/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.ods.dom;

import org.apache.xml.serializer.SerializationHandler;
import org.json.JSONException;
import org.json.JSONObject;
import org.odftoolkit.odfdom.doc.OdfSpreadsheetDocument;
import org.odftoolkit.odfdom.dom.OdfSchemaDocument;
import org.odftoolkit.odfdom.dom.style.OdfStyleFamily;
import org.odftoolkit.odfdom.incubator.doc.style.OdfStyle;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class Condition {

	private String value;
	private String value1;
	private String value2;
	private String date;
	private String styleName;
	private String baseCellAddress;

	final static String namespaceUri = "urn:org:documentfoundation:names:experimental:calc:xmlns:calcext:1.0";

	public Condition() {
	}

	public Condition(Attributes attributes) {

		// condition element
		value = attributes.getValue("calcext:value");
		styleName = attributes.getValue("calcext:apply-style-name");
		baseCellAddress = attributes.getValue("calcext:base-cell-address");

		// date-is element
		date = attributes.getValue("calcext:date");
		if(styleName==null) {
			styleName = attributes.getValue("calcext:style");
		}
	}

	public String getStyleName() {
		return styleName;
	}

	public void setStyleName(String styleName) {
		this.styleName = styleName;
	}

	public void writeObject(SerializationHandler output)
		throws SAXException {

		if(date!=null) {
			output.startElement(namespaceUri, "date-is", "calcext:date-is");
			output.addAttribute("", "date","calcext:date",  null, date);
			if(styleName!=null) {
				output.addAttribute("", "style", "calcext:style", null, styleName);
			}
			output.endElement(namespaceUri, "date-is", "calcext:date-is");
		}
		else {
			output.startElement(namespaceUri, "condition", "calcext:condition");
			if(value!=null) {
				output.addAttribute("", "value","calcext:value",  null, value);
			}
			if(value1!=null) {
				output.addAttribute("", "value1","calcext:value1",  null, value1);
			}
			if(value2!=null) {
				output.addAttribute("", "value2","calcext:value2",  null, value2);
			}
			if(styleName!=null) {
				output.addAttribute("", "apply-style-name", "calcext:apply-style-name", null, styleName);
			}
			if(baseCellAddress!=null) {
				output.addAttribute("", "base-cell-address", "calcext:base-cell-address", null, baseCellAddress);
			}
			output.endElement(namespaceUri, "condition", "calcext:condition");
		}
	}

	void applyCondFormatRuleOperation(OdfSchemaDocument doc, String type, Object value1, String value2, Integer priority, boolean stop, JSONObject attrs)
		throws JSONException, SAXException {

		if(type!=null) {
			value = null;
			date = null;
			// applying the new type 
			switch(type) {
				case "equal": {
					value = "=";
					break;
				}
				case "lessEqual": {
					value = "<=";
					break;
				}
				case "less": {
					value = "<";
					break;
				}
				case "greaterEqual": {
					value = ">=";
					break;
				}
				case "greater": {
					value = ">";
					break;
				}
				case "notEqual": {
					value = "!=";
					break;
				}
				case "between": {
					value = "between";
					break;
				}
				case "notBetween": {
					value = "not-between";
					break;
				}
				case "formula": {
					value = "formula-is";
					break;
				}
				case "today": {
					date = "today";
					break;
				}
				case "yesterday": {
					date = "yesterday";
					break;
				}
				case "tomorrow": {
					date = "tomorrow";
					break;
				}
				case "last7Days": {
					date = "last-7-days";
					break;
				}
				case "thisWeek": {
					date = "this-week";
					break;
				}
				case "lastWeek": {
					date = "last-week";
					break;
				}
			}
		}
		if(value1 instanceof String) {
			if(value!=null) {
				if(value.startsWith("=")) {
					value = "=" + (String)value1;
				}
				else if(value.startsWith("<=")) {
					value = "<=" + (String)value1;
				}
				else if(value.startsWith("<")) {
					value = "<" + (String)value1;
				}
				else if(value.startsWith(">=")) {
					value = ">=" + (String)value1;
				}
				else if(value.startsWith(">")) {
					value = ">" + (String)value1;
				}
				else if(value.startsWith("!=")) {
					value = "!=" + (String)value1;
				}
				else if(value.startsWith("between")) {
					value = "between(" + (String)value1 + "," + (String)value2 + ")";
				}
				else if(value.startsWith("not-between")) {
					value = "not-between(" + (String)value1 + "," + (String)value2 + ")";
				}
				else if(value.startsWith("formula-is")) {
					value = "formula-is(" + (String)value1 + ")";
				}
			}
		}
		if(attrs!=null&&attrs.has("styleId")) {
			// OMG, Odf is storing the display name instead of the styleId 
			// -> we have to correct this, as we are only using the styleId
			String style = attrs.getString("styleId");
			if(style!=null&&!style.isEmpty()) {
				final OdfStyle odfStyle = doc.getStyleByName(OdfStyleFamily.TableCell, style);
				if(odfStyle!=null) {
					final String odfStyleDisplayName = odfStyle.getStyleDisplayNameAttribute();
					if(odfStyleDisplayName!=null&&!odfStyleDisplayName.isEmpty()) {
						style = odfStyleDisplayName;
					}
				}
			}
			setStyleName(style);
		}
	}

	JSONObject createCondFormatRuleOperation(OdfSpreadsheetDocument doc, int sheetIndex, int index, int ruleIndex)
		throws JSONException, SAXException {

		final JSONObject insertCondFormatRuleObject = new JSONObject();
		insertCondFormatRuleObject.put("name", "insertCondFormatRule");
		insertCondFormatRuleObject.put("sheet", sheetIndex);
		insertCondFormatRuleObject.put("index", index);
		insertCondFormatRuleObject.put("ruleIndex", ruleIndex);

		String type = null;
		Object value1 = null;
		Object value2 = null;
		try {
			if(value!=null) {
				if(value.startsWith("=")) {
					type = "equal";
					value1 = value.substring(1);
				}
				else if(value.startsWith("<=")) {
					type = "lessEqual";
					value1 = value.substring(2);
				}
				else if(value.startsWith("<")) {
					type = "less";
					value1 = value.substring(1);
				}
				else if(value.startsWith(">=")) {
					type = "greaterEqual";
					value1 = value.substring(2);
				}
				else if(value.startsWith(">")) {
					type = "greater";
					value1 = value.substring(1);
				}
				else if(value.startsWith("!=")) {
					type = "notEqual";
					value1 = value.substring(1);
				}
				else if(value.startsWith("between")) {
					final String[] vals = getParameters(value.substring(8, value.length()-1));
					if(vals.length==2) {
						value1 = vals[0];
						value2 = vals[1];
					}
					type = "between";
				}
				else if(value.startsWith("not-between")) {
					final String[] vals = getParameters(value.substring(12, value.length()-1));
					if(vals.length==2) {
						value1 = vals[0];
						value2 = vals[1];
					}
					type = "notBetween";
				}
				else if(value.startsWith("formula-is")) {
					type = "formula";
					value1 = value.substring(11, value.length()-1);
				}
			}
			else if(date!=null) {
				if(date.equals("today")) {
					type = "today";
				}
				else if(date.equals("yesterday")) {
					type = "yesterday";
				}
				else if(date.equals("tomorrow")) {
					type = "tomorrow";
				}
				else if(date.equals("last-7-days")) {
					type = "last7Days";
				}
				else if(date.equals("this-week")) {
					type = "thisWeek";
				}
				else if(date.equals("last-week")) {
					type = "lastWeek";
				}
			}
		}
		catch(IndexOutOfBoundsException e) {
			
		}
		if(type!=null) {
			insertCondFormatRuleObject.put("type", type);
		}
		if(value1!=null) {
			insertCondFormatRuleObject.put("value1", value1);
		}
		if(value2!=null) {
			insertCondFormatRuleObject.put("value2", value2);
		}
		String styleName = getStyleName();
		if(styleName!=null) {
			// OMG, Odf is storing the display name instead of the styleId 
			// -> we have to correct this, as we are only using the styleId
			final OdfStyle odfStyle = doc.getStyleByDisplayName(OdfStyleFamily.TableCell, styleName);
			if(odfStyle!=null) {
				final String n = odfStyle.getStyleNameAttribute();
				if(n!=null&&!n.isEmpty()) {
					styleName = n;
				}
			}
			final JSONObject attrs = new JSONObject(1);
			attrs.put("styleId", styleName);
			insertCondFormatRuleObject.put("attrs", attrs);
		}
		return insertCondFormatRuleObject;
	}
	
	private String[] getParameters(String v) {

		int brackets = 0;
		for(int i=0;i<v.length();i++) {
			char c = v.charAt(i);
			if(c==','&&brackets==0) {
				final String[] strings = new String[2];
				if(i>0) {
					strings[0] = v.substring(0, i);
				}
				else {
					strings[0] = "";
				}
				if(i+1<v.length()) {
					strings[1] = v.substring(i+1, v.length());
				}
				else {
					strings[1] = "";
				}
				return strings;
			}
			else if(c=='(') {
				brackets++;
			}
			else if(c==')') {
				brackets--;
			}
		}
		final String[] strings = new String[1];
		strings[0] = v;
		return strings;
	}
}
