/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.office.calcengine.client.impl;

import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.logging.Log;

import com.openexchange.office.calcengine.client.CalcEngineClipBoardEvent;
import com.openexchange.office.calcengine.client.ECalcEngineError;
import com.openexchange.office.calcengine.client.ICalcEngineClient;
import com.openexchange.office.tools.logging.ELogLevel;
import com.openexchange.office.tools.logging.LogFactory;
import com.openxchange.office_communication.jms.core.plain.JMSRuntimeStats;
import com.openxchange.office_communication.tools.common.ExecutionMeasurement;

//=============================================================================
public class CalcEngineClientPerformanceMeasurement2 implements ICalcEngineClient
{
    //-------------------------------------------------------------------------
    private static final Log LOG = LogFactory.getJclLog(CalcEngineClientPerformanceMeasurement2.class);

    //-------------------------------------------------------------------------
    private CalcEngineClientPerformanceMeasurement2 ()
        throws Exception
    {
    	JMSRuntimeStats.setAutoDumpIntervalInMS(10000);
    }
    
    //-------------------------------------------------------------------------
    public synchronized static CalcEngineClientPerformanceMeasurement2 create(final ICalcEngineClient iWrapped)
        throws Exception
    {
    	CalcEngineClientPerformanceMeasurement2 aClient = new CalcEngineClientPerformanceMeasurement2 ();
    	aClient.m_iWrapped = iWrapped;
    	return aClient;
    }

    //-------------------------------------------------------------------------
    @Override
    public void createDocument(final String sHandle)
        throws Exception
    {
//    	final ExecutionMeasurement aMeasure = mem_ExecMeasurement ();
//		aMeasure.startExec();
		m_iWrapped.createDocument(sHandle);
//		aMeasure.startSleep();
    }
    
    //-------------------------------------------------------------------------
    @Override
    public void destroyDocument(final String sHandle)
        throws Exception
    {
//    	final ExecutionMeasurement aMeasure = mem_ExecMeasurement ();
//		aMeasure.startExec();
		m_iWrapped.destroyDocument(sHandle);
//		aMeasure.startSleep();
    }

    //-------------------------------------------------------------------------
    @Override
    public ECalcEngineError executeOperation(final String       sHandle       ,
                                   			 final String       sOperationJSON,
                                   			 final StringBuffer sResultJSON   )
        throws Exception
    {
    	JMSRuntimeStats aStat = new JMSRuntimeStats ();
    	aStat.setStamp4Created();
    	
    	JMSRuntimeStats.countJMSMessageStarted();
//    	final ExecutionMeasurement aMeasure = mem_ExecMeasurement ();
//		aMeasure.startExec();
    	final ECalcEngineError eError = m_iWrapped.executeOperation(sHandle, sOperationJSON, sResultJSON);
//		aMeasure.startSleep();

    	JMSRuntimeStats.countJMSMessageFinished();
    	aStat.setStamp4Closed();
    	JMSRuntimeStats.recordStat(aStat);
    	
    	return eError;
    }
    
    //-------------------------------------------------------------------------
    @Override
    public ECalcEngineError restoreDocument (final String    sHandle             ,
			 				                 final String... lPagedOperationJSONs)
        throws Exception
    {
//    	final ExecutionMeasurement aMeasure = mem_ExecMeasurement ();
//		aMeasure.startExec();
    	final ECalcEngineError eError = m_iWrapped.restoreDocument(sHandle, lPagedOperationJSONs);
//		aMeasure.startSleep();
    	return eError;
    }

    //-------------------------------------------------------------------------
	@Override
	public ECalcEngineError copy(final String                   sSourceDocHandle,
								 final CalcEngineClipBoardEvent aEvent          )
		throws Exception
	{
//    	final ExecutionMeasurement aMeasure = mem_ExecMeasurement ();
//		aMeasure.startExec();
    	final ECalcEngineError eError = m_iWrapped.copy(sSourceDocHandle, aEvent);
//		aMeasure.startSleep();
    	return eError;
	}

    //-------------------------------------------------------------------------
	@Override
	public ECalcEngineError paste(final String                   sTargetDocHandle,
								  final CalcEngineClipBoardEvent aEvent          )
		throws Exception
	{
//    	final ExecutionMeasurement aMeasure = mem_ExecMeasurement ();
//		aMeasure.startExec();
    	final ECalcEngineError eError = m_iWrapped.paste(sTargetDocHandle, aEvent);
//		aMeasure.startSleep();
    	return eError;
	}

    //-------------------------------------------------------------------------
    @Override
    public String getVersion()
    {
        return "Calc Engine Performance Measurement 2.0 :-)";
    }

    //-------------------------------------------------------------------------
    @Override
    public void setLogLevel (final ELogLevel eLevel) 
    	throws Exception
    {
    	m_iWrapped.setLogLevel(eLevel);
    }

    //-------------------------------------------------------------------------
    @Override
    public void dispose ()
    	throws Exception
    {
    	if (m_iWrapped != null)
    		m_iWrapped.dispose ();
    	m_iWrapped = null;
    }

	//-------------------------------------------------------------------------
    private ExecutionMeasurement mem_ExecMeasurement ()
        throws Exception
    {
    	if (m_aExecMeasurement == null)
    	{
    		final ExecutionMeasurement aMeasurement = new ExecutionMeasurement ();
    		aMeasurement.setID                  ("ce-perf-client-jms-"+ObjectUtils.identityToString(this));
    		aMeasurement.setAutoDumpIntervalInMS(1000                                                    );

    		m_aExecMeasurement = aMeasurement;
    	}
		return m_aExecMeasurement;
    }

    //-------------------------------------------------------------------------
    private ICalcEngineClient m_iWrapped = null;

    //-------------------------------------------------------------------------
    private ExecutionMeasurement m_aExecMeasurement = null;
}
