/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.office.calcengine.client;

import org.apache.commons.lang.StringUtils;

//=============================================================================
/** categorize an error which can occur during any operation of ICalcEngineClient.
 *
 *  @note	These errors are errors only which seems to be solvable.
 *  		An runtime error (e.g. exception) which can't be classified
 *  		will be thrown as real exception instead.
 */
public enum ECalcEngineError
{
	//-------------------------------------------------------------------------
	E_NONE,
	E_EXCEPTION,
	E_DOCUMENT_LOST,
	E_TIMEOUT;

	//-------------------------------------------------------------------------
    public static final String STR_ERROR_NONE          = "none";
    public static final String STR_ERROR_EXCEPTION     = "exception";
    public static final String STR_ERROR_DOCUMENT_LOST = "document-lost";
    public static final String STR_ERROR_TIMEOUT       = "timeout";

    //-------------------------------------------------------------------------
    public static ECalcEngineError fromString (final String sError)
        throws Exception
    {
    	if (StringUtils.equalsIgnoreCase(sError, STR_ERROR_NONE))
    		return ECalcEngineError.E_NONE;
    	else
    	if (StringUtils.equalsIgnoreCase(sError, STR_ERROR_EXCEPTION))
    		return ECalcEngineError.E_EXCEPTION;
    	else
    	if (StringUtils.equalsIgnoreCase(sError, STR_ERROR_DOCUMENT_LOST))
    		return ECalcEngineError.E_DOCUMENT_LOST;
    	else
    	if (StringUtils.equalsIgnoreCase(sError, STR_ERROR_TIMEOUT))
    		return ECalcEngineError.E_TIMEOUT;
    	else
    		throw new UnsupportedOperationException ("No support for '"+sError+"' implemented yet.");
    }

    //-------------------------------------------------------------------------
    public static String toString (final ECalcEngineError eError)
        throws Exception
    {
    	if (eError == ECalcEngineError.E_NONE)
    		return STR_ERROR_NONE;
    	else
    	if (eError == ECalcEngineError.E_EXCEPTION)
    		return STR_ERROR_EXCEPTION;
    	else
    	if (eError == ECalcEngineError.E_DOCUMENT_LOST)
    		return STR_ERROR_DOCUMENT_LOST;
    	else
    	if (eError == ECalcEngineError.E_TIMEOUT)
    		return STR_ERROR_TIMEOUT;
    	else
    		throw new UnsupportedOperationException ("No support for '"+eError+"' implemented yet.");
    }
}
