/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.backup.osgi;

import java.util.concurrent.atomic.AtomicBoolean;

import org.apache.commons.logging.Log;

import com.openexchange.file.storage.composition.IDBasedFolderAccessFactory;
import com.openexchange.filemanagement.DistributedFileManagement;
import com.openexchange.filemanagement.ManagedFileManagement;
import com.openexchange.office.backup.distributed.DistributedManagedFileLocker;
import com.openexchange.office.backup.manager.DocumentBackupController;
import com.openexchange.office.backup.manager.impl.DocumentBackupManager;
import com.openexchange.office.hazelcast.doc.DocumentDirectory;
import com.openexchange.office.hazelcast.doc.DocumentResourcesDirectory;
import com.openexchange.osgi.HousekeepingActivator;



/**
 * {@link BackupOfficeActivator}
 *
 * @author <a href="mailto:carsten.driesner@open-xchange.com">Carsten Driesner</a>
 * @since 7.10.0
 */
public class BackupOfficeActivator extends HousekeepingActivator {
    private final Log LOG = com.openexchange.log.Log.loggerFor(BackupOfficeActivator.class);
    private final AtomicBoolean isStopped = new AtomicBoolean(true);

    @Override
    protected Class<?>[] getNeededServices() {
        return new Class<?>[] {
            ManagedFileManagement.class,
            DistributedFileManagement.class,
            DocumentDirectory.class,
            DocumentResourcesDirectory.class,
            IDBasedFolderAccessFactory.class
        };
    }

    @Override
    protected void startBundle() throws Exception {
        Services.setServiceLookup(this);

        LOG.info("Starting bundle: " + getClass().getCanonicalName());

        // Retrieve the needed class to access the hazelcast data
        final DocumentDirectory docStateDir = Services.getServiceLookup().getService(DocumentDirectory.class);
        final DocumentResourcesDirectory docResDir = Services.getServiceLookup().getService(DocumentResourcesDirectory.class);

        // create the one and only distributed backup instance for this node
        DistributedManagedFileLocker.init(this);
        DocumentBackupManager.init(this, docStateDir, docResDir);

        registerService(DocumentBackupController.class, DocumentBackupManager.get());
    }

    @Override
    protected void stopBundle() throws Exception {
        if (isStopped.compareAndSet(false, true)) {
            LOG.info("Stopping bundle: " + getClass().getCanonicalName());
        	DocumentBackupManager.destroy();

            Services.setServiceLookup(null);
            cleanUp();
        }
        super.stopBundle();
    }

    @Override
    protected void handleAvailability(Class<?> clazz) {
        if (allAvailable()) {
            LOG.info("BackupOfficeActivator regained needed service " + clazz.getSimpleName() + ". Going to start bundle.");
            try {
                startBundle();
            } catch (Exception e) {
                LOG.error("Error while starting bundle.", e);
            }
        }
    }

    @Override
    protected void handleUnavailability(Class<?> clazz) {
        LOG.warn("BackupOfficeActivator is handling unavailibility of needed service " + clazz.getSimpleName() + ". Going to stop bundle.");
        try {
            this.stopBundle();
        } catch (Exception e) {
            LOG.error("Error while stopping bundle.", e);
        }
    }

}
