/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
  * © 2016 OX Software GmbH, Germany. info@open-xchange.com
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

(function () {

    'use strict';

    var jslobIds = { 'io.ox/office': { tree: {} } };
    var server = sinon.fakeServer.create();

    server.autoRespond = true;
    server.respondWith('PUT', /jslob/, function (xhr) {

        var ids = JSON.parse(xhr.requestBody),
            fakeSettings = { data: [] };

        ids.forEach(function (id) {
            fakeSettings.data.push({
                id: id,
                meta: {},
                tree: _.has(jslobIds, id) ? jslobIds[id].tree : {}
            });
        });
        xhr.respond(200, { 'Content-Type': 'text/javascript;charset=UTF-8' }, JSON.stringify(fakeSettings));
    });

    sinon.FakeXMLHttpRequest.useFilters = true;
    sinon.FakeXMLHttpRequest.addFilter(function (method, url, async) {
        return async && (url.indexOf('/api/apps/load/' + ox.version + ',') === 0 || (/\/base\/apps\/.*\.json$/).test(url) || (/\.js$/).test(url));
    });

}());
