/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
  * © 2016 OX Software GmbH, Germany. info@open-xchange.com
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define([
    'io.ox/office/tk/utils/dateutils'
], function (DateUtils) {

    'use strict';

    // static class DateUtils =================================================

    describe('Toolkit module DateUtils', function () {

        it('should exist', function () {
            expect(DateUtils).to.be.an('object');
        });

        // static methods -----------------------------------------------------

        describe('method "convertUTCDateToLocalDate"', function () {
            it('should exist', function () {
                expect(DateUtils).itself.to.respondTo('convertUTCDateToLocalDate');
            });
            it('should convert UTC date to local date', function () {
                expect(DateUtils.convertUTCDateToLocalDate('2007-08-31T16:47+00:00')).to.equal('2007-08-31T18:47:00Z');
                expect(DateUtils.convertUTCDateToLocalDate('2007-08-31T16:47+00:00', { useMilliSeconds: true })).to.equal('2007-08-31T18:47:00.000Z');
            });
        });

        describe('method "getIsoDateString"', function () {
            it('should exist', function () {
                expect(DateUtils).itself.to.respondTo('getIsoDateString');
            });
            it('should create an ISO conform date string', function () {
                expect(DateUtils.getIsoDateString()).to.be.a('string');
                expect(DateUtils.getIsoDateString().length).to.equal(24);
                expect(DateUtils.getIsoDateString({ useSeconds: true }).length).to.equal(24);
                expect(DateUtils.getIsoDateString({ useSeconds: false })).to.be.a('string');
                expect(DateUtils.getIsoDateString({ useSeconds: false }).length).to.equal(20);
                expect(DateUtils.getIsoDateString().match(/^\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}\.\d{3}Z$/)[0]).to.be.a('string');
                expect(DateUtils.getIsoDateString({ useSeconds: false }).match(/^\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:00Z$/)[0]).to.be.a('string');
            });
        });

        describe('method "getMSFormatIsoDateString"', function () {
            it('should exist', function () {
                expect(DateUtils).itself.to.respondTo('getMSFormatIsoDateString');
            });
            it('should create an iso conform date string', function () {
                expect(DateUtils.getMSFormatIsoDateString()).to.be.a('string');
                expect(DateUtils.getMSFormatIsoDateString({ useSeconds: false })).to.be.a('string');
            });
        });

        describe('method "getUTCDate"', function () {
            it('should exist', function () {
                expect(DateUtils).itself.to.respondTo('getUTCDate');
            });
            it('should create an UTC conform date string', function () {
                expect(DateUtils.getUTCDate()).to.be.a('date');
                // expect(DateUtils.getUTCDate('1442393575460').toString()).to.be.equal('Wed Sep 16 2015 08:52:55 GMT+0200 (CEST)');
            });
        });

        describe('method "getWeekInMS"', function () {
            it('should exist', function () {
                expect(DateUtils).itself.to.respondTo('getWeekInMS');
            });
            it('should return a week in milliseconds', function () {
                expect(DateUtils.getWeekInMS()).to.be.a('number');
                expect(DateUtils.getWeekInMS()).to.be.equal(604800000);
            });
        });

        describe('method "getWeekDayFormat"', function () {
            it('should exist', function () {
                expect(DateUtils).itself.to.respondTo('getWeekDayFormat');
            });
            it('should create an week-day format', function () {
                expect(DateUtils.getWeekDayFormat()).to.be.a('string');
                expect(DateUtils.getWeekDayFormat()).to.be.equal('dddd');
            });
        });

        describe('method "getLocaleMonths"', function () {
            it('should exist', function () {
                expect(DateUtils).itself.to.respondTo('getLocaleMonths');
            });
            it('should create an array with month-names', function () {
                expect(DateUtils.getLocaleMonths()).to.be.a('array');
                expect(DateUtils.getLocaleMonths()).to.have.length(12);
                // expect(DateUtils.getLocaleMonths()).to.be.deep.equal(['January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December']);
            });
        });

        describe('method "getLocaleMonthsShort"', function () {
            it('should exist', function () {
                expect(DateUtils).itself.to.respondTo('getLocaleMonthsShort');
            });
            it('should create an array with short month-names', function () {
                expect(DateUtils.getLocaleMonthsShort()).to.be.a('array');
                expect(DateUtils.getLocaleMonthsShort()).to.have.length(12);
                // expect(DateUtils.getLocaleMonthsShort()).to.be.deep.equal(['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec']);
            });
        });

        describe('method "getLocaleDays"', function () {
            it('should exist', function () {
                expect(DateUtils).itself.to.respondTo('getLocaleDays');
            });
            it('should create an array with day-names', function () {
                expect(DateUtils.getLocaleDays()).to.be.a('array');
                expect(DateUtils.getLocaleDays()).to.have.length(7);
                // expect(DateUtils.getLocaleDays()).to.be.deep.equal(['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday']);
            });
        });

        describe('method "getLocaleDaysShort"', function () {
            it('should exist', function () {
                expect(DateUtils).itself.to.respondTo('getLocaleDaysShort');
            });
            it('should create an array with short day-names', function () {
                expect(DateUtils.getLocaleDaysShort()).to.be.a('array');
                expect(DateUtils.getLocaleDaysShort()).to.have.length(7);
                // expect(DateUtils.getLocaleDaysShort()).to.be.deep.equal(['Su', 'Mo', 'Tu', 'We', 'Th', 'Fr', 'Sa']);
            });
        });

        describe('method "getLocaleMonth"', function () {
            it('should exist', function () {
                expect(DateUtils).itself.to.respondTo('getLocaleMonth');
            });
            it('should return a string with day-name of given number', function () {
                expect(DateUtils.getLocaleMonth(0)).to.be.a('string');
                // expect(DateUtils.getLocaleMonth(0)).to.be.deep.equal('January');
            });
        });

        describe('method "getLocaleMonthShort"', function () {
            it('should exist', function () {
                expect(DateUtils).itself.to.respondTo('getLocaleMonthShort');
            });
            it('should return a string with short day-name of given number', function () {
                expect(DateUtils.getLocaleMonthShort(0)).to.be.a('string');
                // expect(DateUtils.getLocaleMonthShort(0)).to.be.deep.equal('Jan');
            });
        });

        describe('method "getLocaleDay"', function () {
            it('should exist', function () {
                expect(DateUtils).itself.to.respondTo('getLocaleDay');
            });
            it('should return a string with short day-name of given number', function () {
                expect(DateUtils.getLocaleDay(0)).to.be.a('string');
                // expect(DateUtils.getLocaleDay(0)).to.be.deep.equal('Sunday');
            });
        });

        describe('method "getLocaleDayShort"', function () {
            it('should exist', function () {
                expect(DateUtils).itself.to.respondTo('getLocaleDayShort');
            });
            it('should return string with short day-name of the gicen number', function () {
                expect(DateUtils.getLocaleDayShort(0)).to.be.a('string');
                // expect(DateUtils.getLocaleDayShort(0)).to.be.deep.equal('Su');
            });
        });
    });

    // ========================================================================
});
