/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
  * © 2016 OX Software GmbH, Germany. info@open-xchange.com
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/text/model/modelattributesmixin', [
    'io.ox/office/textframework/format/characterstyles',
    'io.ox/office/text/format/paragraphstyles',
    'io.ox/office/text/format/drawingstyles',
    'io.ox/office/textframework/format/tablestyles',
    'io.ox/office/textframework/format/tablerowstyles',
    'io.ox/office/textframework/format/tablecellstyles',
    'io.ox/office/text/format/pagestyles'
], function (CharacterStyles, ParagraphStyles, DrawingStyles, TableStyles, TableRowStyles, TableCellStyles, PageStyles) {

    'use strict';

    // definitions for global document attributes -----------------------------

    var DOCUMENT_ATTRIBUTE_DEFINITIONS = {

        /**
         * Default tab width in all paragraphs without own tab stop settings,
         * in 1/100 mm.
         */
        defaultTabStop: { def: 1270 }, // 1/2 inch

        /**
         * Current zoom factor.
         */
        zoom: { def: { value: 100 } }, // 100%

        changeTracking: { def: false },

        changeTrackAuthors: { def: [] }
    };

    // definitions for change tracking attributes -----------------------------

    var CHANGES_ATTRIBUTE_DEFINITIONS = {

        inserted: { def: '', scope: 'element' },

        removed: { def: '', scope: 'element' },

        modified: { def: '', scope: 'element' }
    };

    // mix-in class ModelAttributesMixin ======================================

    /**
     * A mix-in class for the document model class TextModel providing the
     * style sheet containers for all attribute families used in a text
     * document.
     *
     * @constructor
     */
    function ModelAttributesMixin() {

        // initialization -----------------------------------------------------

        this.registerAttributeDefinitions('document', DOCUMENT_ATTRIBUTE_DEFINITIONS)
            .registerAttributeDefinitions('changes', CHANGES_ATTRIBUTE_DEFINITIONS);

        this.addStyleCollection(new CharacterStyles(this))
            .addStyleCollection(new ParagraphStyles(this))
            .addStyleCollection(new DrawingStyles(this))
            .addStyleCollection(new TableStyles(this))
            .addStyleCollection(new TableRowStyles(this))
            .addStyleCollection(new TableCellStyles(this))
            .addStyleCollection(new PageStyles(this));

    } // class ModelAttributesMixin

    // exports ================================================================

    return ModelAttributesMixin;

});
