/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
  * © 2016 OX Software GmbH, Germany. info@open-xchange.com
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/spreadsheet/model/formula/impl/webfuncs', function () {

    'use strict';

    /**************************************************************************
     *
     * This module implements all spreadsheet functions dealing with web
     * content.
     *
     * See the README file in this directory for a detailed documentation about
     * the format of function descriptor objects.
     *
     *************************************************************************/

    // exports ================================================================

    return {

        DDE: {
            category: 'web',
            name: { ooxml: null },
            ceName: null,
            hidden: true,
            minParams: 3,
            maxParams: 4,
            type: 'val'
        },

        ENCODEURL: {
            category: 'web',
            name: { ooxml: '_xlfn.ENCODEURL', odf: 'COM.MICROSOFT.ENCODEURL' },
            ceName: null,
            minParams: 1,
            maxParams: 1,
            type: 'val',
            signature: 'val:str'
        },

        FILTERXML: {
            category: 'web',
            name: { ooxml: '_xlfn.FILTERXML', odf: 'COM.MICROSOFT.FILTERXML' },
            ceName: null,
            minParams: 1,
            maxParams: 1,
            type: 'val'
        },

        HYPERLINK: {
            category: 'web',
            minParams: 1,
            maxParams: 2,
            type: 'val',
            signature: 'val:str val:str'
        },

        RTD: {
            category: 'web',
            name: { odf: null },
            ceName: null,
            hidden: true,
            minParams: 3,
            type: 'val'
        },

        WEBSERVICE: {
            category: 'web',
            name: { ooxml: '_xlfn.WEBSERVICE', odf: 'COM.MICROSOFT.WEBSERVICE' },
            ceName: null,
            hidden: true,
            minParams: 1,
            maxParams: 1,
            type: 'val',
            signature: 'val:str'
        }
    };

});
