/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
  * © 2016 OX Software GmbH, Germany. info@open-xchange.com
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define([
    'io.ox/office/spreadsheet/utils/errorcode',
    'io.ox/office/spreadsheet/utils/address',
    'io.ox/office/spreadsheet/utils/interval',
    'io.ox/office/spreadsheet/utils/range',
    'io.ox/office/spreadsheet/utils/range3d',
    'io.ox/office/spreadsheet/utils/addressarray',
    'io.ox/office/spreadsheet/utils/intervalarray',
    'io.ox/office/spreadsheet/utils/rangearray',
    'io.ox/office/spreadsheet/utils/range3darray',
    'io.ox/office/spreadsheet/utils/sheetutils'
], function (ErrorCode, Address, Interval, Range, Range3D, AddressArray, IntervalArray, RangeArray, Range3DArray, SheetUtils) {

    'use strict';

    // static class SheetUtils ================================================

    describe('Spreadsheet module SheetUtils', function () {

        it('should exist', function () {
            expect(SheetUtils).to.be.an('object');
        });

        // helper classes -----------------------------------------------------

        describe('helper class ErrorCode', function () {
            it('should exist', function () {
                expect(SheetUtils).to.have.a.property('ErrorCode', ErrorCode);
            });
        });

        describe('helper class Address', function () {
            it('should exist', function () {
                expect(SheetUtils).to.have.a.property('Address', Address);
            });
        });

        describe('helper class Interval', function () {
            it('should exist', function () {
                expect(SheetUtils).to.have.a.property('Interval', Interval);
            });
        });

        describe('helper class Range', function () {
            it('should exist', function () {
                expect(SheetUtils).to.have.a.property('Range', Range);
            });
        });

        describe('helper class Range3D', function () {
            it('should exist', function () {
                expect(SheetUtils).to.have.a.property('Range3D', Range3D);
            });
        });

        describe('helper class AddressArray', function () {
            it('should exist', function () {
                expect(SheetUtils).to.have.a.property('AddressArray', AddressArray);
            });
        });

        describe('helper class IntervalArray', function () {
            it('should exist', function () {
                expect(SheetUtils).to.have.a.property('IntervalArray', IntervalArray);
            });
        });

        describe('helper class RangeArray', function () {
            it('should exist', function () {
                expect(SheetUtils).to.have.a.property('RangeArray', RangeArray);
            });
        });

        describe('helper class Range3DArray', function () {
            it('should exist', function () {
                expect(SheetUtils).to.have.a.property('Range3DArray', Range3DArray);
            });
        });

        // constants ----------------------------------------------------------

        describe('constant "MAX_NAME_LENGTH"', function () {
            it('should exist', function () {
                expect(SheetUtils.MAX_NAME_LENGTH).to.be.a('number').that.is.above(0);
            });
        });

        describe('constant "MAX_QUERY_CELL_COUNT"', function () {
            it('should exist', function () {
                expect(SheetUtils.MAX_QUERY_CELL_COUNT).to.be.a('number').that.is.above(0);
            });
        });

        describe('constant "MAX_FILL_CELL_COUNT"', function () {
            it('should exist', function () {
                expect(SheetUtils.MAX_FILL_CELL_COUNT).to.be.a('number').that.is.above(0);
            });
        });

        describe('constant "MAX_AUTOFILL_COL_ROW_COUNT"', function () {
            it('should exist', function () {
                expect(SheetUtils.MAX_AUTOFILL_COL_ROW_COUNT).to.be.a('number').that.is.above(0);
            });
        });

        describe('constant "MAX_MERGED_RANGES_COUNT"', function () {
            it('should exist', function () {
                expect(SheetUtils.MAX_MERGED_RANGES_COUNT).to.be.a('number').that.is.above(0);
            });
        });

        describe('constant "MAX_UNMERGE_CELL_COUNT"', function () {
            it('should exist', function () {
                expect(SheetUtils.MAX_UNMERGE_CELL_COUNT).to.be.a('number').that.is.above(0);
            });
        });

        describe('constant "MAX_CHANGE_ROWS_COUNT"', function () {
            it('should exist', function () {
                expect(SheetUtils.MAX_CHANGE_ROWS_COUNT).to.be.a('number').that.is.above(0);
            });
        });

        describe('constant "MAX_SELECTION_CELL_COUNT"', function () {
            it('should exist', function () {
                expect(SheetUtils.MAX_SELECTION_CELL_COUNT).to.be.a('number').that.is.above(0);
            });
        });

        describe('constant "MAX_SEARCH_RESULT_COUNT"', function () {
            it('should exist', function () {
                expect(SheetUtils.MAX_SEARCH_RESULT_COUNT).to.be.a('number').that.is.above(0);
            });
        });

        describe('constant "MAX_LENGTH_STANDARD_CELL"', function () {
            it('should exist', function () {
                expect(SheetUtils.MAX_LENGTH_STANDARD_CELL).to.be.a('number').that.is.above(0);
            });
        });

        describe('constant "MAX_LENGTH_STANDARD_EDIT"', function () {
            it('should exist', function () {
                expect(SheetUtils.MAX_LENGTH_STANDARD_EDIT).to.be.a('number').that.is.above(0);
            });
        });

        describe('constant "MAX_LENGTH_STANDARD_FORMULA"', function () {
            it('should exist', function () {
                expect(SheetUtils.MAX_LENGTH_STANDARD_FORMULA).to.be.a('number').that.is.above(0);
            });
        });

        describe('constant "MIN_CELL_SIZE"', function () {
            it('should exist', function () {
                expect(SheetUtils.MIN_CELL_SIZE).to.be.a('number').that.is.above(0);
            });
        });

        describe('constant "MIN_ZOOM"', function () {
            it('should exist', function () {
                expect(SheetUtils.MIN_ZOOM).to.be.a('number').that.is.above(0).and.below(1);
            });
        });

        describe('constant "MAX_ZOOM"', function () {
            it('should exist', function () {
                expect(SheetUtils.MAX_ZOOM).to.be.a('number').that.is.above(1);
            });
        });

        describe('constant "MULTI_SELECTION"', function () {
            it('should exist', function () {
                expect(SheetUtils.MULTI_SELECTION).to.be.a('boolean');
            });
        });

        // static methods -----------------------------------------------------

        describe('method "getSheetName"', function () {
            it('should exist', function () {
                expect(SheetUtils).itself.to.respondTo('getSheetName');
            });
            it('should return the English sheet name', function () {
                expect(SheetUtils.getSheetName(0)).to.equal('Sheet1');
                expect(SheetUtils.getSheetName(1)).to.equal('Sheet2');
                expect(SheetUtils.getSheetName(9)).to.equal('Sheet10');
            });
        });

        describe('method "getTableColName"', function () {
            it('should exist', function () {
                expect(SheetUtils).itself.to.respondTo('getTableColName');
            });
            it('should return the English column name', function () {
                expect(SheetUtils.getTableColName()).to.equal('Column');
            });
        });
    });

    // ========================================================================
});
