/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
  * © 2016 OX Software GmbH, Germany. info@open-xchange.com
 *
 * @author Michael Nimz <michael.nimz@open-xchange.com>
 */

define([
    'io.ox/office/spreadsheet/utils/errorcode',
    'io.ox/office/spreadsheet/model/formula/formulautils',
    'io.ox/office/spreadsheet/model/formula/impl/operators'
], function (ErrorCode, FormulaUtils, Operators) {

    'use strict';

    // module Operators =======================================================

    describe('Spreadsheet module Operators', function () {

        it('should exist', function () {
            expect(Operators).to.be.an('object');
        });

        // operator implementations -------------------------------------------

        describe('operator "add"', function () {
            var add = Operators.add;
            it('should exist', function () {
                expect(add).to.be.an('object');
            });
            it('should provide correct parameter count', function () {
                expect(add).to.have.a.property('minParams', 1);
                expect(add).to.have.a.property('maxParams', 2);
            });
            it('should provide a resolver function', function () {
                expect(add).to.have.a.property('resolve').that.is.a('function');
            });
        });

        describe('operator "sub"', function () {
            var sub = Operators.sub;
            it('should exist', function () {
                expect(sub).to.be.an('object');
            });
            it('should provide correct parameter count', function () {
                expect(sub).to.have.a.property('minParams', 1);
                expect(sub).to.have.a.property('maxParams', 2);
            });
            it('should provide a resolver function', function () {
                expect(sub).to.have.a.property('resolve').that.is.a('function');
            });
        });

        describe('operator "mul"', function () {
            var mul = Operators.mul;
            it('should exist', function () {
                expect(mul).to.be.an('object');
            });
            it('should provide correct parameter count', function () {
                expect(mul).to.have.a.property('minParams', 2);
                expect(mul).to.have.a.property('maxParams', 2);
            });
            it('should provide a resolver function', function () {
                expect(mul).to.have.a.property('resolve').that.is.a('function');
            });
        });

        describe('operator "div"', function () {
            var div = Operators.div;
            it('should exist', function () {
                expect(div).to.be.an('object');
            });
            it('should provide correct parameter count', function () {
                expect(div).to.have.a.property('minParams', 2);
                expect(div).to.have.a.property('maxParams', 2);
            });
            it('should provide a resolver function', function () {
                expect(div).to.have.a.property('resolve').that.is.a('function');
            });
        });

        describe('operator "pow"', function () {
            var pow = Operators.pow;
            it('should exist', function () {
                expect(pow).to.be.an('object');
            });
            it('should provide correct parameter count', function () {
                expect(pow).to.have.a.property('minParams', 2);
                expect(pow).to.have.a.property('maxParams', 2);
            });
            it('should provide a resolver object', function () {
                expect(pow).to.have.a.property('resolve', FormulaUtils.POWER);
            });
        });

        describe('operator "pct"', function () {
            var pct = Operators.pct;
            it('should exist', function () {
                expect(pct).to.be.an('object');
            });
            it('should provide correct parameter count', function () {
                expect(pct).to.have.a.property('minParams', 1);
                expect(pct).to.have.a.property('maxParams', 1);
            });
            it('should provide a resolver function', function () {
                expect(pct).to.have.a.property('resolve').that.is.a('function');
            });
            it('should return a hundreth of the argument', function () {
                expect(pct.resolve(1)).to.equal(0.01);
                expect(pct.resolve(123)).to.equal(1.23);
                expect(pct.resolve(-1)).to.equal(-0.01);
                expect(pct.resolve(-123)).to.equal(-1.23);
                expect(pct.resolve(0)).to.equal(0);
            });
        });

        describe('operator "con"', function () {
            var con = Operators.con;
            it('should exist', function () {
                expect(con).to.be.an('object');
            });
            it('should provide correct parameter count', function () {
                expect(con).to.have.a.property('minParams', 2);
                expect(con).to.have.a.property('maxParams', 2);
            });
            it('should provide a resolver function', function () {
                expect(con).to.have.a.property('resolve').that.is.a('function');
            });
        });

        describe('operator "lt"', function () {
            var lt = Operators.lt;
            it('should exist', function () {
                expect(lt).to.be.an('object');
            });
            it('should provide correct parameter count', function () {
                expect(lt).to.have.a.property('minParams', 2);
                expect(lt).to.have.a.property('maxParams', 2);
            });
            it('should provide a resolver function', function () {
                expect(lt).to.have.a.property('resolve').that.is.a('function');
            });
        });

        describe('operator "le"', function () {
            var le = Operators.le;
            it('should exist', function () {
                expect(le).to.be.an('object');
            });
            it('should provide correct parameter count', function () {
                expect(le).to.have.a.property('minParams', 2);
                expect(le).to.have.a.property('maxParams', 2);
            });
            it('should provide a resolver function', function () {
                expect(le).to.have.a.property('resolve').that.is.a('function');
            });
        });

        describe('operator "gt"', function () {
            var gt = Operators.gt;
            it('should exist', function () {
                expect(gt).to.be.an('object');
            });
            it('should provide correct parameter count', function () {
                expect(gt).to.have.a.property('minParams', 2);
                expect(gt).to.have.a.property('maxParams', 2);
            });
            it('should provide a resolver function', function () {
                expect(gt).to.have.a.property('resolve').that.is.a('function');
            });
        });

        describe('operator "ge"', function () {
            var ge = Operators.ge;
            it('should exist', function () {
                expect(ge).to.be.an('object');
            });
            it('should provide correct parameter count', function () {
                expect(ge).to.have.a.property('minParams', 2);
                expect(ge).to.have.a.property('maxParams', 2);
            });
            it('should provide a resolver function', function () {
                expect(ge).to.have.a.property('resolve').that.is.a('function');
            });
        });

        describe('operator "eq"', function () {
            var eq = Operators.eq;
            it('should exist', function () {
                expect(eq).to.be.an('object');
            });
            it('should provide correct parameter count', function () {
                expect(eq).to.have.a.property('minParams', 2);
                expect(eq).to.have.a.property('maxParams', 2);
            });
            it('should provide a resolver function', function () {
                expect(eq).to.have.a.property('resolve').that.is.a('function');
            });
        });

        describe('operator "ne"', function () {
            var ne = Operators.ne;
            it('should exist', function () {
                expect(ne).to.be.an('object');
            });
            it('should provide correct parameter count', function () {
                expect(ne).to.have.a.property('minParams', 2);
                expect(ne).to.have.a.property('maxParams', 2);
            });
            it('should provide a resolver function', function () {
                expect(ne).to.have.a.property('resolve').that.is.a('function');
            });
        });

        describe('operator "list"', function () {
            var list = Operators.list;
            it('should exist', function () {
                expect(list).to.be.an('object');
            });
            it('should provide correct parameter count', function () {
                expect(list).to.have.a.property('minParams', 2);
                expect(list).to.have.a.property('maxParams', 2);
            });
            it('should provide a resolver function', function () {
                expect(list).to.have.a.property('resolve').that.is.a('function');
            });
        });

        describe('operator "isect"', function () {
            var isect = Operators.isect;
            it('should exist', function () {
                expect(isect).to.be.an('object');
            });
            it('should provide correct parameter count', function () {
                expect(isect).to.have.a.property('minParams', 2);
                expect(isect).to.have.a.property('maxParams', 2);
            });
            it('should provide a resolver function', function () {
                expect(isect).to.have.a.property('resolve').that.is.a('function');
            });
        });

        describe('operator "range"', function () {
            var range = Operators.range;
            it('should exist', function () {
                expect(range).to.be.an('object');
            });
            it('should provide correct parameter count', function () {
                expect(range).to.have.a.property('minParams', 2);
                expect(range).to.have.a.property('maxParams', 2);
            });
            it('should provide a resolver function', function () {
                expect(range).to.have.a.property('resolve').that.is.a('function');
            });
        });
    });

    // ========================================================================
});
