/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
  * © 2016 OX Software GmbH, Germany. info@open-xchange.com
 *
 * @author Michael Nimz <michael.nimz@open-xchange.com>
 */

define([
    'io.ox/office/spreadsheet/model/formula/formulacontext',
    'io.ox/office/spreadsheet/model/formula/impl/engineeringfuncs'
], function (FormulaContext, EngineeringFuncs) {

    'use strict';

    // initialize the formula context
    var context = null;
    before(function (done) {
        ox.test.spreadsheet.createApp('ooxml').done(function (app) {
            context = new FormulaContext(app.getModel());
            done();
        });
    });

    // module EngineeringFuncs ================================================

    describe('Spreadsheet module EngineeringFuncs', function () {

        it('should exist', function () {
            expect(EngineeringFuncs).to.be.an('object');
        });

        // function implementations -------------------------------------------

        describe('function "DELTA"', function () {
            var DELTA = EngineeringFuncs.DELTA;
            it('should exist', function () {
                expect(DELTA).to.be.an('object');
            });
            it('should be implemented', function () {
                expect(DELTA).itself.to.respondTo('resolve');
            });
            it('should return the error function integrated with positive infinity', function () {
                expect(DELTA.resolve.call(context, 5, 4)).to.equal(0);
                expect(DELTA.resolve.call(context, 5, 5)).to.equal(1);
                expect(DELTA.resolve.call(context, 0.5, 0)).to.equal(0);
            });
        });

        describe('function "ERF"', function () {
            var ERF = EngineeringFuncs.ERF;
            it('should exist', function () {
                expect(ERF).to.be.an('object');
            });
            it('should be implemented', function () {
                expect(ERF).itself.to.respondTo('resolve');
            });
            it('should return the error function integrated', function () {
                expect(ERF.resolve.call(context, 0.745)).to.almostEqual(0.7079288598852725);
                expect(ERF.resolve.call(context, 1)).to.almostEqual(0.84270068874759);
                expect(ERF.resolve.call(context, 0.745, 1)).to.almostEqual(0.13477182886231742);
            });
        });

        describe('function "ERFC"', function () {
            var ERFC = EngineeringFuncs.ERFC;
            it('should exist', function () {
                expect(ERFC).to.be.an('object');
            });
            it('should be implemented', function () {
                expect(ERFC).itself.to.respondTo('resolve');
            });
            it('should return the error function integrated with positive infinity', function () {
                expect(ERFC.resolve.call(context, 0.745)).to.almostEqual(0.29207113911462745);
                expect(ERFC.resolve.call(context, 1)).to.almostEqual(0.15729931025231003);
            });
        });

        describe('function "GESTEP"', function () {
            var GESTEP = EngineeringFuncs.GESTEP;
            it('should exist', function () {
                expect(GESTEP).to.be.an('object');
            });
            it('should be implemented', function () {
                expect(GESTEP).itself.to.respondTo('resolve');
            });
            it('should return the error function integrated with positive infinity', function () {
                expect(GESTEP.resolve.call(context, 5, 4)).to.equal(1);
                expect(GESTEP.resolve.call(context, 5, 5)).to.equal(1);
                expect(GESTEP.resolve.call(context, -4, -5)).to.equal(1);
                expect(GESTEP.resolve.call(context, -1)).to.equal(0);
                expect(GESTEP.resolve.call(context, 1)).to.equal(1);
            });
        });
    });

    // ========================================================================
});
