/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
  * © 2016 OX Software GmbH, Germany. info@open-xchange.com
 *
 * @author Michael Nimz <michael.nimz@open-xchange.com>
 */

define([
    'io.ox/office/drawinglayer/view/drawinglabels'
], function (DrawingLabels) {

    'use strict';

    // static class DrawingLabels =============================================

    describe('DrawingLayer module DrawingLabels', function () {

        it('should exist', function () {
            expect(DrawingLabels).to.be.an('object');
        });

        // private helpers ----------------------------------------------------

        var TYPES = ['chart', 'image', 'shape', 'textframe', 'diagram'];

        // static methods ------------------------------------------------------

        describe('method "getDrawingTypeIcon"', function () {
            it('should exist', function () {
                expect(DrawingLabels).itself.to.respondTo('getDrawingTypeIcon');
            });
            it('should return the icon for the specified type', function () {
                TYPES.forEach(function (type) {
                    expect(DrawingLabels.getDrawingTypeIcon(type)).to.be.a('string');
                });
            });
            it('should return an icon for unknown types', function () {
                expect(DrawingLabels.getDrawingTypeIcon('__something_invalid__')).to.be.a('string');
            });
        });

        describe('method "getDrawingTypeLabel"', function () {
            it('should exist', function () {
                expect(DrawingLabels).itself.to.respondTo('getDrawingTypeLabel');
            });
            it('should return the label for the specified type', function () {
                TYPES.forEach(function (type) {
                    expect(DrawingLabels.getDrawingTypeLabel(type)).to.be.a('string');
                });
            });
            it('should return a label for unknown types', function () {
                expect(DrawingLabels.getDrawingTypeLabel('__something_invalid__')).to.be.a('string');
            });
        });
    });

    // ========================================================================
});
