/* This file has been generated by ox-ui-module generator.
 * Please only apply minor changes (better no changes at all) to this file
 * if you want to be able to run the generator again without much trouble.
 *
 * If you really have to change this file for whatever reason, try to contact
 * the core team and describe your use-case. May be, your changes can be
 * integrated into the templates to be of use for everybody.
 */
'use strict';

module.exports = function (grunt) {

    grunt.config.extend('copy', {
        apps: {
            files: [{
                expand: true,
                src: ['apps/**/*.{js,json}', '!apps/**/manifest.json'],
                filter: 'isFile',
                dest: 'build/'
            }]
        },
        themes: {
            files: [{
                expand: true,
                src: ['**/*.{png,gif,ico,less,css}'],
                cwd: 'apps/',
                dest: 'build/apps/',
                filter: 'isFile'
            }]
        },
        third_party: {
            files: [{
                expand: true,
                src: ['lib/canvasjs.min.js'],
                cwd: 'lib/canvasjs/',
                dest: 'build/apps/io.ox/office/drawinglayer/',
                filter: 'isFile'
            }]
        },
        specs: {
            files: [{
                expand: true,
                src: ['spec/**/*.js', 'spec/fixtures/**/*'],
                filter: 'isFile',
                dest: 'build/'
            }]
        }
    });

    grunt.registerTask('copy_build', [
        'newer:copy:apps',
        'newer:copy:themes',
        'newer:copy:third_party',
        'newer:copy:specs'
    ]);

    grunt.loadNpmTasks('grunt-contrib-copy');
};
