/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
  * © 2016 OX Software GmbH, Germany. info@open-xchange.com
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/spreadsheet/utils/addressarray', [
    'io.ox/office/tk/object/arraytemplate',
    'io.ox/office/spreadsheet/utils/address'
], function (ArrayTemplate, Address) {

    'use strict';

    // class AddressArray =====================================================

    /**
     * Represents an array of cell addresses. The array elements are instances
     * of the class Address.
     *
     * @constructor
     *
     * @extends Array
     */
    var AddressArray = ArrayTemplate.create(Address);

    // public methods ---------------------------------------------------------

    /**
     * Returns a shallow copy of this cell address array that does not contain
     * any duplicate cell addresses.
     *
     * @returns {AddressArray}
     *  A copy of this cell address array without any duplicates.
     */
    AddressArray.prototype.unify = function () {
        var result = new AddressArray(), map = {};
        this.forEach(function (address) {
            var key = address.key();
            if (!map[key]) {
                result.push(address);
                map[key] = true;
            }
        });
        return result;
    };

    // exports ================================================================

    return AddressArray;

});
