/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
  * © 2016 OX Software GmbH, Germany. info@open-xchange.com
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/spreadsheet/model/tablestylecollection', [
    'io.ox/office/editframework/model/stylecollection'
], function (StyleCollection) {

    'use strict';

    // class TableStyleCollection =============================================

    /**
     * Contains the style sheets for all table ranges in a spreadsheet
     * document.
     *
     * @constructor
     *
     * @extends StyleCollection
     *
     * @param {SpreadsheetModel} docModel
     *  The document model containing this instance.
     */
    function TableStyleCollection(docModel) {

        // base constructor ---------------------------------------------------

        StyleCollection.call(this, docModel, 'table', { families: 'character cell' });

    } // class TableStyleCollection

    // exports ================================================================

    // derive this class from class StyleCollection
    return StyleCollection.extend({ constructor: TableStyleCollection });

});
