/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
  * © 2016 OX Software GmbH, Germany. info@open-xchange.com
 *
 * @author Stefan Eckert <stefan.eckert@open-xchange.com>
 */

define('io.ox/office/editframework/view/mobilesearchgroup', [
    'io.ox/office/tk/utils',
    'io.ox/office/tk/forms',
    'io.ox/office/tk/object/triggerobject',
    'io.ox/office/tk/object/timermixin',
    'io.ox/office/baseframework/view/toolpane',
    'io.ox/office/baseframework/view/toolbar',
    'io.ox/office/baseframework/view/basecontrols',
    'io.ox/office/editframework/view/editlabels'
], function (Utils, Forms, TriggerObject, TimerMixin, ToolPane, ToolBar, Controls, Labels) {

    'use strict';

    function MobileSearchGroup(docView) {

        var searchBar = docView.createToolBar('view/searchgroup');
        var searchReplaceBar = docView.createToolBar('view/replacegroup');
        var replacePane = new ToolPane(docView, { position: 'top', classes: 'small-distance standard-design' });
        var replaceBar = new ToolBar(docView);
        var replaceSplit = null;

        var searchBtn = null;
        var searchReplaceBtn = null;

        // base constructor ---------------------------------------------------

        TriggerObject.call(this);
        TimerMixin.call(this);

        // private methods ---------------------------------------------------

        function addSearch(bar) {
            bar.addGroup('document/search/text',  new Controls.TextField(Labels.SEARCH_TEXT).setWidth(Labels.SEARCH_TEXT.smallerVersion.css.width));
            bar.addGroup('document/search/start', new Controls.Button(Labels.SEARCH_START));
            bar.addGroup('document/search/prev',  new Controls.Button(Labels.SEARCH_PREV));
            bar.addGroup('document/search/next',  new Controls.Button(Labels.SEARCH_NEXT));
        }

        function showSearch() {
            searchBtn.show();
            searchReplaceBtn.hide();
        }

        function showSearchReplace() {
            searchBtn.hide();
            searchReplaceBtn.show();
        }

        var delayClose = this.createDebouncedMethod(Utils.NOOP, function () {
            if (!searchBar.isVisible() && !searchReplaceBar.isVisible()) {
                docView.executeSearchOperation('search:end', { query: '', replace: '' });
                showSearch();
            }
        });

        // public methods ---------------------------------------------------

        this.handleTabListButtons = function () {

            docView.createToolBarTab('view/searchgroup', Labels.TAB_SEARCH);
            docView.createToolBarTab('view/replacegroup', Labels.TAB_SEARCH_REPLACE);

            var flatTabView = docView.getToolPane().getFlatTabView();
            var tabViewNode = flatTabView.getMenu().getNode();
            searchBtn = tabViewNode.find('[data-value="view/searchgroup"]').parent();
            searchReplaceBtn = tabViewNode.find('[data-value="view/replacegroup"]').parent();

            $('<div class="separator-line">').insertBefore(searchBtn);

            showSearch();

            tabViewNode.find('[data-key="view/searchpane"]').hide();
        };

        //toggle should be never called
        this.toggle = Utils.NOOP;

        this.hide = function () {
            searchBar.hide();
            searchReplaceBar.hide();
        };

        this.isVisible = function () {
            return searchBar.isVisible() || searchReplaceBar.isVisible();
        };

        // init ---------------------------------------------------------------

        addSearch(searchBar);
        addSearch(searchReplaceBar);

        replaceBar.addGroup('dummy', new Controls.Button({ icon: 'fa' }));
        replaceBar.addGap();
        replaceBar.addGroup('document/replace/text', new Controls.TextField(Labels.REPLACE_TEXT).setWidth(Labels.REPLACE_TEXT.smallerVersion.css.width));

        replaceSplit = new Controls.CompoundSplitButton(docView, Labels.REPLACE_NEXT);
        replaceSplit.addGroup('document/replace/next', new Controls.Button(Labels.REPLACE_NEXT));
        replaceSplit.addGroup('document/replace/all',  new Controls.Button(Labels.REPLACE_ALL));
        replaceBar.addGroup('document/replace/next', replaceSplit);

        replacePane.addViewComponent(replaceBar);
        replacePane.hide();
        docView.addPane(replacePane);

        // listeners ---------------------------------------------------------------

        searchBar.on('component:show', function () {
            replacePane.hide();
            showSearchReplace();
        });

        searchBar.on('component:hide', function () {
            replacePane.hide();
            delayClose();
        });

        searchReplaceBar.on('component:show', function () {
            replacePane.show();
            showSearch();
        });

        searchReplaceBar.on('component:hide', function () {
            replacePane.hide();
            delayClose();
        });

        // destroy all class members on destruction
        this.registerDestructor(function () {
            searchBar.destroy();
            searchReplaceBar.destroy();
            docView = searchBar = searchReplaceBar = null;
            replacePane = replaceBar = replaceSplit = null;
            searchBtn = searchReplaceBtn = null;
        });
    }

    // exports ================================================================
    return TriggerObject.extend({ constructor: MobileSearchGroup });

});
