/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
  * © 2016 OX Software GmbH, Germany. info@open-xchange.com
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/editframework/view/editdialogs', [
    'io.ox/office/tk/dialogs',
    'io.ox/office/editframework/view/dialog/hyperlinkdialog',
    'io.ox/office/editframework/view/dialog/saveasfiledialog',
    'io.ox/office/editframework/view/dialog/saveastemplatedialog'
], function (Dialogs, HyperlinkDialog, SaveAsFileDialog, SaveAsTemplateDialog) {

    'use strict';

    // static class EditDialogs ===============================================

    /**
     * Collects all standard dialog classes defined in the toolkit, and adds
     * more dialog classes a single map for convenience.
     *
     * @extends Dialogs
     */
    var EditDialogs = _.extend({}, Dialogs, {
        HyperlinkDialog: HyperlinkDialog,
        SaveAsFileDialog: SaveAsFileDialog,
        SaveAsTemplateDialog: SaveAsTemplateDialog
    });

    // exports ================================================================

    return EditDialogs;

});
