/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.documentconverter;


//-------------
//- JobStatus -
//-------------

/**
 * {@link JobError}
 *
 * @author <a href="mailto:kai.ahrens@open-xchange.com">Kai Ahrens</a>
 */
public enum JobError {
    NONE			(JobError.ERRORCODE_NONE),
    GENERAL			(JobError.ERRORCODE_GENERAL),
    TIMEOUT			(JobError.ERRORCODE_TIMEOUT),
    PASSWORD		(JobError.ERRORCODE_PASSWORD),
    NO_CONTENT		(JobError.ERRORCODE_NO_CONTENT),
    MAX_SOURCESIZE	(JobError.ERRORCODE_MAX_SOURCESIZE);

    /**
     * @param errorCode
     */
    private JobError(int errorCode) {
        m_errorCode = errorCode;
    }

    /**
     * @return The error code id of the enum
     */
    public int errorCode() {
        return m_errorCode;
    }

    /**
     * @param errorCode
     * @return The enum, given the error code id
     */
    public static JobError fromErrorCode(int errorCode) {
        JobError ret = NONE;

        switch (errorCode) {
        case ERRORCODE_NONE: 			ret = NONE; break;
        case ERRORCODE_GENERAL: 		ret = GENERAL; break;
        case ERRORCODE_TIMEOUT: 		ret = TIMEOUT; break;
        case ERRORCODE_PASSWORD: 		ret = PASSWORD; break;
        case ERRORCODE_NO_CONTENT: 		ret = NO_CONTENT; break;
        case ERRORCODE_MAX_SOURCESIZE: 	ret = MAX_SOURCESIZE; break;

        default: 						ret = GENERAL; break;
        }

        return ret;
    }

    // - Members ---------------------------------------------------------------

    protected int m_errorCode = ERRORCODE_NONE;

    // - Constants -------------------------------------------------------------

    // the error codes to be mapped to enums and vice versa
    final protected static int ERRORCODE_NONE 			= 0x00000000;
    final protected static int ERRORCODE_GENERAL 		= 0x00000001;
    final protected static int ERRORCODE_TIMEOUT 		= 0x00000002;
    final protected static int ERRORCODE_PASSWORD 		= 0x00000004;
    final protected static int ERRORCODE_NO_CONTENT 	= 0x00000008;
    final protected static int ERRORCODE_MAX_SOURCESIZE = 0x00000010;
}
