/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.documentconverter;

import com.sun.star.frame.XDesktop;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.XComponentContext;

//-------------
//- IInstance -
//-------------

/**
 * {@link IInstance}
 *
 * @author <a href="mailto:kai.ahrens@open-xchange.com">Kai Ahrens</a>
 */
public interface IInstance {

    /**
     * sychronous launch of an IInstance with the given parameters;
     *
     * @param backendtype
     * @param aInstallDir
     * @param aUserBaseDir
     * @param maxVMemMB
     * @param locale
     * @return true in case the IInstance was successfully launched
     */
    public boolean launch(BackendType backendtype, String installDir, String userBaseDir, long maxVMemMB, String blacklistFile, String whitelistFile, int urlLinkLimit, String urlLinkProxy);

    /**
     * synchronous shutdown of a launched IInstance
     */
    public void shutdown();

    //
    /**
     * killing of a launched IInstance
     */
    public void kill();

    /**
     * @return  true if the istance was launched successfully at
     *          least once, indicating that the installation
     *          is valid in general
     */
    public boolean isValid();

    /**
     * @return  true if the instance was launched successfully
                and is currently connected to the underlying engine;
                this method might return false in case a call to launch
                was successful but a connection is not yet available
     */
    public boolean isConnected();

    /**
     * @return the ODK {@link XMultiServiceFactory} interface of the Instance
     */
    public XMultiComponentFactory getComponentFactory();

    /**
     * @return the ODK {@link XComponentContext} interface of the Instance
     */
    public XComponentContext getDefaultContext();

    /**
     * @return the ODK {@link XFilterFactory} interface of the Instance
     */
    public XMultiServiceFactory getFilterFactory();

    /**
     * @return the ODK {@link XDesktop} interface of the Instance
     */
    public XDesktop getDesktop();
}
