/*
 * Decompiled with CFR 0.152.
 */
package com.eclipsesource.jaxrs.publisher.internal;

import com.eclipsesource.jaxrs.publisher.ApplicationConfiguration;
import com.eclipsesource.jaxrs.publisher.ServletConfiguration;
import com.eclipsesource.jaxrs.publisher.internal.Configuration;
import com.eclipsesource.jaxrs.publisher.internal.DefaultApplicationConfiguration;
import com.eclipsesource.jaxrs.publisher.internal.ResourcePublisher;
import com.eclipsesource.jaxrs.publisher.internal.RootApplication;
import com.eclipsesource.jaxrs.publisher.internal.ServiceContainer;
import com.eclipsesource.jaxrs.publisher.internal.ServletContainerBridge;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.List;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.ws.rs.core.Application;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;

public class JerseyContext {
    private final RootApplication application;
    private final HttpService httpService;
    private final ServletContainerBridge servletContainerBridge;
    private final Configuration configuration;
    private final ServletConfiguration servletConfiguration;
    private final ResourcePublisher resourcePublisher;
    private boolean isApplicationRegistered;

    public JerseyContext(HttpService httpService, Configuration configuration, ServletConfiguration servletConfiguration, ServiceContainer applicationConfigurations) {
        this.httpService = httpService;
        this.configuration = configuration;
        this.application = new RootApplication();
        this.applyApplicationConfigurations(applicationConfigurations);
        this.servletContainerBridge = new ServletContainerBridge(this.application);
        this.servletConfiguration = servletConfiguration;
        this.resourcePublisher = new ResourcePublisher(this.servletContainerBridge, configuration.getPublishDelay());
    }

    private void applyApplicationConfigurations(ServiceContainer applicationConfigurations) {
        ServiceContainer.ServiceHolder[] services;
        this.application.addProperties(new DefaultApplicationConfiguration(this.configuration).getProperties());
        ServiceContainer.ServiceHolder[] serviceHolderArray = services = applicationConfigurations.getServices();
        int n = services.length;
        int n2 = 0;
        while (n2 < n) {
            Map<String, Object> properties;
            ServiceContainer.ServiceHolder serviceHolder = serviceHolderArray[n2];
            Object service = serviceHolder.getService();
            if (service instanceof ApplicationConfiguration && (properties = ((ApplicationConfiguration)service).getProperties()) != null) {
                this.application.addProperties(properties);
            }
            ++n2;
        }
    }

    public void addResource(Object resource) {
        this.getRootApplication().addResource(resource);
        this.registerServletWhenNotAlreadyRegistered();
        this.resourcePublisher.schedulePublishing();
    }

    void registerServletWhenNotAlreadyRegistered() {
        if (!this.isApplicationRegistered) {
            this.isApplicationRegistered = true;
            this.registerApplication();
        }
    }

    private void registerApplication() {
        ClassLoader loader = this.getContextClassloader();
        this.setContextClassloader();
        try {
            try {
                this.registerServlet();
            }
            catch (ServletException shouldNotHappen) {
                throw new IllegalStateException(shouldNotHappen);
            }
            catch (NamespaceException shouldNotHappen) {
                throw new IllegalStateException(shouldNotHappen);
            }
        }
        finally {
            this.resetContextClassloader(loader);
        }
    }

    private ClassLoader getContextClassloader() {
        return Thread.currentThread().getContextClassLoader();
    }

    private void setContextClassloader() {
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
    }

    private void registerServlet() throws ServletException, NamespaceException {
        ClassLoader original = this.getContextClassloader();
        try {
            Thread.currentThread().setContextClassLoader(Application.class.getClassLoader());
            this.httpService.registerServlet(this.configuration.getRoothPath(), (Servlet)this.servletContainerBridge.getServletContainer(), this.getInitParams(), this.getHttpContext());
        }
        finally {
            this.resetContextClassloader(original);
        }
    }

    private Dictionary getInitParams() {
        if (this.servletConfiguration != null) {
            return this.servletConfiguration.getInitParams(this.httpService, this.configuration.getRoothPath());
        }
        return null;
    }

    private HttpContext getHttpContext() {
        if (this.servletConfiguration != null) {
            return this.servletConfiguration.getHttpContext(this.httpService, this.configuration.getRoothPath());
        }
        return null;
    }

    private void resetContextClassloader(ClassLoader loader) {
        Thread.currentThread().setContextClassLoader(loader);
    }

    public void removeResource(Object resource) {
        this.getRootApplication().removeResource(resource);
        this.unregisterServletWhenNoresourcePresents();
        this.resourcePublisher.schedulePublishing();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterServletWhenNoresourcePresents() {
        if (!this.getRootApplication().hasResources() && this.isApplicationRegistered) {
            ServletContainerBridge servletContainerBridge = this.servletContainerBridge;
            synchronized (servletContainerBridge) {
                this.httpService.unregister(this.configuration.getRoothPath());
                this.servletContainerBridge.reset();
                this.resourcePublisher.cancelPublishing();
                this.isApplicationRegistered = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Object> eliminate() {
        if (this.isApplicationRegistered) {
            ServletContainerBridge servletContainerBridge = this.servletContainerBridge;
            synchronized (servletContainerBridge) {
                try {
                    this.httpService.unregister(this.configuration.getRoothPath());
                }
                catch (Exception exception) {}
            }
            this.resourcePublisher.cancelPublishing();
        }
        return new ArrayList<Object>(this.getRootApplication().getResources());
    }

    RootApplication getRootApplication() {
        return this.application;
    }
}

