/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.client.authn.oauth;

import com.google.gdata.client.authn.oauth.OAuthException;
import com.google.gdata.client.authn.oauth.OAuthHelper;
import com.google.gdata.client.authn.oauth.OAuthHmacSha1Signer;
import com.google.gdata.client.authn.oauth.OAuthParameters;
import com.google.gdata.client.authn.oauth.OAuthSigner;
import com.google.gdata.client.authn.oauth.OAuthUtil;
import java.util.Map;

public class TwoLeggedOAuthHelper {
    private final OAuthSigner signer;
    private final OAuthParameters parameters;

    public TwoLeggedOAuthHelper(OAuthSigner signer, OAuthParameters parameters) {
        this.signer = signer;
        this.parameters = parameters;
    }

    void validateInputParameters() throws OAuthException {
        this.parameters.assertOAuthConsumerKeyExists();
        if (this.signer instanceof OAuthHmacSha1Signer) {
            this.parameters.assertOAuthConsumerSecretExists();
        }
    }

    void addCommonRequestParameters(String baseUrl, String httpMethod) throws OAuthException {
        if (this.parameters.getOAuthSignatureMethod().length() == 0) {
            this.parameters.setOAuthSignatureMethod(this.signer.getSignatureMethod());
        }
        if (this.parameters.getOAuthTimestamp().length() == 0) {
            this.parameters.setOAuthTimestamp(OAuthUtil.getTimestamp());
        }
        if (this.parameters.getOAuthNonce().length() == 0) {
            this.parameters.setOAuthNonce(OAuthUtil.getNonce());
        }
        if (this.parameters.getOAuthSignature().length() == 0) {
            String baseString = OAuthUtil.getSignatureBaseString(baseUrl, httpMethod, this.parameters.getBaseParameters());
            this.parameters.setOAuthSignature(this.signer.getSignature(baseString, this.parameters));
        }
    }

    public String getAuthorizationHeader(String requestUrl, String httpMethod) throws OAuthException {
        this.validateInputParameters();
        return this.addParametersAndRetrieveHeader(requestUrl, httpMethod);
    }

    String addParametersAndRetrieveHeader(String requestUrl, String httpMethod) throws OAuthException {
        this.addCommonRequestParameters(requestUrl, httpMethod);
        OAuthHelper.HeaderKeyValuePair headerParams = new OAuthHelper.HeaderKeyValuePair();
        headerParams.add("realm", this.parameters.getRealm());
        headerParams.add("oauth_signature", this.parameters.getOAuthSignature());
        for (Map.Entry<String, String> e : this.parameters.getBaseParameters().entrySet()) {
            if (e.getValue().length() <= 0) continue;
            headerParams.add(e.getKey(), e.getValue());
        }
        this.parameters.reset();
        return "OAuth" + " " + headerParams.toString();
    }
}

