/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.transfer.internal;

import com.amazonaws.AmazonClientException;
import com.amazonaws.event.ProgressEventType;
import com.amazonaws.event.ProgressListenerChain;
import com.amazonaws.event.SDKProgressPublisher;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.PartETag;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.transfer.PauseResult;
import com.amazonaws.services.s3.transfer.PauseStatus;
import com.amazonaws.services.s3.transfer.PersistableUpload;
import com.amazonaws.services.s3.transfer.Transfer;
import com.amazonaws.services.s3.transfer.TransferManager;
import com.amazonaws.services.s3.transfer.internal.CompleteMultipartUpload;
import com.amazonaws.services.s3.transfer.internal.TransferManagerUtils;
import com.amazonaws.services.s3.transfer.internal.TransferMonitor;
import com.amazonaws.services.s3.transfer.internal.UploadCallable;
import com.amazonaws.services.s3.transfer.internal.UploadImpl;
import com.amazonaws.services.s3.transfer.model.UploadResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

public class UploadMonitor
implements Callable<UploadResult>,
TransferMonitor {
    private final AmazonS3 s3;
    private final PutObjectRequest origReq;
    private final ProgressListenerChain listener;
    private final UploadCallable multipartUploadCallable;
    private final UploadImpl transfer;
    private final ExecutorService threadPool;
    private final List<Future<PartETag>> futures = Collections.synchronizedList(new ArrayList());
    private boolean isUploadDone = false;
    private Future<UploadResult> future;

    public synchronized Future<UploadResult> getFuture() {
        return this.future;
    }

    private synchronized void setFuture(Future<UploadResult> future) {
        this.future = future;
    }

    private synchronized void cancelFuture() {
        this.future.cancel(true);
    }

    @Override
    public synchronized boolean isDone() {
        return this.isUploadDone;
    }

    private synchronized void markAllDone() {
        this.isUploadDone = true;
    }

    public static UploadMonitor create(TransferManager manager, UploadImpl transfer, ExecutorService threadPool, UploadCallable multipartUploadCallable, PutObjectRequest putObjectRequest, ProgressListenerChain progressListenerChain) {
        UploadMonitor uploadMonitor = new UploadMonitor(manager, transfer, threadPool, multipartUploadCallable, putObjectRequest, progressListenerChain);
        uploadMonitor.setFuture(threadPool.submit(uploadMonitor));
        return uploadMonitor;
    }

    private UploadMonitor(TransferManager manager, UploadImpl transfer, ExecutorService threadPool, UploadCallable multipartUploadCallable, PutObjectRequest putObjectRequest, ProgressListenerChain progressListenerChain) {
        this.s3 = manager.getAmazonS3Client();
        this.multipartUploadCallable = multipartUploadCallable;
        this.origReq = putObjectRequest;
        this.listener = progressListenerChain;
        this.transfer = transfer;
        this.threadPool = threadPool;
    }

    @Override
    public UploadResult call() throws Exception {
        try {
            UploadResult result = this.multipartUploadCallable.call();
            if (result == null) {
                this.futures.addAll(this.multipartUploadCallable.getFutures());
                this.setFuture(this.threadPool.submit(new CompleteMultipartUpload(this.multipartUploadCallable.getMultipartUploadId(), this.s3, this.origReq, this.futures, this.multipartUploadCallable.getETags(), this)));
            } else {
                this.uploadComplete();
            }
            return result;
        }
        catch (CancellationException e) {
            this.transfer.setState(Transfer.TransferState.Canceled);
            SDKProgressPublisher.publishProgress(this.listener, ProgressEventType.TRANSFER_CANCELED_EVENT);
            throw new AmazonClientException("Upload canceled");
        }
        catch (Exception e) {
            this.transfer.setState(Transfer.TransferState.Failed);
            SDKProgressPublisher.publishProgress(this.listener, ProgressEventType.TRANSFER_FAILED_EVENT);
            throw e;
        }
    }

    void uploadComplete() {
        this.markAllDone();
        this.transfer.setState(Transfer.TransferState.Completed);
        if (this.multipartUploadCallable.isMultipartUpload()) {
            SDKProgressPublisher.publishProgress(this.listener, ProgressEventType.TRANSFER_COMPLETED_EVENT);
        }
    }

    PauseResult<PersistableUpload> pause(boolean forceCancel) {
        PersistableUpload persistableUpload = this.multipartUploadCallable.getPersistableUpload();
        if (persistableUpload == null) {
            PauseStatus pauseStatus = TransferManagerUtils.determinePauseStatus(this.transfer.getState(), forceCancel);
            if (forceCancel) {
                this.cancelFutures();
                this.multipartUploadCallable.performAbortMultipartUpload();
            }
            return new PauseResult<PersistableUpload>(pauseStatus);
        }
        this.cancelFutures();
        return new PauseResult<PersistableUpload>(PauseStatus.SUCCESS, persistableUpload);
    }

    private void cancelFutures() {
        this.cancelFuture();
        for (Future<PartETag> f : this.futures) {
            f.cancel(true);
        }
        this.multipartUploadCallable.getFutures().clear();
        this.futures.clear();
    }

    void performAbort() {
        this.cancelFutures();
        this.multipartUploadCallable.performAbortMultipartUpload();
    }
}

