/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier.model;

import com.amazonaws.AmazonWebServiceRequest;
import java.io.InputStream;
import java.io.Serializable;

public class UploadArchiveRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private Long contentLength;
    private String vaultName;
    private String accountId;
    private String archiveDescription;
    private String checksum;
    private InputStream body;

    public UploadArchiveRequest() {
    }

    public UploadArchiveRequest(String vaultName, String archiveDescription, String checksum, InputStream body) {
        this.setVaultName(vaultName);
        this.setArchiveDescription(archiveDescription);
        this.setChecksum(checksum);
        this.setBody(body);
    }

    public UploadArchiveRequest(String vaultName, String accountId, String archiveDescription, String checksum, InputStream body) {
        this.setVaultName(vaultName);
        this.setAccountId(accountId);
        this.setArchiveDescription(archiveDescription);
        this.setChecksum(checksum);
        this.setBody(body);
    }

    public Long getContentLength() {
        return this.contentLength;
    }

    public void setContentLength(Long contentLength) {
        this.contentLength = contentLength;
    }

    public UploadArchiveRequest withContentLength(Long contentLength) {
        this.contentLength = contentLength;
        return this;
    }

    public String getVaultName() {
        return this.vaultName;
    }

    public void setVaultName(String vaultName) {
        this.vaultName = vaultName;
    }

    public UploadArchiveRequest withVaultName(String vaultName) {
        this.vaultName = vaultName;
        return this;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public UploadArchiveRequest withAccountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    public String getArchiveDescription() {
        return this.archiveDescription;
    }

    public void setArchiveDescription(String archiveDescription) {
        this.archiveDescription = archiveDescription;
    }

    public UploadArchiveRequest withArchiveDescription(String archiveDescription) {
        this.archiveDescription = archiveDescription;
        return this;
    }

    public String getChecksum() {
        return this.checksum;
    }

    public void setChecksum(String checksum) {
        this.checksum = checksum;
    }

    public UploadArchiveRequest withChecksum(String checksum) {
        this.checksum = checksum;
        return this;
    }

    public InputStream getBody() {
        return this.body;
    }

    public void setBody(InputStream body) {
        this.body = body;
    }

    public UploadArchiveRequest withBody(InputStream body) {
        this.body = body;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getContentLength() != null) {
            sb.append("ContentLength: " + this.getContentLength() + ",");
        }
        if (this.getVaultName() != null) {
            sb.append("VaultName: " + this.getVaultName() + ",");
        }
        if (this.getAccountId() != null) {
            sb.append("AccountId: " + this.getAccountId() + ",");
        }
        if (this.getArchiveDescription() != null) {
            sb.append("ArchiveDescription: " + this.getArchiveDescription() + ",");
        }
        if (this.getChecksum() != null) {
            sb.append("Checksum: " + this.getChecksum() + ",");
        }
        if (this.getBody() != null) {
            sb.append("Body: " + this.getBody());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getContentLength() == null ? 0 : this.getContentLength().hashCode());
        hashCode = 31 * hashCode + (this.getVaultName() == null ? 0 : this.getVaultName().hashCode());
        hashCode = 31 * hashCode + (this.getAccountId() == null ? 0 : this.getAccountId().hashCode());
        hashCode = 31 * hashCode + (this.getArchiveDescription() == null ? 0 : this.getArchiveDescription().hashCode());
        hashCode = 31 * hashCode + (this.getChecksum() == null ? 0 : this.getChecksum().hashCode());
        hashCode = 31 * hashCode + (this.getBody() == null ? 0 : this.getBody().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UploadArchiveRequest)) {
            return false;
        }
        UploadArchiveRequest other = (UploadArchiveRequest)obj;
        if (other.getContentLength() == null ^ this.getContentLength() == null) {
            return false;
        }
        if (other.getContentLength() != null && !other.getContentLength().equals(this.getContentLength())) {
            return false;
        }
        if (other.getVaultName() == null ^ this.getVaultName() == null) {
            return false;
        }
        if (other.getVaultName() != null && !other.getVaultName().equals(this.getVaultName())) {
            return false;
        }
        if (other.getAccountId() == null ^ this.getAccountId() == null) {
            return false;
        }
        if (other.getAccountId() != null && !other.getAccountId().equals(this.getAccountId())) {
            return false;
        }
        if (other.getArchiveDescription() == null ^ this.getArchiveDescription() == null) {
            return false;
        }
        if (other.getArchiveDescription() != null && !other.getArchiveDescription().equals(this.getArchiveDescription())) {
            return false;
        }
        if (other.getChecksum() == null ^ this.getChecksum() == null) {
            return false;
        }
        if (other.getChecksum() != null && !other.getChecksum().equals(this.getChecksum())) {
            return false;
        }
        if (other.getBody() == null ^ this.getBody() == null) {
            return false;
        }
        return other.getBody() == null || other.getBody().equals(this.getBody());
    }

    @Override
    public UploadArchiveRequest clone() {
        return (UploadArchiveRequest)super.clone();
    }
}

