(function(f){if(typeof exports==="object"&&typeof module!=="undefined"){module.exports=f()}else if(typeof define==="function"&&define.amd){define([],f)}else{var g;if(typeof window!=="undefined"){g=window}else if(typeof global!=="undefined"){g=global}else if(typeof self!=="undefined"){g=self}else{g=this}g.JscsStringChecker = f()}})(function(){var define,module,exports;return (function e(t,n,r){function s(o,u){if(!n[o]){if(!t[o]){var a=typeof require=="function"&&require;if(!u&&a)return a(o,!0);if(i)return i(o,!0);var f=new Error("Cannot find module '"+o+"'");throw f.code="MODULE_NOT_FOUND",f}var l=n[o]={exports:{}};t[o][0].call(l.exports,function(e){var n=t[o][1][e];return s(n?n:e)},l,l.exports,e,t,n,r)}return n[o].exports}var i=typeof require=="function"&&require;for(var o=0;o<r.length;o++)s(r[o]);return s})({1:[function(require,module,exports){
var assert = require('assert');
var path = require('path');

var minimatch = require('minimatch');
var defaults = {
    cwd: '.',
    maxErrors: 50
};

var _ = require('lodash');

var BUILTIN_OPTIONS = {
    plugins: true,
    preset: true,
    excludeFiles: true,
    additionalRules: true,
    fileExtensions: true,
    extract: true,
    maxErrors: true,
    configPath: true,
    esnext: true,
    es3: true,
    esprima: true,
    esprimaOptions: true,
    errorFilter: true,
    verbose: true,
    fix: true
};

/**
 * JSCS Configuration.
 * Browser/Rhino-compatible.
 *
 * @name Configuration
 */
function Configuration() {
    /**
     * List of the registered (not used) presets.
     *
     * @protected
     * @type {Object}
     */
    this._presets = {};

    /**
     * Name of the preset (if used).
     *
     * @protected
     * @type {String|null}
     */
    this._presetName = null;

    /**
     * List of loaded presets.
     *
     * @protected
     * @type {String|null}
     */
    this._loadedPresets = [];

    /**
     * List of rules instances.
     *
     * @protected
     * @type {Object}
     */
    this._rules = {};

    /**
     * List of configurated rule instances.
     *
     * @protected
     * @type {Object}
     */
    this._ruleSettings = {};

    /**
     * List of configured rules.
     *
     * @protected
     * @type {Array}
     */
    this._configuredRules = [];

    /**
     * List of unsupported rules.
     *
     * @protected
     * @type {Array}
     */
    this._unsupportedRuleNames = [];

    /**
     * File extensions that would be checked.
     *
     * @protected
     * @type {Array}
     */
    this._fileExtensions = [];

    /**
     * Default file extensions that would be checked.
     *
     * @protected
     * @type {Array}
     */
    this._defaultFileExtensions = ['.js'];

    /**
     * Exclusion masks.
     *
     * @protected
     * @type {Array}
     */
    this._excludedFileMasks = [];

    /**
     * Default exclusion masks, will be rewritten if user has their own masks.
     *
     * @protected
     * @type {Array}
     */
    this._defaultExcludedFileMasks = ['.git/**', 'node_modules/**'];

    /**
     * List of existing files that falls under exclusion masks.
     *
     * @protected
     * @type {Array}
     */
    this._excludedFileMatchers = [];

    /**
     * Extraction masks.
     *
     * @protected
     * @type {Array}
     */
    this._extractFileMasks = [];

    /**
     * Default extractions masks.
     *
     * @protected
     * @type {Array}
     */
    this._defaultExtractFileMasks = ['**/*.+(htm|html|xhtml)'];

    /**
     * List of file matchers from which to extract JavaScript.
     *
     * @protected
     * @type {Array}
     */
    this._extractFileMatchers = [];

    /**
     * Maxixum amount of error that would be reportered.
     *
     * @protected
     * @type {Number}
     */
    this._maxErrors = defaults.maxErrors;

    /**
     * JSCS CWD.
     *
     * @protected
     * @type {String}
     */
    this._basePath = defaults.cwd;

    /**
     * List of overrided options (usually from CLI).
     *
     * @protected
     * @type {Object}
     */
    this._overrides = {};

    /**
     * Is "esnext" mode enabled?
     *
     * @protected
     * @type {Boolean}
     */
    this._esnextEnabled = false;

    /**
     * Is "ES3" mode enabled?.
     *
     * @protected
     * @type {Boolean}
     */
    this._es3Enabled = false;

    /**
     * Custom version of esprima if specified.
     *
     * @protected
     * @type {Object|null}
     */
    this._esprima = null;

    /**
     * Options that would be passed to esprima.
     *
     * @protected
     * @type {Object}
     */
    this._esprimaOptions = {};

    /**
     * A filter function that determines whether or not to report an error.
     *
     * @protected
     * @type {Function|null}
     */
    this._errorFilter = null;

    /**
     * Should we show rule names in error output?
     *
     * @protected
     * @type {Boolean}
     */
    this._verbose = false;
}

/**
 * Load settings from a configuration.
 *
 * @param {Object} config
 */
Configuration.prototype.load = function(config) {

    // Apply all the options
    this._processConfig(config);

    // Load and apply all the rules
    this._useRules();
};

/**
 * Returns resulting configuration after preset is applied and options are processed.
 *
 * @return {Object}
 */
Configuration.prototype.getProcessedConfig = function() {
    var result = {};
    Object.keys(this._ruleSettings).forEach(function(key) {
        result[key] = this._ruleSettings[key];
    }, this);
    result.excludeFiles = this._excludedFileMasks;
    result.fileExtensions = this._fileExtensions;
    result.extract = this._extractFileMasks;
    result.maxErrors = this._maxErrors;
    result.preset = this._presetName;
    result.esnext = this._esnextEnabled;
    result.es3 = this._es3Enabled;
    result.esprima = this._esprima;
    result.esprimaOptions = this._esprimaOptions;
    result.errorFilter = this._errorFilter;
    return result;
};

/**
 * Returns list of configured rules.
 *
 * @returns {Rule[]}
 */
Configuration.prototype.getConfiguredRules = function() {
    return this._configuredRules;
};

/**
 * Returns configured rule.
 *
 * @returns {Rule | null}
 */
Configuration.prototype.getConfiguredRule = function(name) {
    return this._configuredRules.filter(function(rule) {
        return rule.getOptionName() === name;
    })[0] || null;
};

/**
 * Returns the list of unsupported rule names.
 *
 * @return {String[]}
 */
Configuration.prototype.getUnsupportedRuleNames = function() {
    return this._unsupportedRuleNames;
};

/**
 * Returns excluded file mask list.
 *
 * @returns {String[]}
 */
Configuration.prototype.getExcludedFileMasks = function() {
    return this._excludedFileMasks;
};

/**
 * Returns `true` if specified file path is excluded.
 *
 * @param {String} filePath
 * @returns {Boolean}
 */
Configuration.prototype.isFileExcluded = function(filePath) {
    filePath = path.resolve(filePath);
    return this._excludedFileMatchers.some(function(matcher) {
        return matcher.match(filePath);
    });
};

/**
 * Returns file extension list.
 *
 * @returns {String[]}
 */
Configuration.prototype.getFileExtensions = function() {
    return this._fileExtensions;
};

/**
 * Returns extract file masks.
 *
 * @returns {String[]}
 */
Configuration.prototype.getExtractFileMasks = function() {
    return this._extractFileMasks;
};

/**
 * Should filePath to be extracted?
 *
 * @returns {Boolean}
 */
Configuration.prototype.shouldExtractFile = function(filePath) {
    filePath = path.resolve(filePath);
    return this._extractFileMatchers.some(function(matcher) {
        return matcher.match(filePath);
    });
};

/**
 * Returns maximal error count.
 *
 * @returns {Number|null}
 */
Configuration.prototype.getMaxErrors = function() {
    return this._maxErrors;
};

/**
 * Getter "fix" option value.
 *
 * @return {Boolean}
 */
Configuration.prototype.getFix = function() {
    return !!this._fix;
};

/**
 * Returns `true` if `esnext` option is enabled.
 *
 * @returns {Boolean}
 */
Configuration.prototype.isESNextEnabled = function() {
    return this._esnextEnabled;
};

/**
 * Returns `true` if `es3` option is enabled.
 *
 * @returns {Boolean}
 */
Configuration.prototype.isES3Enabled = function() {
    return this._es3Enabled;
};

/**
 * Returns `true` if `esprima` option is not null.
 *
 * @returns {Boolean}
 */
Configuration.prototype.hasCustomEsprima = function() {
    return !!this._esprima;
};

/**
 * Returns the custom esprima parser.
 *
 * @returns {Object|null}
 */
Configuration.prototype.getCustomEsprima = function() {
    return this._esprima;
};

/**
 * Returns verbose option.
 *
 * @returns {Object|null}
 */
Configuration.prototype.getVerbose = function() {
    return this._verbose || false;
};

/**
 * Returns custom Esprima options.
 *
 * @returns {Object}
 */
Configuration.prototype.getEsprimaOptions = function() {
    return this._esprimaOptions;
};

/**
 * Returns the loaded error filter.
 *
 * @returns {Function|null}
 */
Configuration.prototype.getErrorFilter = function() {
    return this._errorFilter;
};

/**
 * Returns base path.
 *
 * @returns {String}
 */
Configuration.prototype.getBasePath = function() {
    return this._basePath;
};

/**
 * Overrides specified settings.
 *
 * @param {String} overrides
 */
Configuration.prototype.override = function(overrides) {
    Object.keys(overrides).forEach(function(key) {
        this._overrides[key] = overrides[key];
    }, this);
};

/**
 * returns options, but not rules, from the provided config
 *
 * @param  {Object} config
 * @returns {Object}
 */
Configuration.prototype._getOptionsFromConfig = function(config) {
    return Object.keys(config).reduce(function(options, key) {
        if (BUILTIN_OPTIONS[key]) {
            options[key] = config[key];
        }
        return options;
    }, {});
};

/**
 * Processes configuration and returns config options.
 *
 * @param {Object} config
 */
Configuration.prototype._processConfig = function(config) {
    var overrides = this._overrides;
    var currentConfig = {};

    // Copy configuration so original config would be intact
    copyConfiguration(config, currentConfig);

    // Override the properties
    copyConfiguration(overrides, currentConfig);

    // NOTE: options is a separate object to ensure that future options must be added
    // to BUILTIN_OPTIONS to work, which also assures they aren't mistaken for a rule
    var options = this._getOptionsFromConfig(currentConfig);

    // Base path
    if (this._basePath === defaults.cwd && options.configPath) {
        assert(
            typeof options.configPath === 'string',
            '`configPath` option requires string value'
        );
        this._basePath = path.dirname(options.configPath);
    }

    if (options.hasOwnProperty('plugins')) {
        assert(Array.isArray(options.plugins), '`plugins` option requires array value');
        options.plugins.forEach(function(plugin) {
            this._loadPlugin(plugin, options.configPath);
        }, this);
    }

    if (options.hasOwnProperty('additionalRules')) {
        assert(Array.isArray(options.additionalRules), '`additionalRules` option requires array value');
        options.additionalRules.forEach(function(rule) {
            this._loadAdditionalRule(rule, options.configPath);
        }, this);
    }

    if (options.hasOwnProperty('extract')) {
        this._loadExtract(options.extract);
    }

    if (options.hasOwnProperty('fileExtensions')) {
        this._loadFileExtensions(options.fileExtensions);

    // Set default extensions if there is no presets that could define their own
    } else if (!options.hasOwnProperty('preset')) {
        this._loadFileExtensions(this._defaultFileExtensions);
    }

    if (options.hasOwnProperty('excludeFiles')) {
        this._loadExcludedFiles(options.excludeFiles);

    // Set default masks if there is no presets that could define their own
    } else if (!options.hasOwnProperty('preset')) {
        this._loadExcludedFiles(this._defaultExcludedFileMasks);
    }

    if (options.hasOwnProperty('fix')) {
        this._loadFix(options.fix);
    }

    this._loadMaxError(options);

    if (options.hasOwnProperty('esnext')) {
        this._loadESNext(options.esnext);
    }

    if (options.hasOwnProperty('es3')) {
        this._loadES3(options.es3);
    }

    if (options.hasOwnProperty('esprima')) {
        this._loadEsprima(options.esprima, options.configPath);
    }

    if (options.hasOwnProperty('esprimaOptions')) {
        this._loadEsprimaOptions(options.esprimaOptions);
    }

    if (options.hasOwnProperty('errorFilter')) {
        this._loadErrorFilter(options.errorFilter, options.configPath);
    }

    if (options.hasOwnProperty('verbose')) {
        this._loadVerbose(options.verbose);
    }

    // Apply presets
    if (options.hasOwnProperty('preset')) {
        this._loadPreset(options.preset, options.configPath);
    }

    this._loadRules(currentConfig);
};

/**
 * Loads plugin data.
 *
 * @param {function(Configuration)} plugin
 * @protected
 */
Configuration.prototype._loadPlugin = function(plugin) {
    assert(typeof plugin === 'function', '`plugin` should be a function');
    plugin(this);
};

/**
 * Load rules.
 *
 * @param {Object} config
 * @protected
 */
Configuration.prototype._loadRules = function(config) {
    Object.keys(config).forEach(function(key) {

        // Only rules should be processed
        if (BUILTIN_OPTIONS[key]) {
            return;
        }

        if (this._rules[key]) {
            var optionValue = config[key];

            // Disable rule it it equals "false" or "null"
            if (optionValue === null || optionValue === false) {
                delete this._ruleSettings[key];

            } else {
                this._ruleSettings[key] = config[key];
            }

        } else if (this._unsupportedRuleNames.indexOf(key) === -1) {
            this._unsupportedRuleNames.push(key);
        }
    }, this);
};

/**
 * Loads an error filter.
 *
 * @param {Function|null} errorFilter
 * @protected
 */
Configuration.prototype._loadErrorFilter = function(errorFilter) {
    assert(
        typeof errorFilter === 'function' ||
        errorFilter === null,
        '`errorFilter` option requires a function or null value'
    );
    this._errorFilter = errorFilter;
};

/**
 * Loads verbose option.
 *
 * @param {Boolean|null} verbose
 * @protected
 */
Configuration.prototype._loadVerbose = function(verbose) {
    assert(
        typeof verbose === 'boolean' || verbose === null,
        '`verbose` option requires a boolean or null value'
    );
    this._verbose = verbose;
};

/*
 * Load "esnext" option.
 *
 * @param {Boolean} esnext
 * @protected
 */
Configuration.prototype._loadESNext = function(esnext) {
    assert(
        typeof esnext === 'boolean' || esnext === null,
        '`esnext` option requires boolean or null value'
    );
    this._esnextEnabled = Boolean(esnext);
};

/**
 * Load "es3" option.
 *
 * @param {Boolean} es3
 * @protected
 */
Configuration.prototype._loadES3 = function(es3) {
    assert(
        typeof es3 === 'boolean' || es3 === null,
        '`es3` option requires boolean or null value'
    );
    this._es3Enabled = Boolean(es3);
};

/**
 * Load "maxError" option.
 *
 * @param {Object} options
 * @protected
 */
Configuration.prototype._loadMaxError = function(options) {

    // If "fix" option is enabled, set to Inifinity, otherwise this option
    // doesn't make sense with "fix" conjunction
    if (this._fix === true) {
        this._maxErrors = Infinity;

        return;
    }

    if (!options.hasOwnProperty('maxErrors')) {
        return;
    }

    var maxErrors = options.maxErrors === null ? null : Number(options.maxErrors);

    assert(
        maxErrors === -1 || maxErrors > 0 || maxErrors === null,
        '`maxErrors` option requires -1, null value or positive number'
    );

    this._maxErrors = maxErrors;
};

/**
 * Load "fix" option.
 *
 * @param {Boolean|null} fix
 * @protected
 */
Configuration.prototype._loadFix = function(fix) {
    fix = fix === null ? false : fix;

    assert(
        typeof fix === 'boolean',
        '`fix` option requires boolean or null value'
    );

    this._fix = fix;
};

/**
 * Loads a custom esprima.
 *
 * @param {Object|null} esprima
 * @protected
 */
Configuration.prototype._loadEsprima = function(esprima) {
    assert(
        (esprima && typeof esprima.parse === 'function') ||
        esprima === null,
        '`esprima` option requires a null value or an object with a parse function'
    );
    this._esprima = esprima;
};

/**
 * Load preset.
 *
 * @param {Object} preset
 * @protected
 */
Configuration.prototype._loadPreset = function(preset) {
    if (this._loadedPresets.indexOf(preset) > -1) {
        return;
    }

    // Do not keep adding preset from CLI (#2087)
    delete this._overrides.preset;

    this._loadedPresets.push(preset);

    // If preset is loaded from another preset - preserve the original name
    if (!this._presetName) {
        this._presetName = preset;
    }
    assert(typeof preset === 'string', '`preset` option requires string value');

    var presetData = this._presets[preset];
    assert(Boolean(presetData), 'Preset "' + preset + '" does not exist');

    // Process config from the preset
    this._processConfig(this._presets[preset]);
};

/**
 * Load file extensions.
 *
 * @param {String|Array} extensions
 * @protected
 */
Configuration.prototype._loadFileExtensions = function(extensions) {
    assert(
        typeof extensions === 'string' || Array.isArray(extensions),
        '`fileExtensions` option requires string or array value'
    );
    this._fileExtensions = this._fileExtensions.concat(extensions).map(function(ext) {
        return ext.toLowerCase();
    });
};

/**
 * Load excluded paths.
 *
 * @param {Array} masks
 * @protected
 */
Configuration.prototype._loadExcludedFiles = function(masks) {
    assert(Array.isArray(masks), '`excludeFiles` option requires array value');

    this._excludedFileMasks = this._excludedFileMasks.concat(masks);
    this._excludedFileMatchers = this._excludedFileMasks.map(function(fileMask) {
        return new minimatch.Minimatch(path.resolve(this._basePath, fileMask), {
            dot: true
        });
    }, this);
};

/**
 * Load paths for extract.
 *
 * @param {Array} masks
 * @protected
 */
Configuration.prototype._loadExtract = function(masks) {
    if (masks === true) {
        masks = this._defaultExtractFileMasks;
    } else if (masks === false) {
        masks = [];
    }

    assert(Array.isArray(masks), '`extract` option should be array of strings');
    this._extractFileMasks = masks.slice();
    this._extractFileMatchers = this._extractFileMasks.map(function(fileMask) {
        return new minimatch.Minimatch(path.resolve(this._basePath, fileMask), {
            dot: true
        });
    }, this);
};

/**
 * Loads custom Esprima options.
 *
 * @param {Object} esprimaOptions
 * @protected
 */
Configuration.prototype._loadEsprimaOptions = function(esprimaOptions) {
    assert(typeof esprimaOptions === 'object' && esprimaOptions !== null, '`esprimaOptions` should be an object');
    this._esprimaOptions = esprimaOptions;
};

/**
 * Loads additional rule.
 *
 * @param {Rule} additionalRule
 * @protected
 */
Configuration.prototype._loadAdditionalRule = function(additionalRule) {
    assert(typeof additionalRule === 'object', '`additionalRule` should be an object');
    this.registerRule(additionalRule);
};

/**
 * Includes plugin in the configuration environment.
 *
 * @param {function(Configuration)|*} plugin
 */
Configuration.prototype.usePlugin = function(plugin) {
    this._loadPlugin(plugin);
};

/**
 * Apply the rules.
 *
 * @protected
 */
Configuration.prototype._useRules = function() {
    this._configuredRules = [];

    Object.keys(this._ruleSettings).forEach(function(optionName) {
        var rule = this._rules[optionName];
        rule.configure(this._ruleSettings[optionName]);
        this._configuredRules.push(rule);
    }, this);
};

/**
 * Adds rule to the collection.
 *
 * @param {Rule|Function} rule Rule instance or rule class.
 */
Configuration.prototype.registerRule = function(rule) {
    if (typeof rule === 'function') {
        var RuleClass = rule;
        rule = new RuleClass();
    }

    var optionName = rule.getOptionName();
    assert(!this._rules.hasOwnProperty(optionName), 'Rule "' + optionName + '" is already registered');
    this._rules[optionName] = rule;
};

/**
 * Returns list of registered rules.
 *
 * @returns {Rule[]}
 */
Configuration.prototype.getRegisteredRules = function() {
    var rules = this._rules;
    return Object.keys(rules).map(function(ruleOptionName) {
        return rules[ruleOptionName];
    });
};

/**
 * Adds preset to the collection.
 *
 * @param {String} presetName
 * @param {Object} presetConfig
 */
Configuration.prototype.registerPreset = function(presetName, presetConfig) {
    assert(_.isPlainObject(presetConfig), 'Preset should be an object');

    for (var key in presetConfig) {
        assert(typeof presetConfig[key] !== 'function', 'Preset should be an JSON object');
    }

    this._presets[presetName] = presetConfig;
};

/**
 * Returns registered presets object (key - preset name, value - preset content).
 *
 * @returns {Object}
 */
Configuration.prototype.getRegisteredPresets = function() {
    return this._presets;
};

/**
 * Returns `true` if preset with specified name exists.
 *
 * @param {String} presetName
 * @return {Boolean}
 */
Configuration.prototype.hasPreset = function(presetName) {
    return this._presets.hasOwnProperty(presetName);
};

/**
 * Returns name of the active preset.
 *
 * @return {String}
 */
Configuration.prototype.getPresetName = function() {
    return this._presetName;
};

/**
 * Registers built-in Code Style cheking rules.
 */
Configuration.prototype.registerDefaultRules = function() {

    /*
        Important!
        These rules are linked explicitly to keep browser-version supported.
    */

    this.registerRule(require('../rules/disallow-unused-params'));

    // Register jsdoc plugin
    this.registerRule(require('../rules/jsdoc'));

    /* ES6 only */
    this.registerRule(require('../rules/require-parentheses-around-arrow-param'));
    this.registerRule(require('../rules/disallow-parentheses-around-arrow-param'));
    this.registerRule(require('../rules/require-numeric-literals'));
    this.registerRule(require('../rules/require-arrow-functions'));
    this.registerRule(require('../rules/disallow-arrow-functions'));
    this.registerRule(require('../rules/require-spread'));
    this.registerRule(require('../rules/require-template-strings'));
    this.registerRule(require('../rules/require-shorthand-arrow-functions'));
    this.registerRule(require('../rules/disallow-shorthand-arrow-functions'));
    this.registerRule(require('../rules/disallow-identical-destructuring-names'));
    this.registerRule(require('../rules/require-spaces-in-generator'));
    this.registerRule(require('../rules/disallow-spaces-in-generator'));
    this.registerRule(require('../rules/require-object-destructuring'));
    this.registerRule(require('../rules/require-enhanced-object-literals'));
    this.registerRule(require('../rules/require-array-destructuring'));
    this.registerRule(require('../rules/disallow-var'));
    /* ES6 only (end) */

    this.registerRule(require('../rules/require-curly-braces'));
    this.registerRule(require('../rules/disallow-curly-braces'));
    this.registerRule(require('../rules/require-multiple-var-decl'));
    this.registerRule(require('../rules/disallow-multiple-var-decl'));
    this.registerRule(require('../rules/require-var-decl-first'));
    this.registerRule(require('../rules/disallow-empty-blocks'));
    this.registerRule(require('../rules/require-space-after-keywords'));
    this.registerRule(require('../rules/require-space-before-keywords'));
    this.registerRule(require('../rules/disallow-space-after-keywords'));
    this.registerRule(require('../rules/disallow-space-before-keywords'));
    this.registerRule(require('../rules/require-parentheses-around-iife'));

    this.registerRule(require('../rules/require-operator-before-line-break'));
    this.registerRule(require('../rules/disallow-operator-before-line-break'));
    this.registerRule(require('../rules/disallow-implicit-type-conversion'));
    this.registerRule(require('../rules/require-camelcase-or-uppercase-identifiers'));
    this.registerRule(require('../rules/disallow-keywords'));
    this.registerRule(require('../rules/disallow-multiple-line-breaks'));
    this.registerRule(require('../rules/disallow-multiple-line-strings'));
    this.registerRule(require('../rules/disallow-multiple-spaces'));
    this.registerRule(require('../rules/validate-line-breaks'));
    this.registerRule(require('../rules/validate-quote-marks'));
    this.registerRule(require('../rules/validate-indentation'));
    this.registerRule(require('../rules/disallow-trailing-whitespace'));
    this.registerRule(require('../rules/disallow-mixed-spaces-and-tabs'));
    this.registerRule(require('../rules/require-object-keys-on-new-line'));
    this.registerRule(require('../rules/disallow-object-keys-on-new-line'));
    this.registerRule(require('../rules/require-keywords-on-new-line'));
    this.registerRule(require('../rules/disallow-keywords-on-new-line'));
    this.registerRule(require('../rules/require-line-feed-at-file-end'));
    this.registerRule(require('../rules/maximum-line-length'));
    this.registerRule(require('../rules/require-yoda-conditions'));
    this.registerRule(require('../rules/disallow-yoda-conditions'));
    this.registerRule(require('../rules/require-spaces-inside-brackets'));
    this.registerRule(require('../rules/require-spaces-inside-object-brackets'));
    this.registerRule(require('../rules/require-spaces-inside-array-brackets'));
    this.registerRule(require('../rules/require-spaces-inside-parentheses'));
    this.registerRule(require('../rules/require-spaces-inside-parenthesized-expression'));
    this.registerRule(require('../rules/disallow-spaces-inside-brackets'));
    this.registerRule(require('../rules/disallow-spaces-inside-object-brackets'));
    this.registerRule(require('../rules/disallow-spaces-inside-array-brackets'));
    this.registerRule(require('../rules/disallow-spaces-inside-parentheses'));
    this.registerRule(require('../rules/disallow-spaces-inside-parenthesized-expression'));
    this.registerRule(require('../rules/require-blocks-on-newline'));
    this.registerRule(require('../rules/require-space-after-object-keys'));
    this.registerRule(require('../rules/require-space-before-object-values'));
    this.registerRule(require('../rules/disallow-space-after-object-keys'));
    this.registerRule(require('../rules/disallow-space-before-object-values'));
    this.registerRule(require('../rules/disallow-quoted-keys-in-objects'));
    this.registerRule(require('../rules/require-quoted-keys-in-objects'));
    this.registerRule(require('../rules/disallow-dangling-underscores'));
    this.registerRule(require('../rules/require-aligned-object-values'));
    this.registerRule(require('../rules/validate-aligned-function-parameters'));

    this.registerRule(require('../rules/disallow-padding-newlines-after-blocks'));
    this.registerRule(require('../rules/require-padding-newlines-after-blocks'));

    this.registerRule(require('../rules/disallow-padding-newlines-in-blocks'));
    this.registerRule(require('../rules/require-padding-newlines-in-blocks'));
    this.registerRule(require('../rules/require-padding-newlines-in-objects'));
    this.registerRule(require('../rules/disallow-padding-newlines-in-objects'));
    this.registerRule(require('../rules/require-newline-before-block-statements'));
    this.registerRule(require('../rules/disallow-newline-before-block-statements'));

    this.registerRule(require('../rules/require-padding-newlines-before-keywords'));
    this.registerRule(require('../rules/disallow-padding-newlines-before-keywords'));

    this.registerRule(require('../rules/disallow-padding-newlines-before-line-comments'));
    this.registerRule(require('../rules/require-padding-newlines-before-line-comments'));
    this.registerRule(require('../rules/validate-comment-position.js'));

    this.registerRule(require('../rules/disallow-trailing-comma'));
    this.registerRule(require('../rules/require-trailing-comma'));

    this.registerRule(require('../rules/require-dollar-before-jquery-assignment'));

    this.registerRule(require('../rules/disallow-comma-before-line-break'));
    this.registerRule(require('../rules/require-comma-before-line-break'));

    this.registerRule(require('../rules/disallow-space-before-block-statements.js'));
    this.registerRule(require('../rules/require-space-before-block-statements.js'));

    this.registerRule(require('../rules/disallow-space-before-postfix-unary-operators.js'));
    this.registerRule(require('../rules/require-space-before-postfix-unary-operators.js'));

    this.registerRule(require('../rules/disallow-space-after-prefix-unary-operators.js'));
    this.registerRule(require('../rules/require-space-after-prefix-unary-operators.js'));

    this.registerRule(require('../rules/disallow-space-before-binary-operators'));
    this.registerRule(require('../rules/require-space-before-binary-operators'));

    this.registerRule(require('../rules/disallow-space-after-binary-operators'));
    this.registerRule(require('../rules/require-space-after-binary-operators'));

    this.registerRule(require('../rules/require-spaces-in-conditional-expression'));
    this.registerRule(require('../rules/disallow-spaces-in-conditional-expression'));
    this.registerRule(require('../rules/require-multi-line-ternary'));
    this.registerRule(require('../rules/disallow-multi-line-ternary'));
    this.registerRule(require('../rules/disallow-nested-ternaries'));

    this.registerRule(require('../rules/require-spaces-in-function'));
    this.registerRule(require('../rules/disallow-spaces-in-function'));
    this.registerRule(require('../rules/require-spaces-in-function-expression'));
    this.registerRule(require('../rules/disallow-spaces-in-function-expression'));
    this.registerRule(require('../rules/require-spaces-in-anonymous-function-expression'));
    this.registerRule(require('../rules/disallow-spaces-in-anonymous-function-expression'));
    this.registerRule(require('../rules/require-spaces-in-named-function-expression'));
    this.registerRule(require('../rules/disallow-spaces-in-named-function-expression'));
    this.registerRule(require('../rules/require-spaces-in-function-declaration'));
    this.registerRule(require('../rules/disallow-spaces-in-function-declaration'));

    this.registerRule(require('../rules/require-spaces-in-call-expression'));
    this.registerRule(require('../rules/disallow-spaces-in-call-expression'));

    this.registerRule(require('../rules/validate-parameter-separator'));
    this.registerRule(require('../rules/require-space-between-arguments'));
    this.registerRule(require('../rules/disallow-space-between-arguments'));

    this.registerRule(require('../rules/require-capitalized-constructors'));
    this.registerRule(require('../rules/require-capitalized-constructors-new'));

    this.registerRule(require('../rules/safe-context-keyword'));

    this.registerRule(require('../rules/require-dot-notation'));

    this.registerRule(require('../rules/require-space-after-line-comment'));
    this.registerRule(require('../rules/disallow-space-after-line-comment'));

    this.registerRule(require('../rules/require-anonymous-functions'));
    this.registerRule(require('../rules/disallow-anonymous-functions'));
    this.registerRule(require('../rules/require-named-unassigned-functions'));
    this.registerRule(require('../rules/disallow-named-unassigned-functions'));

    this.registerRule(require('../rules/require-function-declarations'));
    this.registerRule(require('../rules/disallow-function-declarations'));

    this.registerRule(require('../rules/require-capitalized-comments'));
    this.registerRule(require('../rules/disallow-capitalized-comments'));

    this.registerRule(require('../rules/require-line-break-after-variable-assignment'));
    this.registerRule(require('../rules/require-padding-newline-after-variable-declaration'));

    this.registerRule(require('../rules/disallow-padding-newlines-after-use-strict'));
    this.registerRule(require('../rules/require-padding-newlines-after-use-strict'));

    this.registerRule(require('../rules/disallow-padding-newlines-before-export'));
    this.registerRule(require('../rules/require-padding-newlines-before-export'));

    this.registerRule(require('../rules/require-semicolons'));
    this.registerRule(require('../rules/disallow-semicolons'));

    this.registerRule(require('../rules/require-spaces-in-for-statement'));
    this.registerRule(require('../rules/disallow-spaces-in-for-statement'));

    this.registerRule(require('../rules/disallow-node-types'));

    this.registerRule(require('../rules/disallow-keywords-in-comments'));

    this.registerRule(require('../rules/disallow-identifier-names'));

    this.registerRule(require('../rules/maximum-number-of-lines'));

    this.registerRule(require('../rules/validate-newline-after-array-elements'));

    this.registerRule(require('../rules/disallow-not-operators-in-conditionals'));

    this.registerRule(require('../rules/require-matching-function-name'));

    this.registerRule(require('../rules/disallow-space-before-semicolon'));

    this.registerRule(require('../rules/disallow-space-before-comma'));
    this.registerRule(require('../rules/disallow-space-after-comma'));

    this.registerRule(require('../rules/require-space-before-comma'));
    this.registerRule(require('../rules/require-space-after-comma'));

    this.registerRule(require('../rules/validate-order-in-object-keys'));

    this.registerRule(require('../rules/disallow-tabs'));

    this.registerRule(require('../rules/require-aligned-multiline-params'));

    this.registerRule(require('../rules/require-early-return'));
};

/**
 * Registers built-in Code Style cheking presets.
 */
Configuration.prototype.registerDefaultPresets = function() {
    // https://github.com/airbnb/javascript
    this.registerPreset('airbnb', require('../../presets/airbnb.json'));

    // http://javascript.crockford.com/code.html
    this.registerPreset('crockford', require('../../presets/crockford.json'));

    // https://google-styleguide.googlecode.com/svn/trunk/javascriptguide.xml
    this.registerPreset('google', require('../../presets/google.json'));

    // http://gruntjs.com/contributing#syntax
    this.registerPreset('grunt', require('../../presets/grunt.json'));

    // https://github.com/rwaldron/idiomatic.js#idiomatic-style-manifesto
    this.registerPreset('idiomatic', require('../../presets/idiomatic.json'));

    // https://contribute.jquery.org/style-guide/js/
    this.registerPreset('jquery', require('../../presets/jquery.json'));

    // https://github.com/mrdoob/three.js/wiki/Mr.doob's-Code-Style%E2%84%A2
    this.registerPreset('mdcs', require('../../presets/mdcs.json'));

    // https://github.com/felixge/node-style-guide#nodejs-style-guide
    this.registerPreset('node-style-guide', require('../../presets/node-style-guide.json'));

    // https://www.mediawiki.org/wiki/Manual:Coding_conventions/JavaScript
    this.registerPreset('wikimedia', require('jscs-preset-wikimedia'));

    // https://make.wordpress.org/core/handbook/coding-standards/javascript/
    this.registerPreset('wordpress', require('../../presets/wordpress.json'));

    // https://github.com/yandex/codestyle/blob/master/javascript.md
    this.registerPreset('yandex', require('../../presets/yandex.json'));
};

module.exports = Configuration;

function copyConfiguration(source, dest) {
    Object.keys(source).forEach(function(key) {
        dest[key] = source[key];
    });
    if (source.configPath) {
        dest.configPath = source.configPath;
    }
}

},{"../../presets/airbnb.json":953,"../../presets/crockford.json":954,"../../presets/google.json":955,"../../presets/grunt.json":956,"../../presets/idiomatic.json":957,"../../presets/jquery.json":958,"../../presets/mdcs.json":959,"../../presets/node-style-guide.json":960,"../../presets/wordpress.json":961,"../../presets/yandex.json":962,"../rules/disallow-anonymous-functions":4,"../rules/disallow-arrow-functions":5,"../rules/disallow-capitalized-comments":6,"../rules/disallow-comma-before-line-break":7,"../rules/disallow-curly-braces":8,"../rules/disallow-dangling-underscores":9,"../rules/disallow-empty-blocks":10,"../rules/disallow-function-declarations":11,"../rules/disallow-identical-destructuring-names":12,"../rules/disallow-identifier-names":13,"../rules/disallow-implicit-type-conversion":14,"../rules/disallow-keywords":17,"../rules/disallow-keywords-in-comments":15,"../rules/disallow-keywords-on-new-line":16,"../rules/disallow-mixed-spaces-and-tabs":18,"../rules/disallow-multi-line-ternary":19,"../rules/disallow-multiple-line-breaks":20,"../rules/disallow-multiple-line-strings":21,"../rules/disallow-multiple-spaces":22,"../rules/disallow-multiple-var-decl":23,"../rules/disallow-named-unassigned-functions":24,"../rules/disallow-nested-ternaries":25,"../rules/disallow-newline-before-block-statements":26,"../rules/disallow-node-types":27,"../rules/disallow-not-operators-in-conditionals":28,"../rules/disallow-object-keys-on-new-line":29,"../rules/disallow-operator-before-line-break":30,"../rules/disallow-padding-newlines-after-blocks":31,"../rules/disallow-padding-newlines-after-use-strict":32,"../rules/disallow-padding-newlines-before-export":33,"../rules/disallow-padding-newlines-before-keywords":34,"../rules/disallow-padding-newlines-before-line-comments":35,"../rules/disallow-padding-newlines-in-blocks":36,"../rules/disallow-padding-newlines-in-objects":37,"../rules/disallow-parentheses-around-arrow-param":38,"../rules/disallow-quoted-keys-in-objects":39,"../rules/disallow-semicolons":40,"../rules/disallow-shorthand-arrow-functions":41,"../rules/disallow-space-after-binary-operators":42,"../rules/disallow-space-after-comma":43,"../rules/disallow-space-after-keywords":44,"../rules/disallow-space-after-line-comment":45,"../rules/disallow-space-after-object-keys":46,"../rules/disallow-space-after-prefix-unary-operators.js":47,"../rules/disallow-space-before-binary-operators":48,"../rules/disallow-space-before-block-statements.js":49,"../rules/disallow-space-before-comma":50,"../rules/disallow-space-before-keywords":51,"../rules/disallow-space-before-object-values":52,"../rules/disallow-space-before-postfix-unary-operators.js":53,"../rules/disallow-space-before-semicolon":54,"../rules/disallow-space-between-arguments":55,"../rules/disallow-spaces-in-anonymous-function-expression":56,"../rules/disallow-spaces-in-call-expression":57,"../rules/disallow-spaces-in-conditional-expression":58,"../rules/disallow-spaces-in-for-statement":59,"../rules/disallow-spaces-in-function":62,"../rules/disallow-spaces-in-function-declaration":60,"../rules/disallow-spaces-in-function-expression":61,"../rules/disallow-spaces-in-generator":63,"../rules/disallow-spaces-in-named-function-expression":64,"../rules/disallow-spaces-inside-array-brackets":65,"../rules/disallow-spaces-inside-brackets":66,"../rules/disallow-spaces-inside-object-brackets":67,"../rules/disallow-spaces-inside-parentheses":68,"../rules/disallow-spaces-inside-parenthesized-expression":69,"../rules/disallow-tabs":70,"../rules/disallow-trailing-comma":71,"../rules/disallow-trailing-whitespace":72,"../rules/disallow-unused-params":73,"../rules/disallow-var":74,"../rules/disallow-yoda-conditions":75,"../rules/jsdoc":76,"../rules/maximum-line-length":77,"../rules/maximum-number-of-lines":78,"../rules/require-aligned-multiline-params":79,"../rules/require-aligned-object-values":80,"../rules/require-anonymous-functions":81,"../rules/require-array-destructuring":82,"../rules/require-arrow-functions":83,"../rules/require-blocks-on-newline":84,"../rules/require-camelcase-or-uppercase-identifiers":85,"../rules/require-capitalized-comments":86,"../rules/require-capitalized-constructors":88,"../rules/require-capitalized-constructors-new":87,"../rules/require-comma-before-line-break":89,"../rules/require-curly-braces":90,"../rules/require-dollar-before-jquery-assignment":91,"../rules/require-dot-notation":92,"../rules/require-early-return":93,"../rules/require-enhanced-object-literals":94,"../rules/require-function-declarations":95,"../rules/require-keywords-on-new-line":96,"../rules/require-line-break-after-variable-assignment":97,"../rules/require-line-feed-at-file-end":98,"../rules/require-matching-function-name":99,"../rules/require-multi-line-ternary":100,"../rules/require-multiple-var-decl":101,"../rules/require-named-unassigned-functions":102,"../rules/require-newline-before-block-statements":103,"../rules/require-numeric-literals":104,"../rules/require-object-destructuring":105,"../rules/require-object-keys-on-new-line":106,"../rules/require-operator-before-line-break":107,"../rules/require-padding-newline-after-variable-declaration":108,"../rules/require-padding-newlines-after-blocks":109,"../rules/require-padding-newlines-after-use-strict":110,"../rules/require-padding-newlines-before-export":111,"../rules/require-padding-newlines-before-keywords":112,"../rules/require-padding-newlines-before-line-comments":113,"../rules/require-padding-newlines-in-blocks":114,"../rules/require-padding-newlines-in-objects":115,"../rules/require-parentheses-around-arrow-param":116,"../rules/require-parentheses-around-iife":117,"../rules/require-quoted-keys-in-objects":118,"../rules/require-semicolons":119,"../rules/require-shorthand-arrow-functions":120,"../rules/require-space-after-binary-operators":121,"../rules/require-space-after-comma":122,"../rules/require-space-after-keywords":123,"../rules/require-space-after-line-comment":124,"../rules/require-space-after-object-keys":125,"../rules/require-space-after-prefix-unary-operators.js":126,"../rules/require-space-before-binary-operators":127,"../rules/require-space-before-block-statements.js":128,"../rules/require-space-before-comma":129,"../rules/require-space-before-keywords":130,"../rules/require-space-before-object-values":131,"../rules/require-space-before-postfix-unary-operators.js":132,"../rules/require-space-between-arguments":133,"../rules/require-spaces-in-anonymous-function-expression":134,"../rules/require-spaces-in-call-expression":135,"../rules/require-spaces-in-conditional-expression":136,"../rules/require-spaces-in-for-statement":137,"../rules/require-spaces-in-function":140,"../rules/require-spaces-in-function-declaration":138,"../rules/require-spaces-in-function-expression":139,"../rules/require-spaces-in-generator":141,"../rules/require-spaces-in-named-function-expression":142,"../rules/require-spaces-inside-array-brackets":143,"../rules/require-spaces-inside-brackets":144,"../rules/require-spaces-inside-object-brackets":145,"../rules/require-spaces-inside-parentheses":146,"../rules/require-spaces-inside-parenthesized-expression":147,"../rules/require-spread":148,"../rules/require-template-strings":149,"../rules/require-trailing-comma":150,"../rules/require-var-decl-first":151,"../rules/require-yoda-conditions":152,"../rules/safe-context-keyword":153,"../rules/validate-aligned-function-parameters":154,"../rules/validate-comment-position.js":155,"../rules/validate-indentation":156,"../rules/validate-line-breaks":157,"../rules/validate-newline-after-array-elements":158,"../rules/validate-order-in-object-keys":159,"../rules/validate-parameter-separator":160,"../rules/validate-quote-marks":161,"assert":171,"jscs-preset-wikimedia":733,"lodash":761,"minimatch":865,"path":870}],2:[function(require,module,exports){
var assert = require('assert');
var chalk = require('chalk');
var TokenAssert = require('./token-assert');

/**
 * Set of errors for specified file.
 *
 * @name Errors
 * @param {JsFile} file
 * @param {Boolean} verbose
 */
var Errors = function(file, verbose) {
    this._errorList = [];
    this._file = file;
    this._currentRule = '';
    this._verbose = verbose || false;

    /**
     * @type {TokenAssert}
     * @public
     */
    this.assert = new TokenAssert(file);
    this.assert.on('error', this._addError.bind(this));
};

Errors.prototype = {
    /**
     * Adds style error to the list
     *
     * @param {String} message
     * @param {Number|Object} line
     * @param {Number} [column] optional if line is an object
     */
    add: function(message, line, column) {
        if (typeof line === 'object') {
            column = line.column;
            line = line.line;
        }

        var errorInfo = {
            message: message,
            line: line,
            column: column
        };

        this._validateInput(errorInfo);
        this._addError(errorInfo);
    },

    /**
     * Adds style error to the list
     *
     * @param {Object} errorInfo
     */
    cast: function(errorInfo) {
        var additional = errorInfo.additional;

        assert(typeof additional !== undefined,
               '`additional` argument should not be empty');

        this._addError(errorInfo);
    },

    _validateInput: function(errorInfo) {
        var line = errorInfo.line;
        var column = errorInfo.column;

        // line and column numbers should be explicit
        assert(typeof line === 'number' && line > 0,
            'Unable to add an error, `line` should be a number greater than 0 but ' +
                line + ' given');

        assert(typeof column === 'number' && column >= 0,
            'Unable to add an error, `column` should be a positive number but ' +
                column + ' given');
    },

    /**
     * Adds error to error list.
     *
     * @param {Object} errorInfo
     * @private
     */
    _addError: function(errorInfo) {
        if (!this._file.isEnabledRule(this._currentRule, errorInfo.line)) {
            return;
        }

        this._validateInput(errorInfo);

        this._errorList.push({
            filename: this._file.getFilename(),
            rule: this._currentRule,
            message: this._prepareMessage(errorInfo),
            line: errorInfo.line,
            column: errorInfo.column,
            additional: errorInfo.additional,
            fixed: errorInfo.fixed
        });
    },

    /**
     * Prepare error message.
     *
     * @param {Object} errorInfo
     * @private
     */
    _prepareMessage: function(errorInfo) {
        if (this._verbose && this._currentRule) {
            return this._currentRule + ': ' + errorInfo.message;
        }

        return errorInfo.message;
    },

    /**
     * Returns style error list.
     *
     * @returns {Object[]}
     */
    getErrorList: function() {
        return this._errorList;
    },

    /**
     * Returns filename of file this error list is for.
     *
     * @returns {String}
     */
    getFilename: function() {
        return this._file.getFilename();
    },

    /**
     * Returns true if no errors are added.
     *
     * @returns {Boolean}
     */
    isEmpty: function() {
        return this._errorList.length === 0;
    },

    /**
     * Returns amount of errors added by the rules.
     *
     * @returns {Number}
     */
    getErrorCount: function() {
        return this._errorList.length;
    },

    /**
     * Strips error list to the specified length.
     *
     * @param {Number} length
     */
    stripErrorList: function(length) {
        this._errorList.splice(length);
    },

    /**
     * Filters out errors based on the supplied filter function
     *
     * @param {Function} filter
     */
    filter: function(filter) {
        this._errorList = this._errorList.filter(filter);
    },

    /**
     * Formats error for further output.
     *
     * @param {Object} error
     * @param {Boolean} [colorize = false]
     * @returns {String}
     */
    explainError: function(error, colorize) {
        var lineNumber = error.line - 1;
        var lines = this._file.getLines();
        var result = [
            renderLine(lineNumber, lines[lineNumber], colorize),
            renderPointer(error.column, colorize)
        ];
        var i = lineNumber - 1;
        var linesAround = 2;
        while (i >= 0 && i >= (lineNumber - linesAround)) {
            result.unshift(renderLine(i, lines[i], colorize));
            i--;
        }
        i = lineNumber + 1;
        while (i < lines.length && i <= (lineNumber + linesAround)) {
            result.push(renderLine(i, lines[i], colorize));
            i++;
        }
        result.unshift(formatErrorMessage(error.message, this.getFilename(), colorize));
        return result.join('\n');
    },

    /**
     * Sets the current rule so that errors are aware
     * of which rule triggered them.
     *
     * @param {String} rule
     */
    setCurrentRule: function(rule) {
        this._currentRule = rule;
    }

};

/**
 * Formats error message header.
 *
 * @param {String} message
 * @param {String} filename
 * @param {Boolean} colorize
 * @returns {String}
 */
function formatErrorMessage(message, filename, colorize) {
    return (colorize ? chalk.bold(message) : message) +
        ' at ' +
        (colorize ? chalk.green(filename) : filename) + ' :';
}

/**
 * Simple util for prepending spaces to the string until it fits specified size.
 *
 * @param {String} s
 * @param {Number} len
 * @returns {String}
 */
function prependSpaces(s, len) {
    while (s.length < len) {
        s = ' ' + s;
    }
    return s;
}

/**
 * Renders single line of code in style error formatted output.
 *
 * @param {Number} n line number
 * @param {String} line
 * @param {Boolean} [colorize = false]
 * @returns {String}
 */
function renderLine(n, line, colorize) {
    // Convert tabs to spaces, so errors in code lines with tabs as indention symbol
    // could be correctly rendered, plus it will provide less verbose output
    line = line.replace(/\t/g, ' ');

    // "n + 1" to print lines in human way (counted from 1)
    var lineNumber = prependSpaces((n + 1).toString(), 5) + ' |';
    return ' ' + (colorize ? chalk.grey(lineNumber) : lineNumber) + line;
}

/**
 * Renders pointer:
 * ---------------^
 *
 * @param {Number} column
 * @param {Boolean} [colorize = false]
 * @returns {String}
 */
function renderPointer(column, colorize) {
    var res = (new Array(column + 9)).join('-') + '^';
    return colorize ? chalk.grey(res) : res;
}

module.exports = Errors;

},{"./token-assert":163,"assert":171,"chalk":406}],3:[function(require,module,exports){
var assert = require('assert');

var escope = require('escope');

var treeIterator = require('./tree-iterator');

/**
 * Operator list which are represented as keywords in token list.
 */
var KEYWORD_OPERATORS = {
    'instanceof': true,
    'in': true
};

/**
 * File representation for JSCS.
 *
 * @name JsFile
 * @param {Object} params
 * @param {String} params.filename
 * @param {String} params.source
 * @param {Object} params.esprima
 * @param {Object} [params.esprimaOptions]
 * @param {Boolean} [params.es3]
 * @param {Boolean} [params.es6]
 */
var JsFile = function(params) {
    params = params || {};
    this._parseErrors = [];
    this._filename = params.filename;
    this._source = params.source;
    this._tree = {tokens: [], comments: []};

    this._es3 = params.es3 || false;
    this._es6 = params.es6 || false;

    this._lineBreaks = null;
    this._lines = this._source.split(/\r\n|\r|\n/);

    var hasErrors = false;
    try {
        this._tree = parseJavaScriptSource(this._source, params.esprima, params.esprimaOptions);
    } catch (e) {
        hasErrors = true;
        this._parseErrors.push(e);
    }

    // Lazy initialization
    this._scope = null;

    this._tokens = this._buildTokenList(this._tree.tokens, this._tree.comments);
    this._addEOFToken(hasErrors);
    this._tokens = this._addWhitespaceTokens(this._tokens, this._source);

    this._setTokenIndexes();

    var nodeIndexes = this._buildNodeIndex();
    this._index = nodeIndexes.nodesByType;
    this._nodesByStartRange = nodeIndexes.nodesByStartRange;

    this._fixEsprimaIdentifiers();

    this._buildDisabledRuleIndex();
};

JsFile.prototype = {
    /**
     * Returns the first line break character encountered in the file.
     * Assumes LF if the file is only one line.
     *
     * @returns {String}
     */
    getLineBreakStyle: function() {
        var lineBreaks = this.getLineBreaks();
        return lineBreaks.length ? lineBreaks[0] : '\n';
    },

    /**
     * Returns all line break characters from the file.
     *
     * @returns {String[]}
     */
    getLineBreaks: function() {
        if (this._lineBreaks === null) {
            this._lineBreaks = this._source.match(/\r\n|\r|\n/g) || [];
        }

        return this._lineBreaks;
    },

    /**
     * Set token indexes
     *
     * @private
     */
    _setTokenIndexes: function() {
        var tokenIndexes = this._buildTokenIndex(this._tokens);

        this._tokenRangeStartIndex = tokenIndexes.tokenRangeStartIndex;
        this._tokenRangeEndIndex = tokenIndexes.tokenRangeEndIndex;
        this._tokensByLineIndex = tokenIndexes.tokensByLineIndex;
    },

    /**
     * Builds an index of disabled rules by starting line for error suppression.
     *
     * @private
     */
    _buildDisabledRuleIndex: function() {
        this._disabledRuleIndex = [];

        var comments = this.getComments();

        // Matches a comment enabling or disabling rules.
        var blockRe = /(jscs\s*:\s*(en|dis)able)(.*)/;

        // Matches a comment disbling a rule for one line.
        var lineRe = /(jscs\s*:\s*ignore)(.*)/;

        comments.forEach(function(comment) {
            var enabled;
            var value = comment.value.trim();
            var blockParsed = blockRe.exec(value);
            var lineParsed = lineRe.exec(value);
            var line = comment.loc.start.line;

            if (blockParsed && blockParsed.index === 0) {
                enabled = blockParsed[2] === 'en';
                this._addToDisabledRuleIndex(enabled, blockParsed[3], line);

            } else if (lineParsed && lineParsed.index === 0) {
                this._disableRulesAt(lineParsed[2], line);
            }

        }, this);
    },

    /**
     * Sets whitespace before specified token.
     *
     * @param {Object} token
     * @param {String} whitespace
     */
    setWhitespaceBefore: function(token, whitespace) {
        var whitespaceToken = this.getPrevToken(token, {includeWhitespace: true});
        if (whitespaceToken && whitespaceToken.type === 'Whitespace') {

            // Modifying already existing token.
            if (whitespace === '') {
                this.removeToken(whitespaceToken);
            } else {
                whitespaceToken.value = whitespace;
            }
        } else if (whitespace !== '') {
            var tokenIndex = token._tokenIndex;

            // Adding a token before specified one.
            this._tokens.splice(tokenIndex, 0, {
                type: 'Whitespace',
                value: whitespace,
                isWhitespace: true
            });

            // Quickly updating modified token order
            for (var i = tokenIndex; i < this._tokens.length; i++) {
                this._tokens[i]._tokenIndex = i;
            }
        }
    },

    /**
     * Returns whitespace before specified token.
     *
     * @param {Object} token
     * @returns {String}
     */
    getWhitespaceBefore: function(token) {
        var whitespaceToken = this.getPrevToken(token, {includeWhitespace: true});
        if (whitespaceToken && whitespaceToken.type === 'Whitespace') {
            return whitespaceToken.value;
        } else {
            return '';
        }
    },

    /**
     * Remove some entity (only one) from array with predicate
     *
     * @param {Array} entities
     * @param {*} entity
     */
    removeEntity: function(entities, entity) {
        for (var i = 0; i < entities.length; i++) {
            if (entities[i] === entity) {
                entities.splice(i, 1);

                return;
            }
        }
    },

    /**
     * Remove token from token list.
     *
     * @param {Object} token
     */
    removeToken: function(token) {
        this.removeEntity(this._tokens, token);

        this._setTokenIndexes();
    },

    /**
     * Disables a rules for a single line, not re-enabling any disabled rules
     *
     * @private
     */
    _disableRulesAt: function(rules, line) {
        rules = rules.split(/\s*,\s*/);
        for (var i = 0; i < rules.length; i++) {
            if (!this.isEnabledRule(rules[i], line)) {
                continue;
            }

            this._addToDisabledRuleIndex(false, rules[i], line);
            this._addToDisabledRuleIndex(true, rules[i], line + 1);
        }
    },

    /**
     * Returns whether a specific rule is disabled on the given line.
     *
     * @param {String} ruleName the rule name being tested
     * @param {Number} line the line number being tested
     * @returns {Boolean} true if the rule is enabled
     */
    isEnabledRule: function(ruleName, line) {
        var enabled = true;
        ruleName = ruleName.trim();

        this._disabledRuleIndex.some(function(region) {
            // once the comment we're inspecting occurs after the location of the error,
            // no longer check for whether the state is enabled or disable
            if (region.line > line) {
                return true;
            }

            if (region.rule === ruleName || region.rule === '*') {
                enabled = region.enabled;
            }
        }, this);

        return enabled;
    },

    /**
     * Adds rules to the disabled index given a string containing rules (or '' for all).
     *
     * @param {Boolean} enabled whether the rule is disabled or enabled on this line
     * @param {String} rulesStr the string containing specific rules to en/disable
     * @param {Number} line the line the comment appears on
     * @private
     */
    _addToDisabledRuleIndex: function(enabled, rulesStr, line) {
        rulesStr = rulesStr || '*';

        rulesStr.split(',').forEach(function(rule) {
            rule = rule.trim();

            if (!rule) {
                return;
            }

            this._disabledRuleIndex.push({
                rule: rule,
                enabled: enabled,
                line: line
            });
        }, this);
    },

    /**
     * Builds token index by starting pos for futher navigation.
     *
     * @param {Object[]} tokens
     * @returns {{tokenRangeStartIndex: {}, tokenRangeEndIndex: {}}}
     * @private
     */
    _buildTokenIndex: function(tokens) {
        var tokenRangeStartIndex = {};
        var tokenRangeEndIndex = {};
        var tokensByLineIndex = {};
        for (var i = 0, l = tokens.length; i < l; i++) {
            var token = tokens[i];

            token._tokenIndex = i;

            if (token.type === 'Whitespace') {
                continue;
            }

            // tokens by range
            tokenRangeStartIndex[token.range[0]] = token;
            tokenRangeEndIndex[token.range[1]] = token;

            // tokens by line
            var lineNumber = token.loc.start.line;
            if (!tokensByLineIndex[lineNumber]) {
                tokensByLineIndex[lineNumber] = [];
            }

            tokensByLineIndex[lineNumber].push(token);
        }

        return {
            tokenRangeStartIndex: tokenRangeStartIndex,
            tokenRangeEndIndex: tokenRangeEndIndex,
            tokensByLineIndex: tokensByLineIndex
        };
    },

    /**
     * Returns token using range start from the index.
     *
     * @returns {Object|null}
     */
    getTokenByRangeStart: function(start) {
        return this._tokenRangeStartIndex[start] || null;
    },

    /**
     * Returns token using range end from the index.
     *
     * @returns {Object|null}
     */
    getTokenByRangeEnd: function(end) {
        return this._tokenRangeEndIndex[end] || null;
    },

    /**
     * Returns the first token for the node from the AST.
     *
     * @param {Object} node
     * @returns {Object}
     */
    getFirstNodeToken: function(node) {
        return this.getTokenByRangeStart(node.range[0]);
    },

    /**
     * Returns the last token for the node from the AST.
     *
     * @param {Object} node
     * @returns {Object}
     */
    getLastNodeToken: function(node) {
        return this.getTokenByRangeEnd(node.range[1]);
    },

    /**
     * Returns the first token for the file.
     *
     * @param {Option} [options]
     * @param {Boolean} [options.includeComments=false]
     * @param {Boolean} [options.includeWhitespace=false]
     * @returns {Object}
     */
    getFirstToken: function(options) {
        return this._getTokenFromIndex(0, 1, options);
    },

    /**
     * Returns the last token for the file.
     *
     * @param {Option} [options]
     * @param {Boolean} [options.includeComments=false]
     * @param {Boolean} [options.includeWhitespace=false]
     * @returns {Object}
     */
    getLastToken: function(options) {
        return this._getTokenFromIndex(this._tokens.length - 1, -1, options);
    },

    /**
     * Returns the first token after the given using direction and specified conditions.
     *
     * @param {Number} index
     * @param {Number} direction `1` - forward or `-1` - backwards
     * @param {Object} [options]
     * @param {Boolean} [options.includeComments=false]
     * @param {Boolean} [options.includeWhitespace=false]
     * @returns {Object|null}
     */
    _getTokenFromIndex: function(index, direction, options) {
        while (true) {
            var followingToken = this._tokens[index];

            if (!followingToken) {
                return null;
            }

            if (
                (!followingToken.isComment || (options && options.includeComments)) &&
                (!followingToken.isWhitespace || (options && options.includeWhitespace))
            ) {
                return followingToken;
            }

            index += direction;
        }
    },

    /**
     * Returns the first token before the given.
     *
     * @param {Object} token
     * @param {Object} [options]
     * @param {Boolean} [options.includeComments=false]
     * @param {Boolean} [options.includeWhitespace=false]
     * @returns {Object|null}
     */
    getPrevToken: function(token, options) {
        return this._getTokenFromIndex(token._tokenIndex - 1, -1, options);
    },

    /**
     * Returns the first token after the given.
     *
     * @param {Object} token
     * @param {Object} [options]
     * @param {Boolean} [options.includeComments=false]
     * @param {Boolean} [options.includeWhitespace=false]
     * @returns {Object|null}
     */
    getNextToken: function(token, options) {
        return this._getTokenFromIndex(token._tokenIndex + 1, 1, options);
    },

    /**
     * Returns the first token before the given which matches type (and value).
     *
     * @param {Object} token
     * @param {String} type
     * @param {String} [value]
     * @returns {Object|null}
     */
    findPrevToken: function(token, type, value) {
        var prevToken = this.getPrevToken(token);
        while (prevToken) {
            if (prevToken.type === type && (value === undefined || prevToken.value === value)) {
                return prevToken;
            }

            prevToken = this.getPrevToken(prevToken);
        }

        return prevToken;
    },

    /**
     * Returns the first token after the given which matches type (and value).
     *
     * @param {Object} token
     * @param {String} type
     * @param {String} [value]
     * @returns {Object|null}
     */
    findNextToken: function(token, type, value) {
        var nextToken = this.getNextToken(token);
        while (nextToken) {
            if (nextToken.type === type && (value === undefined || nextToken.value === value)) {
                return nextToken;
            }

            nextToken = this.getNextToken(nextToken);
        }

        return nextToken;
    },

    /**
     * Returns the first token before the given which matches type (and value).
     *
     * @param {Object} token
     * @param {String} value
     * @returns {Object|null}
     */
    findPrevOperatorToken: function(token, value) {
        return this.findPrevToken(token, value in KEYWORD_OPERATORS ? 'Keyword' : 'Punctuator', value);
    },

    /**
     * Returns the first token after the given which matches type (and value).
     *
     * @param {Object} token
     * @param {String} value
     * @returns {Object|null}
     */
    findNextOperatorToken: function(token, value) {
        return this.findNextToken(token, value in KEYWORD_OPERATORS ? 'Keyword' : 'Punctuator', value);
    },

    /**
     * Iterates through the token tree using tree iterator.
     * Calls passed function for every token.
     *
     * @param {Function} cb
     * @param {Object} [tree]
     */
    iterate: function(cb, tree) {
        return treeIterator.iterate(tree || this._tree, cb);
    },

    /**
     * Returns node by its range position from earlier built index.
     *
     * @returns {Object}
     */
    getNodeByRange: function(number) {
        assert(typeof number === 'number', 'requires node range argument');

        var result = {};

        // Look backwards for the first node(s) spanning `number`
        // (possible with this.iterate, but too slow on large files)
        var i = number;
        var nodes;
        do {
            // Escape hatch
            if (i < 0) {
                return result;
            }

            nodes = this._nodesByStartRange[i];
            i--;
        } while (!nodes || nodes[0].range[1] <= number);

        // Return the deepest such node
        for (i = nodes.length - 1; i >= 0; i--) {
            if (nodes[i].range[1] > number) {
                return nodes[i];
            }
        }
    },

    /**
     * Returns nodes by range start index from earlier built index.
     *
     * @param {Object} token
     * @returns {Object[]}
     */
    getNodesByFirstToken: function(token) {
        var result = [];
        if (token && token.range && token.range[0] >= 0) {
            var nodes = this._nodesByStartRange[token.range[0]];
            if (nodes) {
                result = result.concat(nodes);
            }
        }

        return result;
    },

    /**
     * Returns nodes by type(s) from earlier built index.
     *
     * @param {String|String[]} type
     * @returns {Object[]}
     */
    getNodesByType: function(type) {
        if (typeof type === 'string') {
            return this._index[type] || [];
        } else {
            var result = [];
            for (var i = 0, l = type.length; i < l; i++) {
                var nodes = this._index[type[i]];
                if (nodes) {
                    result = result.concat(nodes);
                }
            }

            return result;
        }
    },

    /**
     * Iterates nodes by type(s) from earlier built index.
     * Calls passed function for every matched node.
     *
     * @param {String|String[]} type
     * @param {Function} cb
     * @param {Object} context
     */
    iterateNodesByType: function(type, cb, context) {
        return this.getNodesByType(type).forEach(cb, context || this);
    },

    /**
     * Iterates tokens by type(s) from the token array.
     * Calls passed function for every matched token.
     *
     * @param {String|String[]} type
     * @param {Function} cb
     */
    iterateTokensByType: function(type, cb) {
        var types = (typeof type === 'string') ? [type] : type;
        var typeIndex = {};
        types.forEach(function(type) {
            typeIndex[type] = true;
        });

        this._forEachToken(function(token, index, tokens) {
            if (typeIndex[token.type]) {
                cb(token, index, tokens);
            }
        });
    },

    /**
     * Iterates token by value from the token array.
     * Calls passed function for every matched token.
     *
     * @param {String|String[]} name
     * @param {Function} cb
     */
    iterateTokenByValue: function(name, cb) {
        var names = (typeof name === 'string') ? [name] : name;
        var nameIndex = {};
        names.forEach(function(type) {
            nameIndex[type] = true;
        });

        this._forEachToken(function(token, index, tokens) {
            if (nameIndex.hasOwnProperty(token.value)) {
                cb(token, index, tokens);
            }
        });
    },

    /**
     * Executes callback for each token in token list.
     *
     * @param {Function} cb
     * @private
     */
    _forEachToken: function(cb) {
        var index = 0;
        var tokens = this._tokens;
        while (index < tokens.length) {
            var token = tokens[index];
            cb(token, index, tokens);
            index = token._tokenIndex;
            index++;
        }
    },

    /**
     * Iterates tokens by type and value(s) from the token array.
     * Calls passed function for every matched token.
     *
     * @param {String} type
     * @param {String|String[]} value
     * @param {Function} cb
     */
    iterateTokensByTypeAndValue: function(type, value, cb) {
        var values = (typeof value === 'string') ? [value] : value;
        var valueIndex = {};
        values.forEach(function(type) {
            valueIndex[type] = true;
        });

        this._forEachToken(function(token, index, tokens) {
            if (token.type === type && valueIndex[token.value]) {
                cb(token, index, tokens);
            }
        });
    },

    /**
     * Returns first token for the specified line.
     * Line numbers start with 1.
     *
     * @param {Number} lineNumber
     * @param {Object} [options]
     * @param {Boolean} [options.includeComments = false]
     * @returns {Object|null}
     */
    getFirstTokenOnLine: function(lineNumber, options) {
        var tokensByLine = this._tokensByLineIndex[lineNumber];

        if (!tokensByLine) {
            return null;
        }

        if (options && options.includeComments) {
            return tokensByLine[0];
        }

        for (var i = 0; i < tokensByLine.length; i++) {
            var token = tokensByLine[i];
            if (!token.isComment) {
                return token;
            }
        }

        return null;
    },

    /**
     * Returns last token for the specified line.
     * Line numbers start with 1.
     *
     * @param {Number} lineNumber
     * @param {Object} [options]
     * @param {Boolean} [options.includeComments = false]
     * @returns {Object|null}
     */
    getLastTokenOnLine: function(lineNumber, options) {
        var tokensByLine = this._tokensByLineIndex[lineNumber];

        if (!tokensByLine) {
            return null;
        }

        if (options && options.includeComments) {
            return tokensByLine[tokensByLine.length - 1];
        }

        for (var i = tokensByLine.length - 1; i >= 0; i--) {
            var token = tokensByLine[i];
            if (!token.isComment) {
                return token;
            }
        }

        return null;
    },

    /**
     * Returns which dialect of JS this file supports.
     *
     * @returns {String}
     */
    getDialect: function() {
        if (this._es6) {
            return 'es6';
        }

        if (this._es3) {
            return 'es3';
        }

        return 'es5';
    },

    /**
     * Returns string representing contents of the file.
     *
     * @returns {String}
     */
    getSource: function() {
        return this._source;
    },

    /**
     * Returns token tree, built using esprima.
     *
     * @returns {Object}
     */
    getTree: function() {
        return this._tree;
    },

    /**
     * Returns token list, built using esprima.
     *
     * @returns {Object[]}
     */
    getTokens: function() {
        return this._tokens;
    },

    /**
     * Set token list.
     *
     * @param {Array} tokens
     */
    setTokens: function(tokens) {
        this._tokens = tokens;
    },

    /**
     * Returns comment token list, built using esprima.
     */
    getComments: function() {
        return this._tree.comments;
    },

    /**
     * Returns source filename for this object representation.
     *
     * @returns {String}
     */
    getFilename: function() {
        return this._filename;
    },

    /**
     * Returns array of source lines for the file.
     *
     * @returns {String[]}
     */
    getLines: function() {
        return this._lines;
    },

    /**
     * Returns analyzed scope.
     *
     * @returns {Object}
     */
    getScope: function() {
        if (!this._scope) {
            this._scope = escope.analyze(this._tree, {
                ecmaVersion: 6,
                ignoreEval: true,
                sourceType: 'module'
            });
        }

        return this._scope;
    },

    /**
     * Returns array of source lines for the file with comments removed.
     *
     * @returns {Array}
     */
    getLinesWithCommentsRemoved: function() {
        var lines = this.getLines().concat();

        this.getComments().concat().reverse().forEach(function(comment) {
            var startLine = comment.loc.start.line;
            var startCol = comment.loc.start.column;
            var endLine = comment.loc.end.line;
            var endCol = comment.loc.end.column;
            var i = startLine - 1;

            if (startLine === endLine) {
                // Remove tralling spaces (see gh-1968)
                lines[i] = lines[i].replace(/\*\/\s+/, '\*\/');
                lines[i] = lines[i].substring(0, startCol) + lines[i].substring(endCol);
            } else {
                lines[i] = lines[i].substring(0, startCol);
                for (var x = i + 1; x < endLine - 1; x++) {
                    lines[x] = '';
                }

                lines[x] = lines[x].substring(endCol);
            }
        });

        return lines;
    },

    /**
     * Renders JS-file sources using token list.
     *
     * @returns {String}
     */
    render: function() {
        var result = '';

        // For-loop for maximal speed.
        for (var i = 0; i < this._tokens.length; i++) {
            var token = this._tokens[i];

            switch (token.type) {
                // Line-comment: // ...
                case 'Line':
                    result += '//' + token.value;
                    break;

                // Block-comment: /* ... */
                case 'Block':
                    result += '/*' + token.value + '*/';
                    break;

                default:
                    result += token.value;
            }
        }

        return result;
    },

    /**
     * Returns list of parse errors.
     *
     * @returns {Error[]}
     */
    getParseErrors: function() {
        return this._parseErrors;
    },

    /**
     * Builds token list using both code tokens and comment-tokens.
     *
     * @returns {Object[]}
     * @private
     */
    _buildTokenList: function(codeTokens, commentTokens) {
        var result = [];
        var codeQueue = codeTokens.concat();
        var commentQueue = commentTokens.concat();
        while (codeQueue.length > 0 || commentQueue.length > 0) {
            if (codeQueue.length > 0 && (!commentQueue.length || commentQueue[0].range[0] > codeQueue[0].range[0])) {
                result.push(codeQueue.shift());
            } else {
                var commentToken = commentQueue.shift();
                commentToken.isComment = true;
                result.push(commentToken);
            }
        }

        return result;
    },

    /**
     * Adds JSCS-specific EOF (end of file) token.
     *
     * @private
     */
    _addEOFToken: function(hasErrors) {
        var loc = hasErrors ?
            {line: 0, column: 0} :
            {
                line: this._lines.length,
                column: this._lines[this._lines.length - 1].length
            };
        this._tokens.push({
            type: 'EOF',
            value: '',
            range: hasErrors ? [0, 0] : [this._source.length, this._source.length + 1],
            loc: {start: loc, end: loc}
        });
    },

    /**
     * Applies whitespace information to the token list.
     *
     * @param {Object[]} tokens
     * @param {String} source
     * @private
     */
    _addWhitespaceTokens: function(tokens, source) {
        var prevPos = 0;
        var result = [];

        // For-loop for maximal speed.
        for (var i = 0; i < tokens.length; i++) {
            var token = tokens[i];
            var rangeStart = token.range[0];
            if (rangeStart !== prevPos) {
                var whitespace = source.substring(prevPos, rangeStart);
                result.push({
                    type: 'Whitespace',
                    value: whitespace,
                    isWhitespace: true
                });
            }

            result.push(token);

            prevPos = token.range[1];
        }

        return result;
    },

    /**
     * Builds node indexes using
     *  i. node type as the key
     *  ii. node start range as the key
     *
     * @returns {{nodesByType: {}, nodesByStartRange: {}}}
     * @private
     */
    _buildNodeIndex: function() {
        var nodesByType = {};
        var nodesByStartRange = {};
        this.iterate(function(node, parentNode, parentCollection) {
            var type = node.type;

            node.parentNode = parentNode;
            node.parentCollection = parentCollection;
            (nodesByType[type] || (nodesByType[type] = [])).push(node);

            // this part builds a node index that uses node start ranges as the key
            var startRange = node.range[0];
            (nodesByStartRange[startRange] || (nodesByStartRange[startRange] = [])).push(node);
        });

        return {
            nodesByType: nodesByType,
            nodesByStartRange: nodesByStartRange
        };
    },

    /**
     * Temporary fix (I hope, two years and counting :-) for esprima/babylon tokenizer
     * (https://github.com/jquery/esprima/issues/317)
     * Fixes #83, #180
     *
     * @private
     */
    _fixEsprimaIdentifiers: function() {
        var _this = this;

        this.iterateNodesByType(['Property', 'MethodDefinition', 'MemberExpression'], function(node) {
            switch (node.type) {
                case 'Property':
                    convertKeywordToIdentifierIfRequired(node.key);
                    break;
                case 'MethodDefinition':
                    convertKeywordToIdentifierIfRequired(node.key);
                    break;
                case 'MemberExpression':
                    convertKeywordToIdentifierIfRequired(node.property);
                    break;
            }
        });

        function convertKeywordToIdentifierIfRequired(node) {
            var token = _this.getTokenByRangeStart(node.range[0]);

            if (token.type === 'Keyword') {
                token.type = 'Identifier';
            }
        }
    }
};

/**
 * Parses a JS-file.
 *
 * @param {String} source
 * @param {Object} esprima
 * @param {Object} [esprimaOptions]
 * @returns {Object}
 */
function parseJavaScriptSource(source, esprima, esprimaOptions) {
    var finalEsprimaOptions = {
        tolerant: true
    };

    if (esprimaOptions) {
        for (var key in esprimaOptions) {
            finalEsprimaOptions[key] = esprimaOptions[key];
        }
    }

    // Set required options
    finalEsprimaOptions.loc = true;
    finalEsprimaOptions.range = true;
    finalEsprimaOptions.comment = true;
    finalEsprimaOptions.tokens = true;
    finalEsprimaOptions.sourceType = 'module';

    var hashbang = source.indexOf('#!') === 0;
    var tree;

    // Convert bin annotation to a comment
    if (hashbang) {
        source = '//' + source.substr(2);
    }

    var instrumentationData = {};
    var hasInstrumentationData = false;

    // Process special case code like iOS instrumentation imports: `#import 'abc.js';`
    source = source.replace(/^#!?[^\n]+\n/gm, function(str, pos) {
        hasInstrumentationData = true;
        instrumentationData[pos] = str.substring(0, str.length - 1);
        return '//' + str.slice(2);
    });

    var gritData = {};
    var hasGritData = false;

    // Process grit tags like `<if ...>` and `<include ...>`
    source = source.replace(/^\s*<\/?\s*(if|include)(?!\w)[^]*?>/gim, function(str, p1, pos) {
        hasGritData = true;
        gritData[pos] = str.substring(0, str.length - 1);

        // Cut 4 characters to save correct line/column info for surrounding code
        return '/*' + str.slice(4) + '*/';
    });

    tree = esprima.parse(source, finalEsprimaOptions);

    // Change the bin annotation comment
    if (hashbang) {
        tree.comments[0].type = 'Hashbang';
        tree.comments[0].value = '#!' + tree.comments[0].value;
    }

    if (hasInstrumentationData) {
        tree.comments.forEach(function(token) {
            var rangeStart = token.range[0];
            if (instrumentationData.hasOwnProperty(rangeStart)) {
                token.type = 'InstrumentationDirective';
                token.value = instrumentationData[rangeStart];
            }
        });
    }

    if (hasGritData) {
        tree.comments.forEach(function(token) {
            var rangeStart = token.range[0];
            if (gritData.hasOwnProperty(rangeStart)) {
                token.type = 'GritTag';
                token.value = gritData[rangeStart];
            }
        });
    }

    return tree;
}

module.exports = JsFile;

},{"./tree-iterator":165,"assert":171,"escope":676}],4:[function(require,module,exports){
/**
 * Requires that a function expression be named.
 * Named functions provide more information in the error stack trace than anonymous functions.
 *
 * This option does not help if you use Arrow functions (ES6) which are always anonymous.
 *
 * Type: `Boolean`
 *
 * Value: `true`
 *
 * #### Example
 *
 * ```js
 * "disallowAnonymousFunctions": true
 * ```
 *
 * ##### Valid
 *
 * ```js
 * var a = function foo(){
 *
 * };
 *
 * $('#foo').click(function bar(){
 *
 * });
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * var a = function(){
 *
 * };
 *
 * $('#foo').click(function(){
 *
 * });
 * ```
 */

var assert = require('assert');

module.exports = function() {};

module.exports.prototype = {
    configure: function(options) {
        assert(
            options === true,
            this.getOptionName() + ' option requires a true value or should be removed'
        );
    },

    getOptionName: function() {
        return 'disallowAnonymousFunctions';
    },

    check: function(file, errors) {
        file.iterateNodesByType(['FunctionExpression', 'FunctionDeclaration'], function(node) {
            if (node.id === null) {
                errors.add('Anonymous functions need to be named', node.loc.start);
            }
        });
    }
};

},{"assert":171}],5:[function(require,module,exports){
/**
 * Disallows arrow functions.
 *
 * Why enable this rule? Arrow functions might cause more problems than they
 * solve:
 *
 * - Object-orientation may be better without ECMAScript's `this`.
 * - You can't name an arrow function.
 * - Arrow functions' syntax can cause maintenance issues; see
 *   `disallowShorthandArrowFunctions`.
 * - Arrow functions shouldn't be used on prototypes, as objects' methods,
 *   as event listeners, or as anything polymorhpic- or mixin-related. See
 *   [here](https://gist.github.com/qubyte/43e0093274e793cc82ba#gistcomment-1292183).
 *
 * Type: `Boolean`
 *
 * Value: `true`
 *
 * Version: `ES6`
 *
 * #### Example
 *
 * ```js
 * "disallowArrowFunctions": true
 * ```
 *
 * ##### Valid
 *
 * ```js
 * // function expression in a callback
 * [1, 2, 3].map(function (x) {
 *     return x * x;
 * });
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * // arrow function
 * [1, 2, 3].map((x) => {
 *     return x * x;
 * });
 * ```
 */

var assert = require('assert');

module.exports = function() {};

module.exports.prototype = {
    configure: function(options) {
        assert(
            options === true,
            this.getOptionName() + ' option requires a true value or should be removed'
        );
    },

    getOptionName: function() {
        return 'disallowArrowFunctions';
    },

    check: function(file, errors) {
        file.iterateNodesByType(['ArrowFunctionExpression'], function(node) {
            errors.add('Do not use arrow functions', node.loc.start);
        });
    }
};

},{"assert":171}],6:[function(require,module,exports){
/**
 * Requires the first alphabetical character of a comment to be lowercase.
 *
 * Type: `Boolean`
 *
 * Value: `true`
 *
 * #### Example
 *
 * `"disallowCapitalizedComments": true`
 *
 * Valid:
 *
 * ```
 * // valid
 * //valid
 *
 * /*
 *   valid
 *  *\/
 *
 * /**
 *  * valid
 *  *\/
 *
 * // 123 or any non-alphabetical starting character
 * ```
 *
 * Invalid:
 * ```
 * // Invalid
 * //Invalid
 * /** Invalid *\/
 * /**
 *  * Invalid
 *  *\/
 * ```
 */

var assert = require('assert');

module.exports = function() {};

module.exports.prototype = {
    configure: function(options) {
        assert(
            options === true,
            this.getOptionName() + ' option requires a true value or should be removed'
        );
    },

    getOptionName: function() {
        return 'disallowCapitalizedComments';
    },

    check: function(file, errors) {
        var letterPattern = require('../../patterns/L');
        var lowerCasePattern = require('../../patterns/Ll');

        file.iterateTokensByType(['Line', 'Block'], function(comment) {
            var stripped = comment.value.replace(/[\n\s\*]/g, '');
            var firstChar = stripped[0];

            if (letterPattern.test(firstChar) && !lowerCasePattern.test(firstChar)) {
                errors.add(
                    'Comments must start with a lowercase letter',
                    comment.loc.start
                );
            }
        });
    }
};

},{"../../patterns/L":948,"../../patterns/Ll":949,"assert":171}],7:[function(require,module,exports){
/**
 * Disallows commas as last token on a line in lists.
 *
 * Type: `Boolean`, `Object`
 *
 * Values:
 *  - `true` for default behavior (strict mode, comma on the same line)
 *  - `Object`:
 *    - `'allExcept'` array of exceptions:
 *       - `'function'` ignores objects if one of their values is a function expression
 *
 * JSHint: [`laxcomma`](http://www.jshint.com/docs/options/#laxcomma)
 *
 * #### Example
 *
 * ```js
 * "disallowCommaBeforeLineBreak": true
 * ```
 *
 * ##### Valid for `true`
 *
 * ```js
 * var x = {
 *     one: 1
 *     , two: 2
 * };
 * var y = {three: 3, four: 4};
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * var x = {
 *     one: 1,
 *     two: 2
 * };
 * ```
 *
 * ##### Valid for `{"allExcept": ["function"]}`
 *
 * ```js
 * var x = {
 *     one: 1,
 *     two: function() {}
 * };
 * ```
 *
 */

var assert = require('assert');

module.exports = function() {};

module.exports.prototype = {

    configure: function(options) {
        var optionName = this.getOptionName();

        if (typeof options !== 'object') {
            assert(
                options === true,
                optionName + ' option requires either a true value or an object'
            );

            var _options = {allExcept: []};
            return this.configure(_options);
        }

        assert(
            Array.isArray(options.allExcept),
            'Property `allExcept` in ' + optionName + ' should be an array of strings'
        );

        this._exceptFunction = options.allExcept.indexOf('function') > -1;
    },

    getOptionName: function() {
        return 'disallowCommaBeforeLineBreak';
    },

    check: function(file, errors) {
        var exceptFunction = this._exceptFunction;

        function canSkip(token) {
            var node = file.getNodeByRange(token.range[0]);
            if (node.loc.start.line === node.loc.end.line) {
                return true;
            }

            // exception for function params
            if (node.params &&
                node.params[0].loc.start.line === node.params[node.params.length - 1].loc.end.line) {
                return true;
            }

            // See #1841
            if (!exceptFunction || !node.properties) {
                return false;
            }

            return node.properties.some(function(property) {
                return property.value.type === 'FunctionExpression';
            });
        }

        file.iterateTokensByTypeAndValue('Punctuator', ',', function(token) {
            var nextToken = file.getNextToken(token);

            if (canSkip(token) || nextToken.value === ',') {
                return;
            }

            errors.assert.sameLine({
                token: token,
                nextToken: nextToken,
                message: 'Commas should be placed on the same line as value'
            });

            errors.assert.differentLine({
                token: file.getPrevToken(token),
                nextToken: token,
                message: 'Commas should be placed on new line'
            });
        });
    }

};

},{"assert":171}],8:[function(require,module,exports){
/**
 * Disallows curly braces after statements.
 *
 * Types: `Array` or `Boolean`
 *
 * Values: Array of quoted keywords or `true` to disallow curly braces after the following keywords:
 *
 * #### Example
 *
 * ```js
 * "disallowCurlyBraces": [
 *     "if",
 *     "else",
 *     "while",
 *     "for",
 *     "do",
 *     "with"
 * ]
 * ```
 *
 * ##### Valid
 *
 * ```js
 * if (x) x++;
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * if (x) {
 *     x++;
 * }
 * ```
 */

var assert = require('assert');
var defaultKeywords = require('../utils').curlyBracedKeywords;

module.exports = function() {};

module.exports.prototype = {

    configure: function(statementTypes) {
        assert(
            Array.isArray(statementTypes) || statementTypes === true,
            this.getOptionName() + ' option requires array or true value'
        );

        if (statementTypes === true) {
            statementTypes = defaultKeywords;
        }

        this._typeIndex = {};
        statementTypes.forEach(function(type) {
            this._typeIndex[type] = true;
        }.bind(this));
    },

    getOptionName: function() {
        return 'disallowCurlyBraces';
    },

    check: function(file, errors) {

        function isSingleBlockStatement(node) {
            return node && node.type === 'BlockStatement' &&
            node.body.length === 1;
        }

        function addError(typeString, entity) {
            errors.add(
                typeString + ' statement with extra curly braces',
                entity.loc.start.line,
                entity.loc.start.column
            );
        }

        function checkBody(type, typeString) {
            file.iterateNodesByType(type, function(node) {
                if (isSingleBlockStatement(node.body)) {
                    addError(typeString, node);
                }
            });
        }

        var typeIndex = this._typeIndex;

        if (typeIndex.if || typeIndex.else) {
            file.iterateNodesByType('IfStatement', function(node) {
                if (typeIndex.if && isSingleBlockStatement(node.consequent)) {
                    addError('If', node);
                }
                if (typeIndex.else && isSingleBlockStatement(node.alternate)) {
                    addError('Else', file.getPrevToken(file.getFirstNodeToken(node.alternate)));
                }
            });
        }

        if (typeIndex.while) {
            checkBody('WhileStatement', 'While');
        }

        if (typeIndex.for) {
            checkBody('ForStatement', 'For');
            checkBody('ForInStatement', 'For in');
            checkBody('ForOfStatement', 'For of');
        }

        if (typeIndex.do) {
            checkBody('DoWhileStatement', 'Do while');
        }

        if (typeIndex.with) {
            checkBody('WithStatement', 'With');
        }
    }

};

},{"../utils":166,"assert":171}],9:[function(require,module,exports){
/**
 * Disallows identifiers that start or end in `_`.
 *
 * Types: `Boolean` or `Object`
 *
 * Values:
 *  - `true`
 *  - `Object`:
 *     - `allExcept`: array of quoted identifiers
 *
 * JSHint: [`nomen`](http://www.jshint.com/docs/options/#nomen)
 *
 * Some popular identifiers are automatically listed as exceptions:
 *
 *  - `__proto__` (javascript)
 *  - `_` (underscore.js)
 *  - `__filename` (node.js global)
 *  - `__dirname` (node.js global)
 *  - `super_` (node.js, used by
 *    [`util.inherits`](http://nodejs.org/docs/latest/api/util.html#util_util_inherits_constructor_superconstructor))
 *
 * #### Example
 *
 * ```js
 * "disallowDanglingUnderscores": { "allExcept": ["_exception"] }
 * ```
 *
 * ##### Valid
 *
 * ```js
 * var x = 1;
 * var o = obj.__proto__;
 * var y = _.extend;
 * var z = __dirname;
 * var w = __filename;
 * var x_y = 1;
 * var v = _exception;
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * var _x = 1;
 * var x_ = 1;
 * var x_y_ = 1;
 * ```
 */

var assert = require('assert');

module.exports = function() {};

module.exports.prototype = {

    configure: function(identifiers) {
        assert(
            identifiers === true ||
            typeof identifiers === 'object',
            this.getOptionName() + ' option requires the value `true` ' +
            'or an object with String[] `allExcept` property'
        );

        // verify first item in `allExcept` property in object (if it's an object)
        assert(
            typeof identifiers !== 'object' ||
            Array.isArray(identifiers.allExcept) &&
            typeof identifiers.allExcept[0] === 'string',
            'Property `allExcept` in ' + this.getOptionName() + ' should be an array of strings'
        );

        var isTrue = identifiers === true;
        var defaultIdentifiers = [
            '__proto__',
            '_',
            '__dirname',
            '__filename',
            'super_'
        ];

        if (isTrue) {
            identifiers = defaultIdentifiers;
        } else {
            identifiers = (identifiers.allExcept).concat(defaultIdentifiers);
        }

        this._identifierIndex = identifiers;
    },

    getOptionName: function() {
        return 'disallowDanglingUnderscores';
    },

    check: function(file, errors) {
        var allowedIdentifiers = this._identifierIndex;

        file.iterateTokensByType('Identifier', function(token) {
            var value = token.value;

            if ((value[0] === '_' || value.slice(-1) === '_') &&
                allowedIdentifiers.indexOf(value) < 0
            ) {
                errors.add(
                    'Invalid dangling underscore found',
                    token.loc.start.line,
                    token.loc.start.column
                );
            }
        });
    }

};

},{"assert":171}],10:[function(require,module,exports){
/**
 * Disallows empty blocks (except for catch blocks).
 *
 * Type: `Boolean` or `Object`
 *
 * Values:
 *  - `true` for default behavior (strict mode, no empty blocks allowed)
 *  - `Object`:
 *    - `'allExcept'` array of exceptions:
 *       - `'comments'` blocks containing only comments are not considered empty
 *
 * JSHint: [`noempty`](http://jshint.com/docs/options/#noempty)
 *
 * #### Example
 *
 * ```js
 * "disallowEmptyBlocks": true
 * ```
 *
 * ##### Valid
 *
 * ```js
 * if ( a == b ) { c = d; }
 * try { a = b; } catch( e ){}
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * if ( a == b ) { } else { c = d; }
 * ```
 */

var assert = require('assert');

module.exports = function() {};

module.exports.prototype = {

    configure: function(options) {
        var optionName = this.getOptionName();

        if (typeof options !== 'object') {
            assert(
                options === true,
                optionName + ' option requires a true value or an object like: { allExcept: [\'comments\'] }'
            );

            var _options = {
                allExcept: []
            };
            return this.configure(_options);
        }

        assert(
            Array.isArray(options.allExcept),
            'Property `allExcept` in ' + optionName + ' should be an array of strings'
        );

        this._exceptComments = options.allExcept.indexOf('comments') > -1;
    },

    getOptionName: function() {
        return 'disallowEmptyBlocks';
    },

    check: function(file, errors) {
        var exceptComments = this._exceptComments;

        function canSkip(token) {
            if (!exceptComments) {
                return false;
            }
            var canSkipToken = false;
            file.getComments().forEach(function(comment) {
                if (comment.loc.start.line >= token.loc.start.line &&
                    comment.loc.end.line <= token.loc.end.line) {
                    canSkipToken = true;
                }
            });
            return canSkipToken;
        }

        file.iterateNodesByType('BlockStatement', function(node) {
            if (node.body.length) {
                return true;
            }

            if (canSkip(node)) {
                return true;
            }

            if (node.parentNode.type !== 'CatchClause' &&
                node.parentNode.type !== 'FunctionDeclaration' &&
                node.parentNode.type !== 'FunctionExpression' &&
                node.parentNode.type !== 'ArrowFunctionExpression') {
                errors.add('Empty block found', node.loc.end);
            }
        });
    }
};

},{"assert":171}],11:[function(require,module,exports){
/**
 * Disallows function declarations.
 *
 * Type: `Boolean`
 *
 * Value: `true`
 *
 * #### Example
 *
 * ```js
 * "disallowFunctionDeclarations": true
 * ```
 *
 * ##### Valid
 *
 * ```js
 * var expressed = function() {
 *
 * };
 *
 * var expressed = function deeply() {
 *
 * };
 *
 * $('#foo').click(function bar() {
 *
 * });
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * function stated() {
 *
 * }
 * ```
 */

var assert = require('assert');

module.exports = function() {};

module.exports.prototype = {
    configure: function(options) {
        assert(
            options === true,
            this.getOptionName() + ' option requires a true value or should be removed'
        );
    },

    getOptionName: function() {
        return 'disallowFunctionDeclarations';
    },

    check: function(file, errors) {
        file.iterateNodesByType('FunctionDeclaration', function(node) {
            errors.add('Illegal function declaration', node.loc.start);
        });
    }
};

},{"assert":171}],12:[function(require,module,exports){
/**
 * Disallows identical destructuring names for the key and value in favor of using shorthand destructuring.
 *
 * Type: `Boolean`
 *
 * Value: `true`
 *
 * #### Example
 *
 * ```js
 * "disallowIdenticalDestructuringNames": true
 * ```
 *
 * ##### Valid for mode `true`
 *
 * ```js
 * var {left, top} = obj; // shorthand
 * var {left, top: topper} = obj; // different identifier
 * let { [key]: key } = obj; // computed property
 * ```
 *
 * ##### Invalid for mode `true`
 *
 * ```js
 * var {left: left, top: top} = obj;
 * ```
 */

var assert = require('assert');

module.exports = function() {};

module.exports.prototype = {
    configure: function(options) {
        assert(
            options === true,
            this.getOptionName() + ' option requires a true value or should be removed'
        );
    },

    getOptionName: function() {
        return 'disallowIdenticalDestructuringNames';
    },

    check: function(file, errors) {
        file.iterateNodesByType(['ObjectPattern'], function(node) {
            var props = node.properties;
            for (var i = 0; i < props.length; i++) {
                var prop = props[i];
                if (prop.type === 'Property' && !prop.shorthand && !prop.computed &&
                    prop.key.name === prop.value.name) {
                    errors.add('Use the shorthand form of destructuring instead', prop.loc.start);
                }
            }
        });
    }
};

},{"assert":171}],13:[function(require,module,exports){
/**
 * Disallows a specified set of identifier names.
 *
 * Type: `Array`
 *
 * Values: Array of strings, which should be disallowed as identifier names
 *
 * #### Example
 *
 * ```js
 * "disallowIdentifierNames": ['temp', 'foo']
 * ```
 *
 * ##### Valid
 *
 * ```js
 * var good = 1;
 * object['fine'] = 2;
 * object.fine = 3;
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * var temp = 1;
 * object['foo'] = 2;
 * object.foo = 3;
 * ```
 */

var assert = require('assert');

module.exports = function() {};

module.exports.prototype = {

    configure: function(identifiers) {
        assert(
            Array.isArray(identifiers),
            'disallowIdentifierNames option requires an array'
        );

        this._identifierIndex = {};
        for (var i = 0, l = identifiers.length; i < l; i++) {
            this._identifierIndex[identifiers[i]] = true;
        }
    },

    getOptionName: function() {
        return 'disallowIdentifierNames';
    },

    check: function(file, errors) {
        var disallowedIdentifiers = this._identifierIndex;

        file.iterateNodesByType('Identifier', function(node) {
            if (Object.prototype.hasOwnProperty.call(disallowedIdentifiers, node.name)) {
                errors.add('Illegal Identifier name: ' + node.name, node.loc.start);
            }
        });

        file.iterateNodesByType('MemberExpression', function(node) {
            if (node.property.type === 'Literal') {
                if (Object.prototype.hasOwnProperty.call(disallowedIdentifiers, node.property.value)) {
                    errors.add('Illegal Identifier name: ' + node.property.value, node.property.loc.start);
                }
            }
        });

    }

};

},{"assert":171}],14:[function(require,module,exports){
/**
 * Disallows implicit type conversion.
 *
 * Type: `Array`
 *
 * Values: Array of quoted types
 *
 * #### Example
 *
 * ```js
 * "disallowImplicitTypeConversion": ["numeric", "boolean", "binary", "string"]
 * ```
 *
 * ##### Valid
 *
 * ```js
 * x = Boolean(y);
 * x = Number(y);
 * x = String(y);
 * x = s.indexOf('.') !== -1;
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * x = !!y;
 * x = +y;
 * x = '' + y;
 * x = ~s.indexOf('.');
 * ```
 */

var assert = require('assert');

module.exports = function() {};

module.exports.prototype = {

    configure: function(types) {
        assert(Array.isArray(types), this.getOptionName() + ' option requires array value');
        this._typeIndex = {};
        for (var i = 0, l = types.length; i < l; i++) {
            this._typeIndex[types[i]] = true;
        }
    },

    getOptionName: function() {
        return 'disallowImplicitTypeConversion';
    },

    check: function(file, errors) {
        var types = this._typeIndex;
        if (types.numeric || types.boolean || types.binary) {
            file.iterateNodesByType('UnaryExpression', function(node) {
                if (types.numeric && node.operator === '+') {
                    errors.add('Implicit numeric conversion', node.loc.start);
                }
                if (types.binary && node.operator === '~') {
                    errors.add('Implicit binary conversion', node.loc.start);
                }
                if (types.boolean &&
                    node.operator === '!' &&
                    node.argument.type === 'UnaryExpression' &&
                    node.argument.operator === '!'
                ) {
                    errors.add('Implicit boolean conversion', node.loc.start);
                }
            });
        }
        if (types.string) {
            file.iterateNodesByType('BinaryExpression', function(node) {

                if (node.operator !== '+') {
                    return;
                }

                // Do not report concatination for same string literals (#1538)
                if (node.left.type === node.right.type) {
                    return;
                }

                if (
                    (node.left.type === 'Literal' && node.left.value === '') ||
                    (node.right.type === 'Literal' && node.right.value === '')
                ) {
                    errors.add('Implicit string conversion', node.loc.start);
                }
            });
        }
    }

};

},{"assert":171}],15:[function(require,module,exports){
/**
 * Disallows keywords in your comments, such as TODO or FIXME
 *
 * Types: `Boolean`, `String` or `Array`
 *
 * Values:
 * - `true`
 * - `'\b(word1|word2)\b'`
 * - `['word1', 'word2']`
 *
 * #### Examples
 *
 * ```js
 * "disallowKeywordsInComments": true
 * "disallowKeywordsInComments": "\\b(word1|word2)\\b"
 * "disallowKeywordsInComments": ["word1", "word2"]
 * ```
 *
 * #### Invalid:
 * ```
 * // ToDo
 * //TODO
 * /** fixme *\/
 * /**
 *  * FIXME
 *  *\/
 * ```
 */

var assert = require('assert');

function getCommentErrors(comment, keywordRegEx) {
    var splitComment = comment.value.split('\n');
    var errors = [];

    splitComment.forEach(function(commentNode, index) {
        var lineIndex = index;
        var matches = commentNode.match(keywordRegEx);
        var lastIndex = -1;

        if (!matches) { return; }

        errors = errors.concat(matches.map(function(match) {
            lastIndex++;
            lastIndex = commentNode.indexOf(match, lastIndex);

            // line + lineIndex because comment block was split at new lines
            //   will place carat at correct place within multiline comment
            // foundAtIndex += 2 because comment opening is stripped
            //   +2 finds accurate carat position on opening line comment
            return {
                line: comment.loc.start.line + lineIndex,
                column: lastIndex + (lineIndex > 0 ? 0 : 2)
            };
        }));
    });

    return errors;
}

module.exports = function() {};

module.exports.prototype = {
    configure: function(keywords) {
        this._message = 'Comments cannot contain the following keywords: ';
        this._keywords = ['todo', 'fixme'];

        switch (true) {
            case Array.isArray(keywords):
                // use the array of strings provided to build RegExp pattern
                this._keywords = keywords;
                /* falls through */
            case keywords:
                // use default keywords
                this._message += this._keywords.join(', ');
                this._keywordRegEx = new RegExp('\\b(' + this._keywords.join('|') + ')\\b', 'gi');
                break;
            case typeof keywords === 'string':
                // use string passed in as the RegExp pattern
                this._message = 'Comments cannot contain keywords based on the expression you provided';
                this._keywordRegEx = new RegExp(keywords, 'gi');
                break;
            default:
                assert(false, this.getOptionName() + ' option requires a true value, a string or an array');
        }
    },

    getOptionName: function() {
        return 'disallowKeywordsInComments';
    },

    check: function(file, errors) {
        file.iterateTokensByType(['Line', 'Block'], function(comment) {
            getCommentErrors(comment, this._keywordRegEx).forEach(function(errorObj) {
                errors.add(this._message, errorObj);
            }.bind(this));
        }.bind(this));
    }
};

},{"assert":171}],16:[function(require,module,exports){
/**
 * Disallows placing keywords on a new line.
 *
 * Types: `Array`
 *
 * Values:
 *
 * - `Array` specifies quoted keywords which are disallowed from being placed on a new line
 *
 * #### Example
 *
 * ```js
 * "disallowKeywordsOnNewLine": ["else"]
 * ```
 *
 * ##### Valid
 *
 * ```js
 * if (x < 0) {
 *     x++;
 * } else {
 *     x--;
 * }
 * ```
 * ```js
 * if (x < 0)
 *     x++;
 * else
 *     x--;
 * ```
 * ```js
 * if (x < 0) {
 *     x++;
 * }
 * // comments
 * else {
 *     x--;
 * }
 * ```
 * ```js
 * do {
 *     x++;
 * } while(x < 0);
 * ```
 * ```js
 * do
 *     x++;
 * while(x < 0);
 * ```
 * ```js
 * do {
 *     x++;
 * }
 * // comments
 * while(x < 0);
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * if (x < 0) {
 *     x++;
 * }
 * else {
 *     x--;
 * }
 * ```
 */

var assert = require('assert');

function isPreviousTokenAComment(token, file) {
    var prevToken = file.getPrevToken(token, {includeComments: true});
    return (prevToken.type === 'Line' || prevToken.type === 'Block');
}

module.exports = function() {};

module.exports.prototype = {

    configure: function(keywords) {
        assert(Array.isArray(keywords), this.getOptionName() + ' option requires array value');
        this._keywords = keywords;
    },

    getOptionName: function() {
        return 'disallowKeywordsOnNewLine';
    },

    check: function(file, errors) {
        file.iterateTokensByTypeAndValue('Keyword', this._keywords, function(token) {
            var prevToken = file.getPrevToken(token);

            if (token.value === 'else') {
                if (prevToken.value !== '}') {
                    // Special case for #905, even though it contradicts rule meaning,
                    // it makes more sense that way.
                    return;
                }

                if (isPreviousTokenAComment(token, file)) {
                    // Special case for #1421, to handle comments before the else
                    return;
                }
            }

            // Special cases for #885, using while as the keyword contradicts rule meaning
            // but it is more efficient and reduces complexity of the code in this rule
            if (token.value === 'while') {
                var nodes = file.getNodesByFirstToken(token);

                if (nodes.length === 0) {
                    // "while" that is part of a do will not return nodes as it is not a start token
                    if (prevToken.value !== '}') {
                        // allow "while" that is part of a "do while" with no braces to succeed
                        return;
                    }

                    if (isPreviousTokenAComment(token, file)) {
                        // Special case for #1421, to handle comments before the "while" of a "do while"
                        return;
                    }
                } else {
                    // it is a "while" statement that is not part of a "do while"
                    // , allow it to succeed even though it contradicts rule meaning
                    return;
                }
            }

            errors.assert.sameLine({
                token: prevToken,
                nextToken: token
            });
        });
    }

};

},{"assert":171}],17:[function(require,module,exports){
/**
 * Disallows usage of specified keywords.
 *
 * Type: `Array`
 *
 * Values: Array of quoted keywords
 *
 * #### Example
 *
 * ```js
 * "disallowKeywords": ["with"]
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * with (x) {
 *     prop++;
 * }
 * ```
 */

var assert = require('assert');

module.exports = function() {};

module.exports.prototype = {

    configure: function(keywords) {
        assert(Array.isArray(keywords), this.getOptionName() + ' option requires array value');
        this._keywords = keywords;
    },

    getOptionName: function() {
        return 'disallowKeywords';
    },

    check: function(file, errors) {
        file.iterateTokensByTypeAndValue('Keyword', this._keywords, function(token) {
            errors.add(
                'Illegal keyword: ' + token.value,
                token.loc.start
            );
        });
    }

};

},{"assert":171}],18:[function(require,module,exports){
/**
 * Requires lines to not contain both spaces and tabs consecutively,
 * or spaces after tabs only for alignment if "smart"
 *
 * Types: `Boolean` or `String`
 *
 * Values: `true` or `"smart"`
 *
 * JSHint: [`smarttabs`](http://www.jshint.com/docs/options/#smarttabs)
 *
 * #### Example
 *
 * ```js
 * "disallowMixedSpacesAndTabs": true
 * ```
 *
 * ##### Valid example for mode `true`
 *
 * ```js
 * \tvar foo = "blah blah";
 * \s\s\s\svar foo = "blah blah";
 * \t/**
 * \t\s*
 * \t\s*\/ //a single space to align the star in a multi-line comment is allowed
 * ```
 *
 * ##### Invalid example for mode `true`
 *
 * ```js
 * \t\svar foo = "blah blah";
 * \s\tsvar foo = "blah blah";
 * ```
 *
 * ##### Valid example for mode `"smart"`
 *
 * ```js
 * \tvar foo = "blah blah";
 * \t\svar foo = "blah blah";
 * \s\s\s\svar foo = "blah blah";
 * \t/**
 * \t\s*
 * \t\s*\/ //a single space to align the star in a multi-line comment is allowed
 * ```
 *
 * ##### Invalid example for mode `"smart"`
 *
 * ```js
 * \s\tsvar foo = "blah blah";
 * ```
 */

var assert = require('assert');

module.exports = function() {};

module.exports.prototype = {

    configure: function(options) {
        assert(
            options === true || options === 'smart',
            this.getOptionName() + ' option requires a true value or "smart"'
        );

        this._options = options;
    },

    getOptionName: function() {
        return 'disallowMixedSpacesAndTabs';
    },

    check: function(file, errors) {
        var test = this._options === true ?
            (/ \t|\t [^\*]|\t $/) :
            (/ \t/);

        file.getLinesWithCommentsRemoved().forEach(function(line, i) {
            if (line.match(test)) {
                errors.add('Mixed spaces and tabs found', i + 1, 0);
            }
        });
    }

};

},{"assert":171}],19:[function(require,module,exports){
/**
 * Disallows the test, consequent and alternate to be on separate lines when using the ternary operator.
 *
 * Types: `Boolean`
 *
 * #### Example
 *
 * ```js
 * "disallowMultiLineTernary": true
 * ```
 *
 * ##### Valid
 *
 * ```js
 * var foo = (a === b) ? 1 : 2;
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * var foo = (a === b)
 *   ? 1
 *   : 2;
 * ```
 */

var assert = require('assert');

module.exports = function() {};

module.exports.prototype = {
    configure: function(options) {
        assert(
            options === true,
            this.getOptionName() + ' option requires a true value or should be removed'
        );
    },

    getOptionName: function() {
        return 'disallowMultiLineTernary';
    },

    check: function(file, errors) {
        file.iterateNodesByType('ConditionalExpression', function(node) {

            errors.assert.sameLine({
                token: node.test,
                nextToken: node.consequent,
                message: 'Illegal new line after test'
            });

            errors.assert.sameLine({
                token: node.consequent,
                nextToken: node.alternate,
                message: 'Illegal new line after consequent'
            });
        });
    }

};

},{"assert":171}],20:[function(require,module,exports){
/**
 * Disallows multiple blank lines in a row.
 *
 * Type: `Boolean`
 *
 * Value: `true`
 *
 * #### Example
 *
 * ```js
 * "disallowMultipleLineBreaks": true
 * ```
 *
 * ##### Valid
 * ```js
 * var x = 1;
 *
 * x++;
 * ```
 *
 * ##### Invalid
 * ```js
 * var x = 1;
 *
 *
 * x++;
 * ```
 */

var assert = require('assert');

module.exports = function() {};

module.exports.prototype = {

    configure: function(options) {
        assert(
            options === true,
            this.getOptionName() + ' option requires a true value or should be removed'
        );
    },

    getOptionName: function() {
        return 'disallowMultipleLineBreaks';
    },

    check: function(file, errors) {
        // Iterate over all tokens (including comments)
        file.getTokens().forEach(function(token) {
            if (token.type === 'Whitespace') {
                return;
            }

            // If there are no trailing tokens, exit early
            var nextToken = file.getNextToken(token, {includeComments: true});
            if (!nextToken) {
                return;
            }

            errors.assert.linesBetween({
                token: token,
                nextToken: nextToken,
                atMost: 2
            });
        });
    }

};

},{"assert":171}],21:[function(require,module,exports){
/**
 * Disallows strings that span multiple lines without using concatenation.
 *
 * Type: `Boolean`
 *
 * Value: `true`
 *
 * JSHint: [`multistr`](http://www.jshint.com/docs/options/#multistr)
 *
 * #### Example
 *
 * ```js
 * "disallowMultipleLineStrings": true
 * ```
 *
 * ##### Valid
 * ```js
 * var x = "multi" +
 *         "line";
 * var y = "single line";
 * ```
 *
 * ##### Invalid
 * ```js
 * var x = "multi \
 *         line";
 * ```
 */

var assert = require('assert');

module.exports = function() {};

module.exports.prototype = {

    configure: function(options) {
        assert(
            options === true,
            this.getOptionName() + ' option requires a true value or should be removed'
        );
    },

    getOptionName: function() {
        return 'disallowMultipleLineStrings';
    },

    check: function(file, errors) {
        file.iterateTokensByType('String', function(token) {
            if (token.loc.start.line !== token.loc.end.line) {
                errors.add(
                    'Multiline strings are disallowed.',
                    token.loc.start.line,
                    token.loc.start.column
                );
            }
        });
    }

};

},{"assert":171}],22:[function(require,module,exports){
/**
 * Disallows multiple indentation characters (tabs or spaces) between identifiers, keywords, and any other token
 *
 * Type: `Boolean` or `Object`
 *
 * Values: `true` or `{"allowEOLComments": true}` to allow on-line comments to be ignored
 *
 * #### Examples
 *
 * ```js
 * "disallowMultipleSpaces": true
 * // or
 * "disallowMultipleSpaces": {"allowEOLComments": true}
 * ```
 *
 * ##### Valid
 * ```js
 * var x = "hello";
 * function y() {}
 * ```
 *
 * ##### Valid for `{"allowEOLComments": true}`
 *
 * ```js
 * var x = "hello"    // world;
 * function y() {}
 * ```
 *
 * ##### Invalid
 * ```js
 * var x  = "hello";
 * function  y() {}
 * ```
 */

var assert = require('assert');

module.exports = function() {};

module.exports.prototype = {

    configure: function(options) {
        assert(
            options === true ||
            typeof options === 'object' &&
            options.allowEOLComments === true,
            this.getOptionName() + ' option requires true value ' +
            'or an object with `allowEOLComments` property'
        );

        this.allowEOLComments = options.allowEOLComments;
    },

    getOptionName: function() {
        return 'disallowMultipleSpaces';
    },

    check: function(file, errors) {
        // Iterate over all tokens (including comments)
        var _this = this;
        file.getTokens().forEach(function(token) {
            if (token.type === 'Whitespace') {
                return;
            }

            // If there are no trailing tokens, exit early
            var nextToken = file.getNextToken(token, {includeComments: true});
            if (!nextToken) {
                return;
            }

            // If we are allowing EOL comments and the next token is an EOL comment skip it
            // We don't need to check the current token since EOL comments must be on separate lines from the next one
            if (_this.allowEOLComments && nextToken.type === 'Line') {
                return;
            }

            // Verify we have at most 1 space between this token and the next (won't fail for different lines)
            errors.assert.spacesBetween({
                token: token,
                nextToken: nextToken,
                atMost: 1
            });
        });
    }

};

},{"assert":171}],23:[function(require,module,exports){
/**
 * Disallows multiple `var` declaration (except for-loop).
 *
 * Types: `Boolean` or `Object`
 *
 * Values:
 *
 * - `true` disallows multiple variable declarations except within a for loop
 * - `Object`:
 *    - `'strict'` disallows all multiple variable declarations
 *    - `'allExcept'` array of exceptions:
 *       - `'undefined'` allows declarations where all variables are not defined
 *       - `'require'` allows declarations where all variables are importing external modules with require
 *
 * #### Example
 *
 * ```js
 * "disallowMultipleVarDecl": true
 * ```
 *
 * ##### Valid for `true`
 *
 * ```js
 * var x = 1;
 * var y = 2;
 *
 * for (var i = 0, j = arr.length; i < j; i++) {}
 * ```
 *
 * ##### Valid for `{ strict: true }`
 *
 * ```js
 * var x = 1;
 * var y = 2;
 * ```
 *
 * ##### Valid for `{ allExcept: ['undefined'] }`
 *
 * ```js
 * var a, b;
 * var x = 1;
 * var y = 2;
 *
 * for (var i = 0, j = arr.length; i < j; i++) {}
 * ```
 * ##### Valid for `{ allExcept: ['require'] }`
 *
 * ```js
 * var a = require('a'),
 *     b = require('b');
 *
 * var x = 1;
 * var y = 2;
 *
 * for (var i = 0, j = arr.length; i < j; i++) {}
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * var x = 1,
 *     y = 2;
 *
 * var x, y = 2, z;
 * ```
 */

var assert = require('assert');

module.exports = function() {};

module.exports.prototype = {

    configure: function(options) {
        // support for legacy options
        if (typeof options !== 'object') {
            assert(
                options === true ||
                options === 'strict' ||
                options === 'exceptUndefined',
                this.getOptionName() +
                    ' option requires a true value, "strict", "exceptUndefined", or an object'
            );

            var _options = {
                strict: options === 'strict',
                allExcept: []
            };

            if (options === 'exceptUndefined') {
                _options.allExcept.push('undefined');
            }

            return this.configure(_options);
        }

        if (Array.isArray(options.allExcept)) {
            this._exceptUndefined = options.allExcept.indexOf('undefined') > -1;
            this._exceptRequire = options.allExcept.indexOf('require') > -1;
        }

        this._strictMode = options.strict === true;
    },

    getOptionName: function() {
        return 'disallowMultipleVarDecl';
    },

    check: function(file, errors) {

        function isSourcedFromRequire(node) {
            // If this node is a CallExpression it has a callee,
            // check if this is the `require` function
            if (node.callee && node.callee.name === 'require') {
                return true;
            }

            // If this CallExpression is not a `require` we keep looking for
            // the `require` method up in the tree
            if (node.callee && node.callee.object) {
                return isSourcedFromRequire(node.callee.object);
            }

            // If there is no `callee` this might be a MemberExpression, keep
            // look for the `require` method up in the tree.
            if (node.object) {
                return isSourcedFromRequire(node.object);
            }

            return false;
        }

        var inStrictMode = this._strictMode;
        var exceptUndefined = this._exceptUndefined;
        var exceptRequire = this._exceptRequire;

        file.iterateNodesByType('VariableDeclaration', function(node) {
            var definedVariables = node.declarations.filter(function(declaration) {
                return !!declaration.init;
            });
            var hasDefinedVariables = definedVariables.length > 0;

            var requireStatements = node.declarations.filter(function(declaration) {
                var init = declaration.init;
                return init && isSourcedFromRequire(init);
            });
            var allRequireStatements = requireStatements.length === node.declarations.length;

            var isForStatement = node.parentNode.type === 'ForStatement';

            // allow single var declarations
            if (node.declarations.length === 1) {
                return;
            }

            // allow multiple var declarations in for statement unless we're in strict mode
            // for (var i = 0, j = myArray.length; i < j; i++) {}
            if (!inStrictMode && isForStatement) {
                return;
            }

            // allow multiple var declarations with all undefined variables in exceptUndefined mode
            // var a, b, c
            if (exceptUndefined && !hasDefinedVariables) {
                return;
            }

            // allow multiple var declaration with all require
            // var a = require("a"), b = require("b")
            if (exceptRequire && allRequireStatements) {
                return;
            }

            // allow multiple var declarations only with require && undefined
            // var a = require("a"), b = require("b"), x, y
            if (exceptUndefined && exceptRequire && definedVariables.length === requireStatements.length) {
                return;
            }

            errors.add('Multiple var declaration', node.loc.start);
        });
    }
};

},{"assert":171}],24:[function(require,module,exports){
/**
 * Disallows unassigned functions to be named inline
 *
 * Type: `Boolean`
 *
 * Value: `true`
 *
 * #### Example
 *
 * ```js
 * "disallowNamedUnassignedFunctions": true
 * ```
 *
 * ##### Valid
 * ```js
 * [].forEach(function () {});
 * var x = function() {};
 * function y() {}
 * ```
 *
 * ##### Invalid
 * ```js
 * [].forEach(function x() {});
 * ```
 */

var assert = require('assert');

module.exports = function() {};

module.exports.prototype = {
    configure: function(options) {
        assert(
            options === true,
            this.getOptionName() + ' option requires true value'
        );
    },

    getOptionName: function() {
        return 'disallowNamedUnassignedFunctions';
    },

    check: function(file, errors) {
        file.iterateNodesByType('FunctionExpression', function(node) {
            // If the function has been named via left hand assignment, skip it
            //   e.g. `var hello = function() {`, `foo.bar = function() {`
            if (node.parentNode.type.match(/VariableDeclarator|Property|AssignmentExpression/)) {
                return;
            }

            // If the function has not been named, skip it
            //   e.g. `[].forEach(function() {`
            if (node.id === null) {
                return;
            }

            // Otherwise, complain that it is being named
            errors.add('Inline functions cannot be named', node.loc.start);
        });
    }
};

},{"assert":171}],25:[function(require,module,exports){
/**
 * Disallows nested ternaries.
 *
 * Types: `Boolean`, `Integer`
 *
 * Values: `true` or an Integer that describes the maximum levels of nesting to be allowed.
 *
 * #### Examples
 *
 * ```js
 * "disallowNestedTernaries": true
 *
 * // or
 *
 * "disallowNestedTernaries": { "maxLevel": 1 }
 * ```
 *
 * ##### Valid for modes `true` and `"maxLevel": 1`
 *
 * ```js
 * var foo = (a === b) ? 1 : 2;
 * ```
 *
 * ##### Invalid for mode `true`, but valid for `"maxLevel": 1`
 *
 * ```js
 * var foo = (a === b)
 *   ? (a === c)
 *     ? 1
 *     : 2
 *   : (b === c)
 *     ? 3
 *     : 4;
 * ```
 *
 * ##### Invalid for modes `true` and `"maxLevel": 1`
 *
 * ```js
 * var foo = (a === b)
 *   ? (a === c)
 *     ? (c === d)
 *       ? 5
 *       : 6
 *     : 2
 *   : (b === c)
 *     ? 3
 *     : 4;
 * ```
 */

var assert = require('assert');

module.exports = function() {};

module.exports.prototype = {
    configure: function(options) {
        assert(
            options === true || (typeof options.maxLevel === 'number' && options.maxLevel > 0),
            this.getOptionName() + ' option requires a true value or an object with "maxLevel" property'
        );

        this._maxLevel = 0;
        if (options.maxLevel) {
            this._maxLevel = options.maxLevel;
        }
    },

    getOptionName: function() {
        return 'disallowNestedTernaries';
    },

    check: function(file, errors) {
        var maxLevel = this._maxLevel;
        file.iterateNodesByType('ConditionalExpression', function(node) {
            var level = 0;
            var getLevel = function(currentNode) {
                if (currentNode.parentNode && currentNode.parentNode.type === 'ConditionalExpression') {
                    level += 1;
                    if (level > maxLevel) {
                        errors.add('Illegal nested ternary', node.loc.start.line, node.loc.start.column);
                        return;
                    }
                    getLevel(currentNode.parentNode);
                }
            };
            getLevel(node);
        });
    }

};

},{"assert":171}],26:[function(require,module,exports){
/**
 * Disallows newline before opening curly brace of all block statements.
 *
 * Type: `Boolean` or `Array` or `Object`
 *
 * Values:
 *
 * - `true` always disallows newline before curly brace of block statements
 * - `Array` specifies block-type keywords after which newlines are disallowed before curly brace
 *     - Valid types include: `['if', 'else', 'try', 'catch', 'finally', 'do', 'while', 'for', 'function', 'class',
 *       'switch']`
 * - `Object`:
 *     - `value`: `true` or an Array
 *     - `allExcept`: Array of exceptions
 *        - `"multiLine"`: if the conditions span on multiple lines, require a new line before the curly brace
 *
 * #### Example
 *
 * ```js
 * "disallowNewlineBeforeBlockStatements": true
 * ```
 *
 * ##### Valid
 *
 * ```js
 * function good(){
 *     var obj = {
 *         val: true
 *     };
 *
 *     return {
 *         data: obj
 *     };
 * }
 *
 * if (cond){
 *     foo();
 * }
 *
 * for (var e in elements){
 *     bar(e);
 * }
 *
 * while (cond){
 *     foo();
 * }
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * function bad()
 * {
 *     var obj =
 *     {
 *         val: true
 *     };
 *
 *     return {
 *         data: obj
 *     };
 * }
 *
 * if (cond)
 * {
 *     foo();
 * }
 *
 * for (var e in elements)
 * {
 *     bar(e);
 * }
 *
 * while (cond)
 * {
 *     foo();
 * }
 * ```
 *
 * #### Example
 *
 * ```js
 * "disallowNewlineBeforeBlockStatements": ["if", "else", "for"]
 * ```
 *
 * ##### Valid
 *
 * ```js
 * if (i > 0) {
 *     positive = true;
 * }
 *
 * if (i < 0) {
 *     negative = true;
 * } else {
 *     negative = false;
 * }
 *
 * for (var i = 0, len = myList.length; i < len; ++i) {
 *     newList.push(myList[i]);
 * }
 *
 * // this is fine, since "function" wasn't configured
 * function myFunc(x)
 * {
 *     return x + 1;
 * }
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * if (i < 0)
 * {
 *     negative = true;
 * }
 *
 * if (i < 0)
 * {
 *     negative = true;
 * }
 * else
 * {
 *     negative = false;
 * }
 *
 * for (var i = 0, len = myList.length; i < len; ++i)
 * {
 *     newList.push(myList[i]);
 * }
 * ```
 *
 * #### Example
 *
 * ```js
 * "disallowNewlineBeforeBlockStatements": ["function", "while"]
 * ```
 *
 * ##### Valid
 *
 * ```js
 * function myFunc(x) {
 *     return x + 1;
 * }
 *
 * var z = function(x) {
 *     return x - 1;
 * }
 *
 * // this is fine, since "for" wasn't configured
 * for (var i = 0, len = myList.length; i < len; ++i)
 * {
 *     newList.push(myList[i]);
 * }
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * function myFunc(x)
 * {
 *     return x + 1;
 * }
 *
 * var z = function(x)
 * {
 *     return x - 1;
 * }
 * ```
 *
 * #### Example
 *
 * ```js
 * "disallowNewlineBeforeBlockStatements": {
 *     "value": true,
 *     "allExcept": ["multiLine"]
 * }
 * ```
 *
 * ##### Valid
 *
 * ```js
 * function myFunc(x,
 *                 y)
 * {
 *     return x + y;
 * }
 *
 * function foo() {
 *     if (bar && baz &&
 *         bat)
 *     {
 *         return true;
 *     }
 * }
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * function myFunc(x,
 *                 y) {
 *     return x + y;
 * }
 *
 * function foo() {
 *     if (bar && baz &&
 *         bat) {
 *         return true;
 *     }
 * }
 * ```
 */

var assert = require('assert');

module.exports = function() {};

module.exports.prototype = {
    configure: function(options) {
        var settingValue;
        this._hasMultiLineEx = false;
        if (options.constructor === Object) {
            settingValue = options.value;
            if (options.allExcept) {
                assert(
                    Array.isArray(options.allExcept) && options.allExcept.length === 1 &&
                    options.allExcept[0] === 'multiLine',
                    'allExcept option must be an array whose values can be only `multiLine`'
                );
                this._hasMultiLineEx = true;
            }
        } else {
            settingValue = options;
        }
        assert(
            Array.isArray(settingValue) && settingValue.length || settingValue === true,
            'disallowNewlineBeforeBlockStatements option requires non-empty array value or true value'
        );

        this._setting = settingValue;
    },

    getOptionName: function() {
        return 'disallowNewlineBeforeBlockStatements';
    },

    check: function(file, errors) {
        var setting = this._setting;
        var hasMultiLineEx = this._hasMultiLineEx;

        function assertSameLine(token, nextToken) {
            errors.assert.sameLine({
                token: token,
                nextToken: nextToken,
                message: 'Newline before curly brace for block statement is disallowed'
            });
        }
        function assertDifferentLine(token, nextToken) {
            errors.assert.differentLine({
                token: token,
                nextToken: nextToken,
                message: 'Newline before curly brace for block statement is required'
            });
        }

        file.iterateNodesByType(['BlockStatement', 'ClassBody'], function(node) {
            if (isBareBlock(node)) {
                return;
            }

            if (setting === true || setting.indexOf(getBlockType(node)) !== -1) {
                var openingBrace = file.getFirstNodeToken(node);
                var prevToken = file.getPrevToken(openingBrace);

                if (hasMultiLineEx !== true) {
                    assertSameLine(prevToken, openingBrace);
                    return;
                }

                // Check if the 'conditions' span on multiple lines.
                // The simplest way is to check if the round braces are on different lines.
                //
                // For example:
                //     // same line
                //     for (var i = 0; i < length; i++) {
                //     }
                //
                //     // different lines:
                //     for (var i = 0;
                //          i < length;
                //          i++)
                //     {
                //     }
                var parentNode = node.parentNode;
                var parentNextToken = file.getFirstNodeToken(parentNode);
                var openingRoundBrace = file.findNextToken(parentNextToken, 'Punctuator', '(');
                var closingRoundBrace = file.findPrevToken(openingBrace, 'Punctuator', ')');

                // Not always the conditions are there: to check look for the presence of round braces.
                // For example:
                //     try {
                //     } ...
                if (openingRoundBrace && closingRoundBrace &&
                    openingRoundBrace.loc.start.line !== closingRoundBrace.loc.end.line) {
                    assertDifferentLine(prevToken, openingBrace);
                } else {
                    assertSameLine(prevToken, openingBrace);
                }
            }
        });

        if (setting === true || setting.indexOf('switch') !== -1) {
            file.iterateNodesByType(['SwitchStatement'], function(node) {
                var openingBrace = file.findNextToken(file.getLastNodeToken(node.discriminant), 'Punctuator', '{');
                var prevToken = file.getPrevToken(openingBrace);

                if (hasMultiLineEx !== true) {
                    assertSameLine(prevToken, openingBrace);
                    return;
                }

                var openingRoundBrace = file.findNextToken(file.getFirstNodeToken(node), 'Punctuator', '(');
                var closingRoundBrace = file.findPrevToken(openingBrace, 'Punctuator', ')');

                if (openingRoundBrace.loc.start.line !== closingRoundBrace.loc.end.line) {
                    assertDifferentLine(prevToken, openingBrace);
                } else {
                    assertSameLine(prevToken, openingBrace);
                }
            });
        }
    }
};

function isBareBlock(node) {
    var parentNode = node.parentNode;

    return parentNode &&
    parentNode.type === 'BlockStatement' ||
    parentNode.type === 'Program' ||
    parentNode.body && parentNode.body.type === 'BlockStatement' && Array.isArray(parentNode.body);
}

function getBlockType(node) {
    var parentNode = node.parentNode;
    switch (parentNode.type) {
        case 'IfStatement':
            return (parentNode.alternate === node) ? 'else' : 'if';
        case 'FunctionDeclaration':
        case 'FunctionExpression':
        case 'ArrowFunctionExpression':
            return 'function';
        case 'ForStatement':
        case 'ForInStatement':
        case 'ForOfStatement':
            return 'for';
        case 'WhileStatement':
            return 'while';
        case 'DoWhileStatement':
            return 'do';
        case 'TryStatement':
            return (parentNode.finalizer === node) ? 'finally' : 'try';
        case 'CatchClause':
            return 'catch';
        case 'ClassDeclaration':
            return 'class';
    }
}

},{"assert":171}],27:[function(require,module,exports){
/**
 * Disallow use of certain node types (from Esprima/ESTree).
 *
 * Esprima node types
 *  - [list](https://github.com/jquery/esprima/blob/758196a1c5dd20c3ead6300283a1112428bc7045/esprima.js#L108-L169)
 *
 * Type: `Array`
 *
 * Value: Array of parser node types to be disallowed.
 *
 * #### Example
 *
 * ```js
 * "disallowNodeTypes": ['LabeledStatement']
 * ```
 *
 * ##### Valid
 *
 * ```js
 * // use of an allowed node type
 * var a = 1;
 * // shorthand form of arrow function that returns an object
 * var f = () => ({ a: 1 });
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * // label statement with loop
 * loop1:
 * for (i = 0; i < 10; i++) {
 *     if (i === 3) {
 *         break loop1;
 *     }
 * }
 * // accidental label statement with arrow function
 * var f = () => { a: 1 };
 * // label statement
 * { a: 1 }
 * ```
 */

var assert = require('assert');

module.exports = function() {};

module.exports.prototype = {
    configure: function(nodeTypes) {
        assert(
            Array.isArray(nodeTypes),
            'disallowNodeTypes option requires an array'
        );

        this._nodeTypes = nodeTypes;
    },

    getOptionName: function() {
        return 'disallowNodeTypes';
    },

    check: function(file, errors) {
        var disallowedNodeTypes = this._nodeTypes;
        file.iterateNodesByType(disallowedNodeTypes, function(node) {
            errors.add('Illegal use of disallowed node type: ' + node.type, node.loc.start);
        });
    }
};

},{"assert":171}],28:[function(require,module,exports){
/**
 * Disallows the not, not equals, and strict not equals operators in conditionals.
 *
 * Type: `Boolean`
 *
 * Value: `true`
 *
 * #### Example
 *
 * ```js
 * "disallowNotOperatorsInConditionals": true
 * ```
 *
 * ##### Valid
 *
 * ```js
 * if (clause) {
 *     // Do something really crazy
 * } else {
 *     // Do something crazy
 * }
 *
 * if (a == 1) {
 *     // Do something really crazy
 * } else {
 *     // Do something crazy
 * }
 *
 * var a = (clause) ? 1 : 0
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * if (!clause) {
 *     // Do something crazy
 * } else {
 *     // Do something really crazy
 * }
 *
 * if (a != 1) {
 *     // Do something crazy
 * } else {
 *     // Do something really crazy
 * }
 *
 * if (a !== 1) {
 *     // Do something crazy
 * } else {
 *     // Do something really crazy
 * }
 *
 * var a = (!clause) ? 0 : 1
 * ```
 */

var assert = require('assert');

module.exports = function() {};

module.exports.prototype = {

    configure: function(options) {
        assert(
            options === true,
            this.getOptionName() + ' option requires a true value or should be removed'
        );
    },

    getOptionName: function() {
        return 'disallowNotOperatorsInConditionals';
    },

    check: function(file, errors) {
        function hasNotOperator(test) {
            return test.type === 'UnaryExpression' && test.operator === '!';
        }

        function hasNotEqualOperator(test) {
            return test.type === 'BinaryExpression' && test.operator === '!=';
        }

        function hasStrictNotEqualOperator(test) {
            return test.type === 'BinaryExpression' && test.operator === '!==';
        }

        file.iterateNodesByType(['IfStatement', 'ConditionalExpression'], function(node) {
            var alternate = node.alternate;

            // check if the if statement has an else block
            if (node.type === 'IfStatement' && (!alternate || alternate.type !== 'BlockStatement')) {
                return;
            }
            var test = node.test;
            if (hasNotOperator(test)) {
                errors.add('Illegal use of not operator in if statement', test.loc.start);
            }
            if (hasNotEqualOperator(test)) {
                errors.add('Illegal use of not equal operator in if statement', test.loc.end);
            }
            if (hasStrictNotEqualOperator(test)) {
                errors.add('Illegal use of strict not equal operator in if statement', test.loc.end);
            }
        });
    }
};

},{"assert":171}],29:[function(require,module,exports){
/**
 * Disallows placing object keys on new line
 *
 * Type: `Boolean`
 *
 * Value: `true`
 *
 * #### Example
 *
 * ```js
 * "disallowObjectKeysOnNewLine": true
 * ```
 *
 * ##### Valid
 *
 * ```js
 * var a = {
 *     b: 'b', c: 'c'
 * };
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * var a = {
 *     b: 'b',
 *     c: 'c'
 * };
 * ```
 */

var assert = require('assert');

module.exports = function() {};

module.exports.prototype = {
    configure: function(options) {
        assert(
            options === true,
            this.getOptionName() + ' option requires a true value or should be removed'
        );
    },

    getOptionName: function() {
        return 'disallowObjectKeysOnNewLine';
    },

    check: function(file, errors) {
        file.iterateNodesByType('ObjectExpression', function(node) {
            for (var i = 1; i < node.properties.length; i++) {
                var lastValueToken = file.getLastNodeToken(node.properties[i - 1].value);
                var comma = file.findNextToken(lastValueToken, 'Punctuator', ',');

                var firstKeyToken = file.getFirstNodeToken(node.properties[i].key);

                errors.assert.sameLine({
                    token: comma,
                    nextToken: firstKeyToken,
                    message: 'Object keys must go on a new line'
                });
            }
        });
    }
};

},{"assert":171}],30:[function(require,module,exports){
/**
 * Requires putting certain operators on the next line rather than on the current line before a line break.
 *
 * Types: `Array` or `Boolean`
 *
 * Values: Array of operators to apply to or `true`
 *
 * #### Example
 *
 * ```js
 * "disallowOperatorBeforeLineBreak": ["+", "."]
 * ```
 *
 * ##### Valid
 *
 * ```js
 * $el.on( 'click', fn )
 * 	.appendTo( 'body' );
 *
 * var x = 4 + 5
 * 	+ 12 + 13;
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * $el.on( 'click', fn ).
 * 	appendTo( 'body' );
 *
 * var x = 4 + 5 +
 * 	12 + 13;
 * ```
 */

var assert = require('assert');
var defaultOperators = require('../utils').binaryOperators.slice().concat(['.']);

module.exports = function() {};

module.exports.prototype = {
    configure: function(operators) {
        assert(Array.isArray(operators) || operators === true,
            this.getOptionName() + ' option requires array or true value');

        if (operators === true) {
            operators = defaultOperators;
        }
        this._operators = operators;
    },

    getOptionName: function() {
        return 'disallowOperatorBeforeLineBreak';
    },

    check: function(file, errors) {
        file.iterateTokensByTypeAndValue('Punctuator', this._operators, function(token) {
            errors.assert.sameLine({
                token: token,
                nextToken: file.getNextToken(token),
                message: 'Operator needs to either be on the same line or after a line break.'
            });
        });
    }
};

},{"../utils":166,"assert":171}],31:[function(require,module,exports){
/**
 * Disallow a newline after blocks
 *
 * Type: `Boolean`
 *
 * Value: `true`
 *
 * #### Example
 *
 * ```js
 * "disallowPaddingNewLinesAfterBlocks": true
 * ```
 *
 * ##### Valid
 *
 * ```js
  * function () {
 *     for (var i = 0; i < 2; i++) {
 *         if (true) {
 *             return false;
 *         }
 *         continue;
 *     }
 *     var obj = {
 *         foo: function() {
 *             return 1;
 *         },
 *         bar: function() {
 *             return 2;
 *         }
 *     };
 * }
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * function () {
 *     for (var i = 0; i < 2; i++) {
 *         if (true) {
 *             return false;
 *         }
 *
 *         continue;
 *     }
 *
 *     var obj = {
 *         foo: function() {
 *             return 1;
 *         },
 *
 *         bar: function() {
 *             return 2;
 *         }
 *     };
 * }
 * ```
 */

var assert = require('assert');

module.exports = function() {};

module.exports.prototype = {

    configure: function(value) {
        assert(
            value === true,
            this.getOptionName() + ' option requires a true value or should be removed'
        );
    },

    getOptionName: function() {
        return 'disallowPaddingNewLinesAfterBlocks';
    },

    check: function(file, errors) {
        file.iterateNodesByType('BlockStatement', function(node) {
            var endToken = file.getLastNodeToken(node);
            var nextToken = file.getNextToken(endToken);

            while (nextToken.type !== 'EOF') {
                if (endToken.loc.end.line === nextToken.loc.start.line) {
                    endToken = nextToken;
                    nextToken = file.getNextToken(nextToken);
                    continue;
                }

                errors.assert.linesBetween({
                    token: endToken,
                    nextToken: nextToken,
                    atMost: 1,
                    message: 'Extra newline after closing curly brace'
                });

                return;
            }
        });
    }
};

},{"assert":171}],32:[function(require,module,exports){
/**
 * Disallow a blank line after `'use strict';` statements
 *
 * Values: `true`
 *
 * #### Example
 *
 * ```js
 * "disallowPaddingNewLinesAfterUseStrict": true
 * ```
 *
 * ##### Valid
 *
 * ```js
 * 'use strict';
 * // code
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * 'use strict';
 *
 * // code
 * ```
 */

var assert = require('assert');

module.exports = function() {};

module.exports.prototype = {

    configure: function(disallowPaddingNewLinesAfterUseStrict) {
        assert(
            disallowPaddingNewLinesAfterUseStrict === true,
            this.getOptionName() + ' option requires a true value or should be removed'
        );
    },

    getOptionName: function() {
        return 'disallowPaddingNewLinesAfterUseStrict';
    },

    check: function(file, errors) {
        file.iterateNodesByType('ExpressionStatement', function(node) {
            var expression = node.expression;

            if (expression.type !== 'Literal' || expression.value !== 'use strict') {
                return;
            }

            var endOfNode = file.getLastNodeToken(node);
            var nextToken = file.getNextToken(endOfNode, {
                includeComments: true
            });

            errors.assert.linesBetween({
                atMost: 1,
                token: endOfNode,
                nextToken: nextToken
            });
        });
    }
};

},{"assert":171}],33:[function(require,module,exports){
/**
 * Disallows newline before module.exports
 *
 * Type: `Boolean`
 *
 * Value: `true`
 *
 * #### Example
 *
 * ```js
 * "disallowPaddingNewLinesBeforeExport": true
 * ```
 *
 * ##### Valid
 *
 * ```js
 * var a = 2;
 * module.exports = a;
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * var a = 2;
 *
 * module.exports = a;
 * ```
 */

var assert = require('assert');

module.exports = function() {};

module.exports.prototype = {

    configure: function(value) {
        assert(
            value === true,
            this.getOptionName() + ' option requires a true value or should be removed'
        );
    },

    getOptionName: function() {
        return 'disallowPaddingNewLinesBeforeExport';
    },

    check: function(file, errors) {
        file.iterateNodesByType('AssignmentExpression', function(node) {
            var left = node.left;

            if (!(
                left.object &&
                left.object.name === 'module' &&
                left.property &&
                left.property.name === 'exports')) {
                return;
            }

            var firstToken = file.getFirstNodeToken(node);
            var prevToken = file.getPrevToken(firstToken, {includeComments: true});

            errors.assert.linesBetween({
                atMost: 1,
                token: prevToken,
                nextToken: firstToken,
                message: 'Unexpected extra newline before export'
            });
        });
    }

};

},{"assert":171}],34:[function(require,module,exports){
/**
 * Disallow an empty line above the specified keywords.
 *
 * Types: `Array` or `Boolean`
 *
 * Values: Array of quoted types or `true` to disallow padding new lines after all of the keywords below.
 *
 * #### Example
 *
 * ```js
 * "disallowPaddingNewlinesBeforeKeywords": [
 *     "do",
 *     "for",
 *     "if",
 *     "else",
 *     "switch",
 *     "case",
 *     "try",
 *     "catch",
 *     "void",
 *     "while",
 *     "with",
 *     "return",
 *     "typeof",
 *     "function"
 * ]
 * ```
 *
 * ##### Valid
 *
 * ```js
 * function(a) {
 *     if (!a) {
 *         return false;
 *     }
 *     for (var i = 0; i < b; i++) {
 *         if (!a[i]) {
 *             return false;
 *         }
 *     }
 *     return true;
 * }
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * function(a) {
 *     if (!a) {
 *
 *         return false;
 *     }
 *
 *     for (var i = 0; i < b; i++) {
 *         if (!a[i]) {
 *
 *             return false;
 *         }
 *     }
 *
 *     return true;
 * }
 * ```
 */

var assert = require('assert');
var defaultKeywords = require('../utils').spacedKeywords;

module.exports = function() { };

module.exports.prototype = {

    configure: function(keywords) {
        assert(Array.isArray(keywords) || keywords === true,
            this.getOptionName() + ' option requires array or true value');

        if (keywords === true) {
            keywords = defaultKeywords;
        }

        this._keywords = keywords;
    },

    getOptionName: function() {
        return 'disallowPaddingNewlinesBeforeKeywords';
    },

    check: function(file, errors) {
        file.iterateTokensByTypeAndValue('Keyword', this._keywords, function(token) {
            errors.assert.linesBetween({
                token: file.getPrevToken(token),
                nextToken: token,
                atMost: 1,
                message: 'Keyword `' + token.value + '` should not have an empty line above it'
            });
        });
    }
};

},{"../utils":166,"assert":171}],35:[function(require,module,exports){
/**
 * Disallows newline before line comments
 *
 * Type: `Boolean`
 *
 * Value: `true`
 *
 * #### Example
 *
 * ```js
 * "disallowPaddingNewLinesBeforeLineComments": true
 * ```
 *
 * ##### Valid
 *
 * ```js
 * var a = 2;
 * // comment
 * return a;
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * var a = 2;
 *
 * //comment
 * return a;
 * ```
 */

var assert = require('assert');

module.exports = function() {};

module.exports.prototype = {

    configure: function(value) {
        assert(
            value === true,
            this.getOptionName() + ' option requires a true value or should be removed'
        );
    },

    getOptionName: function() {
        return 'disallowPaddingNewLinesBeforeLineComments';
    },

    check: function(file, errors) {
        file.iterateTokensByType('Line', function(comment) {
            if (comment.loc.start.line === 1) {
                return;
            }

            errors.assert.linesBetween({
                token: file.getPrevToken(comment, {includeComments: true}),
                nextToken: comment,
                atMost: 1,
                message: 'Line comments must not be preceded with a blank line'
            });
        });
    }
};

},{"assert":171}],36:[function(require,module,exports){
/**
 * Disallows blocks from beginning or ending with 2 newlines.
 *
 * Type: `Boolean` or `Object`
 *
 * Values:
 *  - `true` validates all non-empty blocks.
 *  - `Object`:
 *     - `'open'`
*          - `true` validates that there is a newline after the opening brace in a block
*          - `false` ignores the newline validation after the opening brace in a block
 *     - `'close'`
 *          - `true` validates that there is a newline before the closing brace in a block
 *          - `false` ignores the newline validation before the closing brace in a block
 *     - `'allExcept'` array of exceptions:
 *          - `'conditionals'` ignores conditional (if, else if, else) blocks
 *          - `'functions'` ignores function blocks
 *
 * #### Example
 *
 * ```js
 * "disallowPaddingNewlinesInBlocks": true
 * "disallowPaddingNewlinesInBlocks": { "open": true, "close": false }
 * "disallowPaddingNewlinesInBlocks": { "allExcept": [ "conditionals" ] }
 * "disallowPaddingNewlinesInBlocks": { "open": true, "close": false, allExcept: ['conditionals'] }
 * ```
 *
 * ##### Valid for `true`
 *
 * ```js
 * if (true) {
 *     doSomething();
 * }
 * if (true) {doSomething();}
 * var abc = function() {};
 * ```
 *
 * ##### Valid for mode `{ "open": true, "close": false }`
 *
 * ```js
 * if (true) {
 *     doSomething();
 *
 * }
 * ```
 *
 * ##### Valid for `{ allExcept: ['conditionals'] }`
 *
 * ```js
 * if (true) {
 *
 *     doSomething();
 *
 * }
 *
 * function (foo) {
 *     return bar;
 * }
 * ```
 *
 * ##### Valid for `{  "open": true, "close": false, allExcept: ['conditionals'] }`
 *
 * ```js
 * function (foo) {
 *     return bar;
 *
 * }
 *
 * if (true) {
 *
 *     doSomething();
 *
 * }
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * if (true) {
 *
 *     doSomething();
 *
 * }
 * ```
 */

var assert = require('assert');

module.exports = function() {};

module.exports.prototype = {

    configure: function(options) {
        var optionName = this.getOptionName();

        this._checkOpen = true;
        this._checkClose = true;

        if (typeof options === 'object') {
            assert(options.allExcept || options.open || options.close,
            optionName + 'option requires either "open", "close", "allExcept"');

            if (options.allExcept) {
                assert(Array.isArray(options.allExcept), optionName + ' option requires "allExcept" to be an array');
                assert(options.allExcept.length > 0, optionName + ' option requires "allExcept" to have at least one ' +
                'item or be set to `true`');
                this._exceptConditionals = options.allExcept.indexOf('conditionals') > -1;
                this._exceptFunctions = options.allExcept.indexOf('functions') > -1;
            }

            if (options.open || options.close) {
                assert(typeof options.open === 'boolean' && typeof options.close === 'boolean',
                  this.getOptionName() + ' option requires the "open" and "close" ' +
                  'properties to be booleans');

                this._checkOpen = options.open;
                this._checkClose = options.close;
            }
        } else {
            assert(options === true, this.getOptionName() + ' option requires either a true value, or an object');
        }
    },

    getOptionName: function() {
        return 'disallowPaddingNewlinesInBlocks';
    },

    check: function(file, errors) {
        var exceptConditionals = this._exceptConditionals;
        var exceptFunctions = this._exceptFunctions;
        var checkOpen = this._checkOpen;
        var checkClose = this._checkClose;

        file.iterateNodesByType('BlockStatement', function(node) {
            var openingBracket;
            var closingBracket;

            if (exceptConditionals && node.parentNode.type === 'IfStatement' ||
                exceptFunctions && (node.parentNode.type === 'FunctionExpression' ||
                node.parentNode.type === 'FunctionDeclaration')) {
                return;
            }

            if (checkOpen === true) {
                openingBracket = file.getFirstNodeToken(node);

                errors.assert.linesBetween({
                    token: openingBracket,
                    nextToken: file.getNextToken(openingBracket, {includeComments: true}),
                    atMost: 1,
                    message: 'Expected no padding newline after opening curly brace'
                });
            }

            if (checkClose === true) {
                closingBracket = file.getLastNodeToken(node);

                errors.assert.linesBetween({
                    token: file.getPrevToken(closingBracket, {includeComments: true}),
                    nextToken: closingBracket,
                    atMost: 1,
                    message: 'Expected no padding newline before closing curly brace'
                });
            }
        });
    }

};

},{"assert":171}],37:[function(require,module,exports){
/**
 * Disallows newlines adjacent to curly braces in all object literals.
 *
 * Type: `Boolean`
 *
 * Value: `true`
 *
 * #### Example
 *
 * ```js
 * "disallowPaddingNewLinesInObjects": true
 * ```
 *
 * ##### Valid
 *
 * ```js
 * var x = { a: 1 };
 * var y = { a: 1,
 *           b: 2 };
 * var z = { a: 2,
 *           b: 2,
 *
 *           c: 3,
 *
 *
 *
 *           d: 4 };
 * foo({a: {b: 1}});
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * var x = {
 *     a: 1
 * };
 * foo({
 *     a: {
 *         b: 1
 *     }
 * });
 * ```
 */

var assert = require('assert');

module.exports = function() {};

module.exports.prototype = {

    configure: function(value) {
        assert(
            value === true,
            this.getOptionName() + ' option requires a true value or should be removed'
        );
    },

    getOptionName: function() {
        return 'disallowPaddingNewLinesInObjects';
    },

    check: function(file, errors) {
        file.iterateNodesByType('ObjectExpression', function(node) {
            var openingBracket = file.getFirstNodeToken(node);
            var nextToken = file.getNextToken(openingBracket);

            if (nextToken.type === 'Punctuator' && nextToken.value === '}') {
                return;
            }

            errors.assert.sameLine({
                token: openingBracket,
                nextToken: nextToken,
                message: 'Illegal newline after opening curly brace'
            });

            var closingBracket = file.getLastNodeToken(node);

            errors.assert.sameLine({
                token: file.getPrevToken(closingBracket),
                nextToken: closingBracket,
                message: 'Illegal newline before closing curly brace'
            });
        });
    }

};

},{"assert":171}],38:[function(require,module,exports){
/**
 * Disallows parentheses around arrow function expressions with a single parameter.
 *
 * Type: `Boolean`
 *
 * Value: `true`
 *
 * Version: `ES6`
 *
 * #### Example
 *
 * ```js
 * "disallowParenthesesAroundArrowParam": true
 * ```
 *
 * ##### Valid
 *
 * ```js
 * [1, 2, 3].map(x => x * x);
 * // parentheses are always required for multiple parameters
 * [1, 2, 3].map((x, y, z) => x * x);
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * [1, 2, 3].map((x) => x * x);
 * ```
 */

var assert = require('assert');

module.exports = function() {};

module.exports.prototype = {

    configure: function(options) {
        assert(
            options === true,
            this.getOptionName() + ' option requires a true value or should be removed'
        );
    },

    getOptionName: function() {
        return 'disallowParenthesesAroundArrowParam';
    },

    check: function(file, errors) {
        function isWrapped(node) {
            var openParensToken = file.getPrevToken(file.getFirstNodeToken(node));
            var closingParensToken = file.getNextToken(file.getLastNodeToken(node));
            var closingTokenValue = closingParensToken ? closingParensToken.value : '';

            return openParensToken.value + closingTokenValue === '()';
        }

        file.iterateNodesByType('ArrowFunctionExpression', function(node) {
            if (node.params.length !== 1) {
                return;
            }
            var firstParam = node.params[0];

            // Old Esprima
            var hasDefaultParameter = node.defaults && node.defaults.length === 1;
            // ESTree
            var hasDefaultParameterESTree = firstParam.type === 'AssignmentPattern';
            var hasDestructuring = firstParam.type === 'ObjectPattern' || firstParam.type === 'ArrayPattern';
            var hasRestElement = firstParam.type === 'RestElement';

            if (hasDefaultParameter ||
                hasDefaultParameterESTree ||
                hasDestructuring ||
                hasRestElement) {
                return;
            }

            if (isWrapped(firstParam)) {
                errors.add(
                    'Illegal wrap of arrow function expressions in parentheses',
                    firstParam.loc.start
                );
            }
        });
    }

};

},{"assert":171}],39:[function(require,module,exports){
/**
 * Disallows quoted keys in object if possible.
 *
 * Types: `Boolean`, `String` or `Object`
 *
 * Values:
 *
 *  - `true` for strict mode
 *  - `"allButReserved"` (*deprecated* use `"allExcept": ["reserved"]`)
 *  - `Object`:
 *    - `"allExcept"` array of exceptions:
 *      - `"reserved"` allows ES3+ reserved words to remain quoted
 *         which is helpful when using this option with JSHint's `es3` flag.
 *
 * #### Example
 *
 * ```js
 * "disallowQuotedKeysInObjects": true
 * ```
 *
 * ##### Valid for mode `true`
 *
 * ```js
 * var x = { a: { default: 1 } };
 * ```
 *
 * ##### Valid for mode `{"allExcept": ["reserved"]}`
 *
 * ```js
 * var x = {a: 1, 'default': 2};
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * var x = {'a': 1};
 * ```
 */

var assert = require('assert');
var reservedWords = require('reserved-words');

module.exports = function() {};

module.exports.prototype = {

    configure: function(options) {
        assert(
            options === true || options === 'allButReserved' || typeof options === 'object',
            this.getOptionName() + ' option requires a true value or an object'
        );

        this._exceptReserved = options === 'allButReserved';
        if (Array.isArray(options.allExcept)) {
            this._exceptReserved = options.allExcept.indexOf('reserved') !== -1;
        }
    },

    getOptionName: function() {
        return 'disallowQuotedKeysInObjects';
    },

    check: function(file, errors) {
        var KEY_NAME_RE = /^(0|[1-9][0-9]*|[a-zA-Z_$]+[\w$]*)$/; // number or identifier
        var exceptReserved = this._exceptReserved;

        file.iterateNodesByType('ObjectExpression', function(node) {
            node.properties.forEach(function(prop) {
                var key = prop.key;
                if (key.type === 'Literal' &&
                    typeof key.value === 'string' &&
                    KEY_NAME_RE.test(key.value)
                ) {
                    if (exceptReserved && reservedWords.check(key.value, file.getDialect(), true)) {
                        return;
                    }

                    errors.cast({
                        message: 'Extra quotes for key',
                        column: prop.loc.start.column,
                        line: prop.loc.start.line,
                        additional: prop
                    });
                }
            });
        });
    },

    _fix: function(file, error) {
        var node = error.additional;
        var token = file.getFirstNodeToken(node);

        token.value = token.value.slice(1, -1);
    }

};

},{"assert":171,"reserved-words":905}],40:[function(require,module,exports){
/**
 * Disallows lines from ending in a semicolon.
 *
 * Type: `Boolean`
 *
 * Value: `true`
 *
 * #### Example
 *
 * ```js
 * "disallowSemicolons": true
 * ```
 *
 * ##### Valid
 *
 * ```js
 * var a = 1
 * ;[b].forEach(c)
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * var a = 1;
 * [b].forEach(c);
 * ```
 */

var assert = require('assert');

var nodeExceptions = {
    ForStatement: true
};

var tokenExceptions = {
    '[': true,
    '(': true
};

module.exports = function() {};

module.exports.prototype = {
    configure: function(options) {
        assert(
            options === true,
            this.getOptionName() + ' option requires a true value or should be removed'
        );
    },

    getOptionName: function() {
        return 'disallowSemicolons';
    },

    check: function(file, errors) {
        file.iterateTokensByTypeAndValue('Punctuator', ';', function(token) {
            var nextToken = file.getNextToken(token);

            var node = file.getNodeByRange(token.range[0]);

            // Ignore node exceptions
            if (node.type in nodeExceptions) {
                return;
            }

            // Ignore next token exceptions
            if (nextToken.value in tokenExceptions) {
                return;
            }

            if (nextToken.type === 'EOF' || nextToken.loc.end.line > token.loc.end.line) {
                errors.cast({
                    message: 'semicolons are disallowed at the end of a line.',
                    line: token.loc.end.line,
                    column: token.loc.end.column,
                    additional: token
                });
            }
        });
    },

    _fix: function(file, error) {
        file.removeToken(error.additional);
    }
};

},{"assert":171}],41:[function(require,module,exports){
/**
 * Require arrow functions to use a block statement (explicit return).
 *
 * Why enable this rule? Arrow functions' syntax can cause maintenance issues:
 *
 * - When you add additional lines to an arrow function's expression body, the
 *   function will now return `undefined`, unless you remember to add an
 *   explicit `return`.
 * - The shorthand syntax is ambiguous in terms of returning objects.
 *   `(name) => {id: name}` is interpreted as a longhand arrow function with the
 *   label `id:`.
 *
 * Type: `Boolean`
 *
 * Value: `true`
 *
 * Version: `ES6`
 *
 * #### Example
 *
 * ```js
 * "disallowShorthandArrowFunctions": true
 * ```
 *
 * ##### Valid
 *
 * ```js
 * // block statement
 * evens.map(v => {
 *     return v + 1;
 * });
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * // single expression
 * evens.map(v => v + 1);
 * ```
 */

var assert = require('assert');

module.exports = function() {};

module.exports.prototype = {

    configure: function(options) {
        assert(
            options === true,
            this.getOptionName() + ' option requires a true value or should be removed'
        );
    },

    getOptionName: function() {
        return 'disallowShorthandArrowFunctions';
    },

    check: function(file, errors) {
        file.iterateNodesByType('ArrowFunctionExpression', function(node) {
            if (node.expression) {
                errors.add(
                    'Use arrow function with explicit block and explicit return',
                    node.body.loc.start
                );
            }
        });
    }

};

},{"assert":171}],42:[function(require,module,exports){
/**
 * Requires sticking binary operators to the right.
 *
 * Types: `Array` or `Boolean`
 *
 * Values: Array of quoted operators or `true` to disallow space after all possible binary operators
 *
 * #### Example
 *
 * ```js
 * "disallowSpaceAfterBinaryOperators": [
 *     "=",
 *     ",",
 *     "+",
 *     "-",
 *     "/",
 *     "*",
 *     "==",
 *     "===",
 *     "!=",
 *     "!=="
 *     // etc
 * ]
 * ```
 *
 * ##### Valid
 *
 * ```js
 * x +y;
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * x+ y;
 * ```
 */

var assert = require('assert');
var allOperators = require('../utils').binaryOperators;

module.exports = function() {};

module.exports.prototype = {
    configure: function(operators) {
        var isTrue = operators === true;

        assert(
            Array.isArray(operators) || isTrue,
            this.getOptionName() + ' option requires array or true value'
        );

        if (isTrue) {
            operators = allOperators;
        }

        this._operatorIndex = {};
        for (var i = 0, l = operators.length; i < l; i++) {
            this._operatorIndex[operators[i]] = true;
        }
    },

    getOptionName: function() {
        return 'disallowSpaceAfterBinaryOperators';
    },

    check: function(file, errors) {
        var operators = this._operatorIndex;

        // Comma
        if (operators[',']) {
            file.iterateTokensByTypeAndValue('Punctuator', ',', function(token) {
                if (file.getNextToken(token).value === ',') {
                    return;
                }
                errors.assert.noWhitespaceBetween({
                    token: token,
                    nextToken: file.getNextToken(token),
                    message: 'Operator , should stick to following expression'
                });
            });
        }

        // For everything else
        file.iterateNodesByType(
            ['BinaryExpression', 'AssignmentExpression', 'VariableDeclarator', 'LogicalExpression'],
            function(node) {
                var operator;
                var expression;

                if (node.type === 'VariableDeclarator') {
                    expression = node.init;
                    operator = '=';
                } else {
                    operator = node.operator;
                    expression = node.right;
                }

                if (expression === null) {
                    return;
                }

                var operatorToken = file.findPrevOperatorToken(
                    file.getFirstNodeToken(expression),
                    operator
                );

                var nextToken = file.getNextToken(operatorToken);

                if (operators[operator]) {
                    errors.assert.noWhitespaceBetween({
                        token: operatorToken,
                        nextToken: nextToken,
                        message: 'Operator ' + operator + ' should stick to following expression'
                    });
                }
            }
        );
    }

};

},{"../utils":166,"assert":171}],43:[function(require,module,exports){
/**
 * Disallows spaces after commas
 *
 * Types: `Boolean` or `Object`
 *
 * Values:
 *   - `Boolean`: `true` to disallow any spaces after any comma
 *   - `Object`: `"allExcept"` array of exceptions
 *     - `"sparseArrays"` to allow spaces in place of absent values in sparse arrays
 *
 * #### Example
 *
 * ```js
 * "disallowSpaceAfterComma": true
 * ```
 * ```js
 * "disallowSpaceAfterComma" {"allExcept": ["sparseArrays"]}
 * ```
 *
 * ##### Valid for mode `true`
 *
 * ```js
 * [a,b,c];
 * ```
 *
 * ##### Invalid for mode `true`
 *
 * ```js
 * [a, b, c];
 * ```
 * ```js
 * [a,b, , ,c];
 * ```
 *
 * ##### Valid for mode `{"allExcept": ["sparseArrays"]}`
 *
 * ```js
 * [a,b, , ,c];
 * ```
 *
 * ##### Invalid for mode `{"allExcept": ["sparseArrays"]}`
 *
 * ```js
 * [a, b, , , c];
 * ``
 */

var assert = require('assert');

module.exports = function() {
};

module.exports.prototype = {

    configure: function(options) {
        if (typeof options !== 'object') {
            assert(
                options === true,
                this.getOptionName() + ' option requires true value or an object'
            );
            var _options = {allExcept: []};
            return this.configure(_options);
        }

        assert(
            Array.isArray(options.allExcept),
            ' property `allExcept` in ' + this.getOptionName() + ' should be an array of strings'
        );
        this._exceptSparseArrays = options.allExcept.indexOf('sparseArrays') >= 0;
    },

    getOptionName: function() {
        return 'disallowSpaceAfterComma';
    },

    check: function(file, errors) {
        var exceptSparseArrays = this._exceptSparseArrays;
        file.iterateTokensByTypeAndValue('Punctuator', ',', function(token) {
            var nextToken = file.getNextToken(token);

            if (exceptSparseArrays && nextToken.value === ',') {
                return;
            }
            errors.assert.noWhitespaceBetween({
                token: token,
                nextToken: nextToken,
                message: 'Illegal space after comma'
            });
        });
    }

};

},{"assert":171}],44:[function(require,module,exports){
/**
 * Disallows space after keyword.
 *
 * Types: `Array` or `Boolean`
 *
 * Values: Array of quoted keywords or `true` to disallow spaces after all possible keywords.
 *
 * #### Example
 *
 * ```js
 * "disallowSpaceAfterKeywords": [
 *     "if",
 *     "else",
 *     "for",
 *     "while",
 *     "do",
 *     "switch",
 *     "try",
 *     "catch"
 * ]
 * ```
 *
 * ##### Valid
 *
 * ```js
 * if(x > y) {
 *     y++;
 * }
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * if (x > y) {
 *     y++;
 * }
 * ```
 */

var assert = require('assert');
var defaultKeywords = require('../utils').spacedKeywords;

module.exports = function() {};

module.exports.prototype = {

    configure: function(keywords) {
        assert(
            Array.isArray(keywords) || keywords === true,
            this.getOptionName() + ' option requires array or true value'
        );

        if (keywords === true) {
            keywords = defaultKeywords;
        }

        this._keywords = keywords;
    },

    getOptionName: function() {
        return 'disallowSpaceAfterKeywords';
    },

    check: function(file, errors) {
        file.iterateTokensByTypeAndValue('Keyword', this._keywords, function(token) {
            var nextToken = file.getNextToken(token);

            // Make an exception if the next token is not a Punctuator such as a Keyword or Identifier
            if (nextToken.type !== 'Punctuator') {
                return;
            }
            errors.assert.noWhitespaceBetween({
                token: token,
                nextToken: nextToken
            });
        });
    }

};

},{"../utils":166,"assert":171}],45:[function(require,module,exports){
/**
 * Requires that a line comment (`//`) not be followed by a space.
 *
 * Type: `Boolean`
 *
 * Value: `true`
 *
 * #### Example
 *
 * ```js
 * "disallowSpaceAfterLineComment": true
 * ```
 *
 * ##### Valid
 *
 * ```js
 * //A comment
 * /* A comment*\/
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * // A comment
 * ```
 */

var assert = require('assert');

module.exports = function() {};

module.exports.prototype = {

    configure: function(options) {
        assert(
            options === true,
            this.getOptionName() + ' option requires a true value or should be removed'
        );
    },

    getOptionName: function() {
        return 'disallowSpaceAfterLineComment';
    },

    check: function(file, errors) {
        file.iterateTokensByType('Line', function(comment) {
            var value = comment.value;
            if (value.length > 0 && value[0] === ' ') {
                errors.add('Illegal space after line comment', comment.loc.start);
            }
        });
    }
};

},{"assert":171}],46:[function(require,module,exports){
/**
 * Disallows space after object keys.
 *
 * Types: `Boolean` or `String`
 *
 * Values:
 *  - `true`
 *  - `"ignoreSingleLine"` ignores objects if the object only takes up a single line
 *    (*deprecated* use `"allExcept": [ "singleline" ]`)
 *  - `"ignoreMultiLine"` ignores objects if the object takes up multiple lines
 *    (*deprecated* use `"allExcept": [ "multiline" ]`)
 *  - `Object`:
 *     - `"allExcept"`: array of exceptions:
 *        - `"singleline"` ignores objects if the object only takes up a single line
 *        - `"multiline"` ignores objects if the object takes up multiple lines
 *        - `"aligned"` ignores aligned object properties
 *        - `"method"` ignores method declarations
 *
 * #### Example
 *
 * ```js
 * "disallowSpaceAfterObjectKeys": true
 * ```
 *
 * ##### Valid for `true`
 * ```js
 * var x = {a: 1};
 * var y = {
 *     a: 1,
 *     b: 2
 * }
 * ```
 *
 * ##### Valid for `{ allExcept: ['singleline'] }`
 * ```js
 * var x = {a : 1};
 * var y = {
 *     a: 1,
 *     b: 2
 * }
 * ```
 *
 * ##### Valid for `{ allExcept: ['multiline'] }`
 * ```js
 * var x = {a: 1};
 * var y = {
 *     a  : 1,
 *     b   : 2
 * }
 * ```
 *
 * ##### Valid for `{ allExcept: ['aligned'] }`
 * ```js
 * var y = {
 *     abc: 1,
 *     d  : 2
 * }
 * ```
 *
 * ##### Valid for `{ allExcept: ['method'] }`
 * ```js
 * var y = {
 *     fn () {
 *        return 42;
 *     }
 * }
 * ```
 *
 * ##### Invalid
 * ```js
 * var x = {a : 1};
 * ```
 */

var assert = require('assert');

module.exports = function() {};

module.exports.prototype = {

    configure: function(options) {
        if (typeof options !== 'object') {
            assert(
                options === true ||
                options === 'ignoreSingleLine' ||
                options === 'ignoreMultiLine',
                this.getOptionName() +
                ' option requires a true value, "ignoreSingleLine", "ignoreMultiLine", or an object'
            );

            var _options = {
                allExcept: []
            };

            if (options === 'ignoreSingleLine') {
                _options.allExcept.push('singleline');
            }
            if (options === 'ignoreMultiLine') {
                _options.allExcept.push('multiline');
            }

            return this.configure(_options);
        } else {
            assert(
                Array.isArray(options.allExcept),
                this.getOptionName() +
                ' option object requires allExcept array property'
            );
        }

        this._exceptSingleline = options.allExcept.indexOf('singleline') > -1;
        this._exceptMultiline = options.allExcept.indexOf('multiline') > -1;
        this._exceptAligned = options.allExcept.indexOf('aligned') > -1;
        this._exceptMethod = options.allExcept.indexOf('method') > -1;
        assert(
            !this._exceptMultiline || !this._exceptAligned,
            this.getOptionName() +
            ' option allExcept property cannot contain `aligned` and `multiline` at the same time'
        );
        assert(
            !this._exceptMultiline || !this._exceptSingleline,
            this.getOptionName() +
            ' option allExcept property cannot contain `singleline` and `multiline` at the same time'
        );
    },

    getOptionName: function() {
        return 'disallowSpaceAfterObjectKeys';
    },

    check: function(file, errors) {
        var exceptSingleline = this._exceptSingleline;
        var exceptMultiline = this._exceptMultiline;
        var exceptAligned = this._exceptAligned;
        var exceptMethod = this._exceptMethod;

        file.iterateNodesByType('ObjectExpression', function(node) {
            var multiline = node.loc.start.line !== node.loc.end.line;
            if (exceptSingleline && !multiline) {
                return;
            }
            if (exceptMultiline && multiline) {
                return;
            }

            var maxKeyEndPos = 0;
            var tokens = [];
            node.properties.forEach(function(property) {
                if (property.shorthand || property.kind !== 'init' ||
                    (exceptMethod && property.method) ||
                    node.type === 'SpreadProperty') {
                    return;
                }

                var keyToken = file.getLastNodeToken(property.key);
                if (property.computed === true) {
                    keyToken = file.getNextToken(keyToken);
                }

                if (exceptAligned) {
                    maxKeyEndPos = Math.max(maxKeyEndPos, keyToken.loc.end.column);
                }
                tokens.push(keyToken);
            });

            var noSpace = true;
            if (exceptAligned) {
                var withoutSpace = 0;
                var alignedOnColon = 0;
                tokens.forEach(function(key) {
                    var colon = file.getNextToken(key);
                    var spaces = Math.abs(colon.range[0] - key.range[1]);
                    if (spaces === 0) {
                        withoutSpace++;
                    } else if (spaces === maxKeyEndPos - key.loc.end.column) {
                        alignedOnColon++;
                    }
                });

                noSpace = withoutSpace > alignedOnColon;
            }

            tokens.forEach(function(key) {
                var colon = file.getNextToken(key);
                var spaces = (exceptAligned && !noSpace) ? maxKeyEndPos - key.loc.end.column : 0;
                errors.assert.spacesBetween({
                    token: key,
                    nextToken: colon,
                    exactly: spaces,
                    message: 'Illegal space after key',
                    disallowNewLine: true
                });
            });
        });
    }

};

},{"assert":171}],47:[function(require,module,exports){
/**
 * Requires sticking unary operators to the right.
 *
 * Types: `Array` or `Boolean`
 *
 * Values: Array of quoted operators or `true` to disallow space after prefix for all unary operators
 *
 * #### Example
 *
 * ```js
 * "disallowSpaceAfterPrefixUnaryOperators": ["++", "--", "+", "-", "~", "!"]
 * ```
 *
 * ##### Valid
 *
 * ```js
 * x = !y; y = ++z;
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * x = ! y; y = ++ z;
 * ```
 */

var assert = require('assert');
var defaultOperators = require('../utils').unaryOperators;

module.exports = function() {};

module.exports.prototype = {

    configure: function(operators) {
        var isTrue = operators === true;

        assert(
            Array.isArray(operators) || isTrue,
            this.getOptionName() + ' option requires array or true value'
        );

        if (isTrue) {
            operators = defaultOperators;
        }

        this._operatorIndex = {};
        for (var i = 0, l = operators.length; i < l; i++) {
            this._operatorIndex[operators[i]] = true;
        }
    },

    getOptionName: function() {
        return 'disallowSpaceAfterPrefixUnaryOperators';
    },

    check: function(file, errors) {
        var operatorIndex = this._operatorIndex;

        file.iterateNodesByType(['UnaryExpression', 'UpdateExpression'], function(node) {
            // Check "node.prefix" for prefix type of (inc|dec)rement
            if (node.prefix && operatorIndex[node.operator]) {
                var operatorToken = file.getFirstNodeToken(node);
                errors.assert.noWhitespaceBetween({
                    token: operatorToken,
                    nextToken: file.getNextToken(operatorToken),
                    message: 'Operator ' + node.operator + ' should stick to operand'
                });
            }
        });
    }
};

},{"../utils":166,"assert":171}],48:[function(require,module,exports){
/**
 * Requires sticking binary operators to the left.
 *
 * Types: `Array` or `Boolean`
 *
 * Values: Array of quoted operators or `true` to disallow space before all possible binary operators
 *
 * #### Example
 *
 * ```js
 * "disallowSpaceBeforeBinaryOperators": [
 *     "=",
 *     ",",
 *     "+",
 *     "-",
 *     "/",
 *     "*",
 *     "==",
 *     "===",
 *     "!=",
 *     "!=="
 *     // etc
 * ]
 * ```
 *
 * ##### Valid
 *
 * ```js
 * x+ y;
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * x + y;
 * ```
 */

var assert = require('assert');
var allOperators = require('../utils').binaryOperators;

module.exports = function() {};

module.exports.prototype = {

    configure: function(operators) {
        var isTrue = operators === true;

        assert(
            Array.isArray(operators) || isTrue,
            this.getOptionName() + ' option requires array or true value'
        );

        if (isTrue) {
            operators = allOperators;
        }

        this._operatorIndex = {};
        for (var i = 0, l = operators.length; i < l; i++) {
            this._operatorIndex[operators[i]] = true;
        }
    },

    getOptionName: function() {
        return 'disallowSpaceBeforeBinaryOperators';
    },

    check: function(file, errors) {
        var operators = this._operatorIndex;

        // Comma
        if (operators[',']) {
            file.iterateTokensByTypeAndValue('Punctuator', ',', function(token) {
                if (file.getPrevToken(token).value === ',') {
                    return;
                }
                errors.assert.noWhitespaceBetween({
                    token: file.getPrevToken(token, {includeComments: true}),
                    nextToken: token,
                    message: 'Operator , should stick to previous expression'
                });
            });
        }

        // For everything else
        file.iterateNodesByType(
            ['BinaryExpression', 'AssignmentExpression', 'VariableDeclarator', 'LogicalExpression'],
            function(node) {
                var operator;
                var expression;

                if (node.type === 'VariableDeclarator') {
                    expression = node.init;
                    operator = '=';
                } else {
                    operator = node.operator;
                    expression = node.right;
                }

                if (expression === null) {
                    return;
                }

                var operatorToken = file.findPrevOperatorToken(
                    file.getFirstNodeToken(expression),
                    operator
                );

                var prevToken = file.getPrevToken(operatorToken, {includeComments: true});

                if (operators[operator]) {
                    errors.assert.noWhitespaceBetween({
                        token: prevToken,
                        nextToken: operatorToken,
                        message: 'Operator ' + node.operator + ' should stick to previous expression'
                    });
                }
            }
        );
    }

};

},{"../utils":166,"assert":171}],49:[function(require,module,exports){
/**
 * Disallows space before block statements (for loops, control structures).
 *
 * Type: `Boolean`
 *
 * Value: `true`
 *
 * #### Example
 *
 * ```js
 * "disallowSpaceBeforeBlockStatements": true
 * ```
 *
 * ##### Valid
 *
 * ```js
 * if (cond){
 *     foo();
 * } else{
 *    bar();
 * }
 *
 * for (var e in elements){
 *     bar(e);
 * }
 *
 * while (cond){
 *     foo();
 * }
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * if (cond) {
 *     foo();
 * } else {
 *    bar();
 * }
 *
 * for (var e in elements) {
 *     bar(e);
 * }
 *
 * while (cond) {
 *     foo();
 * }
 * ```
 */

var assert = require('assert');

module.exports = function() {};

module.exports.prototype = {
    configure: function(options) {
        assert(
            options === true,
            this.getOptionName() + ' option requires a true value or should be removed'
        );
    },

    getOptionName: function() {
        return 'disallowSpaceBeforeBlockStatements';
    },

    check: function(file, errors) {
        file.iterateNodesByType('BlockStatement', function(node) {
            if (isBareBlock(node)) {
                return;
            }
            var first = file.getFirstNodeToken(node);

            errors.assert.noWhitespaceBetween({
                token: file.getPrevToken(first),
                nextToken: first,
                disallowNewLine: true,
                message: 'Extra space before opening curly brace for block expressions'
            });
        });
    }
};

function isBareBlock(node) {
    var parentNode = node.parentNode;

    return parentNode &&
    parentNode.type === 'BlockStatement' ||
    parentNode.type === 'Program' ||
    parentNode.body && parentNode.body.type === 'BlockStatement' && Array.isArray(parentNode.body);
}

},{"assert":171}],50:[function(require,module,exports){
/**
 * Disallows spaces before commas
 *
 * Types: `Boolean` or `Object`
 *
 * Values:
 *   - `Boolean`: `true` to disallow any spaces before any comma
 *   - `Object`: `"allExcept"` array of exceptions
 *     - `"sparseArrays"` to allow spaces in place of absent values in sparse arrays
 *
 * #### Example
 *
 * ```js
 * "disallowSpaceBeforeComma": true
 * ```
 * ```js
 * "disallowSpaceBeforeComma": {"allExcept": ["sparseArrays"]}
 * ```
 *
 * ##### Valid for mode `true`
 *
 * ```js
 * var a, b;
 * ```
 *
 * ##### Invalid for mode `true`
 *
 * ```js
 * var a ,b;
 * ```
 * ```js
 * [a, b, , , c]
 * ```
 * ##### Valid for mode `{"allExcept": ["sparseArrays"]}`
 *
 * ```js
 * [a, b, , , c]
 * ```
 *
 * ##### Invalid for mode  `{"allExcept": ["sparseArrays"]}`
 *
 * ```js
 * [a , b , , , c]
 * ```
 *
 */

var assert = require('assert');

module.exports = function() {
};

module.exports.prototype = {

    configure: function(options) {
        if (typeof options !== 'object') {
            assert(
                options === true,
                this.getOptionName() + ' option requires true value or an object'
            );
            var _options = {allExcept: []};
            return this.configure(_options);
        }

        assert(
            Array.isArray(options.allExcept),
            ' property `allExcept` in ' + this.getOptionName() + ' should be an array of strings'
        );
        this._exceptSparseArrays = options.allExcept.indexOf('sparseArrays') >= 0;
    },

    getOptionName: function() {
        return 'disallowSpaceBeforeComma';
    },

    check: function(file, errors) {
        var exceptSparseArrays = this._exceptSparseArrays;
        file.iterateTokensByTypeAndValue('Punctuator', ',', function(token) {
            var prevToken = file.getPrevToken(token);

            if (exceptSparseArrays && prevToken.value === ',') {
                return;
            }
            errors.assert.noWhitespaceBetween({
                token: prevToken,
                nextToken: token,
                message: 'Illegal space before comma'
            });
        });
    }

};

},{"assert":171}],51:[function(require,module,exports){
/**
 * Disallows space before keyword.
 *
 * Types: `Array` or `Boolean`
 *
 * Values: Array of quoted keywords or `true` to disallow spaces before all possible keywords.
 *
 * #### Example
 *
 * ```js
 * "disallowSpaceBeforeKeywords": [
 *     "else",
 *     "catch"
 * ]
 * ```
 *
 * ##### Valid
 *
 * ```js
 * }else {
 *     y--;
 * }
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * } else {
 *     y--;
 * }
 * ```
 */

var assert = require('assert');

var defaultKeywords = require('../utils').spacedKeywords;

module.exports = function() {};

module.exports.prototype = {

    configure: function(keywords) {
        assert(
            Array.isArray(keywords) || keywords === true,
            this.getOptionName() + ' option requires array or true value');

        if (keywords === true) {
            keywords = defaultKeywords;
        }

        this._keywords = keywords;
    },

    getOptionName: function() {
        return 'disallowSpaceBeforeKeywords';
    },

    check: function(file, errors) {
        file.iterateTokensByTypeAndValue('Keyword', this._keywords, function(token) {
            var prevToken = file.getPrevToken(token, {includeComments: true});
            if (!prevToken || prevToken.isComment) {
                return;
            }

            if (prevToken.type !== 'Keyword' && prevToken.value !== ';') {
                errors.assert.noWhitespaceBetween({
                    token: prevToken,
                    nextToken: token,
                    message: 'Illegal space before "' + token.value + '" keyword'
                });
            }
        });
    }

};

},{"../utils":166,"assert":171}],52:[function(require,module,exports){
/**
 * Disallows space before object values.
 *
 * Type: `Boolean`
 *
 * Value: `true`
 *
 * #### Example
 *
 * ```js
 * "disallowSpaceBeforeObjectValues": true
 * ```
 *
 * ##### Valid
 * ```js
 * var x = {a:1};
 * ```
 * ##### Invalid
 * ```js
 * var x = {a: 1};
 * ```
 */

var assert = require('assert');

module.exports = function() {};

module.exports.prototype = {

    configure: function(disallow) {
        assert(
            disallow === true,
            this.getOptionName() + ' option requires a true value or should be removed'
        );
    },

    getOptionName: function() {
        return 'disallowSpaceBeforeObjectValues';
    },

    check: function(file, errors) {
        file.iterateNodesByType('ObjectExpression', function(node) {
            node.properties.forEach(function(property) {
                if (property.shorthand || property.method || property.kind !== 'init' ||
                    node.type === 'SpreadProperty') {
                    return;
                }

                var keyToken = file.getFirstNodeToken(property.key);
                var colon = file.findNextToken(keyToken, 'Punctuator', ':');

                errors.assert.noWhitespaceBetween({
                    token: colon,
                    nextToken: file.getNextToken(colon),
                    message: 'Illegal space after key colon'
                });
            });
        });
    }

};

},{"assert":171}],53:[function(require,module,exports){
/**
 * Requires sticking unary operators to the left.
 *
 * Types: `Array` or `Boolean`
 *
 * Values: Array of quoted operators or `true` to disallow space before postfix for all unary operators
 * (i.e. increment/decrement operators)
 *
 * #### Example
 *
 * ```js
 * "disallowSpaceBeforePostfixUnaryOperators": ["++", "--"]
 * ```
 *
 * ##### Valid
 *
 * ```js
 * x = y++; y = z--;
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * x = y ++; y = z --;
 * ```
 */

var assert = require('assert');
var defaultOperators = require('../utils').incrementAndDecrementOperators;

module.exports = function() {};

module.exports.prototype = {

    configure: function(operators) {
        var isTrue = operators === true;

        assert(
            Array.isArray(operators) || isTrue,
            this.getOptionName() + ' option requires array or true value'
        );

        if (isTrue) {
            operators = defaultOperators;
        }

        this._operatorIndex = {};
        for (var i = 0, l = operators.length; i < l; i++) {
            this._operatorIndex[operators[i]] = true;
        }
    },

    getOptionName: function() {
        return 'disallowSpaceBeforePostfixUnaryOperators';
    },

    check: function(file, errors) {
        var operatorIndex = this._operatorIndex;

        // 'UpdateExpression' involve only ++ and -- operators
        file.iterateNodesByType('UpdateExpression', function(node) {
            // "!node.prefix" means postfix type of (inc|dec)rement
            if (!node.prefix && operatorIndex[node.operator]) {
                var operatorToken = file.getLastNodeToken(node);
                errors.assert.noWhitespaceBetween({
                    token: file.getPrevToken(operatorToken),
                    nextToken: operatorToken,
                    message: 'Operator ' + node.operator + ' should stick to operand'
                });
            }
        });
    }
};

},{"../utils":166,"assert":171}],54:[function(require,module,exports){
/**
 * Disallows spaces before semicolons.
 *
 * Types: `Boolean` or `Object`
 *
 * Values:
 *  - `true` to disallow any spaces before any semicolon.
 *  - `Object`:
 *      - `"allExcept"`: `[ "(" ]` list of tokens that can occur after semicolon
 *
 * #### Example
 *
 * ```js
 * "disallowSpaceBeforeSemicolon": true
 * ```
 *
 * ##### Valid
 *
 * ```js
 * var a = 1;
 * ```
 *
 * * ##### Valid for mode `{ "allExcept": [ "(" ] }`
 *
 * ```js
 * for ( ; nodeIndex < nodesCount; ++nodeIndex ) {}
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * var a = 1 ;
 * ```
 */

var assert = require('assert');

module.exports = function() {};

module.exports.prototype = {

    configure: function(value) {
        var isObject = typeof value === 'object';

        var error = this.getOptionName() + ' rule requires string value true or object';

        if (isObject) {
            assert('allExcept' in value, error);
        } else {
            assert(value === true, error);
        }

        this._exceptions = {};

        if (isObject) {
            (value.allExcept || []).forEach(function(value) {
                this._exceptions[value] = true;
            }, this);
        }
    },

    getOptionName: function() {
        return 'disallowSpaceBeforeSemicolon';
    },

    check: function(file, errors) {
        var exceptions = this._exceptions;

        file.iterateTokensByTypeAndValue('Punctuator', ';', function(token) {
            var prevToken = file.getPrevToken(token);

            if (!prevToken || prevToken.value in exceptions) {
                return;
            }

            errors.assert.noWhitespaceBetween({
                token: prevToken,
                nextToken: token,
                message: 'Illegal space before semicolon'
            });
        });
    }

};

},{"assert":171}],55:[function(require,module,exports){
/**
 * Ensure there are no spaces after argument separators in call expressions.
 *
 * Type: `Boolean`
 *
 * Value: `true`
 *
 * #### Example
 *
 * ```js
 * "disallowSpaceBetweenArguments": true
 * ```
 *
 * ##### Valid
 *
 * ```js
 * a(b,c);
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * a(b, c);
 * ```
 */

var assert = require('assert');

module.exports = function() {};

module.exports.prototype = {

    configure: function(options) {
        assert(
            options === true,
            this.getOptionName() + ' option requires a true value or should be removed'
        );
    },

    getOptionName: function() {
        return 'disallowSpaceBetweenArguments';
    },

    check: function(file, errors) {
        file.iterateNodesByType(['CallExpression'], function(node) {
            node.arguments.forEach(function(param) {
                var token = file.getFirstNodeToken(param);
                var punctuatorToken = file.getPrevToken(token);

                if (punctuatorToken.value === ',') {
                    errors.assert.noWhitespaceBetween({
                        token: punctuatorToken,
                        nextToken: file.getNextToken(punctuatorToken),
                        message: 'Illegal space between arguments'
                    });
                }
            });
        });
    }
};

},{"assert":171}],56:[function(require,module,exports){
/**
 * Disallows space before `()` or `{}` in anonymous function expressions.
 *
 * Type: `Object`
 *
 * Values: `"beforeOpeningRoundBrace"` and `"beforeOpeningCurlyBrace"` as child properties.
 * Child properties must be set to `true`.
 *
 * #### Example
 *
 * ```js
 * "disallowSpacesInAnonymousFunctionExpression": {
 *     "beforeOpeningRoundBrace": true,
 *     "beforeOpeningCurlyBrace": true
 * }
 * ```
 *
 * ##### Valid
 *
 * ```js
 * var foo = function(){};
 * var Foo = {
 *     foo: function(){}
 * }
 * array.map(function(){});
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * var foo = function () {};
 * var Foo = {
 *     foo: function (){}
 * }
 * array.map(function() {});
 * ```
 */

var assert = require('assert');

module.exports = function() {};

module.exports.prototype = {
    configure: function(options) {
        assert(
            typeof options === 'object',
            this.getOptionName() + ' option must be the object'
        );

        if ('beforeOpeningRoundBrace' in options) {
            assert(
                options.beforeOpeningRoundBrace === true,
                this.getOptionName() + '.beforeOpeningRoundBrace ' +
                'property requires true value or should be removed'
            );
        }

        if ('beforeOpeningCurlyBrace' in options) {
            assert(
                options.beforeOpeningCurlyBrace === true,
                this.getOptionName() + '.beforeOpeningCurlyBrace ' +
                'property requires true value or should be removed'
            );
        }

        assert(
            options.beforeOpeningCurlyBrace || options.beforeOpeningRoundBrace,
            this.getOptionName() + ' must have beforeOpeningCurlyBrace ' +
            ' or beforeOpeningRoundBrace property'
        );

        this._beforeOpeningRoundBrace = Boolean(options.beforeOpeningRoundBrace);
        this._beforeOpeningCurlyBrace = Boolean(options.beforeOpeningCurlyBrace);
    },

    getOptionName: function() {
        return 'disallowSpacesInAnonymousFunctionExpression';
    },

    check: function(file, errors) {
        var beforeOpeningRoundBrace = this._beforeOpeningRoundBrace;
        var beforeOpeningCurlyBrace = this._beforeOpeningCurlyBrace;

        file.iterateNodesByType(['FunctionExpression'], function(node) {
            var functionNode = node;
            var parent = node.parentNode;

            // Ignore syntactic sugar for getters and setters.
            if (parent.type === 'Property' && (parent.kind === 'get' || parent.kind === 'set')) {
                return;
            }

            // shorthand or constructor methods
            if (parent.method || parent.type === 'MethodDefinition') {
                functionNode = parent.key;
            }

            // anonymous function expressions only
            if (node.id) {
                return;
            }

            if (beforeOpeningRoundBrace) {
                var functionToken = file.getFirstNodeToken(functionNode);
                if (node.async && functionToken.value === 'async') {
                    functionToken = file.getNextToken(functionToken);
                }
                // if generator, set token to be * instead
                if (node.generator && functionToken.value === 'function') {
                    functionToken = file.getNextToken(functionToken);
                }
                errors.assert.noWhitespaceBetween({
                    token: functionToken,
                    nextToken: file.getNextToken(functionToken),
                    message: 'Illegal space before opening round brace'
                });
            }

            if (beforeOpeningCurlyBrace) {
                var bodyToken = file.getFirstNodeToken(node.body);
                errors.assert.noWhitespaceBetween({
                    token: file.getPrevToken(bodyToken),
                    nextToken: bodyToken,
                    message: 'Illegal space before opening curly brace'
                });
            }
        });
    }

};

},{"assert":171}],57:[function(require,module,exports){
/**
 * Disallows space before `()` in call expressions.
 *
 * Type: `Boolean`
 *
 * Value: `true`
 *
 * #### Example
 *
 * ```js
 * "disallowSpacesInCallExpression": true
 * ```
 *
 * ##### Valid
 *
 * ```js
 * var x = foobar();
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * var x = foobar ();
 * ```
 */

var assert = require('assert');

module.exports = function() {};

module.exports.prototype = {
    configure: function(options) {
        assert(
            options === true,
            this.getOptionName() + ' option requires a true value or should be removed'
        );
    },

    getOptionName: function() {
        return 'disallowSpacesInCallExpression';
    },

    check: function(file, errors) {
        file.iterateNodesByType(['CallExpression', 'NewExpression'], function(node) {
            function doesTokenBelongToNode(token, node) {
                return token.range[1] <= node.range[1];
            }

            var lastCalleeToken = file.getLastNodeToken(node.callee);
            var roundBraceToken = file.findNextToken(lastCalleeToken, 'Punctuator', '(');

            // CallExpressions can't have missing parens, otherwise they're identifiers
            if (node.type === 'NewExpression') {
                if (roundBraceToken === null || !doesTokenBelongToNode(roundBraceToken, node)) {
                    return;
                }
            }

            errors.assert.noWhitespaceBetween({
                token: file.getPrevToken(roundBraceToken),
                nextToken: roundBraceToken,
                message: 'Illegal space before opening round brace'
            });
        });
    }
};

},{"assert":171}],58:[function(require,module,exports){
/**
 * Disallows space before and/or after `?` or `:` in conditional expressions.
 *
 * Types: `Object` or `Boolean`
 *
 * Values: `"afterTest"`, `"beforeConsequent"`, `"afterConsequent"`, `"beforeAlternate"` as child properties,
 * or `true` to set all properties to true. Child properties must be set to `true`. These token names correspond to:
 *
 * ```
 * var a = b ? c : d;
 *          ^ ^ ^ ^
 *          | | | |
 *          | | | └- beforeAlternate
 *          | | └--- afterConsequent
 *          | └-------- beforeConsequent
 *          └---------- afterTest
 * ```
 *
 * #### Example
 *
 * ```js
 * "disallowSpacesInConditionalExpression": {
 *     "afterTest": true,
 *     "beforeConsequent": true,
 *     "afterConsequent": true,
 *     "beforeAlternate": true
 * }
 * ```
 *
 * ##### Valid
 *
 * ```js
 * var a = b?c:d;
 * var a= b?c:d;
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * var a = b ?c:d;
 * var a = b? c:d;
 * var a = b?c :d;
 * var a = b?c: d;
 * ```
 */

var assert = require('assert');

module.exports = function() {};

module.exports.prototype = {
    configure: function(options) {
        var validProperties = [
            'afterTest',
            'beforeConsequent',
            'afterConsequent',
            'beforeAlternate'
        ];
        var optionName = this.getOptionName();

        if (options === true) {
            options = {
                'afterTest': true,
                'beforeConsequent': true,
                'afterConsequent': true,
                'beforeAlternate': true
            };
        }

        assert(
            typeof options === 'object',
            optionName + ' option requires a true value or an object'
        );

        var isProperlyConfigured = validProperties.some(function(key) {
            var isPresent = key in options;

            if (isPresent) {
                assert(
                    options[key] === true,
                    optionName + '.' + key + ' property requires true value or should be removed'
                );
            }

            return isPresent;
        });

        assert(
            isProperlyConfigured,
            optionName + ' must have at least 1 of the following properties: ' + validProperties.join(', ')
        );

        validProperties.forEach(function(property) {
            this['_' + property] = Boolean(options[property]);
        }.bind(this));
    },

    getOptionName: function() {
        return 'disallowSpacesInConditionalExpression';
    },

    check: function(file, errors) {
        file.iterateNodesByType(['ConditionalExpression'], function(node) {

            var test = node.test;
            var consequent = node.consequent;
            var consequentToken = file.getFirstNodeToken(consequent);
            var alternate = node.alternate;
            var alternateToken = file.getFirstNodeToken(alternate);
            var questionMarkToken = file.findPrevOperatorToken(consequentToken, '?');
            var colonToken = file.findPrevOperatorToken(alternateToken, ':');
            var token;

            if (this._afterTest && test.loc.end.line === questionMarkToken.loc.start.line) {
                token = file.getPrevToken(questionMarkToken);

                errors.assert.noWhitespaceBetween({
                    token: token,
                    nextToken: questionMarkToken,
                    message: 'Illegal space after test'
                });
            }

            if (this._beforeConsequent && consequent.loc.end.line === questionMarkToken.loc.start.line) {
                token = file.getNextToken(questionMarkToken);

                errors.assert.noWhitespaceBetween({
                    token: questionMarkToken,
                    nextToken: token,
                    message: 'Illegal space before consequent'
                });
            }

            if (this._afterConsequent && consequent.loc.end.line === colonToken.loc.start.line) {
                token = file.getPrevToken(colonToken);

                errors.assert.noWhitespaceBetween({
                    token: token,
                    nextToken: colonToken,
                    message: 'Illegal space after consequent'
                });
            }

            if (this._beforeAlternate && alternate.loc.end.line === colonToken.loc.start.line) {
                token = file.getNextToken(colonToken);
                errors.assert.noWhitespaceBetween({
                    token: colonToken,
                    nextToken: token,
                    message: 'Illegal space before alternate'
                });
            }
        }.bind(this));
    }

};

},{"assert":171}],59:[function(require,module,exports){
/**
 * Disallow spaces in between for statement.
 *
 * Type: `Boolean`
 *
 * Value: `true` to disallow spaces in between for statement.
 *
 * #### Example
 *
 * ```js
 * "disallowSpacesInForStatement": true
 * ```
 *
 * ##### Valid
 *
 * ```js
 * for(var i=0;i<l;i++) {
 *     x++;
 * }
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * for(var i = 0; i<l; i++) {
 *     x++;
 * }
 * ```
 *
 * ```js
 * for(var i = 0; i<l;i++) {
 *     x++;
 * }
 * ```
 *
 * ```js
 * for(var i = 0;i<l; i++) {
 *     x++;
 * }
 * ```
 */

var assert = require('assert');

module.exports = function() {};

module.exports.prototype = {
    configure: function(options) {
        assert(
            options === true,
            this.getOptionName() + ' option requires a true value or should be removed'
        );
    },

    getOptionName: function() {
        return 'disallowSpacesInForStatement';
    },

    check: function(file, errors) {
        file.iterateNodesByType('ForStatement', function(node) {
            if (node.test) {
                var testToken = file.getFirstNodeToken(node.test);
                errors.assert.noWhitespaceBetween({
                    token: file.getPrevToken(testToken),
                    nextToken: testToken,
                    message: 'Space found after semicolon'
                });
            }
            if (node.update) {
                var updateToken = file.getFirstNodeToken(node.update);
                errors.assert.noWhitespaceBetween({
                    token: file.getPrevToken(updateToken),
                    nextToken: updateToken,
                    message: 'Space found after semicolon'
                });
            }
        });
    }
};

},{"assert":171}],60:[function(require,module,exports){
/**
 * Disallows space before `()` or `{}` in function declarations.
 *
 * Type: `Object`
 *
 * Values: `"beforeOpeningRoundBrace"` and `"beforeOpeningCurlyBrace"` as child properties.
 * Child properties must be set to `true`.
 *
 * #### Example
 *
 * ```js
 * "disallowSpacesInFunctionDeclaration": {
 *     "beforeOpeningRoundBrace": true,
 *     "beforeOpeningCurlyBrace": true
 * }
 * ```
 *
 * ##### Valid
 *
 * ```js
 * function a(){}
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * function a() {}
 * function a (){}
 * function a () {}
 * ```
 */

var assert = require('assert');

module.exports = function() {};

module.exports.prototype = {
    configure: function(options) {
        assert(
            typeof options === 'object',
            this.getOptionName() + ' option must be the object'
        );

        if ('beforeOpeningRoundBrace' in options) {
            assert(
                options.beforeOpeningRoundBrace === true,
                this.getOptionName() + '.beforeOpeningRoundBrace ' +
                'property requires true value or should be removed'
            );
        }

        if ('beforeOpeningCurlyBrace' in options) {
            assert(
                options.beforeOpeningCurlyBrace === true,
                this.getOptionName() + '.beforeOpeningCurlyBrace ' +
                'property requires true value or should be removed'
            );
        }

        assert(
            options.beforeOpeningCurlyBrace || options.beforeOpeningRoundBrace,
            this.getOptionName() + ' must have beforeOpeningCurlyBrace or beforeOpeningRoundBrace property'
        );

        this._beforeOpeningRoundBrace = Boolean(options.beforeOpeningRoundBrace);
        this._beforeOpeningCurlyBrace = Boolean(options.beforeOpeningCurlyBrace);
    },

    getOptionName: function() {
        return 'disallowSpacesInFunctionDeclaration';
    },

    check: function(file, errors) {
        var beforeOpeningRoundBrace = this._beforeOpeningRoundBrace;
        var beforeOpeningCurlyBrace = this._beforeOpeningCurlyBrace;

        file.iterateNodesByType(['FunctionDeclaration'], function(node) {
            // Exception for `export default function` #1376
            if (!node.id) {
                return;
            }

            if (beforeOpeningRoundBrace) {
                var functionToken = file.getFirstNodeToken(node.id);
                if (node.async && functionToken.value === 'async') {
                    functionToken = file.getNextToken(functionToken);
                }
                // if generator, set token to be * instead
                if (node.generator && functionToken.value === 'function') {
                    functionToken = file.getNextToken(functionToken);
                }
                errors.assert.noWhitespaceBetween({
                    token: functionToken,
                    nextToken: file.getNextToken(functionToken),
                    message: 'Illegal space before opening round brace'
                });
            }

            if (beforeOpeningCurlyBrace) {
                var bodyToken = file.getFirstNodeToken(node.body);
                errors.assert.noWhitespaceBetween({
                    token: file.getPrevToken(bodyToken),
                    nextToken: bodyToken,
                    message: 'Illegal space before opening curly brace'
                });
            }
        });
    }

};

},{"assert":171}],61:[function(require,module,exports){
/**
 * Disallows space before `()` or `{}` in function expressions (both [named](#disallowspacesinnamedfunctionexpression)
 * and [anonymous](#disallowspacesinanonymousfunctionexpression)).
 *
 * Type: `Object`
 *
 * Values: `"beforeOpeningRoundBrace"` and `"beforeOpeningCurlyBrace"` as child properties.
 * Child properties must be set to `true`.
 *
 * #### Example
 *
 * ```js
 * "disallowSpacesInFunctionExpression": {
 *     "beforeOpeningRoundBrace": true,
 *     "beforeOpeningCurlyBrace": true
 * }
 * ```
 *
 * ##### Valid
 *
 * ```js
 * var x = function(){};
 * var x = function a(){};
 * var x = async function(){};
 * var x = async function a(){};
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * var x = function() {};
 * var x = function (){};
 * var x = function () {};
 * var x = function a() {};
 * var x = function a (){};
 * var x = function a () {};
 * var x = async function () {};
 * var x = async function a() {};
 * var x = async function a (){};
 * var x = async function a () {};
 * ```
 */

var assert = require('assert');

module.exports = function() {};

module.exports.prototype = {
    configure: function(options) {
        assert(
            typeof options === 'object',
            this.getOptionName() + ' option must be the object'
        );

        if ('beforeOpeningRoundBrace' in options) {
            assert(
                options.beforeOpeningRoundBrace === true,
                this.getOptionName() + '.beforeOpeningRoundBrace ' +
                'property requires true value or should be removed'
            );
        }

        if ('beforeOpeningCurlyBrace' in options) {
            assert(
                options.beforeOpeningCurlyBrace === true,
                this.getOptionName() + '.beforeOpeningCurlyBrace ' +
                'property requires true value or should be removed'
            );
        }

        assert(
            options.beforeOpeningCurlyBrace || options.beforeOpeningRoundBrace,
            this.getOptionName() + ' must have beforeOpeningCurlyBrace or beforeOpeningRoundBrace property'
        );

        this._beforeOpeningRoundBrace = Boolean(options.beforeOpeningRoundBrace);
        this._beforeOpeningCurlyBrace = Boolean(options.beforeOpeningCurlyBrace);
    },

    getOptionName: function() {
        return 'disallowSpacesInFunctionExpression';
    },

    check: function(file, errors) {
        var beforeOpeningRoundBrace = this._beforeOpeningRoundBrace;
        var beforeOpeningCurlyBrace = this._beforeOpeningCurlyBrace;

        file.iterateNodesByType('FunctionExpression', function(node) {
            // for a named function, use node.id
            var functionNode = node.id || node;
            var parent = node.parentNode;

            // Ignore syntactic sugar for getters and setters.
            if (parent.type === 'Property' && (parent.kind === 'get' || parent.kind === 'set')) {
                return;
            }

            // shorthand or constructor methods
            if (parent.method || parent.type === 'MethodDefinition') {
                functionNode = parent.key;
            }

            if (beforeOpeningRoundBrace) {
                var functionToken = file.getFirstNodeToken(functionNode);
                if (node.async && functionToken.value === 'async') {
                    functionToken = file.getNextToken(functionToken);
                }
                // if generator, set token to be * instead
                if (node.generator && functionToken.value === 'function') {
                    functionToken = file.getNextToken(functionToken);
                }
                errors.assert.noWhitespaceBetween({
                    token: functionToken,
                    nextToken: file.getNextToken(functionToken),
                    message: 'Illegal space before opening round brace'
                });
            }

            if (beforeOpeningCurlyBrace) {
                var bodyToken = file.getFirstNodeToken(node.body);
                errors.assert.noWhitespaceBetween({
                    token: file.getPrevToken(bodyToken),
                    nextToken: bodyToken,
                    message: 'Illegal space before opening curly brace'
                });
            }
        });
    }

};

},{"assert":171}],62:[function(require,module,exports){
/**
 * Disallows space before `()` or `{}` in function expressions (both [named](#disallowspacesinnamedfunctionexpression)
 * and [anonymous](#disallowspacesinanonymousfunctionexpression)) and function declarations.
 *
 * Type: `Object`
 *
 * Values: `"beforeOpeningRoundBrace"` and `"beforeOpeningCurlyBrace"` as child properties.
 * Child properties must be set to `true`.
 *
 * #### Example
 *
 * ```js
 * "disallowSpacesInFunction": {
 *     "beforeOpeningRoundBrace": true,
 *     "beforeOpeningCurlyBrace": true
 * }
 * ```
 *
 * ##### Valid
 *
 * ```js
 * var x = function(){};
 * var x = function a(){};
 * function a(){}
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * var x = function() {};
 * var x = function (){};
 * var x = function () {};
 * var x = function a() {};
 * var x = function a (){};
 * var x = function a () {};
 * function a() {}
 * function a (){}
 * function a () {}
 * ```
 */

var assert = require('assert');

module.exports = function() {};

module.exports.prototype = {
    configure: function(options) {
        assert(
            typeof options === 'object',
            this.getOptionName() + ' option must be the object'
        );

        if ('beforeOpeningRoundBrace' in options) {
            assert(
                options.beforeOpeningRoundBrace === true,
                this.getOptionName() + '.beforeOpeningRoundBrace ' +
                'property requires true value or should be removed'
            );
        }

        if ('beforeOpeningCurlyBrace' in options) {
            assert(
                options.beforeOpeningCurlyBrace === true,
                this.getOptionName() + '.beforeOpeningCurlyBrace ' +
                'property requires true value or should be removed'
            );
        }

        assert(
            options.beforeOpeningCurlyBrace || options.beforeOpeningRoundBrace,
            this.getOptionName() + ' must have beforeOpeningCurlyBrace or beforeOpeningRoundBrace property'
        );

        this._beforeOpeningRoundBrace = Boolean(options.beforeOpeningRoundBrace);
        this._beforeOpeningCurlyBrace = Boolean(options.beforeOpeningCurlyBrace);
    },

    getOptionName: function() {
        return 'disallowSpacesInFunction';
    },

    check: function(file, errors) {
        var beforeOpeningRoundBrace = this._beforeOpeningRoundBrace;
        var beforeOpeningCurlyBrace = this._beforeOpeningCurlyBrace;

        file.iterateNodesByType(['FunctionDeclaration', 'FunctionExpression'], function(node) {
            // for a named function, use node.id
            var functionNode = node.id || node;
            var parent = node.parentNode;

            // Ignore syntactic sugar for getters and setters.
            if (parent.type === 'Property' && (parent.kind === 'get' || parent.kind === 'set')) {
                return;
            }

            // shorthand or constructor methods
            if (parent.method || parent.type === 'MethodDefinition') {
                functionNode = parent.key;
            }

            if (beforeOpeningRoundBrace) {
                var functionToken = file.getFirstNodeToken(functionNode);
                if (node.async && functionToken.value === 'async') {
                    functionToken = file.getNextToken(functionToken);
                }
                // if generator, set token to be * instead
                if (node.generator && functionToken.value === 'function') {
                    functionToken = file.getNextToken(functionToken);
                }
                errors.assert.noWhitespaceBetween({
                    token: functionToken,
                    nextToken: file.getNextToken(functionToken),
                    message: 'Illegal space before opening round brace'
                });
            }

            if (beforeOpeningCurlyBrace) {
                var bodyToken = file.getFirstNodeToken(node.body);
                errors.assert.noWhitespaceBetween({
                    token: file.getPrevToken(bodyToken),
                    nextToken: bodyToken,
                    message: 'Illegal space before opening curly brace'
                });
            }
        });
    }

};

},{"assert":171}],63:[function(require,module,exports){
/**
 * Disallow space before or after `*` in generator functions
 *
 * Types: `Object`
 *
 *  - `Object` (at least one of properties must be present and it must be set to true):
 *      - `'beforeStar'`
 *          - `true` disallows space before `*`
 *      - `'afterStar'`
 *          - `true` disallows space after `*`
 *
 * #### Example
 *
 * ```js
 * "disallowSpacesInGenerator": {
 *     "beforeStar": true,
 *     "afterStar": true
 * }
 * ```
 *
 * ##### Valid for mode `{ "beforeStar": true, "afterStar": false }`
 * ```js
 * var x = function* () {};
 * function* a() {};
 * var x = async function* () {};
 * var x = async function* a () {};
 * async function* a() {}
 * var x = async function* (){};
 * ```
 *
 * ##### Valid for mode `{ "beforeStar": false, "afterStar": true }`
 * ```js
 * var x = function *() {};
 * function *a() {};
 * var x = async function *() {};
 * var x = async function *a () {};
 * async function *a() {}
 * var x = async function *(){};
 * ```
 *
*/

var assert = require('assert');

module.exports = function() {};

module.exports.prototype = {
    configure: function(options) {
        assert(
            typeof options === 'object',
            this.getOptionName() + ' option must be an object'
        );

        if ('beforeStar' in options) {
            assert(
                options.beforeStar === true,
                this.getOptionName() + '.beforeStar ' +
                'property requires true value or should be removed'
            );
        }
        if ('afterStar' in options) {
            assert(
                options.afterStar === true,
                this.getOptionName() + '.afterStar ' +
                'property requires true value or should be removed'
            );
        }

        assert(
            options.beforeStar || options.afterStar,
            this.getOptionName() + ' must have beforeStar or afterStar property'
        );

        this._beforeStar = options.beforeStar;
        this._afterStar = options.afterStar;
    },

    getOptionName: function() {
        return 'disallowSpacesInGenerator';
    },

    check: function(file, errors) {
        var beforeStar = this._beforeStar;
        var afterStar = this._afterStar;

        file.iterateNodesByType(['FunctionDeclaration', 'FunctionExpression'], function(node) {
            if (!node.generator) {
                return;
            }

            var parent = node.parentNode;
            var shorthand = false;

            // shorthand or constructor methods
            if (parent.method || parent.type === 'MethodDefinition') {
                shorthand = true;
                node = parent.key;
            }

            var currentToken = file.getFirstNodeToken(node);

            if (node.async && currentToken.value === 'async') {
                currentToken = file.getNextToken(currentToken);
            }

            if (beforeStar && !shorthand) {
                // currentToken assigned outside of function
                errors.assert.noWhitespaceBetween({
                    token: currentToken,
                    nextToken: file.getNextToken(currentToken),
                    message: 'Illegal space before star'
                });
            }

            if (afterStar) {
                if (shorthand) {
                    currentToken = file.getPrevToken(currentToken);
                } else {
                    // currentToken reassigned for star token
                    currentToken = file.getNextToken(currentToken);
                }

                errors.assert.noWhitespaceBetween({
                    token: currentToken,
                    nextToken: file.getNextToken(currentToken),
                    message: 'Illegal space after star'
                });
            }
        });
    }
};

},{"assert":171}],64:[function(require,module,exports){
/**
 * Disallows space before `()` or `{}` in named function expressions.
 *
 * Type: `Object`
 *
 * Values: `"beforeOpeningRoundBrace"` and `"beforeOpeningCurlyBrace"` as child properties.
 * Child properties must be set to `true`.
 *
 * #### Example
 *
 * ```js
 * "disallowSpacesInNamedFunctionExpression": {
 *     "beforeOpeningRoundBrace": true,
 *     "beforeOpeningCurlyBrace": true
 * }
 * ```
 *
 * ##### Valid
 *
 * ```js
 * var x = function a(){};
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * var x = function a() {};
 * var x = function a (){};
 * var x = function a () {};
 * ```
 */

var assert = require('assert');

module.exports = function() {};

module.exports.prototype = {
    configure: function(options) {
        assert(
            typeof options === 'object',
            this.getOptionName() + ' option must be the object'
        );

        if ('beforeOpeningRoundBrace' in options) {
            assert(
                options.beforeOpeningRoundBrace === true,
                this.getOptionName() + '.beforeOpeningRoundBrace ' +
                'property requires true value or should be removed'
            );
        }

        if ('beforeOpeningCurlyBrace' in options) {
            assert(
                options.beforeOpeningCurlyBrace === true,
                this.getOptionName() + '.beforeOpeningCurlyBrace ' +
                'property requires true value or should be removed'
            );
        }

        assert(
            options.beforeOpeningCurlyBrace || options.beforeOpeningRoundBrace,
            this.getOptionName() + ' must have beforeOpeningCurlyBrace ' +
            'or beforeOpeningRoundBrace property'
        );

        this._beforeOpeningRoundBrace = Boolean(options.beforeOpeningRoundBrace);
        this._beforeOpeningCurlyBrace = Boolean(options.beforeOpeningCurlyBrace);
    },

    getOptionName: function() {
        return 'disallowSpacesInNamedFunctionExpression';
    },

    check: function(file, errors) {
        var beforeOpeningRoundBrace = this._beforeOpeningRoundBrace;
        var beforeOpeningCurlyBrace = this._beforeOpeningCurlyBrace;

        file.iterateNodesByType(['FunctionExpression'], function(node) {
            var functionNode = node.id;
            var parent = node.parentNode;

            // Ignore syntactic sugar for getters and setters.
            if (parent.type === 'Property' && (parent.kind === 'get' || parent.kind === 'set')) {
                return;
            }

            // shorthand or constructor methods
            if (parent.method || parent.type === 'MethodDefinition') {
                functionNode = parent.key;
            }

            // named function expressions only
            if (node.id) {
                if (beforeOpeningRoundBrace) {
                    var functionToken = file.getFirstNodeToken(functionNode);
                    if (node.async && functionToken.value === 'async') {
                        functionToken = file.getNextToken(functionToken);
                    }
                    errors.assert.noWhitespaceBetween({
                        token: functionToken,
                        nextToken: file.getNextToken(functionToken),
                        message: 'Illegal space before opening round brace'
                    });
                }

                if (beforeOpeningCurlyBrace) {
                    var bodyToken = file.getFirstNodeToken(node.body);
                    errors.assert.noWhitespaceBetween({
                        token: file.getPrevToken(bodyToken),
                        nextToken: bodyToken,
                        message: 'Illegal space before opening curly brace'
                    });
                }
            }
        });
    }

};

},{"assert":171}],65:[function(require,module,exports){
/**
 * Disallows space after opening array square bracket and before closing.
 * Reports only on arrays, not on property accessors.
 * Use [disallowSpacesInsideBrackets](http://jscs.info/rule/disallowSpacesInsideBrackets.html)
 * to report on all brackets.
 *
 * Types: `Boolean`, `String` or `Object`
 *
 * Values: `"all"` or `true` for strict mode, `"nested"` (*deprecated* use `"allExcept": [ "[", "]" ]`)
 * ignores closing brackets in a row.
 *
 * #### Example
 *
 * ```js
 * "disallowSpacesInsideArrayBrackets": "all"
 *
 * // or
 *
 * "disallowSpacesInsideArrayBrackets": {
 *     "allExcept": [ "[", "]", "{", "}" ]
 * }
 * ```
 *
 * ##### Valid for mode `"all"`
 *
 * ```js
 * var x = [[1]];
 * var x = a[ 0 ]; // Property accessor not an array
 * ```
 *
 *
 * ##### Valid for mode `"nested"`
 *
 * ```js
 * var x = [ [1] ];
 * ```
 *
 * ##### Valid for mode `"allExcept"`
 *
 * ```js
 * var x = [ [1] ];
 * var x = [ { a: 1 } ];
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * var x = [ [ 1 ] ];
 * ```
 */

var assert = require('assert');

module.exports = function() {};

module.exports.prototype = {

    configure: function(value) {
        var mode;
        var modes = {
            'all': true,
            'nested': true
        };
        var isObject = typeof value === 'object';

        var error = this.getOptionName() + ' rule' +
        ' requires string value "all" or "nested" or object';

        if (typeof value === 'string' || value === true) {
            assert(modes[value === true ? 'all' : value], error);

        } else if (isObject) {
            assert('allExcept' in value, error);
        } else {
            assert(false, error);
        }

        this._exceptions = {};

        if (isObject) {
            (value.allExcept || []).forEach(function(value) {
                this._exceptions[value] = true;
            }, this);

        } else {
            mode = value;
        }

        if (mode === 'nested') {
            this._exceptions['['] = this._exceptions[']'] = true;
        }
    },

    getOptionName: function() {
        return 'disallowSpacesInsideArrayBrackets';
    },

    check: function(file, errors) {
        var exceptions = this._exceptions;

        file.iterateNodesByType('ArrayExpression', function(node) {
            var openBracket = file.getFirstNodeToken(node);
            var afterOpen = file.getNextToken(openBracket, {includeComments: true});
            var closeBracket = file.getLastNodeToken(node);
            var beforeClose = file.getPrevToken(closeBracket, {includeComments: true});

            // Skip for empty array brackets
            if (afterOpen.value === ']') {
                return;
            }

            if (!(afterOpen.value in exceptions)) {
                errors.assert.noWhitespaceBetween({
                    token: openBracket,
                    nextToken: afterOpen,
                    message: 'Illegal space after opening bracket'
                });
            }

            if (!(beforeClose.value in exceptions)) {
                errors.assert.noWhitespaceBetween({
                    token: beforeClose,
                    nextToken: closeBracket,
                    message: 'Illegal space before closing bracket'
                });
            }
        });
    }
};

},{"assert":171}],66:[function(require,module,exports){
/**
 * Disallows space after opening square bracket and before closing.
 * Reports on all on brackets, even on property accessors.
 * Use [disallowSpacesInsideArrayBrackets](http://jscs.info/rule/disallowSpacesInsideArrayBrackets.html)
 * to exclude property accessors.
 *
 * Types: `Boolean` or `Object`
 *
 * Values: `true` for strict mode, or `"allExcept": [ "[", "]" ]`
 * ignores closing brackets in a row.
 *
 * #### Example
 *
 * ```js
 * "disallowSpacesInsideBrackets": true
 *
 * // or
 *
 * "disallowSpacesInsideBrackets": {
 *     "allExcept": [ "[", "]", "{", "}" ]
 * }
 * ```
 *
 * ##### Valid for mode `true`
 *
 * ```js
 * var x = [[1]];
 * var x = a[1];
 * ```
 *
 * ##### Valid for mode `{ allExcept": [ "[", "]", "{", "}" ] }`
 *
 * ```js
 * var x = [ [1] ];
 * var x = [ { a: 1 } ];
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * var x = [ [ 1 ] ];
 * ```
 */

var assert = require('assert');

module.exports = function() {};

module.exports.prototype = {

    configure: function(value) {
        var isObject = typeof value === 'object';

        var error = this.getOptionName() + ' rule requires string value true or object';

        if (isObject) {
            assert('allExcept' in value, error);
        } else {
            assert(value === true, error);
        }

        this._exceptions = {};

        if (isObject) {
            (value.allExcept || []).forEach(function(value) {
                this._exceptions[value] = true;
            }, this);
        }
    },

    getOptionName: function() {
        return 'disallowSpacesInsideBrackets';
    },

    check: function(file, errors) {
        var exceptions = this._exceptions;

        file.iterateTokenByValue('[', function(token) {
            var nextToken = file.getNextToken(token, { includeComments: true });
            var value = nextToken.value;

            if (value in exceptions) {
                return;
            }

            // Skip for empty array brackets
            if (value === ']') {
                return;
            }

            errors.assert.noWhitespaceBetween({
                token: token,
                nextToken: nextToken,
                message: 'Illegal space after opening bracket'
            });
        });

        file.iterateTokenByValue(']', function(token) {
            var prevToken = file.getPrevToken(token, { includeComments: true });
            var value = prevToken.value;

            if (value in exceptions) {
                return;
            }

            // Skip for empty array brackets
            if (value === '[') {
                return;
            }

            errors.assert.noWhitespaceBetween({
                token: prevToken,
                nextToken: token,
                message: 'Illegal space before closing bracket'
            });
        });
    }
};

},{"assert":171}],67:[function(require,module,exports){
/**
 * Disallows space after opening object curly brace and before closing.
 *
 * Types: `Object`, `Boolean` or `String`
 *
 * Values: `"all"` or `true` for strict mode, `"nested"` (*deprecated* use `"allExcept": ['}']`)
 * ignores closing brackets in a row.
 *
 * #### Example
 *
 * ```js
 * "disallowSpacesInsideObjectBrackets": {
 *     "allExcept": [ "}", ")" ]
 * }
 *
 * // or
 * "disallowSpacesInsideObjectBrackets": true | "all" | "nested"
 * ```
 *
 * ##### Valid for mode `"all"`
 *
 * ```js
 * var x = {a: {b: 1}};
 * ```
 *
 * ##### Valid for mode `"nested"`
 *
 * ```js
 * var x = {a: {b: 1} };
 * ```
 *
 * ##### Valid for mode `"allExcept": ["}"]`
 *
 * ```js
 * var x = {a: {b: 1} };
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * var x = { a: { b: 1 } };
 * ```
 */

var assert = require('assert');

module.exports = function() {};

module.exports.prototype = {

    configure: function(value) {
        var mode;
        var modes = {
            'all': true,
            'nested': true
        };
        var isObject = typeof value === 'object';

        var error = this.getOptionName() + ' rule' +
        ' requires string "all" or "nested", true value or object';

        if (typeof value === 'string' || value === true) {
            assert(modes[value === true ? 'all' : value], error);

        } else if (isObject) {
            assert('allExcept' in value, error);
        } else {
            assert(false, error);
        }

        this._exceptions = {};

        if (isObject) {
            (value.allExcept || []).forEach(function(value) {
                this._exceptions[value] = true;
            }, this);

        } else {
            mode = value;
        }

        if (mode === 'nested') {
            this._exceptions['}'] = true;
        }
    },

    getOptionName: function() {
        return 'disallowSpacesInsideObjectBrackets';
    },

    check: function(file, errors) {
        var exceptions = this._exceptions;

        file.iterateNodesByType(['ObjectExpression', 'ObjectPattern'], function(node) {
            var openingBracket = file.getFirstNodeToken(node);
            var nextToken = file.getNextToken(openingBracket);

            errors.assert.noWhitespaceBetween({
                token: openingBracket,
                nextToken: nextToken,
                message: 'Illegal space after opening curly brace'
            });

            var closingBracket = file.getLastNodeToken(node);
            var prevToken = file.getPrevToken(closingBracket);

            if (prevToken.value in exceptions) {
                return;
            }

            errors.assert.noWhitespaceBetween({
                token: prevToken,
                nextToken: closingBracket,
                message: 'Illegal space before closing curly brace'
            });
        });
    }
};

},{"assert":171}],68:[function(require,module,exports){
/**
 * Disallows space after opening round bracket and before closing.
 *
 * Types: `Boolean` or `Object`
 *
 * Values: Either `true` or Object with `"only"` property as an array of tokens
 *
 * #### Example
 *
 * ```js
 * "disallowSpacesInsideParentheses": true
 * ```
 *
 * ##### Valid for `true` value
 *
 * ```js
 * var x = (1 + 2) * 3;
 * ```
 *
 * ##### Valid for `only` value
 *
 * ```js
 * "disallowSpacesInsideParentheses": { "only": [ "{", "}", "\"" ] }
 * ```
 * ```js
 * var x = ( 1 + 2 );
 * var x = foo({});
 * var x = foo("1");
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * var x = foo( {} );
 * ```
 */

var assert = require('assert');

module.exports = function() {};

module.exports.prototype = {

    configure: function(option) {
        var isObject = typeof option === 'object';

        var error = this.getOptionName() + ' option requires' +
            ' true or object value with "only" properties ';

        // backcompat for 1.10: {all: true} #1027
        if (isObject && option.all === true) {
            option = true;
        }

        if (typeof option === 'boolean') {
            assert(option === true, error);
        } else if (isObject) {
            assert('only' in option, error);
        } else {
            assert(false, error);
        }

        this._onlySingleQuote = false;
        this._onlyDoubleQuote = false;
        this._only = null;

        if (option.only) {
            this._only = {};

            (option.only).forEach(function(value) {
                if (value === '\'') {
                    this._onlySingleQuote = true;
                }

                if (value === '"') {
                    this._onlyDoubleQuote = true;
                }

                this._only[value] = true;
            }, this);
        }
    },

    getOptionName: function() {
        return 'disallowSpacesInsideParentheses';
    },

    check: function(file, errors) {
        var only = this._only;
        var singleQuote = this._onlySingleQuote;
        var doubleQuote = this._onlyDoubleQuote;

        file.iterateTokenByValue('(', function(token) {
            var nextToken = file.getNextToken(token, {includeComments: true});
            var value = nextToken.value;
            var shouldReturn = true;

            if (doubleQuote && nextToken.type === 'String' && value[0] === '"') {
                shouldReturn = false;
            }

            if (singleQuote && nextToken.type === 'String' && value[0] === '\'') {
                shouldReturn = false;
            }

            if (only && value in only) {
                shouldReturn = false;
            }

            if (!only) {
                shouldReturn = false;
            }

            if (shouldReturn) {
                return;
            }

            errors.assert.noWhitespaceBetween({
                token: token,
                nextToken: nextToken,
                message: 'Illegal space after opening round bracket'
            });
        });

        file.iterateTokenByValue(')', function(token) {
            var prevToken = file.getPrevToken(token, {includeComments: true});
            var value = prevToken.value;
            var shouldReturn = true;

            if (doubleQuote && prevToken.type === 'String' && value[value.length - 1] === '"') {
                shouldReturn = false;
            }

            if (singleQuote && prevToken.type === 'String' && value[value.length - 1] === '\'') {
                shouldReturn = false;
            }

            if (only) {
                if (value in only) {
                    shouldReturn = false;
                }

                if (
                    value === ']' &&
                    file.getNodeByRange(prevToken.range[0]).type === 'MemberExpression'
                ) {
                    shouldReturn = true;
                }
            } else {
                shouldReturn = false;
            }

            if (shouldReturn) {
                return;
            }

            errors.assert.noWhitespaceBetween({
                token: prevToken,
                nextToken: token,
                message: 'Illegal space before closing round bracket'
            });
        });
    }

};

},{"assert":171}],69:[function(require,module,exports){
/**
 * Disallows space after opening and before closing grouping parentheses.
 *
 * Types: `Boolean` or `Object`
 *
 * Values:
 * - `true`: always disallow spaces inside grouping parentheses
 * - `Object`:
 *      - `"allExcept"`: `[ "{", "}", "function" ]` Ignore parenthesized objects and functions
 *
 * #### Example
 *
 * ```js
 * "disallowSpacesInsideParenthesizedExpression": true
 *
 * // or
 *
 * "disallowSpacesInsideParenthesizedExpression": {
 *     "allExcept": [ "{", "}" ]
 * }
 * ```
 *
 * ##### Valid for mode `true`
 *
 * ```js
 * var x = (1 + obj.size) * (2);
 * ```
 *
 * ##### Valid for mode `{ allExcept": [ "{", "}", "function" ] }`
 *
 * ```js
 * var x = (options || { x: true } ).x;
 * var global = ( function() { return this; } )();
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * var x = ( 1 + obj.size ) * ( 2 );
 * ```
 */

var assert = require('assert');
var TokenCategorizer = require('../token-categorizer');

module.exports = function() {};

module.exports.prototype = {
    configure: function(value) {
        var isObject = typeof value === 'object';

        var error = this.getOptionName() + ' rule requires string value true or object';

        if (isObject) {
            assert('allExcept' in value, error);
        } else {
            assert(value === true, error);
        }

        this._exceptions = {};

        if (isObject) {
            (value.allExcept || []).forEach(function(value) {
                this._exceptions[value] = true;
            }, this);
        }
    },

    getOptionName: function() {
        return 'disallowSpacesInsideParenthesizedExpression';
    },

    check: function(file, errors) {
        var exceptions = this._exceptions;

        file.iterateTokenByValue('(', function(token) {
            var nextToken = file.getNextToken(token, {includeComments: true});
            var value = nextToken.isComment ?
                nextToken.type === 'Block' ? '/*' : '//' :
                nextToken.value;

            // Skip empty parentheses and explicit exceptions
            if (value === ')' || value in exceptions) {
                return;
            }

            // Skip non-expression parentheses
            var type = TokenCategorizer.categorizeOpenParen(token, file);
            if (type !== 'ParenthesizedExpression') {
                return;
            }

            errors.assert.noWhitespaceBetween({
                token: token,
                nextToken: nextToken,
                message: 'Illegal space after opening grouping parenthesis'
            });
        });

        file.iterateTokenByValue(')', function(token) {
            var prevToken = file.getPrevToken(token, {includeComments: true});
            var value = prevToken.isComment ?
                prevToken.type === 'Block' ? '*/' : '' :
                prevToken.value;

            // Skip empty parentheses and explicit exceptions
            if (value === '(' || value in exceptions) {
                return;
            }

            // Skip non-expression parentheses
            var type = TokenCategorizer.categorizeCloseParen(token, file);
            if (type !== 'ParenthesizedExpression') {
                return;
            }

            errors.assert.noWhitespaceBetween({
                token: prevToken,
                nextToken: token,
                message: 'Illegal space before closing grouping parenthesis'
            });
        });
    }
};

},{"../token-categorizer":164,"assert":171}],70:[function(require,module,exports){
/**
 * Disallows tabs everywhere.
 *
 * Type: `Boolean`
 *
 * Value: `true`
 *
 * #### Example
 *
 * ```js
 * "disallowTabs": true
 * ```
 *
 * ##### Valid
 *
 * ```js
 * if (true) {
 * \s\sfoo();
 * }
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * if (true){
 * \tfoo();
 * }
 * ```
 */

var assert = require('assert');

module.exports = function() {};

module.exports.prototype = {
    configure: function(options) {
        assert(
            options === true,
            this.getOptionName() + ' option requires a true value or should be removed'
        );
    },

    getOptionName: function() {
        return 'disallowTabs';
    },

    check: function(file, errors) {
        file.getLines().forEach(function(line, i) {
            var match = line.match(/\t/);
            if (match) {
                errors.add('Tab found', i + 1, match.index);
            }
        });
    }
};

},{"assert":171}],71:[function(require,module,exports){
/**
 * Disallows an extra comma following the final element of an array or object literal.
 *
 * Type: `Boolean`
 *
 * Value: `true`
 *
 * JSHint: [`es3`](http://jshint.com/docs/options/#es3)
 *
 * #### Example
 *
 * ```js
 * "disallowTrailingComma": true
 * ```
 *
 * ##### Valid
 *
 * ```js
 * var foo = [1, 2, 3];
 * var bar = {a: "a", b: "b"}
 * const [1, 2, 3];
 * const {a: "a", b: "b"}
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * var foo = [1, 2, 3, ];
 * var bar = {a: "a", b: "b", }
 * ```
 */

var assert = require('assert');

module.exports = function() {};

module.exports.prototype = {
    configure: function(options) {
        assert(
            options === true,
            this.getOptionName() + ' option requires a true value or should be removed'
        );
    },

    getOptionName: function() {
        return 'disallowTrailingComma';
    },

    check: function(file, errors) {
        file.iterateNodesByType([
            'ObjectExpression', 'ArrayExpression',
            'ObjectPattern', 'ArrayPattern'
        ], function(node) {
            var closingToken = file.getLastNodeToken(node);

            errors.assert.noTokenBefore({
                token: closingToken,
                expectedTokenBefore: {type: 'Punctuator', value: ','},
                message: 'Extra comma following the final element of an array or object literal'
            });
        });
    }

};

},{"assert":171}],72:[function(require,module,exports){
/**
 * Requires all lines to end on a non-whitespace character
 *
 * Types: `Boolean` or `String`
 *
 * Values:
 *  - `true`
 *  - `"ignoreEmptyLines"`: (default: `false`) allow whitespace on empty lines
 *
 * JSHint: [`trailing`](http://jshint.com/docs/options/#trailing)
 *
 * #### Example
 *
 * ```js
 * "disallowTrailingWhitespace": true
 * ```
 *
 * ##### Valid
 *
 * ```js
 * var foo = "blah blah";
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * var foo = "blah blah"; //<-- whitespace character here
 * ```
 *
 * ##### Valid for `true`
 *
 * ```js
 * foo = 'bar';
 *
 * foo = 'baz';
 * ```
 *
 * ##### Invalid for `true` but Valid for `ignoreEmptyLines`
 *
 * ```js
 * foo = 'bar';
 * \t
 * foo = 'baz';
 * ```
 */

var assert = require('assert');

module.exports = function() {};

module.exports.prototype = {

    configure: function(options) {
        assert(
            options === true || options === 'ignoreEmptyLines',
            this.getOptionName() + ' option requires a true value or "ignoreEmptyLines"'
        );
        this._ignoreEmptyLines = options === 'ignoreEmptyLines';
    },

    getOptionName: function() {
        return 'disallowTrailingWhitespace';
    },

    check: function(file, errors) {
        var ignoreEmptyLines = this._ignoreEmptyLines;
        var lines = file.getLines();

        for (var i = 0, l = lines.length; i < l; i++) {
            if (lines[i].match(/\s$/) && !(ignoreEmptyLines && lines[i].match(/^\s*$/))) {

                errors.cast({
                    message: 'Illegal trailing whitespace',
                    line: i + 1,
                    column: lines[i].length
                });
            }
        }
    },

    _fix: function(file, error) {
        var ignoreEmptyLines = this._ignoreEmptyLines;
        var currentLineNumber = error.line;
        var linebreak = file.getLineBreaks()[0] || '\n';
        var lines = file.getLines();

        var fixed = false;
        var startLineNumber;
        var precedingToken;
        var targetToken;

        while (!precedingToken && currentLineNumber > 0) {
            precedingToken = file.getLastTokenOnLine(currentLineNumber, {
                includeComments: true
            });
            currentLineNumber--;
        }

        if (precedingToken === null) {
            targetToken = file.getFirstToken({includeComments: true});
            startLineNumber = 1;
        } else {
            targetToken = file.getNextToken(precedingToken, {
                includeComments: true
            });
            startLineNumber = precedingToken.loc.end.line;

            if (precedingToken.isComment &&
                precedingToken.loc.start.line <= error.line &&
                precedingToken.loc.end.line >= error.line) {

                if (precedingToken.type === 'Block') {

                    if (ignoreEmptyLines) {
                        var blockLines = precedingToken.value.split(/\r\n|\n|\r/);

                        for (var k = 0; k < blockLines.length; k++) {

                            if (!blockLines[k].match(/^\s*$/) || k === 0) {
                                blockLines[k] = blockLines[k].split(/\s+$/).join('');
                            }
                        }

                        precedingToken.value = blockLines.join(linebreak);
                    } else {
                        precedingToken.value = precedingToken.value
                            .split(/[^\S\r\n]+\r\n|[^\S\n]+\n|[^\S\r]+\r/)
                            .join(linebreak);
                    }
                } else {
                    precedingToken.value = precedingToken.value.split(/\s+$/).join('');
                }

                fixed = true;
            }
        }

        if (targetToken !== null && !fixed) {
            var eolCount = targetToken.loc.start.line - startLineNumber + 1;
            var targetIndent = '';
            var targetLine = lines[targetToken.loc.start.line - 1];
            for (var j = 0, whitespace = targetLine.charAt(j);
                 whitespace.match(/\s/);
                 j++, whitespace = targetLine.charAt(j)) {
                targetIndent += whitespace;
            }

            file.setWhitespaceBefore(targetToken, new Array(eolCount).join(linebreak) + targetIndent);
            fixed = true;
        }

        if (!fixed && precedingToken && precedingToken.type === 'EOF') {
            precedingToken = file.getPrevToken(precedingToken, { includeWhitespace: true });
            if (precedingToken.isWhitespace) {
                precedingToken.value = precedingToken.value.replace(/[^\S\n\r]$/g, '');
                fixed = true;
            }
        }

        if (!fixed) {
            error.fixed = false;
        }
    }
};

},{"assert":171}],73:[function(require,module,exports){
/**
 * Disallows unused params in function expression and function declaration.
 *
 * Types: `Boolean`
 *
 * Values: `true`
 *
 * #### Example
 *
 * ```js
 * "disallowUnusedParams": true
 * ```
 *
 * ##### Valid
 *
 * ```js
 * function x(test) {
 *     return test;
 * }
 *
 * var x = function(test) {
 *     return test;
 * }
 * ```
 *
 * ##### Invalid
 *
 * ```js
  * function x(test) {
 * }
 *
 * var x = function(test) {
 * }
 * ```
 */

var assert = require('assert');

function getUsedParams(scope) {
    var vars;
    var res = [];

    if (scope.type === 'function-expression-name') {
        scope = scope.childScopes[0];
    }

    var length = scope.block.params.length;

    for (var i = 0; i <= length; i++) {
        vars = scope.variables[i];

        if (vars.name === 'arguments') {
            continue;
        }

        res.push({
            param: vars,
            used: !!vars.references.length
        });
    }

    var used = false;
    res.reverse().forEach(function(param) {
        if (used) {
            param.used = true;

            return;
        }

        if (param.used) {
            used = true;
        }
    });

    return res.reverse();
}

module.exports = function() {};

module.exports.prototype = {
    configure: function(options) {
        assert(
            options === true,
            this.getOptionName() + ' option requires a true value or should be removed'
        );
    },

    getOptionName: function() {
        return 'disallowUnusedParams';
    },

    check: function(file, errors) {
        file.iterateNodesByType(['FunctionDeclaration', 'FunctionExpression'], function(node) {
            var scope = file.getScope().acquire(node);
            var params = node.params;

            getUsedParams(scope).forEach(function(value, index) {
                if (value.used) {
                    return;
                }

                var param = params[index];

                errors.cast({
                    message: 'Param `' + value.param.name + '` is not used',
                    line: param.loc.start.line,
                    column: param.loc.start.column,
                    additional: {
                        node: param,
                        token: file.getFirstNodeToken(param)
                    }
                });
            });
        });
    },

    _fix: function(file, error) {
        var node = error.additional.node;
        var parent = node.parentNode;

        var index = parent.params.indexOf(node);
        var length = parent.params.length;

        var token = error.additional.token;

        var next;

        if (parent.params[index + 1]) {
            next = file.findNextToken(token, 'Identifier');
        }

        // For "b"

        // function test(b) {}
        if (length === 1) {
            file.removeToken(token);

            return;
        }

        // function test(a, b) {}
        if (length > 1 && index + 1 === length) {
            file.removeEntity(parent.params, node);
            var comma = file.findPrevToken(token, 'Punctuator', ',');
            file.setWhitespaceBefore(comma, '');
            file.removeToken(comma);
            file.setWhitespaceBefore(token, '');
            file.removeToken(token);

            return;
        }

        // function test(b, c) {}
        if (length > 1) {
            file.removeEntity(parent.params, node);
            file.removeToken(file.findNextToken(token, 'Punctuator', ','));
            file.setWhitespaceBefore(next, '');
            file.removeToken(token);

            return;
        }
    }
};

},{"assert":171}],74:[function(require,module,exports){
/**
 * Disallows declaring variables with `var`.
 *
 * Types: `Boolean`
 *
 * Values: `true`
 *
 * Version: `ES6`
 *
 * #### Example
 *
 * ```js
 * "disallowVar": true
 * ```
 *
 * ##### Valid
 *
 * ```js
 * let foo;
 * const bar;
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * var baz;
 * ```
 */

var assert = require('assert');

module.exports = function() { };

module.exports.prototype = {
    configure: function(option) {
        assert(option === true, this.getOptionName() + ' requires a true value');
    },

    getOptionName: function() {
        return 'disallowVar';
    },

    check: function(file, errors) {
        file.iterateNodesByType('VariableDeclaration', function(node) {
            for (var i = 0; i < node.declarations.length; i++) {
                var thisDeclaration = node.declarations[i];

                if (thisDeclaration.parentNode.kind === 'var') {
                    errors.add(
                      'Variable declarations should use `let` or `const` not `var`',
                      node.loc.start
                    );
                }
            }
        });
    }
};

},{"assert":171}],75:[function(require,module,exports){
/**
 * Requires the variable to be the left hand operator when doing a boolean comparison
 *
 * Type: `Array` or `Boolean`
 *
 * Values: Array of quoted operators or `true` to disallow yoda conditions for most possible comparison operators
 *
 * #### Example
 *
 * ```js
 * "disallowYodaConditions": [
 *     "==",
 *     "===",
 *     "!=",
 *     "!=="
 * ]
 * ```
 *
 * ##### Valid
 *
 * ```js
 * if (a == 1) {
 *     return
 * }
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * if (1 == a) {
 *     return
 * }
 * ```
 */

var assert = require('assert');

module.exports = function() {};

module.exports.prototype = {

    configure: function(operators) {
        var isTrue = operators === true;

        assert(
            Array.isArray(operators) || isTrue,
            this.getOptionName() + ' option requires array or true value'
        );

        if (isTrue) {
            operators = ['==', '===', '!=', '!=='];
        }

        this._operatorIndex = {};
        for (var i = 0, l = operators.length; i < l; i++) {
            this._operatorIndex[operators[i]] = true;
        }
    },

    getOptionName: function() {
        return 'disallowYodaConditions';
    },

    check: function(file, errors) {
        var operators = this._operatorIndex;
        file.iterateNodesByType('BinaryExpression', function(node) {
            if (operators[node.operator]) {
                if (node.left.type === 'Literal' ||
                    (node.left.type === 'Identifier' && node.left.name === 'undefined')
                ) {
                    errors.add('Yoda condition', node.left.loc.start);
                }
            }
        });
    }

};

},{"assert":171}],76:[function(require,module,exports){
/**
 * Validate jsdoc comments
 *
 * ## Usage
 *
 * ```json
 * {
 *     "jsDoc": {
 *         "checkAnnotations": "closurecompiler",
 *         "checkTypes": "strictNativeCase",
 *         "enforceExistence": "exceptExports"
 *         ...
 *     }
 * }
 * ```
 *
 * ## Rules
 *
 * ### checkAnnotations
 *
 * Checks tag names are valid.
 *
 * There are 3 presets for `Closure Compiler`, `JSDoc3` and `JSDuck5`.
 *
 * By default it allows any tag from any preset. You can pass `Object`
 * to select preset with `preset` field and add custom tags with `extra` field.
 *
 * Type: `Boolean` or `String` or `{"preset": String, "extra": Object}`
 * (see [tag values](#user-content-tag-values)).
 *
 * Values: `true`, `"closurecompiler"`, `"jsdoc3"`, `"jsduck5"`, `Object`
 *
 * Context: `file`
 *
 * Tags: `*`
 *
 * #### Tag values
 *
 * `extra` field should contains tags in keys and there are options for values:
 * - `false` means tag available with no value
 * - `true` means tag available with any value
 * - `"some"` means tag available and requires some value
 *
 * See also [tag presets](https://github.com/jscs-dev/jscs-jsdoc/tree/master/lib/tags).
 *
 * #### Example
 *
 * ```js
 * "checkAnnotations": true
 * ```
 *
 * ##### Valid
 *
 * ```js
 * /**
 *  * @chainable
 *  * @param {string} message
 *  * @return {string}
 *  *\/
 * function _f() {}
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * /**
 *  * @pororo
 *  * @lalala
 *  *\/
 * function _f() {}
 * ```
 *
 * #### Example 2
 *
 * ```js
 * "checkAnnotations": {
 *     "preset": "jsdoc3",
 *     "extra": {
 *         "boomer": false
 *     }
 * }
 * ```
 *
 * ##### Valid
 *
 * ```js
 * /**
 *  * @boomer
 *  * @argument {String}
 *  *\/
 * function _f() {}
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * /** @still-invalid *\/
 * ```
 *
 * ### checkParamExistence
 *
 * Checks all parameters are documented.
 *
 * Type: `Boolean`
 *
 * Values: `true`
 *
 *
 * #### Example
 *
 * ```js
 * "checkParamExistence": true
 * ```
 *
 * ##### Valid
 *
 * ```js
 * /**
 *  * @param {string} message
 *  * @return {string}
 *  *\/
 * function _f ( message ) {
 *   return true;
 * }
 *
 * /**
 *  * @inheritdoc
 *  *\/
 * function _f ( message ) {
 *   return true;
 * }
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * /**
 *  * @return {string}
 *  *\/
 * function _f ( message ) {
 *   return true;
 * }
 * ```
 *
 * ### checkParamNames
 *
 * Checks param names in jsdoc and in function declaration are equal.
 *
 * Type: `Boolean`
 *
 * Values: `true`
 *
 * Context: `functions`
 *
 * Tags: `param`, `arg`, `argument`
 *
 * #### Example
 *
 * ```js
 * "checkParamNames": true
 * ```
 *
 * ##### Valid
 *
 * ```js
 * /**
 *  * @param {String} message
 *  * @param {Number|Object} [line]
 *  *\/
 * function method(message, line) {}
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * /**
 *  * @param {String} msg
 *  * @param {Number|Object} [line]
 *  *\/
 * function method(message) {}
 * ```
 *
 * ### requireParamTypes
 *
 * Checks params in jsdoc contains type.
 *
 * Type: `Boolean`
 *
 * Values: `true`
 *
 * Context: `functions`
 *
 * Tags: `param`, `arg`, `argument`
 *
 * #### Example
 *
 * ```js
 * "requireParamTypes": true
 * ```
 *
 * ##### Valid
 *
 * ```js
 * /**
 *  * @param {String} message
 *  *\/
 * function method() {}
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * /**
 *  * @param message
 *  *\/
 * function method() {}
 * ```
 *
 * ### checkRedundantParams
 *
 * Reports redundant params in jsdoc.
 *
 * Type: `Boolean`
 *
 * Values: `true`
 *
 * Context: `functions`
 *
 * Tags: `param`, `arg`, `argument`
 *
 * #### Example
 *
 * ```js
 * "checkRedundantParams": true
 * ```
 *
 * ##### Valid
 *
 * ```js
 * /**
 *  * @param {String} message
 *  *\/
 * function method(message) {}
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * /**
 *  * @param {String} message
 *  *\/
 * function method() {}
 * ```
 *
 * ### checkReturnTypes
 *
 * Checks for differences between the jsdoc and actual return types if both exist.
 *
 * Type: `Boolean`
 *
 * Values: `true`
 *
 * Context: `functions`
 *
 * Tags: `return`, `returns`
 *
 * #### Example
 *
 * ```js
 * "checkReturnTypes": true
 * ```
 *
 * ##### Valid
 *
 * ```js
 * /**
 *  * @returns {String}
 *  *\/
 * function method() {
 *     return 'foo';
 * }
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * /**
 *  * @returns {String}
 *  *\/
 * function method(f) {
 *     if (f) {
 *         return true;
 *     }
 *     return 1;
 * }
 * ```
 *
 * ### checkRedundantReturns
 *
 * Report statements for functions without return.
 *
 * Type: `Boolean`
 *
 * Values: `true`
 *
 * Context: `functions`
 *
 * Tags: `return`, `returns`
 *
 * #### Example
 *
 * ```js
 * "checkRedundantReturns": true
 * ```
 *
 * ##### Valid
 *
 * ```js
 * /**
 *  * @returns {string}
 *  *\/
 * function f() {
 *     return 'yes';
 * }
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * /**
 *  * @returns {string}
 *  *\/
 * function f() {
 *     // no return here
 * }
 * ```
 *
 * ### requireReturnTypes
 *
 * Checks returns in jsdoc contains type
 *
 * Type: `Boolean`
 *
 * Values: `true`
 *
 * Context: `functions`
 *
 * Tags: `return`, `returns`
 *
 * #### Example
 *
 * ```js
 * "requireReturnTypes": true
 * ```
 *
 * ##### Valid
 *
 * ```js
 * /**
 *  * @returns {String}
 *  *\/
 * function method() {}
 *
 * /**
 *  * no @return
 *  *\/
 * function method() {}
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * /**
 *  * @returns
 *  *\/
 * function method() {}
 * ```
 *
 * ### checkTypes
 *
 * Reports invalid types for bunch of tags.
 *
 * The `strictNativeCase` mode checks that case of natives is the same as in this
 * list: `boolean`, `number`, `string`, `Object`, `Array`, `Date`, `RegExp`.
 *
 * The `capitalizedNativeCase` mode checks that the first letter in all native
 * types and primitives is uppercased except the case with `function` in google
 * closure format: `{function(...)}`
 *
 * Type: `Boolean` or `String`
 *
 * Values: `true` or `"strictNativeCase"` or `"capitalizedNativeCase"`
 *
 * Context: `*`
 *
 * Tags: `typedef`, `type`, `param`, `return`, `returns`, `enum`, `var`, `prop`,
 * `property`, `arg`, `argument`, `cfg`, `lends`, `extends`, `implements`, `define`
 *
 * #### Example
 *
 * ```js
 * "checkTypes": true
 * ```
 *
 * ##### Valid
 *
 * ```js
 * /**
 *  * @typedef {Object} ObjectLike
 *  * @property {boolean} hasFlag
 *  * @property {string} name
 *  *\/
 *
 * /** @type {number} *\/
 * var bar = 1;
 *
 * /** @const {number} *\/
 * var FOO = 2;
 *
 * /**
 *  * @const
 *  * @type {number}
 *  *\/
 * var BAZ = 3;
 *
 * /**
 *  * @param {SomeX} x
 *  * @returns {string}
 *  *\/
 * function method(x) {}
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * /** @type {some~number} *\/
 * var x = 1;
 *
 * /**
 *  * @param {function(redundantName: Number)} x
 *  *\/
 * function method(x) {}
 *
 * /**
 *  * @param {Number|Boolean|object|array} x invalid for strictNativeCase
 *  *\/
 * function method(x) {}
 * ```
 *
 * ```js
 * /** @type {some~number} *\/
 * var x = 1;
 * ```
 *
 * ### checkRedundantAccess
 *
 * Reports redundant access declarations.
 *
 * Type: `Boolean` or `String`
 *
 * Values: `true` or `"enforceLeadingUnderscore"` or `"enforceTrailingUnderscore"`
 *
 * Context: `functions`
 *
 * Tags: `access`, `private`, `protected`, `public`
 *
 * #### Example
 *
 * ```js
 * "checkRedundantAccess": true
 * "checkRedundantAccess": "enforceLeadingUnderscore"
 * ```
 *
 * ##### Valid for true, "enforceLeadingUnderscore"
 *
 * ```js
 * /**
 *  * @access private
 *  *\/
 * function _f() {}
 *
 * /**
 *  * @access public
 *  *\/
 * function f() {}
 * ```
 *
 * ##### Invalid for true
 *
 * ```js
 * /**
 *  * @private
 *  * @access private
 *  *\/
 * function _f() {}
 * ```
 *
 * ##### Invalid for "enforceLeadingUnderscore"
 *
 * ```js
 * /**
 *  * @private
 *  *\/
 * function _f() {}
 * ```
 *
 * ### leadingUnderscoreAccess
 *
 * Checks access declaration is set for `_underscored` function names
 *
 * Ignores a bunch of popular identifiers:
 * `__filename`, `__dirname`, `__proto__`, `__defineGetter__`, `super_`,
 * `__constructor`, etc.
 *
 * Type: `Boolean` or `String`
 *
 * Values: `true` (means not public), `"private"`, `"protected"`
 *
 * Context: `functions`
 *
 * Tags: `access`, `private`, `protected`, `public`
 *
 * #### Example
 *
 * ```js
 * "leadingUnderscoreAccess": "protected"
 * ```
 *
 * ##### Valid
 *
 * ```js
 * /**
 *  * @protected
 *  *\/
 * function _f() {}
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * function _g() {}
 *
 * /**
 *  * @private
 *  *\/
 * function _e() {}
 * ```
 *
 * ### enforceExistence
 *
 * Checks jsdoc block exists.
 *
 * Type: `Boolean`, `String` or `Object`
 *
 * Values:
 * - `true`
 * - `"exceptExports"` (*deprecated* use `"allExcept": ["exports"]`)
 * - `Object`:
 *   - `"allExcept"` array of exceptions:
 *     - `"expressions"` skip expression functions
 *     - `"exports"` skip `module.exports = function () {};`
 *     - `"paramless-procedures"` functions without parameters and with empty
 *       return statements will be skipped
 *
 * Context: `functions`
 *
 * #### Example
 *
 * ```js
 * "enforceExistence": true
 * ```
 *
 * ##### Valid
 *
 * ```js
 * /**
 *  * @protected
 *  *\/
 * function _f() {}
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * function _g() {}
 * ```
 *
 *
 * ### requireHyphenBeforeDescription
 *
 * Checks a param description has a hyphen before it (checks for `- `).
 *
 * Type: `Boolean`
 *
 * Values: `true`
 *
 * Context: `functions`
 *
 * Tags: `param`, `arg`, `argument`
 *
 * #### Example
 *
 * ```js
 * "requireHyphenBeforeDescription": true
 * ```
 *
 * ##### Valid
 *
 * ```js
 * /**
 *  * @param {String} - message
 *  *\/
 * function method() {}
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * /**
 *  * @param {String} message
 *  *\/
 * function method() {}
 * ```
 *
 *
 * ### requireNewlineAfterDescription
 *
 * Checks a doc comment description has padding newline.
 *
 * Type: `Boolean`
 *
 * Values: `true`
 *
 * Context: `functions`
 *
 * Tags: `*`
 *
 * #### Example
 *
 * ```js
 * "requireNewlineAfterDescription": true
 * ```
 *
 * ##### Valid
 *
 * ```js
 * /**
 *  * @param {String} msg - message
 *  *\/
 * function method(msg) {}
 *
 * /**
 *  * Description
 *  *\/
 * function method() {}
 *
 * /**
 *  * Description
 *  *
 *  * @param {String} msg - message
 *  *\/
 * function method(msg) {}
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * /**
 *  * Description
 *  * @param {String} message
 *  *\/
 * function method() {}
 * ```
 *
 *
 * ### disallowNewlineAfterDescription
 *
 * Checks a doc comment description has no padding newlines.
 *
 * Type: `Boolean`
 *
 * Values: `true`
 *
 * Context: `functions`
 *
 * Tags: `*`
 *
 * #### Example
 *
 * ```js
 * "disallowNewlineAfterDescription": true
 * ```
 *
 * ##### Valid
 *
 * ```js
 * /**
 *  * @param {String} msg - message
 *  *\/
 * function method(msg) {}
 *
 * /**
 *  * Description
 *  *\/
 * function method() {}
 *
 * /**
 *  * Description
 *  * @param {String} msg - message
 *  *\/
 * function method(msg) {}
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * /**
 *  * Description
 *  *
 *  * @param {String} message
 *  *\/
 * function method(message) {}
 * ```
 *
 *
 * ### requireDescriptionCompleteSentence
 *
 * Checks a doc comment description is a complete sentence.
 *
 * A complete sentence is defined as starting with an upper case letter and ending
 * with a period.
 *
 * Type: `Boolean`
 *
 * Values: `true`
 *
 * Context: `functions`
 *
 * Tags: `*`
 *
 * #### Example
 *
 * ```js
 * "requireDescriptionCompleteSentence": true
 * ```
 *
 * ##### Valid
 *
 * ```js
 * /**
 *  * @param {String} msg - message
 *  *\/
 * function method(msg) {}
 *
 * /**
 *  * Description.
 *  *\/
 * function method() {}
 *
 * /**
 *  * (Description).
 *  *\/
 * function method() {}
 *
 * /**
 *  * Description.
 *  *
 *  * @param {String} msg - message
 *  *\/
 * function method(msg) {}
 *
 * /**
 *  * Description
 *  * on multiple lines are allowed.
 *  *
 *  * @param {String} msg - message
 *  *\/
 * function method(msg) {}
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * /**
 *  * Description
 *  * @param {String} message
 *  *\/
 * function method() {}
 *
 * /**
 *  * Description
 *  * On multiple lines should not start with an upper case.
 *  *
 *  * @param {String} - message
 *  *\/
 * function method() {}
 *
 * /**
 *  * description starting with a lower case letter.
 *  * @param {String} message
 *  *\/
 * function method() {}
 *
 * /**
 *  * Description period is offset .
 *  * @param {String} message
 *  *\/
 * function method() {}
 *
 * /**
 *  * Description!
 *  * @param {String} message
 *  *\/
 * function method() {}
 * ```
 *
 *
 * ### requireParamDescription
 *
 * Checks a param description exists.
 *
 * Type: `Boolean`
 *
 * Values: `true`
 *
 * Context: `functions`
 *
 * Tags: `param`, `arg`, `argument`
 *
 * #### Example
 *
 * ```js
 * "requireParamDescription": true
 * ```
 *
 * ##### Valid
 *
 * ```js
 * /**
 *  * @param {String} arg message
 *  *\/
 * function method(arg) {}
 *
 * /**
 *  * @param arg message
 *  *\/
 * function method(arg) {}
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * /**
 *  * @param {String} arg
 *  *\/
 * function method(arg) {}
 *
 * /**
 *  * @param arg
 *  *\/
 * function method(arg) {}
 * ```
 *
 *
 * ### requireReturnDescription
 *
 * Checks a return description exists.
 *
 * Type: `Boolean`
 *
 * Values: `true`
 *
 * Context: `functions`
 *
 * Tags: `return`, `returns`
 *
 * #### Example
 *
 * ```js
 * "requireReturnDescription": true
 * ```
 *
 * ##### Valid
 *
 * ```js
 * /**
 *  * @returns {Boolean} Method result.
 *  *\/
 * function method() {
 *   return false;
 * }
 *
 * /**
 *  * @returns {String} method result
 *  *\/
 * function method() {
 *   return 'Hello!';
 * }
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * /**
 *  * @returns {Boolean}
 *  *\/
 * function method() {
 *   return false;
 * }
 * ```
 *
 */
module.exports = require('jscs-jsdoc/lib/rules/validate-jsdoc');

},{"jscs-jsdoc/lib/rules/validate-jsdoc":709}],77:[function(require,module,exports){
/**
 * Requires all lines to be at most the number of characters specified
 *
 * Types: `Integer` or `Object`
 *
 * Values:
 *  - `Integer`: lines should be at most the number of characters specified
 *  - `Object`:
 *     - `value`: (required) lines should be at most the number of characters specified
 *     - `tabSize`: (default: `1`) considered the tab character as number of specified spaces
 *     - `allExcept`: (default: `[]`) an array of conditions that will exempt a line
 *        - `regex`: allows regular expression literals to break the rule
 *        - `comments`: allows comments to break the rule
 *        - `urlComments`: allows comments with long urls to break the rule
 *        - `functionSignature`: allows function definitions to break the rule
 *        - `require`: allows require expressions to break the rule
 *     - `allowRegex`: *deprecated* use `allExcept: ["regex"]` instead
 *     - `allowComments`: *deprecated* use `allExcept: ["comments"]` instead
 *     - `allowUrlComments`: *deprecated* use `allExcept: ["urlComments"]` instead
 *
 * JSHint: [`maxlen`](http://jshint.com/docs/options/#maxlen)
 *
 * #### Example
 *
 * ```js
 * "maximumLineLength": 40
 * ```
 *
 * ##### Valid
 *
 * ```js
 * var aLineOf40Chars = 123456789012345678;
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * var aLineOf41Chars = 1234567890123456789;
 * ```
 *
 * #### Example for allExcept functionSignature
 *
 * ```js
 * "maximumLineLength": { "value": 40, "allExcept": [ "functionSignature" ] }
 * ```
 *
 * ##### Valid
 *
 * ```js
 * var f = function(with, many, _many_, arguments) { .... };
 * let f = x => x * x * x * x * x * x * x * x;
 * (function(foo, bar, baz, quux, cuttlefish) {
 *     function namesNaamesNaaamesNaaaames() {
 *         ...
 *     }
 * })();
 * const longNameIgnoredAsWell = (a, b) => a * b;
 * class X { myLongMethodName(withPossiblyManyArgs) { ... } };
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * function x() { // valid
 *     return "function_bodies_are_not_protected";
 * }
 * ```
 */

var assert = require('assert');

module.exports = function() {};

module.exports.prototype = {

    configure: function(maximumLineLength) {
        this._tabSize = '';
        this._allowRegex = false;
        this._allowComments = false;
        this._allowUrlComments = false;
        this._allowRequire = false;

        if (typeof maximumLineLength === 'object') {
            assert(
                typeof maximumLineLength.value === 'number',
                this.getOptionName() + ' option requires the "value" property to be defined'
            );

            this._maximumLineLength = maximumLineLength.value;
            var tabSize = maximumLineLength.tabSize || 0;

            while (tabSize--) {
                this._tabSize += ' ';
            }

            var exceptions = maximumLineLength.allExcept || [];
            this._allowRegex = (exceptions.indexOf('regex') !== -1);
            this._allowComments = (exceptions.indexOf('comments') !== -1);
            this._allowUrlComments = (exceptions.indexOf('urlComments') !== -1);
            this._allowFunctionSignature = (exceptions.indexOf('functionSignature') !== -1);
            this._allowRequire = (exceptions.indexOf('require') !== -1);

            if (maximumLineLength.hasOwnProperty('allowRegex')) {
                this._allowRegex = (maximumLineLength.allowRegex === true);
            }
            if (maximumLineLength.hasOwnProperty('allowComments')) {
                this._allowComments = (maximumLineLength.allowComments === true);
            }
            if (maximumLineLength.hasOwnProperty('allowUrlComments')) {
                this._allowUrlComments = (maximumLineLength.allowUrlComments === true);
            }

        } else {
            assert(
                typeof maximumLineLength === 'number',
                this.getOptionName() + ' option requires number value or options object'
            );

            this._maximumLineLength = maximumLineLength;
        }
    },

    getOptionName: function() {
        return 'maximumLineLength';
    },

    check: function(file, errors) {
        var maximumLineLength = this._maximumLineLength;

        var line;
        var lines = this._allowComments ?
            file.getLinesWithCommentsRemoved() : file.getLines();

        // This check should not be destructive
        lines = lines.slice();

        var removeLoc = function(tokenOrNode) {
            for (var i = tokenOrNode.loc.start.line; i <= tokenOrNode.loc.end.line; i++) {
                lines[i - 1] = '';
            }
        };

        if (this._allowRegex) {
            file.iterateTokensByType('RegularExpression', function(token) {
                removeLoc(token);
            });
        }

        if (this._allowUrlComments) {
            file.iterateTokensByType(['Line', 'Block'], function(comment) {
                for (var i = comment.loc.start.line; i <= comment.loc.end.line; i++) {
                    lines[i - 1] = lines[i - 1].replace(/(http|https|ftp):\/\/[^\s$]+/, '');
                }
            });
        }

        if (this._allowFunctionSignature) {
            file.iterateNodesByType('FunctionDeclaration', function(node) {
                removeLoc(node.id);
                node.params.forEach(removeLoc);
            });

            file.iterateNodesByType('MethodDefinition', function(node) {
                removeLoc(node.key);
            });

            file.iterateNodesByType(['ArrowFunctionExpression', 'FunctionExpression'], function(node) {

                // Need to remove the first line, because we can't be sure there's any id or params
                lines[node.loc.start.line - 1] = '';
                if (node.id) {
                    removeLoc(node.id);
                }
                node.params.forEach(removeLoc);
            });
        }

        if (this._allowRequire) {
            file.iterateNodesByType('CallExpression', function(node) {
                if (node.callee.name === 'require') {
                    removeLoc(node);
                }
            });
        }

        for (var i = 0, l = lines.length; i < l; i++) {
            line = this._tabSize ? lines[i].replace(/\t/g, this._tabSize) : lines[i];

            if (line.length > maximumLineLength) {
                errors.add(
                    'Line must be at most ' + maximumLineLength + ' characters',
                    i + 1,
                    lines[i].length
                );
            }
        }
    }

};

},{"assert":171}],78:[function(require,module,exports){
/**
 * Requires the file to be at most the number of lines specified
 *
 * Types: `Integer` or `Object`
 *
 * Values:
 * - `Integer`: file should be at most the number of lines specified
 * - `Object`:
 *     - `value`: (required) lines should be at most the number of characters specified
 *     - `allExcept`: (default: `[]`) an array of conditions that will exempt a line
 *        - `comments`: allows comments to break the rule
*
 * #### Example
 *
 * ```js
 * "maximumNumberOfLines": 100
 * ```
 */

var assert = require('assert');

module.exports = function() {};

module.exports.prototype = {

    configure: function(options) {
        this._allowComments = true;

        if (typeof options === 'number') {
            assert(
                typeof options === 'number',
                this.getOptionName() + ' option requires number value or options object'
            );
            this._maximumNumberOfLines = options;
        } else {
            assert(
                typeof options.value === 'number',
                this.getOptionName() + ' option requires the "value" property to be defined'
            );
            this._maximumNumberOfLines = options.value;

            var exceptions = options.allExcept || [];
            this._allowComments = (exceptions.indexOf('comments') === -1);
        }
    },

    getOptionName: function() {
        return 'maximumNumberOfLines';
    },

    check: function(file, errors) {
        var firstToken = file.getFirstToken({includeComments: true});
        var lines = this._allowComments ?
             file.getLines() : file.getLinesWithCommentsRemoved();

        lines = lines.filter(function(line) {return line !== '';});

        if (lines.length > this._maximumNumberOfLines) {
            errors.add('File must be at most ' + this._maximumNumberOfLines + ' lines long',
                       firstToken.loc.end.line,
                       firstToken.loc.end.column);
        }
    }

};

},{"assert":171}],79:[function(require,module,exports){
/**
 * Enforces indentation of parameters in multiline functions
 *
 * Types: `Boolean`, `String`, `Number`
 *
 * Values:
 *  - `true` to require parameters are aligned with the body of the function
 *  - `'firstParam'` to require parameters to be aligned with the first parameter
 *  - `Number` for the number of columns the parameters should be indented past the function body
 *
 * #### Example
 *
 * ```js
 * "requireAlignedMultilineParams": true
 * ```
 *
 * ##### Valid for `true`
 *
 * ```js
 * var test = function(one, two,
 *   three, four, five,
 *   six, seven, eight) {
 *   console.log(a);
 * };
 * ```
 *
 * ##### Valid for `2`
 *
 * ```js
 * var test = function(one, two,
 *     three, four, five,
 *     six, seven, eight) {
 *   console.log(a);
 * };
 * ```
 *
 * ##### Valid for `'firstParam'`
 *
 * ```js
 * var test = function(one, two,
 *                     three, four, five,
 *                     six, seven, eight) {
 *   console.log(a);
 * };
 * ```
 *
 * ##### Invalid for `0`
 *
 * ```js
 * var test = function(one, two,
 *     three, four, five,
 *     six, seven, eight) {
 *   console.log(a);
 * };
 * ```
 *
 */

var assert = require('assert');

module.exports = function() {
};

module.exports.prototype = {

    configure: function(option) {
        if (typeof option === 'number') {
            this._indentationLevel = option;
        } else if (typeof option === 'string') {
            assert(
                option === 'firstParam',
                this.getOptionName() + ' option requires string value to be "firstParam"'
            );

            this._alignWithFirstParam = true;
        } else if (option === true) {
            this._indentationLevel = 0;
        } else {
            assert(
                false,
                this.getOptionName() + ' option requires a valid option'
            );
        }
    },

    getOptionName: function() {
        return 'requireAlignedMultilineParams';
    },

    check: function(file, errors) {
        var _this = this;
        file.iterateNodesByType(['FunctionDeclaration', 'FunctionExpression'], function(node) {
            var params = node.params;

            // We can pass the check if there's no params
            if (params.length === 0) {
                return;
            }

            var currentLine = params[0].loc.start.line;
            var referenceColumn;
            var body;

            if (_this._alignWithFirstParam) {
                referenceColumn = params[0].loc.start.column;
            } else {

                body = node.body.body[0];

                // If function doesn't have a body just bail out (#1988)
                if (!body) {
                    return;
                }

                referenceColumn = body.loc.start.column + _this._indentationLevel;
            }

            params.forEach(function(param) {
                if (param.loc.start.line !== currentLine) {
                    if (param.loc.start.column !== referenceColumn) {
                        errors.assert.indentation({
                            lineNumber: param.loc.start.line,
                            actual: param.loc.start.column,
                            expected: referenceColumn,
                            indentChar: ' ',
                            silent: false
                        });
                    }

                    currentLine = param.loc.start.line;
                }
            });

        });
    }

};

},{"assert":171}],80:[function(require,module,exports){
/**
 * Requires proper alignment in object literals.
 *
 * Type: `String`
 *
 * Values:
 *  - `"all"` for strict mode,
 *  - `"ignoreFunction"` ignores objects if one of the property values is a function expression,
 *  - `"ignoreLineBreak"` ignores objects if there are line breaks between properties
 *
 * #### Example
 *
 * ```js
 * "requireAlignedObjectValues": "all"
 * ```
 *
 * ##### Valid
 * ```js
 * var x = {
 *     a   : 1,
 *     bcd : 2,
 *     ef  : 'str'
 * };
 * ```
 * ##### Invalid
 * ```js
 * var x = {
 *     a : 1,
 *     bcd : 2,
 *     ef : 'str'
 * };
 * ```
 */

var assert = require('assert');

module.exports = function() {};

module.exports.prototype = {

    configure: function(mode) {
        var modes = {
            'all': 'all',
            'ignoreFunction': 'ignoreFunction',
            'ignoreLineBreak': 'ignoreLineBreak',
            'skipWithFunction': 'ignoreFunction',
            'skipWithLineBreak': 'ignoreLineBreak'
        };
        assert(
            typeof mode === 'string' && modes[mode],
            this.getOptionName() + ' requires one of the following values: ' + Object.keys(modes).join(', ')
        );
        this._mode = modes[mode];
    },

    getOptionName: function() {
        return 'requireAlignedObjectValues';
    },

    check: function(file, errors) {
        var mode = this._mode;

        file.iterateNodesByType('ObjectExpression', function(node) {
            if (node.loc.start.line === node.loc.end.line || node.properties < 2) {
                return;
            }

            var maxKeyEndPos = 0;
            var prevKeyEndPos = 0;
            var minColonPos = 0;
            var tokens = [];
            var skip = node.properties.some(function(property, index) {
                if (property.shorthand || property.method || property.kind !== 'init' ||
                    node.type === 'SpreadProperty') {
                    return true;
                }

                if (mode === 'ignoreFunction' && property.value.type === 'FunctionExpression') {
                    return true;
                }

                if (mode === 'ignoreLineBreak' && index > 0 &&
                     node.properties[index - 1].loc.end.line !== property.loc.start.line - 1) {
                    return true;
                }

                prevKeyEndPos = maxKeyEndPos;
                maxKeyEndPos = Math.max(maxKeyEndPos, property.key.loc.end.column);
                var keyToken = file.getFirstNodeToken(property.key);
                if (property.computed === true) {
                    while (keyToken.value !== ']') {
                        keyToken = file.getNextToken(keyToken);
                    }
                }
                var colon = file.getNextToken(keyToken);
                if (prevKeyEndPos < maxKeyEndPos) {
                    minColonPos = colon.loc.start.column;
                }
                tokens.push({key: keyToken, colon: colon});
            });

            if (skip) {
                return;
            }

            var space = minColonPos - maxKeyEndPos;
            tokens.forEach(function(pair) {
                errors.assert.spacesBetween({
                    token: pair.key,
                    nextToken: pair.colon,
                    exactly: maxKeyEndPos - pair.key.loc.end.column + space,
                    message: 'Alignment required'
                });
            });
        });
    }

};

},{"assert":171}],81:[function(require,module,exports){
/**
 * Requires that a function expression be anonymous.
 *
 * Type: `Boolean`
 *
 * Values:
 *  - `true`
 *  - `Object`:
 *    - `'allExcept'` array of exceptions:
 *       - `'declarations'` ignores function declarations
 *
 * #### Example
 *
 * ```js
 * "requireAnonymousFunctions": true
 * ```
 *
 * ##### Valid
 *
 * ```js
 * var a = function() {
 *
 * };
 *
 * $('#foo').click(function() {
 *
 * })
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * var a = function foo() {
 *
 * };
 *
 * $('#foo').click(function bar() {
 *
 * });
 * ```
 *
 * ##### Valid for `{ "allExcept": ["declarations"] }`
 *
 * ```js
 * function foo() {
 *
 * }
 *
 * $('#foo').click(function() {
 *
 * })
 * ```
 *
 */

var assert = require('assert');

module.exports = function() {};

module.exports.prototype = {
    configure: function(options) {
        var optionName = this.getOptionName();

        if (typeof options === 'object') {
            assert(Array.isArray(options.allExcept), optionName + ' option requires "allExcept" to be an array');
            assert(options.allExcept.length > 0, optionName + ' option requires "allExcept" to have at least one ' +
            ' item or be set to `true`');
            this._exceptDeclarations = options.allExcept.indexOf('declarations') > -1;
        } else {
            assert(options === true, this.getOptionName() + ' option requires either a true value or an object');
        }
    },

    getOptionName: function() {
        return 'requireAnonymousFunctions';
    },

    check: function(file, errors) {
        var exceptDeclarations = this._exceptDeclarations;

        file.iterateNodesByType(['FunctionExpression', 'FunctionDeclaration'], function(node) {
            if (exceptDeclarations && node.type === 'FunctionDeclaration') {
                return;
            }
            if (node.id !== null) {
                errors.add('Functions must not be named', node.loc.start);
            }
        });
    }
};

},{"assert":171}],82:[function(require,module,exports){
/**
 * Requires that variable assignment from array values are * destructured.
 *
 * Type: `Boolean`
 *
 * Values: `true`
 *
 * Version: `ES6`
 *
 * #### Example
 *
 * ```js
 * "requireArrayDestructuring": true
 * ```
 *
 * ##### Valid
 *
 * ```js
 * var colors = ['red', 'green', 'blue'];
 * var [ red ] = colors;
 *
 * var attributes = {
 *   colors: ['red', 'green', 'blue'];
 * };
 *
 * var [ red ] = attributes.colors;
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * var colors = ['red', 'green', 'blue'];
 * var red = colors[0];
 *
 * var attributes = {
 *   colors: ['red', 'green', 'blue'];
 * };
 *
 * var red = attributes.colors[0];
 * ```
 */

var assert = require('assert');

module.exports = function() {};

module.exports.prototype = {
    configure: function(option) {
        assert(option === true, this.getOptionName() + ' requires a true value');
    },

    getOptionName: function() {
        return 'requireArrayDestructuring';
    },

    check: function(file, errors) {
        file.iterateNodesByType('VariableDeclaration', function(node) {

            node.declarations.forEach(function(declaration) {
                if (!declaration.init || declaration.init.type !== 'MemberExpression') {
                    return;
                }

                var property = declaration.init.property || {};
                if (property.type === 'Literal' && /^\d+$/.test(property.value)) {
                    errors.add('Use array destructuring', property.loc.start);
                }
            });
        });
    }
};

},{"assert":171}],83:[function(require,module,exports){
/**
 * Requires that arrow functions are used instead of anonymous function expressions in callbacks.
 *
 * Type: `Boolean`
 *
 * Value: `true`
 *
 * Version: `ES6`
 *
 * #### Example
 *
 * ```js
 * "requireArrowFunctions": true
 * ```
 *
 * ##### Valid
 *
 * ```js
 * // arrow function
 * [1, 2, 3].map((x) => {
 *     return x * x;
 * });
 * // function declaration
 * function a(n) { return n + 1; }
 * // getter/setter
 * var x = { get y() {}, set y(y) {} }
 * // object shorthand
 * var x = { bar() {} }
 * // class method
 * class Foo { bar() {} }
 * // function expression in a return statement
 * function a(x) {
 *     return function(x) { return x };
 * };
 * // function expression in a variable declaration
 * var a = function(x) { return x };
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * // function expression in a callback
 * [1, 2, 3].map(function (x) {
 *     return x * x;
 * });
 * ```
 */

var assert = require('assert');

module.exports = function() {};

module.exports.prototype = {
    configure: function(options) {
        assert(
            options === true,
            this.getOptionName() + ' option requires a true value or should be removed'
        );
    },

    getOptionName: function() {
        return 'requireArrowFunctions';
    },

    check: function(file, errors) {

        function isCallback(node) {
            return node.type === 'FunctionExpression' && node.parentNode.type === 'CallExpression';
        }

        function isFunctionBindWithThis(node) {
            return node.callee &&
            node.callee.type === 'MemberExpression' &&
            node.callee.object.type === 'FunctionExpression' &&
            node.callee.property.type === 'Identifier' &&
            node.callee.property.name === 'bind' &&
            node.arguments &&
            node.arguments.length === 1 && node.arguments[0].type === 'ThisExpression';
        }

        file.iterateNodesByType(['FunctionExpression', 'CallExpression'], function(node) {
            if (isCallback(node) || isFunctionBindWithThis(node)) {
                errors.add('Use arrow functions instead of function expressions', node.loc.start);
            }

        });
    }
};

},{"assert":171}],84:[function(require,module,exports){
/**
 * Requires blocks to begin and end with a newline
 *
 * Types: `Boolean`, `Integer`, `Object`
 *
 * Values:
 *  - `true` validates all non-empty blocks
 *  - `Integer` specifies a minimum number of lines containing elements in the block before validating
 *  - `Object`:
 *      - `'includeComments'`
 *          - `true` includes comments as part of the validation
 *      - `'minLines'`
 *          - `Integer` specifies a minimum number of lines containing elements in the block before validating
 *
 * #### Examples
 *
 * ```js
 * "requireBlocksOnNewline": true
 * "requireBlocksOnNewline": 1
 * "requireBlocksOnNewline": {
 *      "includeComments": true
 * }
 * "requireBlocksOnNewline": {
 *      "includeComments": true,
 *      "minLines": 1
 * }
 * ```
 *
 * ##### Valid for mode `true`
 *
 * ```js
 * if (true) {
 *     doSomething();
 * }
 * var abc = function() {};
 * // or
 * if (true) { //comments
 *     doSomething();
 * }
 * var abc = function() {};
 * // or
 * if (true) {
 *     doSomething();
 * /** comments *\/
 * }
 * var abc = function() {};
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * if (true) {doSomething();}
 * ```
 *
 * ##### Valid for mode `1`
 *
 * ```js
 * if (true) {
 *     doSomething();
 *     doSomethingElse();
 * }
 * if (true) { doSomething(); }
 * var abc = function() {};
 * // or
 * if (true) { //comments
 *     doSomething();
 *     doSomethingElse();
 * }
 * if (true) { doSomething(); }
 * var abc = function() {};
 * ```
 *
 * ```js
 * if (true) {
 *     doSomething();
 *     doSomethingElse();
 *     /** comments *\/
 * }
 * if (true) { doSomething(); }
 * var abc = function() {};
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * if (true) { doSomething(); doSomethingElse(); }
 * ```
 *
 * ##### Valid for mode `{ includeComments: true }`
 *
 * ```js
 * if (true) {
 *     //comments
 *     doSomething();
 * }
 * var abc = function() {};
 * // or
 * if (true) {
 *     doSomething();
 *      //comments
 * }
 * var abc = function() {};
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * if (true) { //comments
 *     doSomething();
 * }
 * var abc = function() {};
 * // or
 * if (true) {
 *     doSomething();
 * /** comments *\/}
 * var abc = function() {};
 * ```
 *
 * ##### Valid for mode `{ includeComments: true, minLines: 1 }`
 *
 * ```js
 * if (true) {
 *     //comments
 *     doSomething();
 *     doSomethingElse();
 * }
 * if (true) { doSomething(); }
 * var abc = function() {};
 * // or
 * if (true) {
 *     doSomething();
 *     doSomethingElse();
 *     //comments
 * }
 * if (true) { doSomething(); }
 * var abc = function() {};
 * ```
 *
 * ##### Invalid
 * ```js
 * if (true) { //comments
 *     doSomething();
 *     doSomethingElse();
 * }
 * if (true) { doSomething(); }
 * var abc = function() {};
 * // or
 * if (true) {
 *     doSomething();
 *     doSomethingElse();
 *     /** comments *\/}
 * if (true) { doSomething(); }
 * var abc = function() {};
 * ```
 *
 */

var assert = require('assert');

function hasCommentInBlock(block, commentTokens) {
    var count;
    var comment;

    for (count = 0; count < commentTokens.length; count++) {
        comment = commentTokens[count];
        if (comment.range[0] >= block.range[0] &&
            comment.range[1] <= block.range[1]) {
            return true;
        }
    }
    return false;
}

module.exports = function() {};

module.exports.prototype = {

    configure: function(options) {
        var optionType = typeof options;
        assert(
            options === true || optionType === 'number' || optionType === 'object',
            this.getOptionName() + ' option requires the value true, an Integer or an object'
        );

        this._minLines = 0;
        this._includeComments = false;
        if (optionType === 'number') {
            this._minLines = options;
        } else if (optionType === 'object') {
            assert(
                options.includeComments === true,
                this.getOptionName() + ' option requires includeComments property to be true for object'
            );
            this._includeComments = options.includeComments;

            if (options.hasOwnProperty('minLines')) {
                assert(
                    typeof options.minLines === 'number',
                    this.getOptionName() + ' option requires minLines property to be an integer for object'
                );
                this._minLines = options.minLines;
            }
        }

        assert(
            this._minLines >= 0,
            this.getOptionName() + ' option requires minimum statements setting to be >= 0'
        );
    },

    getOptionName: function() {
        return 'requireBlocksOnNewline';
    },

    check: function(file, errors) {
        var minLines = this._minLines;
        var includeComments = this._includeComments;
        var commentTokens = [];

        file.iterateTokensByType(['Line', 'Block'], function(commentToken) {
            commentTokens.push(commentToken);
        });

        file.iterateNodesByType('BlockStatement', function(node) {
            var hasComment = false;
            if (includeComments === true) {
                hasComment = hasCommentInBlock(node, commentTokens);
            }

            if (hasComment === false && node.body.length <= minLines) {
                return;
            }

            var openingBracket = file.getFirstNodeToken(node);
            var nextToken = file.getNextToken(openingBracket, { includeComments: includeComments });

            errors.assert.differentLine({
                token: openingBracket,
                nextToken: nextToken,
                message: 'Missing newline after opening curly brace'
            });

            var closingBracket = file.getLastNodeToken(node);
            var prevToken = file.getPrevToken(closingBracket, { includeComments: includeComments });

            errors.assert.differentLine({
                token: prevToken,
                nextToken: closingBracket,
                message: 'Missing newline before closing curly brace'
            });
        });
    }

};

},{"assert":171}],85:[function(require,module,exports){
/**
 * Requires identifiers to be camelCased or UPPERCASE_WITH_UNDERSCORES
 *
 * Types: `Boolean` or `String` or `Object`
 *
 * Values:
 *
 * - `true`
 * - `"ignoreProperties"` allows an exception for object property names. Deprecated, Please use the `Object` value
 * - `Object`:
 *    - `ignoreProperties`:  boolean that allows an exception for object property names
 *    - `strict`: boolean that forces the first character to not be capitalized
 *    - `allowedPrefixes`: array of String, RegExp, or ESTree RegExpLiteral values permitted as prefixes
 *    - `allowedSuffixes`: array of String, RegExp, or ESTree RegExpLiteral values permitted as suffixes
 *    - `allExcept`: array of String, RegExp, or ESTree RegExpLiteral values permitted as exceptions
 *
 * JSHint: [`camelcase`](http://jshint.com/docs/options/#camelcase)
 *
 * #### Example
 *
 * ```js
 * "requireCamelCaseOrUpperCaseIdentifiers": true
 *
 * "requireCamelCaseOrUpperCaseIdentifiers": {"ignoreProperties": true, "strict": true}
 *
 * "requireCamelCaseOrUpperCaseIdentifiers": {"allowedPrefixes": ["opt_", /pfx\d+_/]}
 *
 * "requireCamelCaseOrUpperCaseIdentifiers": {"allowedSuffixes": ["_dCel", {regex: {pattern: "_[kMG]?Hz"}}]}
 *
 * "requireCamelCaseOrUpperCaseIdentifiers": {"allExcept": ["var_args", {regex: {pattern: "^ignore", flags: "i"}}]}
 * ```
 *
 * ##### Valid for mode `true`
 *
 * ```js
 * var camelCase = 0;
 * var CamelCase = 1;
 * var _camelCase = 2;
 * var camelCase_ = 3;
 * var UPPER_CASE = 4;
 * ```
 *
 * ##### Invalid for mode `true`
 *
 * ```js
 * var lower_case = 1;
 * var Mixed_case = 2;
 * var mixed_Case = 3;
 * ```
 *
 * ##### Valid for mode `ignoreProperties`
 *
 * ```js
 * var camelCase = 0;
 * var CamelCase = 1;
 * var _camelCase = 2;
 * var camelCase_ = 3;
 * var UPPER_CASE = 4;
 * var obj.snake_case = 5;
 * var camelCase = { snake_case: 6 };
 * ```
 *
 * ##### Invalid for mode `ignoreProperties`
 *
 * ```js
 * var lower_case = 1;
 * var Mixed_case = 2;
 * var mixed_Case = 3;
 * var snake_case = { snake_case: 6 };
 * ```
 *
 * ##### Valid for mode `strict`
 *
 * ```js
 * var camelCase = 0;
 * var _camelCase = 2;
 * var camelCase_ = 3;
 * var UPPER_CASE = 4;
 * var obj.snake_case = 5;
 * var camelCase = { snake_case: 6 };
 * ```
 *
 * ##### Invalid for mode `strict`
 *
 * ```js
 * var Mixed_case = 2;
 * var Snake_case = { snake_case: 6 };
 * var snake_case = { SnakeCase: 6 };
 * ```
 *
 * ##### Valid for `{ allowedPrefix: ["opt_", /pfx\d+_/] }`
 * ```js
 * var camelCase = 0;
 * var CamelCase = 1;
 * var _camelCase = 2;
 * var camelCase_ = 3;
 * var UPPER_CASE = 4;
 * var opt_camelCase = 5;
 * var pfx32_camelCase = 6;
 * ```
 *
 * ##### Invalid for `{ allowedPrefix: ["opt_", /pfx\d+/] }`
 * ```js
 * var lower_case = 1;
 * var Mixed_case = 2;
 * var mixed_Case = 3;
 * var req_camelCase = 4;
 * var pfx_CamelCase = 5;
 * ```
 *
 * ##### Valid for `{ allowedSuffixes: ["_dCel", {regex:{pattern:"_[kMG]?Hz"}}] }`
 * ```js
 * var camelCase = 0;
 * var CamelCase = 1;
 * var _camelCase = 2;
 * var camelCase_ = 3;
 * var UPPER_CASE = 4;
 * var camelCase_dCel = 5;
 * var _camelCase_MHz = 6;
 * ```
 *
 * ##### Invalid for `{ allowedSuffixes: ["_dCel", {regex:{pattern:"_[kMG]?Hz"}}] }`
 * ```js
 * var lower_case = 1;
 * var Mixed_case = 2;
 * var mixed_Case = 3;
 * var camelCase_cCel = 4;
 * var CamelCase_THz = 5;
 * ```
 *
 * ##### Valid for `{ allExcept: ["var_args", {regex:{pattern:"^ignore",flags:"i"}}] }`
 * ```js
 * var camelCase = 0;
 * var CamelCase = 1;
 * var _camelCase = 2;
 * var camelCase_ = 3;
 * var UPPER_CASE = 4;
 * var var_args = 5;
 * var ignoreThis_Please = 6;
 * var iGnOrEeThis_Too = 7;
 * ```
 *
 * ##### Invalid for `{ allExcept: ["var_args", {regex:{pattern:"^ignore",flags:"i"}}] }`
 * ```js
 * var lower_case = 1;
 * var Mixed_case = 2;
 * var mixed_Case = 3;
 * var var_arg = 4;
 * var signore_per_favore = 5;
 * ```
 */

var assert = require('assert');

// Convert an array of String or RegExp or ESTree RegExpLiteral values
// into an array of String or RegExp values.  Returns falsy if the
// input does not match expectations.
function processArrayOfStringOrRegExp(iv) {
    if (!Array.isArray(iv)) {
        return;
    }
    var rv = [];
    var i = 0;
    while (rv && (i < iv.length)) {
        var elt = iv[i];
        if (typeof elt === 'string') {
            // string values OK
            rv.push(elt);
        } else if (elt instanceof RegExp) {
            // existing RegExp OK
            rv.push(elt);
        } else if (elt && (typeof elt === 'object')) {
            try {
                // ESTree RegExpLiteral ok if it produces RegExp
                rv.push(new RegExp(elt.regex.pattern, elt.regex.flags || ''));
            } catch (e) {
                // Not a valid RegExpLiteral
                rv = null;
            }
        } else {
            // Unknown value
            rv = null;
        }
        ++i;
    }
    return rv;
}

// Return undefined or the start of the unprefixed value.
function startAfterStringPrefix(value, prefix) {
    var start = prefix.length;
    if (start >= value.length) {
        return;
    }
    if (value.substr(0, prefix.length) !== prefix) {
        return;
    }
    return start;
}

// Return undefined or the start of the unprefixed value.
function startAfterRegExpPrefix(value, prefix) {
    var match = prefix.exec(value);
    if (!match) {
        return;
    }
    if (match.index !== 0) {
        return;
    }
    return match[0].length;
}

// Return undefined or the end of the unsuffixed value.
function endBeforeStringSuffix(value, suffix) {
    var ends = value.length - suffix.length;
    if (ends <= 0) {
        return;
    }
    if (value.substr(ends) !== suffix) {
        return;
    }
    return ends;
}

// Return undefined or the end of the unsuffixed value.
function endBeforeRegExpSuffix(value, suffix) {
    var match = suffix.exec(value);
    if (!match) {
        return;
    }
    var ends = match.index;
    if ((ends + match[0].length) !== value.length) {
        return;
    }
    return ends;
}

// Return truthy iff the value matches the exception.
function matchException(value, exception) {
    if (typeof exception === 'string')  {
        return (exception === value);
    }
    return exception.test(value);
}

module.exports = function() {};

module.exports.prototype = {

    configure: function(options) {
        if (typeof options !== 'object') {
            assert(
              options === true || options === 'ignoreProperties',
              this.getOptionName() + ' option requires a true value or `ignoreProperties`'
            );
            var _options = {
                ignoreProperties: options === 'ignoreProperties' ? true : false,
                strict: false
            };
            return this.configure(_options);
        }

        assert(
          !options.hasOwnProperty('ignoreProperties') || typeof options.ignoreProperties === 'boolean',
          this.getOptionName() + ' option should have boolean value for ignoreProperties'
        );
        this._ignoreProperties = options.ignoreProperties;

        assert(
          !options.hasOwnProperty('strict') || typeof options.strict === 'boolean',
          this.getOptionName() + ' option should have boolean value for strict'
        );
        this._strict = options.strict;

        var asre = processArrayOfStringOrRegExp(options.allowedPrefixes);
        assert(
          !options.hasOwnProperty('allowedPrefixes') || asre,
          this.getOptionName() + ' option should have array of string or RegExp for allowedPrefixes'
        );
        if (asre) {
            this._allowedPrefixes = asre;
        }

        asre = processArrayOfStringOrRegExp(options.allowedSuffixes);
        assert(
          !options.hasOwnProperty('allowedSuffixes') || asre,
          this.getOptionName() + ' option should have array of string or RegExp for allowedSuffixes'
        );
        if (asre) {
            this._allowedSuffixes = asre;
        }

        asre = processArrayOfStringOrRegExp(options.allExcept);
        assert(
          !options.hasOwnProperty('allExcept') || asre,
          this.getOptionName() + ' option should have array of string or RegExp for allExcept'
        );
        if (asre) {
            this._allExcept = asre;
        }

    },

    getOptionName: function() {
        return 'requireCamelCaseOrUpperCaseIdentifiers';
    },

    check: function(file, errors) {
        file.iterateTokensByType('Identifier', function(token) {
            var value = token.value;

            // Leading and trailing underscores signify visibility/scope and do not affect
            // validation of the rule.  Remove them to simplify the checks.
            var isPrivate = (value[0] === '_');
            value = value.replace(/^_+|_+$/g, '');

            // Detect exceptions before stripping prefixes/suffixes.
            if (this._allExcept) {
                for (i = 0, len = this._allExcept.length; i < len; ++i) {
                    if (matchException(value, this._allExcept[i])) {
                        return;
                    }
                }
            }

            // Strip at most one prefix permitted text from the identifier.  This transformation
            // cannot change an acceptable identifier into an unacceptable identifier so we can
            // continue with the normal verification of whatever it produces.
            var i;
            var len;
            if (this._allowedPrefixes) {
                for (i = 0, len = this._allowedPrefixes.length; i < len; ++i) {
                    var prefix = this._allowedPrefixes[i];
                    var start;
                    if (typeof prefix === 'string') {
                        start = startAfterStringPrefix(value, prefix);
                    } else {
                        start = startAfterRegExpPrefix(value, prefix);
                    }
                    if (start !== undefined) {
                        value = value.substr(start);
                        break;
                    }
                }
            }

            // As with prefix but for one suffix permitted text.
            if (this._allowedSuffixes) {
                for (i = 0, len = this._allowedSuffixes.length; i < len; ++i) {
                    var suffix = this._allowedSuffixes[i];
                    var ends;
                    if (typeof suffix === 'string') {
                        ends = endBeforeStringSuffix(value, suffix);
                    } else {
                        ends = endBeforeRegExpSuffix(value, suffix);
                    }
                    if (ends !== undefined) {
                        value = value.substr(0, ends);
                        break;
                    }
                }
            }

            if (value.indexOf('_') === -1 || value.toUpperCase() === value) {
                if (!this._strict) {return;}
                if (value.length === 0 || value[0].toUpperCase() !== value[0] || isPrivate) {
                    return;
                }
            }
            if (this._ignoreProperties) {
                var nextToken = file.getNextToken(token);
                var prevToken = file.getPrevToken(token);

                if (nextToken && nextToken.value === ':') {
                    return;
                }

                /* This enables an identifier to be snake cased via the object
                 * destructuring pattern. We must check to see if the identifier
                 * is being used to set values into an object to determine if
                 * this is a legal assignment.
                 * Example: ({camelCase: snake_case}) => camelCase.length
                 */
                if (prevToken && prevToken.value === ':') {
                    var node = file.getNodeByRange(token.range[0]);
                    var parentNode = node.parentNode;
                    if (parentNode && parentNode.type === 'Property') {
                        var grandpa = parentNode.parentNode;
                        if (grandpa && grandpa.type === 'ObjectPattern') {
                            return;
                        }
                    }
                }

                if (prevToken && (prevToken.value === '.' ||
                    prevToken.value === 'get' || prevToken.value === 'set')) {
                    return;
                }
            }
            errors.add(
                'All identifiers must be camelCase or UPPER_CASE',
                token.loc.start.line,
                token.loc.start.column
            );
        }.bind(this));
    }

};

},{"assert":171}],86:[function(require,module,exports){
/**
 * Requires the first alphabetical character of a comment to be uppercase, unless it is part of a multi-line textblock.
 *
 * This rule automatically ignores jscs, jshint, eslint and istanbul specific comments.
 *
 * Types: `Boolean` or `Object`
 *
 * Values:
 *  - `true`
 *  - `Object`:
 *     - `allExcept`: array of quoted exceptions
 *     - `inlined`: Ignore comments in the middle of the code line
 *
 * #### Example
 *
 * ```js
 * "requireCapitalizedComments": true
 * ```
 *
 * ##### Valid:
 *
 * ```js
 * // Valid
 * //Valid
 *
 * /*
 *   Valid
 *  *\/
 *
 * /**
 *  * Valid
 *  *\/
 *
 * // A textblock is a set of lines
 * // that starts with a capitalized letter
 * // and has one or more non-capitalized lines
 * // afterwards
 *
 * // A textblock may also have multiple lines.
 * // Those lines can be uppercase as well to support
 * // sentence breaks in textblocks
 *
 * // 123 or any non-alphabetical starting character
 * // @are also valid anywhere
 *
 * // jscs: enable
 * ```
 *
 * ##### Invalid:
 *
 * ```js
 * // invalid
 * //invalid
 * /** invalid *\/
 * /**
 *  * invalid
 *  *\/
 * ```
 *
 * ```js
 * "requireCapitalizedComments": { "allExcept": ["pragma"] }
 * ```
 *
 * ##### Valid:
 *
 * ```js
 * function sayHello() {
 *     /* pragma something *\/
 *
 *     // I can now say hello in lots of statements, if I like.
 *     return "Hello";
 * }
 * ```
 *
 * ##### Valid:
 *
 * ```js
 * function sayHello() {
 *     /* istanbul ignore next *\/
 *
 *     // I'd like to ignore this statement in coverage reports.
 *     return "Hello";
 * }
 * ```
 *
 * ##### Invalid:
 *
 * ```js
 * function sayHello() {
 *     /* otherPragma something *\/
 *
 *     // i can now say hello in lots of statements, if I like.
 *     return "Hello";
 * }
 * ```
 *
 * ```js
 * "requireCapitalizedComments": { "inlined": true }
 * ```
 * ##### Valid:
 *
 * ```js
 * function sayHello( world /*internal*\/ ) {
 * }
 * ```
 */

var assert = require('assert');

var isPragma = require('../utils').isPragma;
var letterPattern = require('../../patterns/L');
var upperCasePattern = require('../../patterns/Lu');

module.exports = function() {};

module.exports.prototype = {
    configure: function(options) {
        var exceptions;

        this.inlined = false;
        this._isPragma = null;

        var optionName = this.getOptionName();

        var isObject = typeof options === 'object';
        var error = optionName + ' option requires a true value ' +
            'or an object with String[] `allExcept` property or true with `inlined`';

        assert(
            options === true ||
            isObject,
            error
        );

        if (isObject && options.allExcept) {
            exceptions = options.allExcept;

            // verify items in `allExcept` property in object are string values
            assert(
                Array.isArray(exceptions) &&
                exceptions.every(function(el) { return typeof el === 'string'; }),
                'Property `allExcept` in ' + optionName + ' should be an array of strings'
            );

            this._isPragma = isPragma(exceptions);
        }

        if (!this._isPragma) {
            this._isPragma = isPragma();
        }

        if (isObject && options.inlined) {
            this.inlined = true;
        }

        if (isObject && !options.allExcept && !options.inlined) {
            assert(false, error);
        }
    },

    getOptionName: function() {
        return 'requireCapitalizedComments';
    },

    _isUrl: function(comment) {
        var protocolParts = comment.value.split('://');

        if (protocolParts.length === 1) {
            return false;
        }

        return comment.value.indexOf(protocolParts[0]) === 0;
    },

    _isException: function(comment) {
        return this._isPragma(comment.value);
    },

    _isValid: function(comment) {
        var first = this._getFirstChar(comment);

        return first && upperCasePattern.test(first);
    },

    _isLetter: function(comment) {
        var first = this._getFirstChar(comment);

        return first && letterPattern.test(first);
    },

    _getFirstChar: function(comment) {
        return comment.value.replace(/[\n\s\*]/g, '')[0];
    },

    _isTextBlock: function(comment, file) {
        var prevComment = file.getPrevToken(comment, {includeComments: true});

        if (prevComment) {
            return prevComment.type === 'Line' &&
                prevComment.loc.start.line + 1 === comment.loc.start.line &&
                prevComment.value.trim().length > 0;
        }

        return false;
    },

    _shouldIgnoreIfInTheMiddle: function(file, comment) {
        if (!this.inlined) {
            return false;
        }

        var firstToken = file.getFirstNodeToken(comment);
        var otherToken = file.getPrevToken(firstToken, { includeComments: true });

        return otherToken ? otherToken.loc.start.line === firstToken.loc.start.line : false;
    },

    check: function(file, errors) {
        var _this = this;

        function add(comment) {
            errors.cast({
                message: 'Comments must start with an uppercase letter, unless it is part of a textblock',
                line: comment.loc.start.line,
                column: comment.loc.start.column,
                additional: comment
            });
        }

        file.iterateTokensByType('Line', function(comment) {
            if (_this._isException(comment)) {
                return;
            }

            if (_this._isUrl(comment)) {
                return;
            }

            if (!_this._isLetter(comment)) {
                return;
            }

            if (_this._isTextBlock(comment, file)) {
                return;
            }

            if (_this._isValid(comment)) {
                return;
            }

            add(comment);
        });

        file.iterateTokensByType('Block', function(comment) {
            if (_this._isException(comment)) {
                return;
            }

            if (_this._isUrl(comment)) {
                return;
            }

            if (!_this._isLetter(comment)) {
                return;
            }

            if (_this._shouldIgnoreIfInTheMiddle(file, comment)) {
                return;
            }

            if (_this._isValid(comment)) {
                return;
            }

            add(comment);
        });
    },

    _fix: function(file, error) {
        var comment = error.additional;
        var first = this._getFirstChar(comment);

        comment.value = comment.value.replace(first, first.toUpperCase());
    }
};

},{"../../patterns/L":948,"../../patterns/Lu":950,"../utils":166,"assert":171}],87:[function(require,module,exports){
/**
 * Requires capitalized constructors to to use the `new` keyword
 *
 * Types: `Boolean` or `Object`
 *
 * Values: `true` or Object with `allExcept` Array of quoted identifiers which are exempted
 *
 * JSHint: [`newcap`](http://jshint.com/docs/options/#newcap)
 *
 * #### Example
 *
 * ```js
 * "requireCapitalizedConstructors": true
 * "requireCapitalizedConstructors": {
 *     "allExcept": ["SomethingNative"]
 * }
 * ```
 *
 * ##### Valid
 *
 * ```js
 * var a = new B();
 * var c = SomethingNative();
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * var d = E();
 * ```
 */

var assert = require('assert');

module.exports = function() {};

module.exports.prototype = {
    configure: function(options) {
        assert(
            options === true || Array.isArray(options.allExcept),
            this.getOptionName() + ' option requires a true value or an object of exceptions'
        );
        this._allowedConstructors = {};

        var allExcept = options.allExcept;
        if (allExcept) {
            for (var i = 0, l = allExcept.length; i < l; i++) {
                this._allowedConstructors[allExcept[i]] = true;
            }
        }
    },

    getOptionName: function() {
        return 'requireCapitalizedConstructorsNew';
    },

    check: function(file, errors) {
        var allowedConstructors = this._allowedConstructors;

        file.iterateNodesByType('CallExpression', function(node) {
            if (node.callee.type === 'Identifier' &&
                !allowedConstructors[node.callee.name] &&
                node.callee.name[0].toLowerCase() !== node.callee.name[0]
            ) {
                errors.add(
                    'Constructor functions should use the "new" keyword',
                    node.callee.loc.start.line,
                    node.callee.loc.start.column
                );
            }
        });
    }

};

},{"assert":171}],88:[function(require,module,exports){
/**
 * Requires constructors to be capitalized (except for `this`)
 *
 * Types: `Boolean` or `Object`
 *
 * Values: `true` or Object with `allExcept` Array of quoted identifiers which are exempted
 *
 * JSHint: [`newcap`](http://jshint.com/docs/options/#newcap)
 *
 * #### Example
 *
 * ```js
 * "requireCapitalizedConstructors": true
 * "requireCapitalizedConstructors": {
 *     "allExcept": ["somethingNative"]
 * }
 * ```
 *
 * ##### Valid
 *
 * ```js
 * var a = new B();
 * var c = new this();
 * var d = new somethingNative();
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * var d = new e();
 * ```
 */

var assert = require('assert');

module.exports = function() {};

module.exports.prototype = {
    configure: function(options) {
        assert(
            options === true || Array.isArray(options.allExcept),
            this.getOptionName() + ' option requires a true value or an object of exceptions'
        );
        this._allowedConstructors = {};

        var allExcept = options.allExcept;
        if (allExcept) {
            for (var i = 0, l = allExcept.length; i < l; i++) {
                this._allowedConstructors[allExcept[i]] = true;
            }
        }
    },

    getOptionName: function() {
        return 'requireCapitalizedConstructors';
    },

    check: function(file, errors) {
        var allowedConstructors = this._allowedConstructors;

        file.iterateNodesByType('NewExpression', function(node) {
            if (node.callee.type === 'Identifier' &&
                !allowedConstructors[node.callee.name] &&
                node.callee.name[0].toUpperCase() !== node.callee.name[0]
            ) {
                errors.add(
                    'Constructor functions should be capitalized',
                    node.callee.loc.start.line,
                    node.callee.loc.start.column
                );
            }
        });
    }

};

},{"assert":171}],89:[function(require,module,exports){
/**
 * Requires commas as last token on a line in lists.
 *
 * Type: `Boolean`
 *
 * Value: `true`
 *
 * JSHint: [`laxcomma`](http://www.jshint.com/docs/options/#laxcomma)
 *
 * #### Example
 *
 * ```js
 * "requireCommaBeforeLineBreak": true
 * ```
 *
 * ##### Valid
 *
 * ```js
 * var x = {
 *     one: 1,
 *     two: 2
 * };
 * var y = { three: 3, four: 4};
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * var x = {
 *     one: 1
 *     , two: 2
 * };
 * ```
 */

var assert = require('assert');

module.exports = function() {};

module.exports.prototype = {

    configure: function(options) {
        assert(
            options === true,
            this.getOptionName() + ' option requires a true value or should be removed'
        );
    },

    getOptionName: function() {
        return 'requireCommaBeforeLineBreak';
    },

    check: function(file, errors) {
        file.iterateTokensByTypeAndValue('Punctuator', ',', function(token) {
            var prevToken = file.getPrevToken(token);

            if (prevToken.value === ',') {
                return;
            }
            errors.assert.sameLine({
                token: prevToken,
                nextToken: token,
                message: 'Commas should not be placed on new line'
            });
        });
    }

};

},{"assert":171}],90:[function(require,module,exports){
/**
 * Requires curly braces after statements.
 *
 * Types: `Array` or `Boolean` or `Object`
 *
 * Values:
 *     - Array of quoted keywords
 *     - `true` to require curly braces after the following keywords
 *     - `Object`
 *         - `'keywords'`
 *             - Array of quoted keywords
 *         - `'allExcept'`
 *             - Array of keywords inside of the block that would allow curly braces
 *             - Ex: ["return" , "continue", "break"]
 *
 * JSHint: [`curly`](http://jshint.com/docs/options/#curly)
 *
 * #### Example
 *
 * ```js
 * "requireCurlyBraces": [
 *     "if",
 *     "else",
 *     "for",
 *     "while",
 *     "do",
 *     "try",
 *     "catch",
 *     "case",
 *     "default"
 * ]
 * ```
 *
 * ##### Valid
 *
 * ```js
 * if (x) {
 *     x++;
 * }
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * if (x) x++;
 * ```
 */

var assert = require('assert');
var defaultKeywords = require('../utils').curlyBracedKeywords;

module.exports = function() {};

module.exports.prototype = {

    configure: function(options) {
        assert(
            Array.isArray(options) || options === true || typeof options === 'object',
            this.getOptionName() + ' option requires array, true value, or object'
        );

        var keywordMap = {
            'return': 'ReturnStatement',
            'break': 'BreakStatement',
            'continue': 'ContinueStatement'
        };

        if (options === true) {
            options = defaultKeywords;
        }

        if (!Array.isArray(options)) {
            assert(
                Array.isArray(options.allExcept),
                this.getOptionName() + '.allExcept ' +
                'property requires an array value'
            );
            assert(
                Array.isArray(options.keywords) || options.keywords === true,
                this.getOptionName() + '.keywords ' +
                'property requires an array value or a value of true'
            );

            if (options.keywords === true) {
                options.keywords = defaultKeywords;
            }

            this._exceptions = options.allExcept.map(function(statementType) {
                return keywordMap[statementType];
            });
            options = options.keywords;
        }

        this._typeIndex = {};
        for (var i = 0, l = options.length; i < l; i++) {
            this._typeIndex[options[i]] = true;
        }
    },

    getOptionName: function() {
        return 'requireCurlyBraces';
    },

    check: function(file, errors) {
        var typeIndex = this._typeIndex;
        var exceptions = this._exceptions;

        function isNotABlockStatement(node) {
            return node && node.type !== 'BlockStatement';
        }

        function addError(typeString, entity) {
            errors.add(
                typeString + ' statement without curly braces',
                entity.loc.start.line,
                entity.loc.start.column
            );
        }

        function checkBody(type, typeString) {
            file.iterateNodesByType(type, function(node) {
                if (isNotABlockStatement(node.body)) {
                    addError(typeString, node);
                }
            });
        }

        if (typeIndex.if || typeIndex.else) {
            file.iterateNodesByType('IfStatement', function(node) {
                if (typeIndex.if && isNotABlockStatement(node.consequent) &&
                    // check exceptions for if and else
                    !(exceptions && exceptions.indexOf(node.consequent.type) !== -1)) {
                    addError('If', node);
                }
                if (typeIndex.else && isNotABlockStatement(node.alternate) &&
                    node.alternate.type !== 'IfStatement' &&
                    // check exceptions for if and else
                    !(exceptions && exceptions.indexOf(node.consequent.type) !== -1)) {
                    addError('Else', file.getPrevToken(file.getFirstNodeToken(node.alternate)));
                }
            });
        }

        if (typeIndex.case || typeIndex.default) {
            file.iterateNodesByType('SwitchCase', function(node) {
                // empty case statement
                if (node.consequent.length === 0) {
                    return;
                }

                if (node.consequent.length === 1 && node.consequent[0].type === 'BlockStatement') {
                    return;
                }

                if (node.test === null && typeIndex.default) {
                    addError('Default', node);
                }

                if (node.test !== null && typeIndex.case) {
                    addError('Case', node);
                }
            });
        }

        if (typeIndex.while) {
            checkBody('WhileStatement', 'While');
        }

        if (typeIndex.for) {
            checkBody('ForStatement', 'For');
            checkBody('ForInStatement', 'For in');
            checkBody('ForOfStatement', 'For of');
        }

        if (typeIndex.do) {
            checkBody('DoWhileStatement', 'Do while');
        }

        if (typeIndex.with) {
            checkBody('WithStatement', 'With');
        }
    }

};

},{"../utils":166,"assert":171}],91:[function(require,module,exports){
/**
 * Require a $ before variable names that are jquery assignments.
 *
 * Types: `Boolean` or `String`
 *
 * Values: `true` or `"ignoreProperties"`
 *
 * #### Example
 *
 * ```js
 * "requireDollarBeforejQueryAssignment": true
 * ```
 *
 * ##### Valid example for mode `true`
 *
 * ```js
 * var $x = $(".foo");
 * var y = {
 *   $x: $(".bar")
 * };
 * ```
 *
 * ##### Invalid example for mode `true`
 *
 * ```js
 * var x = $(".foo");
 * var y = {
 *   x: $(".bar")
 * };
 * ```
 *
 * ##### Valid example for mode `ignoreProperties`
 *
 * ```js
 * var $x = $(".foo");
 * var y = {
 *   x: $(".bar")
 * };
 * ```
 *
 * ##### Invalid example for mode `ignoreProperties`
 *
 * ```js
 * var x = $(".foo");
 * ```
 */

var assert = require('assert');

module.exports = function() {};

module.exports.prototype = {

    _ignoreProperties: false,

    configure: function(options) {
        assert(
            options === true || options === 'ignoreProperties',
            this.getOptionName() + ' option requires true or "ignoreProperties" value, or should be removed'
        );

        this._ignoreProperties = (options === 'ignoreProperties');
    },

    getOptionName: function() {
        return 'requireDollarBeforejQueryAssignment';
    },

    check: function(file, errors) {
        var ignoreProperties = this._ignoreProperties;

        file.iterateNodesByType(['VariableDeclarator', 'AssignmentExpression', 'ObjectExpression'], function(token) {
            var type = token.type;
            var left;
            var varName;
            var right;

            function checkIfVarNameShouldStartWithDollar(varName, left, right) {

                if (/^_?\$/.test(varName)) {
                    return;
                }

                if (!right || right.type !== 'CallExpression') {
                    return;
                }

                var nextToken = file.getTokenByRangeStart(right.callee.range[0]);
                if (nextToken.value !== '$') {
                    return;
                }

                nextToken = file.getNextToken(nextToken);
                if (nextToken.value !== '(') {
                    return;
                }

                while (!(nextToken.type === 'Punctuator' && nextToken.value === ')')) {
                    nextToken = file.getNextToken(nextToken);
                }

                nextToken = file.getNextToken(nextToken);
                if (!nextToken || !(nextToken.type === 'Punctuator' && nextToken.value === '.')) {
                    errors.add(
                        'jQuery identifiers must start with a $',
                        left.loc.start.line,
                        left.loc.start.column
                    );
                }
            }

            if (type === 'VariableDeclarator') {
                if (token.id.type === 'ObjectPattern' || token.id.type === 'ArrayPattern') {
                    return;
                }

                left = token.id;
                varName = left.name;
                right = token.init;
                checkIfVarNameShouldStartWithDollar(varName, left, right);
            } else if (ignoreProperties) {
                return;

            } else if (type === 'AssignmentExpression') {
                left = token.left;
                if (left.computed) {
                    return;
                }

                varName = left.name || left.property.name;
                right = token.right;
                checkIfVarNameShouldStartWithDollar(varName, left, right);
            } else {// type === 'ObjectExpression'
                var props = token.properties;

                if (!props) {
                    return;
                }

                props.forEach(function(prop) {
                    left = prop.key;

                    if (!left.name) {
                        return;
                    }

                    varName = left.name;
                    right = prop.value;
                    checkIfVarNameShouldStartWithDollar(varName, left, right);
                });
            }

        });
    }
};

},{"assert":171}],92:[function(require,module,exports){
/**
 * Requires member expressions to use dot notation when possible
 *
 * Types: `Boolean` or `Object`
 *
 * Values:
 *  - `true`
 *  - `"except_snake_case"` (*deprecated* use `"allExcept": ["snake_case"]`) allow quoted snake cased identifiers
 *  - `Object`:
 *    - `'allExcept'` array of exceptions:
 *       - `'keywords'` allow quoted identifiers made of reserved words
 *       - `'snake_case'` allow quoted snake cased identifiers
 *
 * N.B.: keywords are always allowed with es3 enabled (http://jscs.info/overview.html#es3)
 *
 * JSHint: [`sub`](http://www.jshint.com/docs/options/#sub)
 *
 * #### Example
 *
 * ```js
 * "requireDotNotation": true
 * ```
 *
 * ##### Valid
 *
 * ```js
 * var a = b[c];
 * var a = b.c;
 * var a = b[c.d];
 * var a = b[1];
 * var a = b.while; // reserved words can be property names in ES5
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * var a = b['c'];
 * var a = b['snake_cased'];
 * var a = b['_camelCased'];
 * var a = b['camelCased_'];
 * ```
 *
 * #### Example for allExcept snake_case
 *
 * ```js
 * "requireDotNotation": { "allExcept": [ "snake_case" ] }
 * ```
 *
 * ##### Valid
 * ```js
 * var a = b[c];
 * var a = b.c;
 * var a = b['snake_cased'];
 * var a = b['camelCased_butWithSnakes'];
 * ```
 *
 * #### Example for allExcept keywords
 *
 * ```js
 * "requireDotNotation": { "allExcept": [ "keywords" ] }
 * ```
 *
 * ##### Valid
 *
 * ```js
 * var a = b['yield']; // reserved word in ES5
 * var a = b['let'];
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * var a = b['await']; // reserved word in ES6
 * ```
 *
 * #### Example for allExcept keywords with esnext
 *
 * ```js
 * "requireDotNotation": { "allExcept": [ "keywords" ] }
 * "esnext": true
 * ```
 *
 * ##### Valid
 *
 * ```js
 * var a = b['await']; // reserved word in ES6
 * ```
 *
 * #### Example for `"es3": true`
 *
 * ```js
 * "requireDotNotation": true,
 * "es3": true
 * ```
 *
 * ##### Valid
 *
 * ```js
 * var a = b[c];
 * var a = b.c;
 * var a = b[c.d];
 * var a = b[1];
 * var a = b['while']; // reserved word in ES3
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * var a = b['c'];
 * ```
 */

var assert = require('assert');
var utils = require('../utils');
var reservedWords = require('reserved-words');

module.exports = function() {};

module.exports.prototype = {

    configure: function(options) {
        if (typeof options !== 'object') {
            assert(
                options === true || options === 'except_snake_case',
                this.getOptionName() + ' option requires either a true value or an object'
            );

            var _options = {};
            if (options === 'except_snake_case') {
                _options.allExcept = ['snake_case'];
            }

            return this.configure(_options);
        }

        assert(
            !options.allExcept || Array.isArray(options.allExcept),
            'allExcept value of ' + this.getOptionName() + ' option requires an array with exceptions'
        );

        if (Array.isArray(options.allExcept)) {
            this._exceptSnakeCase = options.allExcept.indexOf('snake_case') > -1;
            this._exceptKeywords = options.allExcept.indexOf('keywords') > -1;
        }
    },

    getOptionName: function() {
        return 'requireDotNotation';
    },

    check: function(file, errors) {
        var exceptSnakeCase = this._exceptSnakeCase;
        var exceptKeywords = this._exceptKeywords;

        var dialect = file.getDialect();
        file.iterateNodesByType('MemberExpression', function(node) {
            if (!node.computed || node.property.type !== 'Literal') {
                return;
            }

            var value = node.property.value;
            if (// allow numbers, nulls, and anything else
                typeof value !== 'string' ||
                // allow invalid identifiers
                !utils.isValidIdentifierName(value, file.getDialect()) ||
                // allow quoted snake cased identifiers if allExcept: ['snake_case']
                (exceptSnakeCase && utils.isSnakeCased(utils.trimUnderscores(value))) ||
                // allow quoted reserved words if allExcept: ['keywords']
                ((dialect === 'es3' || exceptKeywords) && reservedWords.check(value, dialect, true))
            ) {
                return;
            }

            errors.add(
                'Use dot notation instead of brackets for member expressions',
                node.property.loc.start
            );
        });
    }

};

},{"../utils":166,"assert":171,"reserved-words":905}],93:[function(require,module,exports){
/**
 * Requires to return early in a function.
 *
 * Types: `Boolean`
 *
 * Values:
 *  - `true`: disallow to use of else if the corrisponding `if` block contain a return.
 *
 * #### Example
 *
 * ```js
 * "requireEarlyReturn": true
 * ```
 *
 * ##### Valid
 *
 * ```js
 * function test() {
 *     if (x) {
 *         return x;
 *     }
 *     return y;
 * }
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * function test() {
 *     if (x) {
 *         return x;
 *     } else {
 *         return y;
 *     }
 * }
 * ```
 */

var assert = require('assert');

module.exports = function() {};

module.exports.prototype = {
    configure: function(options) {
        assert(
            options === true,
            this.getOptionName() + ' option allow only the `true` value'
        );
    },

    getOptionName: function() {
        return 'requireEarlyReturn';
    },

    check: function(file, errors) {
        function addError(entity) {
            errors.add(
                'Use of else after return',
                entity.loc.start.line,
                entity.loc.start.column
            );
        }

        // Check if the IfStatement node contain a ReturnStatement.
        // If the node has a block, check all the statements in backward order to see if there is one.
        // This is to ensure that code like this will still return true:
        //
        // if (true) {
        //    return;
        //    eval();
        // }
        function hasNodeReturn(node) {
            if (node.type === 'BlockStatement') {
                for (var i = node.body.length - 1; i >= 0; i--) {
                    if (node.body[i].type === 'ReturnStatement') {
                        return true;
                    }
                }
                return false;
            }
            return node.type === 'ReturnStatement';
        }

        file.iterateNodesByType('IfStatement', function(node) {
            if (!node.alternate) {
                return;
            }

            // Check if all the parents have a return statement, if not continue to the following IfStatement node.
            //
            // Example:
            //
            // if (foo) {
            //     return;
            // } else if (bar) {  <-- error
            //     bar();
            // } else if (baz) {  <-- safe
            //     return baz();
            // } else {           <-- safe
            //     bas();
            // }
            for (var nodeIf = node; nodeIf && nodeIf.type === 'IfStatement'; nodeIf = nodeIf.parentNode) {
                if (nodeIf.alternate && !hasNodeReturn(nodeIf.consequent)) {
                    return;
                }
            }

            return addError(file.getPrevToken(file.getFirstNodeToken(node.alternate)));
        });
    }
};

},{"assert":171}],94:[function(require,module,exports){
/**
 * Requires declaring objects via ES6 enhanced object literals
 *
 * Type: `Boolean`
 *
 * Values: true
 *
 * Version: `ES6`
 *
 * #### Example
 *
 * ```js
 * "requireEnhancedObjectLiterals": true
 * ```
 *
 * ##### Valid
 *
 * ```js
 * var bar = true;
 * var obj = {
 *   foo() { },
 *   bar
 * };
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * var bar = true;
 * var obj = {
 *   foo: function() { },
 *   bar: bar
 * };
 * ```
 */

var assert = require('assert');

module.exports = function() { };

module.exports.prototype = {
    configure: function(option) {
        assert(option === true, this.getOptionName() + ' requires a true value');
    },

    getOptionName: function() {
        return 'requireEnhancedObjectLiterals';
    },

    check: function(file, errors) {
        file.iterateNodesByType('Property', function(node) {
            // node.key.name is used when the property key is an unquoted identifier
            // node.key.value is used when the property key is a quoted string
            var propertyName = node.key.name || node.key.value;
            var valueName = node.value.name;
            var shorthand = node.shorthand;
            var computed = node.computed;

            // check for non-shorthand properties
            if (propertyName && propertyName === valueName && !(shorthand || computed)) {
                errors.add(
                  'Property assignment should use enhanced object literal function.\n' +
                  ' `{ propName: propName }` is not allowed.',
                  node.loc.start
                );
            }

            // check for non-method function properties
            var valueType = node.value.type;
            var valueIsMethod = node.method;
            if (valueType === 'FunctionExpression' && !valueIsMethod) {
                errors.add(
                  'Property assignment should use enhanced object literal function.\n' +
                  ' `{ funcName: function() {} }` is not allowed.',
                  node.loc.start
                );
            }
        });
    }
};

},{"assert":171}],95:[function(require,module,exports){
/**
 * Requires function declarations by disallowing assignment of functions
 * expressions to variables. Function expressions are allowed in all other
 * contexts, including when passed as function arguments or immediately invoked.
 *
 * Assignment of function expressions to object members is also permitted, since
 * these can't be declared.
 *
 * Type: `Boolean`
 *
 * Value: `true`
 *
 * #### Example
 *
 * ```js
 * "requireFunctionDeclarations": true
 * ```
 *
 * ##### Valid
 *
 * ```js
 * function declared() {
 *
 * };
 *
 * (function iife() {
 *     void 0;
 * })();
 *
 * var obj = {
 *     a: function () {}
 * };
 *
 * obj.b = function () { };
 *
 * $('#foo').click(function bar() {
 *
 * };)
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * var expressed = function() {
 *
 * };
 *
 * var expressed = function deeply() {
 *
 * };
 * ```
 */

var assert = require('assert');

module.exports = function() {};

module.exports.prototype = {
    configure: function(options) {
        assert(
            options === true,
            this.getOptionName() + ' option requires a true value or should be removed'
        );
    },

    getOptionName: function() {
        return 'requireFunctionDeclarations';
    },

    check: function(file, errors) {
        file.iterateNodesByType(
            'VariableDeclarator',
            function(node) {
                if (node.init && node.init.type === 'FunctionExpression') {
                    errors.add('Use a function declaration instead', node.loc.start);
                }
            }
        );

        file.iterateNodesByType(
            'AssignmentExpression',
            function(node) {
                if (node.left.type !== 'MemberExpression' &&
                    node.right.type === 'FunctionExpression') {
                    errors.add('Use a function declaration instead', node.loc.start);
                }
            }
        );
    }
};

},{"assert":171}],96:[function(require,module,exports){
/**
 * Requires placing keywords on a new line.
 *
 * Type: `Array`
 *
 * Values: Array of quoted keywords
 *
 * #### Example
 *
 * ```js
 * "requireKeywordsOnNewLine": ["else"]
 * ```
 *
 * ##### Valid
 *
 * ```js
 * if (x < 0) {
 *     x++;
 * }
 * else {
 *     x--;
 * }
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * if (x < 0) {
 *     x++;
 * } else {
 *     x--;
 * }
 * ```
 */

var assert = require('assert');

module.exports = function() {};

module.exports.prototype = {

    configure: function(keywords) {
        assert(Array.isArray(keywords), this.getOptionName() + ' option requires array value');
        this._keywords = keywords;
    },

    getOptionName: function() {
        return 'requireKeywordsOnNewLine';
    },

    check: function(file, errors) {
        file.iterateTokensByTypeAndValue('Keyword', this._keywords, function(token) {
            errors.assert.differentLine({
                token: file.getPrevToken(token),
                nextToken: token
            });
        });
    }

};

},{"assert":171}],97:[function(require,module,exports){
/**
 * Requires placing line feed after assigning a variable.
 *
 * Type: `Boolean`
 *
 * Value: `true`
 *
 * #### Example
 *
 * ```js
 * "requireLineBreakAfterVariableAssignment": true
 * ```
 *
 * ##### Valid
 *
 * ```js
 * var abc = 8;
 * var foo = 5;
 *
 * var a, b, c,
 *     foo = 7,
 *     bar = 8;
 *
 * var a,
 *     foo = 7,
 *     a, b, c,
 *     bar = 8;
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * var abc = 8; var foo = 5;
 *
 * var a, b, c,
 *     foo = 7, bar = 8;
 * ```
 */

var assert = require('assert');

module.exports = function() {};

module.exports.prototype = {

    configure: function(options) {
        assert(
            options === true,
            this.getOptionName() + ' option requires a true value or should be removed'
        );
    },

    getOptionName: function() {
        return 'requireLineBreakAfterVariableAssignment';
    },

    check: function(file, errors) {
        var lastDeclaration;
        file.iterateNodesByType('VariableDeclaration', function(node) {
            if (node.parentNode.type === 'ForStatement' ||
                node.parentNode.type === 'ForInStatement' ||
                node.parentNode.type === 'ForOfStatement') {
                return;
            }

            for (var i = 0; i < node.declarations.length; i++) {
                var thisDeclaration = node.declarations[i];
                if (thisDeclaration.parentNode.kind === 'var' ||
                    thisDeclaration.parentNode.kind === 'let' ||
                    thisDeclaration.parentNode.kind === 'const') {
                    if (lastDeclaration && lastDeclaration.init) {
                        errors.assert.differentLine({
                            token: lastDeclaration,
                            nextToken: thisDeclaration,
                            message: 'Variable assignments should be followed by new line'
                        });
                    }
                    lastDeclaration = thisDeclaration;
                }
            }
        });
    }

};

},{"assert":171}],98:[function(require,module,exports){
/**
 * Requires placing line feed at file end.
 *
 * Type: `Boolean`
 *
 * Value: `true`
 *
 * #### Example
 *
 * ```js
 * "requireLineFeedAtFileEnd": true
 * ```
 */

var assert = require('assert');

module.exports = function() {};

module.exports.prototype = {

    configure: function(options) {
        assert(
            options === true,
            this.getOptionName() + ' option requires a true value or should be removed'
        );
    },

    getOptionName: function() {
        return 'requireLineFeedAtFileEnd';
    },

    check: function(file, errors) {
        var lastToken = file.getLastToken({includeComments: true});
        var prevToken = file.getPrevToken(lastToken, {includeComments: true});
        errors.assert.differentLine({
            token: prevToken,
            nextToken: lastToken,
            message: 'Missing line feed at file end'
        });
    }

};

},{"assert":171}],99:[function(require,module,exports){
/**
 * Requires function names to match member and property names.
 *
 * It doesn't affect anonymous functions nor functions assigned to members or
 * properties named with a reserved word. Assigning to `module.exports` is also
 * ignored, unless `includeModuleExports: true` is configured.
 *
 * Types: `Boolean` or `Object`
 *
 * Values: `true` or Object with `includeModuleExports: true`
 *
 * #### Example
 *
 * ```js
 * "requireMatchingFunctionName": true
 * ```
 *
 * ##### Valid
 *
 * ```js
 * var test = {};
 * test.foo = function foo() {};
 * ```
 *
 * ```js
 * var test = {};
 * test['foo'] = function foo() {};
 * ```
 *
 * ```js
 * var test = {foo: function foo() {}};
 * ```
 *
 * ```js
 * module.exports = function foo() {};
 * ```
 *
 * ```js
 * module['exports'] = function foo() {};
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * var test = {};
 * test.foo = function bar() {};
 * ```
 *
 * ```js
 * var test = {};
 * test['foo'] = function bar() {};
 * ```
 *
 * ```js
 * var test = {foo: function bar() {}};
 * ```
 *
 * ```js
 * var test = {module: {}};
 * test.module.exports = function foo() {};
 * ```
 *
 * #### Example
 *
 * ```js
 * "requireMatchingFunctionName": { "includeModuleExports": true }
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * module.exports = function foo() {};
 * ```
 *
 * ```js
 * module['exports'] = function foo() {};
 * ```
 */

var assert = require('assert');
var reservedWords = require('reserved-words');

module.exports = function() {};

module.exports.prototype = {
    configure: function(requireMatchingFunctionName) {
        if (typeof requireMatchingFunctionName === 'object') {
            assert(requireMatchingFunctionName.includeModuleExports === true,
                'requireMatchingFunctionName option requires includeModuleExports property to be true for object');
            this._includeModuleExports = requireMatchingFunctionName.includeModuleExports;
        } else {
            assert(
                requireMatchingFunctionName === true,
                'requireMatchingFunctionName option requires true value or should be removed'
            );
        }
    },

    getOptionName: function() {
        return 'requireMatchingFunctionName';
    },

    check: function(file, errors) {
        var _includeModuleExports = this._includeModuleExports;
        file.iterateNodesByType(['FunctionExpression'], function(node) {
            switch (node.parentNode.type) {
                // var foo = function bar() {}
                // object.foo = function bar() {}
                // object['foo'] = function bar() {}
                case 'AssignmentExpression':
                    if (_includeModuleExports || !_isModuleExports(node.parentNode.left)) {
                        checkForMember(node.parentNode, skip, errors);
                    }
                    break;

                // object = {foo: function bar() {}}
                case 'Property':
                    checkForProperty(node.parentNode, skip, errors);
                    break;
            }
        });

        function skip(key, value) {
            // We don't care about anonymous functions as
            // those should be enforced by separate rule
            if (!value.id) {
                return true;
            }

            // Relax a bit when reserved word is detected
            if (reservedWords.check(key, file.getDialect(), true)) {
                return true;
            }
        }
    }
};

function _isModuleExports(pattern) {
    if (pattern.type === 'MemberExpression') {
        // must be module.sth
        if (pattern.object.type === 'Identifier' &&
            pattern.object.name === 'module') {

            if (pattern.property.type === 'Identifier' &&
                pattern.property.name === 'exports') {
                // sth.exports
                return true;
            } else if (pattern.property.type === 'Literal' &&
                pattern.property.value === 'exports') {
                // sth["exports"]
                return true;
            }
        }
    }
    return false;
}

/**
 * Fetching name from a Pattern
 *
 * @param {Pattern} pattern - E.g. left side of AssignmentExpression
 * @returns {String|Boolean} - Resolved name or false (if there is an Expression)
 */
function _resolvePatternName(pattern) {
    switch (pattern.type) {
        case 'Identifier':
            // prop = ...;
            return pattern.name;
        case 'Literal':
            // obj['prop'] = ...;
            return pattern.value;
        case 'MemberExpression':
            // obj.prop = ...;
            return _resolvePatternName(pattern.property);
        default:
            // Something unhandy like obj['x' + 2] = ...;
            return false;
    }
}

function checkForMember(assignment, skip, errors) {
    var _name = _resolvePatternName(assignment.left);
    if (_name === false || skip(_name, assignment.right)) {
        return;
    }

    if (_name !== assignment.right.id.name) {
        errors.add(
            'Function name does not match member name',
            assignment.loc.start
        );
    }
}

function checkForProperty(property, skip, errors) {
    var _name = _resolvePatternName(property.key);
    if (_name === false || skip(_name, property.value)) {
        return;
    }

    if (_name !== property.value.id.name) {
        errors.add(
            'Function name does not match property name',
            property.loc.start
        );
    }
}

},{"assert":171,"reserved-words":905}],100:[function(require,module,exports){
/**
 * Requires the test, consequent and alternate to be on separate lines when using the ternary operator.
 *
 * Types: `Boolean`
 *
 * #### Example
 *
 * ```js
 * "requireMultiLineTernary": true
 * ```
 *
 * ##### Valid
 *
 * ```js
 * var foo = (a === b)
 *   ? 1
 *   : 2;
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * var foo = (a === b) ? 1 : 2;
 * ```
 */

var assert = require('assert');

module.exports = function() {};

module.exports.prototype = {
    configure: function(options) {
        assert(
            options === true,
            this.getOptionName() + ' option requires a true value or should be removed'
        );
    },

    getOptionName: function() {
        return 'requireMultiLineTernary';
    },

    check: function(file, errors) {
        file.iterateNodesByType('ConditionalExpression', function(node) {

            errors.assert.differentLine({
                token: node.test,
                nextToken: node.consequent,
                message: 'Missing new line after test'
            });

            errors.assert.differentLine({
                token: node.consequent,
                nextToken: node.alternate,
                message: 'Missing new line after consequent'
            });

        });
    }

};

},{"assert":171}],101:[function(require,module,exports){
/**
 * Requires multiple `var` declaration.
 *
 * Types: `Boolean` or `String` or `Object`
 *
 * Values: `true` or `"onevar"` or `allExcept: ['require']`
 *
 * If `requireMultipleVarDecl` defined as a `true` value, it will report only consecutive vars, if, on the other hand,
 * value equals to `"onevar"` string, `requireMultipleVarDecl` will allow only one `var` per function scope.
 *
 * If the value is `allExcept: ['require']`, then require statements are allowed to have a var declaration per variable.
 *
 * JSHint: [`onevar`](http://jshint.com/docs/options/#onevar)
 *
 * #### Example
 *
 * ```js
 * "requireMultipleVarDecl": true
 * ```
 *
 * ##### Valid
 *
 * ```js
 * var x = 1,
 *     y = 2;
 * ```
 *
 * ##### Valid for `allExcept: ['require']`
 *
 * ```js
 * var a = require("a");
 * var b = require("b");
 * var c = 1,
 *     d = 2;
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * var x = 1;
 * var y = 2;
 * ```
 */

var assert = require('assert');

function consecutive(file, errors) {
    file.iterateNodesByType('VariableDeclaration', function(node) {
        var pos = node.parentCollection.indexOf(node);
        if (pos < node.parentCollection.length - 1) {
            var sibling = node.parentCollection[pos + 1];
            if (sibling.type === 'VariableDeclaration' && sibling.kind === node.kind) {
                errors.add(
                    node.kind[0].toUpperCase() + node.kind.slice(1) + ' declarations should be joined',
                    sibling.loc.start
                );
            }
        }
    });
}

function onevar(file, errors) {
    file.iterateNodesByType(['Program', 'FunctionDeclaration', 'FunctionExpression'], function(node) {
        var firstVar = true;
        var firstConst = true;
        var firstParent = true;

        file.iterate(function(node) {
            var type = node.type;
            var kind = node.kind;

            // Don't go in nested scopes
            if (!firstParent && ['FunctionDeclaration', 'FunctionExpression'].indexOf(type) > -1) {
                return false;
            }

            if (firstParent) {
                firstParent = false;
            }

            if (type === 'VariableDeclaration') {
                if (kind === 'var') {
                    if (!firstVar) {
                        errors.add(
                            'Var declarations should be joined',
                            node.loc.start
                        );
                    } else {
                        firstVar = false;
                    }
                }

                if (kind === 'const') {
                    if (!firstConst) {
                        errors.add(
                            'Const declarations should be joined',
                            node.loc.start
                        );
                    } else {
                        firstConst = false;
                    }
                }
            }
        }, node);
    });
}

function hasRequireStatements(node) {
    if (!Array.isArray(node.declarations)) {
        return false;
    }

    return node.declarations.some(function(declaration) {
        var init = declaration.init;

        return init &&
            init.callee &&
            init.callee.name === 'require';
    });
}

function exceptRequire(file, errors) {
    file.iterateNodesByType('VariableDeclaration', function(node) {
        if (hasRequireStatements(node)) {
            return;
        }
        var pos = node.parentCollection.indexOf(node);
        if (pos < node.parentCollection.length - 1) {
            var sibling = node.parentCollection[pos + 1];
            if (hasRequireStatements(sibling)) {
                return;
            }
            if (sibling.type === 'VariableDeclaration' && sibling.kind === node.kind) {
                errors.add(
                    node.kind[0].toUpperCase() + node.kind.slice(1) + ' declarations should be joined',
                    sibling.loc.start
                );
            }
        }
    });
}

module.exports = function() {};

module.exports.prototype = {
    configure: function(options) {
        var isExceptRequire = typeof options === 'object' &&
                              options.allExcept.length &&
                              options.allExcept.indexOf('require') !== -1;

        assert(
            options === true ||
            options === 'onevar' ||
            isExceptRequire,
            this.getOptionName() + ' option requires a true value, `onevar` or {allExcept: [\'require\']}'
        );

        var checkers = {
            true: consecutive,
            onevar: onevar
        };

        this._check = isExceptRequire ? exceptRequire : checkers[options];
    },

    getOptionName: function() {
        return 'requireMultipleVarDecl';
    },

    check: function() {
        return this._check.apply(this, arguments);
    }
};

},{"assert":171}],102:[function(require,module,exports){
/**
 * Require unassigned functions to be named inline
 *
 * Types: `Boolean` or `Object`
 *
 * Values:
 *  - `true`
 *  - `Object`:
 *     - `allExcept`: array of quoted identifiers
 *
 * #### Example
 *
 * ```js
 * "requireNamedUnassignedFunctions": { "allExcept": ["describe", "it"] }
 * ```
 *
 * ##### Valid
 *
 * ```js
 * [].forEach(function x() {});
 * var y = function() {};
 * function z() {}
 * it(function () {});
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * [].forEach(function () {});
 * before(function () {});
 * ```
 */

var assert = require('assert');
var pathval = require('pathval');

function getNodeName(node) {
    if (node.type === 'Identifier') {
        return node.name;
    } else {
        return node.value;
    }
}

module.exports = function() {};

module.exports.prototype = {
    configure: function(options) {
        assert(
            options === true ||
            typeof options === 'object',
            this.getOptionName() + ' option requires true value ' +
            'or an object with String[] `allExcept` property'
        );

        // verify first item in `allExcept` property in object (if it's an object)
        assert(
            typeof options !== 'object' ||
            Array.isArray(options.allExcept) &&
            typeof options.allExcept[0] === 'string',
            'Property `allExcept` in ' + this.getOptionName() + ' should be an array of strings'
        );

        if (options.allExcept) {
            this._allExceptItems = options.allExcept.map(function(item) {
                var parts = pathval.parse(item).map(function extractPart(part) {
                    return part.i !== undefined ? part.i : part.p;
                });
                return JSON.stringify(parts);
            });
        }
    },

    getOptionName: function() {
        return 'requireNamedUnassignedFunctions';
    },

    check: function(file, errors) {
        var _this = this;
        file.iterateNodesByType('FunctionExpression', function(node) {
            var parentNode = node.parentNode;
            // If the function has been named via left hand assignment, skip it
            //   e.g. `var hello = function() {`, `foo.bar = function() {`
            if (parentNode.type.match(/VariableDeclarator|Property|AssignmentExpression/)) {
                return;
            }

            // If the function has been named, skip it
            //   e.g. `[].forEach(function hello() {`
            if (node.id !== null) {
                return;
            }

            // If we have exceptions and the function is being invoked, detect whether we excepted it
            if (_this._allExceptItems && parentNode.type === 'CallExpression') {
                // Determine the path that resolves to our call expression
                // We must cover both direct calls (e.g. `it(function() {`) and
                //   member expressions (e.g. `foo.bar(function() {`)
                var memberNode = parentNode.callee;
                var canBeRepresented = true;
                var fullpathParts = [];
                while (memberNode) {
                    if (memberNode.type.match(/Identifier|Literal/)) {
                        fullpathParts.unshift(getNodeName(memberNode));
                    } else if (memberNode.type === 'MemberExpression') {
                        fullpathParts.unshift(getNodeName(memberNode.property));
                    } else {
                        canBeRepresented = false;
                        break;
                    }
                    memberNode = memberNode.object;
                }

                // If the path is not-dynamic (i.e. can be represented by static parts),
                //   then check it against our exceptions
                if (canBeRepresented) {
                    var fullpath = JSON.stringify(fullpathParts);
                    for (var i = 0, l = _this._allExceptItems.length; i < l; i++) {
                        if (fullpath === _this._allExceptItems[i]) {
                            return;
                        }
                    }
                }
            }

            // Complain that this function must be named
            errors.add('Inline functions need to be named', node.loc.start);
        });
    }
};

},{"assert":171,"pathval":873}],103:[function(require,module,exports){
/**
 * Requires newline before opening curly brace of all block statements.
 *
 * Type: `Boolean` or `Array`
 *
 * Values:
 *
 * - `true` always requires newline before curly brace of block statements
 * - `Array` specifies block-type keywords after which newlines are required before curly brace
 *     - Valid types include: `['if', 'else', 'try', 'catch', 'finally', 'do', 'while', 'for', 'function', 'switch']`
 *
 * #### Example
 *
 * ```js
 * "requireNewlineBeforeBlockStatements": true
 * ```
 *
 * ##### Valid
 *
 * ```js
 * function good()
 * {
 *     var obj =
 *     {
 *         val: true
 *     };
 *
 *     return {
 *         data: obj
 *     };
 * }
 *
 * if (cond)
 * {
 *     foo();
 * }
 *
 * for (var e in elements)
 * {
 *     bar(e);
 * }
 *
 * while (cond)
 * {
 *     foo();
 * }
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * function bad(){
 *     var obj = {
 *         val: true
 *     };
 *
 *     return {
 *         data: obj
 *     };
 * }
 *
 * if (cond){
 *     foo();
 * }
 *
 * for (var e in elements){
 *     bar(e);
 * }
 *
 * while (cond){
 *     foo();
 * }
 * ```
 *
 * #### Example
 *
 * ```js
 * "requireNewlineBeforeBlockStatements": ["if", "else", "for"]
 * ```
 *
 * ##### Valid
 *
 * ```js
 * if (i > 0)
 * {
 *     positive = true;
 * }
 *
 * if (i < 0)
 * {
 *     negative = true;
 * }
 * else
 * {
 *     negative = false;
 * }
 *
 * for (var i = 0, len = myList.length; i < len; ++i)
 * {
 *     newList.push(myList[i]);
 * }
 *
 * // this is fine, since "function" wasn't configured
 * function myFunc(x) {
 *     return x + 1;
 * }
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * if (i < 0) {
 *     negative = true;
 * }
 *
 * if (i < 0) {
 *     negative = true;
 * } else {
 *     negative = false;
 * }
 *
 * for (var i = 0, len = myList.length; i < len; ++i) {
 *     newList.push(myList[i]);
 * }
 * ```
 *
 * #### Example
 *
 * ```js
 * "requireNewlineBeforeBlockStatements": ["function", "while"]
 * ```
 *
 * ##### Valid
 *
 * ```js
 * function myFunc(x)
 * {
 *     return x + 1;
 * }
 *
 * var z = function(x)
 * {
 *     return x - 1;
 * }
 *
 * // this is fine, since "for" wasn't configured
 * for (var i = 0, len = myList.length; i < len; ++i) {
 *     newList.push(myList[i]);
 * }
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * function myFunc(x) {
 *     return x + 1;
 * }
 *
 * var z = function(x) {
 *     return x - 1;
 * }
 * ```
 */

var assert = require('assert');

module.exports = function() {};

module.exports.prototype = {
    configure: function(settingValue) {
        assert(
            Array.isArray(settingValue) && settingValue.length || settingValue === true,
            'requireNewlineBeforeBlockStatements option requires non-empty array value or true value'
        );

        this._setting = settingValue;
    },

    getOptionName: function() {
        return 'requireNewlineBeforeBlockStatements';
    },

    check: function(file, errors) {
        var setting = this._setting;

        function assertDifferentLine(token, nextToken) {
            errors.assert.differentLine({
                token: token,
                nextToken: nextToken,
                message: 'Newline before curly brace for block statement is required'
            });
        }

        file.iterateNodesByType('BlockStatement', function(node) {
            if (setting === true || setting.indexOf(getBlockType(node)) !== -1) {
                var openingBrace = file.getFirstNodeToken(node);
                var prevToken = file.getPrevToken(openingBrace);

                assertDifferentLine(prevToken, openingBrace);
            }
        });
        if (setting === true || setting.indexOf('switch') !== -1) {
            file.iterateNodesByType(['SwitchStatement'], function(node) {
                var openingBrace = file.findNextToken(file.getLastNodeToken(node.discriminant), 'Punctuator', '{');
                var prevToken = file.getPrevToken(openingBrace);

                assertDifferentLine(prevToken, openingBrace);
            });
        }
    }
};

function getBlockType(node) {
    var parentNode = node.parentNode;
    switch (parentNode.type) {
        case 'IfStatement':
            return (parentNode.alternate === node) ? 'else' : 'if';
        case 'FunctionDeclaration':
        case 'FunctionExpression':
        case 'ArrowFunctionExpression':
            return 'function';
        case 'ForStatement':
        case 'ForInStatement':
        case 'ForOfStatement':
            return 'for';
        case 'WhileStatement':
            return 'while';
        case 'DoWhileStatement':
            return 'do';
        case 'TryStatement':
            return (parentNode.finalizer === node) ? 'finally' : 'try';
        case 'CatchClause':
            return 'catch';
    }
}

},{"assert":171}],104:[function(require,module,exports){
/**
 * Requires use of binary, hexadecimal, and octal literals instead of parseInt.
 *
 * Type: `Boolean`
 *
 * Value: `true`
 *
 * Version: `ES6`
 *
 * #### Example
 *
 * ```js
 * "requireNumericLiterals": true
 * ```
 *
 * ##### Valid
 *
 * ```js
 * 0b111110111 === 503;
 * 0o767 === 503;
 * 0x1F7 === 503;
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * parseInt("111110111", 2) === 503;
 * parseInt("767", 8) === 503;
 * parseInt("1F7", 16) === 255;
 * ```
 */

var assert = require('assert');

module.exports = function() {};

module.exports.prototype = {
    configure: function(options) {
        assert(
            options === true,
            this.getOptionName() + ' option requires a true value or should be removed'
        );

        this._radixMap = {
            2: 'binary',
            8: 'octal',
            16: 'hexadecimal'
        };
    },

    getOptionName: function() {
        return 'requireNumericLiterals';
    },

    check: function(file, errors) {
        var radixMap = this._radixMap;
        file.iterateNodesByType(['CallExpression'], function(node) {
            // don't check for parseInt(1)
            if (node.arguments.length !== 2) {
                return;
            }

            // only error if the radix is 2, 8, or 16
            var radixName = radixMap[node.arguments[1].value];

            if (node.callee.type === 'Identifier' &&
                node.callee.name === 'parseInt' &&
                radixName
            ) {
                errors.add('Use ' + radixName + ' literals instead of parseInt', node.loc.start);
            }
        });
    }
};

},{"assert":171}],105:[function(require,module,exports){
/**
 * Requires variable declarations from objects via destructuring
 *
 * Type: `Boolean`
 *
 * Value: `true`
 *
 * Version: `ES6`
 *
 * #### Example
 *
 * ```js
 * "requireObjectDestructuring": true
 * ```
 *
 * ##### Valid
 *
 * ```js
 * var { foo } = SomeThing;
 * var { bar } = SomeThing.foo;
 * var { val } = SomeThing['some.key'];
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * var foo = SomeThing.foo;
 * var bar = SomeThing.foo.bar;
 * var val = SomeThing['some.key'].val;
 * ```
 */

var assert = require('assert');

module.exports = function() {};

module.exports.prototype = {
    configure: function(option) {
        var isTrue = option === true;

        assert(
            isTrue || (typeof option === 'object' && Array.isArray(option.allExcept)),
            this.getOptionName() + ' requires the value `true` ' +
              'or an object with an `allExcept` array property'
        );

        this._propertyExceptions = !isTrue && option.allExcept || [];
    },

    getOptionName: function() {
        return 'requireObjectDestructuring';
    },

    check: function(file, errors) {
        var propertyExceptions = this._propertyExceptions;

        file.iterateNodesByType('VariableDeclaration', function(node) {

            node.declarations.forEach(function(declaration) {
                var declarationId = declaration.id || {};
                var declarationInit = declaration.init || {};

                if (declarationId.type !== 'Identifier' || declarationInit.type !== 'MemberExpression') {
                    return;
                }

                var propertyName = declarationInit.property && declarationInit.property.name;

                if (declarationId.name === propertyName &&
                    propertyExceptions.indexOf(propertyName) < 0) {

                    errors.add('Property assignments should use destructuring', node.loc.start);
                }
            });
        });
    }
};

},{"assert":171}],106:[function(require,module,exports){
/**
 * Requires placing object keys on new line
 *
 * Types: `Boolean` or `Object`
 *
 * Values:
 *  - `true`
 *  - `Object`:
 *     - `'allExcept'` array of exceptions:
 *       - `'sameLine'` ignores the rule if all the keys and values are on the same line
 *
 * #### Example
 *
 * ```js
 * "requireObjectKeysOnNewLine": true
 * "requireObjectKeysOnNewLine": {
 *     "allExcept": ["sameLine"]
 * }
 * ```
 *
 * ##### Valid
 *
 * ```js
 * var a = {
 *     b: 'b',
 *     c: 'c'
 * };
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * var a = {
 *     b: 'b', c: 'c'
 * };
 * ```
 *
 * ##### Valid for `{ "allExcept": ["sameLine"] }`
 *
 * ```js
 * var a = {
 *     b: 'b', c: 'c'
 * };
 * ```
 *
 * ##### Invalid for `{ "allExcept": ["sameLine"] }`
 *
 * ```js
 * var a = {
 *     b: 'b', c: 'c',
 *     d: 'd'
 * };
 * ```
 */

var assert = require('assert');

module.exports = function() {};

module.exports.prototype = {
    configure: function(options) {
        assert(
            options === true || Array.isArray(options.allExcept),
            this.getOptionName() + ' option requires a true value or an object of exceptions'
        );

        this._isSameLine = false;
        if (Array.isArray(options.allExcept)) {
            this._isSameLine = options.allExcept[0] === 'sameLine';
        }
    },

    getOptionName: function() {
        return 'requireObjectKeysOnNewLine';
    },

    check: function(file, errors) {
        var message = 'Object keys must go on a new line';
        var isSameLine = this._isSameLine;

        if (isSameLine) {
            message = 'Object keys must go on a new line if they aren\'t all on the same line';
        }

        file.iterateNodesByType('ObjectExpression', function(node) {
            var firstKeyToken;
            var lastValueToken;

            if (isSameLine) {
                if (node.properties.length > 1) {
                    firstKeyToken = file.getFirstNodeToken(node.properties[0].key);
                    lastValueToken = file.getLastNodeToken(node.properties[node.properties.length - 1].value);

                    if (firstKeyToken.loc.end.line === lastValueToken.loc.start.line) {
                        // It's ok, all keys and values are on the same line.
                        return;
                    }
                }
            }

            for (var i = 1; i < node.properties.length; i++) {
                lastValueToken = file.getLastNodeToken(node.properties[i - 1].value);
                var comma = file.findNextToken(lastValueToken, 'Punctuator', ',');

                firstKeyToken = file.getFirstNodeToken(node.properties[i].key);

                errors.assert.differentLine({
                    token: comma,
                    nextToken: firstKeyToken,
                    message: message
                });
            }
        });
    }
};

},{"assert":171}],107:[function(require,module,exports){
/**
 * Requires operators to appear before line breaks and not after.
 *
 * Types: `Array` or `Boolean`
 *
 * Values: Array of quoted operators or `true` to require all possible binary operators to appear before line breaks
 *
 * JSHint: [`laxbreak`](http://www.jshint.com/docs/options/#laxbreak)
 *
 * #### Example
 *
 * ```js
 * "requireOperatorBeforeLineBreak": [
 *     "?",
 *     "=",
 *     "+",
 *     "-",
 *     "/",
 *     "*",
 *     "==",
 *     "===",
 *     "!=",
 *     "!==",
 *     ">",
 *     ">=",
 *     "<",
 *     "<="
 * ]
 * ```
 *
 * ##### Valid
 *
 * ```js
 * x = y ? 1 : 2;
 * x = y ?
 *     1 : 2;
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * x = y
 *     ? 1 : 2;
 * ```
 */

var assert = require('assert');
var defaultOperators = require('../utils').binaryOperators.slice();

defaultOperators.push('?');

module.exports = function() {};

module.exports.prototype = {

    configure: function(operators) {
        var isTrue = operators === true;

        assert(
            Array.isArray(operators) || isTrue,
            this.getOptionName() + ' option requires array value or true value'
        );

        if (isTrue) {
            operators = defaultOperators;
        }

        this._operatorIndex = {};
        for (var i = 0, l = operators.length; i < l; i++) {
            this._operatorIndex[operators[i]] = true;
        }
    },

    getOptionName: function() {
        return 'requireOperatorBeforeLineBreak';
    },

    check: function(file, errors) {
        var operators = this._operatorIndex;
        var throughTokens = ['?', ','];

        function errorIfApplicable(operatorToken) {
            errors.assert.sameLine({
                token: file.getPrevToken(operatorToken),
                nextToken: operatorToken,
                message: 'Operator ' + operatorToken.value + ' should not be on a new line',
                stickToPreviousToken: true
            });
        }

        throughTokens = throughTokens.filter(function(operator) {
            return operators[operator];
        });

        if (throughTokens.length) {
            file.iterateTokensByType('Punctuator', function(token) {
                var operator = token.value;

                if (throughTokens.every(function() {
                    return throughTokens.indexOf(operator) >= 0;
                })) {
                    errorIfApplicable(token);
                }
            });
        }

        file.iterateNodesByType(
            ['BinaryExpression', 'AssignmentExpression', 'LogicalExpression'],
            function(node) {
                var operator = node.operator;

                if (!operators[operator]) {
                    return;
                }

                var nextToken = file.getFirstNodeToken(node.argument || node.right);
                var token = file.findPrevOperatorToken(nextToken, operator);

                errorIfApplicable(token);
            }
        );
    }
};

},{"../utils":166,"assert":171}],108:[function(require,module,exports){
/**
 * Requires an extra blank newline after var declarations, as long
 * as it is not the last expression in the current block.
 *
 * Type: `Boolean`
 *
 * Value: `true`
 *
 * #### Example
 *
 * ```js
 * "requirePaddingNewLineAfterVariableDeclaration": true
 * ```
 *
 * ##### Valid
 *
 * ```js
 * var x = {
 *     a: 1
 * };
 *
 * foo({
 *     a: {
 *         b: 1
 *     }
 * });
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * var x = { a: 1 };
 * foo({a:{b:1}});
 * ```
 */

var assert = require('assert');

module.exports = function() {};

module.exports.prototype = {

    configure: function(requirePaddingNewLineAfterVariableDeclaration) {
        assert(
            requirePaddingNewLineAfterVariableDeclaration === true,
            this.getOptionName() + ' option requires a true value or should be removed'
        );
    },

    getOptionName: function() {
        return 'requirePaddingNewLineAfterVariableDeclaration';
    },

    check: function(file, errors) {
        file.iterateNodesByType('VariableDeclaration', function(node) {
            if (node.parentNode.type === 'ForStatement' ||
                node.parentNode.type === 'ForInStatement' ||
                node.parentNode.type === 'ForOfStatement') {
                return;
            }

            var endOfDeclaration = file.getLastNodeToken(node);
            var nextToken = file.getNextToken(endOfDeclaration);

            // check export declaration
            if (nextToken.value === 'export') {
                nextToken = file.getNextToken(nextToken);
            }

            if (nextToken.value in {'var': true, 'let': true, 'const': true}) {
                return;
            }

            if (nextToken.value === '}') {
                return;
            }

            if (nextToken.type === 'EOF') {
                return;
            }

            errors.assert.linesBetween({
                atLeast: 2,
                token: endOfDeclaration,
                nextToken: nextToken
            });
        });
    }

};

},{"assert":171}],109:[function(require,module,exports){
/**
 * Requires newline after blocks
 *
 * Type: `Boolean` or `Object`
 *
 * Values:
 * - `true`: always require a newline after blocks
 * - `Object`:
 *      - `"allExcept"`: `Array`
 *          - `"inCallExpressions"` Blocks don't need a line of padding in function argument lists
 *          - `"inNewExpressions"` Blocks don't need a line of padding in constructor argument lists
 *          - `"inArrayExpressions"` Blocks don't need a line of padding in arrays
 *          - `"inProperties"` Blocks don't need a line of padding as object properties
 *
 * #### Example
 *
 * ```js
 * "requirePaddingNewLinesAfterBlocks": true
 * "requirePaddingNewLinesAfterBlocks": {
 *     "allExcept": ["inCallExpressions", "inNewExpressions", "inArrayExpressions", "inProperties"]
 * }
 * ```
 *
 * ##### Valid
 *
 * ```js
 * function () {
 *     for (var i = 0; i < 2; i++) {
 *         if (true) {
 *             return false;
 *         }
 *
 *         continue;
 *     }
 *
 *     var obj = {
 *         foo: function() {
 *             return 1;
 *         },
 *
 *         bar: function() {
 *             return 2;
 *         }
 *     };
 *
 *     func(
 *          function() {
 *          }
 *     );
 *
 *     var a = [
 *         function() {
 *         },
 *
 *         function() {
 *         }
 *     ]
 *
 * }
 * ```
 *
 * ##### Valid for `{ "allExcept": ["inCallExpressions"] }`
 *
 * ```js
 * func(
 *     2,
 *     3,
 *     function() {
 *     }
 * );
 * ```
 *
 * ##### Valid for `{ "allExcept": ["inNewExpressions"] }`
 *
 * ```js
 * new SomeClass(
 *     2,
 *     3,
 *     function() {
 *     }
 * );
 * ```
 *
 * ##### Valid for `{ "allExcept": ["inArrayExpressions"] }`
 *
 * ```js
 * var foo = [
 *     2,
 *     3,
 *     function() {
 *     }
 * ];
 * ```
* ##### Valid for `{ "allExcept": ["inProperties"] }`
 *
 * ```js
 * var foo = {
 *     a: 2,
 *     b: function() {
 *     },
 *     c: 3
 * ];
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * function () {
 *     for (var i = 0; i < 2; i++) {
 *         if (true) {
 *             return false;
 *         }
 *         continue;
 *     }
 * }
 * ```
 */

var assert = require('assert');

var excludes = {
    'IfStatement': ['else'],
    'DoWhileStatement': ['while'],
    'TryStatement': ['catch', 'finally'],
    'CatchClause': ['finally'],
    'FunctionExpression': ['.'],
    'ArrowFunctionExpression': [')']
};

function isException(parent, exceptions) {
    var grandpa = parent.parentNode;

    // Check if this block is used in call or array expression
    if (grandpa && exceptions[grandpa.type]) {
        return true;
    }

    return false;
}

module.exports = function() {};

module.exports.prototype = {

    configure: function(value) {
        this.exceptions = {
            'CallExpression': false,
            'NewExpression': false,
            'ArrayExpression': false,
            'Property': false
        };

        var optionName = this.getOptionName();

        if (typeof value === 'object') {
            assert(Array.isArray(value.allExcept), optionName + ' option requires "allExcept" ' +
                'to be an array');
            assert(value.allExcept.length > 0, optionName + ' option requires "allExcept" ' +
                'to have at least one item or be set to `true`');

            value.allExcept.forEach(function(except) {
                if (except === 'inCallExpressions') {
                    this.exceptions.CallExpression = true;
                } else if (except === 'inNewExpressions') {
                    this.exceptions.NewExpression = true;
                } else if (except === 'inArrayExpressions') {
                    this.exceptions.ArrayExpression = true;
                } else if (except === 'inProperties') {
                    this.exceptions.Property = true;
                } else {
                    assert(false, optionName + ' option requires "allExcept" to only have ' +
                        'one of "inCallExpressions", "inNewExpressions", "inArrayExpressions" or "inProperties');
                }
            }, this);
        } else {
            assert(value === true,
                optionName + ' option requires true value or object'
            );
        }
    },

    getOptionName: function() {
        return 'requirePaddingNewLinesAfterBlocks';
    },

    check: function(file, errors) {
        file.iterateNodesByType('BlockStatement', (function(node) {

            var endToken = file.getLastNodeToken(node);
            var parentNode = node.parentNode;

            if (isException(parentNode, this.exceptions)) {
                return;
            }

            var nextToken = file.getNextToken(endToken);

            while (nextToken.type !== 'EOF') {
                var excludeValues = excludes[parentNode.type];
                if (excludeValues && excludeValues.indexOf(nextToken.value) !== -1) {
                    return;
                }

                if (endToken.loc.end.line === nextToken.loc.start.line) {
                    endToken = nextToken;
                    nextToken = file.getNextToken(nextToken);
                    continue;
                }

                if (nextToken.type === 'Punctuator' && (
                    nextToken.value === '}' ||
                    nextToken.value === ']' ||
                    nextToken.value === '>' ||
                    nextToken.value === ')')
                ) {
                    return;
                }

                errors.assert.linesBetween({
                    token: endToken,
                    nextToken: nextToken,
                    atLeast: 2,
                    message: 'Missing newline after block'
                });

                return;
            }
        }).bind(this));
    }
};

},{"assert":171}],110:[function(require,module,exports){
/**
 * Requires a blank line after `'use strict';` statements
 *
 * Values:
 *  - `true` for default behavior (require blank line after 'use strict' statements)
 *  - `Object`:
 *    - `'allExcept'` array of exceptions:
 *       - `'require'` allows 'require' statements to occur immediately after 'use strict'
 *
 * #### Example
 *
 * ```js
 * "requirePaddingNewLinesAfterUseStrict": true
 * ```
 *
 * ##### Valid
 *
 * ```js
 * 'use strict';
 *
 * // code
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * 'use strict';
 * // code
 * ```
 */

var assert = require('assert');

module.exports = function() {};

module.exports.prototype = {

    configure: function(options) {
        if (typeof options !== 'object') {
            assert(
                options === true,
                this.getOptionName() + ' option requires either a true value or an object'
            );

            var _options = {allExcept: []};
            return this.configure(_options);
        }

        if (Array.isArray(options.allExcept)) {
            this._exceptRequire = options.allExcept.indexOf('require') > -1;
        }
    },

    getOptionName: function() {
        return 'requirePaddingNewLinesAfterUseStrict';
    },

    check: function(file, errors) {
        var exceptRequire = this._exceptRequire;
        file.iterateNodesByType('ExpressionStatement', function(node) {
            var expression = node.expression;

            if (expression.type !== 'Literal' || expression.value !== 'use strict') {
                return;
            }

            var endOfNode = file.getLastNodeToken(node);
            if (exceptRequire) {
                var requireToken = file.findNextToken(endOfNode, 'Identifier', 'require');
                if (requireToken && node.loc.start.line + 1 === requireToken.loc.start.line) {

                    // Ensure the detected require is the first declaration of this line
                    var keywordToken = file.getNextToken(endOfNode, {
                        includeComments: true
                    });
                    var identifierToken = file.getNextToken(file.getLastNodeToken(keywordToken), {
                        includeComments: true
                    });
                    var punctuatorToken = file.getNextToken(file.getLastNodeToken(identifierToken), {
                        includeComments: true
                    });
                    requireToken = file.getNextToken(file.getLastNodeToken(punctuatorToken), {
                        includeComments: true
                    });

                    if (
                        keywordToken.type === 'Keyword' &&
                        identifierToken.type === 'Identifier' &&
                        punctuatorToken.type === 'Punctuator' &&
                        requireToken.type === 'Identifier' &&
                        requireToken.value === 'require'
                    ) {
                        return;
                    }
                }
            }

            var nextToken = file.getNextToken(endOfNode, {
                includeComments: true
            });

            errors.assert.linesBetween({
                atLeast: 2,
                token: endOfNode,
                nextToken: nextToken
            });
        });
    }
};

},{"assert":171}],111:[function(require,module,exports){
/**
 * Requires newline before module.exports
 *
 * Type: `Boolean`
 *
 * Value: `true`
 *
 * #### Example
 *
 * ```js
 * "requirePaddingNewLinesBeforeExport": true
 * ```
 *
 * ##### Valid
 *
 * ```js
 * var a = 2;
 *
 * module.exports = a;
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * var a = 2;
 * module.exports = a;
 * ```
 */

var assert = require('assert');

module.exports = function() {};

module.exports.prototype = {

    configure: function(value) {
        assert(
            value === true,
            this.getOptionName() + ' option requires a true value or should be removed'
        );
    },

    getOptionName: function() {
        return 'requirePaddingNewLinesBeforeExport';
    },

    check: function(file, errors) {
        file.iterateNodesByType('AssignmentExpression', function(node) {
            var left = node.left;
            if (!(
                left.object &&
                left.object.name === 'module' &&
                left.property &&
                left.property.name === 'exports')) {
                return;
            }

            var firstToken = file.getFirstNodeToken(node);
            var prevToken = file.getPrevToken(firstToken);

            errors.assert.linesBetween({
                atLeast: 2,
                token: prevToken,
                nextToken: firstToken,
                message: 'Missing newline before export'
            });
        });
    }

};

},{"assert":171}],112:[function(require,module,exports){
/**
 * Requires an empty line above the specified keywords unless the keyword is the first expression in a block.
 *
 * Types: `Boolean` or `Array`
 *
 * Values:
 *
 * - `true` specifies that the spacedKeywords found in the utils module require an empty line above it
 * - `Array` specifies quoted keywords which require an empty line above it
 *
 * #### Example
 *
 * ```js
 * "requirePaddingNewlinesBeforeKeywords": [
 *     "do",
 *     "for",
 *     "if",
 *     "else"
 *     // etc
 * ]
 * ```
 *
 * ##### Valid for mode `true`
 *
 * ```js
 * function(a) {
 *     if (!a) {
 *         return false;
 *     }
 *
 *     for (var i = 0; i < b; i++) {
 *         if (!a[i]) {
 *             return false;
 *         }
 *     }
 *
 *     while (a) {
 *         a = false;
 *     }
 *     return true;
 * }
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * function(a) {
 *     if (!a) {
 *         return false;
 *     }
 *     for (var i = 0; i < b; i++) {
 *         if (!a[i]) {
 *             return false;
 *         }
 *     }
 *     while (a) {
 *         a = false;
 *     }
 *     return true;
 * }
 * ```
 *
 * ##### Valid for mode `['if', for']`
 *
 * ```js
 * function(a) {
 *     if (!a) {
 *         return false;
 *     }
 *
 *     for (var i = 0; i < b; i++) {
 *         if (!a[i]) {
 *             return false;
 *         }
 *     }
 *     while (a) {
 *         a = false;
 *     }
 *     return true;
 * }
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * function(a) {
 *     if (!a) {
 *         return false;
 *     }
 *     for (var i = 0; i < b; i++) {
 *         if (!a[i]) {
 *             return false;
 *         }
 *     }
 *     while (a) {
 *         a = false;
 *     }
 *     return true;
 * }
 * ```
 *
 */

var assert = require('assert');
var defaultKeywords = require('../utils').spacedKeywords;

module.exports = function() { };

module.exports.prototype = {

    configure: function(keywords) {
        assert(Array.isArray(keywords) || keywords === true,
            this.getOptionName() + ' option requires array or true value');

        if (keywords === true) {
            keywords = defaultKeywords;
        }

        this._keywords = keywords;
    },

    getOptionName: function() {
        return 'requirePaddingNewlinesBeforeKeywords';
    },

    check: function(file, errors) {
        var excludedTokens = [':', ',', '(', '='];
        var specialCases = { 'if': 'else' };
        file.iterateTokensByTypeAndValue('Keyword', this._keywords, function(token) {
            var prevToken = file.getPrevToken(token);
            // Handle special cases listed in specialCasesToken array
            if (prevToken && prevToken.value === specialCases[token.value]) {
                return;
            // Allow returning a function
            } else if (prevToken && prevToken.value === 'return' && token.value === 'function') {
                return;
            } else if (prevToken && token.value === 'while' &&
                file.getNodesByFirstToken(token).length === 0) {
                return;
            // Handle excludedTokens
            } else if (prevToken && excludedTokens.indexOf(prevToken.value) > -1) {
                return;
            }

            // Handle all other cases
            // The { character is there to handle the case of a matching token which happens to be the first
            //   statement in a block
            // The ) character is there to handle the case of `if (...) matchingKeyword` in which case
            //   requiring padding would break the statement
            if (prevToken && prevToken.value !== '{' && prevToken.value !== ')') {

                errors.assert.linesBetween({
                    token: prevToken,
                    nextToken: token,
                    atLeast: 2,
                    message: 'Keyword `' + token.value + '` should have an empty line above it'
                });
            }
        });
    }
};

},{"../utils":166,"assert":171}],113:[function(require,module,exports){
/**
 * Requires newline before line comments
 *
 * Types: `Boolean` or `Object`
 *
 * Values:
 * - `true`: always require a newline before line comments
 * - `Object`:
 *      - `"allExcept"`: `"firstAfterCurly"` Comments may be first line of block without extra padding
 *
 * #### Examples
 * ```js
 * "requirePaddingNewLinesBeforeLineComments": true
 * "requirePaddingNewLinesBeforeLineComments": { "allExcept": "firstAfterCurly" }
 * ```
 *
 * ##### Valid for `true`
 *
 * ```js
 * var a = 2;
 * var b = 3; // comment
 *
 * // comment
 * return a;
 *
 * function() {
 *
 *   // comment
 * }
 * ```
 *
 * ##### Valid for `{ "allExcept": "firstAfterCurly" }`
 *
 * ```js
 * var a = 2;
 *
 * // comment
 * return a;
 *
 * function() {
 *   // comment
 * }
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * var a = 2;
 * //comment
 * return a;
 *
 * function() {
 *   // comment
 * }
 * ```
 */

var assert = require('assert');

module.exports = function() {};

module.exports.prototype = {

    configure: function(value) {
        this._allowFirstAfterCurly = false;

        if (typeof value === 'object') {
            assert(typeof value.allExcept === 'string' && value.allExcept === 'firstAfterCurly',
                this.getOptionName() + ' option requires the "allExcept" ' +
                 'property to equal "firstAfterCurly"');
            this._allowFirstAfterCurly = true;
        } else {
            assert(value === true,
                this.getOptionName() + ' option requires true value or object'
            );
        }
    },

    getOptionName: function() {
        return 'requirePaddingNewLinesBeforeLineComments';
    },

    check: function(file, errors) {
        var allowFirstAfterCurly = this._allowFirstAfterCurly;

        file.iterateTokensByType('Line', function(comment) {
            if (comment.loc.start.line === 1) {
                return;
            }

            var firstToken = file.getFirstTokenOnLine(comment.loc.start.line);

            // Should not consider code and comment on the same line (#1194)
            if (firstToken !== null && firstToken.type !== 'EOF') {
                return;
            }

            var prevToken = file.getPrevToken(comment, {includeComments: true});

            if (!prevToken || prevToken.type === 'Line') {
                return;
            }

            if (allowFirstAfterCurly && prevToken.type === 'Punctuator' && prevToken.value === '{') {
                return;
            }

            errors.assert.linesBetween({
                token: prevToken,
                nextToken: comment,
                atLeast: 2,
                message: 'Line comments must be preceded with a blank line'
            });
        });
    }
};

},{"assert":171}],114:[function(require,module,exports){
/**
 * Requires blocks to begin and end with 2 newlines
 *
 * Types: `Boolean`, `Integer`, `Object`
 *
 * Values:
 *  - `true` validates all non-empty blocks
 *  - `Integer` specifies a minimum number of lines containing elements in the block before validating
 *  - `Object` (at least one of properties must be true):
 *      - `'open'`
 *          - `true` validates that there is a newline after the opening brace in a block
 *          - `false` ignores the newline validation after the opening brace in a block
 *      - `'close'`
 *          - `true` validates that there is a newline before the closing brace in a block
 *          - `false` ignores the newline validation before the closing brace in a block
 *      - `'allExcept'` array of exceptions:
 *          - `'conditionals'` ignores conditional (if, else if, else) blocks
 *          - `'functions'` ignores function blocks
 *
 * #### Example
 *
 * ```js
 * "requirePaddingNewlinesInBlocks": true
 * "requirePaddingNewlinesInBlocks": 1
 * "requirePaddingNewlinesInBlocks": { "open": true, "close": false }
 * "requirePaddingNewlinesInBlocks": { "allExcept": [ "conditionals" ] }
 * "requirePaddingNewlinesInBlocks": { "open": true, "close": false, allExcept: ['conditionals'] }
 * ```
 *
 * ##### Valid for mode `true` or `{ "open": true, "close": true }`
 *
 * ```js
 * if (true) {
 *
 *     doSomething();
 *
 * }
 * var abc = function() {};
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * if (true) {doSomething();}
 * if (true) {
 *     doSomething();
 * }
 * ```
 *
 * ##### Valid for mode `1`
 *
 * ```js
 * if (true) {
 *
 *     doSomething();
 *     doSomethingElse();
 *
 * }
 * if (true) {
 *     doSomething();
 * }
 * if (true) { doSomething(); }
 * var abc = function() {};
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * if (true) { doSomething(); doSomethingElse(); }
 * if (true) {
 *     doSomething();
 *     doSomethingElse();
 * }
 *  ```
 *
 * ##### Valid for mode `{ "open": true, "close": false }`
 *
 * ```js
 * if (true) {
 *
 *     doSomething();
 * }
 * var abc = function() {};
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * if (true) {doSomething();}
 * if (true) {
 *     doSomething();
 * }
 * if (true) {
 *     doSomething();
 *
 * }
 * ```
 *
 * ##### Valid for `{ allExcept: ['conditionals'] }`
 *
 * ```js
 * if (true) {
 *     doSomething();
 * }
 *
 * function (foo) {
 *
 *     return bar;
 *
 * }
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * function (foo) {
 *     return bar;
 * }
 * ```
 *
 * ##### Valid for `{  "open": true, "close": false, allExcept: ['conditionals'] }`
 *
 * ```js
 * function (foo) {
 *
 *     return bar;
 * }
 *
 * if (true) {
 *     doSomething();
 * }
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * function (foo) {
 *     return bar;
 *
 * }
 * ```
 */

var assert = require('assert');

module.exports = function() {};

module.exports.prototype = {

    configure: function(options) {
        var optionName = this.getOptionName();

        assert(
            options === true || typeof options === 'number' || typeof options === 'object',
            optionName + ' option requires the value true, an Integer or an object'
        );

        this._checkOpen = true;
        this._checkClose = true;
        this._minLines = 0;

        if (typeof options === 'object') {
            assert(options.allExcept || options.open || options.close,
            optionName + 'option requires either "open", "close", "allExcept"');

            if (options.allExcept) {
                assert(Array.isArray(options.allExcept), optionName + ' option requires "allExcept" to be an array');
                assert(options.allExcept.length > 0, optionName + ' option requires "allExcept" to have at least one ' +
                'item or be set to `true`');
                this._exceptConditionals = options.allExcept.indexOf('conditionals') > -1;
                this._exceptFunctions = options.allExcept.indexOf('functions') > -1;
            }

            if (options.open || options.close) {
                assert(typeof options.open === 'boolean' && typeof options.close === 'boolean',
                  this.getOptionName() + ' option requires the "open" and "close" ' +
                  'properties to be booleans');

                this._checkOpen = options.open;
                this._checkClose = options.close;
            }
        } else if (typeof options === 'number') {
            this._minLines = options;
        } else {
            assert(options === true, this.getOptionName() + ' option requires either a true value, or an object');
        }
    },

    getOptionName: function() {
        return 'requirePaddingNewlinesInBlocks';
    },

    check: function(file, errors) {
        var minLines = this._minLines;
        var exceptConditionals = this._exceptConditionals;
        var exceptFunctions = this._exceptFunctions;
        var checkOpen = this._checkOpen;
        var checkClose = this._checkClose;

        file.iterateNodesByType('BlockStatement', function(node) {
            var openingBracket;
            var closingBracket;

            if (node.body.length <= minLines) {
                return;
            }

            if (exceptConditionals && node.parentNode.type === 'IfStatement' ||
                exceptFunctions && (node.parentNode.type === 'FunctionExpression' ||
                node.parentNode.type === 'FunctionDeclaration')) {
                return;
            }

            if (checkOpen === true) {
                openingBracket = file.getFirstNodeToken(node);

                errors.assert.linesBetween({
                    token: openingBracket,
                    nextToken: file.getNextToken(openingBracket, {includeComments: true}),
                    atLeast: 2,
                    message: 'Expected a padding newline after opening curly brace'
                });
            }

            if (checkClose === true) {
                closingBracket = file.getLastNodeToken(node);

                errors.assert.linesBetween({
                    token: file.getPrevToken(closingBracket, {includeComments: true}),
                    nextToken: closingBracket,
                    atLeast: 2,
                    message: 'Expected a padding newline before closing curly brace'
                });
            }
        });
    }
};

},{"assert":171}],115:[function(require,module,exports){
/**
 * Requires newline inside curly braces of all objects.
 *
 * Type: `Boolean`
 *
 * Value: `true`
 *
 * #### Example
 *
 * ```js
 * "requirePaddingNewLinesInObjects": true
 * ```
 *
 * ##### Valid
 *
 * ```js
 * var x = {
 *     a: 1
 * };
 * foo({
 *     a: {
 *         b: 1
 *     }
 * });
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * var x = { a: 1 };
 * foo({a:{b:1}});
 * ```
 */

var assert = require('assert');

module.exports = function() {};

module.exports.prototype = {

    configure: function(value) {
        assert(
            value === true,
            this.getOptionName() + ' option requires a true value or should be removed'
        );
    },

    getOptionName: function() {
        return 'requirePaddingNewLinesInObjects';
    },

    check: function(file, errors) {
        file.iterateNodesByType('ObjectExpression', function(node) {
            var openingBracket = file.getFirstNodeToken(node);
            var nextToken = file.getNextToken(openingBracket);

            if (nextToken.type === 'Punctuator' && nextToken.value === '}') {
                return;
            }

            errors.assert.differentLine({
                token: openingBracket,
                nextToken: nextToken,
                message: 'Missing newline after opening curly brace'
            });

            var closingBracket = file.getLastNodeToken(node);

            errors.assert.differentLine({
                token: file.getPrevToken(closingBracket),
                nextToken: closingBracket,
                message: 'Missing newline before closing curly brace'
            });
        });
    }

};

},{"assert":171}],116:[function(require,module,exports){
/**
 * Requires parentheses around arrow function expressions with a single parameter.
 *
 * Type: `Boolean`
 *
 * Value: `true`
 *
 * Version: `ES6`
 *
 * #### Example
 *
 * ```js
 * "requireParenthesesAroundArrowParam": true
 * ```
 *
 * ##### Valid
 *
 * ```js
 * [1, 2, 3].map((x) => x * x);
 * // params are always required for multiple parameters
 * [1, 2, 3].map((x, y, z) => x * x);
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * [1, 2, 3].map(x => x * x);
 * ```
 */

var assert = require('assert');

module.exports = function() {};

module.exports.prototype = {

    configure: function(options) {
        assert(
            options === true,
            this.getOptionName() + ' option requires a true value or should be removed'
        );
    },

    getOptionName: function() {
        return 'requireParenthesesAroundArrowParam';
    },

    check: function(file, errors) {
        function isWrapped(node) {
            var openParensToken = file.getPrevToken(file.getFirstNodeToken(node));
            var closingParensToken = file.getNextToken(file.getLastNodeToken(node));
            var closingTokenValue = closingParensToken ? closingParensToken.value : '';

            return openParensToken.value + closingTokenValue === '()';
        }

        file.iterateNodesByType('ArrowFunctionExpression', function(node) {
            var params = node.params;
            var firstParam = params[0];

            if (params.length === 1 && !isWrapped(firstParam)) {
                errors.add(
                    'Wrap arrow function expressions in parentheses',
                    firstParam.loc.start
                );
            }
        });
    }

};

},{"assert":171}],117:[function(require,module,exports){
/**
 * Requires parentheses around immediately invoked function expressions.
 *
 * Type: `Boolean`
 *
 * Value: `true`
 *
 * JSHint: [`immed`](http://www.jshint.com/docs/options/#immed)
 *
 * #### Example
 *
 * ```js
 * "requireParenthesesAroundIIFE": true
 * ```
 *
 * ##### Valid
 *
 * ```js
 * var a = (function(){ return 1; })();
 * var b = (function(){ return 2; }());
 * var c = (function(){ return 3; }).call(this, arg1);
 * var d = (function(){ return 3; }.call(this, arg1));
 * var e = (function(){ return d; }).apply(this, args);
 * var f = (function(){ return d; }.apply(this, args));
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * var a = function(){ return 1; }();
 * var c = function(){ return 3; }.call(this, arg1);
 * var d = function(){ return d; }.apply(this, args);
 * ```
 */

var assert = require('assert');
var utils = require('../utils');

module.exports = function() {};

module.exports.prototype = {

    configure: function(options) {
        assert(
            options === true,
            this.getOptionName() + ' option requires a true value or should be removed'
        );
    },

    getOptionName: function() {
        return 'requireParenthesesAroundIIFE';
    },

    check: function(file, errors) {

        function isWrapped(node) {
            var openParensToken = file.getPrevToken(file.getFirstNodeToken(node));

            var closingParensToken = file.getNextToken(file.getLastNodeToken(node));
            var closingTokenValue = closingParensToken ? closingParensToken.value : '';

            return openParensToken.value + closingTokenValue === '()';
        }

        file.iterateNodesByType('CallExpression', function(node) {
            var inner = utils.getFunctionNodeFromIIFE(node);

            if (inner && !isWrapped(inner) && !isWrapped(node)) {
                errors.add(
                    'Wrap immediately invoked function expressions in parentheses',
                    node.loc.start.line,
                    node.loc.start.column
                );

            }
        });
    }

};

},{"../utils":166,"assert":171}],118:[function(require,module,exports){
/**
 * Requires quoted keys in objects.
 *
 * Type: `Boolean`
 *
 * Value: `true`
 *
 * #### Example
 *
 * ```js
 * "requireQuotedKeysInObjects": true
 * ```
 *
 * ##### Valid
 *
 * ```js
  * var x = { 'a': { "default": 1 } };
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * var x = { a: 1 };
 * ```
 */

var assert = require('assert');

module.exports = function() { };

module.exports.prototype = {

    configure: function(options) {
        assert(
            options === true,
            this.getOptionName() + ' option requires a true value or should be removed'
        );
    },

    getOptionName: function() {
        return 'requireQuotedKeysInObjects';
    },

    check: function(file, errors) {
        file.iterateNodesByType('ObjectExpression', function(node) {
            node.properties.forEach(function(property) {
                if (property.shorthand || property.method || property.kind !== 'init' ||
                    node.type === 'SpreadProperty') {
                    return;
                }

                var key = property.key;
                if (!(typeof key.value === 'string' && key.type === 'Literal')) {
                    errors.add('Object key without surrounding quotes', property.loc.start);
                }
            });
        });
    }
};

},{"assert":171}],119:[function(require,module,exports){
/**
 * Requires semicolon after:
 *
 * * var declaration
 * * expression statement
 * * return
 * * throw
 * * break
 * * continue
 * * do-while
 *
 * Type: `Boolean`
 *
 * Value: `true`
 *
 * #### Example
 *
 * ```js
 * "requireSemicolons": true
 * ```
 *
 * ##### Valid
 *
 * ```js
 * var a = 1;
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * var a = 1
 * ```
*/

var assert = require('assert');

module.exports = function() {};

module.exports.prototype = {

    configure: function(options) {
        assert(
            options === true,
            this.getOptionName() + ' option requires a true value or should be removed'
        );
    },

    getOptionName: function() {
        return 'requireSemicolons';
    },

    check: function(file, errors) {
        file.iterateNodesByType([
            'VariableDeclaration',
            'ImportDeclaration',
            'ExportDeclaration',
            'ExportDefaultDeclaration',
            'ExportNamedDeclaration',
            'ExpressionStatement',
            'DoWhileStatement',
            'ReturnStatement',
            'ThrowStatement',
            'BreakStatement',
            'ContinueStatement',
            'DebuggerStatement',
            'ClassProperty'
        ], function(node) {
            // ignore variable declaration inside for and for-in
            if (node.type === 'VariableDeclaration') {
                if ((node.parentNode.type === 'ForInStatement' && node.parentNode.left === node) ||
                    (node.parentNode.type === 'ForOfStatement' && node.parentNode.left === node) ||
                    (node.parentNode.type === 'ForStatement' && node.parentNode.init === node)) {
                    return;
                }
            }

            // don't require semicolon for class and function exports
            if (node.type === 'ExportDefaultDeclaration' ||
                node.type === 'ExportNamedDeclaration') {
                if (node.declaration) {
                    if (node.declaration.type === 'ClassDeclaration' ||
                        node.declaration.type === 'FunctionDeclaration') {
                        return;
                    }
                }
            }

            // get last token inside node
            var lastToken = file.getLastNodeToken(node);
            var checkToken = lastToken;

            // if last token is not a semicolon punctuator, try to get next token in file
            if (checkToken && (checkToken.type !== 'Punctuator' || checkToken.value !== ';')) {
                checkToken = file.getNextToken(checkToken);
            }

            // check token is semicolon
            if (!checkToken || checkToken.type !== 'Punctuator' || checkToken.value !== ';') {
                var entity = lastToken || node;

                errors.cast({
                    message: 'Missing semicolon after statement',
                    line: entity.loc.end.line,
                    column: entity.loc.end.column,
                    additional: entity
                });
            }
        });
    },

    _fix: function(file, error) {
        var token;
        var entity = error.additional;
        var isNode = !!entity.parentNode;

        if (isNode) {
            token = file.getLastNodeToken(entity.parentNode);

        } else {
            token = file.getNextToken(entity, { includeComments: true });
        }

        file.setWhitespaceBefore(token, ';' + file.getWhitespaceBefore(token));
    }
};

},{"assert":171}],120:[function(require,module,exports){
/**
 * Require arrow functions to use an expression body when returning a single statement
 * (no block statement, implicit return).
 *
 * Type: `Boolean`
 *
 * Value: `true`
 *
 * Version: `ES6`
 *
 * #### Example
 *
 * ```js
 * "requireShorthandArrowFunctions": true
 * ```
 *
 * ##### Valid
 *
 * ```js
 * // single expression
 * evens.map(v => v + 1);
 * // multiple statments require a block
 * evens.map(v => {
 *     v = v + 1;
 *     return v;
 * });
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * evens.map(v => { return v + 1; });
 * ```
 */

var assert = require('assert');

module.exports = function() {};

module.exports.prototype = {

    configure: function(options) {
        assert(
            options === true,
            this.getOptionName() + ' option requires a true value or should be removed'
        );
    },

    getOptionName: function() {
        return 'requireShorthandArrowFunctions';
    },

    check: function(file, errors) {
        file.iterateNodesByType('ArrowFunctionExpression', function(node) {
            var body = node.body;
            if (body.type === 'BlockStatement' &&
                body.body.length === 1 &&
                body.body[0].type === 'ReturnStatement') {
                errors.add(
                    'Use the shorthand arrow function form',
                    node.body.loc.start
                );
            }
        });
    }

};

},{"assert":171}],121:[function(require,module,exports){
/**
 * Disallows sticking binary operators to the right.
 *
 * Types: `Array` or `Boolean`
 *
 * Values: Array of quoted operators or `true` to require space after all possible binary operators
 *
 * #### Example
 *
 * ```js
 * "requireSpaceAfterBinaryOperators": [
 *     "=",
 *     ",",
 *     "+",
 *     "-",
 *     "/",
 *     "*",
 *     "==",
 *     "===",
 *     "!=",
 *     "!=="
 *     // etc
 * ]
 * ```
 *
 * ##### Valid
 *
 * ```js
 * x + y;
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * x +y;
 * ```
 */

var assert = require('assert');
var allOperators = require('../utils').binaryOperators;

module.exports = function() {};

module.exports.prototype = {

    configure: function(operators) {
        var isTrue = operators === true;

        assert(
            Array.isArray(operators) || isTrue,
            this.getOptionName() + ' option requires array or true value'
        );

        if (isTrue) {
            operators = allOperators;
        }

        this._operatorIndex = {};
        for (var i = 0, l = operators.length; i < l; i++) {
            this._operatorIndex[operators[i]] = true;
        }
    },

    getOptionName: function() {
        return 'requireSpaceAfterBinaryOperators';
    },

    check: function(file, errors) {
        var operators = this._operatorIndex;

        // Comma
        if (operators[',']) {
            file.iterateTokensByTypeAndValue('Punctuator', ',', function(token) {
                errors.assert.whitespaceBetween({
                    token: token,
                    nextToken: file.getNextToken(token),
                    message: 'Operator , should not stick to following expression'
                });
            });
        }

        // For everything else
        file.iterateNodesByType(
            ['BinaryExpression', 'AssignmentExpression', 'VariableDeclarator', 'LogicalExpression'],
            function(node) {
                var operator;
                var expression;

                if (node.type === 'VariableDeclarator') {
                    expression = node.init;
                    operator = '=';
                } else {
                    operator = node.operator;
                    expression = node.right;
                }

                if (expression === null) {
                    return;
                }

                var operatorToken = file.findPrevOperatorToken(
                    file.getFirstNodeToken(expression),
                    operator
                );

                var nextToken = file.getNextToken(operatorToken);

                if (operators[operator]) {
                    errors.assert.whitespaceBetween({
                        token: operatorToken,
                        nextToken: nextToken,
                        message: 'Operator ' + operator + ' should not stick to following expression'
                    });
                }
            }
        );
    }

};

},{"../utils":166,"assert":171}],122:[function(require,module,exports){
/**
 * Requires space after comma
 *
 * Types: `Boolean`, or `Object`
 *
 * Values:
 *  - `Boolean`: `true` to require a space after any comma
 *  - `Object`:
 *    - `"allExcept"` array of exceptions:
 *      - `"trailing"` ignore trailing commas
 *
 * #### Example
 *
 * ```js
 * "requireSpaceAfterComma": true
 * ```
 * ```
 * "requireSpaceAfterComma": {"allExcept": ["trailing"]}
 * ```
 *
 * ##### Valid for mode `true`
 *
 * ```js
 * var a, b;
 * ```
 *
 * ##### Invalid for mode `true`
 *
 * ```js
 * var a,b;
 * ```
 *
 *##### Valid for mode `{"allExcept": ["trailing"]}`
 *
 * ```js
 * var a = [1, 2,];
 * ```
 *
 * ##### Invalid for mode `{"allExcept": ["trailing"]}`
 *
 * ```js
 * var a = [a,b,];
 * ```
 *
 */

var assert = require('assert');

module.exports = function() {
};

module.exports.prototype = {

    configure: function(options) {
        if (typeof options !== 'object') {
            assert(
                options === true,
                this.getOptionName() + ' option requires true value or an object'
            );
            var _options = {allExcept: []};
            return this.configure(_options);
        }

        assert(
            Array.isArray(options.allExcept),
            ' property `allExcept` in ' + this.getOptionName() + ' should be an array of strings'
        );
        this._exceptTrailingCommas = options.allExcept.indexOf('trailing') >= 0;
    },

    getOptionName: function() {
        return 'requireSpaceAfterComma';
    },

    check: function(file, errors) {
        var exceptTrailingCommas = this._exceptTrailingCommas;
        file.iterateTokensByTypeAndValue('Punctuator', ',', function(token) {
            if (exceptTrailingCommas && [']', '}'].indexOf(file.getNextToken(token).value) >= 0) {
                return;
            }
            errors.assert.whitespaceBetween({
                token: token,
                nextToken: file.getNextToken(token),
                message: 'Space required after comma'
            });
        });
    }

};

},{"assert":171}],123:[function(require,module,exports){
/**
 * Requires space after keyword.
 *
 * Types: `Array` or `Boolean`
 *
 * Values: Array of quoted keywords or `true` to require all of the keywords below to have a space afterward.
 *
 * #### Example
 *
 * ```js
 * "requireSpaceAfterKeywords": [
 *     "do",
 *     "for",
 *     "if",
 *     "else",
 *     "switch",
 *     "case",
 *     "try",
 *     "catch",
 *     "void",
 *     "while",
 *     "with",
 *     "return",
 *     "typeof",
 *     "function"
 * ]
 * ```
 *
 * ##### Valid
 *
 * ```js
 * if (x) {
 *     x++;
 * }
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * if(x) {
 *     x++;
 * }
 * ```
 */

var assert = require('assert');

var defaultKeywords = require('../utils').spacedKeywords;

module.exports = function() {};

module.exports.prototype = {

    configure: function(keywords) {
        assert(
            Array.isArray(keywords) || keywords === true,
            this.getOptionName() + ' option requires array or true value');

        if (keywords === true) {
            keywords = defaultKeywords;
        }

        this._keywords = keywords;
    },

    getOptionName: function() {
        return 'requireSpaceAfterKeywords';
    },

    check: function(file, errors) {
        file.iterateTokensByTypeAndValue('Keyword', this._keywords, function(token) {
            var nextToken = file.getNextToken(token, {includeComments: true});

            if (nextToken.type === 'Punctuator' && nextToken.value === ';') {
                return;
            }

            errors.assert.spacesBetween({
                token: token,
                nextToken: nextToken,
                exactly: 1,
                message: 'One space required after "' + token.value + '" keyword'
            });
        });
    }

};

},{"../utils":166,"assert":171}],124:[function(require,module,exports){
/**
 * Requires that a line comment (`//`) be followed by a space.
 *
 * Types: `Boolean`, `Object` or `String`
 *
 * Values:
 *  - `true`
 *  - `"allowSlash"` (*deprecated* use `"allExcept": ["/"]`) allows `/// ` format
 *  - `Object`:
 *     - `allExcept`: array of allowed strings before space `//(here) `
 *
 * #### Example
 *
 * ```js
 * "requireSpaceAfterLineComment": { "allExcept": ["#", "="] }
 * ```
 *
 * ##### Valid
 *
 * ```js
 * // A comment
 * /*A comment*\/
 * //# sourceURL=filename.js
 * //= require something
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * //A comment
 * ```
 */

var assert = require('assert');

module.exports = function() {};

module.exports.prototype = {

    configure: function(options) {
        assert(
            options === true ||
            options === 'allowSlash' ||
            typeof options === 'object',
            this.getOptionName() + ' option requires a true value ' +
            'or an object with String[] `allExcept` property'
        );

        // verify first item in `allExcept` property in object (if it's an object)
        assert(
            typeof options !== 'object' ||
            Array.isArray(options.allExcept) &&
            typeof options.allExcept[0] === 'string',
            'Property `allExcept` in ' + this.getOptionName() + ' should be an array of strings'
        );

        // don't check triple slashed comments, microsoft js doc convention. see #593
        // exceptions. see #592
        // need to drop allowSlash support in 2.0. Fixes #697
        this._allExcept = options === 'allowSlash' ? ['/'] :
            options.allExcept || [];
    },

    getOptionName: function() {
        return 'requireSpaceAfterLineComment';
    },

    check: function(file, errors) {
        var allExcept = this._allExcept;

        file.iterateTokensByType('Line', function(comment) {
            var value = comment.value;

            // cutout exceptions
            allExcept.forEach(function(el) {
                if (value.indexOf(el) === 0) {
                    value = value.substr(el.length);
                }
            });

            if (value.length === 0) {
                return;
            }

            if (value[0] !== ' ') {
                errors.add('Missing space after line comment', comment.loc.start);
            }
        });
    }
};

},{"assert":171}],125:[function(require,module,exports){
/**
 * Requires space after object keys.
 *
 * Type: `Boolean`
 *
 * Value: `true`
 *
 * #### Example
 *
 * ```js
 * "requireSpaceAfterObjectKeys": true
 * ```
 *
 * ##### Valid
 * ```js
 * var x = {a : 1};
 * ```
 * ##### Invalid
 * ```js
 * var x = {a: 1};
 * ```
 */

var assert = require('assert');

module.exports = function() {};

module.exports.prototype = {

    configure: function(options) {
        assert(
            options === true,
            this.getOptionName() + ' option requires a true value or should be removed'
        );
    },

    getOptionName: function() {
        return 'requireSpaceAfterObjectKeys';
    },

    check: function(file, errors) {
        file.iterateNodesByType('ObjectExpression', function(node) {
            node.properties.forEach(function(property) {
                if (property.shorthand || property.kind !== 'init' ||
                    node.type === 'SpreadProperty') {
                    return;
                }

                var token = file.getLastNodeToken(property.key);

                if (property.computed === true) {
                    token = file.getNextToken(token);
                }

                errors.assert.whitespaceBetween({
                    token: token,
                    nextToken: file.getNextToken(token),
                    message: 'Missing space after key'
                });
            });
        });
    }

};

},{"assert":171}],126:[function(require,module,exports){
/**
 * Disallows sticking unary operators to the right.
 *
 * Types: `Array` or `Boolean`
 *
 * Values: Array of quoted operators or `true` to require space after prefix for all unary operators
 *
 * #### Example
 *
 * ```js
 * "requireSpaceAfterPrefixUnaryOperators": ["++", "--", "+", "-", "~", "!"]
 * ```
 *
 * ##### Valid
 *
 * ```js
 * x = ! y; y = ++ z;
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * x = !y; y = ++z;
 * ```
 */

var assert = require('assert');
var defaultOperators = require('../utils').unaryOperators;

module.exports = function() {};

module.exports.prototype = {

    configure: function(operators) {
        var isTrue = operators === true;

        assert(
            Array.isArray(operators) || isTrue,
            this.getOptionName() + ' option requires array or true value'
        );

        if (isTrue) {
            operators = defaultOperators;
        }

        this._operatorIndex = {};
        for (var i = 0, l = operators.length; i < l; i++) {
            this._operatorIndex[operators[i]] = true;
        }
    },

    getOptionName: function() {
        return 'requireSpaceAfterPrefixUnaryOperators';
    },

    check: function(file, errors) {
        var operatorIndex = this._operatorIndex;

        file.iterateNodesByType(['UnaryExpression', 'UpdateExpression'], function(node) {
            // Check "node.prefix" for prefix type of (inc|dec)rement
            if (node.prefix && operatorIndex[node.operator]) {
                var argument = node.argument.type;
                var operatorToken = file.getFirstNodeToken(node);
                var nextToken = file.getNextToken(operatorToken);

                // Do not report consecutive operators (#405)
                if (
                    argument === 'UnaryExpression' || argument === 'UpdateExpression' &&
                    nextToken.value !== '('
                ) {
                    return;
                }

                errors.assert.whitespaceBetween({
                    token: operatorToken,
                    nextToken: nextToken,
                    message: 'Operator ' + node.operator + ' should not stick to operand'
                });
            }
        });
    }
};

},{"../utils":166,"assert":171}],127:[function(require,module,exports){
/**
 * Disallows sticking binary operators to the left.
 *
 * Types: `Array` or `Boolean`
 *
 * Values: Array of quoted operators or `true` to require space before all possible binary operators
 * without comma operator, since it's rarely used with this rule
 *
 *
 * #### Example
 *
 * ```js
 * "requireSpaceBeforeBinaryOperators": [
 *     "=",
 *     ",",
 *     "+",
 *     "-",
 *     "/",
 *     "*",
 *     "==",
 *     "===",
 *     "!=",
 *     "!=="
 *     // etc
 * ]
 * ```
 *
 * ##### Valid
 *
 * ```js
 * x !== y;
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * x!== y;
 * ```
 */

var assert = require('assert');
var allOperators = require('../../lib/utils').binaryOperators.filter(function(operator) {
    return operator !== ',';
});

module.exports = function() {};

module.exports.prototype = {

    configure: function(operators) {
        var isTrue = operators === true;

        assert(
            Array.isArray(operators) || isTrue,
            this.getOptionName() + ' option requires array or true value'
        );

        if (isTrue) {
            operators = allOperators;
        }

        this._operatorIndex = {};
        for (var i = 0, l = operators.length; i < l; i++) {
            this._operatorIndex[operators[i]] = true;
        }
    },

    getOptionName: function() {
        return 'requireSpaceBeforeBinaryOperators';
    },

    check: function(file, errors) {
        var operators = this._operatorIndex;

        // Comma
        if (operators[',']) {
            file.iterateTokensByTypeAndValue('Punctuator', ',', function(token) {
                errors.assert.whitespaceBetween({
                    token: file.getPrevToken(token),
                    nextToken: token,
                    message: 'Operator , should not stick to preceding expression'
                });
            });
        }

        // For everything else
        file.iterateNodesByType(
            ['BinaryExpression', 'AssignmentExpression', 'VariableDeclarator', 'LogicalExpression'],
            function(node) {
                var operator;
                var expression;

                if (node.type === 'VariableDeclarator') {
                    expression = node.init;
                    operator = '=';
                } else {
                    operator = node.operator;
                    expression = node.right;
                }

                if (expression === null) {
                    return;
                }

                var operatorToken = file.findPrevOperatorToken(
                    file.getFirstNodeToken(expression),
                    operator
                );

                var prevToken = file.getPrevToken(operatorToken);

                if (operators[operator]) {
                    errors.assert.whitespaceBetween({
                        token: prevToken,
                        nextToken: operatorToken,
                        message: 'Operator ' + operator + ' should not stick to preceding expression'
                    });
                }
            }
        );
    }

};

},{"../../lib/utils":166,"assert":171}],128:[function(require,module,exports){
/**
 * Requires space(s) before block statements (for loops, control structures).
 *
 * Type: `Boolean` or `Integer`
 *
 * Values:
 *
 * - `true` require *at least* a single space
 * - `Integer` require *at least* specified number of spaces
 *
 * #### Example
 *
 * ```js
 * "requireSpaceBeforeBlockStatements": 1
 * ```
 *
 * ##### Valid
 *
 * ```js
 * if (cond) {
 *     foo();
 * } else {
 *     bar();
 * }
 *
 * for (var e in elements) {
 *     bar(e);
 * }
 *
 * while (cond) {
 *     foo();
 * }
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * if (cond){
 *     foo();
 * } else{
 *     bar();
 * }
 *
 * for (var e in elements){
 *     bar(e);
 * }
 *
 * while (cond){
 *     foo();
 * }
 * ```
 */

var assert = require('assert');

module.exports = function() {};

module.exports.prototype = {
    configure: function(requireSpaceBeforeBlockStatements) {
        assert(
            typeof requireSpaceBeforeBlockStatements === 'boolean' ||
            typeof requireSpaceBeforeBlockStatements === 'number',
            this.getOptionName() + ' option requires number or bolean'
        );
        assert(
            requireSpaceBeforeBlockStatements >= 1,
            this.getOptionName() +
              ' option requires true value or a number greater than equal to 1 or should be removed'
        );
        this._count = +requireSpaceBeforeBlockStatements;
    },

    getOptionName: function() {
        return 'requireSpaceBeforeBlockStatements';
    },

    check: function(file, errors) {
        var count = this._count;
        file.iterateNodesByType('BlockStatement', function(node) {
            var first = file.getFirstNodeToken(node);

            errors.assert.spacesBetween({
                token: file.getPrevToken(first),
                nextToken: first,
                atLeast: count,
                disallowNewLine: true,
                message: 'One (or more) spaces required before opening brace for block expressions'
            });
        });
    }

};

},{"assert":171}],129:[function(require,module,exports){
/**
 * Requires space before comma
 *
 * Types: `Boolean`
 *
 * Values: `true` to require a space before any comma
 *
 * #### Example
 *
 * ```js
 * "requireSpaceBeforeComma": true
 * ```
 *
 * ##### Valid
 *
 * ```js
 * var a ,b;
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * var a,b;
 * ```
 */

var assert = require('assert');

module.exports = function() {
};

module.exports.prototype = {

    configure: function(option) {
        assert(
            option === true,
            this.getOptionName() + ' option requires true value'
        );
    },

    getOptionName: function() {
        return 'requireSpaceBeforeComma';
    },

    check: function(file, errors) {
        file.iterateTokensByTypeAndValue('Punctuator', ',', function(token) {
            var prevToken = file.getPrevToken(token);

            errors.assert.whitespaceBetween({
                token: prevToken,
                nextToken: token,
                message: 'Space required before comma'
            });
        });
    }

};

},{"assert":171}],130:[function(require,module,exports){
/**
 * Requires space before keyword.
 *
 * Types: `Array` or `Boolean`
 *
 * Values: Array of quoted keywords or `true` to require all possible keywords to have a preceding space.
 *
 * #### Example
 *
 * ```js
 * "requireSpaceBeforeKeywords": [
 *     "else",
 *     "while",
 *     "catch"
 * ]
 * ```
 *
 * ##### Valid
 *
 * ```js
 * } else {
 *     x++;
 * }
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * }else {
 *     x++;
 * }
 * ```
 */

var assert = require('assert');

var defaultKeywords = require('../utils').spacedKeywords;

module.exports = function() {};

module.exports.prototype = {

    configure: function(keywords) {
        assert(
            Array.isArray(keywords) || keywords === true,
            this.getOptionName() + ' option requires array or true value');

        if (keywords === true) {
            keywords = defaultKeywords;
        }

        this._keywords = keywords;
    },

    getOptionName: function() {
        return 'requireSpaceBeforeKeywords';
    },

    check: function(file, errors) {
        file.iterateTokensByTypeAndValue('Keyword', this._keywords, function(token) {
            var prevToken = file.getPrevToken(token, {includeComments: true});
            if (!prevToken || prevToken.isComment) {
                return;
            }

            if (prevToken.type !== 'Punctuator' || prevToken.value !== ';') {
                errors.assert.whitespaceBetween({
                    token: prevToken,
                    nextToken: token,
                    message: 'Missing space before "' + token.value + '" keyword'
                });
            }
        });
    }

};

},{"../utils":166,"assert":171}],131:[function(require,module,exports){
/**
 * Requires space after object keys.
 *
 * Type: `Boolean`
 *
 * Value: `true`
 *
 * #### Example
 *
 * ```js
 * "requireSpaceBeforeObjectValues": true
 * ```
 *
 * ##### Valid
 * ```js
 * var x = {a: 1};
 * ```
 * ##### Invalid
 * ```js
 * var x = {a:1};
 * ```
 */

var assert = require('assert');

module.exports = function() {};

module.exports.prototype = {

    configure: function(options) {
        assert(
            options === true,
            this.getOptionName() + ' option requires a true value or should be removed'
        );
    },

    getOptionName: function() {
        return 'requireSpaceBeforeObjectValues';
    },

    check: function(file, errors) {
        file.iterateNodesByType('ObjectExpression', function(node) {
            node.properties.forEach(function(property) {
                if (property.shorthand || property.method || property.kind !== 'init' ||
                    node.type === 'SpreadProperty') {
                    return;
                }

                var keyToken = file.getFirstNodeToken(property.key);

                var colon = file.findNextToken(keyToken, 'Punctuator', ':');

                errors.assert.whitespaceBetween({
                    token: colon,
                    nextToken: file.getNextToken(colon),
                    message: 'Missing space after key colon'
                });
            });
        });
    }

};

},{"assert":171}],132:[function(require,module,exports){
/**
 * Disallows sticking unary operators to the left.
 *
 * Types: `Array` or `Boolean`
 *
 * Values: Array of quoted operators or `true` to require space before postfix for all unary operators
 * (i.e. increment/decrement operators).
 *
 * #### Example
 *
 * ```js
 * "requireSpaceBeforePostfixUnaryOperators": ["++", "--"]
 * ```
 *
 * ##### Valid
 *
 * ```js
 * x = y ++; y = z --;
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * x = y++; y = z--;
 * ```
 */

var assert = require('assert');
var defaultOperators = require('../utils').incrementAndDecrementOperators;

module.exports = function() {};

module.exports.prototype = {

    configure: function(operators) {
        var isTrue = operators === true;

        assert(
            Array.isArray(operators) || isTrue,
            this.getOptionName() + ' option requires array or true value'
        );

        if (isTrue) {
            operators = defaultOperators;
        }

        this._operatorIndex = {};
        for (var i = 0, l = operators.length; i < l; i++) {
            this._operatorIndex[operators[i]] = true;
        }
    },

    getOptionName: function() {
        return 'requireSpaceBeforePostfixUnaryOperators';
    },

    check: function(file, errors) {
        var operatorIndex = this._operatorIndex;

        // 'UpdateExpression' involve only ++ and -- operators
        file.iterateNodesByType('UpdateExpression', function(node) {
            // "!node.prefix" means postfix type of (inc|dec)rement
            if (!node.prefix && operatorIndex[node.operator]) {
                var operatorToken = file.getLastNodeToken(node);

                errors.assert.whitespaceBetween({
                    token: file.getPrevToken(operatorToken),
                    nextToken: operatorToken,
                    message: 'Operator ' + node.operator + ' should not stick to operand'
                });
            }
        });
    }
};

},{"../utils":166,"assert":171}],133:[function(require,module,exports){
/**
 * Ensure there are spaces after argument separators in call expressions.
 *
 * Type: `Boolean`
 *
 * Value: `true`
 *
 * #### Example
 *
 * ```js
 * "requireSpaceBetweenArguments": true
 * ```
 *
 * ##### Valid
 *
 * ```js
 * a(b, c);
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * a(b,c);
 * ```
 */

var assert = require('assert');

module.exports = function() {};

module.exports.prototype = {

    configure: function(options) {
        assert(
            options === true,
            this.getOptionName() + ' option requires a true value or should be removed'
        );
    },

    getOptionName: function() {
        return 'requireSpaceBetweenArguments';
    },

    check: function(file, errors) {
        file.iterateNodesByType(['CallExpression'], function(node) {
            node.arguments.forEach(function(param) {
                var punctuatorToken = file.getPrevToken(file.getFirstNodeToken(param));
                if (punctuatorToken.value === ',') {
                    errors.assert.whitespaceBetween({
                        token: punctuatorToken,
                        nextToken: file.getNextToken(punctuatorToken)
                    });
                }
            });
        });
    }
};

},{"assert":171}],134:[function(require,module,exports){
/**
 * Requires space before `()` or `{}` in anonymous function expressions.
 *
 * Type: `Object`
 *
 * Values:
 *  - `Object` with the following properties. One of `"beforeOpeningRoundBrace"`
 *    and `"beforeOpeningCurlyBrace"` must be provided:
 *      - `"beforeOpeningRoundBrace"` validates that there is a space before
 *        the opening round brace `()`. If provided, it must be set to `true`.
 *      - `"beforeOpeningCurlyBrace"` validates that there is a space before
 *        the opening curly brace `{}`. If provided, it must be set to `true`.
 *      - `"allExcept"` may be an Array containing `"shorthand"`, or
 *        the Boolean `true` to enable all configuration exceptions. If
 *        `"shorthand"` is provided, spaces will not be required for
 *        ES6 method definitions.
 *
 * #### Example
 *
 * ```js
 * "requireSpacesInAnonymousFunctionExpression": {
 *     "beforeOpeningRoundBrace": true,
 *     "beforeOpeningCurlyBrace": true
 * }
 * ```
 *
 * ##### Valid
 *
 * ```js
 * var foo = function () {};
 * var Foo = {
 *     foo: function () {}
 * }
 * array.map(function () {});
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * var foo = function() {};
 * var Foo = {
 *     foo: function (){}
 * }
 * array.map(function(){});
 * ```
 */

var assert = require('assert');

module.exports = function() {};

module.exports.prototype = {
    configure: function(options) {
        this._exceptions = {
            'shorthand': false
        };

        assert(
            typeof options === 'object',
            this.getOptionName() + ' option must be the object'
        );

        if ('beforeOpeningRoundBrace' in options) {
            assert(
                options.beforeOpeningRoundBrace === true,
                this.getOptionName() + '.beforeOpeningRoundBrace ' +
                'property requires true value or should be removed'
            );
        }

        if ('beforeOpeningCurlyBrace' in options) {
            assert(
                options.beforeOpeningCurlyBrace === true,
                this.getOptionName() + '.beforeOpeningCurlyBrace ' +
                'property requires true value or should be removed'
            );
        }

        if ('allExcept' in options) {
            if (typeof options.allExcept === 'object') {
                assert(
                    Array.isArray(options.allExcept),
                    this.getOptionName() + ' option requires "allExcept" to be ' +
                    'an array'
                );
                assert(
                    options.allExcept.length > 0,
                    this.getOptionName() + ' option requires "allExcept" to have ' +
                    'at least one item or be set to `true`'
                );
                options.allExcept.forEach(function(except) {
                    if (except === 'shorthand') {
                        this._exceptions.shorthand = true;
                    } else {
                        assert(false, this.getOptionName() + ' option requires ' +
                        '"allExcept" to be an array containing "shorthand"');
                    }
                }, this);
            } else {
                assert(
                    options.allExcept === true,
                    this.getOptionName() + ' option requires a true value or array'
                );
                this._exceptions.shorthand = true;
            }
        }

        assert(
            options.beforeOpeningCurlyBrace || options.beforeOpeningRoundBrace,
            this.getOptionName() + ' must have beforeOpeningCurlyBrace ' +
            ' or beforeOpeningRoundBrace property'
        );

        this._beforeOpeningRoundBrace = Boolean(options.beforeOpeningRoundBrace);
        this._beforeOpeningCurlyBrace = Boolean(options.beforeOpeningCurlyBrace);
    },

    getOptionName: function() {
        return 'requireSpacesInAnonymousFunctionExpression';
    },

    check: function(file, errors) {
        var beforeOpeningRoundBrace = this._beforeOpeningRoundBrace;
        var beforeOpeningCurlyBrace = this._beforeOpeningCurlyBrace;
        var exceptions = this._exceptions;

        file.iterateNodesByType(['FunctionExpression'], function(node) {
            var functionNode = node;
            var parent = node.parentNode;

            // Ignore syntactic sugar for getters and setters.
            if (parent.type === 'Property' && (parent.kind === 'get' || parent.kind === 'set')) {
                return;
            }

            // shorthand or constructor methods
            if (parent.method || parent.type === 'MethodDefinition') {
                functionNode = parent.key;
                if (exceptions.shorthand) {
                    return;
                }
            }

            // anonymous function expressions only
            if (node.id) {
                return;
            }

            if (beforeOpeningRoundBrace) {
                var functionToken = file.getFirstNodeToken(functionNode);
                if (node.async && functionToken.value === 'async') {
                    functionToken = file.getNextToken(functionToken);
                }
                // if generator, set token to be * instead
                if (node.generator && functionToken.value === 'function') {
                    functionToken = file.getNextToken(functionToken);
                }
                errors.assert.whitespaceBetween({
                    token: functionToken,
                    nextToken: file.getNextToken(functionToken),
                    message: 'Missing space before opening round brace'
                });
            }

            if (beforeOpeningCurlyBrace) {
                var bodyToken = file.getFirstNodeToken(node.body);
                errors.assert.whitespaceBetween({
                    token: file.getPrevToken(bodyToken),
                    nextToken: bodyToken,
                    message: 'Missing space before opening curly brace'
                });
            }
        });
    }

};

},{"assert":171}],135:[function(require,module,exports){
/**
 * Requires space before `()` in call expressions.
 *
 * Type: `Boolean`
 *
 * Value: `true`
 *
 * #### Example
 *
 * ```js
 * "requireSpacesInCallExpression": true
 * ```
 *
 * ##### Valid
 *
 * ```js
 * var x = foobar ();
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * var x = foobar();
 * ```
 */

var assert = require('assert');

module.exports = function() {};

module.exports.prototype = {
    configure: function(options) {
        assert(
            options === true,
            this.getOptionName() + ' option requires a true value or should be removed'
        );
    },

    getOptionName: function() {
        return 'requireSpacesInCallExpression';
    },

    check: function(file, errors) {
        file.iterateNodesByType('CallExpression', function(node) {
            var lastCalleeToken = file.getLastNodeToken(node.callee);
            var roundBraceToken = file.findNextToken(lastCalleeToken, 'Punctuator', '(');

            errors.assert.whitespaceBetween({
                token: file.getPrevToken(roundBraceToken),
                nextToken: roundBraceToken,
                message: 'Missing space before opening round brace'
            });
        });
    }
};

},{"assert":171}],136:[function(require,module,exports){
/**
 * Requires space before and/or after `?` or `:` in conditional expressions.
 *
 * Types: `Object` or `Boolean`
 *
 * Values: `"afterTest"`, `"beforeConsequent"`, `"afterConsequent"`, `"beforeAlternate"` as child properties,
 * or `true` to set all properties to `true`. Child properties must be set to `true`.
 *
 * #### Example
 *
 * ```js
 * "requireSpacesInConditionalExpression": {
 *     "afterTest": true,
 *     "beforeConsequent": true,
 *     "afterConsequent": true,
 *     "beforeAlternate": true
 * }
 * ```
 *
 * ##### Valid
 *
 * ```js
 * var a = b ? c : d;
 * var a= b ? c : d;
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * var a = b? c : d;
 * var a = b ?c : d;
 * var a = b ? c: d;
 * var a = b ? c :d;
 * ```
 */

var assert = require('assert');

module.exports = function() {};

module.exports.prototype = {
    configure: function(options) {
        var validProperties = [
            'afterTest',
            'beforeConsequent',
            'afterConsequent',
            'beforeAlternate'
        ];
        var optionName = this.getOptionName();

        if (options === true) {
            options = {
                'afterTest': true,
                'beforeConsequent': true,
                'afterConsequent': true,
                'beforeAlternate': true
            };
        }

        assert(
            typeof options === 'object',
            optionName + ' option requires a true value or an object'
        );

        var isProperlyConfigured = validProperties.some(function(key) {
            var isPresent = key in options;

            if (isPresent) {
                assert(
                    options[key] === true,
                    optionName + '.' + key + ' property requires true value or should be removed'
                );
            }

            return isPresent;
        });

        assert(
            isProperlyConfigured,
            optionName + ' must have at least 1 of the following properties: ' + validProperties.join(', ')
        );

        validProperties.forEach(function(property) {
            this['_' + property] = Boolean(options[property]);
        }.bind(this));
    },

    getOptionName: function() {
        return 'requireSpacesInConditionalExpression';
    },

    check: function(file, errors) {
        file.iterateNodesByType(['ConditionalExpression'], function(node) {
            var consequent = node.consequent;
            var alternate = node.alternate;
            var consequentToken = file.getFirstNodeToken(consequent);
            var alternateToken = file.getFirstNodeToken(alternate);
            var questionMarkToken = file.findPrevOperatorToken(consequentToken, '?');
            var colonToken = file.findPrevOperatorToken(alternateToken, ':');
            var token;

            if (this._afterTest) {
                token = file.getPrevToken(questionMarkToken);
                errors.assert.whitespaceBetween({
                    token: token,
                    nextToken: questionMarkToken,
                    message: 'Missing space after test'
                });
            }

            if (this._beforeConsequent) {
                token = file.getNextToken(questionMarkToken);
                errors.assert.whitespaceBetween({
                    token: questionMarkToken,
                    nextToken: token,
                    message: 'Missing space before consequent'
                });
            }

            if (this._afterConsequent) {
                token = file.getPrevToken(colonToken);
                errors.assert.whitespaceBetween({
                    token: token,
                    nextToken: colonToken,
                    message: 'Missing space after consequent'
                });
            }

            if (this._beforeAlternate) {
                token = file.getNextToken(colonToken);
                errors.assert.whitespaceBetween({
                    token: colonToken,
                    nextToken: token,
                    message: 'Missing space before alternate'
                });
            }
        }.bind(this));
    }

};

},{"assert":171}],137:[function(require,module,exports){
/**
 * Requires spaces inbetween for statement.
 *
 * Type: `Boolean`
 *
 * Value: `true` to requires spaces inbetween for statement.
 *
 * #### Example
 *
 * ```js
 * "requireSpacesInForStatement": true
 * ```
 *
 * ##### Valid
 *
 * ```js
 * for(var i = 0; i<l; i++) {
 *     x++;
 * }
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * for(var i = 0;i<l;i++) {
 *     x++;
 * }
 * ```
 *
 * ```js
 * for(var i = 0; i<l;i++) {
 *     x++;
 * }
 * ```
 *
 * ```js
 * for(var i = 0;i<l; i++) {
 *     x++;
 * }
 * ```
 */

var assert = require('assert');
var TokenCategorizer = require('../token-categorizer');

module.exports = function() {};

module.exports.prototype = {
    configure: function(options) {
        assert(
            options === true,
            this.getOptionName() + ' option requires a true value or should be removed'
        );
    },

    getOptionName: function() {
        return 'requireSpacesInForStatement';
    },

    check: function(file, errors) {
        file.iterateNodesByType('ForStatement', function(node) {
            if (node.test) {
                var testToken = file.getFirstNodeToken(node.test);
                var prevToken = file.getPrevToken(testToken);

                if (prevToken.value === '(' &&
                    TokenCategorizer.categorizeOpenParen(prevToken, file) === 'ParenthesizedExpression') {
                    testToken = prevToken;
                    prevToken = file.getPrevToken(prevToken);
                }
                errors.assert.spacesBetween({
                    token: prevToken,
                    nextToken: testToken,
                    exactly: 1,
                    message: 'One space required after semicolon'
                });
            }
            if (node.update) {
                var updateToken = file.getFirstNodeToken(node.update);
                errors.assert.spacesBetween({
                    token: file.getPrevToken(updateToken),
                    nextToken: updateToken,
                    exactly: 1,
                    message: 'One space required after semicolon'
                });
            }
        });
    }
};

},{"../token-categorizer":164,"assert":171}],138:[function(require,module,exports){
/**
 * Requires space before `()` or `{}` in function declarations.
 *
 * Type: `Object`
 *
 * Values: `"beforeOpeningRoundBrace"` and `"beforeOpeningCurlyBrace"` as child properties.
 * Child properties must be set to `true`.
 *
 * #### Example
 *
 * ```js
 * "requireSpacesInFunctionDeclaration": {
 *     "beforeOpeningRoundBrace": true,
 *     "beforeOpeningCurlyBrace": true
 * }
 * ```
 *
 * ##### Valid
 *
 * ```js
 * function a () {}
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * function a() {}
 * function a (){}
 * function a(){}
 * ```
 */

var assert = require('assert');

module.exports = function() {};

module.exports.prototype = {
    configure: function(options) {
        assert(
            typeof options === 'object',
            this.getOptionName() + ' option must be the object'
        );

        if ('beforeOpeningRoundBrace' in options) {
            assert(
                options.beforeOpeningRoundBrace === true,
                this.getOptionName() + '.beforeOpeningRoundBrace ' +
                'property requires true value or should be removed'
            );
        }

        if ('beforeOpeningCurlyBrace' in options) {
            assert(
                options.beforeOpeningCurlyBrace === true,
                this.getOptionName() + '.beforeOpeningCurlyBrace ' +
                'property requires true value or should be removed'
            );
        }

        assert(
            options.beforeOpeningCurlyBrace || options.beforeOpeningRoundBrace,
            this.getOptionName() + ' must have beforeOpeningCurlyBrace or beforeOpeningRoundBrace property'
        );

        this._beforeOpeningRoundBrace = Boolean(options.beforeOpeningRoundBrace);
        this._beforeOpeningCurlyBrace = Boolean(options.beforeOpeningCurlyBrace);
    },

    getOptionName: function() {
        return 'requireSpacesInFunctionDeclaration';
    },

    check: function(file, errors) {
        var beforeOpeningRoundBrace = this._beforeOpeningRoundBrace;
        var beforeOpeningCurlyBrace = this._beforeOpeningCurlyBrace;

        file.iterateNodesByType(['FunctionDeclaration'], function(node) {
            // Exception for `export default function` #1376
            if (!node.id) {
                return;
            }

            if (beforeOpeningRoundBrace) {
                // for a named function, use node.id
                var functionToken = file.getFirstNodeToken(node.id || node);
                if (node.async && functionToken.value === 'async') {
                    functionToken = file.getNextToken(functionToken);
                }
                // if generator, set token to be * instead
                if (node.generator && functionToken.value === 'function') {
                    functionToken = file.getNextToken(functionToken);
                }
                errors.assert.whitespaceBetween({
                    token: functionToken,
                    nextToken: file.getNextToken(functionToken),
                    message: 'Missing space before opening round brace'
                });
            }

            if (beforeOpeningCurlyBrace) {
                var bodyToken = file.getFirstNodeToken(node.body);
                errors.assert.whitespaceBetween({
                    token: file.getPrevToken(bodyToken),
                    nextToken: bodyToken,
                    message: 'Missing space before opening curly brace'
                });
            }
        });
    }

};

},{"assert":171}],139:[function(require,module,exports){
/**
 * Requires space before `()` or `{}` in function expressions (both [named](#requirespacesinnamedfunctionexpression)
 * and [anonymous](#requirespacesinanonymousfunctionexpression)).
 *
 * Type: `Object`
 *
 * Values: `"beforeOpeningRoundBrace"` and `"beforeOpeningCurlyBrace"` as child properties.
 * Child properties must be set to `true`.
 *
 * #### Example
 *
 * ```js
 * "requireSpacesInFunctionExpression": {
 *     "beforeOpeningRoundBrace": true,
 *     "beforeOpeningCurlyBrace": true
 * }
 * ```
 *
 * ##### Valid
 *
 * ```js
 * var x = function () {};
 * var x = function a () {};
 * var x = async function () {};
 * var x = async function a () {};
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * var x = function() {};
 * var x = function (){};
 * var x = function(){};
 * var x = function a() {};
 * var x = function a (){};
 * var x = function a(){};
 * var x = function async a() {};
 * var x = function async a (){};
 * var x = function async a(){};
 * ```
 */

var assert = require('assert');

module.exports = function() {};

module.exports.prototype = {
    configure: function(options) {
        assert(
            typeof options === 'object',
            this.getOptionName() + ' option must be the object'
        );

        if ('beforeOpeningRoundBrace' in options) {
            assert(
                options.beforeOpeningRoundBrace === true,
                this.getOptionName() + '.beforeOpeningRoundBrace ' +
                'property requires true value or should be removed'
            );
        }

        if ('beforeOpeningCurlyBrace' in options) {
            assert(
                options.beforeOpeningCurlyBrace === true,
                this.getOptionName() + '.beforeOpeningCurlyBrace ' +
                'property requires true value or should be removed'
            );
        }

        assert(
            options.beforeOpeningCurlyBrace || options.beforeOpeningRoundBrace,
            this.getOptionName() + ' must have beforeOpeningCurlyBrace or beforeOpeningRoundBrace property'
        );

        this._beforeOpeningRoundBrace = Boolean(options.beforeOpeningRoundBrace);
        this._beforeOpeningCurlyBrace = Boolean(options.beforeOpeningCurlyBrace);
    },

    getOptionName: function() {
        return 'requireSpacesInFunctionExpression';
    },

    check: function(file, errors) {
        var beforeOpeningRoundBrace = this._beforeOpeningRoundBrace;
        var beforeOpeningCurlyBrace = this._beforeOpeningCurlyBrace;

        file.iterateNodesByType('FunctionExpression', function(node) {
            // for a named function, use node.id
            var functionNode = node.id || node;
            var parent = node.parentNode;

            // Ignore syntactic sugar for getters and setters.
            if (parent.type === 'Property' && (parent.kind === 'get' || parent.kind === 'set')) {
                return;
            }

            // shorthand or constructor methods
            if (parent.method || parent.type === 'MethodDefinition') {
                functionNode = parent.key;
            }

            if (beforeOpeningRoundBrace) {
                var functionToken = file.getFirstNodeToken(functionNode);
                if (node.async && functionToken.value === 'async') {
                    functionToken = file.getNextToken(functionToken);
                }
                // if generator, set token to be * instead
                if (node.generator && functionToken.value === 'function') {
                    functionToken = file.getNextToken(functionToken);
                }
                errors.assert.whitespaceBetween({
                    token: functionToken,
                    nextToken: file.getNextToken(functionToken),
                    message: 'Missing space before opening round brace'
                });
            }

            if (beforeOpeningCurlyBrace) {
                var bodyToken = file.getFirstNodeToken(node.body);
                errors.assert.whitespaceBetween({
                    token: file.getPrevToken(bodyToken),
                    nextToken: bodyToken,
                    message: 'Missing space before opening curly brace'
                });
            }
        });
    }

};

},{"assert":171}],140:[function(require,module,exports){
/**
 * Requires space before `()` or `{}` in function expressions (both [named](#requirespacesinnamedfunctionexpression)
 * and [anonymous](#requirespacesinanonymousfunctionexpression)) and function declarations.
 *
 * Types: `Object`
 *
 *  - `Object` (at least one of properties must be present and it must be set to true):
 *      - `'beforeOpeningRoundBrace'`
 *          - `true` validates that there is a space before `()`
 *      - `'beforeOpeningCurlyBrace'`
 *          - `true` validates that there is a space before `{}`
 *
 * #### Example
 *
 * ```js
 * "requireSpacesInFunction": {
 *     "beforeOpeningRoundBrace": true,
 *     "beforeOpeningCurlyBrace": true
 * }
 * ```
 * ```js
 * "requireSpacesInFunction": {
 *     "beforeOpeningRoundBrace": true
 * }
 * ```
 * ```js
 * "requireSpacesInFunction": {
 *     "beforeOpeningCurlyBrace": true
 * }
 * ```
 *
 * ##### Valid for mode `{ "beforeOpeningRoundBrace": true, "beforeOpeningCurlyBrace": true }`
 *
 * ```js
 * var x = function () {};
 * var x = function a () {};
 * function a () {}
 * var x = async function () {};
 * var x = async function a () {};
 * async function a () {}
 * ```
 *
 * ##### Valid for mode `{ "beforeOpeningRoundBrace": true }`
 *
 * ```js
 * var x = function (){};
 * var x = function a (){};
 * function a (){}
 * var x = async function (){};
 * var x = async function a (){};
 * async function a (){}
 * ```
 *
 * ##### Valid for mode `{ "beforeOpeningCurlyBrace": true }`
 *
 * ```js
 * var x = function() {};
 * var x = function a() {};
 * function a() {}
 * var x = async function() {};
 * var x = async function a() {};
 * async function a() {}
 * ```
 *
 * ##### Invalid for mode `{ "beforeOpeningRoundBrace": true, "beforeOpeningCurlyBrace": true }`
 *
 * ```js
 * var x = function() {};
 * var x = function (){};
 * var x = function(){};
 * var x = function a() {};
 * var x = function a (){};
 * var x = function a(){};
 * function a() {}
 * function a (){}
 * function a(){}
 * var x = async function() {};
 * var x = async function (){};
 * var x = async function(){};
 * var x = async function a() {};
 * var x = async function a (){};
 * var x = async function a(){};
 * async function a() {}
 * async function a (){}
 * async function a(){}
 * ```
 */

var assert = require('assert');

module.exports = function() {};

module.exports.prototype = {
    configure: function(options) {
        assert(
            typeof options === 'object',
            this.getOptionName() + ' option must be the object'
        );

        if ('beforeOpeningRoundBrace' in options) {
            assert(
                options.beforeOpeningRoundBrace === true,
                this.getOptionName() + '.beforeOpeningRoundBrace ' +
                'property requires true value or should be removed'
            );
        }

        if ('beforeOpeningCurlyBrace' in options) {
            assert(
                options.beforeOpeningCurlyBrace === true,
                this.getOptionName() + '.beforeOpeningCurlyBrace ' +
                'property requires true value or should be removed'
            );
        }

        assert(
            options.beforeOpeningCurlyBrace || options.beforeOpeningRoundBrace,
            this.getOptionName() + ' must have beforeOpeningCurlyBrace or beforeOpeningRoundBrace property'
        );

        this._beforeOpeningRoundBrace = Boolean(options.beforeOpeningRoundBrace);
        this._beforeOpeningCurlyBrace = Boolean(options.beforeOpeningCurlyBrace);
    },

    getOptionName: function() {
        return 'requireSpacesInFunction';
    },

    check: function(file, errors) {
        var beforeOpeningRoundBrace = this._beforeOpeningRoundBrace;
        var beforeOpeningCurlyBrace = this._beforeOpeningCurlyBrace;

        file.iterateNodesByType(['FunctionDeclaration', 'FunctionExpression'], function(node) {
            // for a named function, use node.id
            var functionNode = node.id || node;
            var parent = node.parentNode;

            // Ignore syntactic sugar for getters and setters.
            if (parent.type === 'Property' && (parent.kind === 'get' || parent.kind === 'set')) {
                return;
            }

            // shorthand or constructor methods
            if (parent.method || parent.type === 'MethodDefinition') {
                functionNode = parent.key;
            }

            if (beforeOpeningRoundBrace) {
                var functionToken = file.getFirstNodeToken(functionNode);
                if (node.async && functionToken.value === 'async') {
                    functionToken = file.getNextToken(functionToken);
                }
                // if generator, set token to be * instead
                if (node.generator && functionToken.value === 'function') {
                    functionToken = file.getNextToken(functionToken);
                }
                errors.assert.whitespaceBetween({
                    token: functionToken,
                    nextToken: file.getNextToken(functionToken),
                    message: 'Missing space before opening round brace'
                });
            }

            if (beforeOpeningCurlyBrace) {
                var bodyToken = file.getFirstNodeToken(node.body);
                errors.assert.whitespaceBetween({
                    token: file.getPrevToken(bodyToken),
                    nextToken: bodyToken,
                    message: 'Missing space before opening curly brace'
                });
            }
        });
    }

};

},{"assert":171}],141:[function(require,module,exports){
/**
 * Requires space before and after `*` in generator functions
 *
 * Types: `Object`
 *
 *  - `Object` (at least one of properties must be present and it must be set to true):
 *      - `'beforeStar'`
 *          - `true` validates that there is a space before `*`
 *      - `'afterStar'`
 *          - `true` validates that there is a space after `*`
 *
 * #### Example
 *
 * ```js
 * "requireSpacesInGenerator": {
 *     "beforeStar": true,
 *     "afterStar": true
 * }
 * ```
 * ##### Valid for mode `{ "beforeStar": true, "afterStar": true }`
 *
 * ```js
 * var x = function * () {};
 * function * a() {};
 * var x = async function * () {};
 * var x = async function * a () {};
 * async function * a() {}
 * var x = async function * (){};
 * ```
 *
*/

var assert = require('assert');

module.exports = function() {};

module.exports.prototype = {
    configure: function(options) {
        assert(
            typeof options === 'object',
            this.getOptionName() + ' option must be an object'
        );

        if ('beforeStar' in options) {
            assert(
                options.beforeStar === true,
                this.getOptionName() + '.beforeStar ' +
                'property requires true value or should be removed'
            );
        }
        if ('afterStar' in options) {
            assert(
                options.afterStar === true,
                this.getOptionName() + '.afterStar ' +
                'property requires true value or should be removed'
            );
        }

        assert(
            options.beforeStar || options.afterStar,
            this.getOptionName() + ' must have beforeStar or afterStar property'
        );

        this._beforeStar = options.beforeStar;
        this._afterStar = options.afterStar;
    },

    getOptionName: function() {
        return 'requireSpacesInGenerator';
    },

    check: function(file, errors) {
        var beforeStar = this._beforeStar;
        var afterStar = this._afterStar;

        file.iterateNodesByType(['FunctionDeclaration', 'FunctionExpression'], function(node) {
            if (!node.generator) {
                return;
            }

            var parent = node.parentNode;
            var shorthand = false;

            // shorthand or constructor methods
            if (parent.method || parent.type === 'MethodDefinition') {
                shorthand = true;
                node = parent.key;
            }

            var currentToken = file.getFirstNodeToken(node);

            if (node.async && currentToken.value === 'async') {
                currentToken = file.getNextToken(currentToken);
            }

            if (beforeStar && !shorthand) {
                // currentToken assigned outside of function
                errors.assert.whitespaceBetween({
                    token: currentToken,
                    nextToken: file.getNextToken(currentToken),
                    message: 'Missing space before star'
                });
            }

            if (afterStar) {
                if (shorthand) {
                    currentToken = file.getPrevToken(currentToken);
                } else {
                    // currentToken reassigned for star token
                    currentToken = file.getNextToken(currentToken);
                }

                errors.assert.whitespaceBetween({
                    token: currentToken,
                    nextToken: file.getNextToken(currentToken),
                    message: 'Missing space after star'
                });
            }
        });
    }
};

},{"assert":171}],142:[function(require,module,exports){
/**
 * Requires space before `()` or `{}` in named function expressions.
 *
 * Types: `Object`
 *
 *  - `Object` (at least one of properties must be present and it must be set to true):
 *      - `'beforeOpeningRoundBrace'`
 *          - `true` validates that there is a space before `()`
 *      - `'beforeOpeningCurlyBrace'`
 *          - `true` validates that there is a space before `{}`
 *
 * #### Example
 *
 * ```js
 * "requireSpacesInNamedFunctionExpression": {
 *     "beforeOpeningRoundBrace": true,
 *     "beforeOpeningCurlyBrace": true
 * }
 * ```
 * ```js
 * "requireSpacesInNamedFunctionExpression": {
 *     "beforeOpeningRoundBrace": true
 * }
 * ```
 * ```js
 * "requireSpacesInNamedFunctionExpression": {
 *     "beforeOpeningCurlyBrace": true
 * }
 * ```
 *
 * ##### Valid for mode `{ "beforeOpeningRoundBrace": true, "beforeOpeningCurlyBrace": true }`
 *
 * ```js
 * var x = function a () {};
 * ```
 *
 * ##### Valid for mode `{ "beforeOpeningRoundBrace": true }`
 *
 * ```js
 * var x = function a (){};
 * ```
 *
 * ##### Valid for mode `{ "beforeOpeningCurlyBrace": true }`
 *
 * ```js
 * var x = function a() {};
 * ```
 *
 * ##### Invalid for mode `{ "beforeOpeningRoundBrace": true, "beforeOpeningCurlyBrace": true }`
 *
 * ```js
 * var x = function a() {};
 * var x = function a (){};
 * var x = function a(){};
 * ```
 */

var assert = require('assert');

module.exports = function() {};

module.exports.prototype = {
    configure: function(options) {
        assert(
            typeof options === 'object',
            this.getOptionName() + ' option must be the object'
        );

        if ('beforeOpeningRoundBrace' in options) {
            assert(
                options.beforeOpeningRoundBrace === true,
                this.getOptionName() + '.beforeOpeningRoundBrace ' +
                'property requires true value or should be removed'
            );
        }

        if ('beforeOpeningCurlyBrace' in options) {
            assert(
                options.beforeOpeningCurlyBrace === true,
                this.getOptionName() + '.beforeOpeningCurlyBrace ' +
                'property requires true value or should be removed'
            );
        }

        assert(
            options.beforeOpeningCurlyBrace || options.beforeOpeningRoundBrace,
            this.getOptionName() + ' must have beforeOpeningCurlyBrace ' +
            'or beforeOpeningRoundBrace property'
        );

        this._beforeOpeningRoundBrace = Boolean(options.beforeOpeningRoundBrace);
        this._beforeOpeningCurlyBrace = Boolean(options.beforeOpeningCurlyBrace);
    },

    getOptionName: function() {
        return 'requireSpacesInNamedFunctionExpression';
    },

    check: function(file, errors) {
        var beforeOpeningRoundBrace = this._beforeOpeningRoundBrace;
        var beforeOpeningCurlyBrace = this._beforeOpeningCurlyBrace;

        file.iterateNodesByType(['FunctionExpression'], function(node) {
            var functionNode = node.id;
            var parent = node.parentNode;

            // Ignore syntactic sugar for getters and setters.
            if (parent.type === 'Property' && (parent.kind === 'get' || parent.kind === 'set')) {
                return;
            }

            // shorthand or constructor methods
            if (parent.method || parent.type === 'MethodDefinition') {
                functionNode = parent.key;
            }

            // named function expressions only
            if (node.id) {
                if (beforeOpeningRoundBrace) {
                    var functionToken = file.getFirstNodeToken(functionNode);
                    if (node.async && functionToken.value === 'async') {
                        functionToken = file.getNextToken(functionToken);
                    }
                    errors.assert.whitespaceBetween({
                        token: functionToken,
                        nextToken: file.getNextToken(functionToken),
                        message: 'Missing space before opening round brace'
                    });
                }

                if (beforeOpeningCurlyBrace) {
                    var bodyToken = file.getFirstNodeToken(node.body);
                    errors.assert.whitespaceBetween({
                        token: file.getPrevToken(bodyToken),
                        nextToken: bodyToken,
                        message: 'Missing space before opening curly brace'
                    });
                }
            }
        });
    }

};

},{"assert":171}],143:[function(require,module,exports){
/**
 * Requires space after opening array square bracket and before closing.
 * Reports only on arrays, not on property accessors.
 * Use [requireSpacesInsideBrackets](http://jscs.info/rule/requireSpacesInsideBrackets.html)
 * to report on all brackets.
 *
 * Types: `String` or `Object`
 *
 * Values:
 *  - `String`
 *      - `"all"`: strict mode
 *      - `"allButNested"`: (*deprecated* use Object version with `"allExcept": [ "[", "]" ]`) ignores nested
 *        closing brackets in a row
 *  - `Object`:
 *      - `"allExcept"`: Array specifying list of tokens that can occur after an opening square bracket or before a
 *        closing square bracket without a space
 *
 * #### Example
 *
 * ```js
 * "requireSpacesInsideArrayBrackets": "all"
 * ```
 * ```js
 * "requireSpacesInsideArrayBrackets": {
 *     "allExcept": [ "[", "]", "{", "}" ]
 * }
 * ```
 *
 * ##### Valid for mode `"all"`
 *
 * ```js
 * var x = [ 1 ];
 * var x = a[1];
 * ```
 *
 * ##### Valid for mode `{ "allExcept": [ "[", "]" ] }` or `"allButNested"`
 *
 * ```js
 * var x = [[ 1 ], [ 2 ]];
 * ```
 *
 * ##### Valid for mode `{ "allExcept": [ "[", "]", "{", "}" ] }`
 *
 * ```js
 * var x = [[ 1 ], [ 2 ]];
 * var x = [{ a: 1 }, { b: 2}];
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * var x = [1];
 * ```
 */

var assert = require('assert');

module.exports = function() {};

module.exports.prototype = {

    configure: function(value) {
        var mode;
        var modes = {
            'all': true,
            'allButNested': true
        };
        var isObject = typeof value === 'object';

        var error = this.getOptionName() + ' rule' +
        ' requires string value "all" or "allButNested" or object';

        if (typeof value === 'string') {
            assert(modes[value], error);

        } else if (isObject) {
            assert('allExcept' in value, error);
        } else {
            assert(false, error);
        }

        this._exceptions = {};

        if (isObject) {
            (value.allExcept || []).forEach(function(value) {
                this._exceptions[value] = true;
            }, this);

        } else {
            mode = value;
        }

        if (mode === 'allButNested') {
            this._exceptions['['] = this._exceptions[']'] = true;
        }
    },

    getOptionName: function() {
        return 'requireSpacesInsideArrayBrackets';
    },

    check: function(file, errors) {
        var exceptions = this._exceptions;

        file.iterateNodesByType('ArrayExpression', function(node) {
            var openBracket = file.getFirstNodeToken(node);
            var afterOpen = file.getNextToken(openBracket, {includeComments: true});
            var closeBracket = file.getLastNodeToken(node);
            var beforeClose = file.getPrevToken(closeBracket, {includeComments: true});

            // Skip for empty array brackets
            if (afterOpen.value === ']') {
                return;
            }

            if (!(afterOpen.value in exceptions)) {
                errors.assert.spacesBetween({
                    token: openBracket,
                    nextToken: afterOpen,
                    exactly: 1,
                    message: 'One space required after opening bracket'
                });
            }

            if (!(beforeClose.value in exceptions)) {
                errors.assert.spacesBetween({
                    token: beforeClose,
                    nextToken: closeBracket,
                    exactly: 1,
                    message: 'One space required before closing bracket'
                });
            }
        });
    }
};

},{"assert":171}],144:[function(require,module,exports){
/**
 * Requires space after opening square bracket and before closing.
 * Reports on all on brackets, even on property accessors.
 * Use [requireSpacesInsideArrayBrackets](http://jscs.info/rule/requireSpacesInsideArrayBrackets.html)
 * to exclude property accessors.
 *
 * Types: `Boolean` or `Object`
 *
 * Values:
 *  - `Boolean`
 *      - `true`: strict mode
 *  - `Object`:
 *      - `"allExcept"`: Array specifying list of tokens that can occur after an opening square bracket or before a
 *        closing square bracket without a space

 * #### Example
 *
 * ```js
 * "requireSpacesInsideBrackets": true
 * ```
 * ```js
 * "requireSpacesInsideBrackets": {
 *     "allExcept": [ "[", "]", "{", "}" ]
 * }
 * ```
 *
 * ##### Valid for mode `true`
 *
 * ```js
 * var x = [ 1 ];
 * var x = a[ 1 ];
 * ```
 *
 * ##### Valid for mode `{ allExcept": [ "[", "]", "{", "}" ] }`
 *
 * ```js
 * var x = [[ 1 ], [ 2 ]];
 * var x = [{ a: 1 }, { b: 2}];
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * var x = [1];
 * ```
 */

var assert = require('assert');

module.exports = function() {};

module.exports.prototype = {

    configure: function(value) {
        var isObject = typeof value === 'object';

        var error = this.getOptionName() + ' rule requires string value true or object';

        if (isObject) {
            assert('allExcept' in value, error);
        } else {
            assert(value === true, error);
        }

        this._exceptions = {};

        if (isObject) {
            (value.allExcept || []).forEach(function(value) {
                this._exceptions[value] = true;
            }, this);
        }
    },

    getOptionName: function() {
        return 'requireSpacesInsideBrackets';
    },

    check: function(file, errors) {
        var exceptions = this._exceptions;

        file.iterateTokenByValue('[', function(token) {
            var nextToken = file.getNextToken(token, { includeComments: true });
            var value = nextToken.value;

            if (value in exceptions) {
                return;
            }

            // Skip for empty array brackets
            if (value === ']') {
                return;
            }

            errors.assert.spacesBetween({
                token: token,
                nextToken: nextToken,
                exactly: 1,
                message: 'One space required after opening bracket'
            });
        });

        file.iterateTokenByValue(']', function(token) {
            var prevToken = file.getPrevToken(token, { includeComments: true });
            var value = prevToken.value;

            if (value in exceptions) {
                return;
            }

            // Skip for empty array brackets
            if (value === '[') {
                return;
            }

            errors.assert.spacesBetween({
                token: prevToken,
                nextToken: token,
                exactly: 1,
                message: 'One space required before closing bracket'
            });
        });
    }
};

},{"assert":171}],145:[function(require,module,exports){
/**
 * Requires space after opening object curly brace and before closing.
 *
 * Types: `String` or `Object`
 *
 * Values:
 *  - `String`
 *      - `"all"`: strict mode
 *      - `"allButNested"`: (*deprecated* use Object version with `"allExcept": ['}']`) ignores nested
 *        closing object braces in a row
 *  - `Object`:
 *      - `"allExcept"`: Array specifying list of tokens that can occur after an opening object brace or before a
 *        closing object brace without a space
 *
 * #### Example
 *
 * ```js
 * "requireSpacesInsideObjectBrackets": {
 *     "allExcept": [ "}", ")" ]
 * }
 * ```
 * ```js
 * "requireSpacesInsideObjectBrackets": "all"
 * ```
 *
 * ##### Valid for mode `"all"`
 *
 * ```js
 * var x = { a: { b: 1 } };
 * ```
 *
 * ##### Valid for mode `{ "allExcept": [ "}" ] }` or `"allButNested"`
 *
 * ```js
 * var x = { a: { b: 1 }};
 * ```
 *
 * ##### Valid for mode `"allExcept": [ "}", ")" ]`
 *
 * ```js
 * var x = { a: (b ? 1 : 2)};
 * var x = { a: { b: 1 }};
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * var x = {a: 1};
 * ```
 */

var assert = require('assert');

module.exports = function() {};

module.exports.prototype = {

    configure: function(value) {
        var mode;
        var modes = {
            'all': true,
            'allButNested': true
        };
        var isObject = typeof value === 'object';

        var error = this.getOptionName() + ' rule' +
        ' requires string value \'all\' or \'allButNested\' or object';

        if (typeof value === 'string') {
            assert(modes[value], error);

        } else if (isObject) {
            assert('allExcept' in value, error);
        } else {
            assert(false, error);
        }

        this._exceptions = {};

        if (isObject) {
            (value.allExcept || []).forEach(function(value) {
                this._exceptions[value] = true;
            }, this);

        } else {
            mode = value;
        }

        if (mode === 'allButNested') {
            this._exceptions['}'] = true;
        }
    },

    getOptionName: function() {
        return 'requireSpacesInsideObjectBrackets';
    },

    check: function(file, errors) {
        var exceptions = this._exceptions;

        file.iterateNodesByType(['ObjectExpression', 'ObjectPattern'], function(node) {
            var openingBracket = file.getFirstNodeToken(node);
            var nextToken = file.getNextToken(openingBracket);

            // Don't check empty object
            if (nextToken.value === '}') {
                return;
            }

            errors.assert.spacesBetween({
                token: openingBracket,
                nextToken: nextToken,
                exactly: 1,
                message: 'One space required after opening curly brace'
            });

            var closingBracket = file.getLastNodeToken(node);
            var prevToken = file.getPrevToken(closingBracket);

            if (prevToken.value in exceptions) {
                return;
            }

            errors.assert.spacesBetween({
                token: prevToken,
                nextToken: closingBracket,
                exactly: 1,
                message: 'One space required before closing curly brace'
            });
        });
    }
};

},{"assert":171}],146:[function(require,module,exports){
/**
 * Requires space after opening round bracket and before closing.
 *
 * Types: `String` or `Object`
 *
 * Values:
 *  - `String`
 *      - `"all"`: strict mode
 *      - `"allButNested"`: (*deprecated* use Object version with `"except": ["(", ")"]`) ignores nested brackets
 *        in a row
 *  - `Object`:
 *      - `"all"`: true
 *      - `"ignoreParenthesizedExpression"`: true
 *      - `"except"`: Array specifying list of tokens that can occur after an opening bracket or before a
 *        closing bracket without a space
 *
 * #### Example
 *
 * ```js
 * "requireSpacesInsideParentheses": "all"
 * ```
 * ```js
 * "requireSpacesInsideParentheses": {
 *     "all": true,
 *     "except": [ "{", "}", "\"" ]
 * }
 * ```
 *
 * ##### Valid for mode `"all"`
 *
 * ```js
 * var x = Math.pow( ( 1 + 2 ), ( 3 + 4 ) );
 * ```
 *
 * ##### Valid for mode `{ "all": true, "except": [ "(", ")" ] }` or `"allButNested"`
 *
 * ```js
 * var x = Math.pow(( 1 + 2 ), ( 3 + 4 ));
 * ```
 *
 * ##### Valid for mode `{ "all": true, "ignoreParenthesizedExpression": true }`
 *
 * ```js
 * if ( !("foo" in obj) ) {}
 * ```
 *
 * ##### Valid for mode `{ "all": true, "except": [ "{", "}" ] }`
 *
 * ```js
 * var x = Math.pow( foo({ test: 1 }) );
 * ```
 *
 * ##### Valid for mode `{ "all": true, "except": [ "\"" ] }`
 *
 * ```js
 * var x = foo("string");
 * var x = foo( 1 );
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * var x = Math.pow(1 + 2, 3 + 4);
 * ```
 */

var assert = require('assert');
var TokenCategorizer = require('../token-categorizer');

module.exports = function() {};

module.exports.prototype = {

    configure: function(value) {
        var mode;
        var modes = {
            'all': true,
            'allButNested': true
        };
        var isObject = typeof value === 'object';

        var error = this.getOptionName() + ' rule' +
        ' requires string value \'all\' or \'allButNested\' or object';

        if (typeof value === 'string') {
            assert(modes[value], error);

        } else if (isObject) {
            assert(
                'all' in value || 'allButNested' in value,
                error
            );
        } else {
            assert(false, error);
        }

        this._exceptions = {};
        this._exceptSingleQuote = false;
        this._exceptDoubleQuote = false;
        this._ignoreParenthesizedExpression = false;

        if (isObject) {
            mode = 'all' in value ? 'all' : 'allButNested';

            (value.except || []).forEach(function(value) {
                if (value === '\'') {
                    this._exceptSingleQuote = true;
                }

                if (value === '"') {
                    this._exceptDoubleQuote = true;
                }

                this._exceptions[value] = true;
            }, this);

            if (value.ignoreParenthesizedExpression === true) {
                this._ignoreParenthesizedExpression = true;
            }

        } else {
            mode = value;
        }

        if (mode === 'allButNested') {
            this._exceptions[')'] = this._exceptions['('] = true;
        }
    },

    getOptionName: function() {
        return 'requireSpacesInsideParentheses';
    },

    check: function(file, errors) {
        var exceptions = this._exceptions;
        var singleQuote = this._exceptSingleQuote;
        var doubleQuote = this._exceptDoubleQuote;
        var ignoreParenthesizedExpression = this._ignoreParenthesizedExpression;

        file.iterateTokenByValue('(', function(token) {
            var nextToken = file.getNextToken(token, {includeComments: true});
            var value = nextToken.value;

            if (
                ignoreParenthesizedExpression &&
                TokenCategorizer.categorizeOpenParen(token, file) === 'ParenthesizedExpression'
            ) {
                return;
            }

            if (value in exceptions) {
                return;
            }

            if (doubleQuote && nextToken.type === 'String' && value[0] === '"') {
                return;
            }

            if (singleQuote && nextToken.type === 'String' && value[0] === '\'') {
                return;
            }

            // Skip for empty parentheses
            if (value === ')') {
                return;
            }

            errors.assert.whitespaceBetween({
                token: token,
                nextToken: nextToken,
                message: 'Missing space after opening round bracket'
            });
        });

        file.iterateTokenByValue(')', function(token) {
            var prevToken = file.getPrevToken(token, {includeComments: true});
            var value = prevToken.value;

            if (
                ignoreParenthesizedExpression &&
                TokenCategorizer.categorizeCloseParen(token, file) === 'ParenthesizedExpression'
            ) {
                return;
            }

            if (value in exceptions) {

                // Special case - foo( object[i] )
                if (!(
                    value === ']' &&
                    file.getNodeByRange(token.range[0] - 1).type === 'MemberExpression'
                )) {
                    return;
                }
            }

            if (doubleQuote && prevToken.type === 'String' && value[value.length - 1] === '"') {
                return;
            }

            if (singleQuote && prevToken.type === 'String' && value[value.length - 1] === '\'') {
                return;
            }

            // Skip for empty parentheses
            if (value === '(') {
                return;
            }

            errors.assert.whitespaceBetween({
                token: prevToken,
                nextToken: token,
                message: 'Missing space before closing round bracket'
            });
        });
    }
};

},{"../token-categorizer":164,"assert":171}],147:[function(require,module,exports){
/**
 * Requires space after opening and before closing grouping parentheses.
 *
 * Types: `Boolean` or `Object`
 *
 * Values:
 * - `true`: always require spaces inside grouping parentheses
 * - `Object`:
 *      - `"allExcept"`: `[ "{", "}", "function" ]` Ignore parenthesized objects and functions
 *
 * #### Example
 *
 * ```js
 * "requireSpacesInsideParenthesizedExpression": true
 *
 * // or
 *
 * "requireSpacesInsideParenthesizedExpression": {
 *     "allExcept": [ "{", "}" ]
 * }
 * ```
 *
 * ##### Valid for mode `true`
 *
 * ```js
 * var x = ( 1 + obj.size ) * ( 2 );
 * ```
 *
 * ##### Valid for mode `{ allExcept": [ "{", "}", "function" ] }`
 *
 * ```js
 * var x = ( options || { x: true }).x;
 * var global = (function() { return this; })();
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * var x = (1 + obj.size) * (2);
 * ```
 */

var assert = require('assert');
var TokenCategorizer = require('../token-categorizer');

module.exports = function() {};

module.exports.prototype = {
    configure: function(value) {
        var isObject = typeof value === 'object';

        var error = this.getOptionName() + ' rule requires string value true or object';

        if (isObject) {
            assert('allExcept' in value, error);
        } else {
            assert(value === true, error);
        }

        this._exceptions = {};

        if (isObject) {
            (value.allExcept || []).forEach(function(value) {
                this._exceptions[value] = true;
            }, this);
        }
    },

    getOptionName: function() {
        return 'requireSpacesInsideParenthesizedExpression';
    },

    check: function(file, errors) {
        var exceptions = this._exceptions;

        file.iterateTokenByValue('(', function(token) {
            var nextToken = file.getNextToken(token, {includeComments: true});
            var value = nextToken.isComment ?
                nextToken.type === 'Block' ? '/*' : '//' :
                nextToken.value;

            // Skip empty parentheses and explicit exceptions
            if (value === ')' || value in exceptions) {
                return;
            }

            // Skip non-expression parentheses
            var type = TokenCategorizer.categorizeOpenParen(token, file);
            if (type !== 'ParenthesizedExpression') {
                return;
            }

            errors.assert.whitespaceBetween({
                token: token,
                nextToken: nextToken,
                message: 'Missing space after opening grouping parenthesis'
            });
        });

        file.iterateTokenByValue(')', function(token) {
            var prevToken = file.getPrevToken(token, {includeComments: true});
            var value = prevToken.isComment ?
                prevToken.type === 'Block' ? '*/' : '' :
                prevToken.value;

            // Skip empty parentheses and explicit exceptions
            if (value === '(' || value in exceptions) {
                return;
            }

            // Skip non-expression parentheses
            var type = TokenCategorizer.categorizeCloseParen(token, file);
            if (type !== 'ParenthesizedExpression') {
                return;
            }

            errors.assert.whitespaceBetween({
                token: prevToken,
                nextToken: token,
                message: 'Missing space before closing grouping parenthesis'
            });
        });
    }
};

},{"../token-categorizer":164,"assert":171}],148:[function(require,module,exports){
/**
 * Disallows using `.apply` in favor of the spread operator
 *
 * Types: `Boolean`
 *
 * Values:
 * - `true` specifies that apply `.apply` is disallowed
 *
 * Version: `ES6`
 *
 * #### Example
 *
 * ```js
 * "requireSpread": true
 * ```
 *
 * ##### Valid for mode `true`
 *
 * ```js
 * const wrap = (f, g) => (...args) => g(f, ...args)
 * instance.method(...args)
 * ```
 *
 * ##### Invalid for mode `true`
 *
 * ```js
 * const wrap = (f, g) => (...args) => g.apply(g, [f].concat(args))
 * instance.method.apply(instance, args);
 * ```
 */

var assert = require('assert');

module.exports = function() {};

module.exports.prototype = {

    configure: function(options) {
        assert(
            options === true,
            this.getOptionName() + ' option requires a true value or should be removed'
        );
    },

    getOptionName: function() {
        return 'requireSpread';
    },

    check: function(file, errors) {
        file.iterateNodesByType('CallExpression', function(node) {
            var callee = node.callee;
            var firstParameter = node.arguments[0];

            if (node.arguments.length === 2 &&
                callee.property && callee.property.name === 'apply' &&
                callee.object && callee.object.name === firstParameter.name) {
                errors.add(
                    'Illegal use of apply method. Use the spread operator instead',
                    node.callee.property.loc.start
                );
            }
        });
    }
};

},{"assert":171}],149:[function(require,module,exports){
/**
 * Requires the use of template strings instead of string concatenation.
 *
 * Types: `Boolean` or `Object`
 *
 * Values:
 * - true
 * - `Object`:
 *      - `"allExcept"`: array of quoted exceptions:
 *          - `"stringConcatenation"` ignores strings concatenated with other strings
 *
 * Version: `ES6`
 *
 * #### Example
 *
 * ```js
 * "requireTemplateStrings": true
 * "requireTemplateStrings": { "allExcept": ["stringConcatenation"] }
 * ```
 *
 * ##### Valid
 *
 * ```js
 * function sayHi(name) {
 *     return `How are you, ${name}?`;
 * }
 * `a ${b + c}`
 * `a ${a()}`
 * ```
 *
 * ##### Valid for `{ "allExcept": ["stringConcatenation"] }`
 *
 * ```js
 * function sayBye(name) {
 *     return `It was good seeing you, ${name}! Let's hang out again sometime and` +
 *         ' grab some chicken and waffles.';
 * }
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * function sayHi(name) {
 *     return 'How are you, ' + name + '?';
 * }
 * "a" + (b + c)
 * "a" + a()
 * ```
 */

var assert = require('assert');

module.exports = function() {};

module.exports.prototype = {

    configure: function(options) {
        this._allowStringConcatenation = false;
        var optionName = this.getOptionName();

        if (typeof options === 'object') {
            assert(Array.isArray(options.allExcept), optionName + ' option requires "allExcept" ' +
                'to be an array');
            assert(options.allExcept.length > 0, optionName + ' option requires "allExcept" ' +
                'to have at least one item or be set to `true`');
            options.allExcept.forEach(function(except) {
                if (except === 'stringConcatenation') {
                    this._allowStringConcatenation = true;
                } else {
                    assert(false, optionName + ' option requires "allExcept" to only have ' +
                        '"stringConcatenation"');
                }
            }, this);
        } else {
            assert(
                options === true,
                optionName + ' option requires true value or object'
            );
        }
    },

    getOptionName: function() {
        return 'requireTemplateStrings';
    },

    check: function(file, errors) {
        var allowStringConcatenation = this._allowStringConcatenation;

        function add(node) {
            errors.add(
                'Illegal use of string concatenation. Use template strings instead.',
                node.left.loc.end
            );
        }

        file.iterateNodesByType('BinaryExpression', function(node) {
            if (node.operator !== '+') {
                return;
            }

            var leftIsString = node.left;
            var rightIsString = node.right;

            // Left side could also be binary expression (See gh-2050),
            // but not the right one
            while (leftIsString.type === 'BinaryExpression') {
                leftIsString = leftIsString.left;
            }

            leftIsString = typeof leftIsString.value === 'string' ||
                leftIsString.type === 'TemplateLiteral';

            rightIsString = typeof rightIsString.value === 'string' ||
                rightIsString.type === 'TemplateLiteral';

            if (allowStringConcatenation && leftIsString && rightIsString) {
                return;
            }

            // At least one of the operands should be a string or template string,
            // otherwise this is not a concatenation
            if (leftIsString || rightIsString) {
                add(node);
            }
        });
    }
};

},{"assert":171}],150:[function(require,module,exports){
/**
 * Requires an extra comma following the final element of an array or object literal.
 *
 * Types: `Boolean` or `Object`
 *
 * Values:
 *
 * - `true`: validates all arrays and objects
 * - `Object`:
 *     - `ignoreSingleValue`: allows single property objects and single element arrays to not require a trailing comma
 *     - `ignoreSingleLine`: allows objects and arrays on a single line to not require a trailing comma
 *
 * #### Example
 *
 * ```js
 * "requireTrailingComma": true
 * ```
 *
 * ##### Valid
 *
 * ```js
 * var foo = [1, 2, 3,];
 * var bar = {a: "a", b: "b",}
 * ```
 *
 * ##### Valid with ignoreSingleValue
 *
 * ```js
 * var car = [1];
 * var dar = {a: "a"};
 * ```
 *
 * ##### Valid with ignoreSingleLine
 *
 * ```js
 * var car = [1, 2, 3];
 * var dar = {a: "a", b: "b"};
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * var foo = [1, 2, 3];
 * var bar = {a: "a", b: "b"}
 * ```
 */

var assert = require('assert');

module.exports = function() {};

module.exports.prototype = {
    configure: function(options) {

        if (typeof options === 'object') {
            if ('ignoreSingleValue' in options) {
                assert(
                    options.ignoreSingleValue === true,
                    this.getOptionName() + ' option ignoreSingleValue requires true value or should be removed'
                );
                this._ignoreSingleValue = true;
            }
            if ('ignoreSingleLine' in options) {
                assert(
                    options.ignoreSingleLine === true,
                    this.getOptionName() + ' option ignoreSingleLine requires true value or should be removed'
                );
                this._ignoreSingleLine = true;
            }
        } else {
            assert(
                options === true,
                this.getOptionName() + ' option requires a true value or should be removed'
            );
        }
    },

    getOptionName: function() {
        return 'requireTrailingComma';
    },

    check: function(file, errors) {
        var _this = this;

        file.iterateNodesByType([
            'ObjectExpression', 'ArrayExpression',
            'ObjectPattern', 'ArrayPattern'
        ], function(node) {
            var isLikeObject = node.type === 'ObjectExpression' || node.type === 'ObjectPattern';
            var entities = isLikeObject ? node.properties : node.elements;

            if (entities.length === 0) {
                return;
            }

            if (_this._ignoreSingleValue && entities.length === 1) {
                return;
            }

            if (_this._ignoreSingleLine && node.loc.start.line === node.loc.end.line) {
                return;
            }

            var closingToken = file.getLastNodeToken(node);

            errors.assert.tokenBefore({
                token: closingToken,
                expectedTokenBefore: {type: 'Punctuator', value: ','},
                message: 'Missing comma before closing ' + (isLikeObject ? 'curly brace' : 'bracket')
            });
        });
    }

};

},{"assert":171}],151:[function(require,module,exports){
/**
 * Requires `var` declaration to be on the top of an enclosing scope
 *
 * Types: `Boolean`
 *
 * Values:
 *
 * - `true` specifies that `var` declarations must occur the top of a function scope.
 *
 * #### Example
 *
 * ```js
 * "requireVarDeclFirst": true
 * ```
 *
 * ##### Valid for mode `true`
 *
 * ```js
 * var x = 1,
 *     y = 2;
 * ```
 * ```js
 * 'use strict;'
 * var x = 1,
 *     y = 2;
 * ```
 * ```js
 * var x = 1;
 * var y = 2;
 * ```
 * ```js
 * var x = 1;
 * // comments
 * var y = 2;
 * ```
 * ```js
 * var x = 1;
 * // comments
 * // comments 2
 * var y = 2;
 * ```
 * ```js
 * const a = 1;
 * const b = 2;
 * ```
 * ```js
 * var x = 1;
 * function y() {var z;};
 * ```
 * ```js
 * var x = 1;
 * var y = function () {var z;};
 * ```
 * ```js
 * var w = 1;
 * function x() {
 *  var y;
 * // comments
 * // comments 2
 *  var z;
 * };
 * ```
 * ```js
 * var w = 1;
 * function x() {
 *  "use strict";
 *  var y;
 * };
 * ```
 * ```js
 * var x = 1;
 * var y;
 * for (y = 0; y < 10; y++) {};
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * var x;
 * x = 1;
 * var y = 2;
 * ```
 * ```js
 * var w = 1;
 * function x() {var y;};
 * var z = 2;
 * ```
 * ```js
 * var w = 1;
 * function x() {
 *  var y;
 *  y = 2;
 *  var z;
 * };
 * ```
 * ```js
 * var a;
 * for(var count=0;count < 10;count++){}
 * ```
 * ```js
 * var x;
 * for(var count=0;count < 10;count++){
 *  var y;
 * }
 * ```
 *
 */

var assert = require('assert');

function getVariableScope(node) {
    while (node.type !== 'Program' &&
        node.type !== 'FunctionDeclaration' &&
        node.type !== 'FunctionExpression') {
        node = node.parentNode;
    }

    return node;
}

function getOffsetForBlockStatement(enclosingScope, varDecl, commentTokens, file) {
    var offset = 0;
    var parentNode = varDecl.parentNode;
    if (enclosingScope.type !== 'Program' && parentNode.type === 'BlockStatement') {
        offset += 1;
        offset += getCommentOffsetBetweenNodes(parentNode, varDecl, commentTokens, file);
    }
    return offset;
}

function getUseStrictDeclFirst(enclosingScope) {
    var firstNode;
    if (enclosingScope.type === 'Program') {
        firstNode = enclosingScope.body[0];
    } else {
        firstNode = enclosingScope.body.body[0];
    }

    if (firstNode.type === 'ExpressionStatement' &&
        firstNode.hasOwnProperty('expression') === true &&
        firstNode.expression.hasOwnProperty('value') === true &&
        firstNode.expression.value === 'use strict') {
        return firstNode;
    }

    return null;
}

function isFirstVarDeclInScope(enclosingScope, varDecl, whitespaceOffsetBeforeVarDecl, commentTokens, file) {
    var adjustedVarDeclStart = varDecl.range[0];
    var adjustedScopeStart = enclosingScope.range[0];

    if (enclosingScope.type !== 'Program') {
        // For function declaration and function expression scope use the top block statement as start
        // This removes the requirement to offset the function declaration or expression related tokens
        adjustedScopeStart = enclosingScope.body.range[0];
        // If enclosing scope node type is Program the range start ignores all comments and whitespace before the
        // variable declaration
        adjustedVarDeclStart -= whitespaceOffsetBeforeVarDecl;
    }

    adjustedVarDeclStart -= getOffsetForBlockStatement(enclosingScope, varDecl, commentTokens, file);

    if (adjustedVarDeclStart === adjustedScopeStart) {
        return true;
    }

    return false;
}

function getCommentOffsetBetweenNodes(previousNode, currentNode, commentTokens, file) {
    var count;
    var comment;
    var commentLength = 0;

    for (count = 0; count < commentTokens.length; count++) {
        comment = commentTokens[count];
        if (comment.range[0] >= currentNode.range[1]) {
            // Stop processing comments that are occurred after current node
            break;
        }

        if (previousNode.range[1] < currentNode.range[0] &&
            comment.range[0] > previousNode.range[0] &&
            comment.range[1] < previousNode.range[1]) {
            // Stop processing comments that are within multiple declarators in a single variable declaration
            // of the previous node and the previousNode is not the parent of currentNode
            break;
        }

        if (comment.range[0] > currentNode.range[0] &&
            comment.range[1] < currentNode.range[1]) {
            // Stop processing comments that are within multiple declarators in a single variable declaration
            break;
        }

        if (previousNode.range[0] >= comment.range[1]) {
            // Skip comments that occurred before the previous node
            continue;
        }

        commentLength += comment.range[1] - comment.range[0] + file.getWhitespaceBefore(comment).length;
    }

    return commentLength;
}

function isPreviousNodeAVarDecl(previousNode, varDecl, whitespaceOffsetBeforeVarDecl, commentTokens, file) {
    var offsetForComments;
    if (varDecl.range[0] === previousNode.range[1]) {
        return true;
    }

    offsetForComments = getCommentOffsetBetweenNodes(previousNode, varDecl, commentTokens, file);
    if (varDecl.range[0] - whitespaceOffsetBeforeVarDecl - offsetForComments === previousNode.range[1]) {
        return true;
    }

    return false;
}

module.exports = function() {};

module.exports.prototype = {
    configure: function(options) {
        assert(
            options === true,
            this.getOptionName() + ' option requires a true value'
        );
    },

    getOptionName: function() {
        return 'requireVarDeclFirst';
    },

    check: function(file, errors) {
        var scopesFoundInFile = {};
        var commentTokens = [];

        file.iterateTokensByType(['Line', 'Block'], function(commentToken) {
            commentTokens.push(commentToken);
        });

        file.iterateNodesByType(['VariableDeclaration'], function(varDecl) {
            // Ignore let and const for now #1783
            if (varDecl.kind !== 'var') {
                return;
            }

            var enclosingScope;
            var scopeContents;
            var previousNode;
            var useStrictDirective;
            var isVarDeclFirst = false;

            var whitespaceOffsetBeforeVarDecl = file.getWhitespaceBefore(file.getFirstNodeToken(varDecl)).length;

            enclosingScope = getVariableScope(varDecl.parentNode);
            if (!scopesFoundInFile.hasOwnProperty(enclosingScope.range[0])) {
                scopesFoundInFile[enclosingScope.range[0]] = { hasNonVarDecl: false, varDecl: [] };
                // placing the handling 'use strict' declared as the first statement of scope here to improve
                // performance to run once per scope discovered in file
                useStrictDirective = getUseStrictDeclFirst(enclosingScope);
                if (useStrictDirective !== null) {
                    // Special case to make varDecl stack contain the use strict as first node
                    // this reduces the complexity of the isFirstVarDecInScope and reuses
                    // isPreviousNodeAVarDecl to handle this special scenario
                    scopesFoundInFile[enclosingScope.range[0]].varDecl.push(useStrictDirective);
                }
            }

            scopeContents = scopesFoundInFile[enclosingScope.range[0]];

            if (scopeContents.varDecl.length === 0) {
                isVarDeclFirst = isFirstVarDeclInScope(
                    enclosingScope, varDecl, whitespaceOffsetBeforeVarDecl, commentTokens, file
                );
            } else {
                previousNode = scopeContents.varDecl[scopeContents.varDecl.length - 1];
                if (!scopeContents.hasNonVarDecl) {
                    isVarDeclFirst = isPreviousNodeAVarDecl(
                        previousNode, varDecl, whitespaceOffsetBeforeVarDecl, commentTokens, file
                    );
                }
            }

            scopeContents.varDecl.push(varDecl);
            if (!isVarDeclFirst) {
                scopeContents.hasNonVarDecl = true;
                errors.add('Variable declarations must be the first statements of a function scope.',
                    varDecl.loc.start.line, varDecl.loc.start.column);
            }
        });
    }
};

},{"assert":171}],152:[function(require,module,exports){
/**
 * Requires the variable to be the right hand operator when doing a boolean comparison
 *
 * Types: `Array` or `Boolean`
 *
 * Values:
 * - `true` specifies that yoda conditions are required for most possible comparison operators
 * - `Array`: represents the list of quoted operators that requires yoda conditions
 *
 * #### Example
 *
 * ```js
 * "requireYodaConditions": true
 * ```
 * ```js
 * "requireYodaConditions": [
 *     "==",
 *     "===",
 *     "!=",
 *     "!=="
 * ]
 * ```
 *
 * ##### Valid for mode `true` or `['==']`
 * ```js
 * if (1 == a) {
 *     return
 * }
 * ```
 *
 * ##### Invalid for mode `true` or `['==']`
 *
 * ```js
 * if (a == 1) {
 *     return
 * }
 * ```
 */

var assert = require('assert');

module.exports = function() {};

module.exports.prototype = {

    configure: function(operators) {
        var isTrue = operators === true;

        assert(
            Array.isArray(operators) || isTrue,
            this.getOptionName() + ' option requires array or true value'
        );

        if (isTrue) {
            operators = ['==', '===', '!=', '!=='];
        }

        this._operatorIndex = {};
        for (var i = 0, l = operators.length; i < l; i++) {
            this._operatorIndex[operators[i]] = true;
        }
    },

    getOptionName: function() {
        return 'requireYodaConditions';
    },

    check: function(file, errors) {
        var operators = this._operatorIndex;
        file.iterateNodesByType('BinaryExpression', function(node) {
            if (operators[node.operator]) {
                if (node.right.type === 'Literal' ||
                    (node.right.type === 'Identifier' && node.right.name === 'undefined')
                ) {
                    errors.add('Not yoda condition', node.left.loc.start);
                }
            }
        });
    }

};

},{"assert":171}],153:[function(require,module,exports){
/**
 * Option to check `var that = this` expressions
 *
 * Types: `String`, `Array`
 *
 * Values:
 *  - `String`: represents the keyword that can assigned to `this` context
 *  - `Array`: represents the list of keywords that can assigned to `this` context
 *
 * #### Example
 *
 * ```js
 * "safeContextKeyword": ["that"]
 * ```
 *
 * ##### Valid for mode `["that"]`
 *
 * ```js
 * var that = this;
 * ```
 *
 * ##### Invalid for mode `["that"]`
 *
 * ```js
 * var _this = this;
 * ```
 */

var assert = require('assert');

module.exports = function() {};

module.exports.prototype = {

    configure: function(keywords) {
        assert(
            Array.isArray(keywords) || typeof keywords === 'string',
            this.getOptionName() + ' option requires string or array value'
        );

        this._keywords = keywords;
    },

    getOptionName: function() {
        return 'safeContextKeyword';
    },

    check: function(file, errors) {
        var keywords = typeof this._keywords === 'string' ? [this._keywords] : this._keywords;

        // var that = this
        file.iterateNodesByType('VariableDeclaration', function(node) {
            var firstToken = file.getFirstNodeToken(node);

            // Miss destructing assignment (#1699)
            if (file.getNextToken(firstToken).value === '{') {
                return;
            }

            for (var i = 0; i < node.declarations.length; i++) {
                var decl = node.declarations[i];

                // decl.init === null in case of "var foo;"
                if (decl.init &&
                    (decl.init.type === 'ThisExpression' && checkKeywords(decl.id.name, keywords))
                ) {
                    errors.add(
                        'You should use "' + keywords.join('" or "') + '" to save a reference to "this"',
                        node.loc.start
                    );
                }
            }
        });

        // that = this
        file.iterateNodesByType('AssignmentExpression', function(node) {

            if (
                // filter property assignments "foo.bar = this"
                node.left.type === 'Identifier' &&
                (node.right.type === 'ThisExpression' && checkKeywords(node.left.name, keywords))
            ) {
                errors.add(
                    'You should use "' + keywords.join('" or "') + '" to save a reference to "this"',
                    node.loc.start
                );
            }
        });
    }
};

/**
 * Check if at least one keyword equals to passed name.
 *
 * @param {String} name
 * @param {Array} keywords
 * @return {Boolean}
 */
function checkKeywords(name, keywords) {
    for (var i = 0; i < keywords.length; i++) {
        if (name === keywords[i]) {
            return false;
        }
    }

    return true;
}

},{"assert":171}],154:[function(require,module,exports){
/**
 * Validates proper alignment of function parameters.
 *
 * Types: `Boolean`, `Object`
 *
 * Values:
 *  - `true`: setting this is the same as validating the rule using
 *    `{lineBreakAfterOpeningBrace: true, lineBreakBeforeClosingBrace: true}`
 *  - `Object`:
 *      - `lineBreakAfterOpeningBrace`
 *          - `true` specifies that the first function parameter must not be on the same line as the opening brace `(`
 *            of the function parameters list
 *      - `lineBreakBeforeClosingBrace`
 *          - `true` specifies that the last function parameter must not be on the same line as the closing brace `)`
 *            of the function parameters list
 *
 * #### Example
 *
 * ```js
 * "validateAlignedFunctionParameters": {
 *   "lineBreakAfterOpeningBrace": true,
 *   "lineBreakBeforeClosingBrace": true
 * }
 * ```
 *
 * ##### Valid for mode `{ "lineBreakAfterOpeningBrace": true, "lineBreakBeforeClosingBrace": true}`
 * ```js
 * function (
 *   thisIs,
 *   theLongestList,
 *   ofParametersEverWritten
 * ) {}
 * ```
 * ##### Invalid for mode `{ "lineBreakAfterOpeningBrace": true, "lineBreakBeforeClosingBrace": true}`
 * ```js
 * function (thisIs,
 *           theLongestList,
 *           ofParametersEverWritten) {}
 * ```
 */

var assert = require('assert');

module.exports = function() {};

module.exports.prototype = {

    configure: function(options) {
        var validProperties = [
            'lineBreakAfterOpeningBrace',
            'lineBreakBeforeClosingBrace'
        ];
        var optionName = this.getOptionName();

        assert(
            typeof options === 'object' || options === true,
            optionName + ' option must be an object or boolean true'
        );

        if (typeof options === 'object') {
            validProperties.forEach(function(key) {
                var isPresent = key in options;

                if (isPresent) {
                    assert(
                        options[key] === true,
                        optionName + '.' + key + ' property requires true value or should be removed'
                    );
                }
            });

            validProperties.forEach(function(property) {
                this['_' + property] = Boolean(options[property]);
            }.bind(this));
        }
    },

    getOptionName: function() {
        return 'validateAlignedFunctionParameters';
    },

    check: function(file, errors) {
        var lineBreakAfterOpeningBrace = this._lineBreakAfterOpeningBrace;
        var lineBreakBeforeClosingBrace = this._lineBreakBeforeClosingBrace;

        file.iterateNodesByType([
            'FunctionDeclaration',
            'FunctionExpression',
            'ArrowFunctionExpression'
        ], function(node) {

            // ignore this rule if there are no parameters
            if (node.params.length === 0) {
                return;
            }

            // ignore this rule if the parameters are not multi-line
            var firstParameter = file.getFirstNodeToken(node.params[0]);
            var lastParameter = node.params[node.params.length - 1];
            if (firstParameter.loc.start.line === lastParameter.loc.end.line) {
                return;
            }

            // look for the furthest parameter start position
            var maxParamStartPos = 0;
            node.params.forEach(function(parameter) {
                maxParamStartPos = Math.max(maxParamStartPos, parameter.loc.start.column);
            });

            // make sure all parameters are lined up
            node.params.forEach(function(parameter) {
                if (parameter.loc.start.column !== maxParamStartPos) {
                    errors.add('Multi-line parameters are not aligned.', parameter.loc.start);
                }
            });

            // make sure the first parameter is on a new line
            if (lineBreakAfterOpeningBrace) {
                var openingBrace = file.getPrevToken(firstParameter);
                errors.assert.differentLine({
                    token: openingBrace,
                    nextToken: firstParameter,
                    message: 'There is no line break after the opening brace'
                });
            }

            // make sure the closing brace is on a new line
            if (lineBreakBeforeClosingBrace) {
                var bodyToken = file.getFirstNodeToken(node.body);
                var closingBrace = file.getPrevToken(bodyToken);
                errors.assert.differentLine({
                    token: lastParameter,
                    nextToken: closingBrace,
                    message: 'There is no line break before the closing brace'
                });
            }

        });
    }

};

},{"assert":171}],155:[function(require,module,exports){
/**
 * This rule is for validating the positioning of line comments. Block comments are ignored.
 *
 * Comments that start with the following keywords are also ignored:
 * `eslint`, `jshint`, `jslint`, `istanbul`, `global`, `exported`, `jscs`, `falls through`
 * eg. // jshint strict: true
 *
 * Type: `Object`
 *
 * Value:
 *
 * - `Object`:
 *    - `position`: `above` or `beside`
 *    - `allExcept`: array of quoted exceptions (comments that start with these values will be excepted)
 *
 * #### Example
 *
 * ```js
 * "validateCommentPosition": { position: `above`, allExcept: [`pragma`] }
 * ```
 *
 * ##### Valid
 *
 * ```js
 * // This is a valid comment
 * 1 + 1;
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * 1 + 1; // This is an invalid comment
 * 2 + 2; // pragma (this comment is fine)
 * ```
 *
 * ```js
 * "validateCommentPosition": { position: `beside` }
 * ```
 *
 * ##### Valid
 *
 * ```js
 * 1 + 1; // This is a valid comment
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * // This is an invalid comment
 * 1 + 1;
 * ```
*/

var assert = require('assert');

var isPragma = require('../utils').isPragma;

module.exports = function() {};

module.exports.prototype = {

    configure: function(options) {
        var validPositions = {
            'above': 'above',
            'beside': 'beside'
        };
        var allExcept = options.allExcept;
        assert(
            typeof options === 'object' && validPositions[options.position],
            this.getOptionName() + ' requires one of the following values: ' + Object.keys(validPositions).join(', ')
        );
        if (Array.isArray(allExcept)) {
            assert(
                allExcept.every(function(el) { return typeof el === 'string'; }),
                'Property `allExcept` in ' + allExcept + ' should be an array of strings'
            );
            this._isExcepted = isPragma(allExcept);
        } else {
            this._isExcepted  = isPragma();
        }
        this._position = options.position;
    },

    getOptionName: function() {
        return 'validateCommentPosition';
    },

    check: function(file, errors) {
        var position = this._position;
        var isExcepted = this._isExcepted;
        file.iterateTokensByType('Line', function(comment) {
            if (isExcepted(comment.value)) {
                return;
            }
            var firstToken = file.getFirstTokenOnLine(comment.loc.start.line, { includeComments: true });
            if (position === 'above' && !firstToken.isComment) {
                errors.add('Expected comments to be above the code not beside', comment.loc.start);
            }
            if (position === 'beside' && firstToken.isComment) {
                errors.add('Expected comments to be beside the code not above', comment.loc.start);
            }
        });
    }
};

},{"../utils":166,"assert":171}],156:[function(require,module,exports){
/**
 * Validates indentation for switch statements and block statements
 *
 * Types: `Integer`, `String` or `Object`
 *
 * Values:
 *  - `Integer`: A positive number of spaces
 *  - `String`: `"\t"` for tab indentation
 *  - `Object`:
 *     - `value`: (required) the same effect as the non-object values
 *     - `includeEmptyLines` (*deprecated*): (default: `false`) require empty lines to be indented
 *     - `'allExcept'` array of exceptions:
 *       - `'comments'` ignores comments
 *       - `'emptyLines'` ignore empty lines, included by default
 *
 * JSHint: [`indent`](http://jshint.com/docs/options/#indent)
 *
 * #### Example
 *
 * ```js
 * "validateIndentation": "\t"
 * ```
 *
 * ##### Valid example for mode `2`
 *
 * ```js
 * if (a) {
 *   b=c;
 *   function(d) {
 *     e=f;
 *   }
 * }
 * ```
 *
 * ##### Invalid example for mode `2`
 *
 * ```js
 * if (a) {
 *    b=c;
 * function(d) {
 *        e=f;
 * }
 * }
 * ```
 *
 * ##### Valid example for mode `"\t"`
 *
 * ```js
 * if (a) {
 *     b=c;
 *     function(d) {
 *         e=f;
 *     }
 * }
 * ```
 *
 * ##### Invalid example for mode `"\t"`
 *
 * ```js
 * if (a) {
 *      b=c;
 * function(d) {
 *            e=f;
 *  }
 * }
 * ```
 *
 * ##### Valid example for mode `{ "value": "\t", "includeEmptyLines": true }`
 * ```js
 * if (a) {
 *     b=c;
 *     function(d) {
 *         e=f;
 *     }
 *
 * } // single tab character on previous line
 * ```
 *
 * ##### Invalid example for mode `{ "value": "\t", "includeEmptyLines": true }`
 * ```js
 * if (a) {
 *     b=c;
 *     function(d) {
 *         e=f;
 *     }
 *
 * } // no tab character on previous line
 * ```
 *
 * ##### Valid example for mode `{ "value": "\t", "allExcept": ["comments"] }`
 * ```js
 * if (a) {
 *     b=c;
 * //    e=f
 * }
 * ```
 */

var assert = require('assert');
var utils = require('../utils');

var blockParents = [
    'IfStatement',
    'WhileStatement',
    'DoWhileStatement',
    'ForStatement',
    'ForInStatement',
    'ForOfStatement',
    'FunctionDeclaration',
    'FunctionExpression',
    'ArrowExpression',
    'CatchClause'
];

var indentableNodes = {
    BlockStatement: 'body',
    Program: 'body',
    ObjectExpression: 'properties',
    ArrayExpression: 'elements',
    SwitchStatement: 'cases',
    SwitchCase: 'consequent'
};

module.exports = function() {};

module.exports.prototype = {

    configure: function(options) {
        this._includeEmptyLines = false;
        this._exceptComments = false;

        if (typeof options === 'object') {
            this._includeEmptyLines = (options.includeEmptyLines === true);
            if (Array.isArray(options.allExcept)) {
                this._exceptComments = options.allExcept.indexOf('comments') > -1;
                this._includeEmptyLines = options.allExcept.indexOf('emptyLines') > -1;
            }

            options = options.value;
        }

        assert(
            options === '\t' ||
                (typeof options === 'number' && options > 0),
            this.getOptionName() + ' option requires a positive number of spaces or "\\t"' +
            ' or options object with "value" property'
        );

        if (typeof options === 'number') {
            this._indentChar = ' ';
            this._indentSize = options;
        } else {
            this._indentChar = '\t';
            this._indentSize = 1;
        }

        this._breakIndents = null;
        this._moduleIndents = null;
    },

    getOptionName: function() {
        return 'validateIndentation';
    },

    check: function(file, errors) {
        function markCheckLine(line) {
            linesToCheck[line].check = true;
        }

        function markCheck(node) {
            markCheckLine(node.loc.start.line - 1);
        }

        function markEndCheck(node) {
            markCheckLine(node.loc.end.line - 1);
        }

        function markPush(node, indents) {
            linesToCheck[node.loc.start.line - 1].push.push(indents);
        }

        function markPop(node, outdents) {
            linesToCheck[node.loc.end.line - 1].pop.push(outdents);
        }

        function markPushAlt(node) {
            linesToCheck[node.loc.start.line - 1].pushAltLine.push(node.loc.end.line - 1);
        }

        function markCase(caseNode, children) {
            var outdentNode = getCaseOutdent(children);

            if (outdentNode) {
                // If a case statement has a `break` as a direct child and it is the
                // first one encountered, use it as the example for all future case indentation
                if (_this._breakIndents === null) {
                    _this._breakIndents = (caseNode.loc.start.column === outdentNode.loc.start.column) ? 1 : 0;
                }
                markPop(outdentNode, _this._breakIndents);
            } else {
                markPop(caseNode, 0);
            }
        }

        function markChildren(node) {
            getChildren(node).forEach(function(childNode) {
                if (childNode.loc.start.line !== node.loc.start.line) {
                    markCheck(childNode);
                }
            });
        }

        function markKeyword(node) {
            if (node) {
                markCheck(file.getPrevToken(file.getFirstNodeToken(node)));
            }
        }

        function isMultiline(node) {
            return node.loc.start.line !== node.loc.end.line;
        }

        function getCaseOutdent(caseChildren) {
            var outdentNode;
            caseChildren.some(function(node) {
                if (node.type === 'BreakStatement') {
                    outdentNode = node;
                    return true;
                }
            });

            return outdentNode;
        }

        function getBlockNodeToPush(node) {
            var parent = node.parentNode;

            // The parent of an else is the entire if/else block. To avoid over indenting
            // in the case of a non-block if with a block else, mark push where the else starts,
            // not where the if starts!
            if (parent.type === 'IfStatement' && parent.alternate === node) {
                return node;
            }

            // The end line to check of a do while statement needs to be the location of the
            // closing curly brace, not the while statement, to avoid marking the last line of
            // a multiline while as a line to check.
            if (parent.type === 'DoWhileStatement') {
                return node;
            }

            // Detect bare blocks: a block whose parent doesn't expect blocks in its syntax specifically.
            if (blockParents.indexOf(parent.type) === -1) {
                return node;
            }

            return parent;
        }

        function getChildren(node) {
            var childrenProperty = indentableNodes[node.type];
            return node[childrenProperty];
        }

        function getIndentationFromLine(line) {
            var firstContent = line.search(rNotIndentChar);
            if (firstContent === -1) {
                firstContent = line.length;
            }
            return firstContent;
        }

        function checkIndentations() {
            var lineAugment = 0;

            linesToCheck.forEach(function(line, i) {
                var lineNumber = i + 1;
                var actualIndentation = line.indentation;
                var expectedIndentation = getExpectedIndentation(line, actualIndentation);

                // do not augment this line considering this line changes indentation
                if (line.pop.length || line.push.length) {
                    lineAugment = 0;
                }

                if (line.check) {
                    errors.assert.indentation({
                        lineNumber: lineNumber,
                        actual: actualIndentation,
                        expected: expectedIndentation,
                        indentChar: indentChar
                    });

                    // for multiline statements, we need move subsequent lines over the correct
                    // number of spaces to match the change made to the first line of the statement.
                    lineAugment = expectedIndentation - actualIndentation;

                    // correct the indentation so that future lines can be validated appropriately
                    actualIndentation = expectedIndentation;
                } else if (!line.empty) {
                    // in the case that we moved a previous line over a certain number spaces,
                    // we need to move this line over as well, but technically, it's not an error
                    errors.assert.indentation({
                        lineNumber: lineNumber,
                        actual: actualIndentation,
                        // Avoid going negative in the case that a previous line was overindented,
                        // and now outdenting a line that is already at column zero.
                        expected: Math.max(actualIndentation + lineAugment, 0),
                        indentChar: indentChar,
                        silent: true
                    });
                }

                if (line.push.length) {
                    pushExpectedIndentations(line, actualIndentation);
                }
            });
        }

        function getExpectedIndentation(line, actual) {
            var outdent = indentSize * Math.max.apply(null, line.pop);

            var idx = indentStack.length - 1;
            var expected = indentStack[idx];

            if (!Array.isArray(expected)) {
                expected = [expected];
            }

            expected = expected.map(function(value) {
                if (line.pop.length) {
                    value -= outdent;
                }

                return value;
            }).reduce(function(previous, current) {
                // when the expected is an array, resolve the value
                // back into a Number by checking both values are the actual indentation
                return actual === current ? current : previous;
            });

            indentStack[idx] = expected;

            line.pop.forEach(function() {
                indentStack.pop();
            });

            return expected;
        }

        function pushExpectedIndentations(line, actualIndentation) {
            var indents = Math.max.apply(null, line.push);

            var expected = actualIndentation + (indentSize * indents);

            // when a line has alternate indentations, push an array of possible values
            // on the stack, to be resolved when checked against an actual indentation
            if (line.pushAltLine.length) {
                expected = [expected];
                line.pushAltLine.forEach(function(altLine) {
                    expected.push(linesToCheck[altLine].indentation + (indentSize * indents));
                });
            }

            line.push.forEach(function() {
                indentStack.push(expected);
            });
        }

        function setModuleBody(node) {
            if (node.body.length !== 1 || node.body[0].type !== 'ExpressionStatement' ||
                node.body[0].expression.type !== 'CallExpression') {
                return;
            }

            var callExpression = node.body[0].expression;
            var callee = callExpression.callee;
            var callArgs = callExpression.arguments;
            var iffeFunction = utils.getFunctionNodeFromIIFE(callExpression);

            if (iffeFunction) {
                if (callArgs.length === 1 && callArgs[0].type === 'FunctionExpression') {
                    // detect UMD Shim, where the file body is the body of the factory,
                    // which is the sole argument to the IIFE
                    moduleBody = callArgs[0].body;
                } else {
                    // full file IIFE
                    moduleBody = iffeFunction.body;
                }
            }

            // detect require/define
            if (callee.type === 'Identifier' && callee.name.match(/^(require|define)$/)) {
                // the define callback is the *first* functionExpression encountered,
                // as it can be the first, second, or third argument.
                callArgs.some(function(argument) {
                    if (argument.type === 'FunctionExpression') {
                        moduleBody = argument.body;
                        return true;
                    }
                });
            }

            // set number of indents for modules by detecting
            // whether the first statement is indented or not
            if (moduleBody && moduleBody.body.length) {
                _this._moduleIndents = moduleBody.body[0].loc.start.column > 0 ? 1 : 0;
            }
        }

        function generateIndentations() {
            file.iterateNodesByType('Program', function(node) {
                if (!isMultiline(node)) {
                    return;
                }

                setModuleBody(node);
                markChildren(node);
            });

            file.iterateNodesByType('BlockStatement', function(node) {
                if (!isMultiline(node)) {
                    return;
                }

                var indents = node === moduleBody ? _this._moduleIndents : 1;

                markChildren(node);
                markPop(node, indents);
                markPush(getBlockNodeToPush(node), indents);
                markEndCheck(node);
            });

            file.iterateNodesByType('ObjectExpression', function(node) {
                if (!isMultiline(node)) {
                    return;
                }

                var children = getChildren(node);

                // only check objects that have children and that look like they are trying to adhere
                // to an indentation strategy, i.e. objects that have curly braces on their own lines.
                if (!children.length || node.loc.start.line === children[0].loc.start.line ||
                    node.loc.end.line === children[children.length - 1].loc.end.line) {
                    return;
                }

                markChildren(node);
                markPop(node, 1);
                markPush(node, 1);
                markEndCheck(node);
                markPushAlt(node);
            });

            file.iterateNodesByType('IfStatement', function(node) {
                markKeyword(node.alternate);
            });

            file.iterateNodesByType('TryStatement', function(node) {
                if (!isMultiline(node)) {
                    return;
                }

                var handler = node.handlers && node.handlers.length ? node.handlers[0] : node.handler;
                if (handler) {
                    markCheck(handler);
                }
                markKeyword(node.finalizer);
            });

            file.iterateNodesByType('SwitchStatement', function(node) {
                if (!isMultiline(node)) {
                    return;
                }

                var indents = 1;
                var children = getChildren(node);

                if (children.length < 1) {
                    return;
                }

                if (node.loc.start.column === children[0].loc.start.column) {
                    indents = 0;
                }

                markChildren(node);
                markPop(node, indents);
                markPush(node, indents);
                markEndCheck(node);
            });

            file.iterateNodesByType('SwitchCase', function(node) {
                if (!isMultiline(node)) {
                    return;
                }

                var children = getChildren(node);

                if (children.length === 1 && children[0].type === 'BlockStatement') {
                    return;
                }

                markPush(node, 1);
                markCheck(node);
                markChildren(node);

                markCase(node, children);
            });

            // indentations inside of function expressions can be offset from
            // either the start of the function or the end of the function, therefore
            // mark all starting lines of functions as potential indentations
            file.iterateNodesByType(['FunctionDeclaration', 'FunctionExpression'], function(node) {
                markPushAlt(node);
            });

            if (_this._includeEmptyLines) {
                linesToCheck.forEach(function(line) {
                    if (line.empty) {
                        line.check = true;
                    }
                });
            }

            if (!_this._exceptComments) {
                // starting from the bottom, which allows back to back comments to be checked, mark comments
                file.getComments().concat().reverse().forEach(function(node) {
                    var startLine = node.loc.start.line;
                    var firstToken = file.getFirstTokenOnLine(startLine, { includeComments: true });

                    var nextToken = file.getNextToken(firstToken, { includeComments: true });
                    var nextStartLine = nextToken.loc.start.line;

                    var nextLine = linesToCheck[nextStartLine - 1];

                    // ignore if not the only token on the line, or not right above another checked line
                    if (firstToken !== node || startLine === nextStartLine || !nextLine.check) {
                        return;
                    }

                    // ignore if next line is a case statement, which is kind of hacky, but avoids
                    // additional complexity for what qualifies as an outdent
                    if (nextToken && nextToken.type === 'Keyword' &&
                      (nextToken.value === 'case' || nextToken.value === 'default')) {
                        return;
                    }

                    // ignore if above a line that both introduces and ends an ident,
                    // which catches cases like a comment above an `else if`, but not nested ifs.
                    if (nextLine.push.length && nextLine.pop.length) {
                        return;
                    }

                    markCheck(node);
                });
            }
        }

        var _this = this;

        var moduleBody;

        var indentChar = this._indentChar;
        var indentSize = this._indentSize;
        var rNotIndentChar = new RegExp('[^' + indentChar + ']');

        var indentStack = [0];
        var linesToCheck = file.getLines().map(function(line) {
            return {
                push: [],
                pushAltLine: [],
                pop: [],
                check: false,
                indentation: getIndentationFromLine(line),
                empty: line.match(/^\s*$/)
            };
        });

        generateIndentations();
        checkIndentations();
    }

};

},{"../utils":166,"assert":171}],157:[function(require,module,exports){
/**
 * Option to check line break characters
 *
 * Types: `String`, `Object`
 *
 * Values:
 *  - `String`: setting this is the same as validating the rule using `{character: String, reportOncePerFile: false}`
 *  - `Object`:
 *      - `character`
 *          - `String` specifies the line break character that is allowed. (Values allowed: `"CR"`, `"LF"` or `"CRLF"`)
 *      - `reportOncePerFile`
 *          - `true` specifies that validation for the file should stop running upon encountering the first rule
 *            violation and return the details of that violation in the report
 *          - `false` specifies that all lines in the file should be validated with all rule violations captured in
 *            the final report
 *
 * #### Example
 *
 * ```js
 * "validateLineBreaks": "LF"
 * ```
 *
 * ##### Valid for mode `"LF"`
 * ```js
 * var x = 1;<LF>
 * x++;
 * ```
 *
 * ##### Invalid for mode `"LF"`
 * ```js
 * var x = 1;<CRLF>
 * x++;
 * ```
 */

var assert = require('assert');

module.exports = function() {};

module.exports.prototype = {

    configure: function(options) {
        assert(
            typeof options === 'string' || typeof options === 'object',
            this.getOptionName() + ' option requires string or object value'
        );

        if (typeof options === 'string') {
            options = { character: options };
        }

        var lineBreaks = {
            CR: '\r',
            LF: '\n',
            CRLF: '\r\n'
        };
        this._allowedLineBreak = lineBreaks[options.character];

        this._reportOncePerFile = options.reportOncePerFile !== false;
    },

    getOptionName: function() {
        return 'validateLineBreaks';
    },

    check: function(file, errors) {
        var lines = file.getLines();
        if (lines.length < 2) {
            return;
        }

        file.getLineBreaks().some(function(lineBreak, i) {
            if (lineBreak !== this._allowedLineBreak) {
                errors.add('Invalid line break', i + 1, lines[i].length);
                return this._reportOncePerFile;
            }
        }, this);
    }

};

},{"assert":171}],158:[function(require,module,exports){
/**
 * Requires each element in array on a single line when array length is more than passed maximum
 * number or array fills more than one line.
 *
 * Types: `Boolean`, `Integer`, `Object`
 *
 * Values:
 *  - `true`: setting this is the same as validating the rule using `{maximum: Infinity, ignoreBrackets: false}`
 *  - `Integer`: setting this is the same as validating the rule using `{maximum: Integer, ignoreBrackets: false}`
 *  - `Object`:
 *      - `maximum`
 *          - `Integer` specifies the maximum number of elements that a single line array can contain
 *      - `ignoreBrackets`
 *          - `true` specifies that the `[` and `]` brackets can be placed on the same line as the array elements
 *
 * #### Example
 *
 * ```js
 * "validateNewlineAfterArrayElements": {
 *   "maximum": 3
 * }
 * ```
 *
 * ##### Valid for mode `true`
 *
 * ```js
 * var x = [{a: 1}, [2], '3', 4, 5, 6];
 * var x = [
 *   {a: 1},
 *   [2],
 *   '3',
 *   4
 * ];
 * ```
 *
 * ##### Invalid for mode `true`
 *
 * ```js
 * var x = [1,
 *   2];
 * ```
 *
 * ##### Valid for mode `3`
 *
 * ```js
 * var x = [{a: 1}, [2], '3'];
 * var x = [
 *   1,
 *   2,
 *   3,
 *   4
 * ];
 * ```
 *
 * ##### Invalid for mode `3`
 *
 * ```js
 * var x = [1, 2, 3, 4];
 * var x = [1,
 *   2,
 *   3];
 * var x = [
 *     1, 2
 * ];
 * ```
 *
 * ##### Valid for mode `{maximum: 2, ignoreBrackets: true}`
 *
 * ```js
 * var x = [{a: 1}, [2]];
 * var x = [1,
 *   2,
 *   3];
 * ```
 *
 * ##### Invalid for mode `{maximum: 2, ignoreBrackets: true}`
 *
 * ```js
 * var x = [1, 2, 3];
 * var x = [1, 2,
 *   3];
 * var x = [1,
 *   2, 3];
 * ```
 */

var assert = require('assert');

module.exports = function() {};

module.exports.prototype = {
    configure: function(opts) {
        assert(
            opts === true ||
            typeof opts === 'number' && opts >= 1 ||
            typeof opts === 'object',
            this.getOptionName() + ' option requires maximal number of items ' +
                'or true value either should be removed'
        );
        if (typeof opts === 'object') {
            this._options = {
                maximum: Infinity,
                ignoreBrackets: false
            };

            if ('maximum' in opts) {
                assert(typeof opts.maximum === 'number' && opts.maximum >= 1,
                    'maximum property requires a positive number or should be removed');
                this._options.maximum = opts.maximum;
            }

            if ('ignoreBrackets' in opts) {
                assert(opts.ignoreBrackets === true,
                    'ignoreBrackets property requires true value or should be removed');
                this._options.ignoreBrackets = true;
            }
        } else {
            this._options = {
                maximum: opts === true ? Infinity : opts,
                ignoreBrackets: false
            };
        }
    },

    getOptionName: function() {
        return 'validateNewlineAfterArrayElements';
    },

    check: function(file, errors) {
        var maximum = this._options.maximum;
        var ignoreBrackets = this._options.ignoreBrackets;

        file.iterateNodesByType(['ArrayExpression'], function(node) {
            var els = node.elements;
            var firstEl = els[0];
            var lastEl = els[els.length - 1];
            var bracket;
            var elToken;

            if (els.length <= maximum && node.loc.start.line === node.loc.end.line) {
                return;
            }

            if (!ignoreBrackets) {
                if (firstEl && firstEl.loc.start.line === node.loc.start.line) {
                    bracket = file.getFirstNodeToken(node);
                    elToken = file.getNextToken(bracket);

                    errors.assert.differentLine({
                        token: bracket,
                        nextToken: elToken,
                        message: 'First element should be placed on new line'
                    });
                }
                if (lastEl && lastEl.loc.end.line === node.loc.end.line) {
                    bracket = file.getLastNodeToken(node);
                    elToken = file.getPrevToken(bracket);

                    errors.assert.differentLine({
                        token: elToken,
                        nextToken: bracket,
                        message: 'Closing bracket should be placed on new line'
                    });
                }
            }

            els.forEach(function(elem) {
                var elToken;
                var comma;

                if (!elem) {
                    // skip holes
                    return;
                }

                if (firstEl !== elem) {
                    elToken = file.getFirstNodeToken(elem);
                    comma = file.getPrevToken(elToken);

                    errors.assert.differentLine({
                        token: comma,
                        nextToken: elToken,
                        message: 'Multiple elements at a single line in multiline array'
                    });
                }
            });
        });
    }
};

},{"assert":171}],159:[function(require,module,exports){

/**
 * Validates the order in object keys.
 *
 * Types: `Boolean` or `String`
 *
 * Values:
 *  - `true` (alias to `asc`)
 *  - `"asc"`: requires sorting in ascending order
 *  - `"asc-insensitive"`: requires sorting in ascending order (case-insensitive)
 *  - `"asc-natural"`: requires sorting in ascending natural order
 *  - `"desc"`: requires sorting in descending order
 *  - `"desc-insensitive"`: requires sorting in descending order (case-insensitive)
 *  - `"desc-natural"`: requires sorting in descending natural order
 *
 * #### Example
 *
 * ```js
 * "validateOrderInObjectKeys": "asc"
 * ```
 *
 * ##### Valid
 *
 * ```js
 * var x = {
 *  x: 'foo',
 *  y: 'bar'
 * }
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * var x = {
 *  y: 'foo',
 *  x: 'bar'
 * }
 * ```
 */

var assert = require('assert');
var naturalSort = require('natural-compare');

/**
 * Sort in ascending order.
 */
function asc(a, b) {
    return String(a) < String(b) ? -1 : 1;
}

/**
 * Sort in ascending order (case-insensitive).
 */
function ascInsensitive(a, b) {
    var lowercaseA = String(a).toLowerCase();
    var lowercaseB = String(b).toLowerCase();

    if (lowercaseA < lowercaseB) {
        return -1;
    }

    if (lowercaseA > lowercaseB) {
        return 1;
    }

    return asc(a, b);
}

/**
 * Natural sort in ascending order.
 */
function ascNatural(a, b) {
    return naturalSort(a, b);
}

/**
 * Native sort in descending order.
 */
function desc(a, b) {
    return asc(a, b) * -1;
}

/**
 * Sort in descending order (case-insensitive).
 */
function descInsensitive(a, b) {
    return ascInsensitive(a, b) * -1;
}

/**
 * Native sort in descending order.
 */
function descNatural(a, b) {
    return naturalSort(a, b) * -1;
}

/**
 * Available sort methods.
 */
var methods = {
    asc: asc,
    'asc-insensitive': ascInsensitive,
    'asc-natural': ascNatural,
    desc: desc,
    'desc-insensitive': descInsensitive,
    'desc-natural': descNatural
};

module.exports = function() {};

module.exports.prototype = {

    configure: function(options) {
        assert(
            options === true || Object.keys(methods).indexOf(options) !== -1,
            this.getOptionName() + ' option requires a true value or should be removed'
        );

        this._sort = methods[options] || methods.asc;
    },

    getOptionName: function() {
        return 'validateOrderInObjectKeys';
    },

    check: function(file, errors) {
        var sort = this._sort;

        file.iterateNodesByType('ObjectExpression', function(node) {
            var keys = node.properties.map(function(property) {
                return (property.key.name || property.key.value);
            });

            var sorted = keys.slice(0).sort(sort);
            var unsorted;

            for (var i = 0; i < keys.length; i++) {
                if (keys[i] !== sorted[i]) {
                    unsorted = i;

                    break;
                }
            }

            if (undefined !== unsorted) {
                errors.add(
                    'Object keys must be in ' + (/asc/.test(sort.name) ? 'ascending' : 'descending') + ' order',
                    node.properties[unsorted].loc.start
                );
            }
        });
    }
};

},{"assert":171,"natural-compare":867}],160:[function(require,module,exports){
/**
 * Enable validation of separators between function parameters. Will ignore newlines.
 *
 * Type: `String`
 *
 * Values:
 *
 *  - `","`: function parameters are immediately followed by a comma
 *  - `", "`: function parameters are immediately followed by a comma and then a space
 *  - `" ,"`: function parameters are immediately followed by a space and then a comma
 *  - `" , "`: function parameters are immediately followed by a space, a comma, and then a space
 *
 * #### Example
 *
 * ```js
 * "validateParameterSeparator": ", "
 * ```
 *
 * ##### Valid
 *
 * ```js
 * function a(b, c) {}
 * ```
 *
 * ##### Invalid
 *
 * ```js
 * function a(b , c) {}
 * ```
 */

var assert = require('assert');

module.exports = function() {};

module.exports.prototype = {

    configure: function(options) {
        assert(
            typeof options === 'string' && /^[ ]?,[ ]?$/.test(options),
            this.getOptionName() + ' option requires string value containing only a comma and optional spaces'
        );

        this._separator = options;
    },

    getOptionName: function() {
        return 'validateParameterSeparator';
    },

    check: function(file, errors) {

        var separators = this._separator.split(',');
        var whitespaceBeforeComma = Boolean(separators.shift());
        var whitespaceAfterComma = Boolean(separators.pop());

        file.iterateNodesByType(['FunctionDeclaration', 'FunctionExpression'], function(node) {

            node.params.forEach(function(paramNode) {

                var prevParamToken = file.getFirstNodeToken(paramNode);
                var punctuatorToken = file.getNextToken(prevParamToken);

                if (punctuatorToken.value === ',') {

                    if (whitespaceBeforeComma) {
                        errors.assert.spacesBetween({
                            token: prevParamToken,
                            nextToken: punctuatorToken,
                            exactly: 1,
                            message: 'One space required after function parameter \'' + prevParamToken.value + '\''
                        });
                    } else {
                        errors.assert.noWhitespaceBetween({
                            token: prevParamToken,
                            nextToken: punctuatorToken,
                            message: 'Unexpected space after function parameter \'' + prevParamToken.value + '\''
                        });
                    }

                    var nextParamToken = file.getNextToken(punctuatorToken);

                    if (whitespaceAfterComma) {
                        errors.assert.spacesBetween({
                            token: punctuatorToken,
                            nextToken: nextParamToken,
                            exactly: 1,
                            message: 'One space required before function parameter \'' + nextParamToken.value + '\''
                        });
                    } else {
                        errors.assert.noWhitespaceBetween({
                            token: punctuatorToken,
                            nextToken: nextParamToken,
                            message: 'Unexpected space before function parameter \'' + nextParamToken.value + '\''
                        });
                    }
                }
            });
        });
    }

};

},{"assert":171}],161:[function(require,module,exports){
/**
 * Requires all quote marks to be either the supplied value, or consistent if `true`
 *
 * Types: `Boolean`, `String` or `Object`
 *
 * Values:
 *  - `"\""`: all strings require double quotes
 *  - `"'"`: all strings require single quotes
 *  - `true`: all strings require the quote mark first encountered in the source code
 *  - `Object`:
 *     - `escape`: allow the "other" quote mark to be used, but only to avoid having to escape
 *     - `mark`: the same effect as the non-object values
 *     - `ignoreJSX`: ignore JSX nodes
 *
 * JSHint: [`quotmark`](http://jshint.com/docs/options/#quotmark)
 *
 * #### Example
 *
 * ```js
 * "validateQuoteMarks": "\""
 * ```
 * ```js
 * "validateQuoteMarks": { "mark": "\"", "escape": true }
 * ```
 *
 * ##### Valid example for mode `{ "mark": "\"", "escape": true }`
 *
 * ```js
 * var x = "x";
 * var y = '"x"';
 * ```
 *
 * ##### Invalid example for mode `{ "mark": "\"", "escape": true }`
 *
 * ```js
 * var x = "x";
 * var y = 'x';
 * ```
 *
 * ##### Valid example for mode `{ "mark": "'", "escape": true, "ignoreJSX": true }`
 *
 * ```js
 * <div className="flex-card__header">{this.props.children}</div>;
 * ```
 *
 * ##### Valid example for mode `"\""` or mode `true`
 *
 * ```js
 * var x = "x";
 * ```
 *
 * ##### Valid example for mode `"'"` or mode `true`
 *
 * ```js
 * var x = 'x';
 * ```
 *
 * ##### Invalid example for mode `true`
 *
 * ```js
 * var x = "x", y = 'y';
 * ```
 */

var assert = require('assert');

module.exports = function() {};

module.exports.prototype = {

    configure: function(quoteMark) {
        this._allowEscape = false;
        this._ignoreJSX = false;

        if (typeof quoteMark === 'object') {
            assert(
                typeof quoteMark.escape === 'boolean' && quoteMark.mark !== undefined,
                this.getOptionName() + ' option requires the "escape" and "mark" property to be defined'
            );
            this._allowEscape = quoteMark.escape;

            if (quoteMark.ignoreJSX) {
                this._ignoreJSX = quoteMark.ignoreJSX;
            }

            quoteMark = quoteMark.mark;
        }

        assert(
            quoteMark === '"' || quoteMark === '\'' || quoteMark === true,
            this.getOptionName() + ' option requires \'"\', "\'", or boolean true'
        );

        assert(
            quoteMark === '"' || quoteMark === '\'' || quoteMark === true,
            this.getOptionName() + ' option requires \'"\', "\'", or boolean true'
        );

        this._quoteMark = quoteMark;
    },

    getOptionName: function() {
        return 'validateQuoteMarks';
    },

    check: function(file, errors) {
        var quoteMark = this._quoteMark;
        var allowEscape = this._allowEscape;
        var ignoreJSX = this._ignoreJSX;

        var opposite = {
            '"': '\'',
            '\'': '"'
        };
        file.iterateTokensByType('String', function(token) {
            if (
                ignoreJSX &&
                file.getNodeByRange(token.range[0]).parentNode.type === 'JSXAttribute'
            ) {
                return;
            }

            var str = token.value;
            var mark = str[0];
            var stripped = str.substring(1, str.length - 1);

            if (quoteMark === true) {
                quoteMark = mark;
            }

            if (mark !== quoteMark) {
                if (allowEscape && stripped.indexOf(opposite[mark]) > -1) {
                    return;
                }

                errors.cast({
                    message: 'Invalid quote mark found',
                    line: token.loc.start.line,
                    column: token.loc.start.column,
                    additional: token
                });
            }
        });
    },

    _fix: function(file, error) {
        var token = error.additional;
        var fixer = require(this._quoteMark === '"' ? 'to-double-quotes' : 'to-single-quotes');

        token.value = fixer(token.value);
    }
};

},{"assert":171}],162:[function(require,module,exports){
var esprima = require('esprima');
var babelJscs = require('babel-jscs');
var Errors = require('./errors');
var JsFile = require('./js-file');
var Configuration = require('./config/configuration');

var MAX_FIX_ATTEMPTS = 5;

function getInternalErrorMessage(rule, e) {
    return 'Error running rule ' + rule + ': ' +
        'This is an issue with JSCS and not your codebase.\n' +
        'Please file an issue (with the stack trace below) at: ' +
        'https://github.com/jscs-dev/node-jscs/issues/new\n' + e;
}

/**
 * Starts Code Style checking process.
 *
 * @name StringChecker
 */
var StringChecker = function() {
    this._configuredRules = [];

    this._errorsFound = 0;
    this._maxErrorsExceeded = false;

    // Need to be defined here because Configuration module can choose
    // custom esprima or chose parsers based on "esnext" option
    this._esprima = esprima;

    this._configuration = this._createConfiguration();
    this._configuration.registerDefaultPresets();
};

StringChecker.prototype = {
    /**
     * Registers single Code Style checking rule.
     *
     * @param {Rule} rule
     */
    registerRule: function(rule) {
        this._configuration.registerRule(rule);
    },

    /**
     * Registers built-in Code Style checking rules.
     */
    registerDefaultRules: function() {
        this._configuration.registerDefaultRules();
    },

    /**
     * Get processed config.
     *
     * @return {Object}
     */
    getProcessedConfig: function() {
        return this._configuration.getProcessedConfig();
    },

    /**
     * Loads configuration from JS Object. Activates and configures required rules.
     *
     * @param {Object} config
     */
    configure: function(config) {
        this._configuration.load(config);

        if (this._configuration.hasCustomEsprima()) {
            this._esprima = this._configuration.getCustomEsprima();
        } else if (this._configuration.isESNextEnabled()) {
            this._esprima = babelJscs;
        }

        this._verbose = this._configuration.getVerbose();

        this._configuredRules = this._configuration.getConfiguredRules();
        this._maxErrors = this._configuration.getMaxErrors();
    },

    /**
     * Checks file provided with a string.
     *
     * @param {String} source
     * @param {String} [filename='input']
     * @returns {Errors}
     */
    checkString: function(source, filename) {
        filename = filename || 'input';

        var file = this._createJsFileInstance(filename, source);

        var errors = new Errors(file, this._verbose);

        file.getParseErrors().forEach(function(parseError) {
            if (!this._maxErrorsExceeded) {
                this._addParseError(errors, parseError);
            }
        }, this);

        // Do not check empty strings
        if (file.getFirstToken({includeComments: true}).type === 'EOF') {
            return errors;
        }

        this._checkJsFile(file, errors);

        return errors;
    },

    /**
     * Fix provided error.
     *
     * @param {JsFile} file
     * @param {Errors} errors
     * @protected
     */
    _fixJsFile: function(file, errors) {
        var list = errors.getErrorList();
        var configuration = this.getConfiguration();

        list.forEach(function(error) {
            if (error.fixed) {
                return;
            }

            var instance = configuration.getConfiguredRule(error.rule);

            if (instance && instance._fix) {
                try {

                    // "error.fixed = true" should go first, so rule can
                    // decide for itself (with "error.fixed = false")
                    // if it can fix this particular error
                    error.fixed = true;
                    instance._fix(file, error);

                } catch (e) {
                    error.fixed = undefined;
                    errors.add(getInternalErrorMessage(error.rule, e), 1, 0);
                }
            }
        });
    },

    /**
     * Checks a file specified using JsFile instance.
     * Fills Errors instance with validation errors.
     *
     * @param {JsFile} file
     * @param {Errors} errors
     * @protected
     */
    _checkJsFile: function(file, errors) {
        if (this._maxErrorsExceeded) {
            return;
        }

        var errorFilter = this._configuration.getErrorFilter();

        this._configuredRules.forEach(function(rule) {
            errors.setCurrentRule(rule.getOptionName());

            try {
                rule.check(file, errors);
            } catch (e) {
                errors.setCurrentRule('internalError');
                errors.add(getInternalErrorMessage(rule.getOptionName(), e.stack), 1, 0);
            }
        }, this);

        this._configuration.getUnsupportedRuleNames().forEach(function(rulename) {
            errors.add('Unsupported rule: ' + rulename, 1, 0);
        });

        // sort errors list to show errors as they appear in source
        errors.getErrorList().sort(function(a, b) {
            return (a.line - b.line) || (a.column - b.column);
        });

        if (errorFilter) {
            errors.filter(errorFilter);
        }

        if (this.maxErrorsEnabled()) {
            if (this._maxErrors === -1 || this._maxErrors === null) {
                this._maxErrorsExceeded = false;

            } else {
                this._maxErrorsExceeded = this._errorsFound + errors.getErrorCount() > this._maxErrors;
                errors.stripErrorList(Math.max(0, this._maxErrors - this._errorsFound));
            }
        }

        this._errorsFound += errors.getErrorCount();
    },

    /**
     * Adds parse error to the error list.
     *
     * @param {Errors} errors
     * @param {Error} parseError
     * @private
     */
    _addParseError: function(errors, parseError) {
        if (this._maxErrorsExceeded) {
            return;
        }

        errors.setCurrentRule('parseError');
        errors.add(parseError.description, parseError.lineNumber, parseError.column);

        if (this.maxErrorsEnabled()) {
            this._errorsFound += 1;
            this._maxErrorsExceeded = this._errorsFound >= this._maxErrors;
        }
    },

    /**
     * Creates configured JsFile instance.
     *
     * @param {String} filename
     * @param {String} source
     * @private
     */
    _createJsFileInstance: function(filename, source) {
        return new JsFile({
            filename: filename,
            source: source,
            esprima: this._esprima,
            esprimaOptions: this._configuration.getEsprimaOptions(),
            es3: this._configuration.isES3Enabled(),
            es6: this._configuration.isESNextEnabled()
        });
    },

    /**
     * Checks file provided with a string.
     *
     * @param {String} source
     * @param {String} [filename='input']
     * @returns {{output: String, errors: Errors}}
     */
    fixString: function(source, filename) {
        filename = filename || 'input';

        var file = this._createJsFileInstance(filename, source);
        var errors = new Errors(file, this._verbose);

        var parseErrors = file.getParseErrors();
        if (parseErrors.length > 0) {
            parseErrors.forEach(function(parseError) {
                this._addParseError(errors, parseError);
            }, this);

            return {output: source, errors: errors};
        } else {
            var attempt = 0;
            do {
                // Changes to current sources are made in rules through assertions.
                this._checkJsFile(file, errors);

                // If assertions weren't used but rule has "fix" method,
                // which we could use.
                this._fixJsFile(file, errors);

                var hasFixes = errors.getErrorList().some(function(err) {
                    return err.fixed;
                });

                if (!hasFixes) {
                    break;
                }

                file = this._createJsFileInstance(filename, file.render());
                errors = new Errors(file, this._verbose);
                attempt++;
            } while (attempt < MAX_FIX_ATTEMPTS);

            return {output: file.getSource(), errors: errors};
        }
    },

    /**
     * Returns `true` if max erros limit is enabled.
     *
     * @returns {Boolean}
     */
    maxErrorsEnabled: function() {
        return this._maxErrors !== null && this._maxErrors !== -1;
    },

    /**
     * Returns `true` if error count exceeded `maxErrors` option value.
     *
     * @returns {Boolean}
     */
    maxErrorsExceeded: function() {
        return this._maxErrorsExceeded;
    },

    /**
     * Returns new configuration instance.
     *
     * @protected
     * @returns {Configuration}
     */
    _createConfiguration: function() {
        return new Configuration();
    },

    /**
     * Returns current configuration instance.
     *
     * @returns {Configuration}
     */
    getConfiguration: function() {
        return this._configuration;
    },

    /**
     * Returns the current esprima parser
     *
     * @return {Esprima}
     */
    getEsprima: function() {
        return this._esprima || this._configuration.getCustomEsprima();
    }
};

module.exports = StringChecker;

},{"./config/configuration":1,"./errors":2,"./js-file":3,"babel-jscs":362,"esprima":683}],163:[function(require,module,exports){
var utils = require('util');
var EventEmitter = require('events').EventEmitter;

/**
 * Token assertions class.
 *
 * @name {TokenAssert}
 * @param {JsFile} file
 */
function TokenAssert(file) {
    EventEmitter.call(this);

    this._file = file;
}

utils.inherits(TokenAssert, EventEmitter);

/**
 * Requires to have whitespace between specified tokens. Ignores newlines.
 *
 * @param {Object} options
 * @param {Object} options.token
 * @param {Object} options.nextToken
 * @param {String} [options.message]
 * @param {Number} [options.spaces] Amount of spaces between tokens.
 */
TokenAssert.prototype.whitespaceBetween = function(options) {
    options.atLeast = 1;
    this.spacesBetween(options);
};

/**
 * Requires to have no whitespace between specified tokens.
 *
 * @param {Object} options
 * @param {Object} options.token
 * @param {Object} options.nextToken
 * @param {String} [options.message]
 * @param {Boolean} [options.disallowNewLine=false]
 */
TokenAssert.prototype.noWhitespaceBetween = function(options) {
    options.exactly = 0;
    this.spacesBetween(options);
};

/**
 * Requires to have the whitespace between specified tokens with the provided options.
 *
 * @param {Object} options
 * @param {Object} options.token
 * @param {Object} options.nextToken
 * @param {String} [options.message]
 * @param {Object} [options.atLeast] At least how many spaces the tokens are apart
 * @param {Object} [options.atMost] At most how many spaces the tokens are apart
 * @param {Object} [options.exactly] Exactly how many spaces the tokens are apart
 * @param {Boolean} [options.disallowNewLine=false]
 */
TokenAssert.prototype.spacesBetween = function(options) {
    var token = options.token;
    var nextToken = options.nextToken;
    var atLeast = options.atLeast;
    var atMost = options.atMost;
    var exactly = options.exactly;

    if (!token || !nextToken) {
        return;
    }

    this._validateOptions(options);

    if (!options.disallowNewLine && token.loc.end.line !== nextToken.loc.start.line) {
        return;
    }

    // Only attempt to remove or add lines if there are no comments between the two nodes
    // as this prevents accidentally moving a valid token onto a line comment ed line
    var fixed = this._file.getNextToken(options.token, {
        includeComments: true
    }) === nextToken;

    var emitError = function(countPrefix, spaceCount) {
        if (fixed) {
            this._file.setWhitespaceBefore(nextToken, new Array(spaceCount + 1).join(' '));
        }

        var msgPostfix = token.value + ' and ' + nextToken.value;

        if (!options.message) {
            if (exactly === 0) {
                // support noWhitespaceBetween
                options.message = 'Unexpected whitespace between ' + msgPostfix;
            } else if (exactly !== undefined) {
                // support whitespaceBetween (spaces option)
                options.message = spaceCount + ' spaces required between ' + msgPostfix;
            } else if (atLeast === 1 && atMost === undefined) {
                // support whitespaceBetween (no spaces option)
                options.message = 'Missing space between ' + msgPostfix;
            } else {
                options.message = countPrefix + ' ' + spaceCount + ' spaces required between ' + msgPostfix;
            }
        }

        this.emit('error', {
            message: options.message,
            line: token.loc.end.line,
            column: token.loc.end.column,
            fixed: fixed
        });
    }.bind(this);

    var spacesBetween = Math.abs(nextToken.range[0] - token.range[1]);
    if (atLeast !== undefined && spacesBetween < atLeast) {
        emitError('at least', atLeast);
    } else if (atMost !== undefined && spacesBetween > atMost) {
        emitError('at most', atMost);
    } else if (exactly !== undefined && spacesBetween !== exactly) {
        emitError('exactly', exactly);
    }
};

/**
 * Requires the specified line to have the expected indentation.
 *
 * @param {Object} options
 * @param {Number} options.lineNumber
 * @param {Number} options.actual
 * @param {Number} options.expected
 * @param {String} options.indentChar
 * @param {Boolean} [options.silent] if true, will suppress error emission but still fix whitespace
 */
TokenAssert.prototype.indentation = function(options) {
    var lineNumber = options.lineNumber;
    var actual = options.actual;
    var expected = options.expected;
    var indentChar = options.indentChar;

    if (actual === expected) {
        return;
    }

    if (!options.silent) {
        this.emit('error', {
            message: 'Expected indentation of ' + expected + ' characters',
            line: lineNumber,
            column: expected,
            fixed: true
        });
    }

    var token = this._file.getFirstTokenOnLine(lineNumber, {
        includeComments: true
    });
    var newWhitespace = (new Array(expected + 1)).join(indentChar);

    if (!token) {
        this._setEmptyLineIndentation(lineNumber, newWhitespace);
        return;
    }

    this._updateWhitespaceByLine(token, function(lines) {
        lines[lines.length - 1] = newWhitespace;

        return lines;
    });

    if (token.isComment) {
        this._updateCommentWhitespace(token, indentChar, actual, expected);
    }
};

/**
 * Updates the whitespace of a line by passing split lines to a callback function
 * for editing.
 *
 * @param  {Object} token
 * @param  {Function} callback
 */
TokenAssert.prototype._updateWhitespaceByLine = function(token, callback) {
    var lineBreak = this._file.getLineBreakStyle();
    var lines = this._file.getWhitespaceBefore(token).split(/\r\n|\r|\n/);

    lines = callback(lines);
    this._file.setWhitespaceBefore(token, lines.join(lineBreak));
};

/**
 * Updates the whitespace of a line by passing split lines to a callback function
 * for editing.
 *
 * @param  {Object} token
 * @param  {Function} indentChar
 * @param  {Number} actual
 * @param  {Number} expected
 */
TokenAssert.prototype._updateCommentWhitespace = function(token, indentChar, actual, expected) {
    var difference = expected - actual;
    var tokenLines = token.value.split(/\r\n|\r|\n/);
    var i = 1;
    if (difference >= 0) {
        var lineWhitespace = (new Array(difference + 1)).join(indentChar);
        for (; i < tokenLines.length; i++) {
            tokenLines[i] = tokenLines[i] === '' ? '' : lineWhitespace + tokenLines[i];
        }
    } else {
        for (; i < tokenLines.length; i++) {
            tokenLines[i] = tokenLines[i].substring(-difference);
        }
    }

    token.value = tokenLines.join(this._file.getLineBreakStyle());
};

/**
 * Fixes the indentation of a line that has no tokens on it
 *
 * @param  {Number} lineNumber
 * @param  {String} newWhitespace
 */
TokenAssert.prototype._setEmptyLineIndentation = function(lineNumber, newWhitespace) {
    var token;
    do {
        token = this._file.getFirstTokenOnLine(++lineNumber, {
            includeComments: true
        });
    } while (!token);

    this._updateWhitespaceByLine(token, function(lines) {
        if (lines[0] !== '') {
            lines[0] = newWhitespace;
        }

        for (var i = 1; i < lines.length; i++) {
            lines[i] = newWhitespace;
        }

        return lines;
    });
};

/**
 * Requires tokens to be on the same line.
 *
 * @param {Object} options
 * @param {Object} options.token
 * @param {Object} options.nextToken
 * @param {Boolean} [options.stickToPreviousToken]
 * @param {String} [options.message]
 */
TokenAssert.prototype.sameLine = function(options) {
    options.exactly = 0;

    this.linesBetween(options);
};

/**
 * Requires tokens to be on different lines.
 *
 * @param {Object} options
 * @param {Object} options.token
 * @param {Object} options.nextToken
 * @param {Object} [options.message]
 */
TokenAssert.prototype.differentLine = function(options) {
    options.atLeast = 1;

    this.linesBetween(options);
};

/**
 * Requires tokens to have a certain amount of lines between them.
 * Set at least one of atLeast or atMost OR set exactly.
 *
 * @param {Object} options
 * @param {Object} options.token
 * @param {Object} options.nextToken
 * @param {Object} [options.message]
 * @param {Object} [options.atLeast] At least how many lines the tokens are apart
 * @param {Object} [options.atMost] At most how many lines the tokens are apart
 * @param {Object} [options.exactly] Exactly how many lines the tokens are apart
 * @param {Boolean} [options.stickToPreviousToken] When auto-fixing stick the
 *     nextToken onto the previous token.
 */
TokenAssert.prototype.linesBetween = function(options) {
    var token = options.token;
    var nextToken = options.nextToken;
    var atLeast = options.atLeast;
    var atMost = options.atMost;
    var exactly = options.exactly;

    if (!token || !nextToken) {
        return;
    }

    this._validateOptions(options);

    // Only attempt to remove or add lines if there are no comments between the two nodes
    // as this prevents accidentally moving a valid token onto a line comment ed line
    var fixed = this._file.getNextToken(options.token, {
        includeComments: true
    }) === nextToken;

    var linesBetween = Math.abs(token.loc.end.line - nextToken.loc.start.line);

    var emitError = function(countPrefix, lineCount) {
        var msgPrefix = token.value + ' and ' + nextToken.value;

        if (!options.message) {
            if (exactly === 0) {
                // support sameLine
                options.message = msgPrefix + ' should be on the same line';
            } else if (atLeast === 1 && atMost === undefined) {
                // support differentLine
                options.message = msgPrefix + ' should be on different lines';
            } else {
                // support linesBetween
                options.message = msgPrefix + ' should have ' + countPrefix + ' ' + lineCount + ' line(s) between them';
            }
        }

        if (fixed) {
            this._augmentLineCount(options, lineCount);
        }

        this.emit('error', {
            message: options.message,
            line: token.loc.end.line,
            column: token.loc.end.column,
            fixed: fixed
        });
    }.bind(this);

    if (atLeast !== undefined && linesBetween < atLeast) {
        emitError('at least', atLeast);
    } else if (atMost !== undefined && linesBetween > atMost) {
        emitError('at most', atMost);
    } else if (exactly !== undefined && linesBetween !== exactly) {
        emitError('exactly', exactly);
    }
};

/**
 * Throws errors if atLeast, atMost, and exactly options don't mix together properly or
 * if the tokens provided are equivalent.
 *
 * @param {Object} options
 * @param {Object} options.token
 * @param {Object} options.nextToken
 * @param {Object} [options.atLeast] At least how many spaces the tokens are apart
 * @param {Object} [options.atMost] At most how many spaces the tokens are apart
 * @param {Object} [options.exactly] Exactly how many spaces the tokens are apart
 * @throws {Error} If the options are non-sensical
 */
TokenAssert.prototype._validateOptions = function(options) {
    var token = options.token;
    var nextToken = options.nextToken;
    var atLeast = options.atLeast;
    var atMost = options.atMost;
    var exactly = options.exactly;

    if (token === nextToken) {
        throw new Error('You cannot specify the same token as both token and nextToken');
    }

    if (atLeast === undefined &&
        atMost === undefined &&
        exactly === undefined) {
        throw new Error('You must specify at least one option');
    }

    if (exactly !== undefined && (atLeast !== undefined || atMost !== undefined)) {
        throw new Error('You cannot specify atLeast or atMost with exactly');
    }

    if (atLeast !== undefined && atMost !== undefined && atMost < atLeast) {
        throw new Error('atLeast and atMost are in conflict');
    }
};

/**
 * Augments token whitespace to contain the correct number of newlines while preserving indentation
 *
 * @param {Object} options
 * @param {Object} options.nextToken
 * @param {Boolean} [options.stickToPreviousToken]
 * @param {Number} lineCount
 */
TokenAssert.prototype._augmentLineCount = function(options, lineCount) {
    var token = options.nextToken;
    if (lineCount === 0) {
        if (options.stickToPreviousToken) {
            var nextToken = this._file.getNextToken(token, {
                includeComments: true
            });
            this._file.setWhitespaceBefore(nextToken, this._file.getWhitespaceBefore(token));
        }

        this._file.setWhitespaceBefore(token, ' ');
        return;
    }

    this._updateWhitespaceByLine(token, function(lines) {
        var currentLineCount = lines.length;
        var lastLine = lines[lines.length - 1];

        if (currentLineCount <= lineCount) {
            // add additional lines that maintain the same indentation as the former last line
            for (; currentLineCount <= lineCount; currentLineCount++) {
                lines[lines.length - 1] = '';
                lines.push(lastLine);
            }
        } else {
            // remove lines and then ensure that the new last line maintains the previous indentation
            lines = lines.slice(0, lineCount + 1);
            lines[lines.length - 1] = lastLine;
        }

        return lines;
    });
};

/**
 * Requires specific token before given.
 *
 * @param {Object} options
 * @param {Object} options.token
 * @param {Object} options.expectedTokenBefore
 * @param {String} [options.message]
 */
TokenAssert.prototype.tokenBefore = function(options) {
    var token = options.token;
    var actualTokenBefore = this._file.getPrevToken(token);
    var expectedTokenBefore = options.expectedTokenBefore;

    if (!actualTokenBefore) {
        this.emit('error', {
            message: expectedTokenBefore.value + ' was expected before ' + token.value + ' but document start found',
            line: token.loc.start.line,
            column: token.loc.start.column
        });
        return;
    }

    // Only attempt to remove or add lines if there are no comments between the two nodes
    // as this prevents accidentally moving a valid token onto a line comment ed line
    var fixed = this._file.getPrevToken(options.token, {includeComments: true}) === actualTokenBefore;

    if (
        actualTokenBefore.type !== expectedTokenBefore.type ||
        actualTokenBefore.value !== expectedTokenBefore.value
    ) {

        if (fixed) {
            this._file.setWhitespaceBefore(token, expectedTokenBefore.value + this._file.getWhitespaceBefore(token));
        }

        var message = options.message;
        if (!message) {
            var showTypes = expectedTokenBefore.value === actualTokenBefore.value;
            message =
                expectedTokenBefore.value + (showTypes ? ' (' + expectedTokenBefore.type + ')' : '') +
                ' was expected before ' + token.value +
                ' but ' + actualTokenBefore.value + (showTypes ? ' (' + actualTokenBefore.type + ')' : '') + ' found';
        }

        this.emit('error', {
            message: message,
            line: actualTokenBefore.loc.end.line,
            column: actualTokenBefore.loc.end.column,
            fixed: fixed
        });
    }
};
/**
 * Disallows specific token before given.
 *
 * @param {Object} options
 * @param {Object} options.token
 * @param {Object} options.expectedTokenBefore
 * @param {String} [options.message]
 */
TokenAssert.prototype.noTokenBefore = function(options) {
    var token = options.token;
    var actualTokenBefore = this._file.getPrevToken(token);
    if (!actualTokenBefore) {
        // document start
        return;
    }

    var fixed = this._file.getPrevToken(options.token, {
        includeComments: true
    }) === actualTokenBefore;

    var expectedTokenBefore = options.expectedTokenBefore;
    if (actualTokenBefore.type === expectedTokenBefore.type &&
        actualTokenBefore.value === expectedTokenBefore.value
    ) {

        if (fixed) {
            actualTokenBefore.value = '';
        }

        this.emit('error', {
            message: options.message || 'Illegal ' + expectedTokenBefore.value + ' was found before ' + token.value,
            line: actualTokenBefore.loc.end.line,
            column: actualTokenBefore.loc.end.column,
            fixed: fixed
        });
    }
};

module.exports = TokenAssert;

},{"events":695,"util":946}],164:[function(require,module,exports){
var assert = require('assert');

var FUNCTION_TYPE_RE = /Function/;
var PAREN_KEYWORD_TYPE_RE = /Statement$|^CatchClause$/;
var NO_PAREN_KEYWORD_TYPE_RE = /^ExpressionStatement$|^ReturnStatement$|^ThrowStatement$/;
var QUASI_STATEMENT_TYPE_RE = /Statement$|Declaration$/;

/**
 * Returns the type of AST node or ECMAScript production in which the provided
 * open parenthesis token is included.
 *
 * @param {Object} token
 * @param {JsFile} file
 * @returns {String}
 */
exports.categorizeOpenParen = function(token, file) {
    assert(token.value === '(', 'Input token must be a parenthesis');
    var node = file.getNodeByRange(token.range[0]);
    var nodeType = node.type;
    var prevToken = file.getPrevToken(token);

    // Outermost grouping parenthesis
    if (!prevToken) {
        return 'ParenthesizedExpression';
    }

    // Part of a parentheses-bearing statement (if, with, while, switch, etc.)
    if (prevToken.type === 'Keyword' && PAREN_KEYWORD_TYPE_RE.test(nodeType) &&
        !NO_PAREN_KEYWORD_TYPE_RE.test(nodeType)) {

        return 'Statement';
    }

    // Part of a function definition (declaration, expression, method, etc.)
    if (FUNCTION_TYPE_RE.test(nodeType) &&

        // Name is optional for function expressions
        (prevToken.type === 'Identifier' || prevToken.value === 'function')) {

        return 'Function';
    }

    // Part of a call expression
    var prevNode = file.getNodeByRange(prevToken.range[0]);
    if ((nodeType === 'CallExpression' || nodeType === 'NewExpression') &&

        // Must not be inside an arguments list or other grouping parentheses
        prevToken.value !== ',' && prevToken.value !== '(' &&

        // If the callee is parenthesized (e.g., `(foo.bar)()`), prevNode will match node
        // Otherwise (e.g., `foo.bar()`), prevToken must be the last token of the callee node
        (prevNode === node || prevToken === file.getLastNodeToken(node.callee))) {

        return 'CallExpression';
    }

    // All remaining cases are grouping parentheses
    return 'ParenthesizedExpression';
};

/**
 * Returns the type of AST node or ECMAScript production in which the provided
 * close parenthesis token is included.
 *
 * @param {Object} token
 * @param {JsFile} file
 * @returns {String}
 */
exports.categorizeCloseParen = function(token, file) {
    assert(token.value === ')', 'Input token must be a parenthesis');
    var node = file.getNodeByRange(token.range[0]);
    var nodeType = node.type;
    var nextToken = file.getNextToken(token);

    // Terminal statement
    if (nextToken.type === 'EOF') {
        switch (nodeType) {
            case 'DoWhileStatement':
                return 'Statement';
            case 'CallExpression':
            case 'NewExpression':
                return 'CallExpression';
            default:
                return 'ParenthesizedExpression';
        }
    }

    // Part of a parentheses-bearing statement (if, with, while, switch, etc.)
    if (PAREN_KEYWORD_TYPE_RE.test(nodeType) && !NO_PAREN_KEYWORD_TYPE_RE.test(nodeType)) {
        // Closing parentheses for `switch` and `catch` must be followed by "{"
        // Closing parentheses for `do..while` may be the last punctuation inside a block
        if (nextToken.value === '{' || nextToken.value === '}') {
            return 'Statement';
        }

        // Closing parentheses for other statements must be followed by a statement or declaration
        var nextNode = file.getNodeByRange(nextToken.range[0]);
        while (nextNode.range[0] >= token.range[1]) {
            if (QUASI_STATEMENT_TYPE_RE.test(nextNode.type)) {
                return 'Statement';
            }
            nextNode = nextNode.parentNode;
        }
    }

    // Part of a function definition (declaration, expression, method, etc.)
    if (nextToken.value === '{' && FUNCTION_TYPE_RE.test(nodeType)) {
        return 'Function';
    }

    // Part of a call expression
    if ((nodeType === 'CallExpression' || nodeType === 'NewExpression') &&
        nextToken.range[0] >= node.range[1]) {

        return 'CallExpression';
    }

    // All remaining cases are grouping parentheses
    return 'ParenthesizedExpression';
};

},{"assert":171}],165:[function(require,module,exports){
var estraverse = require('estraverse');
var assign = require('lodash').assign;
var VISITOR_KEYS = require('./visitor-keys');

var keys = assign({}, VISITOR_KEYS, estraverse.VisitorKeys, {
    // These are deprecated, need to remove it in the future
    XJSIdentifier: [],
    XJSNamespacedName: ['namespace', 'name'],
    XJSMemberExpression: ['object', 'property'],
    XJSEmptyExpression: [],
    XJSExpressionContainer: ['expression'],
    XJSElement: ['openingElement', 'closingElement', 'children'],
    XJSClosingElement: ['name'],
    XJSOpeningElement: ['name', 'attributes'],
    XJSAttribute: ['name', 'value'],
    XJSSpreadAttribute: ['argument'],
    XJSText: null,

    // babel-core extends the estraverse "VisitorKeys" property with old TryStatement path
    // We need to revert it back
    TryStatement: ['block', 'handler', 'finalizer']
});

module.exports.iterate = function iterate(node, cb) {
    if ('type' in node) {
        estraverse.traverse(node, {
            enter: function(node, parent) {
                var parentCollection = [];

                // parentCollection support
                var path = this.path();
                if (path) {
                    var collectionKey;
                    while (path.length > 0) {
                        var pathElement = path.pop();
                        if (typeof pathElement === 'string') {
                            collectionKey = pathElement;
                            break;
                        }
                    }

                    parentCollection = parent[collectionKey];
                    if (!Array.isArray(parentCollection)) {
                        parentCollection = [parentCollection];
                    }
                }

                if (cb(node, parent, parentCollection) === false) {
                    return estraverse.VisitorOption.Skip;
                }
            },
            keys: keys
        });
    }
};

},{"./visitor-keys":167,"estraverse":688,"lodash":761}],166:[function(require,module,exports){
var path = require('path');
var Vow = require('vow');
var reservedWords = require('reserved-words');

var IDENTIFIER_NAME_ES5_RE = require('../patterns/identifiers-ES5');
var IDENTIFIER_NAME_ES6_RE = require('../patterns/identifiers-ES6');

var TRAILING_UNDERSCORES_RE = /(^_+|_+$)/g;

var SNAKE_CASE_RE = /^([a-z$][a-z0-9$]+)(_[a-z0-9$]+)+$/i;

/**
 * All keywords where spaces are a stylistic choice
 * @type {Array}
 */
exports.spacedKeywords = [
    'do',
    'for',
    'if',
    'else',
    'switch',
    'case',
    'try',
    'catch',
    'finally',
    'void',
    'while',
    'with',
    'return',
    'typeof',
    'function'
];

/**
 * All keywords where curly braces are a stylistic choice
 * @type {Array}
 */
exports.curlyBracedKeywords = [
    'if',
    'else',
    'for',
    'while',
    'do',
    'case',
    'default',
    'with'
];

/**
 * Returns true if name is valid identifier name.
 *
 * @param {String} name
 * @param {String} dialect
 * @returns {Boolean}
 */
exports.isValidIdentifierName = function(name, dialect) {
    dialect = dialect || 'es5';
    var identifierRegex = dialect === 'es5' ? IDENTIFIER_NAME_ES5_RE : IDENTIFIER_NAME_ES6_RE;
    return !reservedWords.check(name, dialect, true) && identifierRegex.test(name);
};

/**
 * Snake case tester
 *
 * @param {String} name
 * @return {Boolean}
 */
exports.isSnakeCased = function(name) {
    return SNAKE_CASE_RE.test(name);
};

/**
 * Returns the function expression node if the provided node is an IIFE,
 * otherwise returns null.
 *
 * @param  {Object} node
 * @return {?Object}
 */
exports.getFunctionNodeFromIIFE = function(node) {
    if (node.type !== 'CallExpression') {
        return null;
    }

    var callee = node.callee;

    if (callee.type === 'FunctionExpression') {
        return callee;
    }

    if (callee.type === 'MemberExpression' &&
        callee.object.type === 'FunctionExpression' &&
        callee.property.type === 'Identifier' &&
        (callee.property.name === 'call' || callee.property.name === 'apply')
    ) {
        return callee.object;
    }

    return null;
};

/**
 * Trims leading and trailing underscores
 *
 * @param {String} name
 * @return {String}
 */
exports.trimUnderscores = function(name) {
    var res = name.replace(TRAILING_UNDERSCORES_RE, '');
    return res ? res : name;
};

/**
 * Whether or not the given path is relative
 *
 * @param  {String}  path
 * @return {Boolean}
 */
exports.isRelativePath = function(path) {
    // Logic from: https://github.com/joyent/node/blob/4f1ae11a62b97052bc83756f8cb8700cc1f61661/lib/module.js#L237
    var start = path.substring(0, 2);
    return start === './' || start === '..';
};

/**
 * Resolves a relative filepath against the supplied base path
 * or just returns the filepath if not relative
 *
 * @param  {String} filepath
 * @param  {String} basePath
 * @return {String}
 */
exports.normalizePath = function(filepath, basePath) {
    if (this.isRelativePath(filepath)) {
        return path.resolve(basePath, filepath);
    }

    return filepath;
};

/**
 * Wraps a function such that you can interact with a promise and not a
 * node-style callback.
 *
 * @param  {Function} fn - function that expects a node-style callback
 * @return {Function} When invoked with arguments, returns a promise resolved/rejected
 *                    based on the results of the wrapped node-style callback
 */
exports.promisify = function(fn) {
    return function() {
        var deferred = Vow.defer();
        var args = [].slice.call(arguments);

        args.push(function(err, result) {
            if (err) {
                deferred.reject(err);
            } else {
                deferred.resolve(result);
            }
        });

        fn.apply(null, args);

        return deferred.promise();
    };
};

/**
 * All possible binary operators supported by JSCS
 * @type {Array}
 */
exports.binaryOperators = [

    // assignment operators
    '=', '+=', '-=', '*=', '/=', '%=', '<<=', '>>=', '>>>=',
    '&=', '|=', '^=',

    '+', '-', '*', '/', '%', '<<', '>>', '>>>', '&',
    '|', '^', '&&', '||', '===', '==', '>=',
    '<=', '<', '>', '!=', '!=='
];

/**
 * Increment and decrement operators
 * @type {Array}
 */
exports.incrementAndDecrementOperators = ['++', '--'];

/**
 * All possible unary operators supported by JSCS
 * @type {Array}
 */
exports.unaryOperators = ['-', '+', '!', '~'].concat(exports.incrementAndDecrementOperators);

/**
 * All possible operators support by JSCS
 * @type {Array}
 */
exports.operators = exports.binaryOperators.concat(exports.unaryOperators);

/**
 * Returns a function that can check if a comment is a valid pragma.
 *
 * @param {Array} additionalExceptions can optionally be added to the existing pragmaKeywords
 * @returns {Function} that can be used to determine if a comment (supplied as an argument is a valid pragma
 *
 */
exports.isPragma = function(additionalExceptions) {
    var pragmaKeywords = [
        'eslint',
        'eslint-env',
        'eslint-enable',
        'eslint-disable',
        'eslint-disable-line',
        'global',
        'jshint',
        'jslint',
        'globals',
        'falls through',
        'exported',
        'jscs:',
        'jscs:enable',
        'jscs:disable',
        'jscs:ignore',
        'istanbul'
    ];
    if (additionalExceptions && Array.isArray(additionalExceptions)) {
        pragmaKeywords = pragmaKeywords.concat(additionalExceptions);
    }

    return function(comment) {
        // pragmaKeywords precede a space or the end of the comment
        var trimmedComment = comment.trim() + ' ';
        for (var i = 0; i < pragmaKeywords.length; i++) {
            if (trimmedComment.indexOf(pragmaKeywords[i] + ' ') === 0) {
                return true;
            }
        }
        return false;
    };
};

},{"../patterns/identifiers-ES5":951,"../patterns/identifiers-ES6":952,"path":870,"reserved-words":905,"vow":947}],167:[function(require,module,exports){
module.exports = {
    AnyTypeAnnotation: [],
    ArrayExpression: ['elements'],
    ArrayPattern: ['elements', 'typeAnnotation'],
    ArrayTypeAnnotation: ['elementType'],
    ArrowFunctionExpression: ['params', 'body', 'returnType'],
    AssignmentExpression: ['left', 'right'],
    AssignmentPattern: ['left', 'right'],
    AwaitExpression: ['argument'],
    BinaryExpression: ['left', 'right'],
    BindExpression: ['object', 'callee'],
    BlockStatement: ['body'],
    BooleanLiteralTypeAnnotation: [],
    BooleanTypeAnnotation: [],
    BreakStatement: ['label'],
    CallExpression: ['callee', 'arguments'],
    CatchClause: ['param', 'body'],
    ClassBody: ['body'],
    ClassDeclaration: ['id','body', 'superClass', 'typeParameters', 'superTypeParameters', 'implements', 'decorators'],
    ClassExpression: ['id', 'body', 'superClass', 'typeParameters', 'superTypeParameters', 'implements', 'decorators'],
    ClassImplements: ['id', 'typeParameters'],
    ClassProperty: ['key', 'value', 'typeAnnotation', 'decorators'],
    ComprehensionBlock: ['left', 'right'],
    ComprehensionExpression: ['filter', 'blocks', 'body'],
    ConditionalExpression: ['test', 'consequent', 'alternate'],
    ContinueStatement: ['label'],
    DebuggerStatement: [],
    DeclareClass: ['id', 'typeParameters', 'extends', 'body'],
    DeclareFunction: ['id'],
    DeclareModule: ['id', 'body'],
    DeclareVariable: ['id'],
    Decorator: ['expression'],
    DoExpression: ['body'],
    DoWhileStatement: ['body', 'test'],
    EmptyStatement: [],
    ExportAllDeclaration: ['source', 'exported'],
    ExportDefaultDeclaration: ['declaration'],
    ExportDefaultSpecifier: ['exported'],
    ExportNamedDeclaration: ['declaration', 'specifiers', 'source'],
    ExportNamespaceSpecifier: ['exported'],
    ExportSpecifier: ['local', 'exported'],
    ExpressionStatement: ['expression'],
    File: ['program'],
    ForInStatement: ['left', 'right', 'body'],
    ForOfStatement: ['left', 'right', 'body'],
    ForStatement: ['init', 'test', 'update', 'body'],
    FunctionDeclaration: ['id', 'params', 'body', 'returnType', 'typeParameters'],
    FunctionExpression: ['id', 'params', 'body', 'returnType', 'typeParameters'],
    FunctionTypeAnnotation: ['typeParameters', 'params', 'rest', 'returnType'],
    FunctionTypeParam: ['name', 'typeAnnotation'],
    GenericTypeAnnotation: ['id', 'typeParameters'],
    Identifier: ['typeAnnotation'],
    IfStatement: ['test', 'consequent', 'alternate'],
    ImportDeclaration: ['specifiers', 'source'],
    ImportDefaultSpecifier: ['local'],
    ImportNamespaceSpecifier: ['local'],
    ImportSpecifier: ['local', 'imported'],
    InterfaceDeclaration: ['id', 'typeParameters', 'extends', 'body'],
    InterfaceExtends: ['id', 'typeParameters'],
    IntersectionTypeAnnotation: ['types'],
    JSXAttribute: ['name', 'value'],
    JSXClosingElement: ['name'],
    JSXElement: ['openingElement', 'closingElement', 'children'],
    JSXEmptyExpression: [],
    JSXExpressionContainer: ['expression'],
    JSXIdentifier: [],
    JSXMemberExpression: ['object', 'property'],
    JSXNamespacedName: ['namespace', 'name'],
    JSXOpeningElement: ['name', 'attributes'],
    JSXSpreadAttribute: ['argument'],
    LabeledStatement: ['label', 'body'],
    Literal: [],
    LogicalExpression: ['left', 'right'],
    MemberExpression: ['object', 'property'],
    MetaProperty: ['meta', 'property'],
    MethodDefinition: ['key', 'value', 'decorators'],
    MixedTypeAnnotation: [],
    NewExpression: ['callee', 'arguments'],
    Noop: [],
    NullableTypeAnnotation: ['typeAnnotation'],
    NumberLiteralTypeAnnotation: [],
    NumberTypeAnnotation: [],
    ObjectExpression: ['properties'],
    ObjectPattern: ['properties', 'typeAnnotation'],
    ObjectTypeAnnotation: ['properties', 'indexers', 'callProperties'],
    ObjectTypeCallProperty: ['value'],
    ObjectTypeIndexer: ['id', 'key', 'value'],
    ObjectTypeProperty: ['key', 'value'],
    ParenthesizedExpression: ['expression'],
    Program: ['body'],
    Property: ['key', 'value', 'decorators'],
    QualifiedTypeIdentifier: ['id', 'qualification'],
    RestElement: ['argument', 'typeAnnotation'],
    ReturnStatement: ['argument'],
    SequenceExpression: ['expressions'],
    SpreadElement: ['argument'],
    SpreadProperty: ['argument'],
    StringLiteralTypeAnnotation: [],
    StringTypeAnnotation: [],
    Super: [],
    SwitchCase: ['test', 'consequent'],
    SwitchStatement: ['discriminant', 'cases'],
    TaggedTemplateExpression: ['tag', 'quasi'],
    TemplateElement: [],
    TemplateLiteral: ['quasis', 'expressions'],
    ThisExpression: [],
    ThrowStatement: ['argument'],
    TryStatement: ['block', 'handlers', 'handler', 'guardedHandlers', 'finalizer'],
    TupleTypeAnnotation: ['types'],
    TypeAlias: ['id', 'typeParameters', 'right'],
    TypeAnnotation: ['typeAnnotation'],
    TypeCastExpression: ['expression', 'typeAnnotation'],
    TypeofTypeAnnotation: ['argument'],
    TypeParameterDeclaration: ['params'],
    TypeParameterInstantiation: ['params'],
    UnaryExpression: ['argument'],
    UnionTypeAnnotation: ['types'],
    UpdateExpression: ['argument'],
    VariableDeclaration: ['declarations'],
    VariableDeclarator: ['id', 'init'],
    VoidTypeAnnotation: [],
    WhileStatement: ['test', 'body'],
    WithStatement: ['object', 'body'],
    YieldExpression: ['argument']
};

},{}],168:[function(require,module,exports){
// alter.js
// MIT licensed, see LICENSE file
// Copyright (c) 2013 Olov Lassus <olov.lassus@gmail.com>

var assert = require("assert");
var stableSort = require("stable");

// fragments is a list of {start: index, end: index, str: string to replace with}
function alter(str, fragments) {
    "use strict";

    var isArray = Array.isArray || function(v) {
        return Object.prototype.toString.call(v) === "[object Array]";
    };;

    assert(typeof str === "string");
    assert(isArray(fragments));

    // stableSort isn't in-place so no need to copy array first
    var sortedFragments = stableSort(fragments, function(a, b) {
        return a.start - b.start;
    });

    var outs = [];

    var pos = 0;
    for (var i = 0; i < sortedFragments.length; i++) {
        var frag = sortedFragments[i];

        assert(pos <= frag.start);
        assert(frag.start <= frag.end);
        outs.push(str.slice(pos, frag.start));
        outs.push(frag.str);
        pos = frag.end;
    }
    if (pos < str.length) {
        outs.push(str.slice(pos));
    }

    return outs.join("");
}

if (typeof module !== "undefined" && typeof module.exports !== "undefined") {
    module.exports = alter;
}

},{"assert":171,"stable":922}],169:[function(require,module,exports){
'use strict';
module.exports = function () {
	return /[\u001b\u009b][[()#;?]*(?:[0-9]{1,4}(?:;[0-9]{0,4})*)?[0-9A-ORZcf-nqry=><]/g;
};

},{}],170:[function(require,module,exports){
'use strict';

function assembleStyles () {
	var styles = {
		modifiers: {
			reset: [0, 0],
			bold: [1, 22], // 21 isn't widely supported and 22 does the same thing
			dim: [2, 22],
			italic: [3, 23],
			underline: [4, 24],
			inverse: [7, 27],
			hidden: [8, 28],
			strikethrough: [9, 29]
		},
		colors: {
			black: [30, 39],
			red: [31, 39],
			green: [32, 39],
			yellow: [33, 39],
			blue: [34, 39],
			magenta: [35, 39],
			cyan: [36, 39],
			white: [37, 39],
			gray: [90, 39]
		},
		bgColors: {
			bgBlack: [40, 49],
			bgRed: [41, 49],
			bgGreen: [42, 49],
			bgYellow: [43, 49],
			bgBlue: [44, 49],
			bgMagenta: [45, 49],
			bgCyan: [46, 49],
			bgWhite: [47, 49]
		}
	};

	// fix humans
	styles.colors.grey = styles.colors.gray;

	Object.keys(styles).forEach(function (groupName) {
		var group = styles[groupName];

		Object.keys(group).forEach(function (styleName) {
			var style = group[styleName];

			styles[styleName] = group[styleName] = {
				open: '\u001b[' + style[0] + 'm',
				close: '\u001b[' + style[1] + 'm'
			};
		});

		Object.defineProperty(styles, groupName, {
			value: group,
			enumerable: false
		});
	});

	return styles;
}

Object.defineProperty(module, 'exports', {
	enumerable: true,
	get: assembleStyles
});

},{}],171:[function(require,module,exports){
// http://wiki.commonjs.org/wiki/Unit_Testing/1.0
//
// THIS IS NOT TESTED NOR LIKELY TO WORK OUTSIDE V8!
//
// Originally from narwhal.js (http://narwhaljs.org)
// Copyright (c) 2009 Thomas Robinson <280north.com>
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the 'Software'), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED 'AS IS', WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
// ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
// WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

// when used in node, this will actually load the util module we depend on
// versus loading the builtin util module as happens otherwise
// this is a bug in node module loading as far as I am concerned
var util = require('util/');

var pSlice = Array.prototype.slice;
var hasOwn = Object.prototype.hasOwnProperty;

// 1. The assert module provides functions that throw
// AssertionError's when particular conditions are not met. The
// assert module must conform to the following interface.

var assert = module.exports = ok;

// 2. The AssertionError is defined in assert.
// new assert.AssertionError({ message: message,
//                             actual: actual,
//                             expected: expected })

assert.AssertionError = function AssertionError(options) {
  this.name = 'AssertionError';
  this.actual = options.actual;
  this.expected = options.expected;
  this.operator = options.operator;
  if (options.message) {
    this.message = options.message;
    this.generatedMessage = false;
  } else {
    this.message = getMessage(this);
    this.generatedMessage = true;
  }
  var stackStartFunction = options.stackStartFunction || fail;

  if (Error.captureStackTrace) {
    Error.captureStackTrace(this, stackStartFunction);
  }
  else {
    // non v8 browsers so we can have a stacktrace
    var err = new Error();
    if (err.stack) {
      var out = err.stack;

      // try to strip useless frames
      var fn_name = stackStartFunction.name;
      var idx = out.indexOf('\n' + fn_name);
      if (idx >= 0) {
        // once we have located the function frame
        // we need to strip out everything before it (and its line)
        var next_line = out.indexOf('\n', idx + 1);
        out = out.substring(next_line + 1);
      }

      this.stack = out;
    }
  }
};

// assert.AssertionError instanceof Error
util.inherits(assert.AssertionError, Error);

function replacer(key, value) {
  if (util.isUndefined(value)) {
    return '' + value;
  }
  if (util.isNumber(value) && !isFinite(value)) {
    return value.toString();
  }
  if (util.isFunction(value) || util.isRegExp(value)) {
    return value.toString();
  }
  return value;
}

function truncate(s, n) {
  if (util.isString(s)) {
    return s.length < n ? s : s.slice(0, n);
  } else {
    return s;
  }
}

function getMessage(self) {
  return truncate(JSON.stringify(self.actual, replacer), 128) + ' ' +
         self.operator + ' ' +
         truncate(JSON.stringify(self.expected, replacer), 128);
}

// At present only the three keys mentioned above are used and
// understood by the spec. Implementations or sub modules can pass
// other keys to the AssertionError's constructor - they will be
// ignored.

// 3. All of the following functions must throw an AssertionError
// when a corresponding condition is not met, with a message that
// may be undefined if not provided.  All assertion methods provide
// both the actual and expected values to the assertion error for
// display purposes.

function fail(actual, expected, message, operator, stackStartFunction) {
  throw new assert.AssertionError({
    message: message,
    actual: actual,
    expected: expected,
    operator: operator,
    stackStartFunction: stackStartFunction
  });
}

// EXTENSION! allows for well behaved errors defined elsewhere.
assert.fail = fail;

// 4. Pure assertion tests whether a value is truthy, as determined
// by !!guard.
// assert.ok(guard, message_opt);
// This statement is equivalent to assert.equal(true, !!guard,
// message_opt);. To test strictly for the value true, use
// assert.strictEqual(true, guard, message_opt);.

function ok(value, message) {
  if (!value) fail(value, true, message, '==', assert.ok);
}
assert.ok = ok;

// 5. The equality assertion tests shallow, coercive equality with
// ==.
// assert.equal(actual, expected, message_opt);

assert.equal = function equal(actual, expected, message) {
  if (actual != expected) fail(actual, expected, message, '==', assert.equal);
};

// 6. The non-equality assertion tests for whether two objects are not equal
// with != assert.notEqual(actual, expected, message_opt);

assert.notEqual = function notEqual(actual, expected, message) {
  if (actual == expected) {
    fail(actual, expected, message, '!=', assert.notEqual);
  }
};

// 7. The equivalence assertion tests a deep equality relation.
// assert.deepEqual(actual, expected, message_opt);

assert.deepEqual = function deepEqual(actual, expected, message) {
  if (!_deepEqual(actual, expected)) {
    fail(actual, expected, message, 'deepEqual', assert.deepEqual);
  }
};

function _deepEqual(actual, expected) {
  // 7.1. All identical values are equivalent, as determined by ===.
  if (actual === expected) {
    return true;

  } else if (util.isBuffer(actual) && util.isBuffer(expected)) {
    if (actual.length != expected.length) return false;

    for (var i = 0; i < actual.length; i++) {
      if (actual[i] !== expected[i]) return false;
    }

    return true;

  // 7.2. If the expected value is a Date object, the actual value is
  // equivalent if it is also a Date object that refers to the same time.
  } else if (util.isDate(actual) && util.isDate(expected)) {
    return actual.getTime() === expected.getTime();

  // 7.3 If the expected value is a RegExp object, the actual value is
  // equivalent if it is also a RegExp object with the same source and
  // properties (`global`, `multiline`, `lastIndex`, `ignoreCase`).
  } else if (util.isRegExp(actual) && util.isRegExp(expected)) {
    return actual.source === expected.source &&
           actual.global === expected.global &&
           actual.multiline === expected.multiline &&
           actual.lastIndex === expected.lastIndex &&
           actual.ignoreCase === expected.ignoreCase;

  // 7.4. Other pairs that do not both pass typeof value == 'object',
  // equivalence is determined by ==.
  } else if (!util.isObject(actual) && !util.isObject(expected)) {
    return actual == expected;

  // 7.5 For all other Object pairs, including Array objects, equivalence is
  // determined by having the same number of owned properties (as verified
  // with Object.prototype.hasOwnProperty.call), the same set of keys
  // (although not necessarily the same order), equivalent values for every
  // corresponding key, and an identical 'prototype' property. Note: this
  // accounts for both named and indexed properties on Arrays.
  } else {
    return objEquiv(actual, expected);
  }
}

function isArguments(object) {
  return Object.prototype.toString.call(object) == '[object Arguments]';
}

function objEquiv(a, b) {
  if (util.isNullOrUndefined(a) || util.isNullOrUndefined(b))
    return false;
  // an identical 'prototype' property.
  if (a.prototype !== b.prototype) return false;
  // if one is a primitive, the other must be same
  if (util.isPrimitive(a) || util.isPrimitive(b)) {
    return a === b;
  }
  var aIsArgs = isArguments(a),
      bIsArgs = isArguments(b);
  if ((aIsArgs && !bIsArgs) || (!aIsArgs && bIsArgs))
    return false;
  if (aIsArgs) {
    a = pSlice.call(a);
    b = pSlice.call(b);
    return _deepEqual(a, b);
  }
  var ka = objectKeys(a),
      kb = objectKeys(b),
      key, i;
  // having the same number of owned properties (keys incorporates
  // hasOwnProperty)
  if (ka.length != kb.length)
    return false;
  //the same set of keys (although not necessarily the same order),
  ka.sort();
  kb.sort();
  //~~~cheap key test
  for (i = ka.length - 1; i >= 0; i--) {
    if (ka[i] != kb[i])
      return false;
  }
  //equivalent values for every corresponding key, and
  //~~~possibly expensive deep test
  for (i = ka.length - 1; i >= 0; i--) {
    key = ka[i];
    if (!_deepEqual(a[key], b[key])) return false;
  }
  return true;
}

// 8. The non-equivalence assertion tests for any deep inequality.
// assert.notDeepEqual(actual, expected, message_opt);

assert.notDeepEqual = function notDeepEqual(actual, expected, message) {
  if (_deepEqual(actual, expected)) {
    fail(actual, expected, message, 'notDeepEqual', assert.notDeepEqual);
  }
};

// 9. The strict equality assertion tests strict equality, as determined by ===.
// assert.strictEqual(actual, expected, message_opt);

assert.strictEqual = function strictEqual(actual, expected, message) {
  if (actual !== expected) {
    fail(actual, expected, message, '===', assert.strictEqual);
  }
};

// 10. The strict non-equality assertion tests for strict inequality, as
// determined by !==.  assert.notStrictEqual(actual, expected, message_opt);

assert.notStrictEqual = function notStrictEqual(actual, expected, message) {
  if (actual === expected) {
    fail(actual, expected, message, '!==', assert.notStrictEqual);
  }
};

function expectedException(actual, expected) {
  if (!actual || !expected) {
    return false;
  }

  if (Object.prototype.toString.call(expected) == '[object RegExp]') {
    return expected.test(actual);
  } else if (actual instanceof expected) {
    return true;
  } else if (expected.call({}, actual) === true) {
    return true;
  }

  return false;
}

function _throws(shouldThrow, block, expected, message) {
  var actual;

  if (util.isString(expected)) {
    message = expected;
    expected = null;
  }

  try {
    block();
  } catch (e) {
    actual = e;
  }

  message = (expected && expected.name ? ' (' + expected.name + ').' : '.') +
            (message ? ' ' + message : '.');

  if (shouldThrow && !actual) {
    fail(actual, expected, 'Missing expected exception' + message);
  }

  if (!shouldThrow && expectedException(actual, expected)) {
    fail(actual, expected, 'Got unwanted exception' + message);
  }

  if ((shouldThrow && actual && expected &&
      !expectedException(actual, expected)) || (!shouldThrow && actual)) {
    throw actual;
  }
}

// 11. Expected to throw an error:
// assert.throws(block, Error_opt, message_opt);

assert.throws = function(block, /*optional*/error, /*optional*/message) {
  _throws.apply(this, [true].concat(pSlice.call(arguments)));
};

// EXTENSION! This is annoying to write outside this module.
assert.doesNotThrow = function(block, /*optional*/message) {
  _throws.apply(this, [false].concat(pSlice.call(arguments)));
};

assert.ifError = function(err) { if (err) {throw err;}};

var objectKeys = Object.keys || function (obj) {
  var keys = [];
  for (var key in obj) {
    if (hasOwn.call(obj, key)) keys.push(key);
  }
  return keys;
};

},{"util/":946}],172:[function(require,module,exports){
function traverse(root, options) {
    "use strict";

    options = options || {};
    var pre = options.pre;
    var post = options.post;
    var skipProperty = options.skipProperty;

    function visit(node, parent, prop, idx) {
        if (!node || typeof node.type !== "string") {
            return;
        }

        var res = undefined;
        if (pre) {
            res = pre(node, parent, prop, idx);
        }

        if (res !== false) {
            for (var prop in node) {
                if (skipProperty ? skipProperty(prop, node) : prop[0] === "$") {
                    continue;
                }

                var child = node[prop];

                if (Array.isArray(child)) {
                    for (var i = 0; i < child.length; i++) {
                        visit(child[i], node, prop, i);
                    }
                } else {
                    visit(child, node, prop);
                }
            }
        }

        if (post) {
            post(node, parent, prop, idx);
        }
    }

    visit(root, null);
};

if (typeof module !== "undefined" && typeof module.exports !== "undefined") {
    module.exports = traverse;
}

},{}],173:[function(require,module,exports){
require("./es7");

var types = require("../lib/types");
var defaults = require("../lib/shared").defaults;
var def = types.Type.def;
var or = types.Type.or;

def("Noop")
  .bases("Node")
  .build();

def("DoExpression")
  .bases("Expression")
  .build("body")
  .field("body", [def("Statement")]);

def("Super")
  .bases("Expression")
  .build();

def("BindExpression")
  .bases("Expression")
  .build("object", "callee")
  .field("object", or(def("Expression"), null))
  .field("callee", def("Expression"));

def("Decorator")
  .bases("Node")
  .build("expression")
  .field("expression", def("Expression"));

def("Property")
  .field("decorators",
         or([def("Decorator")], null),
         defaults["null"]);

def("MethodDefinition")
  .field("decorators",
         or([def("Decorator")], null),
         defaults["null"]);

def("MetaProperty")
  .bases("Expression")
  .build("meta", "property")
  .field("meta", def("Identifier"))
  .field("property", def("Identifier"));

def("ParenthesizedExpression")
  .bases("Expression")
  .build("expression")
  .field("expression", def("Expression"));

def("ImportSpecifier")
  .bases("ModuleSpecifier")
  .build("imported", "local")
  .field("imported", def("Identifier"));

def("ImportDefaultSpecifier")
  .bases("ModuleSpecifier")
  .build("local");

def("ImportNamespaceSpecifier")
  .bases("ModuleSpecifier")
  .build("local");

def("ExportDefaultDeclaration")
  .bases("Declaration")
  .build("declaration")
  .field("declaration", or(def("Declaration"), def("Expression")));

def("ExportNamedDeclaration")
  .bases("Declaration")
  .build("declaration", "specifiers", "source")
  .field("declaration", or(def("Declaration"), null))
  .field("specifiers", [def("ExportSpecifier")], defaults.emptyArray)
  .field("source", or(def("Literal"), null), defaults["null"]);

def("ExportSpecifier")
  .bases("ModuleSpecifier")
  .build("local", "exported")
  .field("exported", def("Identifier"));

def("ExportNamespaceSpecifier")
  .bases("Specifier")
  .build("exported")
  .field("exported", def("Identifier"));

def("ExportDefaultSpecifier")
  .bases("Specifier")
  .build("exported")
  .field("exported", def("Identifier"));

def("ExportAllDeclaration")
  .bases("Declaration")
  .build("exported", "source")
  .field("exported", or(def("Identifier"), null))
  .field("source", def("Literal"));

def("CommentBlock")
    .bases("Comment")
    .build("value", /*optional:*/ "leading", "trailing");

def("CommentLine")
    .bases("Comment")
    .build("value", /*optional:*/ "leading", "trailing");

},{"../lib/shared":186,"../lib/types":187,"./es7":177}],174:[function(require,module,exports){
var types = require("../lib/types");
var Type = types.Type;
var def = Type.def;
var or = Type.or;
var shared = require("../lib/shared");
var defaults = shared.defaults;
var geq = shared.geq;

// Abstract supertype of all syntactic entities that are allowed to have a
// .loc field.
def("Printable")
    .field("loc", or(
        def("SourceLocation"),
        null
    ), defaults["null"], true);

def("Node")
    .bases("Printable")
    .field("type", String)
    .field("comments", or(
        [def("Comment")],
        null
    ), defaults["null"], true);

def("SourceLocation")
    .build("start", "end", "source")
    .field("start", def("Position"))
    .field("end", def("Position"))
    .field("source", or(String, null), defaults["null"]);

def("Position")
    .build("line", "column")
    .field("line", geq(1))
    .field("column", geq(0));

def("File")
    .bases("Node")
    .build("program")
    .field("program", def("Program"));

def("Program")
    .bases("Node")
    .build("body")
    .field("body", [def("Statement")]);

def("Function")
    .bases("Node")
    .field("id", or(def("Identifier"), null), defaults["null"])
    .field("params", [def("Pattern")])
    .field("body", def("BlockStatement"));

def("Statement").bases("Node");

// The empty .build() here means that an EmptyStatement can be constructed
// (i.e. it's not abstract) but that it needs no arguments.
def("EmptyStatement").bases("Statement").build();

def("BlockStatement")
    .bases("Statement")
    .build("body")
    .field("body", [def("Statement")]);

// TODO Figure out how to silently coerce Expressions to
// ExpressionStatements where a Statement was expected.
def("ExpressionStatement")
    .bases("Statement")
    .build("expression")
    .field("expression", def("Expression"));

def("IfStatement")
    .bases("Statement")
    .build("test", "consequent", "alternate")
    .field("test", def("Expression"))
    .field("consequent", def("Statement"))
    .field("alternate", or(def("Statement"), null), defaults["null"]);

def("LabeledStatement")
    .bases("Statement")
    .build("label", "body")
    .field("label", def("Identifier"))
    .field("body", def("Statement"));

def("BreakStatement")
    .bases("Statement")
    .build("label")
    .field("label", or(def("Identifier"), null), defaults["null"]);

def("ContinueStatement")
    .bases("Statement")
    .build("label")
    .field("label", or(def("Identifier"), null), defaults["null"]);

def("WithStatement")
    .bases("Statement")
    .build("object", "body")
    .field("object", def("Expression"))
    .field("body", def("Statement"));

def("SwitchStatement")
    .bases("Statement")
    .build("discriminant", "cases", "lexical")
    .field("discriminant", def("Expression"))
    .field("cases", [def("SwitchCase")])
    .field("lexical", Boolean, defaults["false"]);

def("ReturnStatement")
    .bases("Statement")
    .build("argument")
    .field("argument", or(def("Expression"), null));

def("ThrowStatement")
    .bases("Statement")
    .build("argument")
    .field("argument", def("Expression"));

def("TryStatement")
    .bases("Statement")
    .build("block", "handler", "finalizer")
    .field("block", def("BlockStatement"))
    .field("handler", or(def("CatchClause"), null), function() {
        return this.handlers && this.handlers[0] || null;
    })
    .field("handlers", [def("CatchClause")], function() {
        return this.handler ? [this.handler] : [];
    }, true) // Indicates this field is hidden from eachField iteration.
    .field("guardedHandlers", [def("CatchClause")], defaults.emptyArray)
    .field("finalizer", or(def("BlockStatement"), null), defaults["null"]);

def("CatchClause")
    .bases("Node")
    .build("param", "guard", "body")
    .field("param", def("Pattern"))
    .field("guard", or(def("Expression"), null), defaults["null"])
    .field("body", def("BlockStatement"));

def("WhileStatement")
    .bases("Statement")
    .build("test", "body")
    .field("test", def("Expression"))
    .field("body", def("Statement"));

def("DoWhileStatement")
    .bases("Statement")
    .build("body", "test")
    .field("body", def("Statement"))
    .field("test", def("Expression"));

def("ForStatement")
    .bases("Statement")
    .build("init", "test", "update", "body")
    .field("init", or(
        def("VariableDeclaration"),
        def("Expression"),
        null))
    .field("test", or(def("Expression"), null))
    .field("update", or(def("Expression"), null))
    .field("body", def("Statement"));

def("ForInStatement")
    .bases("Statement")
    .build("left", "right", "body")
    .field("left", or(
        def("VariableDeclaration"),
        def("Expression")))
    .field("right", def("Expression"))
    .field("body", def("Statement"));

def("DebuggerStatement").bases("Statement").build();

def("Declaration").bases("Statement");

def("FunctionDeclaration")
    .bases("Function", "Declaration")
    .build("id", "params", "body")
    .field("id", def("Identifier"));

def("FunctionExpression")
    .bases("Function", "Expression")
    .build("id", "params", "body");

def("VariableDeclaration")
    .bases("Declaration")
    .build("kind", "declarations")
    .field("kind", or("var", "let", "const"))
    .field("declarations", [def("VariableDeclarator")]);

def("VariableDeclarator")
    .bases("Node")
    .build("id", "init")
    .field("id", def("Pattern"))
    .field("init", or(def("Expression"), null));

// TODO Are all Expressions really Patterns?
def("Expression").bases("Node", "Pattern");

def("ThisExpression").bases("Expression").build();

def("ArrayExpression")
    .bases("Expression")
    .build("elements")
    .field("elements", [or(def("Expression"), null)]);

def("ObjectExpression")
    .bases("Expression")
    .build("properties")
    .field("properties", [def("Property")]);

// TODO Not in the Mozilla Parser API, but used by Esprima.
def("Property")
    .bases("Node") // Want to be able to visit Property Nodes.
    .build("kind", "key", "value")
    .field("kind", or("init", "get", "set"))
    .field("key", or(def("Literal"), def("Identifier")))
    .field("value", def("Expression"));

def("SequenceExpression")
    .bases("Expression")
    .build("expressions")
    .field("expressions", [def("Expression")]);

var UnaryOperator = or(
    "-", "+", "!", "~",
    "typeof", "void", "delete");

def("UnaryExpression")
    .bases("Expression")
    .build("operator", "argument", "prefix")
    .field("operator", UnaryOperator)
    .field("argument", def("Expression"))
    // Esprima doesn't bother with this field, presumably because it's
    // always true for unary operators.
    .field("prefix", Boolean, defaults["true"]);

var BinaryOperator = or(
    "==", "!=", "===", "!==",
    "<", "<=", ">", ">=",
    "<<", ">>", ">>>",
    "+", "-", "*", "/", "%",
    "&", // TODO Missing from the Parser API.
    "|", "^", "in",
    "instanceof", "..");

def("BinaryExpression")
    .bases("Expression")
    .build("operator", "left", "right")
    .field("operator", BinaryOperator)
    .field("left", def("Expression"))
    .field("right", def("Expression"));

var AssignmentOperator = or(
    "=", "+=", "-=", "*=", "/=", "%=",
    "<<=", ">>=", ">>>=",
    "|=", "^=", "&=");

def("AssignmentExpression")
    .bases("Expression")
    .build("operator", "left", "right")
    .field("operator", AssignmentOperator)
    .field("left", def("Pattern"))
    .field("right", def("Expression"));

var UpdateOperator = or("++", "--");

def("UpdateExpression")
    .bases("Expression")
    .build("operator", "argument", "prefix")
    .field("operator", UpdateOperator)
    .field("argument", def("Expression"))
    .field("prefix", Boolean);

var LogicalOperator = or("||", "&&");

def("LogicalExpression")
    .bases("Expression")
    .build("operator", "left", "right")
    .field("operator", LogicalOperator)
    .field("left", def("Expression"))
    .field("right", def("Expression"));

def("ConditionalExpression")
    .bases("Expression")
    .build("test", "consequent", "alternate")
    .field("test", def("Expression"))
    .field("consequent", def("Expression"))
    .field("alternate", def("Expression"));

def("NewExpression")
    .bases("Expression")
    .build("callee", "arguments")
    .field("callee", def("Expression"))
    // The Mozilla Parser API gives this type as [or(def("Expression"),
    // null)], but null values don't really make sense at the call site.
    // TODO Report this nonsense.
    .field("arguments", [def("Expression")]);

def("CallExpression")
    .bases("Expression")
    .build("callee", "arguments")
    .field("callee", def("Expression"))
    // See comment for NewExpression above.
    .field("arguments", [def("Expression")]);

def("MemberExpression")
    .bases("Expression")
    .build("object", "property", "computed")
    .field("object", def("Expression"))
    .field("property", or(def("Identifier"), def("Expression")))
    .field("computed", Boolean, defaults["false"]);

def("Pattern").bases("Node");

def("SwitchCase")
    .bases("Node")
    .build("test", "consequent")
    .field("test", or(def("Expression"), null))
    .field("consequent", [def("Statement")]);

def("Identifier")
    // But aren't Expressions and Patterns already Nodes? TODO Report this.
    .bases("Node", "Expression", "Pattern")
    .build("name")
    .field("name", String);

def("Literal")
    // But aren't Expressions already Nodes? TODO Report this.
    .bases("Node", "Expression")
    .build("value")
    .field("value", or(String, Boolean, null, Number, RegExp))
    .field("regex", or({
        pattern: String,
        flags: String
    }, null), function() {
        if (this.value instanceof RegExp) {
            var flags = "";

            if (this.value.ignoreCase) flags += "i";
            if (this.value.multiline) flags += "m";
            if (this.value.global) flags += "g";

            return {
                pattern: this.value.source,
                flags: flags
            };
        }

        return null;
    });

// Abstract (non-buildable) comment supertype. Not a Node.
def("Comment")
    .bases("Printable")
    .field("value", String)
    // A .leading comment comes before the node, whereas a .trailing
    // comment comes after it. These two fields should not both be true,
    // but they might both be false when the comment falls inside a node
    // and the node has no children for the comment to lead or trail,
    // e.g. { /*dangling*/ }.
    .field("leading", Boolean, defaults["true"])
    .field("trailing", Boolean, defaults["false"]);

},{"../lib/shared":186,"../lib/types":187}],175:[function(require,module,exports){
require("./core");
var types = require("../lib/types");
var def = types.Type.def;
var or = types.Type.or;

// Note that none of these types are buildable because the Mozilla Parser
// API doesn't specify any builder functions, and nobody uses E4X anymore.

def("XMLDefaultDeclaration")
    .bases("Declaration")
    .field("namespace", def("Expression"));

def("XMLAnyName").bases("Expression");

def("XMLQualifiedIdentifier")
    .bases("Expression")
    .field("left", or(def("Identifier"), def("XMLAnyName")))
    .field("right", or(def("Identifier"), def("Expression")))
    .field("computed", Boolean);

def("XMLFunctionQualifiedIdentifier")
    .bases("Expression")
    .field("right", or(def("Identifier"), def("Expression")))
    .field("computed", Boolean);

def("XMLAttributeSelector")
    .bases("Expression")
    .field("attribute", def("Expression"));

def("XMLFilterExpression")
    .bases("Expression")
    .field("left", def("Expression"))
    .field("right", def("Expression"));

def("XMLElement")
    .bases("XML", "Expression")
    .field("contents", [def("XML")]);

def("XMLList")
    .bases("XML", "Expression")
    .field("contents", [def("XML")]);

def("XML").bases("Node");

def("XMLEscape")
    .bases("XML")
    .field("expression", def("Expression"));

def("XMLText")
    .bases("XML")
    .field("text", String);

def("XMLStartTag")
    .bases("XML")
    .field("contents", [def("XML")]);

def("XMLEndTag")
    .bases("XML")
    .field("contents", [def("XML")]);

def("XMLPointTag")
    .bases("XML")
    .field("contents", [def("XML")]);

def("XMLName")
    .bases("XML")
    .field("contents", or(String, [def("XML")]));

def("XMLAttribute")
    .bases("XML")
    .field("value", String);

def("XMLCdata")
    .bases("XML")
    .field("contents", String);

def("XMLComment")
    .bases("XML")
    .field("contents", String);

def("XMLProcessingInstruction")
    .bases("XML")
    .field("target", String)
    .field("contents", or(String, null));

},{"../lib/types":187,"./core":174}],176:[function(require,module,exports){
require("./core");
var types = require("../lib/types");
var def = types.Type.def;
var or = types.Type.or;
var defaults = require("../lib/shared").defaults;

def("Function")
    .field("generator", Boolean, defaults["false"])
    .field("expression", Boolean, defaults["false"])
    .field("defaults", [or(def("Expression"), null)], defaults.emptyArray)
    // TODO This could be represented as a RestElement in .params.
    .field("rest", or(def("Identifier"), null), defaults["null"]);

// The ESTree way of representing a ...rest parameter.
def("RestElement")
    .bases("Pattern")
    .build("argument")
    .field("argument", def("Pattern"));

def("SpreadElementPattern")
    .bases("Pattern")
    .build("argument")
    .field("argument", def("Pattern"));

def("FunctionDeclaration")
    .build("id", "params", "body", "generator", "expression");

def("FunctionExpression")
    .build("id", "params", "body", "generator", "expression");

// The Parser API calls this ArrowExpression, but Esprima and all other
// actual parsers use ArrowFunctionExpression.
def("ArrowFunctionExpression")
    .bases("Function", "Expression")
    .build("params", "body", "expression")
    // The forced null value here is compatible with the overridden
    // definition of the "id" field in the Function interface.
    .field("id", null, defaults["null"])
    // Arrow function bodies are allowed to be expressions.
    .field("body", or(def("BlockStatement"), def("Expression")))
    // The current spec forbids arrow generators, so I have taken the
    // liberty of enforcing that. TODO Report this.
    .field("generator", false, defaults["false"]);

def("YieldExpression")
    .bases("Expression")
    .build("argument", "delegate")
    .field("argument", or(def("Expression"), null))
    .field("delegate", Boolean, defaults["false"]);

def("GeneratorExpression")
    .bases("Expression")
    .build("body", "blocks", "filter")
    .field("body", def("Expression"))
    .field("blocks", [def("ComprehensionBlock")])
    .field("filter", or(def("Expression"), null));

def("ComprehensionExpression")
    .bases("Expression")
    .build("body", "blocks", "filter")
    .field("body", def("Expression"))
    .field("blocks", [def("ComprehensionBlock")])
    .field("filter", or(def("Expression"), null));

def("ComprehensionBlock")
    .bases("Node")
    .build("left", "right", "each")
    .field("left", def("Pattern"))
    .field("right", def("Expression"))
    .field("each", Boolean);

def("Property")
    .field("key", or(def("Literal"), def("Identifier"), def("Expression")))
    .field("value", or(def("Expression"), def("Pattern")))
    .field("method", Boolean, defaults["false"])
    .field("shorthand", Boolean, defaults["false"])
    .field("computed", Boolean, defaults["false"]);

def("PropertyPattern")
    .bases("Pattern")
    .build("key", "pattern")
    .field("key", or(def("Literal"), def("Identifier"), def("Expression")))
    .field("pattern", def("Pattern"))
    .field("computed", Boolean, defaults["false"]);

def("ObjectPattern")
    .bases("Pattern")
    .build("properties")
    .field("properties", [or(def("PropertyPattern"), def("Property"))]);

def("ArrayPattern")
    .bases("Pattern")
    .build("elements")
    .field("elements", [or(def("Pattern"), null)]);

def("MethodDefinition")
    .bases("Declaration")
    .build("kind", "key", "value", "static")
    .field("kind", or("constructor", "method", "get", "set"))
    .field("key", or(def("Literal"), def("Identifier"), def("Expression")))
    .field("value", def("Function"))
    .field("computed", Boolean, defaults["false"])
    .field("static", Boolean, defaults["false"]);

def("SpreadElement")
    .bases("Node")
    .build("argument")
    .field("argument", def("Expression"));

def("ArrayExpression")
    .field("elements", [or(
        def("Expression"),
        def("SpreadElement"),
        def("RestElement"),
        null
    )]);

def("NewExpression")
    .field("arguments", [or(def("Expression"), def("SpreadElement"))]);

def("CallExpression")
    .field("arguments", [or(def("Expression"), def("SpreadElement"))]);

// Note: this node type is *not* an AssignmentExpression with a Pattern on
// the left-hand side! The existing AssignmentExpression type already
// supports destructuring assignments. AssignmentPattern nodes may appear
// wherever a Pattern is allowed, and the right-hand side represents a
// default value to be destructured against the left-hand side, if no
// value is otherwise provided. For example: default parameter values.
def("AssignmentPattern")
    .bases("Pattern")
    .build("left", "right")
    .field("left", def("Pattern"))
    .field("right", def("Expression"));

var ClassBodyElement = or(
    def("MethodDefinition"),
    def("VariableDeclarator"),
    def("ClassPropertyDefinition"),
    def("ClassProperty")
);

def("ClassProperty")
  .bases("Declaration")
  .build("key")
  .field("key", or(def("Literal"), def("Identifier"), def("Expression")))
  .field("computed", Boolean, defaults["false"]);

def("ClassPropertyDefinition") // static property
    .bases("Declaration")
    .build("definition")
    // Yes, Virginia, circular definitions are permitted.
    .field("definition", ClassBodyElement);

def("ClassBody")
    .bases("Declaration")
    .build("body")
    .field("body", [ClassBodyElement]);

def("ClassDeclaration")
    .bases("Declaration")
    .build("id", "body", "superClass")
    .field("id", or(def("Identifier"), null))
    .field("body", def("ClassBody"))
    .field("superClass", or(def("Expression"), null), defaults["null"]);

def("ClassExpression")
    .bases("Expression")
    .build("id", "body", "superClass")
    .field("id", or(def("Identifier"), null), defaults["null"])
    .field("body", def("ClassBody"))
    .field("superClass", or(def("Expression"), null), defaults["null"])
    .field("implements", [def("ClassImplements")], defaults.emptyArray);

def("ClassImplements")
    .bases("Node")
    .build("id")
    .field("id", def("Identifier"))
    .field("superClass", or(def("Expression"), null), defaults["null"]);

// Specifier and ModuleSpecifier are abstract non-standard types
// introduced for definitional convenience.
def("Specifier").bases("Node");

// This supertype is shared/abused by both def/babel.js and
// def/esprima.js. In the future, it will be possible to load only one set
// of definitions appropriate for a given parser, but until then we must
// rely on default functions to reconcile the conflicting AST formats.
def("ModuleSpecifier")
    .bases("Specifier")
    // This local field is used by Babel/Acorn. It should not technically
    // be optional in the Babel/Acorn AST format, but it must be optional
    // in the Esprima AST format.
    .field("local", or(def("Identifier"), null), defaults["null"])
    // The id and name fields are used by Esprima. The id field should not
    // technically be optional in the Esprima AST format, but it must be
    // optional in the Babel/Acorn AST format.
    .field("id", or(def("Identifier"), null), defaults["null"])
    .field("name", or(def("Identifier"), null), defaults["null"]);

def("TaggedTemplateExpression")
    .bases("Expression")
    .build("tag", "quasi")
    .field("tag", def("Expression"))
    .field("quasi", def("TemplateLiteral"));

def("TemplateLiteral")
    .bases("Expression")
    .build("quasis", "expressions")
    .field("quasis", [def("TemplateElement")])
    .field("expressions", [def("Expression")]);

def("TemplateElement")
    .bases("Node")
    .build("value", "tail")
    .field("value", {"cooked": String, "raw": String})
    .field("tail", Boolean);

},{"../lib/shared":186,"../lib/types":187,"./core":174}],177:[function(require,module,exports){
require("./es6");

var types = require("../lib/types");
var def = types.Type.def;
var or = types.Type.or;
var builtin = types.builtInTypes;
var defaults = require("../lib/shared").defaults;

def("Function")
    .field("async", Boolean, defaults["false"]);

def("SpreadProperty")
    .bases("Node")
    .build("argument")
    .field("argument", def("Expression"));

def("ObjectExpression")
    .field("properties", [or(def("Property"), def("SpreadProperty"))]);

def("SpreadPropertyPattern")
    .bases("Pattern")
    .build("argument")
    .field("argument", def("Pattern"));

def("ObjectPattern")
    .field("properties", [or(
        def("Property"),
        def("PropertyPattern"),
        def("SpreadPropertyPattern")
    )]);

def("AwaitExpression")
    .bases("Expression")
    .build("argument", "all")
    .field("argument", or(def("Expression"), null))
    .field("all", Boolean, defaults["false"]);

},{"../lib/shared":186,"../lib/types":187,"./es6":176}],178:[function(require,module,exports){
require("./es7");

var types = require("../lib/types");
var defaults = require("../lib/shared").defaults;
var def = types.Type.def;
var or = types.Type.or;

def("VariableDeclaration")
    .field("declarations", [or(
        def("VariableDeclarator"),
        def("Identifier") // Esprima deviation.
    )]);

def("Property")
    .field("value", or(
        def("Expression"),
        def("Pattern") // Esprima deviation.
    ));

def("ArrayPattern")
    .field("elements", [or(
        def("Pattern"),
        def("SpreadElement"),
        null
    )]);

def("ObjectPattern")
    .field("properties", [or(
        def("Property"),
        def("PropertyPattern"),
        def("SpreadPropertyPattern"),
        def("SpreadProperty") // Used by Esprima.
    )]);

// Like ModuleSpecifier, except type:"ExportSpecifier" and buildable.
// export {<id [as name]>} [from ...];
def("ExportSpecifier")
    .bases("ModuleSpecifier")
    .build("id", "name");

// export <*> from ...;
def("ExportBatchSpecifier")
    .bases("Specifier")
    .build();

// Like ModuleSpecifier, except type:"ImportSpecifier" and buildable.
// import {<id [as name]>} from ...;
def("ImportSpecifier")
    .bases("ModuleSpecifier")
    .build("id", "name");

// import <* as id> from ...;
def("ImportNamespaceSpecifier")
    .bases("ModuleSpecifier")
    .build("id");

// import <id> from ...;
def("ImportDefaultSpecifier")
    .bases("ModuleSpecifier")
    .build("id");

def("ExportDeclaration")
    .bases("Declaration")
    .build("default", "declaration", "specifiers", "source")
    .field("default", Boolean)
    .field("declaration", or(
        def("Declaration"),
        def("Expression"), // Implies default.
        null
    ))
    .field("specifiers", [or(
        def("ExportSpecifier"),
        def("ExportBatchSpecifier")
    )], defaults.emptyArray)
    .field("source", or(
        def("Literal"),
        null
    ), defaults["null"]);

def("ImportDeclaration")
    .bases("Declaration")
    .build("specifiers", "source")
    .field("specifiers", [or(
        def("ImportSpecifier"),
        def("ImportNamespaceSpecifier"),
        def("ImportDefaultSpecifier")
    )], defaults.emptyArray)
    .field("source", def("Literal"));

def("Block")
    .bases("Comment")
    .build("value", /*optional:*/ "leading", "trailing");

def("Line")
    .bases("Comment")
    .build("value", /*optional:*/ "leading", "trailing");

},{"../lib/shared":186,"../lib/types":187,"./es7":177}],179:[function(require,module,exports){
require("./es7");

var types = require("../lib/types");
var def = types.Type.def;
var or = types.Type.or;
var defaults = require("../lib/shared").defaults;

def("JSXAttribute")
    .bases("Node")
    .build("name", "value")
    .field("name", or(def("JSXIdentifier"), def("JSXNamespacedName")))
    .field("value", or(
        def("Literal"), // attr="value"
        def("JSXExpressionContainer"), // attr={value}
        null // attr= or just attr
    ), defaults["null"]);

def("JSXIdentifier")
    .bases("Identifier")
    .build("name")
    .field("name", String);

def("JSXNamespacedName")
    .bases("Node")
    .build("namespace", "name")
    .field("namespace", def("JSXIdentifier"))
    .field("name", def("JSXIdentifier"));

def("JSXMemberExpression")
    .bases("MemberExpression")
    .build("object", "property")
    .field("object", or(def("JSXIdentifier"), def("JSXMemberExpression")))
    .field("property", def("JSXIdentifier"))
    .field("computed", Boolean, defaults.false);

var JSXElementName = or(
    def("JSXIdentifier"),
    def("JSXNamespacedName"),
    def("JSXMemberExpression")
);

def("JSXSpreadAttribute")
    .bases("Node")
    .build("argument")
    .field("argument", def("Expression"));

var JSXAttributes = [or(
    def("JSXAttribute"),
    def("JSXSpreadAttribute")
)];

def("JSXExpressionContainer")
    .bases("Expression")
    .build("expression")
    .field("expression", def("Expression"));

def("JSXElement")
    .bases("Expression")
    .build("openingElement", "closingElement", "children")
    .field("openingElement", def("JSXOpeningElement"))
    .field("closingElement", or(def("JSXClosingElement"), null), defaults["null"])
    .field("children", [or(
        def("JSXElement"),
        def("JSXExpressionContainer"),
        def("JSXText"),
        def("Literal") // TODO Esprima should return JSXText instead.
    )], defaults.emptyArray)
    .field("name", JSXElementName, function() {
        // Little-known fact: the `this` object inside a default function
        // is none other than the partially-built object itself, and any
        // fields initialized directly from builder function arguments
        // (like openingElement, closingElement, and children) are
        // guaranteed to be available.
        return this.openingElement.name;
    }, true) // hidden from traversal
    .field("selfClosing", Boolean, function() {
        return this.openingElement.selfClosing;
    }, true) // hidden from traversal
    .field("attributes", JSXAttributes, function() {
        return this.openingElement.attributes;
    }, true); // hidden from traversal

def("JSXOpeningElement")
    .bases("Node") // TODO Does this make sense? Can't really be an JSXElement.
    .build("name", "attributes", "selfClosing")
    .field("name", JSXElementName)
    .field("attributes", JSXAttributes, defaults.emptyArray)
    .field("selfClosing", Boolean, defaults["false"]);

def("JSXClosingElement")
    .bases("Node") // TODO Same concern.
    .build("name")
    .field("name", JSXElementName);

def("JSXText")
    .bases("Literal")
    .build("value")
    .field("value", String);

def("JSXEmptyExpression").bases("Expression").build();

// Type Annotations
def("Type").bases("Node");

def("AnyTypeAnnotation")
  .bases("Type")
  .build();

def("MixedTypeAnnotation")
  .bases("Type")
  .build();

def("VoidTypeAnnotation")
  .bases("Type")
  .build();

def("NumberTypeAnnotation")
  .bases("Type")
  .build();

def("NumberLiteralTypeAnnotation")
  .bases("Type")
  .build("value", "raw")
  .field("value", Number)
  .field("raw", String);

def("StringTypeAnnotation")
  .bases("Type")
  .build();

def("StringLiteralTypeAnnotation")
  .bases("Type")
  .build("value", "raw")
  .field("value", String)
  .field("raw", String);

def("BooleanTypeAnnotation")
  .bases("Type")
  .build();

def("BooleanLiteralTypeAnnotation")
  .bases("Type")
  .build("value", "raw")
  .field("value", Boolean)
  .field("raw", String);

def("TypeAnnotation")
  .bases("Node")
  .build("typeAnnotation")
  .field("typeAnnotation", def("Type"));

def("NullableTypeAnnotation")
  .bases("Type")
  .build("typeAnnotation")
  .field("typeAnnotation", def("Type"));

def("FunctionTypeAnnotation")
  .bases("Type")
  .build("params", "returnType", "rest", "typeParameters")
  .field("params", [def("FunctionTypeParam")])
  .field("returnType", def("Type"))
  .field("rest", or(def("FunctionTypeParam"), null))
  .field("typeParameters", or(def("TypeParameterDeclaration"), null));

def("FunctionTypeParam")
  .bases("Node")
  .build("name", "typeAnnotation", "optional")
  .field("name", def("Identifier"))
  .field("typeAnnotation", def("Type"))
  .field("optional", Boolean);

def("ArrayTypeAnnotation")
  .bases("Type")
  .build("elementType")
  .field("elementType", def("Type"));

def("ObjectTypeAnnotation")
  .bases("Type")
  .build("properties")
  .field("properties", [def("ObjectTypeProperty")])
  .field("indexers", [def("ObjectTypeIndexer")], defaults.emptyArray)
  .field("callProperties",
         [def("ObjectTypeCallProperty")],
         defaults.emptyArray);

def("ObjectTypeProperty")
  .bases("Node")
  .build("key", "value", "optional")
  .field("key", or(def("Literal"), def("Identifier")))
  .field("value", def("Type"))
  .field("optional", Boolean);

def("ObjectTypeIndexer")
  .bases("Node")
  .build("id", "key", "value")
  .field("id", def("Identifier"))
  .field("key", def("Type"))
  .field("value", def("Type"));

def("ObjectTypeCallProperty")
  .bases("Node")
  .build("value")
  .field("value", def("FunctionTypeAnnotation"))
  .field("static", Boolean, false);

def("QualifiedTypeIdentifier")
  .bases("Node")
  .build("qualification", "id")
  .field("qualification",
         or(def("Identifier"),
            def("QualifiedTypeIdentifier")))
  .field("id", def("Identifier"));

def("GenericTypeAnnotation")
  .bases("Type")
  .build("id", "typeParameters")
  .field("id", or(def("Identifier"), def("QualifiedTypeIdentifier")))
  .field("typeParameters", or(def("TypeParameterInstantiation"), null));

def("MemberTypeAnnotation")
  .bases("Type")
  .build("object", "property")
  .field("object", def("Identifier"))
  .field("property",
         or(def("MemberTypeAnnotation"),
            def("GenericTypeAnnotation")));

def("UnionTypeAnnotation")
  .bases("Type")
  .build("types")
  .field("types", [def("Type")]);

def("IntersectionTypeAnnotation")
  .bases("Type")
  .build("types")
  .field("types", [def("Type")]);

def("TypeofTypeAnnotation")
  .bases("Type")
  .build("argument")
  .field("argument", def("Type"));

def("Identifier")
  .field("typeAnnotation", or(def("TypeAnnotation"), null), defaults["null"]);

def("TypeParameterDeclaration")
  .bases("Node")
  .build("params")
  .field("params", [def("Identifier")]);

def("TypeParameterInstantiation")
  .bases("Node")
  .build("params")
  .field("params", [def("Type")]);

def("Function")
  .field("returnType",
         or(def("TypeAnnotation"), null),
         defaults["null"])
  .field("typeParameters",
         or(def("TypeParameterDeclaration"), null),
         defaults["null"]);

def("ClassProperty")
  .build("key", "value", "typeAnnotation", "static")
  .field("value", or(def("Expression"), null))
  .field("typeAnnotation", or(def("TypeAnnotation"), null))
  .field("static", Boolean, defaults["false"]);

def("ClassImplements")
  .field("typeParameters",
         or(def("TypeParameterInstantiation"), null),
         defaults["null"]);

def("InterfaceDeclaration")
  .bases("Statement")
  .build("id", "body", "extends")
  .field("id", def("Identifier"))
  .field("typeParameters",
         or(def("TypeParameterDeclaration"), null),
         defaults["null"])
  .field("body", def("ObjectTypeAnnotation"))
  .field("extends", [def("InterfaceExtends")]);

def("InterfaceExtends")
  .bases("Node")
  .build("id")
  .field("id", def("Identifier"))
  .field("typeParameters", or(def("TypeParameterInstantiation"), null));

def("TypeAlias")
  .bases("Statement")
  .build("id", "typeParameters", "right")
  .field("id", def("Identifier"))
  .field("typeParameters", or(def("TypeParameterDeclaration"), null))
  .field("right", def("Type"));

def("TypeCastExpression")
  .bases("Expression")
  .build("expression", "typeAnnotation")
  .field("expression", def("Expression"))
  .field("typeAnnotation", def("TypeAnnotation"));

def("TupleTypeAnnotation")
  .bases("Type")
  .build("types")
  .field("types", [def("Type")]);

def("DeclareVariable")
  .bases("Statement")
  .build("id")
  .field("id", def("Identifier"));

def("DeclareFunction")
  .bases("Statement")
  .build("id")
  .field("id", def("Identifier"));

def("DeclareClass")
  .bases("InterfaceDeclaration")
  .build("id");

def("DeclareModule")
  .bases("Statement")
  .build("id", "body")
  .field("id", or(def("Identifier"), def("Literal")))
  .field("body", def("BlockStatement"));

},{"../lib/shared":186,"../lib/types":187,"./es7":177}],180:[function(require,module,exports){
require("./core");
var types = require("../lib/types");
var def = types.Type.def;
var or = types.Type.or;
var shared = require("../lib/shared");
var geq = shared.geq;
var defaults = shared.defaults;

def("Function")
    // SpiderMonkey allows expression closures: function(x) x+1
    .field("body", or(def("BlockStatement"), def("Expression")));

def("ForInStatement")
    .build("left", "right", "body", "each")
    .field("each", Boolean, defaults["false"]);

def("ForOfStatement")
    .bases("Statement")
    .build("left", "right", "body")
    .field("left", or(
        def("VariableDeclaration"),
        def("Expression")))
    .field("right", def("Expression"))
    .field("body", def("Statement"));

def("LetStatement")
    .bases("Statement")
    .build("head", "body")
    // TODO Deviating from the spec by reusing VariableDeclarator here.
    .field("head", [def("VariableDeclarator")])
    .field("body", def("Statement"));

def("LetExpression")
    .bases("Expression")
    .build("head", "body")
    // TODO Deviating from the spec by reusing VariableDeclarator here.
    .field("head", [def("VariableDeclarator")])
    .field("body", def("Expression"));

def("GraphExpression")
    .bases("Expression")
    .build("index", "expression")
    .field("index", geq(0))
    .field("expression", def("Literal"));

def("GraphIndexExpression")
    .bases("Expression")
    .build("index")
    .field("index", geq(0));

},{"../lib/shared":186,"../lib/types":187,"./core":174}],181:[function(require,module,exports){
var types = require("../main");
var getFieldNames = types.getFieldNames;
var getFieldValue = types.getFieldValue;
var isArray = types.builtInTypes.array;
var isObject = types.builtInTypes.object;
var isDate = types.builtInTypes.Date;
var isRegExp = types.builtInTypes.RegExp;
var hasOwn = Object.prototype.hasOwnProperty;

function astNodesAreEquivalent(a, b, problemPath) {
    if (isArray.check(problemPath)) {
        problemPath.length = 0;
    } else {
        problemPath = null;
    }

    return areEquivalent(a, b, problemPath);
}

astNodesAreEquivalent.assert = function(a, b) {
    var problemPath = [];
    if (!astNodesAreEquivalent(a, b, problemPath)) {
        if (problemPath.length === 0) {
            if (a !== b) {
                throw new Error("Nodes must be equal");
            }
        } else {
            throw new Error(
                "Nodes differ in the following path: " +
                    problemPath.map(subscriptForProperty).join("")
            );
        }
    }
};

function subscriptForProperty(property) {
    if (/[_$a-z][_$a-z0-9]*/i.test(property)) {
        return "." + property;
    }
    return "[" + JSON.stringify(property) + "]";
}

function areEquivalent(a, b, problemPath) {
    if (a === b) {
        return true;
    }

    if (isArray.check(a)) {
        return arraysAreEquivalent(a, b, problemPath);
    }

    if (isObject.check(a)) {
        return objectsAreEquivalent(a, b, problemPath);
    }

    if (isDate.check(a)) {
        return isDate.check(b) && (+a === +b);
    }

    if (isRegExp.check(a)) {
        return isRegExp.check(b) && (
            a.source === b.source &&
            a.global === b.global &&
            a.multiline === b.multiline &&
            a.ignoreCase === b.ignoreCase
        );
    }

    return a == b;
}

function arraysAreEquivalent(a, b, problemPath) {
    isArray.assert(a);
    var aLength = a.length;

    if (!isArray.check(b) || b.length !== aLength) {
        if (problemPath) {
            problemPath.push("length");
        }
        return false;
    }

    for (var i = 0; i < aLength; ++i) {
        if (problemPath) {
            problemPath.push(i);
        }

        if (i in a !== i in b) {
            return false;
        }

        if (!areEquivalent(a[i], b[i], problemPath)) {
            return false;
        }

        if (problemPath) {
            var problemPathTail = problemPath.pop();
            if (problemPathTail !== i) {
                throw new Error("" + problemPathTail);
            }
        }
    }

    return true;
}

function objectsAreEquivalent(a, b, problemPath) {
    isObject.assert(a);
    if (!isObject.check(b)) {
        return false;
    }

    // Fast path for a common property of AST nodes.
    if (a.type !== b.type) {
        if (problemPath) {
            problemPath.push("type");
        }
        return false;
    }

    var aNames = getFieldNames(a);
    var aNameCount = aNames.length;

    var bNames = getFieldNames(b);
    var bNameCount = bNames.length;

    if (aNameCount === bNameCount) {
        for (var i = 0; i < aNameCount; ++i) {
            var name = aNames[i];
            var aChild = getFieldValue(a, name);
            var bChild = getFieldValue(b, name);

            if (problemPath) {
                problemPath.push(name);
            }

            if (!areEquivalent(aChild, bChild, problemPath)) {
                return false;
            }

            if (problemPath) {
                var problemPathTail = problemPath.pop();
                if (problemPathTail !== name) {
                    throw new Error("" + problemPathTail);
                }
            }
        }

        return true;
    }

    if (!problemPath) {
        return false;
    }

    // Since aNameCount !== bNameCount, we need to find some name that's
    // missing in aNames but present in bNames, or vice-versa.

    var seenNames = Object.create(null);

    for (i = 0; i < aNameCount; ++i) {
        seenNames[aNames[i]] = true;
    }

    for (i = 0; i < bNameCount; ++i) {
        name = bNames[i];

        if (!hasOwn.call(seenNames, name)) {
            problemPath.push(name);
            return false;
        }

        delete seenNames[name];
    }

    for (name in seenNames) {
        problemPath.push(name);
        break;
    }

    return false;
}

module.exports = astNodesAreEquivalent;

},{"../main":188}],182:[function(require,module,exports){
var types = require("./types");
var n = types.namedTypes;
var b = types.builders;
var isNumber = types.builtInTypes.number;
var isArray = types.builtInTypes.array;
var Path = require("./path");
var Scope = require("./scope");

function NodePath(value, parentPath, name) {
    if (!(this instanceof NodePath)) {
        throw new Error("NodePath constructor cannot be invoked without 'new'");
    }
    Path.call(this, value, parentPath, name);
}

var NPp = NodePath.prototype = Object.create(Path.prototype, {
    constructor: {
        value: NodePath,
        enumerable: false,
        writable: true,
        configurable: true
    }
});

Object.defineProperties(NPp, {
    node: {
        get: function() {
            Object.defineProperty(this, "node", {
                configurable: true, // Enable deletion.
                value: this._computeNode()
            });

            return this.node;
        }
    },

    parent: {
        get: function() {
            Object.defineProperty(this, "parent", {
                configurable: true, // Enable deletion.
                value: this._computeParent()
            });

            return this.parent;
        }
    },

    scope: {
        get: function() {
            Object.defineProperty(this, "scope", {
                configurable: true, // Enable deletion.
                value: this._computeScope()
            });

            return this.scope;
        }
    }
});

NPp.replace = function() {
    delete this.node;
    delete this.parent;
    delete this.scope;
    return Path.prototype.replace.apply(this, arguments);
};

NPp.prune = function() {
    var remainingNodePath = this.parent;

    this.replace();

    return cleanUpNodesAfterPrune(remainingNodePath);
};

// The value of the first ancestor Path whose value is a Node.
NPp._computeNode = function() {
    var value = this.value;
    if (n.Node.check(value)) {
        return value;
    }

    var pp = this.parentPath;
    return pp && pp.node || null;
};

// The first ancestor Path whose value is a Node distinct from this.node.
NPp._computeParent = function() {
    var value = this.value;
    var pp = this.parentPath;

    if (!n.Node.check(value)) {
        while (pp && !n.Node.check(pp.value)) {
            pp = pp.parentPath;
        }

        if (pp) {
            pp = pp.parentPath;
        }
    }

    while (pp && !n.Node.check(pp.value)) {
        pp = pp.parentPath;
    }

    return pp || null;
};

// The closest enclosing scope that governs this node.
NPp._computeScope = function() {
    var value = this.value;
    var pp = this.parentPath;
    var scope = pp && pp.scope;

    if (n.Node.check(value) &&
        Scope.isEstablishedBy(value)) {
        scope = new Scope(this, scope);
    }

    return scope || null;
};

NPp.getValueProperty = function(name) {
    return types.getFieldValue(this.value, name);
};

/**
 * Determine whether this.node needs to be wrapped in parentheses in order
 * for a parser to reproduce the same local AST structure.
 *
 * For instance, in the expression `(1 + 2) * 3`, the BinaryExpression
 * whose operator is "+" needs parentheses, because `1 + 2 * 3` would
 * parse differently.
 *
 * If assumeExpressionContext === true, we don't worry about edge cases
 * like an anonymous FunctionExpression appearing lexically first in its
 * enclosing statement and thus needing parentheses to avoid being parsed
 * as a FunctionDeclaration with a missing name.
 */
NPp.needsParens = function(assumeExpressionContext) {
    var pp = this.parentPath;
    if (!pp) {
        return false;
    }

    var node = this.value;

    // Only expressions need parentheses.
    if (!n.Expression.check(node)) {
        return false;
    }

    // Identifiers never need parentheses.
    if (node.type === "Identifier") {
        return false;
    }

    while (!n.Node.check(pp.value)) {
        pp = pp.parentPath;
        if (!pp) {
            return false;
        }
    }

    var parent = pp.value;

    switch (node.type) {
    case "UnaryExpression":
    case "SpreadElement":
    case "SpreadProperty":
        return parent.type === "MemberExpression"
            && this.name === "object"
            && parent.object === node;

    case "BinaryExpression":
    case "LogicalExpression":
        switch (parent.type) {
        case "CallExpression":
            return this.name === "callee"
                && parent.callee === node;

        case "UnaryExpression":
        case "SpreadElement":
        case "SpreadProperty":
            return true;

        case "MemberExpression":
            return this.name === "object"
                && parent.object === node;

        case "BinaryExpression":
        case "LogicalExpression":
            var po = parent.operator;
            var pp = PRECEDENCE[po];
            var no = node.operator;
            var np = PRECEDENCE[no];

            if (pp > np) {
                return true;
            }

            if (pp === np && this.name === "right") {
                if (parent.right !== node) {
                    throw new Error("Nodes must be equal");
                }
                return true;
            }

        default:
            return false;
        }

    case "SequenceExpression":
        switch (parent.type) {
        case "ForStatement":
            // Although parentheses wouldn't hurt around sequence
            // expressions in the head of for loops, traditional style
            // dictates that e.g. i++, j++ should not be wrapped with
            // parentheses.
            return false;

        case "ExpressionStatement":
            return this.name !== "expression";

        default:
            // Otherwise err on the side of overparenthesization, adding
            // explicit exceptions above if this proves overzealous.
            return true;
        }

    case "YieldExpression":
        switch (parent.type) {
        case "BinaryExpression":
        case "LogicalExpression":
        case "UnaryExpression":
        case "SpreadElement":
        case "SpreadProperty":
        case "CallExpression":
        case "MemberExpression":
        case "NewExpression":
        case "ConditionalExpression":
        case "YieldExpression":
            return true;

        default:
            return false;
        }

    case "Literal":
        return parent.type === "MemberExpression"
            && isNumber.check(node.value)
            && this.name === "object"
            && parent.object === node;

    case "AssignmentExpression":
    case "ConditionalExpression":
        switch (parent.type) {
        case "UnaryExpression":
        case "SpreadElement":
        case "SpreadProperty":
        case "BinaryExpression":
        case "LogicalExpression":
            return true;

        case "CallExpression":
            return this.name === "callee"
                && parent.callee === node;

        case "ConditionalExpression":
            return this.name === "test"
                && parent.test === node;

        case "MemberExpression":
            return this.name === "object"
                && parent.object === node;

        default:
            return false;
        }

    default:
        if (parent.type === "NewExpression" &&
            this.name === "callee" &&
            parent.callee === node) {
            return containsCallExpression(node);
        }
    }

    if (assumeExpressionContext !== true &&
        !this.canBeFirstInStatement() &&
        this.firstInStatement())
        return true;

    return false;
};

function isBinary(node) {
    return n.BinaryExpression.check(node)
        || n.LogicalExpression.check(node);
}

function isUnaryLike(node) {
    return n.UnaryExpression.check(node)
        // I considered making SpreadElement and SpreadProperty subtypes
        // of UnaryExpression, but they're not really Expression nodes.
        || (n.SpreadElement && n.SpreadElement.check(node))
        || (n.SpreadProperty && n.SpreadProperty.check(node));
}

var PRECEDENCE = {};
[["||"],
 ["&&"],
 ["|"],
 ["^"],
 ["&"],
 ["==", "===", "!=", "!=="],
 ["<", ">", "<=", ">=", "in", "instanceof"],
 [">>", "<<", ">>>"],
 ["+", "-"],
 ["*", "/", "%"]
].forEach(function(tier, i) {
    tier.forEach(function(op) {
        PRECEDENCE[op] = i;
    });
});

function containsCallExpression(node) {
    if (n.CallExpression.check(node)) {
        return true;
    }

    if (isArray.check(node)) {
        return node.some(containsCallExpression);
    }

    if (n.Node.check(node)) {
        return types.someField(node, function(name, child) {
            return containsCallExpression(child);
        });
    }

    return false;
}

NPp.canBeFirstInStatement = function() {
    var node = this.node;
    return !n.FunctionExpression.check(node)
        && !n.ObjectExpression.check(node);
};

NPp.firstInStatement = function() {
    return firstInStatement(this);
};

function firstInStatement(path) {
    for (var node, parent; path.parent; path = path.parent) {
        node = path.node;
        parent = path.parent.node;

        if (n.BlockStatement.check(parent) &&
            path.parent.name === "body" &&
            path.name === 0) {
            if (parent.body[0] !== node) {
                throw new Error("Nodes must be equal");
            }
            return true;
        }

        if (n.ExpressionStatement.check(parent) &&
            path.name === "expression") {
            if (parent.expression !== node) {
                throw new Error("Nodes must be equal");
            }
            return true;
        }

        if (n.SequenceExpression.check(parent) &&
            path.parent.name === "expressions" &&
            path.name === 0) {
            if (parent.expressions[0] !== node) {
                throw new Error("Nodes must be equal");
            }
            continue;
        }

        if (n.CallExpression.check(parent) &&
            path.name === "callee") {
            if (parent.callee !== node) {
                throw new Error("Nodes must be equal");
            }
            continue;
        }

        if (n.MemberExpression.check(parent) &&
            path.name === "object") {
            if (parent.object !== node) {
                throw new Error("Nodes must be equal");
            }
            continue;
        }

        if (n.ConditionalExpression.check(parent) &&
            path.name === "test") {
            if (parent.test !== node) {
                throw new Error("Nodes must be equal");
            }
            continue;
        }

        if (isBinary(parent) &&
            path.name === "left") {
            if (parent.left !== node) {
                throw new Error("Nodes must be equal");
            }
            continue;
        }

        if (n.UnaryExpression.check(parent) &&
            !parent.prefix &&
            path.name === "argument") {
            if (parent.argument !== node) {
                throw new Error("Nodes must be equal");
            }
            continue;
        }

        return false;
    }

    return true;
}

/**
 * Pruning certain nodes will result in empty or incomplete nodes, here we clean those nodes up.
 */
function cleanUpNodesAfterPrune(remainingNodePath) {
    if (n.VariableDeclaration.check(remainingNodePath.node)) {
        var declarations = remainingNodePath.get('declarations').value;
        if (!declarations || declarations.length === 0) {
            return remainingNodePath.prune();
        }
    } else if (n.ExpressionStatement.check(remainingNodePath.node)) {
        if (!remainingNodePath.get('expression').value) {
            return remainingNodePath.prune();
        }
    } else if (n.IfStatement.check(remainingNodePath.node)) {
        cleanUpIfStatementAfterPrune(remainingNodePath);
    }

    return remainingNodePath;
}

function cleanUpIfStatementAfterPrune(ifStatement) {
    var testExpression = ifStatement.get('test').value;
    var alternate = ifStatement.get('alternate').value;
    var consequent = ifStatement.get('consequent').value;

    if (!consequent && !alternate) {
        var testExpressionStatement = b.expressionStatement(testExpression);

        ifStatement.replace(testExpressionStatement);
    } else if (!consequent && alternate) {
        var negatedTestExpression = b.unaryExpression('!', testExpression, true);

        if (n.UnaryExpression.check(testExpression) && testExpression.operator === '!') {
            negatedTestExpression = testExpression.argument;
        }

        ifStatement.get("test").replace(negatedTestExpression);
        ifStatement.get("consequent").replace(alternate);
        ifStatement.get("alternate").replace();
    }
}

module.exports = NodePath;

},{"./path":184,"./scope":185,"./types":187}],183:[function(require,module,exports){
var types = require("./types");
var NodePath = require("./node-path");
var Printable = types.namedTypes.Printable;
var isArray = types.builtInTypes.array;
var isObject = types.builtInTypes.object;
var isFunction = types.builtInTypes.function;
var hasOwn = Object.prototype.hasOwnProperty;
var undefined;

function PathVisitor() {
    if (!(this instanceof PathVisitor)) {
        throw new Error(
            "PathVisitor constructor cannot be invoked without 'new'"
        );
    }

    // Permanent state.
    this._reusableContextStack = [];

    this._methodNameTable = computeMethodNameTable(this);
    this._shouldVisitComments =
        hasOwn.call(this._methodNameTable, "Block") ||
        hasOwn.call(this._methodNameTable, "Line");

    this.Context = makeContextConstructor(this);

    // State reset every time PathVisitor.prototype.visit is called.
    this._visiting = false;
    this._changeReported = false;
}

function computeMethodNameTable(visitor) {
    var typeNames = Object.create(null);

    for (var methodName in visitor) {
        if (/^visit[A-Z]/.test(methodName)) {
            typeNames[methodName.slice("visit".length)] = true;
        }
    }

    var supertypeTable = types.computeSupertypeLookupTable(typeNames);
    var methodNameTable = Object.create(null);

    var typeNames = Object.keys(supertypeTable);
    var typeNameCount = typeNames.length;
    for (var i = 0; i < typeNameCount; ++i) {
        var typeName = typeNames[i];
        methodName = "visit" + supertypeTable[typeName];
        if (isFunction.check(visitor[methodName])) {
            methodNameTable[typeName] = methodName;
        }
    }

    return methodNameTable;
}

PathVisitor.fromMethodsObject = function fromMethodsObject(methods) {
    if (methods instanceof PathVisitor) {
        return methods;
    }

    if (!isObject.check(methods)) {
        // An empty visitor?
        return new PathVisitor;
    }

    function Visitor() {
        if (!(this instanceof Visitor)) {
            throw new Error(
                "Visitor constructor cannot be invoked without 'new'"
            );
        }
        PathVisitor.call(this);
    }

    var Vp = Visitor.prototype = Object.create(PVp);
    Vp.constructor = Visitor;

    extend(Vp, methods);
    extend(Visitor, PathVisitor);

    isFunction.assert(Visitor.fromMethodsObject);
    isFunction.assert(Visitor.visit);

    return new Visitor;
};

function extend(target, source) {
    for (var property in source) {
        if (hasOwn.call(source, property)) {
            target[property] = source[property];
        }
    }

    return target;
}

PathVisitor.visit = function visit(node, methods) {
    return PathVisitor.fromMethodsObject(methods).visit(node);
};

var PVp = PathVisitor.prototype;

PVp.visit = function() {
    if (this._visiting) {
        throw new Error(
            "Recursively calling visitor.visit(path) resets visitor state. " +
                "Try this.visit(path) or this.traverse(path) instead."
        );
    }

    // Private state that needs to be reset before every traversal.
    this._visiting = true;
    this._changeReported = false;
    this._abortRequested = false;

    var argc = arguments.length;
    var args = new Array(argc)
    for (var i = 0; i < argc; ++i) {
        args[i] = arguments[i];
    }

    if (!(args[0] instanceof NodePath)) {
        args[0] = new NodePath({ root: args[0] }).get("root");
    }

    // Called with the same arguments as .visit.
    this.reset.apply(this, args);

    try {
        var root = this.visitWithoutReset(args[0]);
        var didNotThrow = true;
    } finally {
        this._visiting = false;

        if (!didNotThrow && this._abortRequested) {
            // If this.visitWithoutReset threw an exception and
            // this._abortRequested was set to true, return the root of
            // the AST instead of letting the exception propagate, so that
            // client code does not have to provide a try-catch block to
            // intercept the AbortRequest exception.  Other kinds of
            // exceptions will propagate without being intercepted and
            // rethrown by a catch block, so their stacks will accurately
            // reflect the original throwing context.
            return args[0].value;
        }
    }

    return root;
};

PVp.AbortRequest = function AbortRequest() {};
PVp.abort = function() {
    var visitor = this;
    visitor._abortRequested = true;
    var request = new visitor.AbortRequest();

    // If you decide to catch this exception and stop it from propagating,
    // make sure to call its cancel method to avoid silencing other
    // exceptions that might be thrown later in the traversal.
    request.cancel = function() {
        visitor._abortRequested = false;
    };

    throw request;
};

PVp.reset = function(path/*, additional arguments */) {
    // Empty stub; may be reassigned or overridden by subclasses.
};

PVp.visitWithoutReset = function(path) {
    if (this instanceof this.Context) {
        // Since this.Context.prototype === this, there's a chance we
        // might accidentally call context.visitWithoutReset. If that
        // happens, re-invoke the method against context.visitor.
        return this.visitor.visitWithoutReset(path);
    }

    if (!(path instanceof NodePath)) {
        throw new Error("");
    }

    var value = path.value;

    var methodName = value &&
        typeof value === "object" &&
        typeof value.type === "string" &&
        this._methodNameTable[value.type];

    if (methodName) {
        var context = this.acquireContext(path);
        try {
            return context.invokeVisitorMethod(methodName);
        } finally {
            this.releaseContext(context);
        }

    } else {
        // If there was no visitor method to call, visit the children of
        // this node generically.
        return visitChildren(path, this);
    }
};

function visitChildren(path, visitor) {
    if (!(path instanceof NodePath)) {
        throw new Error("");
    }
    if (!(visitor instanceof PathVisitor)) {
        throw new Error("");
    }

    var value = path.value;

    if (isArray.check(value)) {
        path.each(visitor.visitWithoutReset, visitor);
    } else if (!isObject.check(value)) {
        // No children to visit.
    } else {
        var childNames = types.getFieldNames(value);

        // The .comments field of the Node type is hidden, so we only
        // visit it if the visitor defines visitBlock or visitLine, and
        // value.comments is defined.
        if (visitor._shouldVisitComments &&
            value.comments &&
            childNames.indexOf("comments") < 0) {
            childNames.push("comments");
        }

        var childCount = childNames.length;
        var childPaths = [];

        for (var i = 0; i < childCount; ++i) {
            var childName = childNames[i];
            if (!hasOwn.call(value, childName)) {
                value[childName] = types.getFieldValue(value, childName);
            }
            childPaths.push(path.get(childName));
        }

        for (var i = 0; i < childCount; ++i) {
            visitor.visitWithoutReset(childPaths[i]);
        }
    }

    return path.value;
}

PVp.acquireContext = function(path) {
    if (this._reusableContextStack.length === 0) {
        return new this.Context(path);
    }
    return this._reusableContextStack.pop().reset(path);
};

PVp.releaseContext = function(context) {
    if (!(context instanceof this.Context)) {
        throw new Error("");
    }
    this._reusableContextStack.push(context);
    context.currentPath = null;
};

PVp.reportChanged = function() {
    this._changeReported = true;
};

PVp.wasChangeReported = function() {
    return this._changeReported;
};

function makeContextConstructor(visitor) {
    function Context(path) {
        if (!(this instanceof Context)) {
            throw new Error("");
        }
        if (!(this instanceof PathVisitor)) {
            throw new Error("");
        }
        if (!(path instanceof NodePath)) {
            throw new Error("");
        }

        Object.defineProperty(this, "visitor", {
            value: visitor,
            writable: false,
            enumerable: true,
            configurable: false
        });

        this.currentPath = path;
        this.needToCallTraverse = true;

        Object.seal(this);
    }

    if (!(visitor instanceof PathVisitor)) {
        throw new Error("");
    }

    // Note that the visitor object is the prototype of Context.prototype,
    // so all visitor methods are inherited by context objects.
    var Cp = Context.prototype = Object.create(visitor);

    Cp.constructor = Context;
    extend(Cp, sharedContextProtoMethods);

    return Context;
}

// Every PathVisitor has a different this.Context constructor and
// this.Context.prototype object, but those prototypes can all use the
// same reset, invokeVisitorMethod, and traverse function objects.
var sharedContextProtoMethods = Object.create(null);

sharedContextProtoMethods.reset =
function reset(path) {
    if (!(this instanceof this.Context)) {
        throw new Error("");
    }
    if (!(path instanceof NodePath)) {
        throw new Error("");
    }

    this.currentPath = path;
    this.needToCallTraverse = true;

    return this;
};

sharedContextProtoMethods.invokeVisitorMethod =
function invokeVisitorMethod(methodName) {
    if (!(this instanceof this.Context)) {
        throw new Error("");
    }
    if (!(this.currentPath instanceof NodePath)) {
        throw new Error("");
    }

    var result = this.visitor[methodName].call(this, this.currentPath);

    if (result === false) {
        // Visitor methods return false to indicate that they have handled
        // their own traversal needs, and we should not complain if
        // this.needToCallTraverse is still true.
        this.needToCallTraverse = false;

    } else if (result !== undefined) {
        // Any other non-undefined value returned from the visitor method
        // is interpreted as a replacement value.
        this.currentPath = this.currentPath.replace(result)[0];

        if (this.needToCallTraverse) {
            // If this.traverse still hasn't been called, visit the
            // children of the replacement node.
            this.traverse(this.currentPath);
        }
    }

    if (this.needToCallTraverse !== false) {
        throw new Error(
            "Must either call this.traverse or return false in " + methodName
        );
    }

    var path = this.currentPath;
    return path && path.value;
};

sharedContextProtoMethods.traverse =
function traverse(path, newVisitor) {
    if (!(this instanceof this.Context)) {
        throw new Error("");
    }
    if (!(path instanceof NodePath)) {
        throw new Error("");
    }
    if (!(this.currentPath instanceof NodePath)) {
        throw new Error("");
    }

    this.needToCallTraverse = false;

    return visitChildren(path, PathVisitor.fromMethodsObject(
        newVisitor || this.visitor
    ));
};

sharedContextProtoMethods.visit =
function visit(path, newVisitor) {
    if (!(this instanceof this.Context)) {
        throw new Error("");
    }
    if (!(path instanceof NodePath)) {
        throw new Error("");
    }
    if (!(this.currentPath instanceof NodePath)) {
        throw new Error("");
    }

    this.needToCallTraverse = false;

    return PathVisitor.fromMethodsObject(
        newVisitor || this.visitor
    ).visitWithoutReset(path);
};

sharedContextProtoMethods.reportChanged = function reportChanged() {
    this.visitor.reportChanged();
};

sharedContextProtoMethods.abort = function abort() {
    this.needToCallTraverse = false;
    this.visitor.abort();
};

module.exports = PathVisitor;

},{"./node-path":182,"./types":187}],184:[function(require,module,exports){
var Op = Object.prototype;
var hasOwn = Op.hasOwnProperty;
var types = require("./types");
var isArray = types.builtInTypes.array;
var isNumber = types.builtInTypes.number;
var Ap = Array.prototype;
var slice = Ap.slice;
var map = Ap.map;

function Path(value, parentPath, name) {
    if (!(this instanceof Path)) {
        throw new Error("Path constructor cannot be invoked without 'new'");
    }

    if (parentPath) {
        if (!(parentPath instanceof Path)) {
            throw new Error("");
        }
    } else {
        parentPath = null;
        name = null;
    }

    // The value encapsulated by this Path, generally equal to
    // parentPath.value[name] if we have a parentPath.
    this.value = value;

    // The immediate parent Path of this Path.
    this.parentPath = parentPath;

    // The name of the property of parentPath.value through which this
    // Path's value was reached.
    this.name = name;

    // Calling path.get("child") multiple times always returns the same
    // child Path object, for both performance and consistency reasons.
    this.__childCache = null;
}

var Pp = Path.prototype;

function getChildCache(path) {
    // Lazily create the child cache. This also cheapens cache
    // invalidation, since you can just reset path.__childCache to null.
    return path.__childCache || (path.__childCache = Object.create(null));
}

function getChildPath(path, name) {
    var cache = getChildCache(path);
    var actualChildValue = path.getValueProperty(name);
    var childPath = cache[name];
    if (!hasOwn.call(cache, name) ||
        // Ensure consistency between cache and reality.
        childPath.value !== actualChildValue) {
        childPath = cache[name] = new path.constructor(
            actualChildValue, path, name
        );
    }
    return childPath;
}

// This method is designed to be overridden by subclasses that need to
// handle missing properties, etc.
Pp.getValueProperty = function getValueProperty(name) {
    return this.value[name];
};

Pp.get = function get(name) {
    var path = this;
    var names = arguments;
    var count = names.length;

    for (var i = 0; i < count; ++i) {
        path = getChildPath(path, names[i]);
    }

    return path;
};

Pp.each = function each(callback, context) {
    var childPaths = [];
    var len = this.value.length;
    var i = 0;

    // Collect all the original child paths before invoking the callback.
    for (var i = 0; i < len; ++i) {
        if (hasOwn.call(this.value, i)) {
            childPaths[i] = this.get(i);
        }
    }

    // Invoke the callback on just the original child paths, regardless of
    // any modifications made to the array by the callback. I chose these
    // semantics over cleverly invoking the callback on new elements because
    // this way is much easier to reason about.
    context = context || this;
    for (i = 0; i < len; ++i) {
        if (hasOwn.call(childPaths, i)) {
            callback.call(context, childPaths[i]);
        }
    }
};

Pp.map = function map(callback, context) {
    var result = [];

    this.each(function(childPath) {
        result.push(callback.call(this, childPath));
    }, context);

    return result;
};

Pp.filter = function filter(callback, context) {
    var result = [];

    this.each(function(childPath) {
        if (callback.call(this, childPath)) {
            result.push(childPath);
        }
    }, context);

    return result;
};

function emptyMoves() {}
function getMoves(path, offset, start, end) {
    isArray.assert(path.value);

    if (offset === 0) {
        return emptyMoves;
    }

    var length = path.value.length;
    if (length < 1) {
        return emptyMoves;
    }

    var argc = arguments.length;
    if (argc === 2) {
        start = 0;
        end = length;
    } else if (argc === 3) {
        start = Math.max(start, 0);
        end = length;
    } else {
        start = Math.max(start, 0);
        end = Math.min(end, length);
    }

    isNumber.assert(start);
    isNumber.assert(end);

    var moves = Object.create(null);
    var cache = getChildCache(path);

    for (var i = start; i < end; ++i) {
        if (hasOwn.call(path.value, i)) {
            var childPath = path.get(i);
            if (childPath.name !== i) {
                throw new Error("");
            }
            var newIndex = i + offset;
            childPath.name = newIndex;
            moves[newIndex] = childPath;
            delete cache[i];
        }
    }

    delete cache.length;

    return function() {
        for (var newIndex in moves) {
            var childPath = moves[newIndex];
            if (childPath.name !== +newIndex) {
                throw new Error("");
            }
            cache[newIndex] = childPath;
            path.value[newIndex] = childPath.value;
        }
    };
}

Pp.shift = function shift() {
    var move = getMoves(this, -1);
    var result = this.value.shift();
    move();
    return result;
};

Pp.unshift = function unshift(node) {
    var move = getMoves(this, arguments.length);
    var result = this.value.unshift.apply(this.value, arguments);
    move();
    return result;
};

Pp.push = function push(node) {
    isArray.assert(this.value);
    delete getChildCache(this).length
    return this.value.push.apply(this.value, arguments);
};

Pp.pop = function pop() {
    isArray.assert(this.value);
    var cache = getChildCache(this);
    delete cache[this.value.length - 1];
    delete cache.length;
    return this.value.pop();
};

Pp.insertAt = function insertAt(index, node) {
    var argc = arguments.length;
    var move = getMoves(this, argc - 1, index);
    if (move === emptyMoves) {
        return this;
    }

    index = Math.max(index, 0);

    for (var i = 1; i < argc; ++i) {
        this.value[index + i - 1] = arguments[i];
    }

    move();

    return this;
};

Pp.insertBefore = function insertBefore(node) {
    var pp = this.parentPath;
    var argc = arguments.length;
    var insertAtArgs = [this.name];
    for (var i = 0; i < argc; ++i) {
        insertAtArgs.push(arguments[i]);
    }
    return pp.insertAt.apply(pp, insertAtArgs);
};

Pp.insertAfter = function insertAfter(node) {
    var pp = this.parentPath;
    var argc = arguments.length;
    var insertAtArgs = [this.name + 1];
    for (var i = 0; i < argc; ++i) {
        insertAtArgs.push(arguments[i]);
    }
    return pp.insertAt.apply(pp, insertAtArgs);
};

function repairRelationshipWithParent(path) {
    if (!(path instanceof Path)) {
        throw new Error("");
    }

    var pp = path.parentPath;
    if (!pp) {
        // Orphan paths have no relationship to repair.
        return path;
    }

    var parentValue = pp.value;
    var parentCache = getChildCache(pp);

    // Make sure parentCache[path.name] is populated.
    if (parentValue[path.name] === path.value) {
        parentCache[path.name] = path;
    } else if (isArray.check(parentValue)) {
        // Something caused path.name to become out of date, so attempt to
        // recover by searching for path.value in parentValue.
        var i = parentValue.indexOf(path.value);
        if (i >= 0) {
            parentCache[path.name = i] = path;
        }
    } else {
        // If path.value disagrees with parentValue[path.name], and
        // path.name is not an array index, let path.value become the new
        // parentValue[path.name] and update parentCache accordingly.
        parentValue[path.name] = path.value;
        parentCache[path.name] = path;
    }

    if (parentValue[path.name] !== path.value) {
        throw new Error("");
    }
    if (path.parentPath.get(path.name) !== path) {
        throw new Error("");
    }

    return path;
}

Pp.replace = function replace(replacement) {
    var results = [];
    var parentValue = this.parentPath.value;
    var parentCache = getChildCache(this.parentPath);
    var count = arguments.length;

    repairRelationshipWithParent(this);

    if (isArray.check(parentValue)) {
        var originalLength = parentValue.length;
        var move = getMoves(this.parentPath, count - 1, this.name + 1);

        var spliceArgs = [this.name, 1];
        for (var i = 0; i < count; ++i) {
            spliceArgs.push(arguments[i]);
        }

        var splicedOut = parentValue.splice.apply(parentValue, spliceArgs);

        if (splicedOut[0] !== this.value) {
            throw new Error("");
        }
        if (parentValue.length !== (originalLength - 1 + count)) {
            throw new Error("");
        }

        move();

        if (count === 0) {
            delete this.value;
            delete parentCache[this.name];
            this.__childCache = null;

        } else {
            if (parentValue[this.name] !== replacement) {
                throw new Error("");
            }

            if (this.value !== replacement) {
                this.value = replacement;
                this.__childCache = null;
            }

            for (i = 0; i < count; ++i) {
                results.push(this.parentPath.get(this.name + i));
            }

            if (results[0] !== this) {
                throw new Error("");
            }
        }

    } else if (count === 1) {
        if (this.value !== replacement) {
            this.__childCache = null;
        }
        this.value = parentValue[this.name] = replacement;
        results.push(this);

    } else if (count === 0) {
        delete parentValue[this.name];
        delete this.value;
        this.__childCache = null;

        // Leave this path cached as parentCache[this.name], even though
        // it no longer has a value defined.

    } else {
        throw new Error("Could not replace path");
    }

    return results;
};

module.exports = Path;

},{"./types":187}],185:[function(require,module,exports){
var types = require("./types");
var Type = types.Type;
var namedTypes = types.namedTypes;
var Node = namedTypes.Node;
var Expression = namedTypes.Expression;
var isArray = types.builtInTypes.array;
var hasOwn = Object.prototype.hasOwnProperty;
var b = types.builders;

function Scope(path, parentScope) {
    if (!(this instanceof Scope)) {
        throw new Error("Scope constructor cannot be invoked without 'new'");
    }
    if (!(path instanceof require("./node-path"))) {
        throw new Error("");
    }
    ScopeType.assert(path.value);

    var depth;

    if (parentScope) {
        if (!(parentScope instanceof Scope)) {
            throw new Error("");
        }
        depth = parentScope.depth + 1;
    } else {
        parentScope = null;
        depth = 0;
    }

    Object.defineProperties(this, {
        path: { value: path },
        node: { value: path.value },
        isGlobal: { value: !parentScope, enumerable: true },
        depth: { value: depth },
        parent: { value: parentScope },
        bindings: { value: {} }
    });
}

var scopeTypes = [
    // Program nodes introduce global scopes.
    namedTypes.Program,

    // Function is the supertype of FunctionExpression,
    // FunctionDeclaration, ArrowExpression, etc.
    namedTypes.Function,

    // In case you didn't know, the caught parameter shadows any variable
    // of the same name in an outer scope.
    namedTypes.CatchClause
];

var ScopeType = Type.or.apply(Type, scopeTypes);

Scope.isEstablishedBy = function(node) {
    return ScopeType.check(node);
};

var Sp = Scope.prototype;

// Will be overridden after an instance lazily calls scanScope.
Sp.didScan = false;

Sp.declares = function(name) {
    this.scan();
    return hasOwn.call(this.bindings, name);
};

Sp.declareTemporary = function(prefix) {
    if (prefix) {
        if (!/^[a-z$_]/i.test(prefix)) {
            throw new Error("");
        }
    } else {
        prefix = "t$";
    }

    // Include this.depth in the name to make sure the name does not
    // collide with any variables in nested/enclosing scopes.
    prefix += this.depth.toString(36) + "$";

    this.scan();

    var index = 0;
    while (this.declares(prefix + index)) {
        ++index;
    }

    var name = prefix + index;
    return this.bindings[name] = types.builders.identifier(name);
};

Sp.injectTemporary = function(identifier, init) {
    identifier || (identifier = this.declareTemporary());

    var bodyPath = this.path.get("body");
    if (namedTypes.BlockStatement.check(bodyPath.value)) {
        bodyPath = bodyPath.get("body");
    }

    bodyPath.unshift(
        b.variableDeclaration(
            "var",
            [b.variableDeclarator(identifier, init || null)]
        )
    );

    return identifier;
};

Sp.scan = function(force) {
    if (force || !this.didScan) {
        for (var name in this.bindings) {
            // Empty out this.bindings, just in cases.
            delete this.bindings[name];
        }
        scanScope(this.path, this.bindings);
        this.didScan = true;
    }
};

Sp.getBindings = function () {
    this.scan();
    return this.bindings;
};

function scanScope(path, bindings) {
    var node = path.value;
    ScopeType.assert(node);

    if (namedTypes.CatchClause.check(node)) {
        // A catch clause establishes a new scope but the only variable
        // bound in that scope is the catch parameter. Any other
        // declarations create bindings in the outer scope.
        addPattern(path.get("param"), bindings);

    } else {
        recursiveScanScope(path, bindings);
    }
}

function recursiveScanScope(path, bindings) {
    var node = path.value;

    if (path.parent &&
        namedTypes.FunctionExpression.check(path.parent.node) &&
        path.parent.node.id) {
        addPattern(path.parent.get("id"), bindings);
    }

    if (!node) {
        // None of the remaining cases matter if node is falsy.

    } else if (isArray.check(node)) {
        path.each(function(childPath) {
            recursiveScanChild(childPath, bindings);
        });

    } else if (namedTypes.Function.check(node)) {
        path.get("params").each(function(paramPath) {
            addPattern(paramPath, bindings);
        });

        recursiveScanChild(path.get("body"), bindings);

    } else if (namedTypes.VariableDeclarator.check(node)) {
        addPattern(path.get("id"), bindings);
        recursiveScanChild(path.get("init"), bindings);

    } else if (node.type === "ImportSpecifier" ||
               node.type === "ImportNamespaceSpecifier" ||
               node.type === "ImportDefaultSpecifier") {
        addPattern(
            // Esprima used to use the .name field to refer to the local
            // binding identifier for ImportSpecifier nodes, but .id for
            // ImportNamespaceSpecifier and ImportDefaultSpecifier nodes.
            // ESTree/Acorn/ESpree use .local for all three node types.
            path.get(node.local ? "local" :
                     node.name ? "name" : "id"),
            bindings
        );

    } else if (Node.check(node) && !Expression.check(node)) {
        types.eachField(node, function(name, child) {
            var childPath = path.get(name);
            if (childPath.value !== child) {
                throw new Error("");
            }
            recursiveScanChild(childPath, bindings);
        });
    }
}

function recursiveScanChild(path, bindings) {
    var node = path.value;

    if (!node || Expression.check(node)) {
        // Ignore falsy values and Expressions.

    } else if (namedTypes.FunctionDeclaration.check(node)) {
        addPattern(path.get("id"), bindings);

    } else if (namedTypes.ClassDeclaration &&
               namedTypes.ClassDeclaration.check(node)) {
        addPattern(path.get("id"), bindings);

    } else if (ScopeType.check(node)) {
        if (namedTypes.CatchClause.check(node)) {
            var catchParamName = node.param.name;
            var hadBinding = hasOwn.call(bindings, catchParamName);

            // Any declarations that occur inside the catch body that do
            // not have the same name as the catch parameter should count
            // as bindings in the outer scope.
            recursiveScanScope(path.get("body"), bindings);

            // If a new binding matching the catch parameter name was
            // created while scanning the catch body, ignore it because it
            // actually refers to the catch parameter and not the outer
            // scope that we're currently scanning.
            if (!hadBinding) {
                delete bindings[catchParamName];
            }
        }

    } else {
        recursiveScanScope(path, bindings);
    }
}

function addPattern(patternPath, bindings) {
    var pattern = patternPath.value;
    namedTypes.Pattern.assert(pattern);

    if (namedTypes.Identifier.check(pattern)) {
        if (hasOwn.call(bindings, pattern.name)) {
            bindings[pattern.name].push(patternPath);
        } else {
            bindings[pattern.name] = [patternPath];
        }

    } else if (namedTypes.ObjectPattern &&
               namedTypes.ObjectPattern.check(pattern)) {
        patternPath.get('properties').each(function(propertyPath) {
            var property = propertyPath.value;
            if (namedTypes.Pattern.check(property)) {
                addPattern(propertyPath, bindings);
            } else  if (namedTypes.Property.check(property)) {
                addPattern(propertyPath.get('value'), bindings);
            } else if (namedTypes.SpreadProperty &&
                       namedTypes.SpreadProperty.check(property)) {
                addPattern(propertyPath.get('argument'), bindings);
            }
        });

    } else if (namedTypes.ArrayPattern &&
               namedTypes.ArrayPattern.check(pattern)) {
        patternPath.get('elements').each(function(elementPath) {
            var element = elementPath.value;
            if (namedTypes.Pattern.check(element)) {
                addPattern(elementPath, bindings);
            } else if (namedTypes.SpreadElement &&
                       namedTypes.SpreadElement.check(element)) {
                addPattern(elementPath.get("argument"), bindings);
            }
        });

    } else if (namedTypes.PropertyPattern &&
               namedTypes.PropertyPattern.check(pattern)) {
        addPattern(patternPath.get('pattern'), bindings);

    } else if ((namedTypes.SpreadElementPattern &&
                namedTypes.SpreadElementPattern.check(pattern)) ||
               (namedTypes.SpreadPropertyPattern &&
                namedTypes.SpreadPropertyPattern.check(pattern))) {
        addPattern(patternPath.get('argument'), bindings);
    }
}

Sp.lookup = function(name) {
    for (var scope = this; scope; scope = scope.parent)
        if (scope.declares(name))
            break;
    return scope;
};

Sp.getGlobalScope = function() {
    var scope = this;
    while (!scope.isGlobal)
        scope = scope.parent;
    return scope;
};

module.exports = Scope;

},{"./node-path":182,"./types":187}],186:[function(require,module,exports){
var types = require("../lib/types");
var Type = types.Type;
var builtin = types.builtInTypes;
var isNumber = builtin.number;

// An example of constructing a new type with arbitrary constraints from
// an existing type.
exports.geq = function(than) {
    return new Type(function(value) {
        return isNumber.check(value) && value >= than;
    }, isNumber + " >= " + than);
};

// Default value-returning functions that may optionally be passed as a
// third argument to Def.prototype.field.
exports.defaults = {
    // Functions were used because (among other reasons) that's the most
    // elegant way to allow for the emptyArray one always to give a new
    // array instance.
    "null": function() { return null },
    "emptyArray": function() { return [] },
    "false": function() { return false },
    "true": function() { return true },
    "undefined": function() {}
};

var naiveIsPrimitive = Type.or(
    builtin.string,
    builtin.number,
    builtin.boolean,
    builtin.null,
    builtin.undefined
);

exports.isPrimitive = new Type(function(value) {
    if (value === null)
        return true;
    var type = typeof value;
    return !(type === "object" ||
             type === "function");
}, naiveIsPrimitive.toString());

},{"../lib/types":187}],187:[function(require,module,exports){
var Ap = Array.prototype;
var slice = Ap.slice;
var map = Ap.map;
var each = Ap.forEach;
var Op = Object.prototype;
var objToStr = Op.toString;
var funObjStr = objToStr.call(function(){});
var strObjStr = objToStr.call("");
var hasOwn = Op.hasOwnProperty;

// A type is an object with a .check method that takes a value and returns
// true or false according to whether the value matches the type.

function Type(check, name) {
    var self = this;
    if (!(self instanceof Type)) {
        throw new Error("Type constructor cannot be invoked without 'new'");
    }

    // Unfortunately we can't elegantly reuse isFunction and isString,
    // here, because this code is executed while defining those types.
    if (objToStr.call(check) !== funObjStr) {
        throw new Error(check + " is not a function");
    }

    // The `name` parameter can be either a function or a string.
    var nameObjStr = objToStr.call(name);
    if (!(nameObjStr === funObjStr ||
          nameObjStr === strObjStr)) {
        throw new Error(name + " is neither a function nor a string");
    }

    Object.defineProperties(self, {
        name: { value: name },
        check: {
            value: function(value, deep) {
                var result = check.call(self, value, deep);
                if (!result && deep && objToStr.call(deep) === funObjStr)
                    deep(self, value);
                return result;
            }
        }
    });
}

var Tp = Type.prototype;

// Throughout this file we use Object.defineProperty to prevent
// redefinition of exported properties.
exports.Type = Type;

// Like .check, except that failure triggers an AssertionError.
Tp.assert = function(value, deep) {
    if (!this.check(value, deep)) {
        var str = shallowStringify(value);
        throw new Error(str + " does not match type " + this);
    }
    return true;
};

function shallowStringify(value) {
    if (isObject.check(value))
        return "{" + Object.keys(value).map(function(key) {
            return key + ": " + value[key];
        }).join(", ") + "}";

    if (isArray.check(value))
        return "[" + value.map(shallowStringify).join(", ") + "]";

    return JSON.stringify(value);
}

Tp.toString = function() {
    var name = this.name;

    if (isString.check(name))
        return name;

    if (isFunction.check(name))
        return name.call(this) + "";

    return name + " type";
};

var builtInCtorFns = [];
var builtInCtorTypes = [];
var builtInTypes = {};
exports.builtInTypes = builtInTypes;

function defBuiltInType(example, name) {
    var objStr = objToStr.call(example);

    var type = new Type(function(value) {
        return objToStr.call(value) === objStr;
    }, name);

    builtInTypes[name] = type;

    if (example && typeof example.constructor === "function") {
        builtInCtorFns.push(example.constructor);
        builtInCtorTypes.push(type);
    }

    return type;
}

// These types check the underlying [[Class]] attribute of the given
// value, rather than using the problematic typeof operator. Note however
// that no subtyping is considered; so, for instance, isObject.check
// returns false for [], /./, new Date, and null.
var isString = defBuiltInType("truthy", "string");
var isFunction = defBuiltInType(function(){}, "function");
var isArray = defBuiltInType([], "array");
var isObject = defBuiltInType({}, "object");
var isRegExp = defBuiltInType(/./, "RegExp");
var isDate = defBuiltInType(new Date, "Date");
var isNumber = defBuiltInType(3, "number");
var isBoolean = defBuiltInType(true, "boolean");
var isNull = defBuiltInType(null, "null");
var isUndefined = defBuiltInType(void 0, "undefined");

// There are a number of idiomatic ways of expressing types, so this
// function serves to coerce them all to actual Type objects. Note that
// providing the name argument is not necessary in most cases.
function toType(from, name) {
    // The toType function should of course be idempotent.
    if (from instanceof Type)
        return from;

    // The Def type is used as a helper for constructing compound
    // interface types for AST nodes.
    if (from instanceof Def)
        return from.type;

    // Support [ElemType] syntax.
    if (isArray.check(from))
        return Type.fromArray(from);

    // Support { someField: FieldType, ... } syntax.
    if (isObject.check(from))
        return Type.fromObject(from);

    if (isFunction.check(from)) {
        var bicfIndex = builtInCtorFns.indexOf(from);
        if (bicfIndex >= 0) {
            return builtInCtorTypes[bicfIndex];
        }

        // If isFunction.check(from), and from is not a built-in
        // constructor, assume from is a binary predicate function we can
        // use to define the type.
        return new Type(from, name);
    }

    // As a last resort, toType returns a type that matches any value that
    // is === from. This is primarily useful for literal values like
    // toType(null), but it has the additional advantage of allowing
    // toType to be a total function.
    return new Type(function(value) {
        return value === from;
    }, isUndefined.check(name) ? function() {
        return from + "";
    } : name);
}

// Returns a type that matches the given value iff any of type1, type2,
// etc. match the value.
Type.or = function(/* type1, type2, ... */) {
    var types = [];
    var len = arguments.length;
    for (var i = 0; i < len; ++i)
        types.push(toType(arguments[i]));

    return new Type(function(value, deep) {
        for (var i = 0; i < len; ++i)
            if (types[i].check(value, deep))
                return true;
        return false;
    }, function() {
        return types.join(" | ");
    });
};

Type.fromArray = function(arr) {
    if (!isArray.check(arr)) {
        throw new Error("");
    }
    if (arr.length !== 1) {
        throw new Error("only one element type is permitted for typed arrays");
    }
    return toType(arr[0]).arrayOf();
};

Tp.arrayOf = function() {
    var elemType = this;
    return new Type(function(value, deep) {
        return isArray.check(value) && value.every(function(elem) {
            return elemType.check(elem, deep);
        });
    }, function() {
        return "[" + elemType + "]";
    });
};

Type.fromObject = function(obj) {
    var fields = Object.keys(obj).map(function(name) {
        return new Field(name, obj[name]);
    });

    return new Type(function(value, deep) {
        return isObject.check(value) && fields.every(function(field) {
            return field.type.check(value[field.name], deep);
        });
    }, function() {
        return "{ " + fields.join(", ") + " }";
    });
};

function Field(name, type, defaultFn, hidden) {
    var self = this;

    if (!(self instanceof Field)) {
        throw new Error("Field constructor cannot be invoked without 'new'");
    }
    isString.assert(name);

    type = toType(type);

    var properties = {
        name: { value: name },
        type: { value: type },
        hidden: { value: !!hidden }
    };

    if (isFunction.check(defaultFn)) {
        properties.defaultFn = { value: defaultFn };
    }

    Object.defineProperties(self, properties);
}

var Fp = Field.prototype;

Fp.toString = function() {
    return JSON.stringify(this.name) + ": " + this.type;
};

Fp.getValue = function(obj) {
    var value = obj[this.name];

    if (!isUndefined.check(value))
        return value;

    if (this.defaultFn)
        value = this.defaultFn.call(obj);

    return value;
};

// Define a type whose name is registered in a namespace (the defCache) so
// that future definitions will return the same type given the same name.
// In particular, this system allows for circular and forward definitions.
// The Def object d returned from Type.def may be used to configure the
// type d.type by calling methods such as d.bases, d.build, and d.field.
Type.def = function(typeName) {
    isString.assert(typeName);
    return hasOwn.call(defCache, typeName)
        ? defCache[typeName]
        : defCache[typeName] = new Def(typeName);
};

// In order to return the same Def instance every time Type.def is called
// with a particular name, those instances need to be stored in a cache.
var defCache = Object.create(null);

function Def(typeName) {
    var self = this;
    if (!(self instanceof Def)) {
        throw new Error("Def constructor cannot be invoked without 'new'");
    }

    Object.defineProperties(self, {
        typeName: { value: typeName },
        baseNames: { value: [] },
        ownFields: { value: Object.create(null) },

        // These two are populated during finalization.
        allSupertypes: { value: Object.create(null) }, // Includes own typeName.
        supertypeList: { value: [] }, // Linear inheritance hierarchy.
        allFields: { value: Object.create(null) }, // Includes inherited fields.
        fieldNames: { value: [] }, // Non-hidden keys of allFields.

        type: {
            value: new Type(function(value, deep) {
                return self.check(value, deep);
            }, typeName)
        }
    });
}

Def.fromValue = function(value) {
    if (value && typeof value === "object") {
        var type = value.type;
        if (typeof type === "string" &&
            hasOwn.call(defCache, type)) {
            var d = defCache[type];
            if (d.finalized) {
                return d;
            }
        }
    }

    return null;
};

var Dp = Def.prototype;

Dp.isSupertypeOf = function(that) {
    if (that instanceof Def) {
        if (this.finalized !== true ||
            that.finalized !== true) {
            throw new Error("");
        }
        return hasOwn.call(that.allSupertypes, this.typeName);
    } else {
        throw new Error(that + " is not a Def");
    }
};

// Note that the list returned by this function is a copy of the internal
// supertypeList, *without* the typeName itself as the first element.
exports.getSupertypeNames = function(typeName) {
    if (!hasOwn.call(defCache, typeName)) {
        throw new Error("");
    }
    var d = defCache[typeName];
    if (d.finalized !== true) {
        throw new Error("");
    }
    return d.supertypeList.slice(1);
};

// Returns an object mapping from every known type in the defCache to the
// most specific supertype whose name is an own property of the candidates
// object.
exports.computeSupertypeLookupTable = function(candidates) {
    var table = {};
    var typeNames = Object.keys(defCache);
    var typeNameCount = typeNames.length;

    for (var i = 0; i < typeNameCount; ++i) {
        var typeName = typeNames[i];
        var d = defCache[typeName];
        if (d.finalized !== true) {
            throw new Error("" + typeName);
        }
        for (var j = 0; j < d.supertypeList.length; ++j) {
            var superTypeName = d.supertypeList[j];
            if (hasOwn.call(candidates, superTypeName)) {
                table[typeName] = superTypeName;
                break;
            }
        }
    }

    return table;
};

Dp.checkAllFields = function(value, deep) {
    var allFields = this.allFields;
    if (this.finalized !== true) {
        throw new Error("" + this.typeName);
    }

    function checkFieldByName(name) {
        var field = allFields[name];
        var type = field.type;
        var child = field.getValue(value);
        return type.check(child, deep);
    }

    return isObject.check(value)
        && Object.keys(allFields).every(checkFieldByName);
};

Dp.check = function(value, deep) {
    if (this.finalized !== true) {
        throw new Error(
            "prematurely checking unfinalized type " + this.typeName
        );
    }

    // A Def type can only match an object value.
    if (!isObject.check(value))
        return false;

    var vDef = Def.fromValue(value);
    if (!vDef) {
        // If we couldn't infer the Def associated with the given value,
        // and we expected it to be a SourceLocation or a Position, it was
        // probably just missing a "type" field (because Esprima does not
        // assign a type property to such nodes). Be optimistic and let
        // this.checkAllFields make the final decision.
        if (this.typeName === "SourceLocation" ||
            this.typeName === "Position") {
            return this.checkAllFields(value, deep);
        }

        // Calling this.checkAllFields for any other type of node is both
        // bad for performance and way too forgiving.
        return false;
    }

    // If checking deeply and vDef === this, then we only need to call
    // checkAllFields once. Calling checkAllFields is too strict when deep
    // is false, because then we only care about this.isSupertypeOf(vDef).
    if (deep && vDef === this)
        return this.checkAllFields(value, deep);

    // In most cases we rely exclusively on isSupertypeOf to make O(1)
    // subtyping determinations. This suffices in most situations outside
    // of unit tests, since interface conformance is checked whenever new
    // instances are created using builder functions.
    if (!this.isSupertypeOf(vDef))
        return false;

    // The exception is when deep is true; then, we recursively check all
    // fields.
    if (!deep)
        return true;

    // Use the more specific Def (vDef) to perform the deep check, but
    // shallow-check fields defined by the less specific Def (this).
    return vDef.checkAllFields(value, deep)
        && this.checkAllFields(value, false);
};

Dp.bases = function() {
    var args = slice.call(arguments);
    var bases = this.baseNames;

    if (this.finalized) {
        if (args.length !== bases.length) {
            throw new Error("");
        }
        for (var i = 0; i < args.length; i++) {
            if (args[i] !== bases[i]) {
                throw new Error("");
            }
        }
        return this;
    }

    args.forEach(function(baseName) {
        isString.assert(baseName);

        // This indexOf lookup may be O(n), but the typical number of base
        // names is very small, and indexOf is a native Array method.
        if (bases.indexOf(baseName) < 0)
            bases.push(baseName);
    });

    return this; // For chaining.
};

// False by default until .build(...) is called on an instance.
Object.defineProperty(Dp, "buildable", { value: false });

var builders = {};
exports.builders = builders;

// This object is used as prototype for any node created by a builder.
var nodePrototype = {};

// Call this function to define a new method to be shared by all AST
// nodes. The replaced method (if any) is returned for easy wrapping.
exports.defineMethod = function(name, func) {
    var old = nodePrototype[name];

    // Pass undefined as func to delete nodePrototype[name].
    if (isUndefined.check(func)) {
        delete nodePrototype[name];

    } else {
        isFunction.assert(func);

        Object.defineProperty(nodePrototype, name, {
            enumerable: true, // For discoverability.
            configurable: true, // For delete proto[name].
            value: func
        });
    }

    return old;
};

var isArrayOfString = isString.arrayOf();

// Calling the .build method of a Def simultaneously marks the type as
// buildable (by defining builders[getBuilderName(typeName)]) and
// specifies the order of arguments that should be passed to the builder
// function to create an instance of the type.
Dp.build = function(/* param1, param2, ... */) {
    var self = this;

    var newBuildParams = slice.call(arguments);
    isArrayOfString.assert(newBuildParams);

    // Calling Def.prototype.build multiple times has the effect of merely
    // redefining this property.
    Object.defineProperty(self, "buildParams", {
        value: newBuildParams,
        writable: false,
        enumerable: false,
        configurable: true
    });

    if (self.buildable) {
        // If this Def is already buildable, update self.buildParams and
        // continue using the old builder function.
        return self;
    }

    // Every buildable type will have its "type" field filled in
    // automatically. This includes types that are not subtypes of Node,
    // like SourceLocation, but that seems harmless (TODO?).
    self.field("type", String, function() { return self.typeName });

    // Override Dp.buildable for this Def instance.
    Object.defineProperty(self, "buildable", { value: true });

    Object.defineProperty(builders, getBuilderName(self.typeName), {
        enumerable: true,

        value: function() {
            var args = arguments;
            var argc = args.length;
            var built = Object.create(nodePrototype);

            if (!self.finalized) {
                throw new Error(
                    "attempting to instantiate unfinalized type " +
                        self.typeName
                );
            }

            function add(param, i) {
                if (hasOwn.call(built, param))
                    return;

                var all = self.allFields;
                if (!hasOwn.call(all, param)) {
                    throw new Error("" + param);
                }

                var field = all[param];
                var type = field.type;
                var value;

                if (isNumber.check(i) && i < argc) {
                    value = args[i];
                } else if (field.defaultFn) {
                    // Expose the partially-built object to the default
                    // function as its `this` object.
                    value = field.defaultFn.call(built);
                } else {
                    var message = "no value or default function given for field " +
                        JSON.stringify(param) + " of " + self.typeName + "(" +
                            self.buildParams.map(function(name) {
                                return all[name];
                            }).join(", ") + ")";
                    throw new Error(message);
                }

                if (!type.check(value)) {
                    throw new Error(
                        shallowStringify(value) +
                            " does not match field " + field +
                            " of type " + self.typeName
                    );
                }

                // TODO Could attach getters and setters here to enforce
                // dynamic type safety.
                built[param] = value;
            }

            self.buildParams.forEach(function(param, i) {
                add(param, i);
            });

            Object.keys(self.allFields).forEach(function(param) {
                add(param); // Use the default value.
            });

            // Make sure that the "type" field was filled automatically.
            if (built.type !== self.typeName) {
                throw new Error("");
            }

            return built;
        }
    });

    return self; // For chaining.
};

function getBuilderName(typeName) {
    return typeName.replace(/^[A-Z]+/, function(upperCasePrefix) {
        var len = upperCasePrefix.length;
        switch (len) {
        case 0: return "";
        // If there's only one initial capital letter, just lower-case it.
        case 1: return upperCasePrefix.toLowerCase();
        default:
            // If there's more than one initial capital letter, lower-case
            // all but the last one, so that XMLDefaultDeclaration (for
            // example) becomes xmlDefaultDeclaration.
            return upperCasePrefix.slice(
                0, len - 1).toLowerCase() +
                upperCasePrefix.charAt(len - 1);
        }
    });
}
exports.getBuilderName = getBuilderName;

function getStatementBuilderName(typeName) {
    typeName = getBuilderName(typeName);
    return typeName.replace(/(Expression)?$/, "Statement");
}
exports.getStatementBuilderName = getStatementBuilderName;

// The reason fields are specified using .field(...) instead of an object
// literal syntax is somewhat subtle: the object literal syntax would
// support only one key and one value, but with .field(...) we can pass
// any number of arguments to specify the field.
Dp.field = function(name, type, defaultFn, hidden) {
    if (this.finalized) {
        console.error("Ignoring attempt to redefine field " +
                      JSON.stringify(name) + " of finalized type " +
                      JSON.stringify(this.typeName));
        return this;
    }
    this.ownFields[name] = new Field(name, type, defaultFn, hidden);
    return this; // For chaining.
};

var namedTypes = {};
exports.namedTypes = namedTypes;

// Like Object.keys, but aware of what fields each AST type should have.
function getFieldNames(object) {
    var d = Def.fromValue(object);
    if (d) {
        return d.fieldNames.slice(0);
    }

    if ("type" in object) {
        throw new Error(
            "did not recognize object of type " +
                JSON.stringify(object.type)
        );
    }

    return Object.keys(object);
}
exports.getFieldNames = getFieldNames;

// Get the value of an object property, taking object.type and default
// functions into account.
function getFieldValue(object, fieldName) {
    var d = Def.fromValue(object);
    if (d) {
        var field = d.allFields[fieldName];
        if (field) {
            return field.getValue(object);
        }
    }

    return object[fieldName];
}
exports.getFieldValue = getFieldValue;

// Iterate over all defined fields of an object, including those missing
// or undefined, passing each field name and effective value (as returned
// by getFieldValue) to the callback. If the object has no corresponding
// Def, the callback will never be called.
exports.eachField = function(object, callback, context) {
    getFieldNames(object).forEach(function(name) {
        callback.call(this, name, getFieldValue(object, name));
    }, context);
};

// Similar to eachField, except that iteration stops as soon as the
// callback returns a truthy value. Like Array.prototype.some, the final
// result is either true or false to indicates whether the callback
// returned true for any element or not.
exports.someField = function(object, callback, context) {
    return getFieldNames(object).some(function(name) {
        return callback.call(this, name, getFieldValue(object, name));
    }, context);
};

// This property will be overridden as true by individual Def instances
// when they are finalized.
Object.defineProperty(Dp, "finalized", { value: false });

Dp.finalize = function() {
    var self = this;

    // It's not an error to finalize a type more than once, but only the
    // first call to .finalize does anything.
    if (!self.finalized) {
        var allFields = self.allFields;
        var allSupertypes = self.allSupertypes;

        self.baseNames.forEach(function(name) {
            var def = defCache[name];
            if (def instanceof Def) {
                def.finalize();
                extend(allFields, def.allFields);
                extend(allSupertypes, def.allSupertypes);
            } else {
                var message = "unknown supertype name " +
                    JSON.stringify(name) +
                    " for subtype " +
                    JSON.stringify(self.typeName);
                throw new Error(message);
            }
        });

        // TODO Warn if fields are overridden with incompatible types.
        extend(allFields, self.ownFields);
        allSupertypes[self.typeName] = self;

        self.fieldNames.length = 0;
        for (var fieldName in allFields) {
            if (hasOwn.call(allFields, fieldName) &&
                !allFields[fieldName].hidden) {
                self.fieldNames.push(fieldName);
            }
        }

        // Types are exported only once they have been finalized.
        Object.defineProperty(namedTypes, self.typeName, {
            enumerable: true,
            value: self.type
        });

        Object.defineProperty(self, "finalized", { value: true });

        // A linearization of the inheritance hierarchy.
        populateSupertypeList(self.typeName, self.supertypeList);

        if (self.buildable && self.supertypeList.lastIndexOf("Expression") >= 0) {
            wrapExpressionBuilderWithStatement(self.typeName);
        }
    }
};

// Adds an additional builder for Expression subtypes
// that wraps the built Expression in an ExpressionStatements.
function wrapExpressionBuilderWithStatement(typeName) {
    var wrapperName = getStatementBuilderName(typeName);

    // skip if the builder already exists
    if (builders[wrapperName]) return;

    // the builder function to wrap with builders.ExpressionStatement
    var wrapped = builders[getBuilderName(typeName)];

    // skip if there is nothing to wrap
    if (!wrapped) return;

    builders[wrapperName] = function() {
        return builders.expressionStatement(wrapped.apply(builders, arguments));
    };
}

function populateSupertypeList(typeName, list) {
    list.length = 0;
    list.push(typeName);

    var lastSeen = Object.create(null);

    for (var pos = 0; pos < list.length; ++pos) {
        typeName = list[pos];
        var d = defCache[typeName];
        if (d.finalized !== true) {
            throw new Error("");
        }

        // If we saw typeName earlier in the breadth-first traversal,
        // delete the last-seen occurrence.
        if (hasOwn.call(lastSeen, typeName)) {
            delete list[lastSeen[typeName]];
        }

        // Record the new index of the last-seen occurrence of typeName.
        lastSeen[typeName] = pos;

        // Enqueue the base names of this type.
        list.push.apply(list, d.baseNames);
    }

    // Compaction loop to remove array holes.
    for (var to = 0, from = to, len = list.length; from < len; ++from) {
        if (hasOwn.call(list, from)) {
            list[to++] = list[from];
        }
    }

    list.length = to;
}

function extend(into, from) {
    Object.keys(from).forEach(function(name) {
        into[name] = from[name];
    });

    return into;
};

exports.finalize = function() {
    Object.keys(defCache).forEach(function(name) {
        defCache[name].finalize();
    });
};

},{}],188:[function(require,module,exports){
var types = require("./lib/types");

// This core module of AST types captures ES5 as it is parsed today by
// git://github.com/ariya/esprima.git#master.
require("./def/core");

// Feel free to add to or remove from this list of extension modules to
// configure the precise type hierarchy that you need.
require("./def/es6");
require("./def/es7");
require("./def/mozilla");
require("./def/e4x");
require("./def/fb-harmony");
require("./def/esprima");
require("./def/babel");

types.finalize();

exports.Type = types.Type;
exports.builtInTypes = types.builtInTypes;
exports.namedTypes = types.namedTypes;
exports.builders = types.builders;
exports.defineMethod = types.defineMethod;
exports.getFieldNames = types.getFieldNames;
exports.getFieldValue = types.getFieldValue;
exports.eachField = types.eachField;
exports.someField = types.someField;
exports.getSupertypeNames = types.getSupertypeNames;
exports.astNodesAreEquivalent = require("./lib/equiv");
exports.finalize = types.finalize;
exports.NodePath = require("./lib/node-path");
exports.PathVisitor = require("./lib/path-visitor");
exports.visit = exports.PathVisitor.visit;

},{"./def/babel":173,"./def/core":174,"./def/e4x":175,"./def/es6":176,"./def/es7":177,"./def/esprima":178,"./def/fb-harmony":179,"./def/mozilla":180,"./lib/equiv":181,"./lib/node-path":182,"./lib/path-visitor":183,"./lib/types":187}],189:[function(require,module,exports){
module.exports = require("./lib/api/node.js");

},{"./lib/api/node.js":190}],190:[function(require,module,exports){
"use strict";

exports.__esModule = true;
exports.register = register;
exports.polyfill = polyfill;
exports.transformFile = transformFile;
exports.transformFileSync = transformFileSync;
exports.parse = parse;
// istanbul ignore next

function _interopRequire(obj) { return obj && obj.__esModule ? obj["default"] : obj; }

// istanbul ignore next

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj["default"] = obj; return newObj; } }

// istanbul ignore next

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

var _lodashLangIsFunction = require("lodash/lang/isFunction");

var _lodashLangIsFunction2 = _interopRequireDefault(_lodashLangIsFunction);

var _transformation = require("../transformation");

var _transformation2 = _interopRequireDefault(_transformation);

var _babylon = require("babylon");

var babylon = _interopRequireWildcard(_babylon);

var _util = require("../util");

var util = _interopRequireWildcard(_util);

var _fs = require("fs");

var _fs2 = _interopRequireDefault(_fs);

var _types = require("../types");

var t = _interopRequireWildcard(_types);

exports.util = util;
exports.acorn = babylon;
exports.transform = _transformation2["default"];
exports.pipeline = _transformation.pipeline;
exports.canCompile = _util.canCompile;

var _transformationFile = require("../transformation/file");

exports.File = _interopRequire(_transformationFile);

var _transformationFileOptionsConfig = require("../transformation/file/options/config");

exports.options = _interopRequire(_transformationFileOptionsConfig);

var _transformationPlugin = require("../transformation/plugin");

exports.Plugin = _interopRequire(_transformationPlugin);

var _transformationTransformer = require("../transformation/transformer");

exports.Transformer = _interopRequire(_transformationTransformer);

var _transformationPipeline = require("../transformation/pipeline");

exports.Pipeline = _interopRequire(_transformationPipeline);

var _traversal = require("../traversal");

exports.traverse = _interopRequire(_traversal);

var _toolsBuildExternalHelpers = require("../tools/build-external-helpers");

exports.buildExternalHelpers = _interopRequire(_toolsBuildExternalHelpers);

var _package = require("../../package");

exports.version = _package.version;
exports.types = t;

/**
 * Register Babel and polyfill globally.
 */

function register(opts) {
  var callback = require("./register/node-polyfill");
  if (opts != null) callback(opts);
  return callback;
}

/**
 * Register polyfill globally.
 */

function polyfill() {
  require("../polyfill");
}

/**
 * Asynchronously transform `filename` with optional `opts`, calls `callback` when complete.
 */

function transformFile(filename, opts, callback) {
  if (_lodashLangIsFunction2["default"](opts)) {
    callback = opts;
    opts = {};
  }

  opts.filename = filename;

  _fs2["default"].readFile(filename, function (err, code) {
    if (err) return callback(err);

    var result;

    try {
      result = _transformation2["default"](code, opts);
    } catch (err) {
      return callback(err);
    }

    callback(null, result);
  });
}

/**
 * Synchronous form of `transformFile`.
 */

function transformFileSync(filename) {
  var opts = arguments.length <= 1 || arguments[1] === undefined ? {} : arguments[1];

  opts.filename = filename;
  return _transformation2["default"](_fs2["default"].readFileSync(filename, "utf8"), opts);
}

/**
 * Parse script with Babel's parser.
 */

function parse(code) {
  var opts = arguments.length <= 1 || arguments[1] === undefined ? {} : arguments[1];

  opts.allowHashBang = true;
  opts.sourceType = "module";
  opts.ecmaVersion = Infinity;
  opts.plugins = {
    jsx: true,
    flow: true
  };
  opts.features = {};

  for (var key in _transformation2["default"].pipeline.transformers) {
    opts.features[key] = true;
  }

  var ast = babylon.parse(code, opts);

  if (opts.onToken) {
    // istanbul ignore next

    var _opts$onToken;

    (_opts$onToken = opts.onToken).push.apply(_opts$onToken, ast.tokens);
  }

  if (opts.onComment) {
    // istanbul ignore next

    var _opts$onComment;

    (_opts$onComment = opts.onComment).push.apply(_opts$onComment, ast.comments);
  }

  return ast.program;
}
},{"../../package":359,"../polyfill":219,"../tools/build-external-helpers":220,"../transformation":241,"../transformation/file":221,"../transformation/file/options/config":223,"../transformation/pipeline":255,"../transformation/plugin":257,"../transformation/transformer":258,"../traversal":323,"../types":354,"../util":357,"./register/node-polyfill":192,"babylon":379,"fs":404,"lodash/lang/isFunction":843}],191:[function(require,module,exports){
// required to safely use babel/register within a browserify codebase

"use strict";

exports.__esModule = true;

require("../../polyfill");

exports["default"] = function () {};

module.exports = exports["default"];
},{"../../polyfill":219}],192:[function(require,module,exports){
"use strict";

exports.__esModule = true;
// istanbul ignore next

function _interopRequire(obj) { return obj && obj.__esModule ? obj["default"] : obj; }

require("../../polyfill");

var _node = require("./node");

exports["default"] = _interopRequire(_node);
module.exports = exports["default"];
},{"../../polyfill":219,"./node":191}],193:[function(require,module,exports){
"use strict";

exports.__esModule = true;
// istanbul ignore next

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

// istanbul ignore next

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var _repeating = require("repeating");

var _repeating2 = _interopRequireDefault(_repeating);

var _trimRight = require("trim-right");

var _trimRight2 = _interopRequireDefault(_trimRight);

var _lodashLangIsBoolean = require("lodash/lang/isBoolean");

var _lodashLangIsBoolean2 = _interopRequireDefault(_lodashLangIsBoolean);

var _lodashCollectionIncludes = require("lodash/collection/includes");

var _lodashCollectionIncludes2 = _interopRequireDefault(_lodashCollectionIncludes);

var _lodashLangIsNumber = require("lodash/lang/isNumber");

var _lodashLangIsNumber2 = _interopRequireDefault(_lodashLangIsNumber);

/**
 * Buffer for collecting generated output.
 */

var Buffer = (function () {
  function Buffer(position, format) {
    _classCallCheck(this, Buffer);

    this.parenPushNewlineState = null;

    this.position = position;
    this._indent = format.indent.base;
    this.format = format;
    this.buf = "";
  }

  /**
   * Get the current trimmed buffer.
   */

  Buffer.prototype.get = function get() {
    return _trimRight2["default"](this.buf);
  };

  /**
   * Get the current indent.
   */

  Buffer.prototype.getIndent = function getIndent() {
    if (this.format.compact || this.format.concise) {
      return "";
    } else {
      return _repeating2["default"](this.format.indent.style, this._indent);
    }
  };

  /**
   * Get the current indent size.
   */

  Buffer.prototype.indentSize = function indentSize() {
    return this.getIndent().length;
  };

  /**
   * Increment indent size.
   */

  Buffer.prototype.indent = function indent() {
    this._indent++;
  };

  /**
   * Decrement indent size.
   */

  Buffer.prototype.dedent = function dedent() {
    this._indent--;
  };

  /**
   * Add a semicolon to the buffer.
   */

  Buffer.prototype.semicolon = function semicolon() {
    this.push(";");
  };

  /**
   * Ensure last character is a semicolon.
   */

  Buffer.prototype.ensureSemicolon = function ensureSemicolon() {
    if (!this.isLast(";")) this.semicolon();
  };

  /**
   * Add a right brace to the buffer.
   */

  Buffer.prototype.rightBrace = function rightBrace() {
    this.newline(true);
    //if (this.format.compact) this._removeLast(";");
    this.push("}");
  };

  /**
   * Add a keyword to the buffer.
   */

  Buffer.prototype.keyword = function keyword(name) {
    this.push(name);
    this.space();
  };

  /**
   * Add a space to the buffer unless it is compact (override with force).
   */

  Buffer.prototype.space = function space(force) {
    if (!force && this.format.compact) return;

    if (force || this.buf && !this.isLast(" ") && !this.isLast("\n")) {
      this.push(" ");
    }
  };

  /**
   * Remove the last character.
   */

  Buffer.prototype.removeLast = function removeLast(cha) {
    if (this.format.compact) return;
    return this._removeLast(cha);
  };

  Buffer.prototype._removeLast = function _removeLast(cha) {
    if (!this._isLast(cha)) return;
    this.buf = this.buf.substr(0, this.buf.length - 1);
    this.position.unshift(cha);
  };

  /**
   * Set some state that will be modified if a newline has been inserted before any
   * non-space characters.
   *
   * This is to prevent breaking semantics for terminatorless separator nodes. eg:
   *
   *    return foo;
   *
   * returns `foo`. But if we do:
   *
   *   return
   *   foo;
   *
   *  `undefined` will be returned and not `foo` due to the terminator.
   */

  Buffer.prototype.startTerminatorless = function startTerminatorless() {
    return this.parenPushNewlineState = {
      printed: false
    };
  };

  /**
   * Print an ending parentheses if a starting one has been printed.
   */

  Buffer.prototype.endTerminatorless = function endTerminatorless(state) {
    if (state.printed) {
      this.dedent();
      this.newline();
      this.push(")");
    }
  };

  /**
   * Add a newline (or many newlines), maintaining formatting.
   * Strips multiple newlines if removeLast is true.
   */

  Buffer.prototype.newline = function newline(i, removeLast) {
    if (this.format.compact || this.format.retainLines) return;

    if (this.format.concise) {
      this.space();
      return;
    }

    removeLast = removeLast || false;

    if (_lodashLangIsNumber2["default"](i)) {
      i = Math.min(2, i);

      if (this.endsWith("{\n") || this.endsWith(":\n")) i--;
      if (i <= 0) return;

      while (i > 0) {
        this._newline(removeLast);
        i--;
      }
      return;
    }

    if (_lodashLangIsBoolean2["default"](i)) {
      removeLast = i;
    }

    this._newline(removeLast);
  };

  /**
   * Adds a newline unless there is already two previous newlines.
   */

  Buffer.prototype._newline = function _newline(removeLast) {
    // never allow more than two lines
    if (this.endsWith("\n\n")) return;

    // remove the last newline
    if (removeLast && this.isLast("\n")) this.removeLast("\n");

    this.removeLast(" ");
    this._removeSpacesAfterLastNewline();
    this._push("\n");
  };

  /**
   * If buffer ends with a newline and some spaces after it, trim those spaces.
   */

  Buffer.prototype._removeSpacesAfterLastNewline = function _removeSpacesAfterLastNewline() {
    var lastNewlineIndex = this.buf.lastIndexOf("\n");
    if (lastNewlineIndex === -1) {
      return;
    }

    var index = this.buf.length - 1;
    while (index > lastNewlineIndex) {
      if (this.buf[index] !== " ") {
        break;
      }

      index--;
    }

    if (index === lastNewlineIndex) {
      this.buf = this.buf.substring(0, index + 1);
    }
  };

  /**
   * Push a string to the buffer, maintaining indentation and newlines.
   */

  Buffer.prototype.push = function push(str, noIndent) {
    if (!this.format.compact && this._indent && !noIndent && str !== "\n") {
      // we have an indent level and we aren't pushing a newline
      var indent = this.getIndent();

      // replace all newlines with newlines with the indentation
      str = str.replace(/\n/g, "\n" + indent);

      // we've got a newline before us so prepend on the indentation
      if (this.isLast("\n")) this._push(indent);
    }

    this._push(str);
  };

  /**
   * Push a string to the buffer.
   */

  Buffer.prototype._push = function _push(str) {
    // see startTerminatorless() instance method
    var parenPushNewlineState = this.parenPushNewlineState;
    if (parenPushNewlineState) {
      for (var i = 0; i < str.length; i++) {
        var cha = str[i];

        // we can ignore spaces since they wont interupt a terminatorless separator
        if (cha === " ") continue;

        this.parenPushNewlineState = null;

        if (cha === "\n" || cha === "/") {
          // we're going to break this terminator expression so we need to add a parentheses
          this._push("(");
          this.indent();
          parenPushNewlineState.printed = true;
        }

        break;
      }
    }

    //
    this.position.push(str);
    this.buf += str;
  };

  /**
   * Test if the buffer ends with a string.
   */

  Buffer.prototype.endsWith = function endsWith(str) {
    var buf = arguments.length <= 1 || arguments[1] === undefined ? this.buf : arguments[1];

    if (str.length === 1) {
      return buf[buf.length - 1] === str;
    } else {
      return buf.slice(-str.length) === str;
    }
  };

  /**
   * Test if a character is last in the buffer.
   */

  Buffer.prototype.isLast = function isLast(cha) {
    if (this.format.compact) return false;
    return this._isLast(cha);
  };

  Buffer.prototype._isLast = function _isLast(cha) {
    var buf = this.buf;
    var last = buf[buf.length - 1];

    if (Array.isArray(cha)) {
      return _lodashCollectionIncludes2["default"](cha, last);
    } else {
      return cha === last;
    }
  };

  return Buffer;
})();

exports["default"] = Buffer;
module.exports = exports["default"];
},{"lodash/collection/includes":755,"lodash/lang/isBoolean":841,"lodash/lang/isNumber":845,"repeating":904,"trim-right":941}],194:[function(require,module,exports){
/**
 * Print File.program
 */

"use strict";

exports.__esModule = true;
exports.File = File;
exports.Program = Program;
exports.BlockStatement = BlockStatement;
exports.Noop = Noop;

function File(node, print) {
  print.plain(node.program);
}

/**
 * Print all nodes in a Program.body.
 */

function Program(node, print) {
  print.sequence(node.body);
}

/**
 * Print BlockStatement, collapses empty blocks, prints body.
 */

function BlockStatement(node, print) {
  this.push("{");
  if (node.body.length) {
    this.newline();
    print.sequence(node.body, { indent: true });
    if (!this.format.retainLines) this.removeLast("\n");
    this.rightBrace();
  } else {
    print.printInnerComments();
    this.push("}");
  }
}

/**
 * What is my purpose?
 * Why am I here?
 * Why are any of us here?
 * Does any of this really matter?
 */

function Noop() {}
},{}],195:[function(require,module,exports){
/**
 * Print ClassDeclaration, prints decorators, typeParameters, extends, implements, and body.
 */

"use strict";

exports.__esModule = true;
exports.ClassDeclaration = ClassDeclaration;
exports.ClassBody = ClassBody;
exports.ClassProperty = ClassProperty;
exports.MethodDefinition = MethodDefinition;

function ClassDeclaration(node, print) {
  print.list(node.decorators, { separator: "" });
  this.push("class");

  if (node.id) {
    this.push(" ");
    print.plain(node.id);
  }

  print.plain(node.typeParameters);

  if (node.superClass) {
    this.push(" extends ");
    print.plain(node.superClass);
    print.plain(node.superTypeParameters);
  }

  if (node["implements"]) {
    this.push(" implements ");
    print.join(node["implements"], { separator: ", " });
  }

  this.space();
  print.plain(node.body);
}

/**
 * Alias ClassDeclaration printer as ClassExpression.
 */

exports.ClassExpression = ClassDeclaration;

/**
 * Print ClassBody, collapses empty blocks, prints body.
 */

function ClassBody(node, print) {
  this.push("{");
  if (node.body.length === 0) {
    print.printInnerComments();
    this.push("}");
  } else {
    this.newline();

    this.indent();
    print.sequence(node.body);
    this.dedent();

    this.rightBrace();
  }
}

/**
 * Print ClassProperty, prints decorators, static, key, typeAnnotation, and value.
 * Also: semicolons, deal with it.
 */

function ClassProperty(node, print) {
  print.list(node.decorators, { separator: "" });

  if (node["static"]) this.push("static ");
  print.plain(node.key);
  print.plain(node.typeAnnotation);
  if (node.value) {
    this.space();
    this.push("=");
    this.space();
    print.plain(node.value);
  }
  this.semicolon();
}

/**
 * Print MethodDefinition, prints decorations, static, and method.
 */

function MethodDefinition(node, print) {
  print.list(node.decorators, { separator: "" });

  if (node["static"]) {
    this.push("static ");
  }

  this._method(node, print);
}
},{}],196:[function(require,module,exports){
/**
 * Prints ComprehensionBlock, prints left and right.
 */

"use strict";

exports.__esModule = true;
exports.ComprehensionBlock = ComprehensionBlock;
exports.ComprehensionExpression = ComprehensionExpression;

function ComprehensionBlock(node, print) {
  this.keyword("for");
  this.push("(");
  print.plain(node.left);
  this.push(" of ");
  print.plain(node.right);
  this.push(")");
}

/**
 * Prints ComprehensionExpression, prints blocks, filter, and body. Handles generators.
 */

function ComprehensionExpression(node, print) {
  this.push(node.generator ? "(" : "[");

  print.join(node.blocks, { separator: " " });
  this.space();

  if (node.filter) {
    this.keyword("if");
    this.push("(");
    print.plain(node.filter);
    this.push(")");
    this.space();
  }

  print.plain(node.body);

  this.push(node.generator ? ")" : "]");
}
},{}],197:[function(require,module,exports){
"use strict";

exports.__esModule = true;
exports.UnaryExpression = UnaryExpression;
exports.DoExpression = DoExpression;
exports.ParenthesizedExpression = ParenthesizedExpression;
exports.UpdateExpression = UpdateExpression;
exports.ConditionalExpression = ConditionalExpression;
exports.NewExpression = NewExpression;
exports.SequenceExpression = SequenceExpression;
exports.ThisExpression = ThisExpression;
exports.Super = Super;
exports.Decorator = Decorator;
exports.CallExpression = CallExpression;
exports.EmptyStatement = EmptyStatement;
exports.ExpressionStatement = ExpressionStatement;
exports.AssignmentPattern = AssignmentPattern;
exports.AssignmentExpression = AssignmentExpression;
exports.BindExpression = BindExpression;
exports.MemberExpression = MemberExpression;
exports.MetaProperty = MetaProperty;
// istanbul ignore next

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj["default"] = obj; return newObj; } }

// istanbul ignore next

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

var _isInteger = require("is-integer");

var _isInteger2 = _interopRequireDefault(_isInteger);

var _lodashLangIsNumber = require("lodash/lang/isNumber");

var _lodashLangIsNumber2 = _interopRequireDefault(_lodashLangIsNumber);

var _node = require("../node");

var _node2 = _interopRequireDefault(_node);

var _types = require("../../types");

var t = _interopRequireWildcard(_types);

/**
 * RegExp for testing scientific notation in literals.
 */

var SCIENTIFIC_NOTATION = /e/i;
var ZERO_DECIMAL_INTEGER = /\.0+$/;

/**
 * RegExp for testing if a numeric literal is
 * a BinaryIntegerLiteral, OctalIntegerLiteral or HexIntegerLiteral.
 */

var NON_DECIMAL_NUMERIC_LITERAL = /^0(b|o|x)/i;

/**
 * Prints UnaryExpression, prints operator and argument.
 */

function UnaryExpression(node, print) {
  var needsSpace = /[a-z]$/.test(node.operator);
  var arg = node.argument;

  if (t.isUpdateExpression(arg) || t.isUnaryExpression(arg)) {
    needsSpace = true;
  }

  if (t.isUnaryExpression(arg) && arg.operator === "!") {
    needsSpace = false;
  }

  this.push(node.operator);
  if (needsSpace) this.push(" ");
  print.plain(node.argument);
}

/**
 * Prints DoExpression, prints body.
 */

function DoExpression(node, print) {
  this.push("do");
  this.space();
  print.plain(node.body);
}

/**
 * Prints ParenthesizedExpression, prints expression.
 */

function ParenthesizedExpression(node, print) {
  this.push("(");
  print.plain(node.expression);
  this.push(")");
}

/**
 * Prints UpdateExpression, prints operator and argument.
 */

function UpdateExpression(node, print) {
  if (node.prefix) {
    this.push(node.operator);
    print.plain(node.argument);
  } else {
    print.plain(node.argument);
    this.push(node.operator);
  }
}

/**
 * Prints ConditionalExpression, prints test, consequent, and alternate.
 */

function ConditionalExpression(node, print) {
  print.plain(node.test);
  this.space();
  this.push("?");
  this.space();
  print.plain(node.consequent);
  this.space();
  this.push(":");
  this.space();
  print.plain(node.alternate);
}

/**
 * Prints NewExpression, prints callee and arguments.
 */

function NewExpression(node, print) {
  this.push("new ");
  print.plain(node.callee);
  this.push("(");
  print.list(node.arguments);
  this.push(")");
}

/**
 * Prints SequenceExpression.expressions.
 */

function SequenceExpression(node, print) {
  print.list(node.expressions);
}

/**
 * Prints ThisExpression.
 */

function ThisExpression() {
  this.push("this");
}

/**
 * Prints Super.
 */

function Super() {
  this.push("super");
}

/**
 * Prints Decorator, prints expression.
 */

function Decorator(node, print) {
  this.push("@");
  print.plain(node.expression);
  this.newline();
}

/**
 * Prints CallExpression, prints callee and arguments.
 */

function CallExpression(node, print) {
  print.plain(node.callee);

  this.push("(");

  var isPrettyCall = node._prettyCall && !this.format.retainLines && !this.format.compact;

  var separator;
  if (isPrettyCall) {
    separator = ",\n";
    this.newline();
    this.indent();
  }

  print.list(node.arguments, { separator: separator });

  if (isPrettyCall) {
    this.newline();
    this.dedent();
  }

  this.push(")");
}

/**
 * Builds yield or await expression printer.
 * Prints delegate, all, and argument.
 */

var buildYieldAwait = function buildYieldAwait(keyword) {
  return function (node, print) {
    this.push(keyword);

    if (node.delegate || node.all) {
      this.push("*");
    }

    if (node.argument) {
      this.push(" ");
      var terminatorState = this.startTerminatorless();
      print.plain(node.argument);
      this.endTerminatorless(terminatorState);
    }
  };
};

/**
 * Create YieldExpression and AwaitExpression printers.
 */

var YieldExpression = buildYieldAwait("yield");
exports.YieldExpression = YieldExpression;
var AwaitExpression = buildYieldAwait("await");

exports.AwaitExpression = AwaitExpression;
/**
 * Prints EmptyStatement.
 */

function EmptyStatement() {
  this.semicolon();
}

/**
 * Prints ExpressionStatement, prints expression.
 */

function ExpressionStatement(node, print) {
  print.plain(node.expression);
  this.semicolon();
}

/**
 * Prints AssignmentPattern, prints left and right.
 */

function AssignmentPattern(node, print) {
  print.plain(node.left);
  this.push(" = ");
  print.plain(node.right);
}

/**
 * Prints AssignmentExpression, prints left, operator, and right.
 */

function AssignmentExpression(node, print, parent) {
  // Somewhere inside a for statement `init` node but doesn't usually
  // needs a paren except for `in` expressions: `for (a in b ? a : b;;)`
  var parens = this._inForStatementInit && node.operator === "in" && !_node2["default"].needsParens(node, parent);

  if (parens) {
    this.push("(");
  }

  // todo: add cases where the spaces can be dropped when in compact mode
  print.plain(node.left);

  var spaces = node.operator === "in" || node.operator === "instanceof";
  spaces = true; // todo: https://github.com/babel/babel/issues/1835
  this.space(spaces);

  this.push(node.operator);

  if (!spaces) {
    // space is mandatory to avoid outputting <!--
    // http://javascript.spec.whatwg.org/#comment-syntax
    spaces = node.operator === "<" && t.isUnaryExpression(node.right, { prefix: true, operator: "!" }) && t.isUnaryExpression(node.right.argument, { prefix: true, operator: "--" });
  }

  this.space(spaces);

  print.plain(node.right);

  if (parens) {
    this.push(")");
  }
}

/**
 * Prints BindExpression, prints object and callee.
 */

function BindExpression(node, print) {
  print.plain(node.object);
  this.push("::");
  print.plain(node.callee);
}

/**
 * Alias ClassDeclaration printer as ClassExpression,
 * and AssignmentExpression printer as LogicalExpression.
 */

exports.BinaryExpression = AssignmentExpression;
exports.LogicalExpression = AssignmentExpression;

/**
 * Print MemberExpression, prints object, property, and value. Handles computed.
 */

function MemberExpression(node, print) {
  var obj = node.object;
  print.plain(obj);

  if (!node.computed && t.isMemberExpression(node.property)) {
    throw new TypeError("Got a MemberExpression for MemberExpression property");
  }

  var computed = node.computed;
  if (t.isLiteral(node.property) && _lodashLangIsNumber2["default"](node.property.value)) {
    computed = true;
  }

  if (computed) {
    this.push("[");
    print.plain(node.property);
    this.push("]");
  } else {
    if (t.isLiteral(node.object)) {
      var val = this._Literal(node.object);
      if (_isInteger2["default"](+val) && !ZERO_DECIMAL_INTEGER.test(val) && !SCIENTIFIC_NOTATION.test(val) && !this.endsWith(".") && !NON_DECIMAL_NUMERIC_LITERAL.test(val)) {
        this.push(".");
      }
    }

    this.push(".");
    print.plain(node.property);
  }
}

/**
 * Print MetaProperty, prints meta and property.
 */

function MetaProperty(node, print) {
  print.plain(node.meta);
  this.push(".");
  print.plain(node.property);
}
},{"../../types":354,"../node":206,"is-integer":704,"lodash/lang/isNumber":845}],198:[function(require,module,exports){
"use strict";

exports.__esModule = true;
exports.AnyTypeAnnotation = AnyTypeAnnotation;
exports.ArrayTypeAnnotation = ArrayTypeAnnotation;
exports.BooleanTypeAnnotation = BooleanTypeAnnotation;
exports.BooleanLiteralTypeAnnotation = BooleanLiteralTypeAnnotation;
exports.DeclareClass = DeclareClass;
exports.DeclareFunction = DeclareFunction;
exports.DeclareModule = DeclareModule;
exports.DeclareVariable = DeclareVariable;
exports.FunctionTypeAnnotation = FunctionTypeAnnotation;
exports.FunctionTypeParam = FunctionTypeParam;
exports.InterfaceExtends = InterfaceExtends;
exports._interfaceish = _interfaceish;
exports.InterfaceDeclaration = InterfaceDeclaration;
exports.IntersectionTypeAnnotation = IntersectionTypeAnnotation;
exports.MixedTypeAnnotation = MixedTypeAnnotation;
exports.NullableTypeAnnotation = NullableTypeAnnotation;
exports.NumberTypeAnnotation = NumberTypeAnnotation;
exports.StringLiteralTypeAnnotation = StringLiteralTypeAnnotation;
exports.StringTypeAnnotation = StringTypeAnnotation;
exports.TupleTypeAnnotation = TupleTypeAnnotation;
exports.TypeofTypeAnnotation = TypeofTypeAnnotation;
exports.TypeAlias = TypeAlias;
exports.TypeAnnotation = TypeAnnotation;
exports.TypeParameterInstantiation = TypeParameterInstantiation;
exports.ObjectTypeAnnotation = ObjectTypeAnnotation;
exports.ObjectTypeCallProperty = ObjectTypeCallProperty;
exports.ObjectTypeIndexer = ObjectTypeIndexer;
exports.ObjectTypeProperty = ObjectTypeProperty;
exports.QualifiedTypeIdentifier = QualifiedTypeIdentifier;
exports.UnionTypeAnnotation = UnionTypeAnnotation;
exports.TypeCastExpression = TypeCastExpression;
exports.VoidTypeAnnotation = VoidTypeAnnotation;
// istanbul ignore next

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj["default"] = obj; return newObj; } }

var _types = require("../../types");

var t = _interopRequireWildcard(_types);

/**
 * Prints AnyTypeAnnotation.
 */

function AnyTypeAnnotation() {
  this.push("any");
}

/**
 * Prints ArrayTypeAnnotation, prints elementType.
 */

function ArrayTypeAnnotation(node, print) {
  print.plain(node.elementType);
  this.push("[");
  this.push("]");
}

/**
 * Prints BooleanTypeAnnotation.
 */

function BooleanTypeAnnotation() {
  this.push("bool");
}

/**
 * Prints BooleanLiteralTypeAnnotation.
 */

function BooleanLiteralTypeAnnotation(node) {
  this.push(node.value ? "true" : "false");
}

/**
 * Prints DeclareClass, prints node.
 */

function DeclareClass(node, print) {
  this.push("declare class ");
  this._interfaceish(node, print);
}

/**
 * Prints DeclareFunction, prints id and id.typeAnnotation.
 */

function DeclareFunction(node, print) {
  this.push("declare function ");
  print.plain(node.id);
  print.plain(node.id.typeAnnotation.typeAnnotation);
  this.semicolon();
}

/**
 * Prints DeclareModule, prints id and body.
 */

function DeclareModule(node, print) {
  this.push("declare module ");
  print.plain(node.id);
  this.space();
  print.plain(node.body);
}

/**
 * Prints DeclareVariable, prints id and id.typeAnnotation.
 */

function DeclareVariable(node, print) {
  this.push("declare var ");
  print.plain(node.id);
  print.plain(node.id.typeAnnotation);
  this.semicolon();
}

/**
 * Prints FunctionTypeAnnotation, prints typeParameters, params, and rest.
 */

function FunctionTypeAnnotation(node, print, parent) {
  print.plain(node.typeParameters);
  this.push("(");
  print.list(node.params);

  if (node.rest) {
    if (node.params.length) {
      this.push(",");
      this.space();
    }
    this.push("...");
    print.plain(node.rest);
  }

  this.push(")");

  // this node type is overloaded, not sure why but it makes it EXTREMELY annoying
  if (parent.type === "ObjectTypeProperty" || parent.type === "ObjectTypeCallProperty" || parent.type === "DeclareFunction") {
    this.push(":");
  } else {
    this.space();
    this.push("=>");
  }

  this.space();
  print.plain(node.returnType);
}

/**
 * Prints FunctionTypeParam, prints name and typeAnnotation, handles optional.
 */

function FunctionTypeParam(node, print) {
  print.plain(node.name);
  if (node.optional) this.push("?");
  this.push(":");
  this.space();
  print.plain(node.typeAnnotation);
}

/**
 * Prints InterfaceExtends, prints id and typeParameters.
 */

function InterfaceExtends(node, print) {
  print.plain(node.id);
  print.plain(node.typeParameters);
}

/**
 * Alias InterfaceExtends printer as ClassImplements,
 * and InterfaceExtends printer as GenericTypeAnnotation.
 */

exports.ClassImplements = InterfaceExtends;
exports.GenericTypeAnnotation = InterfaceExtends;

/**
 * Prints interface-like node, prints id, typeParameters, extends, and body.
 */

function _interfaceish(node, print) {
  print.plain(node.id);
  print.plain(node.typeParameters);
  if (node["extends"].length) {
    this.push(" extends ");
    print.join(node["extends"], { separator: ", " });
  }
  this.space();
  print.plain(node.body);
}

/**
 * Prints InterfaceDeclaration, prints node.
 */

function InterfaceDeclaration(node, print) {
  this.push("interface ");
  this._interfaceish(node, print);
}

/**
 * Prints IntersectionTypeAnnotation, prints types.
 */

function IntersectionTypeAnnotation(node, print) {
  print.join(node.types, { separator: " & " });
}

/**
 * Prints MixedTypeAnnotation.
 */

function MixedTypeAnnotation() {
  this.push("mixed");
}

/**
 * Prints NullableTypeAnnotation, prints typeAnnotation.
 */

function NullableTypeAnnotation(node, print) {
  this.push("?");
  print.plain(node.typeAnnotation);
}

/**
 * Prints NumberLiteralTypeAnnotation, prints value.
 */

var _types2 = require("./types");

exports.NumberLiteralTypeAnnotation = _types2.Literal;

/**
 * Prints NumberTypeAnnotation.
 */

function NumberTypeAnnotation() {
  this.push("number");
}

/**
 * Prints StringLiteralTypeAnnotation, prints value.
 */

function StringLiteralTypeAnnotation(node) {
  this.push(this._stringLiteral(node.value));
}

/**
 * Prints StringTypeAnnotation.
 */

function StringTypeAnnotation() {
  this.push("string");
}

/**
 * Prints TupleTypeAnnotation, prints types.
 */

function TupleTypeAnnotation(node, print) {
  this.push("[");
  print.join(node.types, { separator: ", " });
  this.push("]");
}

/**
 * Prints TypeofTypeAnnotation, prints argument.
 */

function TypeofTypeAnnotation(node, print) {
  this.push("typeof ");
  print.plain(node.argument);
}

/**
 * Prints TypeAlias, prints id, typeParameters, and right.
 */

function TypeAlias(node, print) {
  this.push("type ");
  print.plain(node.id);
  print.plain(node.typeParameters);
  this.space();
  this.push("=");
  this.space();
  print.plain(node.right);
  this.semicolon();
}

/**
 * Prints TypeAnnotation, prints typeAnnotation, handles optional.
 */

function TypeAnnotation(node, print) {
  this.push(":");
  this.space();
  if (node.optional) this.push("?");
  print.plain(node.typeAnnotation);
}

/**
 * Prints TypeParameterInstantiation, prints params.
 */

function TypeParameterInstantiation(node, print) {
  this.push("<");
  print.join(node.params, {
    separator: ", ",
    iterator: function iterator(node) {
      print.plain(node.typeAnnotation);
    }
  });
  this.push(">");
}

/**
 * Alias TypeParameterInstantiation printer as TypeParameterDeclaration
 */

exports.TypeParameterDeclaration = TypeParameterInstantiation;

/**
 * Prints ObjectTypeAnnotation, prints properties, callProperties, and indexers.
 */

function ObjectTypeAnnotation(node, print) {
  // istanbul ignore next

  var _this = this;

  this.push("{");
  var props = node.properties.concat(node.callProperties, node.indexers);

  if (props.length) {
    this.space();

    print.list(props, {
      separator: false,
      indent: true,
      iterator: function iterator() {
        if (props.length !== 1) {
          _this.semicolon();
          _this.space();
        }
      }
    });

    this.space();
  }

  this.push("}");
}

/**
 * Prints ObjectTypeCallProperty, prints value, handles static.
 */

function ObjectTypeCallProperty(node, print) {
  if (node["static"]) this.push("static ");
  print.plain(node.value);
}

/**
 * Prints ObjectTypeIndexer, prints id, key, and value, handles static.
 */

function ObjectTypeIndexer(node, print) {
  if (node["static"]) this.push("static ");
  this.push("[");
  print.plain(node.id);
  this.push(":");
  this.space();
  print.plain(node.key);
  this.push("]");
  this.push(":");
  this.space();
  print.plain(node.value);
}

/**
 * Prints ObjectTypeProperty, prints static, key, and value.
 */

function ObjectTypeProperty(node, print) {
  if (node["static"]) this.push("static ");
  print.plain(node.key);
  if (node.optional) this.push("?");
  if (!t.isFunctionTypeAnnotation(node.value)) {
    this.push(":");
    this.space();
  }
  print.plain(node.value);
}

/**
 * Prints QualifiedTypeIdentifier, prints qualification and id.
 */

function QualifiedTypeIdentifier(node, print) {
  print.plain(node.qualification);
  this.push(".");
  print.plain(node.id);
}

/**
 * Prints UnionTypeAnnotation, prints types.
 */

function UnionTypeAnnotation(node, print) {
  print.join(node.types, { separator: " | " });
}

/**
 * Prints TypeCastExpression, prints expression and typeAnnotation.
 */

function TypeCastExpression(node, print) {
  this.push("(");
  print.plain(node.expression);
  print.plain(node.typeAnnotation);
  this.push(")");
}

/**
 * Prints VoidTypeAnnotation.
 */

function VoidTypeAnnotation() {
  this.push("void");
}
},{"../../types":354,"./types":204}],199:[function(require,module,exports){
"use strict";

exports.__esModule = true;
exports.JSXAttribute = JSXAttribute;
exports.JSXIdentifier = JSXIdentifier;
exports.JSXNamespacedName = JSXNamespacedName;
exports.JSXMemberExpression = JSXMemberExpression;
exports.JSXSpreadAttribute = JSXSpreadAttribute;
exports.JSXExpressionContainer = JSXExpressionContainer;
exports.JSXElement = JSXElement;
exports.JSXOpeningElement = JSXOpeningElement;
exports.JSXClosingElement = JSXClosingElement;
exports.JSXEmptyExpression = JSXEmptyExpression;
// istanbul ignore next

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj["default"] = obj; return newObj; } }

var _types = require("../../types");

var t = _interopRequireWildcard(_types);

/**
 * Prints JSXAttribute, prints name and value.
 */

function JSXAttribute(node, print) {
  print.plain(node.name);
  if (node.value) {
    this.push("=");
    print.plain(node.value);
  }
}

/**
 * Prints JSXIdentifier, prints name.
 */

function JSXIdentifier(node) {
  this.push(node.name);
}

/**
 * Prints JSXNamespacedName, prints namespace and name.
 */

function JSXNamespacedName(node, print) {
  print.plain(node.namespace);
  this.push(":");
  print.plain(node.name);
}

/**
 * Prints JSXMemberExpression, prints object and property.
 */

function JSXMemberExpression(node, print) {
  print.plain(node.object);
  this.push(".");
  print.plain(node.property);
}

/**
 * Prints JSXSpreadAttribute, prints argument.
 */

function JSXSpreadAttribute(node, print) {
  this.push("{...");
  print.plain(node.argument);
  this.push("}");
}

/**
 * Prints JSXExpressionContainer, prints expression.
 */

function JSXExpressionContainer(node, print) {
  this.push("{");
  print.plain(node.expression);
  this.push("}");
}

/**
 * Prints JSXElement, prints openingElement, children, and closingElement.
 */

function JSXElement(node, print) {
  var open = node.openingElement;
  print.plain(open);
  if (open.selfClosing) return;

  this.indent();
  var _arr = node.children;
  for (var _i = 0; _i < _arr.length; _i++) {
    var child = _arr[_i];
    if (t.isLiteral(child)) {
      this.push(child.value, true);
    } else {
      print.plain(child);
    }
  }
  this.dedent();

  print.plain(node.closingElement);
}

/**
 * Prints JSXOpeningElement, prints name and attributes, handles selfClosing.
 */

function JSXOpeningElement(node, print) {
  this.push("<");
  print.plain(node.name);
  if (node.attributes.length > 0) {
    this.push(" ");
    print.join(node.attributes, { separator: " " });
  }
  this.push(node.selfClosing ? " />" : ">");
}

/**
 * Prints JSXClosingElement, prints name.
 */

function JSXClosingElement(node, print) {
  this.push("</");
  print.plain(node.name);
  this.push(">");
}

/**
 * Prints JSXEmptyExpression.
 */

function JSXEmptyExpression() {}
},{"../../types":354}],200:[function(require,module,exports){
"use strict";

exports.__esModule = true;
exports._params = _params;
exports._method = _method;
exports.FunctionExpression = FunctionExpression;
exports.ArrowFunctionExpression = ArrowFunctionExpression;
// istanbul ignore next

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj["default"] = obj; return newObj; } }

var _types = require("../../types");

var t = _interopRequireWildcard(_types);

/**
 * Prints nodes with params, prints typeParameters, params, and returnType, handles optional params.
 */

function _params(node, print) {
  // istanbul ignore next

  var _this = this;

  print.plain(node.typeParameters);
  this.push("(");
  print.list(node.params, {
    iterator: function iterator(node) {
      if (node.optional) _this.push("?");
      print.plain(node.typeAnnotation);
    }
  });
  this.push(")");

  if (node.returnType) {
    print.plain(node.returnType);
  }
}

/**
 * Prints method-like nodes, prints key, value, and body, handles async, generator, computed, and get or set.
 */

function _method(node, print) {
  var value = node.value;
  var kind = node.kind;
  var key = node.key;

  if (kind === "method" || kind === "init") {
    if (value.generator) {
      this.push("*");
    }
  }

  if (kind === "get" || kind === "set") {
    this.push(kind + " ");
  }

  if (value.async) this.push("async ");

  if (node.computed) {
    this.push("[");
    print.plain(key);
    this.push("]");
  } else {
    print.plain(key);
  }

  this._params(value, print);
  this.space();
  print.plain(value.body);
}

/**
 * Prints FunctionExpression, prints id and body, handles async and generator.
 */

function FunctionExpression(node, print) {
  if (node.async) this.push("async ");
  this.push("function");
  if (node.generator) this.push("*");

  if (node.id) {
    this.push(" ");
    print.plain(node.id);
  } else {
    this.space();
  }

  this._params(node, print);
  this.space();
  print.plain(node.body);
}

/**
 * Alias FunctionExpression printer as FunctionDeclaration.
 */

exports.FunctionDeclaration = FunctionExpression;

/**
 * Prints ArrowFunctionExpression, prints params and body, handles async.
 * Leaves out parentheses when single param.
 */

function ArrowFunctionExpression(node, print) {
  if (node.async) this.push("async ");

  if (node.params.length === 1 && t.isIdentifier(node.params[0])) {
    print.plain(node.params[0]);
  } else {
    this._params(node, print);
  }

  this.push(" => ");

  var bodyNeedsParens = t.isObjectExpression(node.body);

  if (bodyNeedsParens) {
    this.push("(");
  }

  print.plain(node.body);

  if (bodyNeedsParens) {
    this.push(")");
  }
}
},{"../../types":354}],201:[function(require,module,exports){
"use strict";

exports.__esModule = true;
exports.ImportSpecifier = ImportSpecifier;
exports.ImportDefaultSpecifier = ImportDefaultSpecifier;
exports.ExportDefaultSpecifier = ExportDefaultSpecifier;
exports.ExportSpecifier = ExportSpecifier;
exports.ExportNamespaceSpecifier = ExportNamespaceSpecifier;
exports.ExportAllDeclaration = ExportAllDeclaration;
exports.ExportNamedDeclaration = ExportNamedDeclaration;
exports.ExportDefaultDeclaration = ExportDefaultDeclaration;
exports.ImportDeclaration = ImportDeclaration;
exports.ImportNamespaceSpecifier = ImportNamespaceSpecifier;
// istanbul ignore next

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj["default"] = obj; return newObj; } }

var _types = require("../../types");

var t = _interopRequireWildcard(_types);

/**
 * Prints ImportSpecifier, prints imported and local.
 */

function ImportSpecifier(node, print) {
  print.plain(node.imported);
  if (node.local && node.local.name !== node.imported.name) {
    this.push(" as ");
    print.plain(node.local);
  }
}

/**
 * Prints ImportDefaultSpecifier, prints local.
 */

function ImportDefaultSpecifier(node, print) {
  print.plain(node.local);
}

/**
 * Prints ExportDefaultSpecifier, prints exported.
 */

function ExportDefaultSpecifier(node, print) {
  print.plain(node.exported);
}

/**
 * Prints ExportSpecifier, prints local and exported.
 */

function ExportSpecifier(node, print) {
  print.plain(node.local);
  if (node.exported && node.local.name !== node.exported.name) {
    this.push(" as ");
    print.plain(node.exported);
  }
}

/**
 * Prints ExportNamespaceSpecifier, prints exported.
 */

function ExportNamespaceSpecifier(node, print) {
  this.push("* as ");
  print.plain(node.exported);
}

/**
 * Prints ExportAllDeclaration, prints exported and source.
 */

function ExportAllDeclaration(node, print) {
  this.push("export *");
  if (node.exported) {
    this.push(" as ");
    print.plain(node.exported);
  }
  this.push(" from ");
  print.plain(node.source);
  this.semicolon();
}

/**
 * Prints ExportNamedDeclaration, delegates to ExportDeclaration.
 */

function ExportNamedDeclaration(node, print) {
  this.push("export ");
  ExportDeclaration.call(this, node, print);
}

/**
 * Prints ExportDefaultDeclaration, delegates to ExportDeclaration.
 */

function ExportDefaultDeclaration(node, print) {
  this.push("export default ");
  ExportDeclaration.call(this, node, print);
}

/**
 * Prints ExportDeclaration, prints specifiers, declration, and source.
 */

function ExportDeclaration(node, print) {
  var specifiers = node.specifiers;

  if (node.declaration) {
    var declar = node.declaration;
    print.plain(declar);
    if (t.isStatement(declar) || t.isFunction(declar) || t.isClass(declar)) return;
  } else {
    if (node.exportKind === "type") {
      this.push("type ");
    }

    var first = specifiers[0];
    var hasSpecial = false;
    if (t.isExportDefaultSpecifier(first) || t.isExportNamespaceSpecifier(first)) {
      hasSpecial = true;
      print.plain(specifiers.shift());
      if (specifiers.length) {
        this.push(", ");
      }
    }

    if (specifiers.length || !specifiers.length && !hasSpecial) {
      this.push("{");
      if (specifiers.length) {
        this.space();
        print.join(specifiers, { separator: ", " });
        this.space();
      }
      this.push("}");
    }

    if (node.source) {
      this.push(" from ");
      print.plain(node.source);
    }
  }

  this.ensureSemicolon();
}

/**
 * Prints ImportDeclaration, prints specifiers and source, handles isType.
 */

function ImportDeclaration(node, print) {
  this.push("import ");

  if (node.importKind === "type" || node.importKind === "typeof") {
    this.push(node.importKind + " ");
  }

  var specfiers = node.specifiers;
  if (specfiers && specfiers.length) {
    var first = node.specifiers[0];
    if (t.isImportDefaultSpecifier(first) || t.isImportNamespaceSpecifier(first)) {
      print.plain(node.specifiers.shift());
      if (node.specifiers.length) {
        this.push(", ");
      }
    }

    if (node.specifiers.length) {
      this.push("{");
      this.space();
      print.join(node.specifiers, { separator: ", " });
      this.space();
      this.push("}");
    }

    this.push(" from ");
  }

  print.plain(node.source);
  this.semicolon();
}

/**
 * Prints ImportNamespaceSpecifier, prints local.
 */

function ImportNamespaceSpecifier(node, print) {
  this.push("* as ");
  print.plain(node.local);
}
},{"../../types":354}],202:[function(require,module,exports){
"use strict";

exports.__esModule = true;
exports.WithStatement = WithStatement;
exports.IfStatement = IfStatement;
exports.ForStatement = ForStatement;
exports.WhileStatement = WhileStatement;
exports.DoWhileStatement = DoWhileStatement;
exports.LabeledStatement = LabeledStatement;
exports.TryStatement = TryStatement;
exports.CatchClause = CatchClause;
exports.SwitchStatement = SwitchStatement;
exports.SwitchCase = SwitchCase;
exports.DebuggerStatement = DebuggerStatement;
exports.VariableDeclaration = VariableDeclaration;
exports.VariableDeclarator = VariableDeclarator;
// istanbul ignore next

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj["default"] = obj; return newObj; } }

// istanbul ignore next

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

var _repeating = require("repeating");

var _repeating2 = _interopRequireDefault(_repeating);

var _types = require("../../types");

var t = _interopRequireWildcard(_types);

/**
 * Prints WithStatement, prints object and body.
 */

function WithStatement(node, print) {
  this.keyword("with");
  this.push("(");
  print.plain(node.object);
  this.push(")");
  print.block(node.body);
}

/**
 * Prints IfStatement, prints test, consequent, and alternate.
 */

function IfStatement(node, print) {
  this.keyword("if");
  this.push("(");
  print.plain(node.test);
  this.push(")");
  this.space();

  print.indentOnComments(node.consequent);

  if (node.alternate) {
    if (this.isLast("}")) this.space();
    this.push("else ");
    print.indentOnComments(node.alternate);
  }
}

/**
 * Prints ForStatement, prints init, test, update, and body.
 */

function ForStatement(node, print) {
  this.keyword("for");
  this.push("(");

  this._inForStatementInit = true;
  print.plain(node.init);
  this._inForStatementInit = false;
  this.push(";");

  if (node.test) {
    this.space();
    print.plain(node.test);
  }
  this.push(";");

  if (node.update) {
    this.space();
    print.plain(node.update);
  }

  this.push(")");
  print.block(node.body);
}

/**
 * Prints WhileStatement, prints test and body.
 */

function WhileStatement(node, print) {
  this.keyword("while");
  this.push("(");
  print.plain(node.test);
  this.push(")");
  print.block(node.body);
}

/**
 * Builds ForIn or ForOf statement printers.
 * Prints left, right, and body.
 */

var buildForXStatement = function buildForXStatement(op) {
  return function (node, print) {
    this.keyword("for");
    this.push("(");
    print.plain(node.left);
    this.push(" " + op + " ");
    print.plain(node.right);
    this.push(")");
    print.block(node.body);
  };
};

/**
 * Create ForInStatement and ForOfStatement printers.
 */

var ForInStatement = buildForXStatement("in");
exports.ForInStatement = ForInStatement;
var ForOfStatement = buildForXStatement("of");

exports.ForOfStatement = ForOfStatement;
/**
 * Prints DoWhileStatement, prints body and test.
 */

function DoWhileStatement(node, print) {
  this.push("do ");
  print.plain(node.body);
  this.space();
  this.keyword("while");
  this.push("(");
  print.plain(node.test);
  this.push(");");
}

/**
 * Builds continue, return, or break statement printers.
 * Prints label (or key).
 */

var buildLabelStatement = function buildLabelStatement(prefix) {
  var key = arguments.length <= 1 || arguments[1] === undefined ? "label" : arguments[1];

  return function (node, print) {
    this.push(prefix);

    var label = node[key];
    if (label) {
      this.push(" ");
      var terminatorState = this.startTerminatorless();
      print.plain(label);
      this.endTerminatorless(terminatorState);
    }

    this.semicolon();
  };
};

/**
 * Create ContinueStatement, ReturnStatement, and BreakStatement printers.
 */

var ContinueStatement = buildLabelStatement("continue");
exports.ContinueStatement = ContinueStatement;
var ReturnStatement = buildLabelStatement("return", "argument");
exports.ReturnStatement = ReturnStatement;
var BreakStatement = buildLabelStatement("break");
exports.BreakStatement = BreakStatement;
var ThrowStatement = buildLabelStatement("throw", "argument");

exports.ThrowStatement = ThrowStatement;
/**
 * Prints LabeledStatement, prints label and body.
 */

function LabeledStatement(node, print) {
  print.plain(node.label);
  this.push(": ");
  print.plain(node.body);
}

/**
 * Prints TryStatement, prints block, handlers, and finalizer.
 */

function TryStatement(node, print) {
  this.keyword("try");
  print.plain(node.block);
  this.space();

  // Esprima bug puts the catch clause in a `handlers` array.
  // see https://code.google.com/p/esprima/issues/detail?id=433
  // We run into this from regenerator generated ast.
  if (node.handlers) {
    print.plain(node.handlers[0]);
  } else {
    print.plain(node.handler);
  }

  if (node.finalizer) {
    this.space();
    this.push("finally ");
    print.plain(node.finalizer);
  }
}

/**
 * Prints CatchClause, prints param and body.
 */

function CatchClause(node, print) {
  this.keyword("catch");
  this.push("(");
  print.plain(node.param);
  this.push(") ");
  print.plain(node.body);
}

/**
 * Prints SwitchStatement, prints discriminant and cases.
 */

function SwitchStatement(node, print) {
  this.keyword("switch");
  this.push("(");
  print.plain(node.discriminant);
  this.push(")");
  this.space();
  this.push("{");

  print.sequence(node.cases, {
    indent: true,
    addNewlines: function addNewlines(leading, cas) {
      if (!leading && node.cases[node.cases.length - 1] === cas) return -1;
    }
  });

  this.push("}");
}

/**
 * Prints SwitchCase, prints test and consequent.
 */

function SwitchCase(node, print) {
  if (node.test) {
    this.push("case ");
    print.plain(node.test);
    this.push(":");
  } else {
    this.push("default:");
  }

  if (node.consequent.length) {
    this.newline();
    print.sequence(node.consequent, { indent: true });
  }
}

/**
 * Prints DebuggerStatement.
 */

function DebuggerStatement() {
  this.push("debugger;");
}

/**
 * Prints VariableDeclaration, prints declarations, handles kind and format.
 */

function VariableDeclaration(node, print, parent) {
  this.push(node.kind + " ");

  var hasInits = false;
  // don't add whitespace to loop heads
  if (!t.isFor(parent)) {
    var _arr = node.declarations;

    for (var _i = 0; _i < _arr.length; _i++) {
      var declar = _arr[_i];
      if (declar.init) {
        // has an init so let's split it up over multiple lines
        hasInits = true;
      }
    }
  }

  //
  // use a pretty separator when we aren't in compact mode, have initializers and don't have retainLines on
  // this will format declarations like:
  //
  //   var foo = "bar", bar = "foo";
  //
  // into
  //
  //   var foo = "bar",
  //       bar = "foo";
  //

  var sep;
  if (!this.format.compact && !this.format.concise && hasInits && !this.format.retainLines) {
    sep = ",\n" + _repeating2["default"](" ", node.kind.length + 1);
  }

  //

  print.list(node.declarations, { separator: sep });

  if (t.isFor(parent)) {
    // don't give semicolons to these nodes since they'll be inserted in the parent generator
    if (parent.left === node || parent.init === node) return;
  }

  this.semicolon();
}

/**
 * Prints VariableDeclarator, handles id, id.typeAnnotation, and init.
 */

function VariableDeclarator(node, print) {
  print.plain(node.id);
  print.plain(node.id.typeAnnotation);
  if (node.init) {
    this.space();
    this.push("=");
    this.space();
    print.plain(node.init);
  }
}
},{"../../types":354,"repeating":904}],203:[function(require,module,exports){
/**
 * Prints TaggedTemplateExpression, prints tag and quasi.
 */

"use strict";

exports.__esModule = true;
exports.TaggedTemplateExpression = TaggedTemplateExpression;
exports.TemplateElement = TemplateElement;
exports.TemplateLiteral = TemplateLiteral;

function TaggedTemplateExpression(node, print) {
  print.plain(node.tag);
  print.plain(node.quasi);
}

/**
 * Prints TemplateElement, prints value.
 */

function TemplateElement(node) {
  this._push(node.value.raw);
}

/**
 * Prints TemplateLiteral, prints quasis, and expressions.
 */

function TemplateLiteral(node, print) {
  this.push("`");

  var quasis = node.quasis;
  var len = quasis.length;

  for (var i = 0; i < len; i++) {
    print.plain(quasis[i]);

    if (i + 1 < len) {
      this.push("${ ");
      print.plain(node.expressions[i]);
      this.push(" }");
    }
  }

  this._push("`");
}
},{}],204:[function(require,module,exports){
/* eslint quotes: 0 */

"use strict";

exports.__esModule = true;
exports.Identifier = Identifier;
exports.RestElement = RestElement;
exports.ObjectExpression = ObjectExpression;
exports.Property = Property;
exports.ArrayExpression = ArrayExpression;
exports.Literal = Literal;
exports._Literal = _Literal;
exports._stringLiteral = _stringLiteral;
// istanbul ignore next

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj["default"] = obj; return newObj; } }

var _types = require("../../types");

var t = _interopRequireWildcard(_types);

/**
 * Prints Identifier, prints name.
 */

function Identifier(node) {
  this.push(node.name);
}

/**
 * Prints RestElement, prints argument.
 */

function RestElement(node, print) {
  this.push("...");
  print.plain(node.argument);
}

/**
 * Alias RestElement printer as SpreadElement,
 * and RestElement printer as SpreadProperty.
 */

exports.SpreadElement = RestElement;
exports.SpreadProperty = RestElement;

/**
 * Prints ObjectExpression, prints properties.
 */

function ObjectExpression(node, print) {
  var props = node.properties;

  this.push("{");
  print.printInnerComments();

  if (props.length) {
    this.space();
    print.list(props, { indent: true });
    this.space();
  }

  this.push("}");
}

/**
 * Alias ObjectExpression printer as ObjectPattern.
 */

exports.ObjectPattern = ObjectExpression;

/**
 * Prints Property, prints decorators, key, and value, handles kind, computed, and shorthand.
 */

function Property(node, print) {
  print.list(node.decorators, { separator: "" });

  if (node.method || node.kind === "get" || node.kind === "set") {
    this._method(node, print);
  } else {
    if (node.computed) {
      this.push("[");
      print.plain(node.key);
      this.push("]");
    } else {
      // print `({ foo: foo = 5 } = {})` as `({ foo = 5 } = {});`
      if (t.isAssignmentPattern(node.value) && t.isIdentifier(node.key) && node.key.name === node.value.left.name) {
        print.plain(node.value);
        return;
      }

      print.plain(node.key);

      // shorthand!
      if (node.shorthand && t.isIdentifier(node.key) && t.isIdentifier(node.value) && node.key.name === node.value.name) {
        return;
      }
    }

    this.push(":");
    this.space();
    print.plain(node.value);
  }
}

/**
 * Prints ArrayExpression, prints elements.
 */

function ArrayExpression(node, print) {
  var elems = node.elements;
  var len = elems.length;

  this.push("[");
  print.printInnerComments();

  for (var i = 0; i < elems.length; i++) {
    var elem = elems[i];
    if (elem) {
      if (i > 0) this.space();
      print.plain(elem);
      if (i < len - 1) this.push(",");
    } else {
      // If the array expression ends with a hole, that hole
      // will be ignored by the interpreter, but if it ends with
      // two (or more) holes, we need to write out two (or more)
      // commas so that the resulting code is interpreted with
      // both (all) of the holes.
      this.push(",");
    }
  }

  this.push("]");
}

/**
 * Alias ArrayExpression printer as ArrayPattern.
 */

exports.ArrayPattern = ArrayExpression;

/**
 * Prints Literal, prints value, regex, raw, handles val type.
 */

function Literal(node) {
  this.push(""); // hack: catch up indentation
  this._push(this._Literal(node));
}

function _Literal(node) {
  var val = node.value;

  if (node.regex) {
    return "/" + node.regex.pattern + "/" + node.regex.flags;
  }

  // just use the raw property if our current value is equivalent to the one we got
  // when we populated raw
  if (node.raw != null && node.rawValue != null && val === node.rawValue) {
    return node.raw;
  }

  switch (typeof val) {
    case "string":
      return this._stringLiteral(val);

    case "number":
      return val + "";

    case "boolean":
      return val ? "true" : "false";

    default:
      if (val === null) {
        return "null";
      } else {
        throw new Error("Invalid Literal type");
      }
  }
}

/**
 * Prints string literals, handles format.
 */

function _stringLiteral(val) {
  val = JSON.stringify(val);

  // escape illegal js but valid json unicode characters
  val = val.replace(/[\u000A\u000D\u2028\u2029]/g, function (c) {
    return "\\u" + ("0000" + c.charCodeAt(0).toString(16)).slice(-4);
  });

  if (this.format.quotes === "single") {
    // remove double quotes
    val = val.slice(1, -1);

    // unescape double quotes
    val = val.replace(/\\"/g, '"');

    // escape single quotes
    val = val.replace(/'/g, "\\'");

    // add single quotes
    val = "'" + val + "'";
  }

  return val;
}
},{"../../types":354}],205:[function(require,module,exports){
"use strict";

// istanbul ignore next

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

// istanbul ignore next

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj["default"] = obj; return newObj; } }

// istanbul ignore next

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

// istanbul ignore next

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var _detectIndent = require("detect-indent");

var _detectIndent2 = _interopRequireDefault(_detectIndent);

var _whitespace = require("./whitespace");

var _whitespace2 = _interopRequireDefault(_whitespace);

var _nodePrinter = require("./node/printer");

var _nodePrinter2 = _interopRequireDefault(_nodePrinter);

var _repeating = require("repeating");

var _repeating2 = _interopRequireDefault(_repeating);

var _sourceMap = require("./source-map");

var _sourceMap2 = _interopRequireDefault(_sourceMap);

var _position = require("./position");

var _position2 = _interopRequireDefault(_position);

var _messages = require("../messages");

var messages = _interopRequireWildcard(_messages);

var _buffer = require("./buffer");

var _buffer2 = _interopRequireDefault(_buffer);

var _lodashObjectExtend = require("lodash/object/extend");

var _lodashObjectExtend2 = _interopRequireDefault(_lodashObjectExtend);

var _lodashCollectionEach = require("lodash/collection/each");

var _lodashCollectionEach2 = _interopRequireDefault(_lodashCollectionEach);

var _node2 = require("./node");

var _node3 = _interopRequireDefault(_node2);

var _types = require("../types");

var t = _interopRequireWildcard(_types);

/**
 * Babel's code generator, turns an ast into code, maintaining sourcemaps,
 * user preferences, and valid output.
 */

var CodeGenerator = (function () {
  function CodeGenerator(ast, opts, code) {
    _classCallCheck(this, CodeGenerator);

    opts = opts || {};

    this.comments = ast.comments || [];
    this.tokens = ast.tokens || [];
    this.format = CodeGenerator.normalizeOptions(code, opts, this.tokens);
    this.opts = opts;
    this.ast = ast;

    this.whitespace = new _whitespace2["default"](this.tokens);
    this.position = new _position2["default"]();
    this.map = new _sourceMap2["default"](this.position, opts, code);
    this.buffer = new _buffer2["default"](this.position, this.format);
  }

  /**
   * [Please add a description.]
   */

  /**
   * Normalize generator options, setting defaults.
   *
   * - Detects code indentation.
   * - If `opts.compact = "auto"` and the code is over 100KB, `compact` will be set to `true`.
   */

  CodeGenerator.normalizeOptions = function normalizeOptions(code, opts, tokens) {
    var style = "  ";
    if (code) {
      var indent = _detectIndent2["default"](code).indent;
      if (indent && indent !== " ") style = indent;
    }

    var format = {
      shouldPrintComment: opts.shouldPrintComment,
      retainLines: opts.retainLines,
      comments: opts.comments == null || opts.comments,
      compact: opts.compact,
      quotes: CodeGenerator.findCommonStringDelimiter(code, tokens),
      indent: {
        adjustMultilineComment: true,
        style: style,
        base: 0
      }
    };

    if (format.compact === "auto") {
      format.compact = code.length > 100000; // 100KB

      if (format.compact) {
        console.error("[BABEL] " + messages.get("codeGeneratorDeopt", opts.filename, "100KB"));
      }
    }

    if (format.compact) {
      format.indent.adjustMultilineComment = false;
    }

    return format;
  };

  /**
   * Determine if input code uses more single or double quotes.
   */

  CodeGenerator.findCommonStringDelimiter = function findCommonStringDelimiter(code, tokens) {
    var occurences = {
      single: 0,
      double: 0
    };

    var checked = 0;

    for (var i = 0; i < tokens.length; i++) {
      var token = tokens[i];
      if (token.type.label !== "string") continue;

      var raw = code.slice(token.start, token.end);
      if (raw[0] === "'") {
        occurences.single++;
      } else {
        occurences.double++;
      }

      checked++;
      if (checked >= 3) break;
    }
    if (occurences.single > occurences.double) {
      return "single";
    } else {
      return "double";
    }
  };

  /**
   * All node generators.
   */

  /**
   * Generate code and sourcemap from ast.
   *
   * Appends comments that weren't attached to any node to the end of the generated output.
   */

  CodeGenerator.prototype.generate = function generate() {
    var ast = this.ast;

    this.print(ast);

    if (ast.comments) {
      var comments = [];
      var _arr = ast.comments;
      for (var _i = 0; _i < _arr.length; _i++) {
        var comment = _arr[_i];
        if (!comment._displayed) comments.push(comment);
      }
      this._printComments(comments);
    }

    return {
      map: this.map.get(),
      code: this.buffer.get()
    };
  };

  /**
   * Build NodePrinter.
   */

  CodeGenerator.prototype.buildPrint = function buildPrint(parent) {
    return new _nodePrinter2["default"](this, parent);
  };

  /**
   * [Please add a description.]
   */

  CodeGenerator.prototype.catchUp = function catchUp(node) {
    // catch up to this nodes newline if we're behind
    if (node.loc && this.format.retainLines && this.buffer.buf) {
      while (this.position.line < node.loc.start.line) {
        this._push("\n");
      }
    }
  };

  /**
   * [Please add a description.]
   */

  CodeGenerator.prototype._printNewline = function _printNewline(leading, node, parent, opts) {
    if (!opts.statement && !_node3["default"].isUserWhitespacable(node, parent)) {
      return;
    }

    var lines = 0;

    if (node.start != null && !node._ignoreUserWhitespace) {
      // user node
      if (leading) {
        lines = this.whitespace.getNewlinesBefore(node);
      } else {
        lines = this.whitespace.getNewlinesAfter(node);
      }
    } else {
      // generated node
      if (!leading) lines++; // always include at least a single line after
      if (opts.addNewlines) lines += opts.addNewlines(leading, node) || 0;

      var needs = _node3["default"].needsWhitespaceAfter;
      if (leading) needs = _node3["default"].needsWhitespaceBefore;
      if (needs(node, parent)) lines++;

      // generated nodes can't add starting file whitespace
      if (!this.buffer.buf) lines = 0;
    }

    this.newline(lines);
  };

  /**
   * [Please add a description.]
   */

  CodeGenerator.prototype.print = function print(node, parent) {
    var opts = arguments.length <= 2 || arguments[2] === undefined ? {} : arguments[2];

    if (!node) return;

    if (parent && parent._compact) {
      node._compact = true;
    }

    var oldConcise = this.format.concise;
    if (node._compact) {
      this.format.concise = true;
    }

    if (!this[node.type]) {
      throw new ReferenceError("unknown node of type " + JSON.stringify(node.type) + " with constructor " + JSON.stringify(node && node.constructor.name));
    }

    var needsParens = _node3["default"].needsParens(node, parent);
    if (needsParens) this.push("(");

    this.printLeadingComments(node, parent);

    this.catchUp(node);

    this._printNewline(true, node, parent, opts);

    if (opts.before) opts.before();
    this.map.mark(node, "start");

    this[node.type](node, this.buildPrint(node), parent);

    if (needsParens) this.push(")");

    this.map.mark(node, "end");
    if (opts.after) opts.after();

    this.format.concise = oldConcise;

    this._printNewline(false, node, parent, opts);

    this.printTrailingComments(node, parent);
  };

  /**
   * [Please add a description.]
   */

  CodeGenerator.prototype.printJoin = function printJoin(print, nodes) {
    // istanbul ignore next

    var _this = this;

    var opts = arguments.length <= 2 || arguments[2] === undefined ? {} : arguments[2];

    if (!nodes || !nodes.length) return;

    var len = nodes.length;

    if (opts.indent) this.indent();

    var printOpts = {
      statement: opts.statement,
      addNewlines: opts.addNewlines,
      after: function after() {
        if (opts.iterator) {
          opts.iterator(node, i);
        }

        if (opts.separator && i < len - 1) {
          _this.push(opts.separator);
        }
      }
    };

    for (var i = 0; i < nodes.length; i++) {
      var node = nodes[i];
      print.plain(node, printOpts);
    }

    if (opts.indent) this.dedent();
  };

  /**
   * [Please add a description.]
   */

  CodeGenerator.prototype.printAndIndentOnComments = function printAndIndentOnComments(print, node) {
    var indent = !!node.leadingComments;
    if (indent) this.indent();
    print.plain(node);
    if (indent) this.dedent();
  };

  /**
   * [Please add a description.]
   */

  CodeGenerator.prototype.printBlock = function printBlock(print, node) {
    if (t.isEmptyStatement(node)) {
      this.semicolon();
    } else {
      this.push(" ");
      print.plain(node);
    }
  };

  /**
   * [Please add a description.]
   */

  CodeGenerator.prototype.generateComment = function generateComment(comment) {
    var val = comment.value;
    if (comment.type === "CommentLine") {
      val = "//" + val;
    } else {
      val = "/*" + val + "*/";
    }
    return val;
  };

  /**
   * [Please add a description.]
   */

  CodeGenerator.prototype.printTrailingComments = function printTrailingComments(node, parent) {
    this._printComments(this.getComments("trailingComments", node, parent));
  };

  /**
   * [Please add a description.]
   */

  CodeGenerator.prototype.printLeadingComments = function printLeadingComments(node, parent) {
    this._printComments(this.getComments("leadingComments", node, parent));
  };

  /**
   * [Please add a description.]
   */

  CodeGenerator.prototype.getComments = function getComments(key, node, parent) {
    if (t.isExpressionStatement(parent)) {
      return [];
    }

    var comments = [];
    var nodes = [node];

    if (t.isExpressionStatement(node)) {
      nodes.push(node.argument);
    }

    var _arr2 = nodes;
    for (var _i2 = 0; _i2 < _arr2.length; _i2++) {
      var _node = _arr2[_i2];
      comments = comments.concat(this._getComments(key, _node));
    }

    return comments;
  };

  /**
   * [Please add a description.]
   */

  CodeGenerator.prototype._getComments = function _getComments(key, node) {
    return node && node[key] || [];
  };

  /**
   * [Please add a description.]
   */

  CodeGenerator.prototype.shouldPrintComment = function shouldPrintComment(comment) {
    if (this.format.shouldPrintComment) {
      return this.format.shouldPrintComment(comment.value);
    } else {
      if (comment.value.indexOf("@license") >= 0 || comment.value.indexOf("@preserve") >= 0) {
        return true;
      } else {
        return this.format.comments;
      }
    }
  };

  /**
   * [Please add a description.]
   */

  CodeGenerator.prototype._printComments = function _printComments(comments) {
    if (!comments || !comments.length) return;

    var _arr3 = comments;
    for (var _i3 = 0; _i3 < _arr3.length; _i3++) {
      var comment = _arr3[_i3];
      if (!this.shouldPrintComment(comment)) continue;
      if (comment._displayed) continue;
      comment._displayed = true;

      this.catchUp(comment);

      // whitespace before
      this.newline(this.whitespace.getNewlinesBefore(comment));

      var column = this.position.column;
      var val = this.generateComment(comment);

      if (column && !this.isLast(["\n", " ", "[", "{"])) {
        this._push(" ");
        column++;
      }

      //
      if (comment.type === "CommentBlock" && this.format.indent.adjustMultilineComment) {
        var offset = comment.loc && comment.loc.start.column;
        if (offset) {
          var newlineRegex = new RegExp("\\n\\s{1," + offset + "}", "g");
          val = val.replace(newlineRegex, "\n");
        }

        var indent = Math.max(this.indentSize(), column);
        val = val.replace(/\n/g, "\n" + _repeating2["default"](" ", indent));
      }

      if (column === 0) {
        val = this.getIndent() + val;
      }

      // force a newline for line comments when retainLines is set in case the next printed node
      // doesn't catch up
      if ((this.format.compact || this.format.retainLines) && comment.type === "CommentLine") {
        val += "\n";
      }

      //
      this._push(val);

      // whitespace after
      this.newline(this.whitespace.getNewlinesAfter(comment));
    }
  };

  _createClass(CodeGenerator, null, [{
    key: "generators",
    value: {
      templateLiterals: require("./generators/template-literals"),
      comprehensions: require("./generators/comprehensions"),
      expressions: require("./generators/expressions"),
      statements: require("./generators/statements"),
      classes: require("./generators/classes"),
      methods: require("./generators/methods"),
      modules: require("./generators/modules"),
      types: require("./generators/types"),
      flow: require("./generators/flow"),
      base: require("./generators/base"),
      jsx: require("./generators/jsx")
    },
    enumerable: true
  }]);

  return CodeGenerator;
})();

_lodashCollectionEach2["default"](_buffer2["default"].prototype, function (fn, key) {
  CodeGenerator.prototype[key] = function () {
    return fn.apply(this.buffer, arguments);
  };
});

/**
 * [Please add a description.]
 */

_lodashCollectionEach2["default"](CodeGenerator.generators, function (generator) {
  _lodashObjectExtend2["default"](CodeGenerator.prototype, generator);
});

/**
 * [Please add a description.]
 */

module.exports = function (ast, opts, code) {
  var gen = new CodeGenerator(ast, opts, code);
  return gen.generate();
};

module.exports.CodeGenerator = CodeGenerator;
},{"../messages":218,"../types":354,"./buffer":193,"./generators/base":194,"./generators/classes":195,"./generators/comprehensions":196,"./generators/expressions":197,"./generators/flow":198,"./generators/jsx":199,"./generators/methods":200,"./generators/modules":201,"./generators/statements":202,"./generators/template-literals":203,"./generators/types":204,"./node":206,"./node/printer":208,"./position":210,"./source-map":211,"./whitespace":212,"detect-indent":617,"lodash/collection/each":753,"lodash/object/extend":854,"repeating":904}],206:[function(require,module,exports){
"use strict";

exports.__esModule = true;
// istanbul ignore next

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj["default"] = obj; return newObj; } }

// istanbul ignore next

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

// istanbul ignore next

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var _whitespace = require("./whitespace");

var _whitespace2 = _interopRequireDefault(_whitespace);

var _parentheses = require("./parentheses");

var parens = _interopRequireWildcard(_parentheses);

var _lodashCollectionEach = require("lodash/collection/each");

var _lodashCollectionEach2 = _interopRequireDefault(_lodashCollectionEach);

var _lodashCollectionSome = require("lodash/collection/some");

var _lodashCollectionSome2 = _interopRequireDefault(_lodashCollectionSome);

var _types = require("../../types");

var t = _interopRequireWildcard(_types);

/**
 * Test if node matches a set of type-matcher pairs.
 * @example
 * find({
 *   VariableDeclaration(node, parent) {
 *     return true;
 *   }
 * }, node, parent);
 */

var find = function find(obj, node, parent) {
  if (!obj) return;
  var result;

  var types = Object.keys(obj);
  for (var i = 0; i < types.length; i++) {
    var type = types[i];

    if (t.is(type, node)) {
      var fn = obj[type];
      result = fn(node, parent);
      if (result != null) break;
    }
  }

  return result;
};

/**
 * Whitespace and Parenthesis related methods for nodes.
 */

var Node = (function () {
  function Node(node, parent) {
    _classCallCheck(this, Node);

    this.parent = parent;
    this.node = node;
  }

  /**
   * Add all static methods from `Node` to `Node.prototype`.
   */

  /**
   * Test if `node` can have whitespace set by the user.
   */

  Node.isUserWhitespacable = function isUserWhitespacable(node) {
    return t.isUserWhitespacable(node);
  };

  /**
   * Test if a `node` requires whitespace.
   */

  Node.needsWhitespace = function needsWhitespace(node, parent, type) {
    if (!node) return 0;

    if (t.isExpressionStatement(node)) {
      node = node.expression;
    }

    var linesInfo = find(_whitespace2["default"].nodes, node, parent);

    if (!linesInfo) {
      var items = find(_whitespace2["default"].list, node, parent);
      if (items) {
        for (var i = 0; i < items.length; i++) {
          linesInfo = Node.needsWhitespace(items[i], node, type);
          if (linesInfo) break;
        }
      }
    }

    return linesInfo && linesInfo[type] || 0;
  };

  /**
   * Test if a `node` requires whitespace before it.
   */

  Node.needsWhitespaceBefore = function needsWhitespaceBefore(node, parent) {
    return Node.needsWhitespace(node, parent, "before");
  };

  /**
   * Test if a `note` requires whitespace after it.
   */

  Node.needsWhitespaceAfter = function needsWhitespaceAfter(node, parent) {
    return Node.needsWhitespace(node, parent, "after");
  };

  /**
   * Test if a `node` needs parentheses around it.
   */

  Node.needsParens = function needsParens(node, parent) {
    if (!parent) return false;

    if (t.isNewExpression(parent) && parent.callee === node) {
      if (t.isCallExpression(node)) return true;

      var hasCall = _lodashCollectionSome2["default"](node, function (val) {
        return t.isCallExpression(val);
      });
      if (hasCall) return true;
    }

    return find(parens, node, parent);
  };

  return Node;
})();

exports["default"] = Node;
_lodashCollectionEach2["default"](Node, function (fn, key) {
  Node.prototype[key] = function () {
    // Avoid leaking arguments to prevent deoptimization
    var args = new Array(arguments.length + 2);

    args[0] = this.node;
    args[1] = this.parent;

    for (var i = 0; i < args.length; i++) {
      args[i + 2] = arguments[i];
    }

    return Node[key].apply(null, args);
  };
});
module.exports = exports["default"];
},{"../../types":354,"./parentheses":207,"./whitespace":209,"lodash/collection/each":753,"lodash/collection/some":758}],207:[function(require,module,exports){
"use strict";

exports.__esModule = true;
exports.NullableTypeAnnotation = NullableTypeAnnotation;
exports.UpdateExpression = UpdateExpression;
exports.ObjectExpression = ObjectExpression;
exports.Binary = Binary;
exports.BinaryExpression = BinaryExpression;
exports.SequenceExpression = SequenceExpression;
exports.YieldExpression = YieldExpression;
exports.ClassExpression = ClassExpression;
exports.UnaryLike = UnaryLike;
exports.FunctionExpression = FunctionExpression;
exports.ConditionalExpression = ConditionalExpression;
exports.AssignmentExpression = AssignmentExpression;
// istanbul ignore next

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj["default"] = obj; return newObj; } }

// istanbul ignore next

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

var _lodashCollectionEach = require("lodash/collection/each");

var _lodashCollectionEach2 = _interopRequireDefault(_lodashCollectionEach);

var _types = require("../../types");

var t = _interopRequireWildcard(_types);

/**
 * Create a mapping of operators to precendence.
 *
 * @example
 * { "==": 6, "+": 9 }
 */
var PRECEDENCE = {};

_lodashCollectionEach2["default"]([["||"], ["&&"], ["|"], ["^"], ["&"], ["==", "===", "!=", "!=="], ["<", ">", "<=", ">=", "in", "instanceof"], [">>", "<<", ">>>"], ["+", "-"], ["*", "/", "%"], ["**"]], function (tier, i) {
  _lodashCollectionEach2["default"](tier, function (op) {
    PRECEDENCE[op] = i;
  });
});

/**
 * Test if NullableTypeAnnotation needs parentheses.
 */

function NullableTypeAnnotation(node, parent) {
  return t.isArrayTypeAnnotation(parent);
}

/**
 * Alias NullableTypeAnnotation test as FunctionTypeAnnotation.
 */

exports.FunctionTypeAnnotation = NullableTypeAnnotation;

/**
 * Test if UpdateExpression needs parentheses.
 */

function UpdateExpression(node, parent) {
  if (t.isMemberExpression(parent) && parent.object === node) {
    // (foo++).test()
    return true;
  }
}

/**
 * Test if ObjectExpression needs parentheses.
 */

function ObjectExpression(node, parent) {
  if (t.isExpressionStatement(parent)) {
    // ({ foo: "bar" });
    return true;
  }

  if (t.isMemberExpression(parent) && parent.object === node) {
    // ({ foo: "bar" }).foo
    return true;
  }

  return false;
}

/**
 * Test if Binary needs parentheses.
 */

function Binary(node, parent) {
  if ((t.isCallExpression(parent) || t.isNewExpression(parent)) && parent.callee === node) {
    return true;
  }

  if (t.isUnaryLike(parent)) {
    return true;
  }

  if (t.isMemberExpression(parent) && parent.object === node) {
    return true;
  }

  if (t.isBinary(parent)) {
    var parentOp = parent.operator;
    var parentPos = PRECEDENCE[parentOp];

    var nodeOp = node.operator;
    var nodePos = PRECEDENCE[nodeOp];

    if (parentPos > nodePos) {
      return true;
    }

    // Logical expressions with the same precedence don't need parens.
    if (parentPos === nodePos && parent.right === node && !t.isLogicalExpression(parent)) {
      return true;
    }
  }
}

/**
 * Test if BinaryExpression needs parentheses.
 */

function BinaryExpression(node, parent) {
  if (node.operator === "in") {
    // var i = (1 in []);
    if (t.isVariableDeclarator(parent)) {
      return true;
    }

    // for ((1 in []);;);
    if (t.isFor(parent)) {
      return true;
    }
  }
}

/**
 * Test if SequenceExpression needs parentheses.
 */

function SequenceExpression(node, parent) {
  if (t.isForStatement(parent)) {
    // Although parentheses wouldn't hurt around sequence
    // expressions in the head of for loops, traditional style
    // dictates that e.g. i++, j++ should not be wrapped with
    // parentheses.
    return false;
  }

  if (t.isExpressionStatement(parent) && parent.expression === node) {
    return false;
  }

  if (t.isReturnStatement(parent)) {
    return false;
  }

  // Otherwise err on the side of overparenthesization, adding
  // explicit exceptions above if this proves overzealous.
  return true;
}

/**
 * Test if YieldExpression needs parentheses.
 */

function YieldExpression(node, parent) {
  return t.isBinary(parent) || t.isUnaryLike(parent) || t.isCallExpression(parent) || t.isMemberExpression(parent) || t.isNewExpression(parent) || t.isConditionalExpression(parent) || t.isYieldExpression(parent);
}

/**
 * Test if ClassExpression needs parentheses.
 */

function ClassExpression(node, parent) {
  return t.isExpressionStatement(parent);
}

/**
 * Test if UnaryLike needs parentheses.
 */

function UnaryLike(node, parent) {
  return t.isMemberExpression(parent) && parent.object === node;
}

/**
 * Test if FunctionExpression needs parentheses.
 */

function FunctionExpression(node, parent) {
  // function () {};
  if (t.isExpressionStatement(parent)) {
    return true;
  }

  // (function test() {}).name;
  if (t.isMemberExpression(parent) && parent.object === node) {
    return true;
  }

  // (function () {})();
  if (t.isCallExpression(parent) && parent.callee === node) {
    return true;
  }
}

/**
 * Test if ConditionalExpression needs parentheses.
 */

function ConditionalExpression(node, parent) {
  if (t.isUnaryLike(parent)) {
    return true;
  }

  if (t.isBinary(parent)) {
    return true;
  }

  if (t.isCallExpression(parent) || t.isNewExpression(parent)) {
    if (parent.callee === node) {
      return true;
    }
  }

  if (t.isConditionalExpression(parent) && parent.test === node) {
    return true;
  }

  if (t.isMemberExpression(parent) && parent.object === node) {
    return true;
  }

  return false;
}

/**
 * Test if AssignmentExpression needs parentheses.
 */

function AssignmentExpression(node) {
  if (t.isObjectPattern(node.left)) {
    return true;
  } else {
    return ConditionalExpression.apply(undefined, arguments);
  }
}
},{"../../types":354,"lodash/collection/each":753}],208:[function(require,module,exports){
/**
 * Printer for nodes, needs a `generator` and a `parent`.
 */

"use strict";

exports.__esModule = true;
// istanbul ignore next

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var NodePrinter = (function () {
  function NodePrinter(generator, parent) {
    _classCallCheck(this, NodePrinter);

    this.generator = generator;
    this.parent = parent;
  }

  /**
   * Description
   */

  NodePrinter.prototype.printInnerComments = function printInnerComments() {
    if (!this.parent.innerComments) return;
    var gen = this.generator;
    gen.indent();
    gen._printComments(this.parent.innerComments);
    gen.dedent();
  };

  /**
   * Print a plain node.
   */

  NodePrinter.prototype.plain = function plain(node, opts) {
    return this.generator.print(node, this.parent, opts);
  };

  /**
   * Print a sequence of nodes as statements.
   */

  NodePrinter.prototype.sequence = function sequence(nodes) {
    var opts = arguments.length <= 1 || arguments[1] === undefined ? {} : arguments[1];

    opts.statement = true;
    return this.generator.printJoin(this, nodes, opts);
  };

  /**
   * Print a sequence of nodes as expressions.
   */

  NodePrinter.prototype.join = function join(nodes, opts) {
    return this.generator.printJoin(this, nodes, opts);
  };

  /**
   * Print a list of nodes, with a customizable separator (defaults to ",").
   */

  NodePrinter.prototype.list = function list(items) {
    var opts = arguments.length <= 1 || arguments[1] === undefined ? {} : arguments[1];

    if (opts.separator == null) {
      opts.separator = ",";
      if (!this.generator.format.compact) opts.separator += " ";
    }

    return this.join(items, opts);
  };

  /**
   * Print a block-like node.
   */

  NodePrinter.prototype.block = function block(node) {
    return this.generator.printBlock(this, node);
  };

  /**
   * Print node and indent comments.
   */

  NodePrinter.prototype.indentOnComments = function indentOnComments(node) {
    return this.generator.printAndIndentOnComments(this, node);
  };

  return NodePrinter;
})();

exports["default"] = NodePrinter;
module.exports = exports["default"];
},{}],209:[function(require,module,exports){
"use strict";

// istanbul ignore next

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj["default"] = obj; return newObj; } }

// istanbul ignore next

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

var _lodashLangIsBoolean = require("lodash/lang/isBoolean");

var _lodashLangIsBoolean2 = _interopRequireDefault(_lodashLangIsBoolean);

var _lodashCollectionEach = require("lodash/collection/each");

var _lodashCollectionEach2 = _interopRequireDefault(_lodashCollectionEach);

var _lodashCollectionMap = require("lodash/collection/map");

var _lodashCollectionMap2 = _interopRequireDefault(_lodashCollectionMap);

var _types = require("../../types");

var t = _interopRequireWildcard(_types);

/**
 * Crawl a node to test if it contains a CallExpression, a Function, or a Helper.
 *
 * @example
 * crawl(node)
 * // { hasCall: false, hasFunction: true, hasHelper: false }
 */

function crawl(node) {
  var state = arguments.length <= 1 || arguments[1] === undefined ? {} : arguments[1];

  if (t.isMemberExpression(node)) {
    crawl(node.object, state);
    if (node.computed) crawl(node.property, state);
  } else if (t.isBinary(node) || t.isAssignmentExpression(node)) {
    crawl(node.left, state);
    crawl(node.right, state);
  } else if (t.isCallExpression(node)) {
    state.hasCall = true;
    crawl(node.callee, state);
  } else if (t.isFunction(node)) {
    state.hasFunction = true;
  } else if (t.isIdentifier(node)) {
    state.hasHelper = state.hasHelper || isHelper(node.callee);
  }

  return state;
}

/**
 * Test if a node is or has a helper.
 */

function isHelper(node) {
  if (t.isMemberExpression(node)) {
    return isHelper(node.object) || isHelper(node.property);
  } else if (t.isIdentifier(node)) {
    return node.name === "require" || node.name[0] === "_";
  } else if (t.isCallExpression(node)) {
    return isHelper(node.callee);
  } else if (t.isBinary(node) || t.isAssignmentExpression(node)) {
    return t.isIdentifier(node.left) && isHelper(node.left) || isHelper(node.right);
  } else {
    return false;
  }
}

/**
 * [Please add a description.]
 */

function isType(node) {
  return t.isLiteral(node) || t.isObjectExpression(node) || t.isArrayExpression(node) || t.isIdentifier(node) || t.isMemberExpression(node);
}

/**
 * Tests for node types that need whitespace.
 */

exports.nodes = {

  /**
   * Test if AssignmentExpression needs whitespace.
   */

  AssignmentExpression: function AssignmentExpression(node) {
    var state = crawl(node.right);
    if (state.hasCall && state.hasHelper || state.hasFunction) {
      return {
        before: state.hasFunction,
        after: true
      };
    }
  },

  /**
   * Test if SwitchCase needs whitespace.
   */

  SwitchCase: function SwitchCase(node, parent) {
    return {
      before: node.consequent.length || parent.cases[0] === node
    };
  },

  /**
   * Test if LogicalExpression needs whitespace.
   */

  LogicalExpression: function LogicalExpression(node) {
    if (t.isFunction(node.left) || t.isFunction(node.right)) {
      return {
        after: true
      };
    }
  },

  /**
   * Test if Literal needs whitespace.
   */

  Literal: function Literal(node) {
    if (node.value === "use strict") {
      return {
        after: true
      };
    }
  },

  /**
   * Test if CallExpression needs whitespace.
   */

  CallExpression: function CallExpression(node) {
    if (t.isFunction(node.callee) || isHelper(node)) {
      return {
        before: true,
        after: true
      };
    }
  },

  /**
   * Test if VariableDeclaration needs whitespace.
   */

  VariableDeclaration: function VariableDeclaration(node) {
    for (var i = 0; i < node.declarations.length; i++) {
      var declar = node.declarations[i];

      var enabled = isHelper(declar.id) && !isType(declar.init);
      if (!enabled) {
        var state = crawl(declar.init);
        enabled = isHelper(declar.init) && state.hasCall || state.hasFunction;
      }

      if (enabled) {
        return {
          before: true,
          after: true
        };
      }
    }
  },

  /**
   * Test if IfStatement needs whitespace.
   */

  IfStatement: function IfStatement(node) {
    if (t.isBlockStatement(node.consequent)) {
      return {
        before: true,
        after: true
      };
    }
  }
};

/**
 * Test if Property or SpreadProperty needs whitespace.
 */

exports.nodes.Property = exports.nodes.SpreadProperty = function (node, parent) {
  if (parent.properties[0] === node) {
    return {
      before: true
    };
  }
};

/**
 * Returns lists from node types that need whitespace.
 */

exports.list = {

  /**
   * Return VariableDeclaration declarations init properties.
   */

  VariableDeclaration: function VariableDeclaration(node) {
    return _lodashCollectionMap2["default"](node.declarations, "init");
  },

  /**
   * Return VariableDeclaration elements.
   */

  ArrayExpression: function ArrayExpression(node) {
    return node.elements;
  },

  /**
   * Return VariableDeclaration properties.
   */

  ObjectExpression: function ObjectExpression(node) {
    return node.properties;
  }
};

/**
 * Add whitespace tests for nodes and their aliases.
 */

_lodashCollectionEach2["default"]({
  Function: true,
  Class: true,
  Loop: true,
  LabeledStatement: true,
  SwitchStatement: true,
  TryStatement: true
}, function (amounts, type) {
  if (_lodashLangIsBoolean2["default"](amounts)) {
    amounts = { after: amounts, before: amounts };
  }

  _lodashCollectionEach2["default"]([type].concat(t.FLIPPED_ALIAS_KEYS[type] || []), function (type) {
    exports.nodes[type] = function () {
      return amounts;
    };
  });
});
},{"../../types":354,"lodash/collection/each":753,"lodash/collection/map":756,"lodash/lang/isBoolean":841}],210:[function(require,module,exports){
/**
 * Track current position in code generation.
 */

"use strict";

exports.__esModule = true;
// istanbul ignore next

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var Position = (function () {
  function Position() {
    _classCallCheck(this, Position);

    this.line = 1;
    this.column = 0;
  }

  /**
   * Push a string to the current position, mantaining the current line and column.
   */

  Position.prototype.push = function push(str) {
    for (var i = 0; i < str.length; i++) {
      if (str[i] === "\n") {
        this.line++;
        this.column = 0;
      } else {
        this.column++;
      }
    }
  };

  /**
   * Unshift a string from the current position, mantaining the current line and column.
   */

  Position.prototype.unshift = function unshift(str) {
    for (var i = 0; i < str.length; i++) {
      if (str[i] === "\n") {
        this.line--;
      } else {
        this.column--;
      }
    }
  };

  return Position;
})();

exports["default"] = Position;
module.exports = exports["default"];
},{}],211:[function(require,module,exports){
"use strict";

exports.__esModule = true;
// istanbul ignore next

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj["default"] = obj; return newObj; } }

// istanbul ignore next

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

// istanbul ignore next

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var _sourceMap = require("source-map");

var _sourceMap2 = _interopRequireDefault(_sourceMap);

var _types = require("../types");

var t = _interopRequireWildcard(_types);

/**
 * Build a sourcemap.
 */

var SourceMap = (function () {
  function SourceMap(position, opts, code) {
    _classCallCheck(this, SourceMap);

    this.position = position;
    this.opts = opts;

    if (opts.sourceMaps) {
      this.map = new _sourceMap2["default"].SourceMapGenerator({
        file: opts.sourceMapTarget,
        sourceRoot: opts.sourceRoot
      });

      this.map.setSourceContent(opts.sourceFileName, code);
    } else {
      this.map = null;
    }
  }

  /**
   * Get the sourcemap.
   */

  SourceMap.prototype.get = function get() {
    var map = this.map;
    if (map) {
      return map.toJSON();
    } else {
      return map;
    }
  };

  /**
   * Mark a node's generated position, and add it to the sourcemap.
   */

  SourceMap.prototype.mark = function mark(node, type) {
    var loc = node.loc;
    if (!loc) return; // no location info

    var map = this.map;
    if (!map) return; // no source map

    if (t.isProgram(node) || t.isFile(node)) return; // illegal mapping nodes

    var position = this.position;

    var generated = {
      line: position.line,
      column: position.column
    };

    var original = loc[type];

    map.addMapping({
      source: this.opts.sourceFileName,
      generated: generated,
      original: original
    });
  };

  return SourceMap;
})();

exports["default"] = SourceMap;
module.exports = exports["default"];
},{"../types":354,"source-map":921}],212:[function(require,module,exports){
/**
 * Returns `i`th number from `base`, continuing from 0 when `max` is reached.
 * Useful for shifting `for` loop by a fixed number but going over all items.
 *
 * @param {Number} i Current index in the loop
 * @param {Number} base Start index for which to return 0
 * @param {Number} max Array length
 * @returns {Number} shiftedIndex
 */

"use strict";

exports.__esModule = true;
// istanbul ignore next

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function getLookupIndex(i, base, max) {
  i += base;

  if (i >= max) {
    i -= max;
  }

  return i;
}

/**
 * Get whitespace around tokens.
 */

var Whitespace = (function () {
  function Whitespace(tokens) {
    _classCallCheck(this, Whitespace);

    this.tokens = tokens;
    this.used = {};

    // Profiling this code shows that while generator passes over it, indexes
    // returned by `getNewlinesBefore` and `getNewlinesAfter` are always increasing.

    // We use this implementation detail for an optimization: instead of always
    // starting to look from `this.tokens[0]`, we will start `for` loops from the
    // previous successful match. We will enumerate all tokens—but the common
    // case will be much faster.

    this._lastFoundIndex = 0;
  }

  /**
   * Count all the newlines before a node.
   */

  Whitespace.prototype.getNewlinesBefore = function getNewlinesBefore(node) {
    var startToken;
    var endToken;
    var tokens = this.tokens;

    for (var j = 0; j < tokens.length; j++) {
      // optimize for forward traversal by shifting for loop index
      var i = getLookupIndex(j, this._lastFoundIndex, this.tokens.length);
      var token = tokens[i];

      // this is the token this node starts with
      if (node.start === token.start) {
        startToken = tokens[i - 1];
        endToken = token;

        this._lastFoundIndex = i;
        break;
      }
    }

    return this.getNewlinesBetween(startToken, endToken);
  };

  /**
   * Count all the newlines after a node.
   */

  Whitespace.prototype.getNewlinesAfter = function getNewlinesAfter(node) {
    var startToken;
    var endToken;
    var tokens = this.tokens;

    for (var j = 0; j < tokens.length; j++) {
      // optimize for forward traversal by shifting for loop index
      var i = getLookupIndex(j, this._lastFoundIndex, this.tokens.length);
      var token = tokens[i];

      // this is the token this node ends with
      if (node.end === token.end) {
        startToken = token;
        endToken = tokens[i + 1];
        if (endToken.type.label === ",") endToken = tokens[i + 2];

        this._lastFoundIndex = i;
        break;
      }
    }

    if (endToken && endToken.type.label === "eof") {
      return 1;
    } else {
      var lines = this.getNewlinesBetween(startToken, endToken);
      if (node.type === "CommentLine" && !lines) {
        // line comment
        return 1;
      } else {
        return lines;
      }
    }
  };

  /**
   * Count all the newlines between two tokens.
   */

  Whitespace.prototype.getNewlinesBetween = function getNewlinesBetween(startToken, endToken) {
    if (!endToken || !endToken.loc) return 0;

    var start = startToken ? startToken.loc.end.line : 1;
    var end = endToken.loc.start.line;
    var lines = 0;

    for (var line = start; line < end; line++) {
      if (typeof this.used[line] === "undefined") {
        this.used[line] = true;
        lines++;
      }
    }

    return lines;
  };

  return Whitespace;
})();

exports["default"] = Whitespace;
module.exports = exports["default"];
},{}],213:[function(require,module,exports){
"use strict";

exports.__esModule = true;
// istanbul ignore next

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

var _lineNumbers = require("line-numbers");

var _lineNumbers2 = _interopRequireDefault(_lineNumbers);

var _repeating = require("repeating");

var _repeating2 = _interopRequireDefault(_repeating);

var _jsTokens = require("js-tokens");

var _jsTokens2 = _interopRequireDefault(_jsTokens);

var _esutils = require("esutils");

var _esutils2 = _interopRequireDefault(_esutils);

var _chalk = require("chalk");

var _chalk2 = _interopRequireDefault(_chalk);

/**
 * Chalk styles for token types.
 */

var defs = {
  string: _chalk2["default"].red,
  punctuator: _chalk2["default"].bold,
  curly: _chalk2["default"].green,
  parens: _chalk2["default"].blue.bold,
  square: _chalk2["default"].yellow,
  keyword: _chalk2["default"].cyan,
  number: _chalk2["default"].magenta,
  regex: _chalk2["default"].magenta,
  comment: _chalk2["default"].grey,
  invalid: _chalk2["default"].inverse
};

/**
 * RegExp to test for newlines in terminal.
 */

var NEWLINE = /\r\n|[\n\r\u2028\u2029]/;

/**
 * Get the type of token, specifying punctuator type.
 */

function getTokenType(match) {
  var token = _jsTokens2["default"].matchToToken(match);
  if (token.type === "name" && _esutils2["default"].keyword.isReservedWordES6(token.value)) {
    return "keyword";
  }

  if (token.type === "punctuator") {
    switch (token.value) {
      case "{":
      case "}":
        return "curly";
      case "(":
      case ")":
        return "parens";
      case "[":
      case "]":
        return "square";
    }
  }

  return token.type;
}

/**
 * Highlight `text`.
 */

function highlight(text) {
  return text.replace(_jsTokens2["default"], function () {
    for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    var type = getTokenType(args);
    var colorize = defs[type];
    if (colorize) {
      return args[0].split(NEWLINE).map(function (str) {
        return colorize(str);
      }).join("\n");
    } else {
      return args[0];
    }
  });
}

/**
 * Create a code frame, adding line numbers, code highlighting, and pointing to a given position.
 */

exports["default"] = function (lines, lineNumber, colNumber) {
  var opts = arguments.length <= 3 || arguments[3] === undefined ? {} : arguments[3];

  colNumber = Math.max(colNumber, 0);

  var highlighted = opts.highlightCode && _chalk2["default"].supportsColor;
  if (highlighted) lines = highlight(lines);

  lines = lines.split(NEWLINE);

  var start = Math.max(lineNumber - 3, 0);
  var end = Math.min(lines.length, lineNumber + 3);

  if (!lineNumber && !colNumber) {
    start = 0;
    end = lines.length;
  }

  var frame = _lineNumbers2["default"](lines.slice(start, end), {
    start: start + 1,
    before: "  ",
    after: " | ",
    transform: function transform(params) {
      if (params.number !== lineNumber) {
        return;
      }

      if (colNumber) {
        params.line += "\n" + params.before + _repeating2["default"](" ", params.width) + params.after + _repeating2["default"](" ", colNumber - 1) + "^";
      }

      params.before = params.before.replace(/^./, ">");
    }
  }).join("\n");

  if (highlighted) {
    return _chalk2["default"].reset(frame);
  } else {
    return frame;
  }
};

module.exports = exports["default"];
},{"chalk":406,"esutils":693,"js-tokens":706,"line-numbers":746,"repeating":904}],214:[function(require,module,exports){
"use strict";

exports.__esModule = true;
// istanbul ignore next

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

var _lodashObjectMerge = require("lodash/object/merge");

var _lodashObjectMerge2 = _interopRequireDefault(_lodashObjectMerge);

/**
 * Merge options.
 */

exports["default"] = function (dest, src) {
  if (!dest || !src) return;

  return _lodashObjectMerge2["default"](dest, src, function (a, b) {
    if (b && Array.isArray(a)) {
      var c = a.slice(0);
      for (var _iterator = b, _isArray = Array.isArray(_iterator), _i = 0, _iterator = _isArray ? _iterator : _iterator[Symbol.iterator]();;) {
        var _ref;

        if (_isArray) {
          if (_i >= _iterator.length) break;
          _ref = _iterator[_i++];
        } else {
          _i = _iterator.next();
          if (_i.done) break;
          _ref = _i.value;
        }

        var v = _ref;

        if (a.indexOf(v) < 0) {
          c.push(v);
        }
      }
      return c;
    }
  });
};

module.exports = exports["default"];
},{"lodash/object/merge":858}],215:[function(require,module,exports){
"use strict";

exports.__esModule = true;
// istanbul ignore next

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj["default"] = obj; return newObj; } }

var _types = require("../types");

var t = _interopRequireWildcard(_types);

/**
 * Normalize an AST.
 *
 * - Wrap `Program` node with a `File` node.
 */

exports["default"] = function (ast, comments, tokens) {
  if (ast && ast.type === "Program") {
    return t.file(ast, comments || [], tokens || []);
  } else {
    throw new Error("Not a valid ast?");
  }
};

module.exports = exports["default"];
},{"../types":354}],216:[function(require,module,exports){
/**
 * Create an object with a `null` prototype.
 */

"use strict";

exports.__esModule = true;

exports["default"] = function () {
  return Object.create(null);
};

module.exports = exports["default"];
},{}],217:[function(require,module,exports){
"use strict";

exports.__esModule = true;
// istanbul ignore next

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj["default"] = obj; return newObj; } }

var _babylon = require("babylon");

var babylon = _interopRequireWildcard(_babylon);

/**
 * Parse `code` with normalized options, collecting tokens and comments.
 */

exports["default"] = function (code) {
  var opts = arguments.length <= 1 || arguments[1] === undefined ? {} : arguments[1];

  var parseOpts = {
    allowImportExportEverywhere: opts.looseModules,
    allowReturnOutsideFunction: opts.looseModules,
    allowHashBang: true,
    ecmaVersion: 6,
    strictMode: opts.strictMode,
    sourceType: opts.sourceType,
    locations: true,
    features: opts.features || {},
    plugins: opts.plugins || {}
  };

  if (opts.nonStandard) {
    parseOpts.plugins.jsx = true;
    parseOpts.plugins.flow = true;
  }

  return babylon.parse(code, parseOpts);
};

module.exports = exports["default"];
},{"babylon":379}],218:[function(require,module,exports){
"use strict";

exports.__esModule = true;
exports.get = get;
exports.parseArgs = parseArgs;
// istanbul ignore next

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj["default"] = obj; return newObj; } }

var _util = require("util");

var util = _interopRequireWildcard(_util);

/**
 * Mapping of messages to be used in Babel.
 * Messages can include $0-style placeholders.
 */

var MESSAGES = {
  tailCallReassignmentDeopt: "Function reference has been reassigned, so it will probably be dereferenced, therefore we can't optimise this with confidence",
  JSXNamespacedTags: "Namespace tags are not supported. ReactJSX is not XML.",
  classesIllegalBareSuper: "Illegal use of bare super",
  classesIllegalSuperCall: "Direct super call is illegal in non-constructor, use super.$1() instead",
  scopeDuplicateDeclaration: "Duplicate declaration $1",
  settersNoRest: "Setters aren't allowed to have a rest",
  noAssignmentsInForHead: "No assignments allowed in for-in/of head",
  expectedMemberExpressionOrIdentifier: "Expected type MemberExpression or Identifier",
  invalidParentForThisNode: "We don't know how to handle this node within the current parent - please open an issue",
  readOnly: "$1 is read-only",
  unknownForHead: "Unknown node type $1 in ForStatement",
  didYouMean: "Did you mean $1?",
  codeGeneratorDeopt: "Note: The code generator has deoptimised the styling of $1 as it exceeds the max of $2.",
  missingTemplatesDirectory: "no templates directory - this is most likely the result of a broken `npm publish`. Please report to https://github.com/babel/babel/issues",
  unsupportedOutputType: "Unsupported output type $1",
  illegalMethodName: "Illegal method name $1",
  lostTrackNodePath: "We lost track of this node's position, likely because the AST was directly manipulated",

  modulesIllegalExportName: "Illegal export $1",
  modulesDuplicateDeclarations: "Duplicate module declarations with the same source but in different scopes",

  undeclaredVariable: "Reference to undeclared variable $1",
  undeclaredVariableType: "Referencing a type alias outside of a type annotation",
  undeclaredVariableSuggestion: "Reference to undeclared variable $1 - did you mean $2?",

  traverseNeedsParent: "You must pass a scope and parentPath unless traversing a Program/File got a $1 node",
  traverseVerifyRootFunction: "You passed `traverse()` a function when it expected a visitor object, are you sure you didn't mean `{ enter: Function }`?",
  traverseVerifyVisitorProperty: "You passed `traverse()` a visitor object with the property $1 that has the invalid property $2",
  traverseVerifyNodeType: "You gave us a visitor for the node type $1 but it's not a valid type",

  pluginIllegalKind: "Illegal kind $1 for plugin $2",
  pluginIllegalPosition: "Illegal position $1 for plugin $2",
  pluginKeyCollision: "The plugin $1 collides with another of the same name",
  pluginNotTransformer: "The plugin $1 didn't export a Plugin instance",
  pluginUnknown: "Unknown plugin $1",

  pluginNotFile: "Plugin $1 is resolving to a different Babel version than what is performing the transformation.",

  pluginInvalidProperty: "Plugin $1 provided an invalid property of $2.",
  pluginInvalidPropertyVisitor: "Define your visitor methods inside a `visitor` property like so:\n\n  new Plugin(\"foobar\", {\n    visitor: {\n      // define your visitor methods here!\n    }\n  });\n"
};

exports.MESSAGES = MESSAGES;
/**
 * Get a message with $0 placeholders replaced by arguments.
 */

function get(key) {
  for (var _len = arguments.length, args = Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
    args[_key - 1] = arguments[_key];
  }

  var msg = MESSAGES[key];
  if (!msg) throw new ReferenceError("Unknown message " + JSON.stringify(key));

  // stringify args
  args = parseArgs(args);

  // replace $0 placeholders with args
  return msg.replace(/\$(\d+)/g, function (str, i) {
    return args[--i];
  });
}

/**
 * Stingify arguments to be used inside messages.
 */

function parseArgs(args) {
  return args.map(function (val) {
    if (val != null && val.inspect) {
      return val.inspect();
    } else {
      try {
        return JSON.stringify(val) || val + "";
      } catch (e) {
        return util.inspect(val);
      }
    }
  });
}
},{"util":946}],219:[function(require,module,exports){
(function (global){
"use strict";

require("core-js/shim");

require("regenerator/runtime");

if (global._babelPolyfill) {
  throw new Error("only one instance of babel/polyfill is allowed");
}
global._babelPolyfill = true;
}).call(this,typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : {})
},{"core-js/shim":604,"regenerator/runtime":898}],220:[function(require,module,exports){
"use strict";

exports.__esModule = true;
// istanbul ignore next

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj["default"] = obj; return newObj; } }

// istanbul ignore next

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

var _generation = require("../generation");

var _generation2 = _interopRequireDefault(_generation);

var _messages = require("../messages");

var messages = _interopRequireWildcard(_messages);

var _util = require("../util");

var util = _interopRequireWildcard(_util);

var _transformationFile = require("../transformation/file");

var _transformationFile2 = _interopRequireDefault(_transformationFile);

var _lodashCollectionEach = require("lodash/collection/each");

var _lodashCollectionEach2 = _interopRequireDefault(_lodashCollectionEach);

var _types = require("../types");

var t = _interopRequireWildcard(_types);

/**
 * [Please add a description.]
 */

function buildGlobal(namespace, builder) {
  var body = [];
  var container = t.functionExpression(null, [t.identifier("global")], t.blockStatement(body));
  var tree = t.program([t.expressionStatement(t.callExpression(container, [util.template("helper-self-global")]))]);

  body.push(t.variableDeclaration("var", [t.variableDeclarator(namespace, t.assignmentExpression("=", t.memberExpression(t.identifier("global"), namespace), t.objectExpression([])))]));

  builder(body);

  return tree;
}

/**
 * [Please add a description.]
 */

function buildUmd(namespace, builder) {
  var body = [];
  body.push(t.variableDeclaration("var", [t.variableDeclarator(namespace, t.identifier("global"))]));

  builder(body);

  var container = util.template("umd-commonjs-strict", {
    FACTORY_PARAMETERS: t.identifier("global"),
    BROWSER_ARGUMENTS: t.assignmentExpression("=", t.memberExpression(t.identifier("root"), namespace), t.objectExpression({})),
    COMMON_ARGUMENTS: t.identifier("exports"),
    AMD_ARGUMENTS: t.arrayExpression([t.literal("exports")]),
    FACTORY_BODY: body,
    UMD_ROOT: t.identifier("this")
  });
  return t.program([container]);
}

/**
 * [Please add a description.]
 */

function buildVar(namespace, builder) {
  var body = [];
  body.push(t.variableDeclaration("var", [t.variableDeclarator(namespace, t.objectExpression({}))]));
  builder(body);
  return t.program(body);
}

/**
 * [Please add a description.]
 */

function buildHelpers(body, namespace, whitelist) {
  _lodashCollectionEach2["default"](_transformationFile2["default"].helpers, function (name) {
    if (whitelist && whitelist.indexOf(name) === -1) return;

    var key = t.identifier(t.toIdentifier(name));
    body.push(t.expressionStatement(t.assignmentExpression("=", t.memberExpression(namespace, key), util.template("helper-" + name))));
  });
}

/**
 * [Please add a description.]
 */

exports["default"] = function (whitelist) {
  var outputType = arguments.length <= 1 || arguments[1] === undefined ? "global" : arguments[1];

  var namespace = t.identifier("babelHelpers");

  var builder = function builder(body) {
    return buildHelpers(body, namespace, whitelist);
  };

  var tree;

  var build = ({
    global: buildGlobal,
    umd: buildUmd,
    "var": buildVar
  })[outputType];

  if (build) {
    tree = build(namespace, builder);
  } else {
    throw new Error(messages.get("unsupportedOutputType", outputType));
  }

  return _generation2["default"](tree).code;
};

module.exports = exports["default"];
},{"../generation":205,"../messages":218,"../transformation/file":221,"../types":354,"../util":357,"lodash/collection/each":753}],221:[function(require,module,exports){
(function (process){
"use strict";

exports.__esModule = true;
// istanbul ignore next

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

// istanbul ignore next

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj["default"] = obj; return newObj; } }

// istanbul ignore next

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

// istanbul ignore next

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var _convertSourceMap = require("convert-source-map");

var _convertSourceMap2 = _interopRequireDefault(_convertSourceMap);

var _modules = require("../modules");

var _modules2 = _interopRequireDefault(_modules);

var _optionsOptionManager = require("./options/option-manager");

var _optionsOptionManager2 = _interopRequireDefault(_optionsOptionManager);

var _pluginManager = require("./plugin-manager");

var _pluginManager2 = _interopRequireDefault(_pluginManager);

var _shebangRegex = require("shebang-regex");

var _shebangRegex2 = _interopRequireDefault(_shebangRegex);

var _traversalPath = require("../../traversal/path");

var _traversalPath2 = _interopRequireDefault(_traversalPath);

var _lodashLangIsFunction = require("lodash/lang/isFunction");

var _lodashLangIsFunction2 = _interopRequireDefault(_lodashLangIsFunction);

var _sourceMap = require("source-map");

var _sourceMap2 = _interopRequireDefault(_sourceMap);

var _generation = require("../../generation");

var _generation2 = _interopRequireDefault(_generation);

var _helpersCodeFrame = require("../../helpers/code-frame");

var _helpersCodeFrame2 = _interopRequireDefault(_helpersCodeFrame);

var _lodashObjectDefaults = require("lodash/object/defaults");

var _lodashObjectDefaults2 = _interopRequireDefault(_lodashObjectDefaults);

var _lodashCollectionIncludes = require("lodash/collection/includes");

var _lodashCollectionIncludes2 = _interopRequireDefault(_lodashCollectionIncludes);

var _traversal = require("../../traversal");

var _traversal2 = _interopRequireDefault(_traversal);

var _tryResolve = require("try-resolve");

var _tryResolve2 = _interopRequireDefault(_tryResolve);

var _logger = require("./logger");

var _logger2 = _interopRequireDefault(_logger);

var _plugin = require("../plugin");

var _plugin2 = _interopRequireDefault(_plugin);

var _helpersParse = require("../../helpers/parse");

var _helpersParse2 = _interopRequireDefault(_helpersParse);

var _traversalHub = require("../../traversal/hub");

var _traversalHub2 = _interopRequireDefault(_traversalHub);

var _util = require("../../util");

var util = _interopRequireWildcard(_util);

var _path = require("path");

var _path2 = _interopRequireDefault(_path);

var _types = require("../../types");

var t = _interopRequireWildcard(_types);

/**
 * [Please add a description.]
 */

var File = (function () {
  function File(opts, pipeline) {
    if (opts === undefined) opts = {};

    _classCallCheck(this, File);

    this.transformerDependencies = {};
    this.dynamicImportTypes = {};
    this.dynamicImportIds = {};
    this.dynamicImports = [];
    this.declarations = {};
    this.usedHelpers = {};
    this.dynamicData = {};
    this.data = {};
    this.ast = {};
    this.metadata = {
      modules: {
        imports: [],
        exports: {
          exported: [],
          specifiers: []
        }
      }
    };
    this.hub = new _traversalHub2["default"](this);

    this.pipeline = pipeline;

    this.log = new _logger2["default"](this, opts.filename || "unknown");
    this.opts = this.initOptions(opts);

    this.buildTransformers();
  }

  /**
   * [Please add a description.]
   */

  File.prototype.initOptions = function initOptions(opts) {
    opts = new _optionsOptionManager2["default"](this.log, this.pipeline).init(opts);

    if (opts.inputSourceMap) {
      opts.sourceMaps = true;
    }

    if (opts.moduleId) {
      opts.moduleIds = true;
    }

    opts.basename = _path2["default"].basename(opts.filename, _path2["default"].extname(opts.filename));

    opts.ignore = util.arrayify(opts.ignore, util.regexify);

    if (opts.only) opts.only = util.arrayify(opts.only, util.regexify);

    _lodashObjectDefaults2["default"](opts, {
      moduleRoot: opts.sourceRoot
    });

    _lodashObjectDefaults2["default"](opts, {
      sourceRoot: opts.moduleRoot
    });

    _lodashObjectDefaults2["default"](opts, {
      filenameRelative: opts.filename
    });

    _lodashObjectDefaults2["default"](opts, {
      sourceFileName: opts.filenameRelative,
      sourceMapTarget: opts.filenameRelative
    });

    //

    if (opts.externalHelpers) {
      this.set("helpersNamespace", t.identifier("babelHelpers"));
    }

    return opts;
  };

  /**
   * [Please add a description.]
   */

  File.prototype.isLoose = function isLoose(key) {
    return _lodashCollectionIncludes2["default"](this.opts.loose, key);
  };

  /**
   * [Please add a description.]
   */

  File.prototype.buildTransformers = function buildTransformers() {
    var file = this;

    var transformers = this.transformers = {};

    var secondaryStack = [];
    var stack = [];

    // build internal transformers
    for (var key in this.pipeline.transformers) {
      var transformer = this.pipeline.transformers[key];
      var pass = transformers[key] = transformer.buildPass(file);

      if (pass.canTransform()) {
        stack.push(pass);

        if (transformer.metadata.secondPass) {
          secondaryStack.push(pass);
        }

        if (transformer.manipulateOptions) {
          transformer.manipulateOptions(file.opts, file);
        }
      }
    }

    // init plugins!
    var beforePlugins = [];
    var afterPlugins = [];
    var pluginManager = new _pluginManager2["default"]({
      file: this,
      transformers: this.transformers,
      before: beforePlugins,
      after: afterPlugins
    });
    for (var i = 0; i < file.opts.plugins.length; i++) {
      pluginManager.add(file.opts.plugins[i]);
    }
    stack = beforePlugins.concat(stack, afterPlugins);

    // build transformer stack
    this.uncollapsedTransformerStack = stack = stack.concat(secondaryStack);

    // build dependency graph
    var _arr = stack;
    for (var _i = 0; _i < _arr.length; _i++) {
      var pass = _arr[_i];var _arr2 = pass.plugin.dependencies;

      for (var _i2 = 0; _i2 < _arr2.length; _i2++) {
        var dep = _arr2[_i2];
        this.transformerDependencies[dep] = pass.key;
      }
    }

    // collapse stack categories
    this.transformerStack = this.collapseStack(stack);
  };

  /**
   * [Please add a description.]
   */

  File.prototype.collapseStack = function collapseStack(_stack) {
    var stack = [];
    var ignore = [];

    var _arr3 = _stack;
    for (var _i3 = 0; _i3 < _arr3.length; _i3++) {
      var pass = _arr3[_i3];
      // been merged
      if (ignore.indexOf(pass) >= 0) continue;

      var group = pass.plugin.metadata.group;

      // can't merge
      if (!pass.canTransform() || !group) {
        stack.push(pass);
        continue;
      }

      var mergeStack = [];
      var _arr4 = _stack;
      for (var _i4 = 0; _i4 < _arr4.length; _i4++) {
        var _pass = _arr4[_i4];
        if (_pass.plugin.metadata.group === group) {
          mergeStack.push(_pass);
          ignore.push(_pass);
        }
      }

      var visitors = [];
      var _arr5 = mergeStack;
      for (var _i5 = 0; _i5 < _arr5.length; _i5++) {
        var _pass2 = _arr5[_i5];
        visitors.push(_pass2.plugin.visitor);
      }
      var visitor = _traversal2["default"].visitors.merge(visitors);
      var mergePlugin = new _plugin2["default"](group, { visitor: visitor });
      stack.push(mergePlugin.buildPass(this));
    }

    return stack;
  };

  /**
   * [Please add a description.]
   */

  File.prototype.set = function set(key, val) {
    return this.data[key] = val;
  };

  /**
   * [Please add a description.]
   */

  File.prototype.setDynamic = function setDynamic(key, fn) {
    this.dynamicData[key] = fn;
  };

  /**
   * [Please add a description.]
   */

  File.prototype.get = function get(key) {
    var data = this.data[key];
    if (data) {
      return data;
    } else {
      var dynamic = this.dynamicData[key];
      if (dynamic) {
        return this.set(key, dynamic());
      }
    }
  };

  /**
   * [Please add a description.]
   */

  File.prototype.resolveModuleSource = function resolveModuleSource(source) {
    var resolveModuleSource = this.opts.resolveModuleSource;
    if (resolveModuleSource) source = resolveModuleSource(source, this.opts.filename);
    return source;
  };

  /**
   * [Please add a description.]
   */

  File.prototype.addImport = function addImport(source, name, type) {
    name = name || source;
    var id = this.dynamicImportIds[name];

    if (!id) {
      source = this.resolveModuleSource(source);
      id = this.dynamicImportIds[name] = this.scope.generateUidIdentifier(name);

      var specifiers = [t.importDefaultSpecifier(id)];
      var declar = t.importDeclaration(specifiers, t.literal(source));
      declar._blockHoist = 3;

      if (type) {
        var modules = this.dynamicImportTypes[type] = this.dynamicImportTypes[type] || [];
        modules.push(declar);
      }

      if (this.transformers["es6.modules"].canTransform()) {
        this.moduleFormatter.importSpecifier(specifiers[0], declar, this.dynamicImports, this.scope);
        this.moduleFormatter.hasLocalImports = true;
      } else {
        this.dynamicImports.push(declar);
      }
    }

    return id;
  };

  /**
   * [Please add a description.]
   */

  File.prototype.attachAuxiliaryComment = function attachAuxiliaryComment(node) {
    var beforeComment = this.opts.auxiliaryCommentBefore;
    if (beforeComment) {
      node.leadingComments = node.leadingComments || [];
      node.leadingComments.push({
        type: "CommentLine",
        value: " " + beforeComment
      });
    }

    var afterComment = this.opts.auxiliaryCommentAfter;
    if (afterComment) {
      node.trailingComments = node.trailingComments || [];
      node.trailingComments.push({
        type: "CommentLine",
        value: " " + afterComment
      });
    }

    return node;
  };

  /**
   * [Please add a description.]
   */

  File.prototype.addHelper = function addHelper(name) {
    var isSolo = _lodashCollectionIncludes2["default"](File.soloHelpers, name);

    if (!isSolo && !_lodashCollectionIncludes2["default"](File.helpers, name)) {
      throw new ReferenceError("Unknown helper " + name);
    }

    var declar = this.declarations[name];
    if (declar) return declar;

    this.usedHelpers[name] = true;

    if (!isSolo) {
      var generator = this.get("helperGenerator");
      var runtime = this.get("helpersNamespace");
      if (generator) {
        return generator(name);
      } else if (runtime) {
        var id = t.identifier(t.toIdentifier(name));
        return t.memberExpression(runtime, id);
      }
    }

    var ref = util.template("helper-" + name);

    var uid = this.declarations[name] = this.scope.generateUidIdentifier(name);

    if (t.isFunctionExpression(ref) && !ref.id) {
      ref.body._compact = true;
      ref._generated = true;
      ref.id = uid;
      ref.type = "FunctionDeclaration";
      this.attachAuxiliaryComment(ref);
      this.path.unshiftContainer("body", ref);
    } else {
      ref._compact = true;
      this.scope.push({
        id: uid,
        init: ref,
        unique: true
      });
    }

    return uid;
  };

  File.prototype.addTemplateObject = function addTemplateObject(helperName, strings, raw) {
    // Generate a unique name based on the string literals so we dedupe
    // identical strings used in the program.
    var stringIds = raw.elements.map(function (string) {
      return string.value;
    });
    var name = helperName + "_" + raw.elements.length + "_" + stringIds.join(",");

    var declar = this.declarations[name];
    if (declar) return declar;

    var uid = this.declarations[name] = this.scope.generateUidIdentifier("templateObject");

    var helperId = this.addHelper(helperName);
    var init = t.callExpression(helperId, [strings, raw]);
    init._compact = true;
    this.scope.push({
      id: uid,
      init: init,
      _blockHoist: 1.9 // This ensures that we don't fail if not using function expression helpers
    });
    return uid;
  };

  /**
   * [Please add a description.]
   */

  File.prototype.errorWithNode = function errorWithNode(node, msg) {
    var Error = arguments.length <= 2 || arguments[2] === undefined ? SyntaxError : arguments[2];

    var err;
    var loc = node && (node.loc || node._loc);
    if (loc) {
      err = new Error("Line " + loc.start.line + ": " + msg);
      err.loc = loc.start;
    } else {
      // todo: find errors with nodes inside to at least point to something
      err = new Error("There's been an error on a dynamic node. This is almost certainly an internal error. Please report it.");
    }
    return err;
  };

  /**
   * [Please add a description.]
   */

  File.prototype.mergeSourceMap = function mergeSourceMap(map) {
    var opts = this.opts;

    var inputMap = opts.inputSourceMap;

    if (inputMap) {
      map.sources[0] = inputMap.file;

      var inputMapConsumer = new _sourceMap2["default"].SourceMapConsumer(inputMap);
      var outputMapConsumer = new _sourceMap2["default"].SourceMapConsumer(map);
      var outputMapGenerator = _sourceMap2["default"].SourceMapGenerator.fromSourceMap(outputMapConsumer);
      outputMapGenerator.applySourceMap(inputMapConsumer);

      var mergedMap = outputMapGenerator.toJSON();
      mergedMap.sources = inputMap.sources;
      mergedMap.file = inputMap.file;
      return mergedMap;
    }

    return map;
  };

  /**
   * [Please add a description.]
   */

  File.prototype.getModuleFormatter = function getModuleFormatter(type) {
    if (_lodashLangIsFunction2["default"](type) || !_modules2["default"][type]) {
      this.log.deprecate("Custom module formatters are deprecated and will be removed in the next major. Please use Babel plugins instead.");
    }

    var ModuleFormatter = _lodashLangIsFunction2["default"](type) ? type : _modules2["default"][type];

    if (!ModuleFormatter) {
      var loc = _tryResolve2["default"].relative(type);
      if (loc) ModuleFormatter = require(loc);
    }

    if (!ModuleFormatter) {
      throw new ReferenceError("Unknown module formatter type " + JSON.stringify(type));
    }

    return new ModuleFormatter(this);
  };

  /**
   * [Please add a description.]
   */

  File.prototype.parse = function parse(code) {
    var opts = this.opts;

    //

    var parseOpts = {
      highlightCode: opts.highlightCode,
      nonStandard: opts.nonStandard,
      sourceType: opts.sourceType,
      filename: opts.filename,
      plugins: {}
    };

    var features = parseOpts.features = {};
    for (var key in this.transformers) {
      var transformer = this.transformers[key];
      features[key] = transformer.canTransform();
    }

    parseOpts.looseModules = this.isLoose("es6.modules");
    parseOpts.strictMode = features.strict;

    this.log.debug("Parse start");
    var ast = _helpersParse2["default"](code, parseOpts);
    this.log.debug("Parse stop");
    return ast;
  };

  /**
   * [Please add a description.]
   */

  File.prototype._addAst = function _addAst(ast) {
    this.path = _traversalPath2["default"].get({
      hub: this.hub,
      parentPath: null,
      parent: ast,
      container: ast,
      key: "program"
    }).setContext();
    this.scope = this.path.scope;
    this.ast = ast;
  };

  /**
   * [Please add a description.]
   */

  File.prototype.addAst = function addAst(ast) {
    this.log.debug("Start set AST");
    this._addAst(ast);
    this.log.debug("End set AST");

    this.log.debug("Start module formatter init");
    var modFormatter = this.moduleFormatter = this.getModuleFormatter(this.opts.modules);
    if (modFormatter.init && this.transformers["es6.modules"].canTransform()) {
      modFormatter.init();
    }
    this.log.debug("End module formatter init");
  };

  /**
   * [Please add a description.]
   */

  File.prototype.transform = function transform() {
    this.call("pre");
    var _arr6 = this.transformerStack;
    for (var _i6 = 0; _i6 < _arr6.length; _i6++) {
      var pass = _arr6[_i6];
      pass.transform();
    }
    this.call("post");

    return this.generate();
  };

  /**
   * [Please add a description.]
   */

  File.prototype.wrap = function wrap(code, callback) {
    code = code + "";

    try {
      if (this.shouldIgnore()) {
        return this.makeResult({ code: code, ignored: true });
      } else {
        return callback();
      }
    } catch (err) {
      if (err._babel) {
        throw err;
      } else {
        err._babel = true;
      }

      var message = err.message = this.opts.filename + ": " + err.message;

      var loc = err.loc;
      if (loc) {
        err.codeFrame = _helpersCodeFrame2["default"](code, loc.line, loc.column + 1, this.opts);
        message += "\n" + err.codeFrame;
      }

      if (process.browser) {
        // chrome has it's own pretty stringifier which doesn't use the stack property
        // https://github.com/babel/babel/issues/2175
        err.message = message;
      }

      if (err.stack) {
        var newStack = err.stack.replace(err.message, message);
        try {
          err.stack = newStack;
        } catch (e) {
          // `err.stack` may be a readonly property in some environments
        }
      }

      throw err;
    }
  };

  /**
   * [Please add a description.]
   */

  File.prototype.addCode = function addCode(code) {
    code = (code || "") + "";
    code = this.parseInputSourceMap(code);
    this.code = code;
  };

  /**
   * [Please add a description.]
   */

  File.prototype.parseCode = function parseCode() {
    this.parseShebang();
    var ast = this.parse(this.code);
    this.addAst(ast);
  };

  /**
   * [Please add a description.]
   */

  File.prototype.shouldIgnore = function shouldIgnore() {
    var opts = this.opts;
    return util.shouldIgnore(opts.filename, opts.ignore, opts.only);
  };

  /**
   * [Please add a description.]
   */

  File.prototype.call = function call(key) {
    var _arr7 = this.uncollapsedTransformerStack;

    for (var _i7 = 0; _i7 < _arr7.length; _i7++) {
      var pass = _arr7[_i7];
      var fn = pass.plugin[key];
      if (fn) fn(this);
    }
  };

  /**
   * [Please add a description.]
   */

  File.prototype.parseInputSourceMap = function parseInputSourceMap(code) {
    var opts = this.opts;

    if (opts.inputSourceMap !== false) {
      var inputMap = _convertSourceMap2["default"].fromSource(code);
      if (inputMap) {
        opts.inputSourceMap = inputMap.toObject();
        code = _convertSourceMap2["default"].removeComments(code);
      }
    }

    return code;
  };

  /**
   * [Please add a description.]
   */

  File.prototype.parseShebang = function parseShebang() {
    var shebangMatch = _shebangRegex2["default"].exec(this.code);
    if (shebangMatch) {
      this.shebang = shebangMatch[0];
      this.code = this.code.replace(_shebangRegex2["default"], "");
    }
  };

  /**
   * [Please add a description.]
   */

  File.prototype.makeResult = function makeResult(_ref) {
    var code = _ref.code;
    var _ref$map = _ref.map;
    var map = _ref$map === undefined ? null : _ref$map;
    var ast = _ref.ast;
    var ignored = _ref.ignored;

    var result = {
      metadata: null,
      ignored: !!ignored,
      code: null,
      ast: null,
      map: map
    };

    if (this.opts.code) {
      result.code = code;
    }

    if (this.opts.ast) {
      result.ast = ast;
    }

    if (this.opts.metadata) {
      result.metadata = this.metadata;
      result.metadata.usedHelpers = Object.keys(this.usedHelpers);
    }

    return result;
  };

  /**
   * [Please add a description.]
   */

  File.prototype.generate = function generate() {
    var opts = this.opts;
    var ast = this.ast;

    var result = { ast: ast };
    if (!opts.code) return this.makeResult(result);

    this.log.debug("Generation start");

    var _result = _generation2["default"](ast, opts, this.code);
    result.code = _result.code;
    result.map = _result.map;

    this.log.debug("Generation end");

    if (this.shebang) {
      // add back shebang
      result.code = this.shebang + "\n" + result.code;
    }

    if (result.map) {
      result.map = this.mergeSourceMap(result.map);
    }

    if (opts.sourceMaps === "inline" || opts.sourceMaps === "both") {
      result.code += "\n" + _convertSourceMap2["default"].fromObject(result.map).toComment();
    }

    if (opts.sourceMaps === "inline") {
      result.map = null;
    }

    return this.makeResult(result);
  };

  _createClass(File, null, [{
    key: "helpers",

    /**
     * [Please add a description.]
     */

    value: ["inherits", "defaults", "create-class", "create-decorated-class", "create-decorated-object", "define-decorated-property-descriptor", "tagged-template-literal", "tagged-template-literal-loose", "to-array", "to-consumable-array", "sliced-to-array", "sliced-to-array-loose", "object-without-properties", "has-own", "slice", "bind", "define-property", "async-to-generator", "interop-export-wildcard", "interop-require-wildcard", "interop-require-default", "typeof", "extends", "get", "set", "new-arrow-check", "class-call-check", "object-destructuring-empty", "temporal-undefined", "temporal-assert-defined", "self-global", "typeof-react-element", "default-props", "instanceof",

    // legacy
    "interop-require"],

    /**
     * [Please add a description.]
     */

    enumerable: true
  }, {
    key: "soloHelpers",
    value: [],
    enumerable: true
  }]);

  return File;
})();

exports["default"] = File;
module.exports = exports["default"];
}).call(this,require('_process'))
},{"../../generation":205,"../../helpers/code-frame":213,"../../helpers/parse":217,"../../traversal":323,"../../traversal/hub":322,"../../traversal/path":330,"../../types":354,"../../util":357,"../modules":249,"../plugin":257,"./logger":222,"./options/option-manager":225,"./plugin-manager":227,"_process":876,"convert-source-map":417,"lodash/collection/includes":755,"lodash/lang/isFunction":843,"lodash/object/defaults":853,"path":870,"shebang-regex":907,"source-map":921,"try-resolve":942}],222:[function(require,module,exports){
"use strict";

exports.__esModule = true;
// istanbul ignore next

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

// istanbul ignore next

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var _debugNode = require("debug/node");

var _debugNode2 = _interopRequireDefault(_debugNode);

var verboseDebug = _debugNode2["default"]("babel:verbose");
var generalDebug = _debugNode2["default"]("babel");

var seenDeprecatedMessages = [];

/**
 * [Please add a description.]
 */

var Logger = (function () {
  function Logger(file, filename) {
    _classCallCheck(this, Logger);

    this.filename = filename;
    this.file = file;
  }

  /**
   * [Please add a description.]
   */

  Logger.prototype._buildMessage = function _buildMessage(msg) {
    var parts = "[BABEL] " + this.filename;
    if (msg) parts += ": " + msg;
    return parts;
  };

  /**
   * [Please add a description.]
   */

  Logger.prototype.warn = function warn(msg) {
    console.warn(this._buildMessage(msg));
  };

  /**
   * [Please add a description.]
   */

  Logger.prototype.error = function error(msg) {
    var Constructor = arguments.length <= 1 || arguments[1] === undefined ? Error : arguments[1];

    throw new Constructor(this._buildMessage(msg));
  };

  /**
   * [Please add a description.]
   */

  Logger.prototype.deprecate = function deprecate(msg) {
    if (this.file.opts && this.file.opts.suppressDeprecationMessages) return;

    msg = this._buildMessage(msg);

    // already seen this message
    if (seenDeprecatedMessages.indexOf(msg) >= 0) return;

    // make sure we don't see it again
    seenDeprecatedMessages.push(msg);

    console.error(msg);
  };

  /**
   * [Please add a description.]
   */

  Logger.prototype.verbose = function verbose(msg) {
    if (verboseDebug.enabled) verboseDebug(this._buildMessage(msg));
  };

  /**
   * [Please add a description.]
   */

  Logger.prototype.debug = function debug(msg) {
    if (generalDebug.enabled) generalDebug(this._buildMessage(msg));
  };

  /**
   * [Please add a description.]
   */

  Logger.prototype.deopt = function deopt(node, msg) {
    this.debug(msg);
  };

  return Logger;
})();

exports["default"] = Logger;
module.exports = exports["default"];
},{"debug/node":609}],223:[function(require,module,exports){
module.exports={
  "filename": {
    "type": "filename",
    "description": "filename to use when reading from stdin - this will be used in source-maps, errors etc",
    "default": "unknown",
    "shorthand": "f"
  },

  "filenameRelative": {
    "hidden": true,
    "type": "string"
  },

  "inputSourceMap": {
    "hidden": true
  },

  "extra": {
    "hidden": true,
    "default": {}
  },

  "env": {
    "hidden": true,
    "default": {}
  },

  "moduleId": {
    "description": "specify a custom name for module ids",
    "type": "string"
  },

  "getModuleId": {
    "hidden": true
  },

  "retainLines": {
    "type": "boolean",
    "default": false,
    "description": "retain line numbers - will result in really ugly code"
  },

  "nonStandard": {
    "type": "boolean",
    "default": true,
    "description": "enable/disable support for JSX and Flow (on by default)"
  },

  "experimental": {
    "type": "boolean",
    "description": "allow use of experimental transformers",
    "default": false
  },

  "highlightCode": {
    "description": "enable/disable ANSI syntax highlighting of code frames (on by default)",
    "type": "boolean",
    "default": true
  },

  "suppressDeprecationMessages": {
    "type": "boolean",
    "default": false,
    "hidden": true
  },

  "resolveModuleSource": {
    "hidden": true
  },

  "stage": {
    "description": "ECMAScript proposal stage version to allow [0-4]",
    "shorthand": "e",
    "type": "number",
    "default": 2
  },

  "blacklist": {
    "type": "transformerList",
    "description": "blacklist of transformers to NOT use",
    "shorthand": "b",
    "default": []
  },

  "whitelist": {
    "type": "transformerList",
    "optional": true,
    "description": "whitelist of transformers to ONLY use",
    "shorthand": "l"
  },

  "optional": {
    "type": "transformerList",
    "description": "list of optional transformers to enable",
    "default": []
  },

  "modules": {
    "type": "string",
    "description": "module formatter type to use [common]",
    "default": "common",
    "shorthand": "m"
  },

  "moduleIds": {
    "type": "boolean",
    "default": false,
    "shorthand": "M",
    "description": "insert an explicit id for modules"
  },

  "loose": {
    "type": "transformerList",
    "description": "list of transformers to enable loose mode ON",
    "shorthand": "L"
  },

  "jsxPragma": {
    "type": "string",
    "description": "custom pragma to use with JSX (same functionality as @jsx comments)",
    "default": "React.createElement",
    "shorthand": "P"
  },

  "plugins": {
    "type": "list",
    "description": "",
    "default": []
  },

  "ignore": {
    "type": "list",
    "description": "list of glob paths to **not** compile",
    "default": []
  },

  "only": {
    "type": "list",
    "description": "list of glob paths to **only** compile"
  },

  "code": {
    "hidden": true,
    "default": true,
    "type": "boolean"
  },

  "metadata": {
    "hidden": true,
    "default": true,
    "type": "boolean"
  },

  "ast": {
    "hidden": true,
    "default": true,
    "type": "boolean"
  },

  "comments": {
    "type": "boolean",
    "default": true,
    "description": "strip/output comments in generated output (on by default)"
  },

  "shouldPrintComment": {
    "hidden": true,
    "description": "optional callback to control whether a comment should be inserted, when this is used the comments option is ignored"
  },

  "compact": {
    "type": "booleanString",
    "default": "auto",
    "description": "do not include superfluous whitespace characters and line terminators [true|false|auto]"
  },

  "keepModuleIdExtensions": {
    "type": "boolean",
    "description": "keep extensions when generating module ids",
    "default": false,
    "shorthand": "k"
  },

  "auxiliaryComment": {
    "deprecated": "renamed to auxiliaryCommentBefore",
    "shorthand": "a",
    "alias": "auxiliaryCommentBefore"
  },

  "auxiliaryCommentBefore": {
    "type": "string",
    "default": "",
    "description": "attach a comment before all helper declarations and auxiliary code"
  },

  "auxiliaryCommentAfter": {
    "type": "string",
    "default": "",
    "description": "attach a comment after all helper declarations and auxiliary code"
  },

  "externalHelpers": {
    "type": "boolean",
    "default": false,
    "shorthand": "r",
    "description": "uses a reference to `babelHelpers` instead of placing helpers at the top of your code."
  },

  "metadataUsedHelpers": {
    "deprecated": "Not required anymore as this is enabled by default",
    "type": "boolean",
    "default": false,
    "hidden": true
  },

  "sourceMap": {
    "alias": "sourceMaps",
    "hidden": true
  },

  "sourceMaps": {
    "type": "booleanString",
    "description": "[true|false|inline]",
    "default": false,
    "shorthand": "s"
  },

  "sourceMapName": {
    "alias": "sourceMapTarget",
    "description": "DEPRECATED - Please use sourceMapTarget"
  },

  "sourceMapTarget": {
    "type": "string",
    "description": "set `file` on returned source map"
  },

  "sourceFileName": {
    "type": "string",
    "description": "set `sources[0]` on returned source map"
  },

  "sourceRoot": {
    "type": "filename",
    "description": "the root from which all sources are relative"
  },

  "moduleRoot": {
    "type": "filename",
    "description": "optional prefix for the AMD module formatter that will be prepend to the filename on module definitions"
  },

  "breakConfig": {
    "type": "boolean",
    "default": false,
    "hidden": true,
    "description": "stop trying to load .babelrc files"
  },

  "babelrc": {
    "description": "Specify a custom list of babelrc files to use",
    "type": "list"
  },

  "sourceType": {
    "description": "",
    "default": "module"
  }
}

},{}],224:[function(require,module,exports){
"use strict";

exports.__esModule = true;
exports.validateOption = validateOption;
exports.normaliseOptions = normaliseOptions;
// istanbul ignore next

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

// istanbul ignore next

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj["default"] = obj; return newObj; } }

var _parsers = require("./parsers");

var parsers = _interopRequireWildcard(_parsers);

var _config = require("./config");

var _config2 = _interopRequireDefault(_config);

exports.config = _config2["default"];

/**
 * Validate an option.
 */

function validateOption(key, val, pipeline) {
  var opt = _config2["default"][key];
  var parser = opt && parsers[opt.type];
  if (parser && parser.validate) {
    return parser.validate(key, val, pipeline);
  } else {
    return val;
  }
}

/**
 * Normalize all options.
 */

function normaliseOptions() {
  var options = arguments.length <= 0 || arguments[0] === undefined ? {} : arguments[0];

  for (var key in options) {
    var val = options[key];
    if (val == null) continue;

    var opt = _config2["default"][key];
    if (!opt) continue;

    var parser = parsers[opt.type];
    if (parser) val = parser(val);

    options[key] = val;
  }

  return options;
}
},{"./config":223,"./parsers":226}],225:[function(require,module,exports){
(function (process){
"use strict";

exports.__esModule = true;
// istanbul ignore next

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

// istanbul ignore next

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var _index = require("./index");

var _json5 = require("json5");

var _json52 = _interopRequireDefault(_json5);

var _pathIsAbsolute = require("path-is-absolute");

var _pathIsAbsolute2 = _interopRequireDefault(_pathIsAbsolute);

var _pathExists = require("path-exists");

var _pathExists2 = _interopRequireDefault(_pathExists);

var _lodashLangClone = require("lodash/lang/clone");

var _lodashLangClone2 = _interopRequireDefault(_lodashLangClone);

var _helpersMerge = require("../../../helpers/merge");

var _helpersMerge2 = _interopRequireDefault(_helpersMerge);

var _config = require("./config");

var _config2 = _interopRequireDefault(_config);

var _path = require("path");

var _path2 = _interopRequireDefault(_path);

var _fs = require("fs");

var _fs2 = _interopRequireDefault(_fs);

var existsCache = {};
var jsonCache = {};

var BABELIGNORE_FILENAME = ".babelignore";
var BABELRC_FILENAME = ".babelrc";
var PACKAGE_FILENAME = "package.json";

function exists(filename) {
  var cached = existsCache[filename];
  if (cached != null) {
    return cached;
  } else {
    return existsCache[filename] = _pathExists2["default"].sync(filename);
  }
}

var OptionManager = (function () {
  function OptionManager(log, pipeline) {
    _classCallCheck(this, OptionManager);

    this.resolvedConfigs = [];
    this.options = OptionManager.createBareOptions();
    this.pipeline = pipeline;
    this.log = log;
  }

  /**
   * [Please add a description.]
   */

  OptionManager.createBareOptions = function createBareOptions() {
    var opts = {};

    for (var key in _config2["default"]) {
      var opt = _config2["default"][key];
      opts[key] = _lodashLangClone2["default"](opt["default"]);
    }

    return opts;
  };

  /**
   * [Please add a description.]
   */

  OptionManager.prototype.addConfig = function addConfig(loc, key) {
    var json = arguments.length <= 2 || arguments[2] === undefined ? _json52["default"] : arguments[2];

    if (this.resolvedConfigs.indexOf(loc) >= 0) return;

    var content = _fs2["default"].readFileSync(loc, "utf8");
    var opts;

    try {
      opts = jsonCache[content] = jsonCache[content] || json.parse(content);
      if (key) opts = opts[key];
    } catch (err) {
      err.message = loc + ": Error while parsing JSON - " + err.message;
      throw err;
    }

    this.mergeOptions(opts, loc);
    this.resolvedConfigs.push(loc);
  };

  /**
   * [Please add a description.]
   */

  OptionManager.prototype.mergeOptions = function mergeOptions(opts) {
    var alias = arguments.length <= 1 || arguments[1] === undefined ? "foreign" : arguments[1];

    if (!opts) return;

    for (var key in opts) {
      if (key[0] === "_") continue;

      var option = _config2["default"][key];

      // check for an unknown option
      if (!option) this.log.error("Unknown option: " + alias + "." + key, ReferenceError);
    }

    // normalise options
    _index.normaliseOptions(opts);

    // merge them into this current files options
    _helpersMerge2["default"](this.options, opts);
  };

  /**
   * [Please add a description.]
   */

  OptionManager.prototype.addIgnoreConfig = function addIgnoreConfig(loc) {
    var file = _fs2["default"].readFileSync(loc, "utf8");
    var lines = file.split("\n");

    lines = lines.map(function (line) {
      return line.replace(/#(.*?)$/, "").trim();
    }).filter(function (line) {
      return !!line;
    });

    this.mergeOptions({ ignore: lines }, loc);
  };

  /**
   * Description
   */

  OptionManager.prototype.findConfigs = function findConfigs(loc) {
    if (!loc) return;

    if (!_pathIsAbsolute2["default"](loc)) {
      loc = _path2["default"].join(process.cwd(), loc);
    }

    while (loc !== (loc = _path2["default"].dirname(loc))) {
      if (this.options.breakConfig) return;

      var configLoc = _path2["default"].join(loc, BABELRC_FILENAME);
      if (exists(configLoc)) this.addConfig(configLoc);

      var pkgLoc = _path2["default"].join(loc, PACKAGE_FILENAME);
      if (exists(pkgLoc)) this.addConfig(pkgLoc, "babel", JSON);

      var ignoreLoc = _path2["default"].join(loc, BABELIGNORE_FILENAME);
      if (exists(ignoreLoc)) this.addIgnoreConfig(ignoreLoc);
    }
  };

  /**
   * [Please add a description.]
   */

  OptionManager.prototype.normaliseOptions = function normaliseOptions() {
    var opts = this.options;

    for (var key in _config2["default"]) {
      var option = _config2["default"][key];
      var val = opts[key];

      // optional
      if (!val && option.optional) continue;

      // deprecated
      if (this.log && val && option.deprecated) {
        this.log.deprecate("Deprecated option " + key + ": " + option.deprecated);
      }

      // validate
      if (this.pipeline && val) {
        val = _index.validateOption(key, val, this.pipeline);
      }

      // aaliases
      if (option.alias) {
        opts[option.alias] = opts[option.alias] || val;
      } else {
        opts[key] = val;
      }
    }
  };

  /**
   * [Please add a description.]
   */

  OptionManager.prototype.init = function init(opts) {
    this.mergeOptions(opts, "direct");

    // babelrc option
    if (opts.babelrc) {
      var _arr = opts.babelrc;

      for (var _i = 0; _i < _arr.length; _i++) {
        var loc = _arr[_i];this.addConfig(loc);
      }
    }

    // resolve all .babelrc files
    if (opts.babelrc !== false) {
      this.findConfigs(opts.filename);
    }

    // merge in env
    var envKey = process.env.BABEL_ENV || process.env.NODE_ENV || "development";
    if (this.options.env) {
      this.mergeOptions(this.options.env[envKey], "direct.env." + envKey);
    }

    // normalise
    this.normaliseOptions(opts);

    return this.options;
  };

  return OptionManager;
})();

exports["default"] = OptionManager;
module.exports = exports["default"];
}).call(this,require('_process'))
},{"../../../helpers/merge":214,"./config":223,"./index":224,"_process":876,"fs":404,"json5":743,"lodash/lang/clone":837,"path":870,"path-exists":871,"path-is-absolute":872}],226:[function(require,module,exports){
"use strict";

exports.__esModule = true;
exports.transformerList = transformerList;
exports.number = number;
exports.boolean = boolean;
exports.booleanString = booleanString;
exports.list = list;
// istanbul ignore next

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj["default"] = obj; return newObj; } }

// istanbul ignore next

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

var _slash = require("slash");

var _slash2 = _interopRequireDefault(_slash);

var _util = require("../../../util");

var util = _interopRequireWildcard(_util);

/**
 * Get a transformer list from a value.
 */

function transformerList(val) {
  return util.arrayify(val);
}

/**
 * Validate transformer list. Maps "all" to all transformer names.
 */

transformerList.validate = function (key, val, pipeline) {
  if (val.indexOf("all") >= 0 || val.indexOf(true) >= 0) {
    val = Object.keys(pipeline.transformers);
  }

  return pipeline._ensureTransformerNames(key, val);
};

/**
 * Cast a value to a number.
 */

function number(val) {
  return +val;
}

/**
 * Cast a value to a boolean.
 */

var filename = _slash2["default"];

exports.filename = filename;
/**
 * [Please add a description.]
 */

function boolean(val) {
  return !!val;
}

/**
 * Cast a boolean-like string to a boolean.
 */

function booleanString(val) {
  return util.booleanify(val);
}

/**
 * Cast a value to an array, splitting strings by ",".
 */

function list(val) {
  return util.list(val);
}
},{"../../../util":357,"slash":910}],227:[function(require,module,exports){
"use strict";

exports.__esModule = true;
// istanbul ignore next

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

// istanbul ignore next

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj["default"] = obj; return newObj; } }

// istanbul ignore next

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

// istanbul ignore next

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var _transformer = require("../transformer");

var _transformer2 = _interopRequireDefault(_transformer);

var _plugin = require("../plugin");

var _plugin2 = _interopRequireDefault(_plugin);

var _types = require("../../types");

var types = _interopRequireWildcard(_types);

var _messages = require("../../messages");

var messages = _interopRequireWildcard(_messages);

var _tryResolve = require("try-resolve");

var _tryResolve2 = _interopRequireDefault(_tryResolve);

var _traversal = require("../../traversal");

var _traversal2 = _interopRequireDefault(_traversal);

var _helpersParse = require("../../helpers/parse");

var _helpersParse2 = _interopRequireDefault(_helpersParse);

/**
 * [Please add a description.]
 */

var context = {
  messages: messages,
  Transformer: _transformer2["default"],
  Plugin: _plugin2["default"],
  types: types,
  parse: _helpersParse2["default"],
  traverse: _traversal2["default"]
};

/**
 * [Please add a description.]
 */

var PluginManager = (function () {

  /**
   * [Please add a description.]
   */

  PluginManager.memoisePluginContainer = function memoisePluginContainer(fn) {
    for (var i = 0; i < PluginManager.memoisedPlugins.length; i++) {
      var plugin = PluginManager.memoisedPlugins[i];
      if (plugin.container === fn) return plugin.transformer;
    }

    var transformer = fn(context);
    PluginManager.memoisedPlugins.push({
      container: fn,
      transformer: transformer
    });
    return transformer;
  };

  /**
   * [Please add a description.]
   */

  _createClass(PluginManager, null, [{
    key: "memoisedPlugins",

    /**
     * [Please add a description.]
     */

    value: [],
    enumerable: true
  }, {
    key: "positions",
    value: ["before", "after"],

    /**
     * [Please add a description.]
     */

    enumerable: true
  }]);

  function PluginManager() {
    var _ref = arguments.length <= 0 || arguments[0] === undefined ? { transformers: {}, before: [], after: [] } : arguments[0];

    var file = _ref.file;
    var transformers = _ref.transformers;
    var before = _ref.before;
    var after = _ref.after;

    _classCallCheck(this, PluginManager);

    this.transformers = transformers;
    this.file = file;
    this.before = before;
    this.after = after;
  }

  /**
   * [Please add a description.]
   */

  PluginManager.prototype.subnormaliseString = function subnormaliseString(name, position) {
    // this is a plugin in the form of "foobar" or "foobar:after"
    // where the optional colon is the delimiter for plugin position in the transformer stack

    var match = name.match(/^(.*?):(after|before)$/);
    if (match) {
      ;

      name = match[1];
      position = match[2];
    }var loc = _tryResolve2["default"].relative("babel-plugin-" + name) || _tryResolve2["default"].relative(name);
    if (loc) {
      var plugin = require(loc);
      return {
        position: position,
        plugin: plugin["default"] || plugin
      };
    } else {
      throw new ReferenceError(messages.get("pluginUnknown", name));
    }
  };

  /**
   * [Please add a description.]
   */

  PluginManager.prototype.validate = function validate(name, plugin) {
    // validate transformer key
    var key = plugin.key;
    if (this.transformers[key]) {
      throw new ReferenceError(messages.get("pluginKeyCollision", key));
    }

    // validate Transformer instance
    if (!plugin.buildPass || plugin.constructor.name !== "Plugin") {
      throw new TypeError(messages.get("pluginNotTransformer", name));
    }

    // register as a plugin
    plugin.metadata.plugin = true;
  };

  /**
   * [Please add a description.]
   */

  PluginManager.prototype.add = function add(name) {
    var position;
    var plugin;

    if (name) {
      if (typeof name === "object" && name.transformer) {
        plugin = name.transformer;
        position = name.position;
      } else if (typeof name !== "string") {
        // not a string so we'll just assume that it's a direct Transformer instance, if not then
        // the checks later on will complain
        plugin = name;
      }

      if (typeof name === "string") {
        var _subnormaliseString = this.subnormaliseString(name, position);

        plugin = _subnormaliseString.plugin;
        position = _subnormaliseString.position;
      }
    } else {
      throw new TypeError(messages.get("pluginIllegalKind", typeof name, name));
    }

    // default position
    position = position || "before";

    // validate position
    if (PluginManager.positions.indexOf(position) < 0) {
      throw new TypeError(messages.get("pluginIllegalPosition", position, name));
    }

    // allow plugin containers to be specified so they don't have to manually require
    if (typeof plugin === "function") {
      plugin = PluginManager.memoisePluginContainer(plugin);
    }

    //
    this.validate(name, plugin);

    // build!
    var pass = this.transformers[plugin.key] = plugin.buildPass(this.file);
    if (pass.canTransform()) {
      var stack = position === "before" ? this.before : this.after;
      stack.push(pass);
    }
  };

  return PluginManager;
})();

exports["default"] = PluginManager;
module.exports = exports["default"];
},{"../../helpers/parse":217,"../../messages":218,"../../traversal":323,"../../types":354,"../plugin":257,"../transformer":258,"try-resolve":942}],228:[function(require,module,exports){
"use strict";

exports.__esModule = true;
// istanbul ignore next

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj["default"] = obj; return newObj; } }

// istanbul ignore next

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

var _explodeAssignableExpression = require("./explode-assignable-expression");

var _explodeAssignableExpression2 = _interopRequireDefault(_explodeAssignableExpression);

var _types = require("../../types");

var t = _interopRequireWildcard(_types);

/**
 * [Please add a description.]
 */

exports["default"] = function (opts) {
  var exports = {};

  /**
   * [Please add a description.]
   */

  var isAssignment = function isAssignment(node) {
    return node.operator === opts.operator + "=";
  };

  /**
   * [Please add a description.]
   */

  var buildAssignment = function buildAssignment(left, right) {
    return t.assignmentExpression("=", left, right);
  };

  /**
   * [Please add a description.]
   */

  exports.ExpressionStatement = function (node, parent, scope, file) {
    // hit the `AssignmentExpression` one below
    if (this.isCompletionRecord()) return;

    var expr = node.expression;
    if (!isAssignment(expr)) return;

    var nodes = [];
    var exploded = _explodeAssignableExpression2["default"](expr.left, nodes, file, scope, true);

    nodes.push(t.expressionStatement(buildAssignment(exploded.ref, opts.build(exploded.uid, expr.right))));

    return nodes;
  };

  /**
   * [Please add a description.]
   */

  exports.AssignmentExpression = function (node, parent, scope, file) {
    if (!isAssignment(node)) return;

    var nodes = [];
    var exploded = _explodeAssignableExpression2["default"](node.left, nodes, file, scope);
    nodes.push(buildAssignment(exploded.ref, opts.build(exploded.uid, node.right)));
    return nodes;
  };

  /**
   * [Please add a description.]
   */

  exports.BinaryExpression = function (node) {
    if (node.operator !== opts.operator) return;
    return opts.build(node.left, node.right);
  };

  return exports;
};

module.exports = exports["default"];
},{"../../types":354,"./explode-assignable-expression":233}],229:[function(require,module,exports){
"use strict";

exports.__esModule = true;
exports["default"] = build;
// istanbul ignore next

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj["default"] = obj; return newObj; } }

var _types = require("../../types");

var t = _interopRequireWildcard(_types);

/**
 * [Please add a description.]
 */

function build(node, buildBody) {
  var self = node.blocks.shift();
  if (!self) return;

  var child = build(node, buildBody);
  if (!child) {
    // last item
    child = buildBody();

    // add a filter as this is our final stop
    if (node.filter) {
      child = t.ifStatement(node.filter, t.blockStatement([child]));
    }
  }

  return t.forOfStatement(t.variableDeclaration("let", [t.variableDeclarator(self.left)]), self.right, t.blockStatement([child]));
}

module.exports = exports["default"];
},{"../../types":354}],230:[function(require,module,exports){
// Based upon the excellent jsx-transpiler by Ingvar Stepanyan (RReverser)
// https://github.com/RReverser/jsx-transpiler

// jsx

"use strict";

exports.__esModule = true;
// istanbul ignore next

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj["default"] = obj; return newObj; } }

// istanbul ignore next

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

var _lodashLangIsString = require("lodash/lang/isString");

var _lodashLangIsString2 = _interopRequireDefault(_lodashLangIsString);

var _messages = require("../../messages");

var messages = _interopRequireWildcard(_messages);

var _esutils = require("esutils");

var _esutils2 = _interopRequireDefault(_esutils);

var _react = require("./react");

var react = _interopRequireWildcard(_react);

var _types = require("../../types");

var t = _interopRequireWildcard(_types);

/**
 * [Please add a description.]
 */

exports["default"] = function (opts) {
  var visitor = {};

  /**
   * [Please add a description.]
   */

  visitor.JSXIdentifier = function (node) {
    if (node.name === "this" && this.isReferenced()) {
      return t.thisExpression();
    } else if (_esutils2["default"].keyword.isIdentifierNameES6(node.name)) {
      node.type = "Identifier";
    } else {
      return t.literal(node.name);
    }
  };

  /**
   * [Please add a description.]
   */

  visitor.JSXNamespacedName = function () {
    throw this.errorWithNode(messages.get("JSXNamespacedTags"));
  };

  /**
   * [Please add a description.]
   */

  visitor.JSXMemberExpression = {
    exit: function exit(node) {
      node.computed = t.isLiteral(node.property);
      node.type = "MemberExpression";
    }
  };

  /**
   * [Please add a description.]
   */

  visitor.JSXExpressionContainer = function (node) {
    return node.expression;
  };

  /**
   * [Please add a description.]
   */

  visitor.JSXAttribute = {
    enter: function enter(node) {
      var value = node.value;
      if (t.isLiteral(value) && _lodashLangIsString2["default"](value.value)) {
        value.value = value.value.replace(/\n\s+/g, " ");
      }
    },

    exit: function exit(node) {
      var value = node.value || t.literal(true);
      return t.inherits(t.property("init", node.name, value), node);
    }
  };

  /**
   * [Please add a description.]
   */

  visitor.JSXOpeningElement = {
    exit: function exit(node, parent, scope, file) {
      parent.children = react.buildChildren(parent);

      var tagExpr = node.name;
      var args = [];

      var tagName;
      if (t.isIdentifier(tagExpr)) {
        tagName = tagExpr.name;
      } else if (t.isLiteral(tagExpr)) {
        tagName = tagExpr.value;
      }

      var state = {
        tagExpr: tagExpr,
        tagName: tagName,
        args: args
      };

      if (opts.pre) {
        opts.pre(state, file);
      }

      var attribs = node.attributes;
      if (attribs.length) {
        attribs = buildJSXOpeningElementAttributes(attribs, file);
      } else {
        attribs = t.literal(null);
      }

      args.push(attribs);

      if (opts.post) {
        opts.post(state, file);
      }

      return state.call || t.callExpression(state.callee, args);
    }
  };

  /**
   * The logic for this is quite terse. It's because we need to
   * support spread elements. We loop over all attributes,
   * breaking on spreads, we then push a new object containg
   * all prior attributes to an array for later processing.
   */

  var buildJSXOpeningElementAttributes = function buildJSXOpeningElementAttributes(attribs, file) {
    var _props = [];
    var objs = [];

    var pushProps = function pushProps() {
      if (!_props.length) return;

      objs.push(t.objectExpression(_props));
      _props = [];
    };

    while (attribs.length) {
      var prop = attribs.shift();
      if (t.isJSXSpreadAttribute(prop)) {
        pushProps();
        objs.push(prop.argument);
      } else {
        _props.push(prop);
      }
    }

    pushProps();

    if (objs.length === 1) {
      // only one object
      attribs = objs[0];
    } else {
      // looks like we have multiple objects
      if (!t.isObjectExpression(objs[0])) {
        objs.unshift(t.objectExpression([]));
      }

      // spread it
      attribs = t.callExpression(file.addHelper("extends"), objs);
    }

    return attribs;
  };

  /**
   * [Please add a description.]
   */

  visitor.JSXElement = {
    exit: function exit(node) {
      var callExpr = node.openingElement;

      callExpr.arguments = callExpr.arguments.concat(node.children);

      if (callExpr.arguments.length >= 3) {
        callExpr._prettyCall = true;
      }

      return t.inherits(callExpr, node);
    }
  };

  return visitor;
};

module.exports = exports["default"];
},{"../../messages":218,"../../types":354,"./react":237,"esutils":693,"lodash/lang/isString":849}],231:[function(require,module,exports){
"use strict";

exports.__esModule = true;
// istanbul ignore next

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj["default"] = obj; return newObj; } }

var _types = require("../../types");

var t = _interopRequireWildcard(_types);

/**
 * [Please add a description.]
 */

var visitor = {

  /**
   * [Please add a description.]
   */

  enter: function enter(node, parent, scope, state) {
    if (this.isThisExpression() || this.isReferencedIdentifier({ name: "arguments" })) {
      state.found = true;
      this.stop();
    }
  },

  /**
   * [Please add a description.]
   */

  Function: function Function() {
    this.skip();
  }
};

/**
 * [Please add a description.]
 */

exports["default"] = function (node, scope) {
  var container = t.functionExpression(null, [], node.body, node.generator, node.async);

  var callee = container;
  var args = [];

  var state = { found: false };
  scope.traverse(node, visitor, state);
  if (state.found) {
    callee = t.memberExpression(container, t.identifier("apply"));
    args = [t.thisExpression(), t.identifier("arguments")];
  }

  var call = t.callExpression(callee, args);
  if (node.generator) call = t.yieldExpression(call, true);

  return t.returnStatement(call);
};

module.exports = exports["default"];
},{"../../types":354}],232:[function(require,module,exports){
"use strict";

exports.__esModule = true;
exports.push = push;
exports.hasComputed = hasComputed;
exports.toComputedObjectFromClass = toComputedObjectFromClass;
exports.toClassObject = toClassObject;
exports.toDefineObject = toDefineObject;
// istanbul ignore next

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj["default"] = obj; return newObj; } }

// istanbul ignore next

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

var _lodashCollectionEach = require("lodash/collection/each");

var _lodashCollectionEach2 = _interopRequireDefault(_lodashCollectionEach);

var _lodashObjectHas = require("lodash/object/has");

var _lodashObjectHas2 = _interopRequireDefault(_lodashObjectHas);

var _types = require("../../types");

var t = _interopRequireWildcard(_types);

/**
 * [Please add a description.]
 */

function push(mutatorMap, node, kind, file) {
  var alias = t.toKeyAlias(node);

  //

  var map = {};
  if (_lodashObjectHas2["default"](mutatorMap, alias)) map = mutatorMap[alias];
  mutatorMap[alias] = map;

  //

  map._inherits = map._inherits || [];
  map._inherits.push(node);

  map._key = node.key;

  if (node.computed) {
    map._computed = true;
  }

  if (node.decorators) {
    var decorators = map.decorators = map.decorators || t.arrayExpression([]);
    decorators.elements = decorators.elements.concat(node.decorators.map(function (dec) {
      return dec.expression;
    }).reverse());
  }

  if (map.value || map.initializer) {
    throw file.errorWithNode(node, "Key conflict with sibling node");
  }

  if (node.value) {
    if (node.kind === "init") kind = "value";
    if (node.kind === "get") kind = "get";
    if (node.kind === "set") kind = "set";

    t.inheritsComments(node.value, node);
    map[kind] = node.value;
  }

  return map;
}

/**
 * [Please add a description.]
 */

function hasComputed(mutatorMap) {
  for (var key in mutatorMap) {
    if (mutatorMap[key]._computed) {
      return true;
    }
  }
  return false;
}

/**
 * [Please add a description.]
 */

function toComputedObjectFromClass(obj) {
  var objExpr = t.arrayExpression([]);

  for (var i = 0; i < obj.properties.length; i++) {
    var prop = obj.properties[i];
    var val = prop.value;
    val.properties.unshift(t.property("init", t.identifier("key"), t.toComputedKey(prop)));
    objExpr.elements.push(val);
  }

  return objExpr;
}

/**
 * [Please add a description.]
 */

function toClassObject(mutatorMap) {
  var objExpr = t.objectExpression([]);

  _lodashCollectionEach2["default"](mutatorMap, function (map) {
    var mapNode = t.objectExpression([]);

    var propNode = t.property("init", map._key, mapNode, map._computed);

    _lodashCollectionEach2["default"](map, function (node, key) {
      if (key[0] === "_") return;

      var inheritNode = node;
      if (t.isMethodDefinition(node) || t.isClassProperty(node)) node = node.value;

      var prop = t.property("init", t.identifier(key), node);
      t.inheritsComments(prop, inheritNode);
      t.removeComments(inheritNode);

      mapNode.properties.push(prop);
    });

    objExpr.properties.push(propNode);
  });

  return objExpr;
}

/**
 * [Please add a description.]
 */

function toDefineObject(mutatorMap) {
  _lodashCollectionEach2["default"](mutatorMap, function (map) {
    if (map.value) map.writable = t.literal(true);
    map.configurable = t.literal(true);
    map.enumerable = t.literal(true);
  });

  return toClassObject(mutatorMap);
}
},{"../../types":354,"lodash/collection/each":753,"lodash/object/has":855}],233:[function(require,module,exports){
"use strict";

exports.__esModule = true;
// istanbul ignore next

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj["default"] = obj; return newObj; } }

var _types = require("../../types");

var t = _interopRequireWildcard(_types);

/**
 * [Please add a description.]
 */

var getObjRef = function getObjRef(node, nodes, file, scope) {
  var ref;
  if (t.isIdentifier(node)) {
    if (scope.hasBinding(node.name)) {
      // this variable is declared in scope so we can be 100% sure
      // that evaluating it multiple times wont trigger a getter
      // or something else
      return node;
    } else {
      // could possibly trigger a getter so we need to only evaluate
      // it once
      ref = node;
    }
  } else if (t.isMemberExpression(node)) {
    ref = node.object;

    if (t.isIdentifier(ref) && scope.hasGlobal(ref.name)) {
      // the object reference that we need to save is locally declared
      // so as per the previous comment we can be 100% sure evaluating
      // it multiple times will be safe
      return ref;
    }
  } else {
    throw new Error("We can't explode this node type " + node.type);
  }

  var temp = scope.generateUidIdentifierBasedOnNode(ref);
  nodes.push(t.variableDeclaration("var", [t.variableDeclarator(temp, ref)]));
  return temp;
};

/**
 * [Please add a description.]
 */

var getPropRef = function getPropRef(node, nodes, file, scope) {
  var prop = node.property;
  var key = t.toComputedKey(node, prop);
  if (t.isLiteral(key)) return key;

  var temp = scope.generateUidIdentifierBasedOnNode(prop);
  nodes.push(t.variableDeclaration("var", [t.variableDeclarator(temp, prop)]));
  return temp;
};

/**
 * [Please add a description.]
 */

exports["default"] = function (node, nodes, file, scope, allowedSingleIdent) {
  var obj;
  if (t.isIdentifier(node) && allowedSingleIdent) {
    obj = node;
  } else {
    obj = getObjRef(node, nodes, file, scope);
  }

  var ref, uid;

  if (t.isIdentifier(node)) {
    ref = node;
    uid = obj;
  } else {
    var prop = getPropRef(node, nodes, file, scope);
    var computed = node.computed || t.isLiteral(prop);
    uid = ref = t.memberExpression(obj, prop, computed);
  }

  return {
    uid: uid,
    ref: ref
  };
};

module.exports = exports["default"];
},{"../../types":354}],234:[function(require,module,exports){
"use strict";

exports.__esModule = true;
// istanbul ignore next

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj["default"] = obj; return newObj; } }

var _types = require("../../types");

var t = _interopRequireWildcard(_types);

/**
 * [Please add a description.]
 */

exports["default"] = function (node) {
  var lastNonDefault = 0;
  for (var i = 0; i < node.params.length; i++) {
    var param = node.params[i];
    if (!t.isAssignmentPattern(param) && !t.isRestElement(param)) {
      lastNonDefault = i + 1;
    }
  }
  return lastNonDefault;
};

module.exports = exports["default"];
},{"../../types":354}],235:[function(require,module,exports){
"use strict";

exports.__esModule = true;
// istanbul ignore next

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj["default"] = obj; return newObj; } }

var _types = require("../../types");

var t = _interopRequireWildcard(_types);

/**
 * [Please add a description.]
 */

exports["default"] = function (decorators, scope) {
  for (var i = 0; i < decorators.length; i++) {
    var decorator = decorators[i];
    var expression = decorator.expression;
    if (!t.isMemberExpression(expression)) continue;

    var temp = scope.maybeGenerateMemoised(expression.object);
    var ref;

    var nodes = [];

    if (temp) {
      ref = temp;
      nodes.push(t.assignmentExpression("=", temp, expression.object));
    } else {
      ref = expression.object;
    }

    nodes.push(t.callExpression(t.memberExpression(t.memberExpression(ref, expression.property, expression.computed), t.identifier("bind")), [ref]));

    if (nodes.length === 1) {
      decorator.expression = nodes[0];
    } else {
      decorator.expression = t.sequenceExpression(nodes);
    }
  }

  return decorators;
};

module.exports = exports["default"];
},{"../../types":354}],236:[function(require,module,exports){
"use strict";

exports.__esModule = true;
exports.custom = custom;
exports.property = property;
exports.bare = bare;
// istanbul ignore next

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj["default"] = obj; return newObj; } }

// istanbul ignore next

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

var _getFunctionArity = require("./get-function-arity");

var _getFunctionArity2 = _interopRequireDefault(_getFunctionArity);

var _util = require("../../util");

var util = _interopRequireWildcard(_util);

var _types = require("../../types");

var t = _interopRequireWildcard(_types);

/**
 * [Please add a description.]
 */

function visitIdentifier(context, node, scope, state) {
  // check if this node matches our function id
  if (node.name !== state.name) return;

  // check that we don't have a local variable declared as that removes the need
  // for the wrapper
  var localDeclar = scope.getBindingIdentifier(state.name);
  if (localDeclar !== state.outerDeclar) return;

  state.selfReference = true;
  context.stop();
}

/**
 * [Please add a description.]
 */

var visitor = {

  /**
   * [Please add a description.]
   */

  ReferencedIdentifier: function ReferencedIdentifier(node, parent, scope, state) {
    visitIdentifier(this, node, scope, state);
  },

  /**
   * [Please add a description.]
   */

  BindingIdentifier: function BindingIdentifier(node, parent, scope, state) {
    visitIdentifier(this, node, scope, state);
  }
};

/**
 * [Please add a description.]
 */

var wrap = function wrap(state, method, id, scope) {
  if (state.selfReference) {
    if (scope.hasBinding(id.name) && !scope.hasGlobal(id.name)) {
      // we can just munge the local binding
      scope.rename(id.name);
    } else {
      // need to add a wrapper since we can't change the references
      var templateName = "property-method-assignment-wrapper";
      if (method.generator) templateName += "-generator";
      var template = util.template(templateName, {
        FUNCTION: method,
        FUNCTION_ID: id,
        FUNCTION_KEY: scope.generateUidIdentifier(id.name)
      });
      template.callee._skipModulesRemap = true;

      // shim in dummy params to retain function arity, if you try to read the
      // source then you'll get the original since it's proxied so it's all good
      var params = template.callee.body.body[0].params;
      for (var i = 0, len = _getFunctionArity2["default"](method); i < len; i++) {
        params.push(scope.generateUidIdentifier("x"));
      }

      return template;
    }
  }

  method.id = id;
  scope.getProgramParent().references[id.name] = true;
};

/**
 * [Please add a description.]
 */

var visit = function visit(node, name, scope) {
  var state = {
    selfAssignment: false,
    selfReference: false,
    outerDeclar: scope.getBindingIdentifier(name),
    references: [],
    name: name
  };

  // check to see if we have a local binding of the id we're setting inside of
  // the function, this is important as there are caveats associated

  var binding = scope.getOwnBinding(name);

  if (binding) {
    if (binding.kind === "param") {
      // safari will blow up in strict mode with code like:
      //
      //   var t = function t(t) {};
      //
      // with the error:
      //
      //   Cannot declare a parameter named 't' as it shadows the name of a
      //   strict mode function.
      //
      // this isn't to the spec and they've invented this behaviour which is
      // **extremely** annoying so we avoid setting the name if it has a param
      // with the same id
      state.selfReference = true;
    } else {
      // otherwise it's defined somewhere in scope like:
      //
      //   var t = function () {
      //     var t = 2;
      //   };
      //
      // so we can safely just set the id and move along as it shadows the
      // bound function id
    }
  } else if (state.outerDeclar || scope.hasGlobal(name)) {
      scope.traverse(node, visitor, state);
    }

  return state;
};

/**
 * [Please add a description.]
 */

function custom(node, id, scope) {
  var state = visit(node, id.name, scope);
  return wrap(state, node, id, scope);
}

/**
 * [Please add a description.]
 */

function property(node, file, scope) {
  var key = t.toComputedKey(node, node.key);
  if (!t.isLiteral(key)) return; // we can't set a function id with this

  var name = t.toBindingIdentifierName(key.value);
  var id = t.identifier(name);

  var method = node.value;
  var state = visit(method, name, scope);
  node.value = wrap(state, method, id, scope) || method;
}

/**
 * [Please add a description.]
 */

function bare(node, parent, scope) {
  // has an `id` so we don't need to infer one
  if (node.id) return;

  var id;
  if (t.isProperty(parent) && parent.kind === "init" && (!parent.computed || t.isLiteral(parent.key))) {
    // { foo() {} };
    id = parent.key;
  } else if (t.isVariableDeclarator(parent)) {
    // var foo = function () {};
    id = parent.id;

    if (t.isIdentifier(id)) {
      var binding = scope.parent.getBinding(id.name);
      if (binding && binding.constant && scope.getBinding(id.name) === binding) {
        // always going to reference this method
        node.id = id;
        return;
      }
    }
  } else {
    return;
  }

  var name;
  if (t.isLiteral(id)) {
    name = id.value;
  } else if (t.isIdentifier(id)) {
    name = id.name;
  } else {
    return;
  }

  name = t.toBindingIdentifierName(name);
  id = t.identifier(name);

  var state = visit(node, name, scope);
  return wrap(state, node, id, scope);
}
},{"../../types":354,"../../util":357,"./get-function-arity":234}],237:[function(require,module,exports){
"use strict";

exports.__esModule = true;
exports.isCompatTag = isCompatTag;
exports.buildChildren = buildChildren;
// istanbul ignore next

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj["default"] = obj; return newObj; } }

var _types = require("../../types");

var t = _interopRequireWildcard(_types);

var isReactComponent = t.buildMatchMemberExpression("React.Component");

exports.isReactComponent = isReactComponent;
/**
 * [Please add a description.]
 */

function isCompatTag(tagName) {
  return tagName && /^[a-z]|\-/.test(tagName);
}

/**
 * [Please add a description.]
 */

function cleanJSXElementLiteralChild(child, args) {
  var lines = child.value.split(/\r\n|\n|\r/);

  var lastNonEmptyLine = 0;

  for (var i = 0; i < lines.length; i++) {
    if (lines[i].match(/[^ \t]/)) {
      lastNonEmptyLine = i;
    }
  }

  var str = "";

  for (var i = 0; i < lines.length; i++) {
    var line = lines[i];

    var isFirstLine = i === 0;
    var isLastLine = i === lines.length - 1;
    var isLastNonEmptyLine = i === lastNonEmptyLine;

    // replace rendered whitespace tabs with spaces
    var trimmedLine = line.replace(/\t/g, " ");

    // trim whitespace touching a newline
    if (!isFirstLine) {
      trimmedLine = trimmedLine.replace(/^[ ]+/, "");
    }

    // trim whitespace touching an endline
    if (!isLastLine) {
      trimmedLine = trimmedLine.replace(/[ ]+$/, "");
    }

    if (trimmedLine) {
      if (!isLastNonEmptyLine) {
        trimmedLine += " ";
      }

      str += trimmedLine;
    }
  }

  if (str) args.push(t.literal(str));
}

/**
 * [Please add a description.]
 */

function buildChildren(node) {
  var elems = [];

  for (var i = 0; i < node.children.length; i++) {
    var child = node.children[i];

    if (t.isLiteral(child) && typeof child.value === "string") {
      cleanJSXElementLiteralChild(child, elems);
      continue;
    }

    if (t.isJSXExpressionContainer(child)) child = child.expression;
    if (t.isJSXEmptyExpression(child)) continue;

    elems.push(child);
  }

  return elems;
}
},{"../../types":354}],238:[function(require,module,exports){
"use strict";

exports.__esModule = true;
exports.is = is;
exports.pullFlag = pullFlag;
// istanbul ignore next

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj["default"] = obj; return newObj; } }

// istanbul ignore next

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

var _lodashArrayPull = require("lodash/array/pull");

var _lodashArrayPull2 = _interopRequireDefault(_lodashArrayPull);

var _types = require("../../types");

var t = _interopRequireWildcard(_types);

/**
 * [Please add a description.]
 */

function is(node, flag) {
  return t.isLiteral(node) && node.regex && node.regex.flags.indexOf(flag) >= 0;
}

/**
 * [Please add a description.]
 */

function pullFlag(node, flag) {
  var flags = node.regex.flags.split("");
  if (node.regex.flags.indexOf(flag) < 0) return;
  _lodashArrayPull2["default"](flags, flag);
  node.regex.flags = flags.join("");
}
},{"../../types":354,"lodash/array/pull":750}],239:[function(require,module,exports){
"use strict";

exports.__esModule = true;
// istanbul ignore next

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj["default"] = obj; return newObj; } }

var _types = require("../../types");

var t = _interopRequireWildcard(_types);

/**
 * [Please add a description.]
 */

var awaitVisitor = {

  /**
   * [Please add a description.]
   */

  Function: function Function() {
    this.skip();
  },

  /**
   * [Please add a description.]
   */

  AwaitExpression: function AwaitExpression(node) {
    node.type = "YieldExpression";

    if (node.all) {
      // await* foo; -> yield Promise.all(foo);
      node.all = false;
      node.argument = t.callExpression(t.memberExpression(t.identifier("Promise"), t.identifier("all")), [node.argument]);
    }
  }
};

/**
 * [Please add a description.]
 */

var referenceVisitor = {

  /**
   * [Please add a description.]
   */

  ReferencedIdentifier: function ReferencedIdentifier(node, parent, scope, state) {
    var name = state.id.name;
    if (node.name === name && scope.bindingIdentifierEquals(name, state.id)) {
      return state.ref = state.ref || scope.generateUidIdentifier(name);
    }
  }
};

/**
 * [Please add a description.]
 */

exports["default"] = function (path, callId) {
  var node = path.node;

  node.async = false;
  node.generator = true;

  path.traverse(awaitVisitor, state);

  var call = t.callExpression(callId, [node]);

  var id = node.id;
  node.id = null;

  if (t.isFunctionDeclaration(node)) {
    var declar = t.variableDeclaration("let", [t.variableDeclarator(id, call)]);
    declar._blockHoist = true;
    return declar;
  } else {
    if (id) {
      var state = { id: id };
      path.traverse(referenceVisitor, state);

      if (state.ref) {
        path.scope.parent.push({ id: state.ref });
        return t.assignmentExpression("=", state.ref, call);
      }
    }

    return call;
  }
};

module.exports = exports["default"];
},{"../../types":354}],240:[function(require,module,exports){
"use strict";

exports.__esModule = true;
// istanbul ignore next

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj["default"] = obj; return newObj; } }

// istanbul ignore next

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var _messages = require("../../messages");

var messages = _interopRequireWildcard(_messages);

var _types = require("../../types");

var t = _interopRequireWildcard(_types);

/**
 * [Please add a description.]
 */

function isIllegalBareSuper(node, parent) {
  if (!t.isSuper(node)) return false;
  if (t.isMemberExpression(parent, { computed: false })) return false;
  if (t.isCallExpression(parent, { callee: node })) return false;
  return true;
}

/**
 * [Please add a description.]
 */

function isMemberExpressionSuper(node) {
  return t.isMemberExpression(node) && t.isSuper(node.object);
}

/**
 * [Please add a description.]
 */

var visitor = {

  /**
   * [Please add a description.]
   */

  enter: function enter(node, parent, scope, state) {
    var topLevel = state.topLevel;
    var self = state.self;

    if (t.isFunction(node) && !t.isArrowFunctionExpression(node)) {
      // we need to call traverseLevel again so we're context aware
      self.traverseLevel(this, false);
      return this.skip();
    }

    if (t.isProperty(node, { method: true }) || t.isMethodDefinition(node)) {
      // break on object methods
      return this.skip();
    }

    var getThisReference = topLevel ?
    // top level so `this` is the instance
    t.thisExpression :
    // not in the top level so we need to create a reference
    self.getThisReference.bind(self);

    var callback = self.specHandle;
    if (self.isLoose) callback = self.looseHandle;
    var result = callback.call(self, this, getThisReference);
    if (result) this.hasSuper = true;
    if (result === true) return;
    return result;
  }
};

/**
 * [Please add a description.]
 */

var ReplaceSupers = (function () {
  function ReplaceSupers(opts) {
    var inClass = arguments.length <= 1 || arguments[1] === undefined ? false : arguments[1];

    _classCallCheck(this, ReplaceSupers);

    this.topLevelThisReference = opts.topLevelThisReference;
    this.methodPath = opts.methodPath;
    this.methodNode = opts.methodNode;
    this.superRef = opts.superRef;
    this.isStatic = opts.isStatic;
    this.hasSuper = false;
    this.inClass = inClass;
    this.isLoose = opts.isLoose;
    this.scope = opts.scope;
    this.file = opts.file;
    this.opts = opts;
  }

  /**
   * [Please add a description.]
   */

  ReplaceSupers.prototype.getObjectRef = function getObjectRef() {
    return this.opts.objectRef || this.opts.getObjectRef();
  };

  /**
   * Sets a super class value of the named property.
   *
   * @example
   *
   *   _set(Object.getPrototypeOf(CLASS.prototype), "METHOD", "VALUE", this)
   *
   */

  ReplaceSupers.prototype.setSuperProperty = function setSuperProperty(property, value, isComputed, thisExpression) {
    return t.callExpression(this.file.addHelper("set"), [t.callExpression(t.memberExpression(t.identifier("Object"), t.identifier("getPrototypeOf")), [this.isStatic ? this.getObjectRef() : t.memberExpression(this.getObjectRef(), t.identifier("prototype"))]), isComputed ? property : t.literal(property.name), value, thisExpression]);
  };

  /**
   * Gets a node representing the super class value of the named property.
   *
   * @example
   *
   *   _get(Object.getPrototypeOf(CLASS.prototype), "METHOD", this)
   *
   */

  ReplaceSupers.prototype.getSuperProperty = function getSuperProperty(property, isComputed, thisExpression) {
    return t.callExpression(this.file.addHelper("get"), [t.callExpression(t.memberExpression(t.identifier("Object"), t.identifier("getPrototypeOf")), [this.isStatic ? this.getObjectRef() : t.memberExpression(this.getObjectRef(), t.identifier("prototype"))]), isComputed ? property : t.literal(property.name), thisExpression]);
  };

  /**
   * [Please add a description.]
   */

  ReplaceSupers.prototype.replace = function replace() {
    this.traverseLevel(this.methodPath.get("value"), true);
  };

  /**
   * [Please add a description.]
   */

  ReplaceSupers.prototype.traverseLevel = function traverseLevel(path, topLevel) {
    var state = { self: this, topLevel: topLevel };
    path.traverse(visitor, state);
  };

  /**
   * [Please add a description.]
   */

  ReplaceSupers.prototype.getThisReference = function getThisReference() {
    if (this.topLevelThisReference) {
      return this.topLevelThisReference;
    } else {
      var ref = this.topLevelThisReference = this.scope.generateUidIdentifier("this");
      this.methodNode.value.body.body.unshift(t.variableDeclaration("var", [t.variableDeclarator(this.topLevelThisReference, t.thisExpression())]));
      return ref;
    }
  };

  /**
   * [Please add a description.]
   */

  ReplaceSupers.prototype.getLooseSuperProperty = function getLooseSuperProperty(id, parent) {
    var methodNode = this.methodNode;
    var methodName = methodNode.key;
    var superRef = this.superRef || t.identifier("Function");

    if (parent.property === id) {
      return;
    } else if (t.isCallExpression(parent, { callee: id })) {
      // super(); -> objectRef.prototype.MethodName.call(this);
      parent.arguments.unshift(t.thisExpression());

      if (methodName.name === "constructor") {
        // constructor() { super(); }
        if (parent.arguments.length === 2 && t.isSpreadElement(parent.arguments[1]) && t.isIdentifier(parent.arguments[1].argument, { name: "arguments" })) {
          // special case single arguments spread
          parent.arguments[1] = parent.arguments[1].argument;
          return t.memberExpression(superRef, t.identifier("apply"));
        } else {
          return t.memberExpression(superRef, t.identifier("call"));
        }
      } else {
        id = superRef;

        // foo() { super(); }
        if (!methodNode["static"]) {
          id = t.memberExpression(id, t.identifier("prototype"));
        }

        id = t.memberExpression(id, methodName, methodNode.computed);
        return t.memberExpression(id, t.identifier("call"));
      }
    } else if (t.isMemberExpression(parent) && !methodNode["static"]) {
      // super.test -> objectRef.prototype.test
      return t.memberExpression(superRef, t.identifier("prototype"));
    } else {
      return superRef;
    }
  };

  /**
   * [Please add a description.]
   */

  ReplaceSupers.prototype.looseHandle = function looseHandle(path, getThisReference) {
    var node = path.node;
    if (path.isSuper()) {
      return this.getLooseSuperProperty(node, path.parent);
    } else if (path.isCallExpression()) {
      var callee = node.callee;
      if (!t.isMemberExpression(callee)) return;
      if (!t.isSuper(callee.object)) return;

      // super.test(); -> objectRef.prototype.MethodName.call(this);
      t.appendToMemberExpression(callee, t.identifier("call"));
      node.arguments.unshift(getThisReference());
      return true;
    }
  };

  /**
   * [Please add a description.]
   */

  ReplaceSupers.prototype.specHandleAssignmentExpression = function specHandleAssignmentExpression(ref, path, node, getThisReference) {
    if (node.operator === "=") {
      // super.name = "val"; -> _set(Object.getPrototypeOf(objectRef.prototype), "name", this);
      return this.setSuperProperty(node.left.property, node.right, node.left.computed, getThisReference());
    } else {
      // super.age += 2; -> var _ref = super.age; super.age = _ref + 2;
      ref = ref || path.scope.generateUidIdentifier("ref");
      return [t.variableDeclaration("var", [t.variableDeclarator(ref, node.left)]), t.expressionStatement(t.assignmentExpression("=", node.left, t.binaryExpression(node.operator[0], ref, node.right)))];
    }
  };

  /**
   * [Please add a description.]
   */

  ReplaceSupers.prototype.specHandle = function specHandle(path, getThisReference) {
    var methodNode = this.methodNode;
    var property;
    var computed;
    var args;
    var thisReference;

    var parent = path.parent;
    var node = path.node;

    if (isIllegalBareSuper(node, parent)) {
      throw path.errorWithNode(messages.get("classesIllegalBareSuper"));
    }

    if (t.isCallExpression(node)) {
      var callee = node.callee;
      if (t.isSuper(callee)) {
        // super(); -> _get(Object.getPrototypeOf(objectRef), "MethodName", this).call(this);
        property = methodNode.key;
        computed = methodNode.computed;
        args = node.arguments;

        // bare `super` call is illegal inside non-constructors
        //  - https://esdiscuss.org/topic/super-call-in-methods
        //  - https://twitter.com/wycats/status/544553184396836864
        if (methodNode.key.name !== "constructor" || !this.inClass) {
          var methodName = methodNode.key.name || "METHOD_NAME";
          throw this.file.errorWithNode(node, messages.get("classesIllegalSuperCall", methodName));
        }
      } else if (isMemberExpressionSuper(callee)) {
        // super.test(); -> _get(Object.getPrototypeOf(objectRef.prototype), "test", this).call(this);
        property = callee.property;
        computed = callee.computed;
        args = node.arguments;
      }
    } else if (t.isMemberExpression(node) && t.isSuper(node.object)) {
      // super.name; -> _get(Object.getPrototypeOf(objectRef.prototype), "name", this);
      property = node.property;
      computed = node.computed;
    } else if (t.isUpdateExpression(node) && isMemberExpressionSuper(node.argument)) {
      var binary = t.binaryExpression(node.operator[0], node.argument, t.literal(1));
      if (node.prefix) {
        // ++super.foo; -> super.foo += 1;
        return this.specHandleAssignmentExpression(null, path, binary, getThisReference);
      } else {
        // super.foo++; -> var _ref = super.foo; super.foo = _ref + 1;
        var ref = path.scope.generateUidIdentifier("ref");
        return this.specHandleAssignmentExpression(ref, path, binary, getThisReference).concat(t.expressionStatement(ref));
      }
    } else if (t.isAssignmentExpression(node) && isMemberExpressionSuper(node.left)) {
      return this.specHandleAssignmentExpression(null, path, node, getThisReference);
    }

    if (!property) return;

    thisReference = getThisReference();
    var superProperty = this.getSuperProperty(property, computed, thisReference);
    if (args) {
      if (args.length === 1 && t.isSpreadElement(args[0])) {
        // super(...arguments);
        return t.callExpression(t.memberExpression(superProperty, t.identifier("apply")), [thisReference, args[0].argument]);
      } else {
        return t.callExpression(t.memberExpression(superProperty, t.identifier("call")), [thisReference].concat(args));
      }
    } else {
      return superProperty;
    }
  };

  return ReplaceSupers;
})();

exports["default"] = ReplaceSupers;
module.exports = exports["default"];
},{"../../messages":218,"../../types":354}],241:[function(require,module,exports){
"use strict";

exports.__esModule = true;
// istanbul ignore next

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj["default"] = obj; return newObj; } }

// istanbul ignore next

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

var _pipeline = require("./pipeline");

var _pipeline2 = _interopRequireDefault(_pipeline);

/**
 * [Please add a description.]
 */

/**
 * [Please add a description.]
 */

var _transformers = require("./transformers");

var _transformers2 = _interopRequireDefault(_transformers);

/**
 * [Please add a description.]
 */

var _transformersDeprecated = require("./transformers/deprecated");

var _transformersDeprecated2 = _interopRequireDefault(_transformersDeprecated);

/**
 * [Please add a description.]
 */

var _transformersAliases = require("./transformers/aliases");

var _transformersAliases2 = _interopRequireDefault(_transformersAliases);

/**
 * [Please add a description.]
 */

var _transformersFilters = require("./transformers/filters");

var filters = _interopRequireWildcard(_transformersFilters);

var pipeline = new _pipeline2["default"]();

for (var key in _transformers2["default"]) {
  var transformer = _transformers2["default"][key];

  if (typeof transformer === "object") {
    var metadata = transformer.metadata = transformer.metadata || {};
    metadata.group = metadata.group || "builtin-basic";
  }
}

pipeline.addTransformers(_transformers2["default"]);
pipeline.addDeprecated(_transformersDeprecated2["default"]);
pipeline.addAliases(_transformersAliases2["default"]);
pipeline.addFilter(filters.internal);
pipeline.addFilter(filters.blacklist);
pipeline.addFilter(filters.whitelist);
pipeline.addFilter(filters.stage);
pipeline.addFilter(filters.optional);

/**
 * [Please add a description.]
 */

var transform = pipeline.transform.bind(pipeline);
transform.fromAst = pipeline.transformFromAst.bind(pipeline);
transform.pipeline = pipeline;
exports["default"] = transform;
module.exports = exports["default"];
},{"./pipeline":255,"./transformers":301,"./transformers/aliases":259,"./transformers/deprecated":260,"./transformers/filters":300}],242:[function(require,module,exports){
"use strict";

exports.__esModule = true;
// istanbul ignore next

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

// istanbul ignore next

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj["default"] = obj; return newObj; } }

// istanbul ignore next

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var _libMetadata = require("./lib/metadata");

var metadataVisitor = _interopRequireWildcard(_libMetadata);

var _messages = require("../../messages");

var messages = _interopRequireWildcard(_messages);

var _libRemaps = require("./lib/remaps");

var _libRemaps2 = _interopRequireDefault(_libRemaps);

var _helpersObject = require("../../helpers/object");

var _helpersObject2 = _interopRequireDefault(_helpersObject);

var _util = require("../../util");

var util = _interopRequireWildcard(_util);

var _types = require("../../types");

var t = _interopRequireWildcard(_types);

/**
 * [Please add a description.]
 */

var DefaultFormatter = (function () {
  function DefaultFormatter(file) {
    _classCallCheck(this, DefaultFormatter);

    // object containg all module sources with the scope that they're contained in
    this.sourceScopes = _helpersObject2["default"]();

    // ids for use in module ids
    this.defaultIds = _helpersObject2["default"]();
    this.ids = _helpersObject2["default"]();

    // contains reference aliases for live bindings
    this.remaps = new _libRemaps2["default"](file, this);

    this.scope = file.scope;
    this.file = file;

    this.hasNonDefaultExports = false;

    this.hasLocalExports = false;
    this.hasLocalImports = false;

    this.localExports = _helpersObject2["default"]();
    this.localImports = _helpersObject2["default"]();

    this.metadata = file.metadata.modules;
    this.getMetadata();
  }

  /**
   * [Please add a description.]
   */

  DefaultFormatter.prototype.addScope = function addScope(path) {
    var source = path.node.source && path.node.source.value;
    if (!source) return;

    var existingScope = this.sourceScopes[source];
    if (existingScope && existingScope !== path.scope) {
      throw path.errorWithNode(messages.get("modulesDuplicateDeclarations"));
    }

    this.sourceScopes[source] = path.scope;
  };

  /**
   * [Please add a description.]
   */

  DefaultFormatter.prototype.isModuleType = function isModuleType(node, type) {
    var modules = this.file.dynamicImportTypes[type];
    return modules && modules.indexOf(node) >= 0;
  };

  /**
   * [Please add a description.]
   */

  DefaultFormatter.prototype.transform = function transform() {
    this.remapAssignments();
  };

  /**
   * [Please add a description.]
   */

  DefaultFormatter.prototype.doDefaultExportInterop = function doDefaultExportInterop(node) {
    return (t.isExportDefaultDeclaration(node) || t.isSpecifierDefault(node)) && !this.noInteropRequireExport && !this.hasNonDefaultExports;
  };

  /**
   * [Please add a description.]
   */

  DefaultFormatter.prototype.getMetadata = function getMetadata() {
    var has = false;
    var _arr = this.file.ast.program.body;
    for (var _i = 0; _i < _arr.length; _i++) {
      var node = _arr[_i];
      if (t.isModuleDeclaration(node)) {
        has = true;
        break;
      }
    }
    if (has || this.isLoose()) {
      this.file.path.traverse(metadataVisitor, this);
    }
  };

  /**
   * [Please add a description.]
   */

  DefaultFormatter.prototype.remapAssignments = function remapAssignments() {
    if (this.hasLocalExports || this.hasLocalImports) {
      this.remaps.run();
    }
  };

  /**
   * [Please add a description.]
   */

  DefaultFormatter.prototype.remapExportAssignment = function remapExportAssignment(node, exported) {
    var assign = node;

    for (var i = 0; i < exported.length; i++) {
      assign = t.assignmentExpression("=", t.memberExpression(t.identifier("exports"), exported[i]), assign);
    }

    return assign;
  };

  /**
   * [Please add a description.]
   */

  DefaultFormatter.prototype._addExport = function _addExport(name, exported) {
    var info = this.localExports[name] = this.localExports[name] || {
      binding: this.scope.getBindingIdentifier(name),
      exported: []
    };
    info.exported.push(exported);
  };

  /**
   * [Please add a description.]
   */

  DefaultFormatter.prototype.getExport = function getExport(node, scope) {
    if (!t.isIdentifier(node)) return;

    var local = this.localExports[node.name];
    if (local && local.binding === scope.getBindingIdentifier(node.name)) {
      return local.exported;
    }
  };

  /**
   * [Please add a description.]
   */

  DefaultFormatter.prototype.getModuleName = function getModuleName() {
    var opts = this.file.opts;
    // moduleId is n/a if a `getModuleId()` is provided
    if (opts.moduleId != null && !opts.getModuleId) {
      return opts.moduleId;
    }

    var filenameRelative = opts.filenameRelative;
    var moduleName = "";

    if (opts.moduleRoot != null) {
      moduleName = opts.moduleRoot + "/";
    }

    if (!opts.filenameRelative) {
      return moduleName + opts.filename.replace(/^\//, "");
    }

    if (opts.sourceRoot != null) {
      // remove sourceRoot from filename
      var sourceRootRegEx = new RegExp("^" + opts.sourceRoot + "\/?");
      filenameRelative = filenameRelative.replace(sourceRootRegEx, "");
    }

    if (!opts.keepModuleIdExtensions) {
      // remove extension
      filenameRelative = filenameRelative.replace(/\.(\w*?)$/, "");
    }

    moduleName += filenameRelative;

    // normalize path separators
    moduleName = moduleName.replace(/\\/g, "/");

    if (opts.getModuleId) {
      // If return is falsy, assume they want us to use our generated default name
      return opts.getModuleId(moduleName) || moduleName;
    } else {
      return moduleName;
    }
  };

  /**
   * [Please add a description.]
   */

  DefaultFormatter.prototype._pushStatement = function _pushStatement(ref, nodes) {
    if (t.isClass(ref) || t.isFunction(ref)) {
      if (ref.id) {
        nodes.push(t.toStatement(ref));
        ref = ref.id;
      }
    }

    return ref;
  };

  /**
   * [Please add a description.]
   */

  DefaultFormatter.prototype._hoistExport = function _hoistExport(declar, assign, priority) {
    if (t.isFunctionDeclaration(declar)) {
      assign._blockHoist = priority || 2;
    }

    return assign;
  };

  /**
   * [Please add a description.]
   */

  DefaultFormatter.prototype.getExternalReference = function getExternalReference(node, nodes) {
    var ids = this.ids;
    var id = node.source.value;

    if (ids[id]) {
      return ids[id];
    } else {
      return this.ids[id] = this._getExternalReference(node, nodes);
    }
  };

  /**
   * [Please add a description.]
   */

  DefaultFormatter.prototype.checkExportIdentifier = function checkExportIdentifier(node) {
    if (t.isIdentifier(node, { name: "__esModule" })) {
      throw this.file.errorWithNode(node, messages.get("modulesIllegalExportName", node.name));
    }
  };

  /**
   * [Please add a description.]
   */

  DefaultFormatter.prototype.exportAllDeclaration = function exportAllDeclaration(node, nodes) {
    var ref = this.getExternalReference(node, nodes);
    nodes.push(this.buildExportsWildcard(ref, node));
  };

  /**
   * [Please add a description.]
   */

  DefaultFormatter.prototype.isLoose = function isLoose() {
    return this.file.isLoose("es6.modules");
  };

  /**
   * [Please add a description.]
   */

  DefaultFormatter.prototype.exportSpecifier = function exportSpecifier(specifier, node, nodes) {
    if (node.source) {
      var ref = this.getExternalReference(node, nodes);

      if (specifier.local.name === "default" && !this.noInteropRequireExport) {
        // importing a default so we need to normalize it
        ref = t.callExpression(this.file.addHelper("interop-require"), [ref]);
      } else {
        ref = t.memberExpression(ref, specifier.local);

        if (!this.isLoose()) {
          nodes.push(this.buildExportsFromAssignment(specifier.exported, ref, node));
          return;
        }
      }

      // export { foo } from "test";
      nodes.push(this.buildExportsAssignment(specifier.exported, ref, node));
    } else {
      // export { foo };
      nodes.push(this.buildExportsAssignment(specifier.exported, specifier.local, node));
    }
  };

  /**
   * [Please add a description.]
   */

  DefaultFormatter.prototype.buildExportsWildcard = function buildExportsWildcard(objectIdentifier) {
    return t.expressionStatement(t.callExpression(this.file.addHelper("defaults"), [t.identifier("exports"), t.callExpression(this.file.addHelper("interop-export-wildcard"), [objectIdentifier, this.file.addHelper("defaults")])]));
  };

  /**
   * [Please add a description.]
   */

  DefaultFormatter.prototype.buildExportsFromAssignment = function buildExportsFromAssignment(id, init) {
    this.checkExportIdentifier(id);
    return util.template("exports-from-assign", {
      INIT: init,
      ID: t.literal(id.name)
    }, true);
  };

  /**
   * [Please add a description.]
   */

  DefaultFormatter.prototype.buildExportsAssignment = function buildExportsAssignment(id, init) {
    this.checkExportIdentifier(id);
    return util.template("exports-assign", {
      VALUE: init,
      KEY: id
    }, true);
  };

  /**
   * [Please add a description.]
   */

  DefaultFormatter.prototype.exportDeclaration = function exportDeclaration(node, nodes) {
    var declar = node.declaration;

    var id = declar.id;

    if (t.isExportDefaultDeclaration(node)) {
      id = t.identifier("default");
    }

    var assign;

    if (t.isVariableDeclaration(declar)) {
      for (var i = 0; i < declar.declarations.length; i++) {
        var decl = declar.declarations[i];

        decl.init = this.buildExportsAssignment(decl.id, decl.init, node).expression;

        var newDeclar = t.variableDeclaration(declar.kind, [decl]);
        if (i === 0) t.inherits(newDeclar, declar);
        nodes.push(newDeclar);
      }
    } else {
      var ref = declar;

      if (t.isFunctionDeclaration(declar) || t.isClassDeclaration(declar)) {
        ref = declar.id;
        nodes.push(declar);
      }

      assign = this.buildExportsAssignment(id, ref, node);

      nodes.push(assign);

      this._hoistExport(declar, assign);
    }
  };

  return DefaultFormatter;
})();

exports["default"] = DefaultFormatter;
module.exports = exports["default"];
},{"../../helpers/object":216,"../../messages":218,"../../types":354,"../../util":357,"./lib/metadata":250,"./lib/remaps":251}],243:[function(require,module,exports){
"use strict";

exports.__esModule = true;
// istanbul ignore next

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj["default"] = obj; return newObj; } }

var _util = require("../../util");

var util = _interopRequireWildcard(_util);

/**
 * [Please add a description.]
 */

exports["default"] = function (Parent) {
  var Constructor = function Constructor() {
    this.noInteropRequireImport = true;
    this.noInteropRequireExport = true;
    Parent.apply(this, arguments);
  };

  util.inherits(Constructor, Parent);

  return Constructor;
};

module.exports = exports["default"];
},{"../../util":357}],244:[function(require,module,exports){
"use strict";

exports.__esModule = true;
// istanbul ignore next

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

var _amd = require("./amd");

var _amd2 = _interopRequireDefault(_amd);

var _strict = require("./_strict");

var _strict2 = _interopRequireDefault(_strict);

/**
 * [Please add a description.]
 */

exports["default"] = _strict2["default"](_amd2["default"]);
module.exports = exports["default"];
},{"./_strict":243,"./amd":245}],245:[function(require,module,exports){
"use strict";

exports.__esModule = true;
// istanbul ignore next

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj["default"] = obj; return newObj; } }

// istanbul ignore next

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

// istanbul ignore next

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

// istanbul ignore next

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var _default = require("./_default");

var _default2 = _interopRequireDefault(_default);

var _common = require("./common");

var _common2 = _interopRequireDefault(_common);

var _lodashCollectionIncludes = require("lodash/collection/includes");

var _lodashCollectionIncludes2 = _interopRequireDefault(_lodashCollectionIncludes);

var _lodashObjectValues = require("lodash/object/values");

var _lodashObjectValues2 = _interopRequireDefault(_lodashObjectValues);

var _util = require("../../util");

var util = _interopRequireWildcard(_util);

var _types = require("../../types");

var t = _interopRequireWildcard(_types);

/**
 * [Please add a description.]
 */

var AMDFormatter = (function (_DefaultFormatter) {
  _inherits(AMDFormatter, _DefaultFormatter);

  function AMDFormatter() {
    _classCallCheck(this, AMDFormatter);

    _DefaultFormatter.apply(this, arguments);
  }

  /**
   * [Please add a description.]
   */

  AMDFormatter.prototype.setup = function setup() {
    _common2["default"].prototype._setup.call(this, this.hasNonDefaultExports);
  };

  /**
   * [Please add a description.]
   */

  AMDFormatter.prototype.buildDependencyLiterals = function buildDependencyLiterals() {
    var names = [];
    for (var name in this.ids) {
      names.push(t.literal(name));
    }
    return names;
  };

  /**
   * Wrap the entire body in a `define` wrapper.
   */

  AMDFormatter.prototype.transform = function transform(program) {
    _common2["default"].prototype.transform.apply(this, arguments);

    var body = program.body;

    // build an array of module names

    var names = [t.literal("exports")];
    if (this.passModuleArg) names.push(t.literal("module"));
    names = names.concat(this.buildDependencyLiterals());
    names = t.arrayExpression(names);

    // build up define container

    var params = _lodashObjectValues2["default"](this.ids);
    if (this.passModuleArg) params.unshift(t.identifier("module"));
    params.unshift(t.identifier("exports"));

    var container = t.functionExpression(null, params, t.blockStatement(body));

    var defineArgs = [names, container];
    var moduleName = this.getModuleName();
    if (moduleName) defineArgs.unshift(t.literal(moduleName));

    var call = t.callExpression(t.identifier("define"), defineArgs);

    program.body = [t.expressionStatement(call)];
  };

  /**
   * Get the AMD module name that we'll prepend to the wrapper
   * to define this module
   */

  AMDFormatter.prototype.getModuleName = function getModuleName() {
    if (this.file.opts.moduleIds) {
      return _default2["default"].prototype.getModuleName.apply(this, arguments);
    } else {
      return null;
    }
  };

  /**
   * [Please add a description.]
   */

  AMDFormatter.prototype._getExternalReference = function _getExternalReference(node) {
    return this.scope.generateUidIdentifier(node.source.value);
  };

  /**
   * [Please add a description.]
   */

  AMDFormatter.prototype.importDeclaration = function importDeclaration(node) {
    this.getExternalReference(node);
  };

  /**
   * [Please add a description.]
   */

  AMDFormatter.prototype.importSpecifier = function importSpecifier(specifier, node, nodes, scope) {
    var key = node.source.value;
    var ref = this.getExternalReference(node);

    if (t.isImportNamespaceSpecifier(specifier) || t.isImportDefaultSpecifier(specifier)) {
      this.defaultIds[key] = specifier.local;
    }

    if (this.isModuleType(node, "absolute")) {
      // absolute module reference
    } else if (this.isModuleType(node, "absoluteDefault")) {
        // prevent unnecessary renaming of dynamic imports
        this.ids[node.source.value] = ref;
        ref = t.memberExpression(ref, t.identifier("default"));
      } else if (t.isImportNamespaceSpecifier(specifier)) {
        // import * as bar from "foo";
      } else if (!_lodashCollectionIncludes2["default"](this.file.dynamicImported, node) && t.isSpecifierDefault(specifier) && !this.noInteropRequireImport) {
          // import foo from "foo";
          var uid = scope.generateUidIdentifier(specifier.local.name);
          nodes.push(t.variableDeclaration("var", [t.variableDeclarator(uid, t.callExpression(this.file.addHelper("interop-require-default"), [ref]))]));
          ref = t.memberExpression(uid, t.identifier("default"));
        } else {
          // import { foo } from "foo";
          var imported = specifier.imported;
          if (t.isSpecifierDefault(specifier)) imported = t.identifier("default");
          ref = t.memberExpression(ref, imported);
        }

    this.remaps.add(scope, specifier.local.name, ref);
  };

  /**
   * [Please add a description.]
   */

  AMDFormatter.prototype.exportSpecifier = function exportSpecifier(specifier, node, nodes) {
    if (this.doDefaultExportInterop(specifier)) {
      this.passModuleArg = true;

      if (specifier.exported !== specifier.local && !node.source) {
        nodes.push(util.template("exports-default-assign", {
          VALUE: specifier.local
        }, true));
        return;
      }
    }

    _common2["default"].prototype.exportSpecifier.apply(this, arguments);
  };

  /**
   * [Please add a description.]
   */

  AMDFormatter.prototype.exportDeclaration = function exportDeclaration(node, nodes) {
    if (this.doDefaultExportInterop(node)) {
      this.passModuleArg = true;

      var declar = node.declaration;
      var assign = util.template("exports-default-assign", {
        VALUE: this._pushStatement(declar, nodes)
      }, true);

      if (t.isFunctionDeclaration(declar)) {
        // we can hoist this assignment to the top of the file
        assign._blockHoist = 3;
      }

      nodes.push(assign);
      return;
    }

    _default2["default"].prototype.exportDeclaration.apply(this, arguments);
  };

  return AMDFormatter;
})(_default2["default"]);

exports["default"] = AMDFormatter;
module.exports = exports["default"];
},{"../../types":354,"../../util":357,"./_default":242,"./common":247,"lodash/collection/includes":755,"lodash/object/values":860}],246:[function(require,module,exports){
"use strict";

exports.__esModule = true;
// istanbul ignore next

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

var _common = require("./common");

var _common2 = _interopRequireDefault(_common);

var _strict = require("./_strict");

var _strict2 = _interopRequireDefault(_strict);

/**
 * [Please add a description.]
 */

exports["default"] = _strict2["default"](_common2["default"]);
module.exports = exports["default"];
},{"./_strict":243,"./common":247}],247:[function(require,module,exports){
"use strict";

exports.__esModule = true;
// istanbul ignore next

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj["default"] = obj; return newObj; } }

// istanbul ignore next

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

// istanbul ignore next

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

// istanbul ignore next

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var _default = require("./_default");

var _default2 = _interopRequireDefault(_default);

var _util = require("../../util");

var util = _interopRequireWildcard(_util);

var _types = require("../../types");

var t = _interopRequireWildcard(_types);

/**
 * [Please add a description.]
 */

var CommonJSFormatter = (function (_DefaultFormatter) {
  _inherits(CommonJSFormatter, _DefaultFormatter);

  function CommonJSFormatter() {
    _classCallCheck(this, CommonJSFormatter);

    _DefaultFormatter.apply(this, arguments);
  }

  /**
   * [Please add a description.]
   */

  CommonJSFormatter.prototype.setup = function setup() {
    this._setup(this.hasLocalExports);
  };

  /**
   * [Please add a description.]
   */

  CommonJSFormatter.prototype._setup = function _setup(conditional) {
    var file = this.file;
    var scope = file.scope;

    scope.rename("module");
    scope.rename("exports");

    if (!this.noInteropRequireImport && conditional) {
      var templateName = "exports-module-declaration";
      if (this.file.isLoose("es6.modules")) templateName += "-loose";
      var declar = util.template(templateName, true);
      declar._blockHoist = 3;
      file.path.unshiftContainer("body", [declar]);
    }
  };

  /**
   * [Please add a description.]
   */

  CommonJSFormatter.prototype.transform = function transform(program) {
    _default2["default"].prototype.transform.apply(this, arguments);

    if (this.hasDefaultOnlyExport) {
      program.body.push(t.expressionStatement(t.assignmentExpression("=", t.memberExpression(t.identifier("module"), t.identifier("exports")), t.memberExpression(t.identifier("exports"), t.identifier("default")))));
    }
  };

  /**
   * [Please add a description.]
   */

  CommonJSFormatter.prototype.importSpecifier = function importSpecifier(specifier, node, nodes, scope) {
    var variableName = specifier.local;

    var ref = this.getExternalReference(node, nodes);

    // import foo from "foo";
    if (t.isSpecifierDefault(specifier)) {
      if (this.isModuleType(node, "absolute")) {
        // absolute module reference
      } else if (this.isModuleType(node, "absoluteDefault")) {
          this.remaps.add(scope, variableName.name, ref);
        } else if (this.noInteropRequireImport) {
          this.remaps.add(scope, variableName.name, t.memberExpression(ref, t.identifier("default")));
        } else {
          var uid = this.scope.generateUidIdentifierBasedOnNode(node, "import");

          nodes.push(t.variableDeclaration("var", [t.variableDeclarator(uid, t.callExpression(this.file.addHelper("interop-require-default"), [ref]))]));

          this.remaps.add(scope, variableName.name, t.memberExpression(uid, t.identifier("default")));
        }
    } else {
      if (t.isImportNamespaceSpecifier(specifier)) {
        if (!this.noInteropRequireImport) {
          ref = t.callExpression(this.file.addHelper("interop-require-wildcard"), [ref]);
        }

        // import * as bar from "foo";
        nodes.push(t.variableDeclaration("var", [t.variableDeclarator(variableName, ref)]));
      } else {
        // import { foo } from "foo";
        this.remaps.add(scope, variableName.name, t.memberExpression(ref, t.identifier(specifier.imported.name)));
      }
    }
  };

  /**
   * [Please add a description.]
   */

  CommonJSFormatter.prototype.importDeclaration = function importDeclaration(node, nodes) {
    // import "foo";
    nodes.push(util.template("require", {
      MODULE_NAME: node.source
    }, true));
  };

  /**
   * [Please add a description.]
   */

  CommonJSFormatter.prototype.exportSpecifier = function exportSpecifier(specifier) {
    if (this.doDefaultExportInterop(specifier)) {
      this.hasDefaultOnlyExport = true;
    }

    _default2["default"].prototype.exportSpecifier.apply(this, arguments);
  };

  /**
   * [Please add a description.]
   */

  CommonJSFormatter.prototype.exportDeclaration = function exportDeclaration(node) {
    if (this.doDefaultExportInterop(node)) {
      this.hasDefaultOnlyExport = true;
    }

    _default2["default"].prototype.exportDeclaration.apply(this, arguments);
  };

  /**
   * [Please add a description.]
   */

  CommonJSFormatter.prototype._getExternalReference = function _getExternalReference(node, nodes) {
    var call = t.callExpression(t.identifier("require"), [node.source]);
    var uid;

    if (this.isModuleType(node, "absolute")) {
      // absolute module reference
    } else if (this.isModuleType(node, "absoluteDefault")) {
        call = t.memberExpression(call, t.identifier("default"));
      } else {
        uid = this.scope.generateUidIdentifierBasedOnNode(node, "import");
      }

    uid = uid || node.specifiers[0].local;

    var declar = t.variableDeclaration("var", [t.variableDeclarator(uid, call)]);
    nodes.push(declar);
    return uid;
  };

  return CommonJSFormatter;
})(_default2["default"]);

exports["default"] = CommonJSFormatter;
module.exports = exports["default"];
},{"../../types":354,"../../util":357,"./_default":242}],248:[function(require,module,exports){
"use strict";

exports.__esModule = true;
// istanbul ignore next

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj["default"] = obj; return newObj; } }

// istanbul ignore next

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

// istanbul ignore next

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

// istanbul ignore next

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var _default = require("./_default");

var _default2 = _interopRequireDefault(_default);

var _types = require("../../types");

var t = _interopRequireWildcard(_types);

/**
 * [Please add a description.]
 */

var IgnoreFormatter = (function (_DefaultFormatter) {
  _inherits(IgnoreFormatter, _DefaultFormatter);

  function IgnoreFormatter() {
    _classCallCheck(this, IgnoreFormatter);

    _DefaultFormatter.apply(this, arguments);
  }

  /**
   * [Please add a description.]
   */

  IgnoreFormatter.prototype.exportDeclaration = function exportDeclaration(node, nodes) {
    var declar = t.toStatement(node.declaration, true);
    if (declar) nodes.push(t.inherits(declar, node));
  };

  /**
   * [Please add a description.]
   */

  IgnoreFormatter.prototype.exportAllDeclaration = function exportAllDeclaration() {};

  IgnoreFormatter.prototype.importDeclaration = function importDeclaration() {};

  IgnoreFormatter.prototype.importSpecifier = function importSpecifier() {};

  IgnoreFormatter.prototype.exportSpecifier = function exportSpecifier() {};

  IgnoreFormatter.prototype.transform = function transform() {};

  return IgnoreFormatter;
})(_default2["default"]);

exports["default"] = IgnoreFormatter;
module.exports = exports["default"];
},{"../../types":354,"./_default":242}],249:[function(require,module,exports){
/**
 * [Please add a description.]
 */

"use strict";

exports.__esModule = true;
exports["default"] = {
  commonStrict: require("./common-strict"),
  amdStrict: require("./amd-strict"),
  umdStrict: require("./umd-strict"),
  common: require("./common"),
  system: require("./system"),
  ignore: require("./ignore"),
  amd: require("./amd"),
  umd: require("./umd")
};
module.exports = exports["default"];
},{"./amd":245,"./amd-strict":244,"./common":247,"./common-strict":246,"./ignore":248,"./system":252,"./umd":254,"./umd-strict":253}],250:[function(require,module,exports){
"use strict";

exports.__esModule = true;
exports.ExportDeclaration = ExportDeclaration;
exports.Scope = Scope;
// istanbul ignore next

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj["default"] = obj; return newObj; } }

// istanbul ignore next

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

var _lodashObjectExtend = require("lodash/object/extend");

var _lodashObjectExtend2 = _interopRequireDefault(_lodashObjectExtend);

var _types = require("../../../types");

var t = _interopRequireWildcard(_types);

/**
 * [Please add a description.]
 */

var ModuleDeclaration = {
  enter: function enter(node, parent, scope, formatter) {
    if (node.source) {
      node.source.value = formatter.file.resolveModuleSource(node.source.value);
      formatter.addScope(this);
    }
  }
};

exports.ModuleDeclaration = ModuleDeclaration;
/**
 * [Please add a description.]
 */

var ImportDeclaration = {
  exit: function exit(node, parent, scope, formatter) {
    formatter.hasLocalImports = true;

    var specifiers = [];
    var imported = [];
    formatter.metadata.imports.push({
      source: node.source.value,
      imported: imported,
      specifiers: specifiers
    });

    var _arr = this.get("specifiers");

    for (var _i = 0; _i < _arr.length; _i++) {
      var specifier = _arr[_i];
      var ids = specifier.getBindingIdentifiers();
      _lodashObjectExtend2["default"](formatter.localImports, ids);

      var local = specifier.node.local.name;

      if (specifier.isImportDefaultSpecifier()) {
        imported.push("default");
        specifiers.push({
          kind: "named",
          imported: "default",
          local: local
        });
      }

      if (specifier.isImportSpecifier()) {
        var importedName = specifier.node.imported.name;
        imported.push(importedName);
        specifiers.push({
          kind: "named",
          imported: importedName,
          local: local
        });
      }

      if (specifier.isImportNamespaceSpecifier()) {
        imported.push("*");
        specifiers.push({
          kind: "namespace",
          local: local
        });
      }
    }
  }
};

exports.ImportDeclaration = ImportDeclaration;
/**
 * [Please add a description.]
 */

function ExportDeclaration(node, parent, scope, formatter) {
  formatter.hasLocalExports = true;

  var source = node.source ? node.source.value : null;
  var exports = formatter.metadata.exports;

  // export function foo() {}
  // export var foo = "bar";
  var declar = this.get("declaration");
  if (declar.isStatement()) {
    var bindings = declar.getBindingIdentifiers();

    for (var name in bindings) {
      var binding = bindings[name];
      formatter._addExport(name, binding);

      exports.exported.push(name);
      exports.specifiers.push({
        kind: "local",
        local: name,
        exported: this.isExportDefaultDeclaration() ? "default" : name
      });
    }
  }

  if (this.isExportNamedDeclaration() && node.specifiers) {
    var _arr2 = node.specifiers;

    for (var _i2 = 0; _i2 < _arr2.length; _i2++) {
      var specifier = _arr2[_i2];
      var exported = specifier.exported.name;
      exports.exported.push(exported);

      // export foo from "bar";
      if (t.isExportDefaultSpecifier(specifier)) {
        exports.specifiers.push({
          kind: "external",
          local: exported,
          exported: exported,
          source: source
        });
      }

      // export * as foo from "bar";
      if (t.isExportNamespaceSpecifier(specifier)) {
        exports.specifiers.push({
          kind: "external-namespace",
          exported: exported,
          source: source
        });
      }

      var local = specifier.local;
      if (!local) continue;

      formatter._addExport(local.name, specifier.exported);

      // export { foo } from "bar";
      // export { foo as bar } from "bar";
      if (source) {
        exports.specifiers.push({
          kind: "external",
          local: local.name,
          exported: exported,
          source: source
        });
      }

      // export { foo };
      // export { foo as bar };
      if (!source) {
        exports.specifiers.push({
          kind: "local",
          local: local.name,
          exported: exported
        });
      }
    }
  }

  // export * from "bar";
  if (this.isExportAllDeclaration()) {
    exports.specifiers.push({
      kind: "external-all",
      source: source
    });
  }

  if (!t.isExportDefaultDeclaration(node) && !declar.isTypeAlias()) {
    var onlyDefault = node.specifiers && node.specifiers.length === 1 && t.isSpecifierDefault(node.specifiers[0]);
    if (!onlyDefault) {
      formatter.hasNonDefaultExports = true;
    }
  }
}

/**
 * [Please add a description.]
 */

function Scope(node, parent, scope, formatter) {
  if (!formatter.isLoose()) {
    this.skip();
  }
}
},{"../../../types":354,"lodash/object/extend":854}],251:[function(require,module,exports){
"use strict";

exports.__esModule = true;
// istanbul ignore next

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj["default"] = obj; return newObj; } }

// istanbul ignore next

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var _types = require("../../../types");

var t = _interopRequireWildcard(_types);

/**
 * [Please add a description.]
 */

var remapVisitor = {

  /**
   * [Please add a description.]
   */

  enter: function enter(node) {
    if (node._skipModulesRemap) {
      return this.skip();
    }
  },

  /**
   * [Please add a description.]
   */

  ReferencedIdentifier: function ReferencedIdentifier(node, parent, scope, remaps) {
    var formatter = remaps.formatter;

    var remap = remaps.get(scope, node.name);
    if (!remap || node === remap) return;

    if (!scope.hasBinding(node.name) || scope.bindingIdentifierEquals(node.name, formatter.localImports[node.name])) {
      if (!formatter.isLoose() && this.key === "callee" && this.parentPath.isCallExpression()) {
        return t.sequenceExpression([t.literal(0), remap]);
      } else {
        return remap;
      }
    }
  },

  /**
   * [Please add a description.]
   */

  AssignmentExpression: {
    exit: function exit(node, parent, scope, _ref) {
      var formatter = _ref.formatter;

      if (!node._ignoreModulesRemap) {
        var exported = formatter.getExport(node.left, scope);
        if (exported) {
          return formatter.remapExportAssignment(node, exported);
        }
      }
    }
  },

  /**
   * [Please add a description.]
   */

  UpdateExpression: function UpdateExpression(node, parent, scope, _ref2) {
    var formatter = _ref2.formatter;

    var exported = formatter.getExport(node.argument, scope);
    if (!exported) return;

    this.skip();

    // expand to long file assignment expression
    var assign = t.assignmentExpression(node.operator[0] + "=", node.argument, t.literal(1));

    // remap this assignment expression
    var remapped = formatter.remapExportAssignment(assign, exported);

    // we don't need to change the result
    if (t.isExpressionStatement(parent) || node.prefix) {
      return remapped;
    }

    var nodes = [];
    nodes.push(remapped);

    var operator;
    if (node.operator === "--") {
      operator = "+";
    } else {
      // "++"
      operator = "-";
    }
    nodes.push(t.binaryExpression(operator, node.argument, t.literal(1)));

    return t.sequenceExpression(nodes);
  }
};

/**
 * [Please add a description.]
 */

var Remaps = (function () {
  function Remaps(file, formatter) {
    _classCallCheck(this, Remaps);

    this.formatter = formatter;
    this.file = file;
  }

  /**
   * [Please add a description.]
   */

  Remaps.prototype.run = function run() {
    this.file.path.traverse(remapVisitor, this);
  };

  /**
   * [Please add a description.]
   */

  Remaps.prototype._getKey = function _getKey(name) {
    return name + ":moduleRemap";
  };

  /**
   * [Please add a description.]
   */

  Remaps.prototype.get = function get(scope, name) {
    return scope.getData(this._getKey(name));
  };

  /**
   * [Please add a description.]
   */

  Remaps.prototype.add = function add(scope, name, val) {
    if (this.all) {
      this.all.push({
        name: name,
        scope: scope,
        node: val
      });
    }

    return scope.setData(this._getKey(name), val);
  };

  /**
   * [Please add a description.]
   */

  Remaps.prototype.remove = function remove(scope, name) {
    return scope.removeData(this._getKey(name));
  };

  /**
   * These methods are used by the system module formatter who needs access to all the remaps
   * so it can process them into it's specific setter method. We don't do this by default since
   * no other module formatters need access to this.
   */

  Remaps.prototype.getAll = function getAll() {
    return this.all;
  };

  /**
   * [Please add a description.]
   */

  Remaps.prototype.clearAll = function clearAll() {
    if (this.all) {
      var _arr = this.all;

      for (var _i = 0; _i < _arr.length; _i++) {
        var remap = _arr[_i];
        remap.scope.removeData(this._getKey(remap.name));
      }
    }

    this.all = [];
  };

  return Remaps;
})();

exports["default"] = Remaps;
module.exports = exports["default"];
},{"../../../types":354}],252:[function(require,module,exports){
"use strict";

exports.__esModule = true;
// istanbul ignore next

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj["default"] = obj; return newObj; } }

// istanbul ignore next

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

// istanbul ignore next

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

// istanbul ignore next

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var _default = require("./_default");

var _default2 = _interopRequireDefault(_default);

var _amd = require("./amd");

var _amd2 = _interopRequireDefault(_amd);

var _util = require("../../util");

var util = _interopRequireWildcard(_util);

var _lodashArrayLast = require("lodash/array/last");

var _lodashArrayLast2 = _interopRequireDefault(_lodashArrayLast);

var _lodashCollectionMap = require("lodash/collection/map");

var _lodashCollectionMap2 = _interopRequireDefault(_lodashCollectionMap);

var _types = require("../../types");

var t = _interopRequireWildcard(_types);

/**
 * [Please add a description.]
 */

var hoistVariablesVisitor = {

  /**
   * [Please add a description.]
   */

  Function: function Function() {
    // nothing inside is accessible
    this.skip();
  },

  /**
   * [Please add a description.]
   */

  VariableDeclaration: function VariableDeclaration(node, parent, scope, state) {
    if (node.kind !== "var" && !t.isProgram(parent)) {
      // let, const
      // can't be accessed
      return;
    }

    // ignore block hoisted nodes as these can be left in
    if (state.formatter._canHoist(node)) return;

    var nodes = [];

    for (var i = 0; i < node.declarations.length; i++) {
      var declar = node.declarations[i];
      state.hoistDeclarators.push(t.variableDeclarator(declar.id));
      if (declar.init) {
        // no initializer so we can just hoist it as-is
        var assign = t.expressionStatement(t.assignmentExpression("=", declar.id, declar.init));
        nodes.push(assign);
      }
    }

    // for (var i in test)
    if (t.isFor(parent) && parent.left === node) {
      return node.declarations[0].id;
    }

    return nodes;
  }
};

/**
 * [Please add a description.]
 */

var hoistFunctionsVisitor = {

  /**
   * [Please add a description.]
   */

  Function: function Function() {
    this.skip();
  },

  /**
   * [Please add a description.]
   */

  enter: function enter(node, parent, scope, state) {
    if (t.isFunctionDeclaration(node) || state.formatter._canHoist(node)) {
      state.handlerBody.push(node);
      this.dangerouslyRemove();
    }
  }
};

/**
 * [Please add a description.]
 */

var runnerSettersVisitor = {

  /**
   * [Please add a description.]
   */

  enter: function enter(node, parent, scope, state) {
    if (node._importSource === state.source) {
      if (t.isVariableDeclaration(node)) {
        var _arr = node.declarations;

        for (var _i = 0; _i < _arr.length; _i++) {
          var declar = _arr[_i];
          state.hoistDeclarators.push(t.variableDeclarator(declar.id));
          state.nodes.push(t.expressionStatement(t.assignmentExpression("=", declar.id, declar.init)));
        }
      } else {
        state.nodes.push(node);
      }

      this.dangerouslyRemove();
    }
  }
};

/**
 * [Please add a description.]
 */

var SystemFormatter = (function (_AMDFormatter) {
  _inherits(SystemFormatter, _AMDFormatter);

  function SystemFormatter(file) {
    _classCallCheck(this, SystemFormatter);

    _AMDFormatter.call(this, file);

    this._setters = null;
    this.exportIdentifier = file.scope.generateUidIdentifier("export");
    this.noInteropRequireExport = true;
    this.noInteropRequireImport = true;

    this.remaps.clearAll();
  }

  /**
   * [Please add a description.]
   */

  SystemFormatter.prototype._addImportSource = function _addImportSource(node, exportNode) {
    if (node) node._importSource = exportNode.source && exportNode.source.value;
    return node;
  };

  /**
   * [Please add a description.]
   */

  SystemFormatter.prototype.buildExportsWildcard = function buildExportsWildcard(objectIdentifier, node) {
    var leftIdentifier = this.scope.generateUidIdentifier("key");
    var valIdentifier = t.memberExpression(objectIdentifier, leftIdentifier, true);

    var left = t.variableDeclaration("var", [t.variableDeclarator(leftIdentifier)]);

    var right = objectIdentifier;

    var block = t.blockStatement([t.ifStatement(t.binaryExpression("!==", leftIdentifier, t.literal("default")), t.expressionStatement(this._buildExportCall(leftIdentifier, valIdentifier)))]);

    return this._addImportSource(t.forInStatement(left, right, block), node);
  };

  /**
   * [Please add a description.]
   */

  SystemFormatter.prototype.buildExportsAssignment = function buildExportsAssignment(id, init, node) {
    var call = this._buildExportCall(t.literal(id.name), init, true);
    return this._addImportSource(call, node);
  };

  /**
   * [Please add a description.]
   */

  SystemFormatter.prototype.buildExportsFromAssignment = function buildExportsFromAssignment() {
    return this.buildExportsAssignment.apply(this, arguments);
  };

  /**
   * [Please add a description.]
   */

  SystemFormatter.prototype.remapExportAssignment = function remapExportAssignment(node, exported) {
    var assign = node;

    for (var i = 0; i < exported.length; i++) {
      assign = this._buildExportCall(t.literal(exported[i].name), assign);
    }

    return assign;
  };

  /**
   * [Please add a description.]
   */

  SystemFormatter.prototype._buildExportCall = function _buildExportCall(id, init, isStatement) {
    var call = t.callExpression(this.exportIdentifier, [id, init]);
    if (isStatement) {
      return t.expressionStatement(call);
    } else {
      return call;
    }
  };

  /**
   * [Please add a description.]
   */

  SystemFormatter.prototype.importSpecifier = function importSpecifier(specifier, node, nodes) {
    _amd2["default"].prototype.importSpecifier.apply(this, arguments);

    var _arr2 = this.remaps.getAll();

    for (var _i2 = 0; _i2 < _arr2.length; _i2++) {
      var remap = _arr2[_i2];
      nodes.push(t.variableDeclaration("var", [t.variableDeclarator(t.identifier(remap.name), remap.node)]));
    }

    this.remaps.clearAll();

    this._addImportSource(_lodashArrayLast2["default"](nodes), node);
  };

  /**
   * [Please add a description.]
   */

  SystemFormatter.prototype._buildRunnerSetters = function _buildRunnerSetters(block, hoistDeclarators) {
    var scope = this.file.scope;

    return t.arrayExpression(_lodashCollectionMap2["default"](this.ids, function (uid, source) {
      var state = {
        hoistDeclarators: hoistDeclarators,
        source: source,
        nodes: []
      };

      scope.traverse(block, runnerSettersVisitor, state);

      return t.functionExpression(null, [uid], t.blockStatement(state.nodes));
    }));
  };

  /**
   * [Please add a description.]
   */

  SystemFormatter.prototype._canHoist = function _canHoist(node) {
    return node._blockHoist && !this.file.dynamicImports.length;
  };

  /**
   * [Please add a description.]
   */

  SystemFormatter.prototype.transform = function transform(program) {
    _default2["default"].prototype.transform.apply(this, arguments);

    var hoistDeclarators = [];
    var moduleName = this.getModuleName();
    var moduleNameLiteral = t.literal(moduleName);

    var block = t.blockStatement(program.body);

    var setterListNode = this._buildRunnerSetters(block, hoistDeclarators);
    this._setters = setterListNode;

    var runner = util.template("system", {
      MODULE_DEPENDENCIES: t.arrayExpressio