/**
 * 
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 * 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * 
 * Copyright (C) Open-Xchange Inc., 2006-2012
 * Mail: info@open-xchange.com 
 * 
 * @author Matthias Biggeleben <matthias.biggeleben@open-xchange.com>
 * @author Stefan Preuss <stefan.preuss@open-xchange.com>
 * 
 */

/*jslint bitwise: false, nomen: false, onevar: false, plusplus: false, regexp: false, white: false, browser: true, devel: true, evil: true, forin: true, undef: true, eqeqeq: true, immed: true */

/*global ox, jQuery, window, getFullImgSrc, _, urlify, setFocus, register */

// window factory for embedded windows
var embeddedWindows = (function () {
    
    var dockVisible = true, titleVisible = true;
    
    var setDockVisible = function (flag) {
        if (flag === true) {
            // set flag
            dockVisible = true;
            // show dock
            $(dock).show();
            // resize UI
            $("#notheader").css("bottom", "34px");
            $(".ox-embedded-container, .ox-embedded-decorator").css("bottom", "32px");
        } else {
            // set flag
            dockVisible = false;
            // hide dock
            $(dock).hide();
            // resize UI
            $("#notheader").css("bottom", "0px");
            $(".ox-embedded-container, .ox-embedded-decorator").css("bottom", "0px");
        }
    };
    
    var setTitleVisible = function (flag) {
        if (flag === true) {
            // set flag
            titleVisible = true;
            // show title and close button
            $(".ox-embedded-title .ox-embedded-close").show();
            $(".ox-embedded-iframe").css({ top: "" });
        } else {
            // set flag
            titleVisible = false;
            // hide title and close button
            $(".ox-embedded-title .ox-embedded-close").hide();
            $(".ox-embedded-iframe").css({ top: 0 });
        }
    };
    
    // ref
    var $ = jQuery;
    
    // vars
    var count = 0, current = null, initialize = true;
    var showDock, hideDock;
    var show, fnShow, add, remove, addToDock, fnClose;
    var row, table, dock;
    var openWindow, closeWindow, selectWindow;
    
    // returns the current, focused window object
    var getCurrent = function() {
        return current;
    };
    
    var readyHandler = function (data) {
        // get window
        var w = ox.api.window.get(data.handle);
        if (w) {
            data.isNew = false;
            if (!data.id || data.id === "" 
            	|| data.id === "-1" || data.activemodule === "mail_new") {
                data.isNew = true;
            }
            
        	var prefix;
        	if (data.isNew === false) {
	        	switch (data.module) {
	        		case "mail":
	        			prefix = _("E-Mail");
	        			break;
	        		case "calendar":
	        			prefix = _("Edit Appointment");
	        			break;
	        		case "contacts":
	        		    if (data.distributionList === true) {
	        		        prefix = _("Edit Distribution List");
	        		    } else {
	        		        prefix = _("Edit Contact");
	        		    }
	        			break;
	        		case "tasks":
	        			prefix = _("Edit Task");
	        			break;
	        		case "infostore":
	        			prefix = _("Edit InfoItem");
	        			break;
	        	}
        	}
        	
        	var title  = prefix ? format(_("%1$s: %2$s"), prefix, noI18n(data.title)) : data.title;
        	w.container.I18nNodes = [ new I18nNode(title), new I18nNode(title) ];
        	
        	// set window / container title
            w.container.children(":first").children().empty().append(w.container.I18nNodes[0].node);
            w.dock.children().find("div.ox-window-title").empty().append(w.container.I18nNodes[1].node);
            
            w.dock.children().find("div.ox-window-module").
            css({ backgroundImage: "url('" + getFullImgSrc("icons/16/mod_" + data.module + ".png") + "')" });
        }
    };
    
    var disable = function () {
        // hide dock
        $(dock).hide();
        // resize UI
        $("#notheader").css("bottom", "0px");
        $(".ox-embedded-container, .ox-embedded-decorator").css("bottom", "0px");
        // unregister ready handler
        ox.api.event.unregister("OX_Window_Ready", readyHandler);
        // reset window factory
        ox.api.window.resetFactory();
    };
    
    var enable = function () {
        
        // update title
        ox.api.event.register("OX_Window_Ready", readyHandler);
        
        if (initialize) {
            
            // show/hide dock
            showDock = function () {
                if (dockVisible === true) {
                    $("#notheader, .ox-embedded-container, .ox-embedded-decorator").css("bottom", "34px");
                    dock.show();
                }
            };
            
            hideDock = function () {
                $("#notheader").css("bottom", "0px");
                dock.hide();
            };
            
            // create dock
            dock = $("<div/>", { id: "ox-dock" })
                .addClass("ox-dock")
                .appendTo("#everything") // former: document.body
                .append(
                    table = $("<table/>", { border: "0", cellPadding: "0", cellSpacing: "0" }).append(
                        $("<tbody/>").append(row = $("<tr/>"))
                    )
                );
            
            // functions
            show = function (guid) {
                // use as toggle
                if (current && current.guid === guid) {
                    guid = "OX.0";
                }
                // hide current window
                if (current) {
                    current.lightbox.hide();
                    current.container.hide();
                    current.window.OX_UI_Visible = false;
                    // remove old selection 
                    current.dock.find(".ox-dock-selected").removeClass("ox-dock-selected");
                    // click on same tab
                    if (current.guid === guid) {
                        // minimize windown
                        if (!current.minimized) {
                            current.minimized = true;
                            return;
                        } else {
                            // maximize
                            delete current.minimized;
                        }
                    }
                }
                
                // show window (not core)?
                if (guid !== "OX.0") {
                    // get window
                    var w = ox.api.window.get(guid);
                    // show
                    w.lightbox.show();
                    w.container.show();
                    // set current
                    current = {
                        guid: guid,
                        lightbox: w.lightbox,
                        container: w.container,
                        dock: w.dock,
                        window: w.window
                    };
                    // select current
                    w.dock.children().first().addClass("ox-dock-selected");
                    // chrome and ie needs a short timeout
                    setTimeout(function() {
                        // trigger visible
                        if (w.window.triggerEvent) {
                        	w.window.triggerEvent("OX_Visible");
                        } else if (w.window.content && w.window.content.triggerEvent) {
                        	w.window.content.triggerEvent("OX_Visible");
                        }
                        // mark as visible
                        w.window.OX_UI_Visible = true;
                    }, 0);
                    
                } else {
                    current = null;
                }
            };
            
            fnShow = function (e) {
                show(e.data.guid);
            };
            
            add = function (guid) {
                // add to dock
                addToDock(guid, "...");
                // show window
                show(guid);
            };
            
            remove = function (guid) {
                // remove last window
                var w = ox.api.window.get(guid);
                w.dock
                    .css("backgroundImage", "none")
                    .remove();
                delete w.dock;
                // get number of windows
                var count = ox.api.window.count();
                // adjust table width
                table.css("width", (Math.min(count, 5) * 20) + "%");
                table.find("td").css("width", ((100 / count) >> 0) + "%");
                // clear current?
                if (current && current.guid === guid) {
                    current = null;
                }
                if (count <= 2) {
                    hideDock();
                }
            };
            
            fnClose = function (e) {
                // call close first (might run into dialog)
                ox.api.window.close(e.data.guid);
                // then show it for proper timing
                if (!current || current.guid !== e.data.guid) {
                    // not closed?
                    if (ox.api.window.get(e.data.guid) !== null) {
                        show(e.data.guid);
                    }
                }
                return false;
            };
            
            addToDock = function (guid, title) {
                // get number of windows
                var count = ox.api.window.count() + 1;
                // adjust table width
                table.css("width", (Math.min(count, 5) * 20) + "%");
                // add item
                var dock = $("<td/>")
                    .css({
                        minWidth: "100px"
                    })
                    .append(
                        $("<div/>").addClass("ox-dock-tab")
                        .append(
                            $("<div/>")
                                .addClass("ox-window-module")
                                .css({
                                    backgroundImage: "none",
                                    position: "absolute",
                                    top: "6px",
                                    width: "16px",
                                    height: "16px"
                                })
                        ).append(
                            $("<div/>")
                                .addClass("ox-window-title")
                                .css({
                                    position: "absolute",
                                    right: "25px",
                                    left: "32px",
                                    overflow: "hidden",
                                    display: (titleVisible ? "inline" : "none")
                                }).append(
                                        function(index, html) {
                                            if (title && title instanceof I18nString) {
                                                // take care about translations
                                                return $(new I18nNode(title).node);
                                            } else {
                                                // plain text
                                                return $(newtext(title));
                                            }
                                        }
                                    )
                        ).append(
                            $("<div/>")
                                .addClass("ox-window-close")
                                .css({
                                    position: "absolute",
                                    right: "8px",
                                    top: "6px",
                                    width: "14px",
                                    height: "14px",
                                    display: (titleVisible ? "inline" : "none")
                                }).
                                bind("click", { guid: guid }, fnClose)
                        )
                        .bind("click", { guid: guid }, fnShow)
                    )
                    .appendTo(row);
                // update width
                table.find("td").css("width", ((100/count) >> 0) + "%");
                // remove close for main dock
                if (guid === "OX.0") {
                    dock.find("div.ox-window-module")
                        .css("backgroundImage", "none") // fix potential IE bug
                        .remove();
                    dock.find("div.ox-window-close").remove();
                }
                // add
                var w = ox.api.window.get(guid);
                w.dock = dock;
            };
            
            // window factory functions
            // open
            openWindow = function (opt) {
                // show dock?
                if (ox.api.window.count() >= 1) {
                    showDock();
                }
                // inc
                count += 2;
                // locals
                var iframe, lightbox, container;
                var css = {
                    border: "0px none",
                    width: "100%"
                };
                // IE7 height fix (cannot handle 100%)
                if (!(IE < 8)) {
                    css.height = "100%";
                }
                // create iframe
                iframe = $("<iframe/>", {
                    src: urlify(opt.url),
                    frameborder: "no",
                    id: opt.guid
                })
                .addClass("ox-embedded-window")
                .css(css)
                .one("load", function (e) { // "bind" (instead of "one") might fail, if success handler work with document.write (endless loop in IE)
                    // set guid
                    var win = this.contentWindow;
                    win.guid = opt.guid;
                    // register new window object
                    var obj = {
                        iframe: $(this),
                        lightbox: lightbox,
                        container: container
                    };
                    if (IE < 8) obj.resizeHandler = IEResize;
                    ox.api.window.register(opt.guid, win, obj);
                    // remove spinner
                    lightbox.removeClass("busy-spinner-black");
                    // show container
                    container.css("visibility", "visible");
                    // add to list
                    add(opt.guid);
                    // continue
                    opt.success(win, opt.guid);
                    win = null;
                });
                // create lightbox
                lightbox = $("<div/>")
                    .addClass("ox-embedded-decorator busy-spinner-black")
                    .css({
                        zIndex: 19 + count,
                        bottom: dockVisible ? "34px" : "0px"
                    })
                    .bind("click contextmenu", function (e) { /* ctrl+click on mac becomes contextmenu */
                        if (e.ctrlKey) {
                            // close
                            opt.closer(opt);
                        } else {
                            // show core
                            show("OX.0");
                        }
                    })
                    .appendTo("#everything"); // former: document.body
                // create container
                var w = opt.options.width, innerDiv;
                container = $("<div/>")
                    .addClass("ox-embedded-container")
                    .css({
                        zIndex: 20 + count,
                        bottom: dockVisible ? "34px" : "0px",
                        marginLeft: (-Math.floor(w / 2)) + "px",
                        width: w + "px",
                        backgroundColor: "white"
                    });
                if (titleVisible === true) {
                    container.append(
                        // title bar
                        $("<div/>")
                            .addClass("ox-embedded-title")
                            .append(
                                $("<div/>")
                                .css({ overflow: "hidden", textOverflow: "ellipsis", marginRight: "10px" })
                                .text("\u00a0")
                            )
                    )
                    .append(
                         // close
                         $("<div/>")
                             .addClass("ox-embedded-close")
                             .append(
                                 $("<img/>", { src: getFullImgSrc("img/dummy.gif"), alt: "" })
                                     .bind("click", { guid: opt.guid }, fnClose)
                             )
                    );
                };
                container.append(
                    innerDiv = $("<div/>").addClass("ox-embedded-iframe").css("top", (titleVisible === true ? "" : 0)).append(iframe)
                )
                .appendTo("#everything"); // former: document.body
                // finish IE7 height fix
                function IEResize() {
                    iframe.css("height", innerDiv.height() + "px");
                }
                if (IE < 8) {
                    IEResize();
                    resizeEvents.register("Resized", IEResize);
                }
                // reset hovers
                Hover.reset();
                // focus frame
                setFocus(iframe.get(0));
                // prevent leak
                if (!(IE < 8)) iframe = innerDiv = null;
            };
            
            // close
            closeWindow = function (obj, guid) {
                // close
                if (obj.resizeHandler) {
                    resizeEvents.unregister("Resized", obj.resizeHandler);
                }
                // disable i18n nodes
                if (obj.container.I18nNodes) {
                    for (var i = 0; i < obj.container.I18nNodes.length; i++) {
                        obj.container.I18nNodes[i].disable();
                    }
                    delete obj.container.I18nNodes;
                }
                
                obj.iframe.remove();
                obj.container.remove();
                obj.lightbox.remove();
                delete obj.iframe;
                delete obj.container;
                delete obj.lightbox;
                // dec
                count -= 2;
                // remove
                remove(guid);
            };
            
            // select
            selectWindow = function (obj, guid) {
                show(guid);
                obj.window.focus();
            };
            
            addToDock("OX.0", _("Main window"));
            
        } else {
            // show dock
            showDock();
        }
        
        // replace factory
        ox.api.window.setFactory(openWindow, closeWindow, selectWindow, true);
        
        // done with first run
        initialize = false;
    };
    
    // public functions
    return {
        setDockVisible: setDockVisible,
        setTitleVisible: setTitleVisible,
        enable: enable,
        disable: disable,
        force: false,
        getCurrent: getCurrent
    };
    
}());

// use embedded windows?
register("Ready", function () {
    if (embeddedWindows.force || ox.api.config.get("ui.global.windows.mode.value") === "embedded") {
        embeddedWindows.enable();
    }
});
