/**
 * 
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 * 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * 
 * Copyright (C) Open-Xchange Inc., 2006-2012
 * Mail: info@open-xchange.com 
 * 
 * @author Jan Finsel <jan.finsel@open-xchange.com>
 * 
 */

registerView("configuration/calendar/preferences",
	function () { 
		showNode("config_calendar"); 
		$("config_calendar").style.display="block";
        
		// toolbar
        temporary.configuration.showToolbar(
            temporary.configuration.defaultToolbar);
    },
	function () { 
		register("OX_SAVE_OBJECT",cc_saveConfiguration);
		register("OX_Cancel_Object",cc_cancelConfiguration);
		cc_enter(); 
		},
	function () { 
		unregister("OX_SAVE_OBJECT",cc_saveConfiguration);
		unregister("OX_Cancel_Object",cc_cancelConfiguration);
		},
	function () { 
		hideNode("config_calendar"); 
		$("config_calendar").style.display="none";
    },
	cc_enter
);

function cc_saveConfiguration() {
	if(configuration_changed_fields["gui"]) {
		configSetKey("gui.calendar.interval",cc_interval.getKey());
		
		configSetKey("gui.calendar.default_reminder",cc_default_reminder.getKey());
		
		configSetKey("gui.calendar.starttime",cc_work_start.getKey());
		configSetKey("gui.calendar.endtime",cc_work_end.getKey());
        cc_default_view_data.view = cc_default_view.getKey();
        cc_default_view_data.calendar = cc_calendar_time_range.getKey();
        cc_default_view_data.team = cc_team_time_range.getKey();
        cc_default_view_data.list = cc_list_time_range.getKey();
        cc_default_view_data.shared = getValueofRadioBox("cc_shared_time_range") ? true : false;
		configSetKey("gui.calendar.views", cc_default_view_data);
		configSetKey("gui.calendar.view", getDefaultCalendarView());
		configSetKey("gui.global.confirmpopup",getBoolofInt(getValueofRadioBox("cs_confirmpopup")));
		
		configSetKey("gui.calendar.day.numberofappointments",cc_countappointmentday.getKey());
		configSetKey("gui.calendar.workweek.numberofappointments",cc_countappointmentww.getKey());
		configSetKey("gui.calendar.workweek.startday",cc_startdayofworkweek.getKey());
		configSetKey("gui.calendar.workweek.countdays",cc_daysinworkweek.getKey());
		configSetKey("gui.calendar.custom.countdays",cc_daysincustom.getKey());
		configSetKey("gui.calendar.custom.numberofappointments",cc_countappointmentcustom.getKey());

		configSetKey("gui.calendar.autoadd_participant_public",getBoolofInt(getValueofRadioBox("cs_calendar_add_participant_public")));	

		configSetKey("gui.effects.hover.calendar",getBoolofInt(getValueofRadioBox("cc_enablehovercalendar")));	

		// Hide non-working time in teamview
		configSetKey("gui.calendar.teamview.workingTimeOnly", getBoolofInt(getValueofRadioBox("cc_teamWorkingTimeOnly")));
		
		menulastviews.calendar = getDefaultCalendarView();
        lastCalendarTimeRanges.calendar = cc_default_view_data.calendar;
        lastCalendarTimeRanges.team = cc_default_view_data.team;
        lastCalendarTimeRanges.list = cc_default_view_data.list;
	}
	if (configuration_changed_fields["modules"]) {
		configSetKey("modules.calendar.defaultStatusPrivate",cc_defaultstatusprivate.getKey());
		configSetKey("modules.calendar.defaultStatusPublic",cc_defaultstatuspublic.getKey());
	}

	/*
     * store notification settings to config, if changed 
     */
    if (configuration_changed_fields["calendarnotification"]) {
        configSetKey("modules.calendar.notifyNewModifiedDeleted",getBoolofInt(getValueofRadioBox("cs_calendarnotification_0")));   
        configSetKey("modules.calendar.notifyAcceptedDeclinedAsCreator",getBoolofInt(getValueofRadioBox("cs_calendarnotification_1")));
        configSetKey("modules.calendar.notifyAcceptedDeclinedAsParticipant",getBoolofInt(getValueofRadioBox("cs_calendarnotification_2")));
    }
	
	triggerEvent("OX_Save_Configuration",false,false);
}
function cc_cancelConfiguration() {
	configuration_changed_fields["gui"]=false;
	cc_enter();
}
var cc_init_bool=false;
var cc_interval;
var cc_default_reminder;
var cc_work_start;
var cc_work_end;
var cc_countappointmentww,cc_countappointmentday,cc_countappointmentcustom,cc_daysinworkweek,cc_daysincustom,cc_startdayofworkweek,cc_defaultstatusprivate,cc_defaultstatuspublic;
var cc_default_view_data;
var cc_default_view;
var cc_calendar_time_range, cc_team_time_range, cc_list_time_range;

function cc_team_view_upsell() {
    if (!configGetKey('modules.calendar.calendar_teamview')) {
        triggerEvent("Feature_Not_Available", "modules/calendar/team", window);
    }
}

function cc_enter() {
	if(!cc_init_bool) {
		cc_init();
		cc_init_bool=true;
	}
	if(configContainsKey("gui.calendar.interval")) {
		cc_interval.setKey(configGetKey("gui.calendar.interval"));
		configuration_changed_fields["gui"]=false;
	}
	
	if(configContainsKey("gui.calendar.default_reminder")) {
		cc_default_reminder.setKey(configGetKey("gui.calendar.default_reminder"));
		configuration_changed_fields["gui"]=false;
	}
	
	if(configContainsKey("gui.calendar.starttime")) {
		cc_work_start.setKey(configGetKey("gui.calendar.starttime"));
		configuration_changed_fields["gui"]=false;
	}
	if(configContainsKey("gui.calendar.endtime")) {
		cc_work_end.setKey(configGetKey("gui.calendar.endtime"));
		configuration_changed_fields["gui"]=false;
	}
	if(   configContainsKey("gui.calendar.views")
	   || configContainsKey("gui.calendar.view"))
	{
        cc_default_view_data = configGetKey("gui.calendar.views");
        if (!cc_default_view_data) {
            cc_default_view_data = configGetKey("gui.calendar.view");
            if (   !cc_default_view_data
                || typeof cc_default_view_data != "object")
            {
                var match = /^calendar\/([^\/]+)\/([^\/]+)$/.exec(
                    cc_default_view_data) || [, "calendar", "day"];
                cc_default_view_data = { view: match[1], calendar: match[2],
                    team: match[2], list: match[2], shared: true };
            }
        }
        cc_default_view.setKey(cc_default_view_data.view);
        cc_calendar_time_range.setKey(cc_default_view_data.calendar);
        cc_team_time_range.setKey(cc_default_view_data.team);
        cc_list_time_range.setKey(cc_default_view_data.list);
        setValueofRadioBox("cc_shared_time_range", cc_default_view_data.shared);
        configuration_changed_fields["gui"]=false;
        var hasTeam = configGetKey('modules.calendar.calendar_teamview');
        ox.UI.Widget.setDisabledClass($("cc_team_time_range_label"), !hasTeam);
        cc_team_time_range[hasTeam ? "enable" : "disable"]();
	}
	if(configContainsKey("gui.global.confirmpopup")) {
		setValueofRadioBox("cs_confirmpopup",configGetKey("gui.global.confirmpopup"));
		configuration_changed_fields["gui"]=false;
	}
	if(configContainsKey("gui.calendar.interval")) {
		cc_interval.setKey(configGetKey("gui.calendar.interval"));
		configuration_changed_fields["gui"]=false;
	}
	if(configContainsKey("gui.calendar.day.numberofappointments")) {
		cc_countappointmentday.setKey(configGetKey("gui.calendar.day.numberofappointments"));
		configuration_changed_fields["gui"]=false;
	}
	if(configContainsKey("gui.calendar.workweek.numberofappointments")) {
		cc_countappointmentww.setKey(configGetKey("gui.calendar.workweek.numberofappointments"));
		configuration_changed_fields["gui"]=false;
	}
	if(configContainsKey("gui.calendar.workweek.startday")) {
		cc_startdayofworkweek.setKey(configGetKey("gui.calendar.workweek.startday"));
		configuration_changed_fields["gui"]=false;
	}
	if(configContainsKey("gui.calendar.workweek.countdays")) {
		cc_daysinworkweek.setKey(configGetKey("gui.calendar.workweek.countdays"));
		configuration_changed_fields["gui"]=false;
	}
	if(configContainsKey("gui.calendar.custom.countdays")) {
		cc_daysincustom.setKey(configGetKey("gui.calendar.custom.countdays"));
		configuration_changed_fields["gui"]=false;
	}
	if(configContainsKey("gui.calendar.custom.numberofappointments")) {
		cc_countappointmentcustom.setKey(configGetKey("gui.calendar.custom.numberofappointments"));
		configuration_changed_fields["gui"]=false;
	}
	if(configContainsKey("modules.calendar.defaultStatusPrivate")) {
		cc_defaultstatusprivate.setKey(configGetKey("modules.calendar.defaultStatusPrivate"));
		configuration_changed_fields["modules"]=false;
	}
	if(configContainsKey("modules.calendar.defaultStatusPublic")) {
		cc_defaultstatuspublic.setKey(configGetKey("modules.calendar.defaultStatusPublic"));
		configuration_changed_fields["modules"]=false;
	}

	if(configContainsKey("gui.effects.hover.calendar")) {
		setIntofRadioBox("cc_enablehovercalendar",configGetKey("gui.effects.hover.calendar"));
		configuration_changed_fields["gui"]=false;
	}
	
    if(configContainsKey("gui.calendar.teamview.workingTimeOnly")) {
        setIntofRadioBox("cc_teamWorkingTimeOnly", configGetKey("gui.calendar.teamview.workingTimeOnly"));
        configuration_changed_fields["gui"] = false;
    }
    
	if(configContainsKey("gui.calendar.autoadd_participant_public")) {
		setIntofRadioBox("cs_calendar_add_participant_public",configGetKey("gui.calendar.autoadd_participant_public"));
		configuration_changed_fields["gui"]=false;
	}
	if (configContainsKey("modules.calendar.notifyNewModifiedDeleted")) {
        setValueofRadioBox("cs_calendarnotification_0",configGetKey("modules.calendar.notifyNewModifiedDeleted"));
        configuration_changed_fields["calendarnotification"]=false;
    }
    if (configContainsKey("modules.calendar.notifyAcceptedDeclinedAsCreator")) {
        setValueofRadioBox("cs_calendarnotification_1",configGetKey("modules.calendar.notifyAcceptedDeclinedAsCreator"));
        configuration_changed_fields["calendarnotification"]=false;
    }
    if (configContainsKey("modules.calendar.notifyAcceptedDeclinedAsParticipant")) {
        setValueofRadioBox("cs_calendarnotification_2",configGetKey("modules.calendar.notifyAcceptedDeclinedAsParticipant"));
        configuration_changed_fields["calendarnotification"]=false;
    }
	setConfigPath($("cc_header"));	
}

register("OX_Configuration_Loaded",cc_onconfigload);
function cc_onconfigload() {
    addDefaultView("calendar/calendar/day", true);
    addDefaultView("calendar/calendar/workweek", true);
    addDefaultView("calendar/calendar/month", true);
    addDefaultView("calendar/calendar/week", true);
    addDefaultView("calendar/calendar/custom", true);
    if (   configGetKey("modules.calendar.calendar_freebusy")
        && configGetKey("modules.calendar.calendar_teamview"))
    {
        addDefaultView("calendar/team/day", true);
        addDefaultView("calendar/team/workweek", true);
        addDefaultView("calendar/team/month", true);
        addDefaultView("calendar/team/week", true);
        addDefaultView("calendar/team/custom", true);
    }
    addDefaultView("calendar/list/day", true);
    addDefaultView("calendar/list/workweek", true);
    addDefaultView("calendar/list/month", true);
    addDefaultView("calendar/list/week", true);
    addDefaultView("calendar/list/custom", true);
}

 
function cc_init() {
	cc_interval= new ComboBox3(window, "cc_interval", "11em", 1, true,"OX_Configuration_GUI_Changed", null);
	cc_interval.addElement(noI18n("5"),5);
	cc_interval.addElement(noI18n("10"),10);
	cc_interval.addElement(noI18n("15"),15);
	cc_interval.addElement(noI18n("20"),20);
	cc_interval.addElement(noI18n("30"),30);
	cc_interval.addElement(noI18n("60"),60);
	cc_interval.getDomNode();	
	
	var timearray=["00:00","01:00","02:00","03:00","04:00","05:00","06:00","07:00","08:00","09:00","10:00","11:00","12:00","13:00","14:00","15:00","16:00","17:00","18:00","19:00","20:00","21:00","22:00","23:00"];
	
	var h = 60, d = 1440, w = 10080; // minutes per hour, day and week
    var cc_reminder_intervals = [0, 15, 30, 45, 1*h, 2*h, 4*h, 6*h, 8*h, 12*h,1*d, 2*d, 3*d, 4*d, 5*d, 6*d, 1*w, 2*w, 3*w, 4*w];
	cc_default_reminder = new ComboBox3(window, "cc_reminder_status", "11em", 2, true, "OX_Configuration_GUI_Changed", 5);
	cc_default_reminder.addElement(_("no reminder"), "-1");
    for (var i = 0; i < cc_reminder_intervals.length; i++) {
        cc_default_reminder.addElement(
            getInterval(cc_reminder_intervals[i] * 6e4), // ms / min
            cc_reminder_intervals[i]);
    }
    cc_default_reminder.getDomNode();
	
	
	cc_work_start= new ComboBox3(window, "cc_work_start", "11em", 1, true,"cf_wtimechanged", 5, "start");
	for(var i=0;i<timearray.length;i++) {
        cc_work_start.addElement(
            formatDate(new Date(Date.UTC(2000,1,1,i,0,0)), "time"), i);
	}
	cc_work_start.getDomNode();	
	cc_work_end= new ComboBox3(window, "cc_work_end", "11em", 1, true,"cf_wtimechanged", 5, "end");
	for(var i=0;i<timearray.length;i++) {
        cc_work_end.addElement(
            formatDate(new Date(Date.UTC(2000,1,1,i,0,0)), "time"), i);
	}
	cc_work_end.getDomNode();
	
	// adjust working start and end time
	register("cf_wtimechanged", function(value, type) {
	    var start = cc_work_start.getKey();
	    var end = cc_work_end.getKey();
	    if (type == "start")  {
	        if (start == 23) {
	            cc_work_start.setKey(22);
	        } else if (start > end) {
	            cc_work_end.setKey(start+1);
	        }
	    } else {
	        if (end == 0) {
                cc_work_end.setKey(1);
            } else if (end < start) {
                cc_work_start.setKey(end-1);
            }
	    }
	    triggerEvent("OX_Configuration_GUI_Changed");
	});
	
    cc_default_view = new ComboBox3(window, "cc_default_view", "11em", 1, true, "OX_Configuration_GUI_Changed", 3);
    cc_default_view.addElement(_("Calendar"), "calendar");
    cc_default_view.addElement(_("Team"), "team");
    cc_default_view.addElement(_("List"), "list");
    cc_default_view.getDomNode();
    cc_calendar_time_range = new ComboBox3(window, "cc_calendar_time_range", "11em", 1, true, "OX_Configuration_GUI_Changed", 5);
    cc_team_time_range = new ComboBox3(window, "cc_team_time_range", "11em", 1, true, "OX_Configuration_GUI_Changed", 5);
    cc_list_time_range = new ComboBox3(window, "cc_list_time_range", "11em", 1, true, "OX_Configuration_GUI_Changed", 5);
	var time_ranges = ["day", "workweek", "month", "week", "custom"];
    var range_names = [_("Day"), _("Work Week"), _("Month"), _("Week"),
                       _("Custom")];
    for (var i = 0; i < time_ranges.length; i++) {
        cc_calendar_time_range.addElement(range_names[i], time_ranges[i]);
        cc_team_time_range.addElement(range_names[i], time_ranges[i]);
        cc_list_time_range.addElement(range_names[i], time_ranges[i]);
	}
    cc_calendar_time_range.getDomNode();
    cc_team_time_range.getDomNode();
    cc_list_time_range.getDomNode();
    
	cc_countappointmentww= new ComboBox3(window, "cc_countappointmentww", "11em", 1, true,"OX_Configuration_GUI_Changed", 5);
	cc_countappointmentday= new ComboBox3(window, "cc_countappointmentday", "11em",1, true,"OX_Configuration_GUI_Changed", 5);
	cc_countappointmentcustom= new ComboBox3(window, "cc_countappointmentcustom", "11em",1, true,"OX_Configuration_GUI_Changed", 5);
	cc_daysinworkweek= new ComboBox3(window, "cc_daysinworkweek", "11em",1, true,"OX_Configuration_GUI_Changed", 5);
	cc_daysincustom= new ComboBox3(window, "cc_daysincustom", "11em",1, true,"OX_Configuration_GUI_Changed", 5);
	cc_startdayofworkweek= new ComboBox3(window, "cc_startdayofworkweek", "11em",1, true,"OX_Configuration_GUI_Changed", 5);
	for (var i2=1;i2<=8;i2++) {
        cc_countappointmentcustom.addElement(noI18n(i2),i2);
        cc_countappointmentww.addElement(noI18n(i2),i2);
        cc_countappointmentday.addElement(noI18n(i2),i2);
	}
	for (var i2=1;i2<=7;i2++) {
        cc_daysinworkweek.addElement(noI18n(i2),i2);
        cc_daysincustom.addElement(noI18n(i2),i2);
	}
	for (var i2=0;i2<weekdays.untranslated.length;i2++) {
		cc_startdayofworkweek.addElement(_(weekdays.untranslated[i2]), i2);
	}
	
	cc_defaultstatusprivate= new ComboBox3(window, "cc_defaultstatusprivate", "11em",1, true,"OX_Configuration_Settings_Changed_Modules", 3);
	cc_defaultstatuspublic= new ComboBox3(window, "cc_defaultstatuspublic", "11em",1, true,"OX_Configuration_Settings_Changed_Modules", 3);
	
    cc_defaultstatusprivate.addElement(_("waiting"), 0);
    cc_defaultstatusprivate.addElement(_("accepted"), 1);
    cc_defaultstatusprivate.addElement(_("tentative"), 3);
    
    cc_defaultstatuspublic.addElement(_("waiting"), 0);
    cc_defaultstatuspublic.addElement(_("accepted"), 1);
    cc_defaultstatuspublic.addElement(_("tentative"), 3);

	
	cc_countappointmentday.getDomNode();
	cc_daysinworkweek.getDomNode();
	cc_startdayofworkweek.getDomNode();
	cc_countappointmentww.getDomNode();
	cc_daysincustom.getDomNode();
	cc_countappointmentcustom.getDomNode();
	cc_defaultstatusprivate.getDomNode();
	cc_defaultstatuspublic.getDomNode();	
}

fileloaded();