/**
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License, Version 2 as published
 * by the Free Software Foundation.
 *
 * Copyright (C) 2009 Open-Xchange GmbH
 * Mail: info@open-xchange.com 
 * 
 * @author: Stefan Preuss <stefan.preuss@open-xchange.com>
 *
 */

var ms_link = "[protocol]://[hostname][path]plugins/com.openexchange.usm.eas/docs/OX6-OXtender-for-Business-Mobility-[language].pdf";
function ms_openDocument() {
	var ms_language = (configGetKey("language") || "en_US").split("_");
	var ms_object = { 
			language:  
				(function() {
					switch(ms_language[0]) {
						case "de": return "German";
						case "fr": return "French";
						case "nl": return "Dutch";
						case "es": return "Spanish";
                                                case "es": if (ms_language[1] == "MX")
                                                             return "Mexican_Spanish";
                                                           else
                                                             return "Spanish";
						case "ja": return "Japanese";
						case "pl": return "Polish";
						case "it": return "Italian";
						default  : return "English";
					}
				})()
	};
	open(ms_link.format(ms_object));
}
HelpMenu.addText(_("Mobility Setup"), ms_openDocument);
return;
var visibleModules = { tasks: 1, calendar: 1, contacts: 1, mail: 1, system: 1 };
var alwaysSynced = {};
var folders = jQuery.extend({}, configGetKey("folder"),
    configGetKey("modules.mail.defaultFolder"));
for (var i in folders) alwaysSynced[folders[i]] = 1;

new ox.Configuration.InnerNode("configuration/com.openexchange.usm.eas",
    _("Synchronization"));
var node = new ox.Configuration.LeafNode(
    "configuration/com.openexchange.usm.eas/eas", _("Exchange ActiveSync"));
var page = new ox.Configuration.Page(node, _("Exchange ActiveSync"));
page.init = function() {
    this.addWidget(new ox.UI.Text(
        _("Please select which folders should be synchronized with mobile devices.")));
    var w = new ox.UI.Widget();
    w.checkboxdata = {};
    w.checkboxes = {};
    w.addContent = function() {
        var self = this;
        this.top = newnode("div",
            { position: "absolute", left: 0, right: 0, top: "2em", bottom: 0 });
        this.tree = new ox.gui.FolderTree(undefined, { grep: function(data) {
            return (data.module in visibleModules) &&
                !/^default[^0]/.test(String(data.id));
        } });
        var oldCustomize = this.tree.customize;
        this.tree.customize = function(node) {
            if (!node.dom.checkbox && node.data.module != "system") {
                var box = node.dom.checkbox = newcheckbox();
                self.checkboxes[node.id] = box;
                if (self.checkboxdata[node.id]) box.checked = true;
                if (node.id in alwaysSynced) box.disabled = true;
                var icon = node.dom.icon.parentNode;
                icon.parentNode.insertBefore(
                    newnode("td", { width: "1.6em" }, 0, [box]), icon);
            }
            return oldCustomize.apply(this, arguments);
        };
        this.tree.setParentDOMNode(this.top);
        this.node = this.parent.addRow(this.top, false);
        this.tree.validate();
        ox.UI.Widget.prototype.addContent.apply(this, arguments);
    };
    w.set = function(data) {
        this.checkboxdata = data;
        if (this.initialized) {
            for (var i in this.checkboxes) {
                this.checkboxes[i].checked = Boolean(data[i]);
            }
        }
    };
    w.get = function() {
        if (this.initialized) {
            for (var i in this.checkboxes) {
                var checked = Boolean(this.checkboxes[i].checked);
                if (this.checkboxdata[i] || checked) {
                    this.checkboxdata[i] = checked;
                }
            }
        }
        return this.checkboxdata;
    };
    this.addWidget(w, ox.Configuration.Group.NoField);
};
page.load = function(cont) {
    ox.JSON.get(AjaxRoot +
        "/folders?action=list&parent=0&columns=1,314&all=1&tree=20&session=" +
        session, function(reply) {
            var data = {};
            for (var i in reply.data) {
                var folder = reply.data[i];
                data[folder[0]] = Boolean(folder[1]);
            }
            cont(data);
        });
};
page.save = function(data, cont) {
    var folders = [];
    for (var i in data) {
        if (data[i] != Boolean(page.original[i])) {
            folders.push({ id: i, subscribe: data[i] });
        }
    }
    ox.JSON.put(AjaxRoot +
        "/folders?action=subscribe&tree=20&parent=0&session=" + session,
        folders, function() {
            ox.Configuration.info(_("Your settings have been saved."));
            cont();
        });
};
