/**
 * 
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 * 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * 
 * Copyright (C) Open-Xchange Inc., 2006-2012
 * Mail: info@open-xchange.com 
 * 
 * @author Stefan Preuss <stefan.preuss@open-xchange.com>
 * 
 */

// global var which holds a common storage with all accounts
// needed later for folder subscribe and updates
// SHOULD be used as a LOCAL var - from now on!
var mail_accounts;

function new_mail_account() {}

register("OX_Configuration_Loaded", function () {
    
    // init account storage
	mail_accounts = new Storage(0, [], 0, 0, 0, 0, function(data) { return data.id; });
		
    var account_folders = {};
    function updateAccountFolders() {
        account_folders = {};
        mail_accounts.newIterate(mail_accounts.ids, emptyFunction,
            function(index, account) {
                for (var i in { trash: 1, sent: 1, drafts: 1, spam: 1 }) {
                    var fullname = account[i + "_fullname"];
                    if (fullname) account_folders[fullname] = i;
                }
            });
    }
    
    /*
     * fix some properties
     */
    function fixObject (data) {
        // fix
        var copy = ox.util.clone(data);
        copy.password = null;
        copy.pop3_expunge_on_quit = !copy.pop3_expunge_on_quit;
        if (copy.transport_login) {
        	copy.transport_credentials = true;
        }
        return copy;
    }
	
	function loadAccounts(cb) {
	    // load all mail accounts
	    ox.api.account.all(function (data) {
            mail_accounts.remove(0, mail_accounts.ids.length);
            var nData = [];
            for (var i in data) {
            	nData.push(fixObject(data[i]));
            }
            mail_accounts.append(nData);
            updateAccountFolders();
            var oldStdFolder = window.isStdFolder || function() {
                return false;
            };
            window.isStdFolder = corewindow == window ? function(type) {
                return account_folders[activefolder] == type || oldStdFolder(type);
            } : function(type) {
                return account_folders[url.folder] == type || oldStdFolder(type);
            };
            ox.util.call(cb);
        });
	}
	
	// load
	if (configGetKey("modules.mail.module") != null) {
		loadAccounts(null);
	}

	// if not enabled we won't continue
	if (configGetKey("modules.mail.module") == null) return;
		
	var node = new ox.Configuration.LeafNode("configuration/mail/accounts", _("E-Mail Accounts"));
	var split = new ox.Configuration.VSplit(node, _("E-Mail Accounts"), 0.28);
	
	// toolbar
    if (!configToolbars.mailaccounts) {
        configToolbars.mailaccounts = temporary.configuration.newToolbar(
            _("E-Mail Accounts"), [
                {
                    title: _("New"),
                    id: "new",
                    buttons: [{
                        title: _("New"),
                        id: "new",
                        icons: ["img/new.png"],
                        big: true,
                        action: function() { 
                            if (split.onNew) split.onNew();
                        },
                        mousedown: function (options, e) {
                            if (ox.api.config.get("modules.mailaccount.module") !== true) {
                                corewindow.triggerEvent("Feature_Not_Available", 
                                        "configuration/mail/accounts/new", window);
                            }
                        }
                    }]
                }
            ], "mailaccounts");
    }
    split.toolbar = configToolbars.mailaccounts;
    
    // disabled when mailaccounts not available
    if (ox.widgets.toolBar.menuItems["mailaccounts-new-new"]) {
        ox.widgets.toolBar.menuItems["mailaccounts-new-new"].setEnabled(
            ox.api.config.get("modules.mailaccount.module") === true
        );
    }
    
    var unifiedCheckbox;
    
	/** Init function **/
	split.init = function() {
	    var selection = new Selection();
	    
	    var fields = [
            //Acount name
            { 
                text: _("Account name"),
                clear: LiveGrid.makeClear(""),
                set: function(div, data) {
                    if (div.firstChild)
                        div.firstChild.data = data.name || "";
                    else
                        div.appendChild(document.createTextNode(data.name || ""));
                }
            }
	    ];
	    
	    // unified inbox is disabled
	    if (ox.api.config.get("modules.mailaccount.unifiedMail", false) === true) {
	        fields.push(
	            // Unified INBOX flag
                {
                    text: _("Unified Mail")/* i18n */,
                    width: "12em",
                    clear: emptyFunction,
                    set: function(div, data) {
                        if (!div.firstChild) {
                            jQuery(div).append(
                                    jQuery("<input/>").attr({type: "checkbox", "oxid": data.id }).
                                    click(function(data) {
                                        var accountId = jQuery(this).attr("oxid");
                                        if (typeof(accountId) != "undefined") {
                                            // talk with server
                                            var data = { "id": accountId, "unified_inbox_enabled": !!jQuery(this).attr("checked") };
                                            // update
                                            ox.api.account.update({
                                                data: data,
                                                success: function (reply) {
                                                    // update right checkbox (only)
                                                    var enabled = reply.unified_inbox_enabled;
                                                    unifiedCheckbox.set(enabled);
                                                    // stop asking if nothing was changes
                                                    split.original.unified_inbox_enabled = enabled;
                                                    // thx to preuss' "brilliant" idea
                                                    mail_accounts.data.data[accountId].unified_inbox_enabled = enabled;
                                                    updateAccountFolders();
                                                }
                                            });
                                        }
                                    })
                            );
                        } else {
                            jQuery("input", div).attr({ "oxid": data.id });
                        }
                        div.firstChild.checked = data.unified_inbox_enabled || false;
                    }
                }
	        );
	    } 
	    
	    var grid = new LiveGrid(fields, selection);
	    fields = null;
	    grid.emptylivegridtext = _("No accounts available");
	    
	    split.list = grid;
	    
	    split.enableList = function() {
	    	loadAccounts(
	    			function() {
		            	grid.enable(mail_accounts);
	    			}
	    	);
	    };
	    
	    function checkFields(data) {
            function check(name, field, text) {
                if (data[name] != "") return false;
                field.formnode.focus();
                setTimeout(function() { 
                    //#. %1$s is the field name.
                    //#, c-format
                    triggerEvent("OX_New_Error", 4, format(
                        _("The mandatory field %1$s is not defined."), text)); 
                }, 0);
                return true;
            }
            return (
                check("name",            name,            _("Account Name"))  ||
                check("primary_address", primary_address, _("E-Mail Address"))||
                check("mail_server",     mail_server,     _("Server Name"))   ||
                check("login",           login,           _("Login"))         ||
                check("transport_login", transport_login, _("Login"))         ||
                split.id === undefined && (
                    check("password",    password,        _("Password"))      ||
                    check("transport_password", transport_password,
                                                          _("Password")))
            );
	    }
	    
	    split.save = function(data, cont) {
            if (checkFields(data)) return;
            
	    	var nData = clone(data);
	    	
	    	// remove some fields if required
	    	if (!trimStr(nData.password).length) {
	    		delete(nData.password);
	    	}
	    	
	    	if (nData.transport_credentials == true) {
	    		nData.transport_auth = "custom";
	    	} else if (nData.transport_credentials === false) {
	    	    nData.transport_login = null;
	    		nData.transport_password = null;
	    	} else if (nData.transport_credentials !== true) {
	    	    delete(nData.transport_login);
                delete(nData.transport_password);
	    	}
	    	delete(nData.transport_credentials);
	    	
            if ("pop3_expunge_on_quit" in nData) {
                nData.pop3_expunge_on_quit = !nData.pop3_expunge_on_quit;
            }
            if ("mail_port" in nData) {
                nData.mail_port = parseInt(nData.mail_port);
            }
            if ("transport_port" in nData) {
                nData.transport_port = parseInt(nData.transport_port);
            }
            nData.transport_protocol = "smtp";
	    	if (nData["mail_protocol"] == "pop3") {
	    		nData.pop3_storage = "mailaccount";
	    	}
	    	
	    	if ("id" in data) {
	    		for (var i in nData) {
	        		if (nData[i] == undefined || nData[i] == "undefined") nData[i]=null; //delete(nData[i]);
	        	}
	    		
	    		// fields to be removed for account 0 (default) 
	    		if (nData.id == 0) {
	    		    delete nData.transport_protocol;
	    		}
	    		
	    		// update account
	    		ox.api.account.update({
	    		    data: nData,
	    		    success: function (reply) {
	    		        // fix data
	    		        var fixed = fixObject(reply);
	    		        // local update
        				mail_accounts.localUpdate([data.id], function (old) {
        				    return fixed;
                        });
        				updateAccountFolders();
                        ox.Configuration.info(_("Your settings have been saved."));
                        track({
                            type: "update",
                            what: "mail_account",
                            data: { id: data.id },
                            text: "Updated mail-account " + data.id
                        });
        	            cont(fixed);
                    }
	    		});
	        } else {
	        	nData.spam_handler = "NoSpamHandler";
	        	// create account
	        	ox.api.account.create({
	        	    data: nData,
	        	    success: handleNew
	        	});
	        }
	    	
	    	function handleNew(data) {
	    	    track({
                    type: "new",
                    what: "mail_account",
                    data: { id: data.id },
                    text: "Added mail-account " + data.id
                });
	    	    // add
	    		mail_accounts.append([fixObject(data)]);
	            ox.Configuration.info(_("Your settings have been saved."));
	            newAlert(_("Info"), _("You have set up an external E-Mail account. The sole responsibility for the availability of the external E-Mail account lies with the service provider."),
	            		function() {
	                        updateAccountFolders();
		            		globalalert.SHOWAGAIN=null;
		            		cont(data);
		            		split.onNew();
	            		}
	            );
	        }
	    };
	    
	    split.load = function(cont) {
	    	split.right.scrollTop = 0;
	    	mail_accounts.newIterate(selection.getSelected(), emptyFunction,
	            function(i, data) {
	                if (data.errormsg) return cont();
	                var d = clone(data);
	                cont(d);
	            });
	    };
	    
	    split.onNew = function() {	    	
            if (configGetKey("modules.mailaccount.module")) {
                split.right.scrollTop = 0;
                this.addNew({ name: _("New account") });
            } else {
                triggerEvent("Feature_Not_Available", "configuration/mail/accounts/new", window);
            }
	    };
	    
	    new_mail_account = function(data) {
	        if (!data.name) data.name = _("New account");
	        split.addNew(data);
        };
	    
	    
	    /*** menu items ***/
	    //menuarrows[node.id] = {};
	    
	    var accountsmenu = MenuNodes.createSmallButtonContext("mail.accounts",
	        _("Accounts"));
	    MenuNodes.createSmallButton(accountsmenu, "mail.accounts.delete",
	        _("Delete"), getFullImgSrc("img/menu/delete.gif"),
	        getFullImgSrc("img/menu/delete.gif"), confirmDelete);
	    function confirmDelete() {
	        if (!selection.count) return;
	        newConfirm(ngettext("Delete Account", "Delete Accounts", selection.count),
	            ngettext("Are you sure you want to delete the selected account?",
	                     "Are you sure you want to delete the selected accounts?",
	                     selection.count),
	            AlertPopup.YES | AlertPopup.NO, null, null, handleYes);
	    }
	    function handleYes() {
	    	mail_accounts.newIterate(selection.getSelected(), emptyFunction, handleDelete);
	    }
	    function handleDelete(idx, data) {
	        // cont
	        var cont = function () {
                grid.deleteIDs([data.id]);
            };
	        // remove account
	        ox.api.account.remove({
	            id: data.id,
	            success: cont
	        });
	        
	    }
	    addMenuNode(accountsmenu.node, MenuNodes.FIXED, 31);
	    changeDisplay(node.id, "mail.accounts");
	    
	    register("OX_SELECTED_ITEMS_CHANGED", function() {	    	
	        var deleteenabled = selection.count >= 1;
	        if (!configGetKey("modules.mailaccount.module")) {
	        	deleteenabled = false;
	        }
	        if (grid.storage) {
	            grid.storage.newIterate(selection.getSelected(), emptyFunction, emptyFunction, updateMenu);
	        } else updateMenu();	        
	        function updateMenu() {
	            menuglobalzaehler = 0;
	            //menuarrows[node.id]["mail.accounts"] = [];
	            menu_display_contents(node.id, "mail.accounts", deleteenabled, "mail.accounts.delete");
	        }
	    });
	    
	    /*** new/edit fields on the right side ***/
	    
	    /*** blank line ***/
	    var lb = function() { ox.UI.Widget.call(this); };
	    lb.prototype = extend(ox.UI.Widget, {
	        addContent: function() {
	           this.node = this.parent.addRow(newnode("br", null, false));
            }
	    });
        
        function disabler(widget) {
            return {
                get: ox.Configuration.Group.NoField.get,
                set: function(data) {
                    widget.setEnabled(data.id !== 0);
                    return data;
                }
            };
        }
        
        /*** ACCOUNT SETTINGS ***/
	    var account = new ox.Configuration.Group(_("Account Settings"));
	    var name = new ox.UI.Input(_("Account Name"));
	    account.addWidget(name, "name");
	    var primary_address = new ox.UI.Input(_("E-Mail Address"));
	    account.addWidget(primary_address, "primary_address");
	    var reply_to = new ox.UI.Input(_("Reply-to Address"));
	    if (ox.api.config.get("ui.mail.replyTo.configurable") === true) {
	        account.addWidget(reply_to, "reply_to");
	    }
	    var personal = new ox.UI.Input(_("Your name"));
	    account.addWidget(personal, "personal");
	    
	    // unified inbox is disabled
	    if (ox.api.config.get("modules.mailaccount.unifiedMail", false) === true) {
	        unifiedCheckbox = new ox.UI.CheckBox(_("Use Unified Mail for this account"));
	        account.addWidget(unifiedCheckbox, "unified_inbox_enabled");
	    }
	    
	    account.addWidget(new lb());
        split.addWidget(account, {
            get: ox.Configuration.Group.NoField.get,
            set: function(data) {
                name.setEnabled(data.id !== 0);
                primary_address.setEnabled(data.id !== 0);
                return data;
            }
        });
	    
	    /*** SERVER SETTINGS ***/
	    var mail = new ox.Configuration.Group(_("Server Settings")); 
        split.addWidget(mail, disabler(mail));
	    
	    function changePort() {
	    	switch(mail_protocol.get()) {
	        	case "imap": 
	        		if (mail_secure.get()) {
	    	    		mail_port.set("993");
	    	    	} else {
	    	    		mail_port.set("143");
	    	    	}
	        		mail_pop_note.setVisible(false);
	        		pop_refresh_rate.setVisible(false);
	        		pop_expunge_on_quit.setVisible(false);
	        		pop_delete_write_through.setVisible(false);
	        		break;
	        	case "pop3":
	        		if (mail_secure.get()) {
	    	    		mail_port.set("995");
	    	    	} else {
	    	    		mail_port.set("110");
	    	    	}
	        		mail_pop_note.setVisible(true);
	        		pop_refresh_rate.setVisible(true);
	        		pop_expunge_on_quit.setVisible(true);
	        		pop_delete_write_through.setVisible(true);
	        		break;
	    	}
	    }

	    
	    var mail_protocol = new ox.UI.ComboBox(_("Server Type"));
	    mail_protocol.width = "18.5em";
	    var protocols = [["imap"],[_("IMAP Mail Server")]];
	    if (ox.api.config.contains("modules.mail.protocols") === false
	            || jQuery.inArray("pop3", ox.api.config.get("modules.mail.protocols", [ ])) !== -1) {
	        protocols[0].push("pop3");
	        protocols[1].push(_("POP3 Mail Server"));
	    }
	    mail_protocol.setEntries(protocols[0], protocols[1]); 
	    mail_protocol.changed = changePort;
	    mail_protocol.default_value = "imap";
	    mail.addWidget(mail_protocol, {
	        get: function(data, value) { data.mail_protocol = value; },
	        set: function(data) {
	            mail_protocol.setEnabled(data.id === undefined);
	            return data.mail_protocol;
	        }
	    });
	    
	    var mail_pop_note = new ox.UI.Text(_("Please note: All messages received from the POP3 account will be stored to a folder on your local IMAP account."));
	    mail_pop_note.disable();
	    mail_pop_note.setVisible(false);
	    mail.addWidget(mail_pop_note, ox.Configuration.Group.NoField);
	    
	    var mail_secure = new ox.UI.CheckBox(_("Use SSL connection"));
	    mail.addWidget(mail_secure, "mail_secure");
	    mail_secure.changed = changePort;
	    
	    var mail_server = new ox.UI.Input(_("Server Name")); 
	    mail.addWidget(mail_server, "mail_server");
	    var mail_port = new ox.UI.Input(_("Server Port"));
	    mail_port.default_value = "143";
	    mail.addWidget(mail_port, "mail_port");
	    
	    var login = new ox.UI.Input(pgettext("username", "Login"));
	    mail.addWidget(login, "login");
	    var password = new ox.UI.Password(_("Password"));
	    mail.addWidget(password, "password");
	    
	    var pop_refresh_rate = new ox.UI.ComboBox(_("Check for new messages every 'n' minutes"));
	    pop_refresh_rate.width = "5em";	    
	    pop_refresh_rate.setEntries(["3","5","10","15","30","60","360"], ["3","5","10","15","30","60","360"]);
	    pop_refresh_rate.setVisible(false);
	    mail.addWidget(pop_refresh_rate, "pop3_refresh_rate"); 
	    
	    var pop_expunge_on_quit = new ox.UI.CheckBox(_("Leave messages on server"));
	    pop_expunge_on_quit.setVisible(false);
	    pop_expunge_on_quit.changed = function() {
	    	pop_delete_write_through.setEnabled(pop_expunge_on_quit.get());
	    };
	    mail.addWidget(pop_expunge_on_quit, "pop3_expunge_on_quit");
	    
	    var pop_delete_write_through = new ox.UI.CheckBox(_("Deleting messages on local storage also deletes them on server"));
	    pop_delete_write_through.setEnabled(false);
	    mail.addWidget(pop_delete_write_through, "pop3_delete_write_through");
	    
	    mail.addWidget(new lb());
	    
	    /*** TRANSPORT SETTINGS ***/
	    var transport_login, transport_password;
	    var transport = new ox.Configuration.Group(_("Outgoing Server Settings (SMTP)"));
	    split.addWidget(transport, {
            get: ox.Configuration.Group.NoField.get,
            set: function(data) {
                transport.setEnabled(data.id !== 0);
		    	var bool = Boolean(data.transport_credentials);
				transport_login.setEnabled(bool);
				transport_password.setEnabled(bool);
				return data;
            }
        });
	    
	    var transport_secure = new ox.UI.CheckBox("Use SSL connection");
	    transport.addWidget(transport_secure, "transport_secure");
	    transport_secure.changed = function() {
	    	if (transport_secure.get()) transport_port.set("465");
	    	else transport_port.set("25");
	    };
	    
	    transport.addWidget(new ox.UI.Input(_("Server Name")), "transport_server");
	    
	    var transport_port  = new ox.UI.Input(_("Server Port"));
	    transport_port.default_value = "25";
	    transport.addWidget(transport_port, "transport_port");
	    
	    var transport_credentials = new ox.UI.CheckBox(_("Use username and password"));
	    transport.addWidget(transport_credentials, "transport_credentials");
	    transport_credentials.changed = function(bool) {
	    	var bool = transport_credentials.get();
	    	transport_login.setEnabled(bool);
	    	transport_password.setEnabled(bool);
	    	if (bool === false) {
	    		transport_login.set(null);
	    		transport_password.set(null);
	    	}
	    };
	    
	    transport_login = new ox.UI.Input(pgettext("username", "Login"));
		transport.addWidget(transport_login, "transport_login");		
		transport_login.disable();
		
		transport_password = new ox.UI.Password(_("Password"));
		transport.addWidget(transport_password, "transport_password");
		transport_password.disable();
		
		
	    split.addWidget(new lb());
	    
	    /*** FOLDER SETTINGS ***/	    
	    var folder = new ox.Configuration.Group(_("Folder Settings"));
	    split.addWidget(folder, {
            get: ox.Configuration.Group.NoField.get,
            set: function(data) {
                folder.setVisible(Boolean(data.id));
                return data;
            }
        });
	    
	    // helper to find proper root node
	    var getRoot = function () {
	        // get value
	        var val = this.get() || "default0";
            var accountId = getMailAccountIdByFolder(val);
            return "default" + accountId;
	    };
	    
	    var selectionWidth = "30em";
	    var sent_fullname = new temporary.MailFolderSelection(_("Sent folder"), getRoot);
	    sent_fullname.width = selectionWidth;
	    folder.addWidget(sent_fullname, "sent_fullname");
        
        var trash_fullname = new temporary.MailFolderSelection(_("Trash folder"), getRoot);
        trash_fullname.width = selectionWidth;
        folder.addWidget(trash_fullname, "trash_fullname");
        
        var drafts_fullname = new temporary.MailFolderSelection(_("Drafts folder"), getRoot);
        drafts_fullname.width = selectionWidth;
        folder.addWidget(drafts_fullname, "drafts_fullname");
        
        var spam_fullname = new temporary.MailFolderSelection(_("Spam folder"), getRoot);
        spam_fullname.width = selectionWidth;
        folder.addWidget(spam_fullname, "spam_fullname");
	    
        folder.addWidget(new lb());
        
        /*** BUTTONS ***/
	        
	    var buttons = new ox.Configuration.HLayout();
	    
	    var check_button = new ox.UI.Button(_("Check connection"));
	    check_button.click = function () {
            var data = clone(split.get());
            if (checkFields(data)) return;
	        // pending...
	    	newAlert(_("Info"), _("Please wait while checking the connection ... This may take a while ..."));
	    	$(globalalert.visibleButtons[0].id).style.display="none";
	    	if (selection.getSelected().length == 1) {
	    		data.id = selection.getSelected()[0];
	    		if ("password" in data === false 
	    		        || trimStr(data.password).length === 0) {
	    		    delete(data.password);
	    		}
	    	}
	    	data.mail_protocol = mail_protocol.get();
	    	data.transport_protocol = "smtp";
	    	data.tree = false;
	    	
	    	if (data.transport_credentials == true) {
	    		data.transport_auth = "custom";
	    	}

	    	// validate account data
	    	ox.api.account.validate(
	    	    data,
	    	    // success
    			function (reply) {
    				newAlert(_("Info"), reply.data ? _("The connection was successful.") : _("Connection failed! Please check your settings."));
                },
                // error
                function (reply) {
                	newAlert(_("Error"), _("Connection failed! Please check your settings: ") + formatError(reply));
                	return true;
                }
            );
	    };
        buttons.addWidget(check_button);
        split.addWidget(buttons, {
            get: emptyFunction,
            set: function(data) { check_button.setEnabled(data.id !== 0); }
        });
	    
	    var save_button = new ox.UI.Button(_("Save"));
        save_button.click = function() {
            var enabled = mail_protocol.enabled;
            mail_protocol.enable();
            split.saveView();
            mail_protocol.setEnabled(enabled);
        };
	    buttons.addWidget(save_button);
	
	    var cancel_button = new ox.UI.Button(_("Cancel"));
	    split.cancelView = function() {
	        this.isNew = false;
            if (this.afterSave) {
                this.afterSave();
            } else {
                var data = clone(this.original);
                data.id = this.id;
                this.set(data);
            }
	    };
	    cancel_button.click = function() { split.cancelView(); };
	    buttons.addWidget(cancel_button);
	    
	    //split.disable();
	}
});