/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
/*
 * Copyright (C) 2007 MicroDoc GmbH, Munich, Germany
 */

package com.openexchange.usm.util;

import java.util.BitSet;

public class BitSetEncoder {
	private static final byte[] BITS = { 1, 2, 4, 8, 16, 32, 64, -128 };

	public static byte[] toByteArray(BitSet s) {
		int length = s.length();
		byte[] bytes = new byte[(length + 7) >> 3];
		for (int i = 0; i < length; i++) {
			if (s.get(i))
				bytes[i >> 3] |= BITS[i % 8];
		}
		return bytes;
	}

	public static BitSet fromByteArray(byte[] bytes) {
		BitSet set = new BitSet(bytes.length << 3);
		for (int i = 0; i < bytes.length; i++) {
			for (int j = 0; j < BITS.length; j++)
				if ((bytes[i] & BITS[j]) != 0)
					set.set((i << 3) + j);
		}
		return set;
	}

	public static String toBase64(BitSet s) {
		return Toolkit.encodeBase64(toByteArray(s));
	}

	public static BitSet fromBase64(String s) {
		return fromByteArray(Toolkit.decodeBase64(s));
	}
}
