/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.usm.mimemail;

import java.io.IOException;
import java.io.InputStream;
import java.io.PipedOutputStream;
import java.util.concurrent.ExecutorService;
import com.openexchange.usm.api.io.InputStreamProvider;
import com.openexchange.usm.json.USMJSONServlet;
import com.openexchange.usm.util.Toolkit;

/**
 * {@link MailInputStreamProvider}
 *
 * @author <a href="mailto:afe@microdoc.de">Alexander Feess</a>
 * @author <a href="mailto:thorben.betten@open-xchange.com">Thorben Betten</a> Added delegation to thread pool if available & JavaDoc
 */
public class MailInputStreamProvider implements InputStreamProvider {

    final USMMimeMessage _message;

    /**
     * Initializes a new {@link MailInputStreamProvider}.
     *
     * @param message The MIME message
     */
    public MailInputStreamProvider(USMMimeMessage message) {
        _message = message;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        final ExtendedPipedInputStream in = new ExtendedPipedInputStream();
        final PipedOutputStream out = new PipedOutputStream(in);

        final Runnable r = new Runnable() {

            @Override
            public void run() {
                try {
                    _message.writeTo(out);
                } catch (Exception e) {
                    in.setException(e);
                } finally {
                    Toolkit.close(out);
                }
            }
        };

        final ExecutorService executor = USMJSONServlet.getExecutorService();
        if (null == executor) {
            new Thread(r, "USM-StreamingMimeMailBuilder").start();
        } else {
            executor.execute(r);
        }

        return in;
    }

}
