/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.usm.json.response;

/**
 * List of status codes to be returned in the response.  
 * @author ldo
 *
 */
public enum ResponseStatusCode {

	/**
	 * The command was completed successfully 
	 */
	SUCCESS,

	/**
	 * Unexpected Error occurred when accessing the OX server.
	 */
	OX_SERVER_ERROR,

	/**
	 * Unexpected Error occurred when accessing the Database.
	 */
	DATABASE_ERROR,

	/**
	 * Unexpected error in USM.
	 */
	INTERNAL_ERROR,

	/**
	 * Could not login to USM/OX.
	 */
	ACCESS_DENIED,

	/**
	 * The session-id does not exist. 
	 */
	UNKNOWN_SESSION,

	/**
	 * The UUID does not exist. 
	 */
	UNKNOWN_UUID,

	/**
	 * Wrong parameter types or missing parameters in the request. 
	 */
	WRONG_MISSING_PARAMETERS,

	/**
	 * Synchronization failed because of Conflicts. 
	 */
	SYNC_FAILED,

	/**
	 * Bad request. 
	 */
	BAD_REQUEST,

	/**
	 * A SyncID was provided that is not known by the USM. A valid SyncID or a slow sync is required.
	 */
	UNKNOWN_SYNCID,

	/**
	 * During login a version of the USM/JSON-API was requested that is not supported by the USM server
	 */
	UNSUPPORTED_VERSION,

	/**
	 * A specified folder was not found by the USM/OX server. A synchronization of the folder hierarchy
	 * should be performed to get its current structure.
	 */
	FOLDER_NOT_FOUND,

	/**
	 * An element was not found on the server with the specified UID (not to be confused with UUID!)
	 */
	UNKNOWN_UID,
	
	/**
	 * Client time is too old/ too new. 
	 */
	UNALLOWED_CLIENT_TIME,
	
	/**
	 * Server/Resource/Subsystem is temporary down or busy. 
	 */
	TEMPORARY_NOT_AVAILABLE,
	
    /**
     * The command was completed successfully, but objects too large for synchronization were filtered out. Supported since protocol version 1.6.10!
     */
	SUCCESS_FILTERED_OUT_LARGE_OBJECTS;

	public int getStatusCode() {
		return ordinal() + 1;
	}
}
