/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.usm.api.session.assets;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * {@link SessionInformation}
 *
 * @author <a href="mailto:ioannis.chouklis@open-xchange.com">Ioannis Chouklis</a>
 */
public class SessionInformation implements Comparable<SessionInformation> {

    private final int contextID;

    private final int userID;

    private int usmSessionID;

    private final String protocol;

    private final String device;

    private List<String> fieldData;

    /**
     * Initializes a new {@link SessionInformation}.
     * @param cid
     * @param id
     * @param protocol
     * @param device
     * @param usmSessionId
     */
    public SessionInformation(int c, int uid, String p, String d, int usid) {
        contextID = c;
        userID = uid;
        protocol = p;
        device = d;
        usmSessionID = usid;
    }

    /*
     * (non-Javadoc)
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        return "CID: " + contextID + ", User ID: " + userID + ", Protocol: " + protocol + ", Device: " + device + ", usmSessionId: " + usmSessionID;
    }

    /**
     * Add field data
     * @param data
     */
    public void addFieldData(String data) {
        if (fieldData == null)
            fieldData = new ArrayList<String>();
        fieldData.add(data);
    }

    /**
     * Append field data to the given list
     * @param list
     */
    public void appendFieldDataToList(List<String> list) {
        list.add(toString());
        if (fieldData != null) {
            Collections.sort(fieldData);
            list.addAll(fieldData);
        }
    }

    /*
     * (non-Javadoc)
     * @see java.lang.Comparable#compareTo(java.lang.Object)
     */
    @Override
    public int compareTo(SessionInformation o) {
        int rv = contextID - o.contextID;
        if (rv == 0) {
            rv = protocol.compareTo(o.protocol);
            if (rv == 0) {
                rv = userID - o.userID;
                if (rv == 0) {
                    rv = device.compareTo(o.device);
                    if (rv == 0)
                        rv = usmSessionID - o.usmSessionID;
                }
            }
        }
        return rv;
    }

    /*
     * (non-Javadoc)
     * @see java.lang.Object#hashCode()
     */
    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + contextID;
        result = prime * result + ((device == null) ? 0 : device.hashCode());
        result = prime * result + userID;
        result = prime * result + ((protocol == null) ? 0 : protocol.hashCode());
        result = prime * result + usmSessionID;
        return result;
    }

    /*
     * (non-Javadoc)
     * @see java.lang.Object#equals(java.lang.Object)
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (!(obj instanceof SessionInformation))
            return false;
        SessionInformation other = (SessionInformation) obj;
        if (contextID != other.contextID)
            return false;
        if (device == null) {
            if (other.device != null)
                return false;
        } else if (!device.equals(other.device))
            return false;
        if (userID != other.userID)
            return false;
        if (protocol == null) {
            if (other.protocol != null)
                return false;
        } else if (!protocol.equals(other.protocol))
            return false;
        if (usmSessionID != other.usmSessionID)
            return false;
        return true;
    }

    /**
     * Gets the contextID
     *
     * @return The contextID
     */
    public int getContextID() {
        return contextID;
    }
    
    /**
     * Sets the usmSessionID
     * 
     * @param usid
     */
    public void setUSMSessionID(int usid) {
        usmSessionID = usid;
    }

    /**
     * Gets the usmSessionID
     *
     * @return The usmSessionID
     */
    public int getUSMSessionID() {
        return usmSessionID;
    }

    /**
     * Gets the protocol
     *
     * @return The protocol
     */
    public String getProtocol() {
        return protocol;
    }

    /**
     * Gets the device
     *
     * @return The device
     */
    public String getDevice() {
        return device;
    }

    /**
     * Gets the userID
     *
     * @return The userID
     */
    public int getUserID() {
        return userID;
    }
}