/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.usm.api.ox.event;

/**
 * Interface for listeners that get notified of changes on folders or their
 * content.
 * 
 * @author afe
 *
 */
public interface OXEventListener {
	/**
	 * Called when a folder itself has changed for a user (i.e. at least one of the fields of the folder has changed).
	 * If the folderID is specified as null, the folderID could not be determined.
	 * 
	 * @param contextID contextID of the user for which a change is reported
	 * @param userID User ID for which a change is reported
	 * @param parentFolderId parent folderID of the folder that has changed
	 * @param timestamp timestamp of the modification (if not available, 0 is reported)
	 */
	void folderChanged(int contextID, int userID, String parentFolderId, long timestamp);

	/**
	 * Called when for a user the content of a folder has changed (i.e. at least one element in
	 * the folder had some modification).
	 * If the folderID is specified as null, the folderID could not be determined.
	 * 
	 * @param contextID contextID of the user for which a change is reported
	 * @param userID User ID for which a change is reported
	 * @param folderId folderID of the folder in which at least 1 element changed
	 * @param timestamp timestamp of the modification (if not available, 0 is reported)
	 */
	void folderContentChanged(int contextID, int userID, String folderId, long timestamp);
	
	void objectDeleted(int contextID, int objectID, int contentType);
	
	void defaultFoldersChanged(int contextID, int userID);
}
