/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.usm.util;

import java.util.HashSet;
import java.util.Set;

import org.json.JSONException;
import org.json.JSONObject;

public class OXJSONUtil {

    private static final String WARNING_CATEGORY = "13";

    private static final String CATEGORY_FIELD = "category";

    public static final String CATEGORY_RESOURCE_TEMPORARY_DOWN = "4";

    public static final String CATEGORY_SUBSYSTEM_DOWN = "5";

    public static final String CATEGORY_SOCKET_CONNECTION_CORRUPT = "6";

    public static final String CATEGORY_RESOURCE_FULL_OR_BUSY = "11";

    public static final String ERROR_CODE_OBJECT_CHANGED = "FLD-0001";

    public static final String ERROR_CODE_FOLDER_MUST_NOT_BE_DELETED = "FLD-0090";

    public static final String ERROR_FIELD = "error";

    public static final String ERROR_CODE_FIELD = "code";

    public static final String DATA_FIELD = "data";

    public static final String UNKNOWN_ERROR_CODE = "unknown";

    public static final Set<String> _RELOGIN_ERROR_CODES = new HashSet<String>();
    
    private static final Set<String> _OBJECT_MISSING_ERROR_CODES = new HashSet<String>();
    
    

    public static boolean isOXError(JSONObject object) {
        if (!object.has(ERROR_FIELD))
            return false;
        if (!object.has(CATEGORY_FIELD))
            return true;
        if (!WARNING_CATEGORY.equals(getJSONErrorCategory(object)))
            return true;
        return getJSONErrorCode(object).equals(ERROR_CODE_FOLDER_MUST_NOT_BE_DELETED);
    }

    public static String getJSONErrorCode(JSONObject object) {
        if (!object.has(ERROR_FIELD))
            return "";
        try {
            return object.getString(ERROR_CODE_FIELD);
        } catch (JSONException e) {
            return UNKNOWN_ERROR_CODE;
        }
    }

    public static String getJSONErrorCategory(JSONObject object) {
        return object.optString(CATEGORY_FIELD, null);
    }
    
    public static void setReloginErrorCodes(String reloginErrorCodes) {
    	setErrorCodes(reloginErrorCodes,_RELOGIN_ERROR_CODES);
    }
    
    public static void setMissingObjectErrorCodes(String missingObjectErrorCodes) {
    	setErrorCodes(missingObjectErrorCodes,_OBJECT_MISSING_ERROR_CODES);
    }

    private static void setErrorCodes(String errorCodesString, Set<String> errorCodesCollection) {
    	errorCodesCollection.clear();
        for (String s : errorCodesString.split(",")) {
            String code = s.trim();
            if (code.length() > 0)
            	errorCodesCollection.add(code);
        }
    }
    
    public static boolean isMissingObjectErrorCode(JSONObject oxError) {
        return _OBJECT_MISSING_ERROR_CODES.contains(getJSONErrorCode(oxError));
    }
    
    public static boolean isReloginErrorCode(JSONObject oxError) {
        return  _RELOGIN_ERROR_CODES.contains(OXJSONUtil.getJSONErrorCode(oxError));
    }

}
