/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.usm.connector.commands;

import static com.openexchange.usm.connector.commands.CommandConstants.SESSIONID;
import static com.openexchange.usm.connector.commands.CommandConstants.TEMPID;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import com.openexchange.usm.json.ConnectorBundleErrorCodes;
import com.openexchange.usm.json.USMJSONAPIException;
import com.openexchange.usm.json.USMJSONServlet;
import com.openexchange.usm.json.USMJSONVersion;
import com.openexchange.usm.json.response.ResponseObject;
import com.openexchange.usm.json.response.ResponseStatusCode;
import com.openexchange.usm.util.TempFileStorage;

/**
 * {@link ClearDataHandler} Allows the client to explicitly remove 1 or all previously created (with uploadData) temporary data files
 * 
 * @author <a href="mailto:afe@microdoc.de">Alexander Feess</a>
 */
public class ClearDataHandler extends NormalCommandHandler {

    private static final String[] REQUIRED_PARAMETERS = { SESSIONID };

    private static final String[] OPTIONAL_PARAMETERS = { TEMPID };

    public ClearDataHandler(USMJSONServlet servlet, HttpServletRequest request) throws USMJSONAPIException {
        super(servlet, request);
        USMJSONVersion.verifyProtocolVersion(_session, USMJSONVersion.SUPPORTS_ATTACHMENT_STREAMING);
    }

    @Override
    public ResponseObject handleRequest() throws USMJSONAPIException {
        String tempid = getStringParameter(TEMPID, null);
        try {
            if (tempid != null)
                TempFileStorage.deleteTempFile(_session, tempid);
            // no else case
            // bug fix 36718: commands which may run in parallel shall not delete all files!
                
            return new ResponseObject(ResponseStatusCode.SUCCESS);
        } catch (IOException e) {
            throw new USMJSONAPIException(
                ConnectorBundleErrorCodes.COMMAND_CLEAR_DATA_IO_ERROR_ON_DELETING_TEMP_FILE,
                ResponseStatusCode.OX_SERVER_ERROR,
                "I/O error deleting tempfile '" + tempid + '\'',
                e);
        }
    }

    /*
     * (non-Javadoc)
     * @see com.openexchange.usm.connector.commands.BaseCommandHandler#getRequiredParameters()
     */
    @Override
    protected String[] getRequiredParameters() {
        return REQUIRED_PARAMETERS;
    }

    /*
     * (non-Javadoc)
     * @see com.openexchange.usm.connector.commands.BaseCommandHandler#getOptionalParameters()
     */
    @Override
    protected String[] getOptionalParameters() {
        return OPTIONAL_PARAMETERS;
    }
}
