/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.usm.api.session.assets;

import java.io.Serializable;
import java.util.UUID;

/**
 * Holds the fields that identify an USM Object. 
 * @author ldo
 *
 */
public class OXObjectID implements Serializable, Comparable<OXObjectID> {

	public static OXObjectID fromSimplifiedUUID(UUID uuid) {
		if (uuid == null)
			return null;
		return new OXObjectID((int) (uuid.getMostSignificantBits() & 0xFFFFFFFFL), (int) (uuid
				.getLeastSignificantBits() >> 32), (int) (uuid.getLeastSignificantBits() & 0xFFFFFFFFL));
	}

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private final int _cid;
	private final int _contentType;
	private final int _objectId;

	public OXObjectID(int cid, int contentType, int objectId) {
		_cid = cid;
		_contentType = contentType;
		_objectId = objectId;
	}

	public int getCid() {
		return _cid;
	}

	public int getObjectId() {
		return _objectId;
	}

	public int getContentType() {
		return _contentType;
	}

	@Override
    public int compareTo(OXObjectID o) {
		int result = _cid == o._cid ? 0 : 1;
		if (result == 0) {
			result = _objectId == o._objectId ? 0 : 1;
			if (result == 0) {
				result = _contentType == o._contentType ? 0 : 1;
			}
		}
		return result;
	}

	@Override
	public String toString() {
		return "(cid: " + _cid + ", type: " + _contentType + ", id: " + _objectId + ')';
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + _cid;
		result = prime * result + _objectId;
		result = prime * result + _contentType;
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (!(obj instanceof OXObjectID))
			return false;
		OXObjectID other = (OXObjectID) obj;

		if (_cid != other._cid)
			return false;

		if (_objectId != other._objectId)
			return false;

		if (_contentType != other._contentType)
			return false;

		return true;
	}

	public UUID convertToSimplifiedUUID() {
		return new UUID(_cid, (((long) _contentType) << 32L) | (_objectId));
	}
}
