/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.usm.api.exceptions;

import com.openexchange.usm.api.session.DataObject;

/**
 * Helper class used by SynchronizationConflictException to report conflicting changes between client and server.
 * Note that the server change may not always be available (will be set to null) if the conflict was detected by
 * a low level method (i.e. an error was reported by OX) and couldn't be mapped by a higher level method (e.g. if
 * no cached or current server information is available). The server change will also not be available on failed
 * creations.
 * 
 * @author afe
 *
 */
public class ConflictingChange {
	private final DataObject _clientChange;
	private final DataObject _serverChange;

	public ConflictingChange(DataObject clientChange, DataObject serverChange) {
		_clientChange = clientChange;
		_serverChange = serverChange;
	}

	public DataObject getClientChange() {
		return _clientChange;
	}

	public DataObject getServerChange() {
		return _serverChange;
	}

	@Override
	public String toString() {
		return _clientChange + "<=>" + _serverChange;
	}
}
