package com.openexchange.office.tools.resource;

import com.openexchange.office.tools.files.DocFileHelper;


public class ResourceHelper {

    public static String getResourceName(final DocFileHelper fileHelper, long uid, final String newExt) throws Exception {
        String resourceName = null;

        switch (fileHelper.getDocumentFormat()) {
        case DOCX: {
            resourceName = "word/media/uid" + Long.toHexString(uid) + "." + newExt;
            break;
        }
        case PPTX: {
            resourceName = "ppt/media/uid" + Long.toHexString(uid) + "." + newExt;
            break;
        }
        case XLSX: {
            resourceName = "xl/media/uid" + Long.toHexString(uid) + "." + newExt;
            break;
        }
        case ODT: {
            resourceName = "Pictures/uid" + Long.toHexString(uid) + "." + newExt;
            break;
        }
        case ODS: {
            resourceName = "Pictures/uid" + Long.toHexString(uid) + "." + newExt;
            break;
        }

        case NONE:
        case ODG:
        case ODP:
        default: {
            break;
        }
        }

        return resourceName;
    }
}
