package com.openexchange.office.tools.htmldoc;

import org.apache.commons.lang.StringEscapeUtils;
import org.json.JSONObject;

public class ComplexField
        extends SubNode
{

    private static final String FIELDSTART = "<div contenteditable=\"false\" class=\"inline complexfield\" ";
    private static final String FIELDCLOSER = "\" ";
    private static final String FIELDID = "data-field-id=\"";
    private static final String FIELDINSTRUCTION = "data-field-instruction=\"";
    private static final String FIELDEND = "></div>";

    private String              id;
    private String              instruction;

    // ///////////////////////////////////////////////////////////

    public ComplexField(
            int logicalPosition, String id, String instruction)
    {
        super(logicalPosition, 1);

        this.id = id;
        this.instruction = instruction;
    }

    @Override
    public boolean appendContent(
        StringBuilder document)
        throws Exception
    {
        document.append(FIELDSTART);
        document.append(FIELDID + this.id + FIELDCLOSER);
        document.append(FIELDINSTRUCTION + StringEscapeUtils.escapeHtml(this.instruction) + FIELDCLOSER);

        
        JSONObject params = new JSONObject();
        params.put("fieldId", id);
        params.put("fieldInstructions", instruction);

        document.append(" jquerydata='");
        document.append(params.toString());
        document.append("'");
        
        document.append(FIELDEND);

        return true;
    }

    @Override
    public boolean needsEmptySpan()
    {
        return true;
    }

    @Override
    public String toString()
    {
        return "ComplexField";
    }

}
