package com.openexchange.office.tools.htmldoc;

import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.json.JSONObject;

public class Comment
        extends NodeHolder
{
    private static final String  COMMENT_THREADOPEN  = "<div class='commentthread";
    private static final String  COMMENT_THREADCLOSE = "'>";
    private static final String  COMMENT_START       = "<div contenteditable='true' class='drawing comment'";
    private static final String  COMMENT_METAINFO    = "<div class='commentmetainfo'>";
    private static final String  COMMENT_PICTURE     = "<div class='commentpicture'></div>";
    private static final String  COMMENT_AUTHOR_DATE = "<div class='commentauthordate'>";
    private static final String  COMMENT_AUTHOR_START = "<a class='commentauthor'>";
    private static final String  COMMENT_AUTHOR_END  = "</a>";
    private static final String  COMMENT_DATE        = "<div class='commentdate'></div>";
    private static final String  COMMENT_BUTTON      = "<div class='commentbutton'>";
    private static final String  COMMENT_METAINFO_CLOSER = "<a class='reply commentreply' tabindex='1'><i class='fa fa-reply' aria-hidden='true'></i></a><a class='closer commentcloser' tabindex='1'><i class='fa fa-trash-o' aria-hidden='true'></i></a></div></div>";
    private static final String  CONTENT_START       = "<div class='content textframecontent autoresizeheight'>";
    private static final String  COMMENT_BOTTOM      = "<div class='commentbottom'><a class='shrinkarrow' tabindex='1'><i class='fa fa-sort-desc' aria-hidden='true'></i></a></div>";
    private static final String  TEXTFRAME_START     = "<div class='textframe' contenteditable='true'>";

    private final String id;
    private final String author;
    private final String uid;
    private final String date;
    private final String target;

    public Comment(
            String id, String author, String uid, String date, String target)
    {
        this.id = id;
        this.author = author;
        this.uid = uid;
        this.date = date;
        this.target = target;
    }

    @Override
    public boolean needsEmptySpan()
    {
        return false;
    }

    @Override
    public boolean appendContent(
        StringBuilder document)
        throws Exception

    {
    	// appending the comment thread node
    	document.append(COMMENT_THREADOPEN);
    	if (!this.target.isEmpty()) { document.append(" targetcomment"); }
    	document.append(COMMENT_THREADCLOSE);

    	// appending the comment node
        document.append(COMMENT_START);
        document.append("data-container-id=" + StringEscapeUtils.escapeHtml(this.id) + " data-container-author='" + StringEscapeUtils.escapeHtml(this.author) + "'");
        if (StringUtils.isNotEmpty(this.uid)) { 
            document.append(" data-container-uid=" + StringEscapeUtils.escapeHtml(this.uid));
        }
        document.append(" data-container-date=" + StringEscapeUtils.escapeHtml(this.date));

        JSONObject params = new JSONObject();
        params.put("containerId", id);
        params.put("containerAuthor", author);
        if (StringUtils.isNotEmpty(this.uid)) {
            params.put("containerUid", uid);
        }
        params.put("containerDate", date);
        params.put("type", "comment");
        params.put("model", "null");

        document.append(" jquerydata='");
        document.append(params.toString());
        document.append("'>");

        // the meta info div element (open and close)
        document.append(COMMENT_METAINFO);
        document.append(COMMENT_PICTURE);
        document.append(COMMENT_AUTHOR_DATE);
        document.append(COMMENT_AUTHOR_START + StringEscapeUtils.escapeHtml(this.author) + COMMENT_AUTHOR_END);
        document.append(COMMENT_DATE);
        document.append("</div>"); // the common author-date node
        document.append(COMMENT_BUTTON);
        document.append(COMMENT_METAINFO_CLOSER);

        // the content node
        document.append(CONTENT_START);

        // the text frame node
        document.append(TEXTFRAME_START);

        super.appendContent(document);

        document.append("</div>"); // the text frame node
        document.append("</div>"); // the content node

        document.append(COMMENT_BOTTOM);

        document.append("</div>"); // the comment node
        document.append("</div>"); // the comment thread node

        return true;
    }

}
