package com.openexchange.office.realtime.doc;

import com.openexchange.exception.OXException;
import com.openexchange.log.Log;
import com.openexchange.office.hazelcast.doc.DocumentDirectory;
import com.openexchange.office.tools.directory.DocResourceID;
import com.openexchange.office.tools.directory.DocumentState;


public class DocumentStateHelper {

    @SuppressWarnings("deprecation")
    static private final org.apache.commons.logging.Log LOG = Log.loggerFor(DocumentStateHelper.class);

    public static void updateSaveState(final DocumentDirectory globalDocDir, final String contextId, final String docId, boolean saveState) {
        // set global save state to prevent a second access via a new rt group dispatcher instance
        try {
            if (null != globalDocDir) {
                final DocResourceID docResId = DocResourceID.createDocResourceID(contextId, docId);
                DocumentState docState = globalDocDir.get(docResId);
                if (null != docState) {
                    docState.setSaveInProgress(saveState);
                } else {
                    docState = new DocumentState(docResId, null, saveState);
                }
                globalDocDir.set(docResId, docState);
            } else {
                LOG.warn("RT connection: Failed to find hazelcast based document state directory");
            }
        } catch (OXException e) {
            LOG.error("RT connection: Failed to set global save state for document context " + docId, e);
        }
    }

}
