/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.ooxml.drawingml;

import org.docx4j.dml.CTGroupShapeProperties;
import org.docx4j.dml.CTGroupTransform2D;
import org.docx4j.dml.CTPoint2D;
import org.docx4j.dml.CTPositiveSize2D;
import org.docx4j.dml.IGroupShape;
import org.docx4j.jaxb.Context;
import org.json.JSONException;
import org.json.JSONObject;

import com.openexchange.office.ooxml.OperationDocument;

public class GroupShape {

	public static void applyAttrsFromJSON(OperationDocument operationDocument, JSONObject attrs, IGroupShape group)
		throws JSONException {

        DMLHelper.applyNonVisualDrawingProperties(group, attrs.optJSONObject("drawing"));
	    CTGroupShapeProperties groupProperties = group.getGrpSpPr();
		if(groupProperties==null) {
			groupProperties = Context.getDmlObjectFactory().createCTGroupShapeProperties();
			group.setGrpSpPr(groupProperties);
		}
		CTGroupTransform2D groupTransform2d = groupProperties.getXfrm();
		if(groupTransform2d==null) {
		    groupTransform2d = Context.getDmlObjectFactory().createCTGroupTransform2D();
		    groupProperties.setXfrm(groupTransform2d);
		}
		DMLHelper.applyTransform2DFromJson(groupTransform2d, attrs);
		// now applying the size and pos of the childs
		final CTPoint2D chPos = Context.getDmlObjectFactory().createCTPoint2D();
		chPos.setX(0);
		chPos.setY(0);
		groupTransform2d.setChOff(chPos);
		final CTPositiveSize2D ex = groupTransform2d.getExt();
		if(ex!=null) {
		    final CTPositiveSize2D chEx = Context.getDmlObjectFactory().createCTPositiveSize2D();
		    chEx.setCx(ex.getCx());
		    chEx.setCy(ex.getCy());
		    groupTransform2d.setChExt(chEx);
		}
		DMLHelper.applyFillPropertiesFromJson(groupProperties, attrs);
	}

    public static void createJSONAttrs(OperationDocument operationDocument, JSONObject attrs, IGroupShape groupShape)
    	throws JSONException {

        DMLHelper.createJsonFromNonVisualDrawingProperties(attrs, groupShape.getCNvPr());
        final CTGroupShapeProperties groupProperties = groupShape.getGrpSpPr();
		if(groupProperties!=null) {
	        final CTGroupTransform2D groupTransform =groupProperties.getXfrm();
	        if(groupTransform!=null) {
	        	DMLHelper.createJsonFromTransform2D(attrs, groupTransform);
	        }
		}
    }
}
