/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.ods.dom;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map.Entry;

import org.apache.xerces.dom.ElementNSImpl;
import org.apache.xml.serializer.SerializationHandler;
import org.odftoolkit.odfdom.IElementWriter;
import org.odftoolkit.odfdom.dom.element.table.TableDatabaseRangesElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.w3c.dom.DOMException;
import org.xml.sax.SAXException;

@SuppressWarnings("serial")
public class DatabaseRanges extends ElementNSImpl implements IElementWriter {

	private final HashMap<String, DatabaseRange> databaseRangeList = new HashMap<String, DatabaseRange>();

	public DatabaseRanges(OdfFileDom ownerDocument)
		throws DOMException {
		super(ownerDocument, TableDatabaseRangesElement.ELEMENT_NAME.getUri(), TableDatabaseRangesElement.ELEMENT_NAME.getQName());
	}

	public HashMap<String, DatabaseRange> getDatabaseRangeList() {
		return databaseRangeList;
	}

	public DatabaseRange getDatabaseRange(Content content, int sheetIndex, String name, boolean forceCreate) {
		if(name==null||name.isEmpty()) {
			return getAnonymousRange(content, sheetIndex, forceCreate);
		}
		DatabaseRange databaseRange = databaseRangeList.get(name);
		if(databaseRange==null&&forceCreate) {
			databaseRange = new DatabaseRange(name);
			databaseRangeList.put(name, databaseRange);
		}
		return databaseRange;
	}

	public void deleteTable(Content content, int sheetIndex, String name) {
		final DatabaseRange databaseRange = getDatabaseRange(content, sheetIndex, name, false);
		if(databaseRange!=null) {
			final Iterator<Entry<String, DatabaseRange>> databaseRangeIter = databaseRangeList.entrySet().iterator();
			while(databaseRangeIter.hasNext()) {
				final Entry<String, DatabaseRange> databaseEntry = databaseRangeIter.next();
				if(databaseEntry.getValue().equals(databaseRange)) {
					databaseRangeIter.remove();
					break;
				}
			}
		}
	}

	private DatabaseRange getAnonymousRange(Content content, int sheetIndex, boolean forceCreate) {
		final Iterator<DatabaseRange> databaseRangeIter = databaseRangeList.values().iterator();
		while(databaseRangeIter.hasNext()) {
			final DatabaseRange databaseRange = databaseRangeIter.next();
			if(databaseRange.getName().startsWith("__Anonymous_Sheet_DB__")) {
				if(databaseRange.getRange().getSheetIndex()==sheetIndex) {
					return databaseRange;
				}
			}
		}
		if(forceCreate) {
			// search for the first unused Anonymous entry
			int count = 0;
			DatabaseRange databaseRange = null;
			String name;
			do {
				name = "__Anonymous_Sheet_DB__" + Integer.toString(count++);
				databaseRange = databaseRangeList.get(name);
			}
			while(databaseRange!=null);

			databaseRange = new DatabaseRange(name);
			databaseRangeList.put(name, databaseRange);
			return databaseRange;
		}
		return null;
	}

	@Override
	public void writeObject(SerializationHandler output) {
		try {
			if(!databaseRangeList.isEmpty()) {
				output.startElement(getNamespaceURI(), getLocalName(), getNodeName());
				SaxContextHandler.addAttributes(output, getAttributes(), null);
				final Iterator<Entry<String, DatabaseRange>> databaseRangeIter = databaseRangeList.entrySet().iterator();
				while(databaseRangeIter.hasNext()) {
					databaseRangeIter.next().getValue().writeObject(output, (Content)this.getOwnerDocument());
				}
				output.endElement(getNamespaceURI(), getLocalName(), getNodeName());
			}
		} catch (SAXException e) {

		}
	}
}
