﻿
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"

	xmlns:java="http://xml.apache.org/xalan/java"
	xmlns:mc="http://schemas.openxmlformats.org/markup-compatibility/2006"
	
	xmlns:w="http://schemas.openxmlformats.org/wordprocessingml/2006/main"
	
	xmlns:wordml2010="http://schemas.microsoft.com/office/word/2010/wordml"
	xmlns:wordml201011="http://schemas.microsoft.com/office/word/2010/11/wordml"

    xmlns:o="urn:schemas-microsoft-com:office:office"

	version="1.0" exclude-result-prefixes="java">	
        
<!--  This is a mc:AlternateContent pre-processor.
      It selects the mc:Fallback content, which 
      docx4j 2.7.0 ought to be able to handle.  
      
      See MainDocumentPart's unmarshall method 
      for an example of how it is invoked. -->


<xsl:output method="xml" encoding="utf-8" omit-xml-declaration="no" indent="yes" />

  <xsl:template match="/ | @*|node()">
    <xsl:copy>
      <xsl:apply-templates select="@*|node()"/>
    </xsl:copy>
  </xsl:template>

  <xsl:template match="mc:AlternateContent">
	<xsl:variable name="dummy" 
		select="java:org.docx4j.utils.XSLTUtils.logWarn('Found some mc:AlternateContent')" />
    <xsl:choose>
        <!-- we want to remain mc:AlternateContent (wpg, wps and wpc) unchanged only within w:r-->
        <xsl:when test="parent::w:r and (mc:Choice[@Requires = 'wpg'] or mc:Choice[@Requires = 'wps'] or mc:Choice[@Requires = 'wpc'])">
            <xsl:copy>
                <xsl:apply-templates select="@*|node()"/>
            </xsl:copy>
        </xsl:when>
        <xsl:otherwise>
		  	<xsl:choose>
		  		<xsl:when test="mc:Fallback">
		  			<xsl:variable name="message" 
		  				select="concat('Selecting ', name(mc:Fallback/*[1]) )" />  			
					<xsl:variable name="logging" 
						select="java:org.docx4j.utils.XSLTUtils.logWarn($message)" />
		  			<xsl:copy-of select="mc:Fallback/*"/>
		  		</xsl:when>
		  		<xsl:otherwise> 
					<xsl:variable name="logging" 
						select="java:org.docx4j.utils.XSLTUtils.logWarn('Missing mc:Fallback!  Dropping the mc:AlternateContent entirely.')" />
		  		</xsl:otherwise>  		
		  	</xsl:choose>
	   </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <!--  Most JAXB implementations don't signal additional attributes as errors. -->
  <xsl:template match="@wordml2010:*" />  
  <xsl:template match="@wordml201011:*" />  

  <!-- Fix for the vml shape type which has to be integer -->
  <xsl:template match="@o:spt">
      <xsl:attribute name="o:spt"><xsl:value-of select="format-number(., '#')" /></xsl:attribute>
  </xsl:template>

  <!-- Fix for the gridCol which has to be integer -->
  <xsl:template match="w:gridCol/@w:w">
      <xsl:attribute name="w:w"><xsl:value-of select="round(.)" /></xsl:attribute>
  </xsl:template>
  
  
  <!-- Workaround for Google Docs as at 20140225 <w:tblW w:w="10206.0" w:type="dxa"/> 
       See http://www.docx4java.org/forums/docx-java-f6/problem-with-document-created-by-google-docs-t1802.html
       Google Docs make the same error in many places..  -->
  
  <xsl:template match="@w:w" >
  	  <xsl:choose>
  	  	<!--  limit fix to dxa case -->
  		<xsl:when test="../@w:type='dxa'">
		  	<xsl:attribute name="w:w"><xsl:value-of select="format-number(., '#')" /></xsl:attribute>
  		</xsl:when>
  		<xsl:otherwise>
		    <xsl:copy-of select="."/>
  		</xsl:otherwise>
  	</xsl:choose> 
  	
  </xsl:template> 
</xsl:stylesheet>
