/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.office.calcengine.client;

import org.apache.commons.lang.StringUtils;

//=============================================================================
public enum ECalcEngineMode
{
    //-------------------------------------------------------------------------
    E_NATIVE,

    //-------------------------------------------------------------------------
    E_INLINE,

    //-------------------------------------------------------------------------
    E_LOCAL,

    //-------------------------------------------------------------------------
    E_HTTP,

    //-------------------------------------------------------------------------
    E_HTTP_CLIENT,

    //-------------------------------------------------------------------------
    E_HTTP_CLIENT_SIMPLE,

    //-------------------------------------------------------------------------
    E_HTTP_SERVER,

    //-------------------------------------------------------------------------
    E_JMS,

    //-------------------------------------------------------------------------
    E_JMS_CLIENT,

    //-------------------------------------------------------------------------
    E_JMS_SERVER,

    //-------------------------------------------------------------------------
    E_SIMULATOR;
    
    //-------------------------------------------------------------------------
    @Deprecated
    public static final String STR_MODE_EMBEDDED           = "embedded"          ;
    public static final String STR_MODE_INLINE             = "inline"            ;
    public static final String STR_MODE_NATIVE             = "native"            ;
    public static final String STR_MODE_LOCAL              = "local"             ;
    @Deprecated
    public static final String STR_MODE_REMOTE             = "remote"            ;
    public static final String STR_MODE_HTTP               = "http"              ;
    public static final String STR_MODE_HTTP_CLIENT        = "http-client"       ;
    public static final String STR_MODE_HTTP_CLIENT_SIMPLE = "http-client-simple";
    public static final String STR_MODE_HTTP_SERVER        = "http-server"       ;
    public static final String STR_MODE_JMS                = "jms"               ;
    public static final String STR_MODE_JMS_CLIENT         = "jms-client"        ;
    public static final String STR_MODE_JMS_SERVER         = "jms-server"        ;
    public static final String STR_MODE_SIMULATOR          = "simulator"         ;
    
    //-------------------------------------------------------------------------
    public static ECalcEngineMode fromString (final String          sMode    ,
    		                                  final ECalcEngineMode eFallback)
        throws Exception
    {
    	if (StringUtils.equalsIgnoreCase(sMode, STR_MODE_EMBEDDED))
    		return ECalcEngineMode.E_INLINE;

       	if (StringUtils.equalsIgnoreCase(sMode, STR_MODE_NATIVE))
    		return ECalcEngineMode.E_NATIVE;

       	if (StringUtils.equalsIgnoreCase(sMode, STR_MODE_INLINE))
    		return ECalcEngineMode.E_INLINE;

    	if (StringUtils.equalsIgnoreCase(sMode, STR_MODE_LOCAL))
    		return ECalcEngineMode.E_LOCAL;

    	if (StringUtils.equalsIgnoreCase(sMode, STR_MODE_REMOTE))
    		return ECalcEngineMode.E_HTTP;
    	
    	if (StringUtils.equalsIgnoreCase(sMode, STR_MODE_HTTP))
    		return ECalcEngineMode.E_HTTP;

    	if (StringUtils.equalsIgnoreCase(sMode, STR_MODE_HTTP_CLIENT))
    		return ECalcEngineMode.E_HTTP_CLIENT;

    	if (StringUtils.equalsIgnoreCase(sMode, STR_MODE_HTTP_CLIENT_SIMPLE))
    		return ECalcEngineMode.E_HTTP_CLIENT_SIMPLE;

    	if (StringUtils.equalsIgnoreCase(sMode, STR_MODE_HTTP_SERVER))
    		return ECalcEngineMode.E_HTTP_SERVER;

    	if (StringUtils.equalsIgnoreCase(sMode, STR_MODE_JMS))
    		return ECalcEngineMode.E_JMS;

    	if (StringUtils.equalsIgnoreCase(sMode, STR_MODE_JMS_CLIENT))
    		return ECalcEngineMode.E_JMS_CLIENT;

    	if (StringUtils.equalsIgnoreCase(sMode, STR_MODE_JMS_SERVER))
    		return ECalcEngineMode.E_JMS_SERVER;

    	if (StringUtils.equalsIgnoreCase(sMode, STR_MODE_SIMULATOR))
    		return ECalcEngineMode.E_SIMULATOR;
    	
		return eFallback;
    }
}
