package com.openexchange.office.tools.htmldoc;

public class HardBreak
        extends SubNode
{

    private String textContent           = "<br>";
    private String type                  = "textWrapping";
    private String before                = "";
    private String after                 = "";
    private String hardBreakSpanTypePage = "";

    // ///////////////////////////////////////////////////////////

    public HardBreak(
            int position, String type)
    {
        super(position, 1);
        if ((type != null) && (!type.isEmpty()))
        {
            this.type = type;
        }
        if (this.type.equalsIgnoreCase("page") || this.type.equalsIgnoreCase("column"))
        {
            this.textContent = " ";
            this.hardBreakSpanTypePage = "class='ms-hardbreak-page'";
        }
        this.before = "<div contenteditable='false' class='inline hardbreak' jquerydata=\"{&quot;type&quot;:&quot;" + this.type + "&quot;}\"><span ";
        this.after = " " + this.hardBreakSpanTypePage + ">" + this.textContent + "</span></div>";
    }

    @Override
    public boolean appendContent(
        StringBuilder document)
        throws Exception
    {
        document.append(this.before);
        GenDocHelper.appendAttributes(getAttribute(), document);
        document.append(this.after);
        return true;
    }

    @Override
    public boolean needsEmptySpan()
    {
        return true;
    }

    @Override
    public boolean hasManualPageBreak()
    {
        if (this.type.equalsIgnoreCase("page"))
        {
            return true;
        }
        return super.hasManualPageBreak();
    }

    public String getType()
    {
        return type;
    }
}
