package com.openexchange.office.tools.htmldoc;

import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GenDocHelper
{
    private final static String EMPTYSPAN = "<span nonjquerydata=\"{&quot;isempty&quot;:true}\" \"style=\"font-family: Arial, Helvetica, sans-serif; font-weight: normal; font-style: normal; text-decoration: none; color: rgb(0, 0, 0); font-size: 11pt; vertical-align: baseline; line-height: 20px; background-color: transparent;\"></span>";

    static JSONArray shiftedCopy(
        JSONArray input)
    {
        final List<Object> list = input.asList();
        list.remove(0);
        return new JSONArray(list);
    }

    public static void appendAttributes(
        JSONObject attrs,
        StringBuilder document)
        throws JSONException
    {

        appendAttributes(attrs, document, false);

    }

    public static JSONObject getJQueryData(
        JSONObject attrs)
        throws JSONException
    {
        return getJQueryData(attrs, false);
    }

    public static void appendAttributes(
        JSONObject attrs,
        StringBuilder document,
        boolean implicit)
        throws JSONException
    {
        final JSONObject adapter = getJQueryData(attrs, implicit);
        appendJQueryData(document, adapter);
    }

    public static void appendJQueryData(
        StringBuilder document,
        JSONObject jquerydata)
        throws JSONException
    {

        if (jquerydata.length() > 0)
        {
            document.append(" jquerydata='");
            String str = StringEscapeUtils.escapeHtml(jquerydata.toString());
            str = str.replace("'", "&#39;"); // escaping all single quotes (49847)
            document.append(str);
            document.append("' ");
        }
    }

    public static JSONObject getJQueryData(
        JSONObject attrs,
        boolean implicit)
        throws JSONException
    {
        final JSONObject adapter = new JSONObject();
        if (attrs != null)
        {
            adapter.put("attributes", attrs);
        }
        if (implicit)
        {
            adapter.put("implicit", true);
        }
        return adapter;
    }

    public static boolean addEmptySpanForNecessaryNode(
        StringBuilder doc,
        INode node,
        boolean emptySpanNeeded)
    {
        boolean nodeTypeNeedsEmptySpan = node.needsEmptySpan();

        if (nodeTypeNeedsEmptySpan && emptySpanNeeded)
        {
            doc.append(EMPTYSPAN);
        }

        return nodeTypeNeedsEmptySpan;
    }

    public static void addEmptySpan(
        StringBuilder doc)
    {
        doc.append(EMPTYSPAN);
    }

    public static final String escapeSingleQuote(final String text) {
        return text.replaceAll("'","&#39");
    }
}
