package com.openexchange.office.realtime.debug;

import java.util.HashMap;


public class SaveDebugProperties {

    public final static String DEBUG_PROP_SLOWSAVE = "debugSlowSave";
    public final static String DEBUG_PROP_SLOWSAVETIME = "debugSlowSaveTime";
    public final static String DEBUG_PROP_SLOWSAVEUSER = "debugSlowSaveUser";

    private final HashMap<String, Object> m_debugProperties = new HashMap<String, Object>();

    public SaveDebugProperties() {

    }

    public boolean slowSave(boolean defValue) {
        Object value = m_debugProperties.get(DEBUG_PROP_SLOWSAVE);
        return (value instanceof Boolean) ? (Boolean)value : defValue;
    }

    public int slowSaveTime(int defValue) {
        Object value = m_debugProperties.get(DEBUG_PROP_SLOWSAVETIME);
        return (value instanceof Integer) ? (Integer)value : defValue;
    }

    public boolean slowSaveUser(boolean defValue) {
        Object value = m_debugProperties.get(DEBUG_PROP_SLOWSAVEUSER);
        return (value instanceof Boolean) ? (Boolean)value : defValue;
    }

    public void setProperty(final String prop, Object value) {
        m_debugProperties.put(prop, value);
    }
}
