package com.openexchange.presenter.impl;

import com.openexchange.realtime.packet.ID;

/**
 * Helper class to extract or get information from a real-time stanza ID.
 *
 * {@link IDUtils}
 *
 * @author <a href="mailto:carsten.driesner@open-xchange.com">Carsten Driesner</a>
 * @since v7.6.0
 */
public class IDUtils {

    /**
     * Tries to get the user id from a real-time id string.
     *
     * @param id
     *  The real-time ID as string where we want to retrieve the user id.
     *
     * @return
     *  The user id or -1 if the id could not be determined.
     *
     * @throws Exception
     */
    public static int getUserIdFromRealTimeId(final String id) throws Exception {
        return getUserIdFromRealTimeId(new ID(id));
    }

    /**
     * Tries to get the user id from a real-time id.
     *
     * @param id
     *  The real-time ID where we want to retrieve the user id.
     *
     * @return
     *  The user id or -1 if the id could not be determined.
     *
     * @throws Exception
     */
    public static int getUserIdFromRealTimeId(final ID id) throws Exception {
        int result = -1;

        // try to get user id from session from ID
        if (null != id) {
            result = SessionUtils.getUserId(id.toSession());
        }

        return result;
    }
}
