package com.openexchange.office.ooxml.drawingml;

import org.docx4j.dml.Theme;
import org.docx4j.dml.chart.CTChartSpace;
import org.docx4j.dml.chart.CTPlotArea;
import org.docx4j.dml.chartStyle2012.CTChartStyle;
import org.docx4j.dml.chartStyle2012.CTColorStyle;
import org.docx4j.openpackaging.parts.DrawingML.Chart;

import com.openexchange.office.FilterException;
import com.openexchange.office.ooxml.OperationDocument;

public class ChartWrapper
{
    private final Chart chart;
    private final OperationDocument operationDocument;

    public ChartWrapper(
            Chart chart, OperationDocument operationDocument)
    {
        if (chart == null) {
            throw new RuntimeException("chart cant be null");
        }
        if (operationDocument == null) {
            throw new RuntimeException("operationDocument cant be null");
        }

        this.chart = chart;
        this.operationDocument = operationDocument;
    }

    public CTChartStyle getChartStyle()
    {
        CTChartStyle result = chart.getChartStyle();
        if (result == null)
        {
            /*final CTChartSpace chartSpace = getChartSpace();*/
            result = ChartStyleDefaults.get(/*chartSpace.getStyle().getVal()*/);
        }
        return result;
    }

    public CTColorStyle getChartColorStyle()
    {
        return chart.getChartColorStyle();
    }

    public CTChartSpace getChartSpace()
    {
        return chart.getContents();
    }

    public Theme getTheme()
        throws FilterException
    {
        return operationDocument.getTheme();
    }

    public CTPlotArea getPlotArea()
    {
        return getChartSpace().getChart().getPlotArea();
    }
}
